-- MySQL dump 10.13  Distrib 5.7.36, for Linux (x86_64)
--
-- Host: localhost    Database: amazonte_db
-- ------------------------------------------------------
-- Server version	5.7.36

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accessories`
--

DROP TABLE IF EXISTS `accessories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accessories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_field_name` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `accessories_category_field_name_unique` (`category_field_name`),
  KEY `accessories_category_id_foreign` (`category_id`),
  CONSTRAINT `accessories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accessories`
--

LOCK TABLES `accessories` WRITE;
/*!40000 ALTER TABLE `accessories` DISABLE KEYS */;
/*!40000 ALTER TABLE `accessories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amazings`
--

DROP TABLE IF EXISTS `amazings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(30) COLLATE utf8_persian_ci NOT NULL,
  `start` datetime NOT NULL,
  `end` datetime NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `description` varchar(255) COLLATE utf8_persian_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `order` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amazings`
--

LOCK TABLES `amazings` WRITE;
/*!40000 ALTER TABLE `amazings` DISABLE KEYS */;
INSERT INTO `amazings` VALUES (7,'پودر اکلیل طلایی 2033','2019-06-16 00:00:00','2019-07-01 00:00:00',140,'<p dir=\"rtl\">فروش ویژه&nbsp;پودر اکلیل طلایی 2033</p>\r\n\r\n<p dir=\"rtl\">محصول کشور آلمان</p>\r\n\r\n<p dir=\"rtl\">وزن 100 گرم</p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#27ae60\"><strong>ارسال رایگان با پست پیشتاز درب منزل یا محل کار</strong></span></p>',1,1,NULL,'2019-06-16 12:42:16'),(8,'پودر شب تاب','2019-06-16 00:00:00','2019-07-01 00:00:00',316,'<p dir=\"rtl\">فروش ویژه&nbsp;پودر شب تاب برند UPC</p>\r\n\r\n<p dir=\"rtl\">محصول کشور کره</p>\r\n\r\n<p dir=\"rtl\">وزن 50 گرم</p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#27ae60\">ارسال رایگان با پست پیشتاز درب منزل یا محل کار</span></strong></p>',1,2,NULL,'2019-06-16 12:42:51'),(9,'گلیتر طلایی هفت رنگ','2019-06-16 00:00:00','2019-07-01 00:00:00',328,'<p dir=\"rtl\">فروش ویژه&nbsp;گلیتر طلایی هفت رنگ برند UPC</p>\r\n\r\n<p dir=\"rtl\">محصول کشور کره</p>\r\n\r\n<p dir=\"rtl\">وزن 50 گرم</p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#27ae60\"><strong>ارسال رایگان با پست پیشتاز درب منزل یا محل کار</strong></span></p>',1,3,NULL,'2019-06-16 12:43:46'),(10,'پیگمنت صدفی سفید','2019-06-16 00:00:00','2019-07-01 00:00:00',119,'<p dir=\"rtl\">فروش ویژه&nbsp;پیگمنت صدفی سفید&nbsp;</p>\r\n\r\n<p dir=\"rtl\">محصول کشور چین</p>\r\n\r\n<p dir=\"rtl\">وزن 100 گرم</p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#e74c3c\"><strong>ارسال رایگان با پست پیشتاز درب منزل یا محل کار</strong></span></p>',1,4,NULL,'2019-06-16 12:44:30'),(11,'پیگمنت فلورسنت زرد','2019-05-16 10:00:00','2019-05-21 00:00:00',317,'<p dir=\"rtl\">فروش ویژه&nbsp;پیگمنت فلورسنت زرد</p>\r\n\r\n<p dir=\"rtl\">محصول کشور کره</p>\r\n\r\n<p dir=\"rtl\">وزن 75 گرم</p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#e74c3c\"><strong>ارسال رایگان با پست پیشتاز درب منزل یا محل کار</strong></span></p>',1,5,NULL,'2020-05-14 10:44:27'),(12,'پیگمنت الترامارین آبی','2019-02-24 10:00:00','2019-03-04 10:00:00',28,'<p dir=\"rtl\">فروش ویژه&nbsp;پودر شب تاب برند Nubiola</p>\r\n\r\n<p dir=\"rtl\">محصول کشور اسپانیا</p>\r\n\r\n<p dir=\"rtl\">وزن 100 گرم</p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#e74c3c\"><strong>ارسال رایگان با پست پیشتاز درب منزل یا محل کار</strong></span></p>',0,2,NULL,'2019-02-24 10:25:03'),(13,'رزین لاتکس پودری RDP','2019-02-24 00:00:00','2019-10-23 00:00:00',8,'<p><span style=\"font-size:22px\"><strong><span style=\"font-family:calibri,sans-serif\">فروش ویژه&nbsp; رزین لاتکس پودری</span></strong></span></p>',0,1,NULL,'2019-06-16 12:29:00');
/*!40000 ALTER TABLE `amazings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `article_categories`
--

DROP TABLE IF EXISTS `article_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `article_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_persian_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_persian_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `article_categories_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `article_categories`
--

LOCK TABLES `article_categories` WRITE;
/*!40000 ALTER TABLE `article_categories` DISABLE KEYS */;
INSERT INTO `article_categories` VALUES (1,'افزودنی ها','افزودنی-ها','2018-06-19 20:56:22','2018-06-19 20:56:22'),(2,'رزین','رزین','2018-06-19 20:56:37','2018-06-19 20:56:37'),(3,'رنگ','رنگ','2018-06-19 20:56:47','2018-06-19 20:56:47'),(4,'Amazon MAG','Amazon-MAG','2018-06-24 11:25:24','2018-12-23 09:53:41'),(5,'Amazon News','Amazon-News','2019-01-21 13:37:18','2019-01-21 13:37:18');
/*!40000 ALTER TABLE `article_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `articles`
--

DROP TABLE IF EXISTS `articles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `articles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `title` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `description` varchar(150) COLLATE utf8_persian_ci NOT NULL,
  `body` longtext COLLATE utf8_persian_ci NOT NULL,
  `image_path` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `thumb_path` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `tags` varchar(150) COLLATE utf8_persian_ci NOT NULL,
  `slug` varchar(150) COLLATE utf8_persian_ci NOT NULL,
  `view_count` int(11) NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `articles_category_id_foreign` (`category_id`),
  KEY `articles_user_id_foreign` (`user_id`),
  CONSTRAINT `articles_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `article_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `articles_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=317 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `articles`
--

LOCK TABLES `articles` WRITE;
/*!40000 ALTER TABLE `articles` DISABLE KEYS */;
INSERT INTO `articles` VALUES (1,1,'فرآیند پلیمریزاسیون مینی امولسیون','فرایند مینی­ امولسیون امکان تهیه­  نانو ذرات پلیمری با ساختار پیچیده و کپسوله کردن یک جامد یا مایع...','<p dir=\"rtl\" style=\"text-align:center\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/o5pm3/vt/frame\" width=\"80%\"></iframe></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">فرایند مینی &shy;امولسیون امکان تهیه &shy;ی نانوذرات پلیمری با ساختار پیچیده و کپسوله کردن یک جامد یا مایع، یک ماده ی آلی و یا غیر آلی، یک ماده &shy;ی آبدوست و یا آبگریز در یک پوسته&shy;&nbsp; پلیمری را فراهم می&shy;آورد. مواد مختلفی از پیگمنت&shy;های آلی و غیر آلی، مواد مغناطیسی و یا نانوذرات دیگر و یا مایعات آبدوست و آبگریز، مانند عطرها، داروها، و یا شروع کننده های نوری، می&shy;توانند کپسوله شوند. اصلاح سطوح نانوذرات هم می&shy;تواند به راحتی انجام شود. علاوه بر فرایند پلیمریزاسیون در حلال&shy;های آلی، نانوذرات پلیمری می&shy;توانند در حلال&shy;های سازگار با محیط زیست که معمولا آب است هم تهیه شوند.</span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"font-size:22px\"><span style=\"color:#0000FF\">معرفی</span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">فرایندهای هتروژن بسیاری برای تهیه &shy;ی نانوذرات در آب وجود دارد که شناخته شده ترین آن&shy;ها تکنیک پلیمریزاسیون امولسیونی است. اما این تکنیک بیشتر برای پلیمریزاسیون رادیکالی مناسب است و برای فرایند کپسوله کردن مناسب نیست. فرایند مینی&shy; امولسیون کردن یک تکنیک بسیار مناسب برای تهیه &shy;ی طیف وسیعی از پلیمرها و مواد است.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">مینی &shy;امولسیون&shy;ها قطرات کوچک، پایدار و با توزیع اندازه ذرات باریک در یک فاز پیوسته هستند. این سیستم به وسیله&shy; ی تنش بالا، برای مثال با التراسوند و یا همزن&shy;های فشار بالا تهیه می&shy;شود. قطرات کوچک مینی امولسیون&shy;ها می&shy;توانند به عنوان نانو ظرف&shy;هایی عمل کنند که واکنش&shy;ها می&shy;توانند داخل آن&shy;ها و یا در سطح آن&shy;ها انجام شوند و در اغلب موارد منجر به تشکیل نانو ذرات می&shy;شود. این فرایند به صورت شماتیک در شکل زیر نشان داده شده است.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><img src=\"http://www.unionpigments.com/public/photos/shares/Blogs/polymerization-process/01.png\" /></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#008000\"><span style=\"font-size:20px\"><strong>شکل 19- تصویر شماتیک فرایند پلیمریزاسیون مینی &shy;&shy;امولسیونی</strong></span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">کپسوله کردن مواد محلول و نامحلول</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">مواد محلول</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">با پلیمریزاسیون&shy;های مینی &shy;امولسیونی می&shy;توان لاتکس&shy;های بسیار یکنواخت و حاوی کمپلکس&shy;های فلزی آبگریز مانند&nbsp;bis(acetylacetonato)platinum(II)،&nbsp;tris(acetylacetonato)indium(III)،bis(tetramethylheptadionato)Zink(II)،&nbsp;bis(phthalocyanino)zinc(II)&nbsp;و&nbsp;tris(benzoylacetonato)chromium(III)&nbsp;تهیه کرد. این کمپلکس&shy;ها قبل از پلیمریزاسیون در منومرها حل &nbsp;می&shy;شوند. در برخی موارد یکنواختی لاتکس را می توان با روش&shy;های تنظیم امولسیون&shy;ها افزایش داد. با تغییر دادن میزان سرفکتانت می&shy;توان اندازه ذرات را بین 100 تا 260 نانومتر نگه داشت و با افزودن مقدار بیشتری منومر، اندازه ذرات بزرگتر و تا 370 نانومتر حاصل می شود.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><img src=\"http://www.unionpigments.com/public/photos/shares/Blogs/polymerization-process/02.png\" /></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#008000\"><strong><span style=\"font-size:20px\">شکل 20- تصویر&nbsp;TEM&nbsp;نانوذرات حاوی پلاتینیوم در اندازه&shy; های مختلف</span></strong></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">با وجود این که کمپلکس&shy;های بالا بعد از پلیمریزه شدن به طور یکنواخت در قطره پخش می&shy;شوند، کمپلکس&shy;های لانتانوایدها مانند&nbsp;[Gd<sup>III</sup>(tmhd)<sub>3</sub>] (tmhd: 2,2,6,6-tetramethyl-3,5- heptanedionate)، [Eu<sup>III</sup>(fod)<sub>3</sub>] (fod: 1,1,1,2,2,3,3-heptafluor- 4,6-octandionate)&nbsp;یا&nbsp;[Ho<sup>III</sup>(thmd)<sub>3</sub>]&nbsp;با منومرهای حاوی استر مانند بوتیل اکریلات، به طور طبیعی منجر به قطرات مینی&shy;امولسیون با تعداد زیادی لایه&shy;های پلیمری&nbsp; &nbsp;می&shy;شود. نانوکامپوزیت&shy;ها شامل یک فاز کمپلکسی لانتانواید و یک فاز پلیمری است که به صورت لایه&shy;ای با فاصله&shy;ی 5/3 نانومتر وجود دارد که تا حدی می&shy;توان گفت که از نسبت اجزای سازنده سیستم مستقل است.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><img src=\"http://www.unionpigments.com/public/photos/shares/Blogs/polymerization-process/03.png\" /></span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">شکل 21- تصویر&nbsp;TEM&nbsp;ذرات پلیمری حاوی کمپلکس آبگریز گادولینیوم&nbsp;[Gd(tmhd)<sub>3</sub>]&nbsp;همراه با سرفکتانت&shy;های مختلف&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;a) SDS،&nbsp;b)&nbsp;sodium stearate</span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">همانطور که ساختار درون ذرات با سرفکتانت تغییر می&shy;کند ماده بین سطحی هم نقش مهمی در تشکیل ساختار بازی می&shy;کند.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">یک ماده&shy;ی رنگزای فلوروسنت آبگریز را به عنوان علامت&shy;گذار در برخی کاربردهای خاص می&shy;توان به راحتی در نانوذرات جای داد. در این مورد مولکول&shy;های ماده رنگزا به صورت مولکولی در منومر حل شده &shy;اند و بعد از پلیمریزاسیون به صورت همگن در پلیمر وجود دارند.</span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">مواد نامحلول</span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">کپسوله کردن جامدات سخت&shy;تر است. برای کپسوله کردن ذرات غیر آلی مانند سیلیکای کلوئیدی، پیگمنت&shy;های تیتانیوم&shy; دی&shy; اکساید و ذرات نقره در یک پوسته پلیمری می&shy;توان از تکنیک پلیمریزاسیون امولسیونی استفاده کرد. گذشته از مشکل بودن کنترل پایداری ذرات غیر آلی در فاز آبی پیش از پلیمریزاسیون که منجر به کلوخه شدن ذرات می&shy;شود، منحصر کردن واکنش&shy;های پلیمری شدن بر روی سطوح غیر آلی هم بسیار مشکل است. یعنی هسته سازی نوع دوم هم اغلب رخ می&shy;دهد و منجر به کم شده بازده کپسوله شدن می&shy;شود. اختلافات در رفتار نفوذی منومرهای نسبتا نامحلول از قطرات منومری به سمت مراکز رشد ذرات پلیمری، نایکنواختی در ساختار ذرات پلیمری ایجاد می&shy;کند برای کپسوله کردن ذرات آبدوست، سطوح را باید با انجام آماده سازی آبگریز کرد. این آماده سازی با موادی نظیر&nbsp;3-(trimethoxysilyl)propyl methacrylate&nbsp;(MPS) انجام می&shy;شود.&nbsp;MPS&nbsp;باعث می&shy;شود که جذب سطحی منومرهای غیر قطبی و یا پلیمر بر روی سطوح معدنی بیشتر شود و یک پیوستگی کوالانسی بین زنجیره&shy;های پلیمری و سطوح پیگمنت به وجود آید که به واسطه&shy;ی گروه&shy;های آلکن قابلیت پلیمریزه شدن دارد. اصلاح سطح همچنین می&shy;تواند با روش&shy;های جذب ساده هم انجام شود. برای مثال با جذب شروع کننده&shy;های کاتیونی مانند&nbsp;2,2&rsquo;-azobis(2- amidinopropane) dihydrochloride&nbsp;(AIBA&middot;2HCl) بر روی سطوح با بار منفی می&shy;توان آماده&shy;سازی را انجام داد. واکنش پلیمریزاسیون منومرها می&shy;تواند با&nbsp;AIBNهای شروع کننده و برخورد آن&shy;ها به سطوح آماده سازی شده شروع شود.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">از پلیمریزاسیون دیسپرسیونی هم می&shy;توان برای کپسوله کردن استفاده کرد. برای مثال ذرات سیلیکای کوپل شده با&nbsp;MPS&nbsp;را می&shy;توان با پلی&shy;استایرن در فاز پیوسته&shy; ی اتانول و یا با&nbsp;poly (<em>tert</em>-butyl acrylate)&nbsp;در فاز پیوسته 2پروپانول کپسوله کرد.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">در مقایسه با پلیمریزاسیون امولسیونی و دیسپرسیونی، پلیمریزاسیون مینی&shy; امولسیونی مزایای بسیاری دارد. در یک مینی&shy; امولسیون قطرات منومر کوچک است و در نتیجه پلیمریزاسیون با ورود رادیکال&shy;ها به درون قطرات مینی&shy; امولسیون که از پیش ساخته شده است و بدون به وجود آمدن ذرات جدید رخ می&shy;دهد. از آنجایی که قطرات منومری یکنواخت تشکیل شده، خصوصیات خود را طی پلیمریزاسیون حفظ می&shy;کنند و سرعت تبادلات بین قطرات بسیار ناچیز است، اجزای پلیمری در کوپلیمریزاسیون قطره، به اجزای همان قطره در حالت منومری وابسته است. قرار دادن اجزایی مانند پیگمنت&shy;ها در منومر قبل از مینی &shy;امولسیون کردن در فاز آبی و بعد انجام فرایند پلیمریزاسیون منجر به بالا رفتن بازده کپسوله شدن می&shy;کند. کپسوله کردن پیگمنت&shy;ها و یا نانو ذرات غیر آلی به وسیله پلیمرها و با فرایند مینی&shy; امولسیون کردن این امکان را فراهم می&shy;آورد که با پخش کردن مستقیم داده&shy;های پیگمنت در فاز روغنی و بعد هسته &shy;سازی در تمام قطره&shy; های منومری که حاوی دانه&shy; های پیگمنت هستند بتوانیم اندازه ذرات نهایی را کنترل کنیم.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">با استفاده از روش مینی &shy;امولسیون کردن، نانوذراتی که از منومر آبگریزتر هستند، می توانند بدون هیچ گونه آماده سازی در فاز منومری پخش گردند. همان طور که کپسوله کردن پیگمنت&shy;های آبی فتالوسیانین و ذرات کربن بلاک با استایرن گزارش شده است. برای کپسوله کردن آبدوست مانند کلسیم کربنات، تیتانیوم&shy; دی اکساید، مگنتیت،&nbsp;CdSe&nbsp;فلوروسنتی که با&nbsp;CdS/ZnS&nbsp;پوشیده شده است، مونت&shy;موری لونیت، سیلیکا، نقره و یا ذرات فسفرسانس ایریوم&shy;اکسی &shy;سولفاید با پلیمرهای هیدروفوب، قبل و یا در حین پخش کردن نانوذرات در فاز منومری، عملیات آبگریز کردن نانو ذرات بسیار ضروری است. ذرات کلسیم کربنات و مگنتیت می&shy;توانند به خوبی با استئاریک اسید وOleoyl Sarcosine acid&nbsp;به عنوان عامل آبگریز کننده در پلی استایرن کپسوله شوند.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">Erdem et al&nbsp;از&nbsp;OLOA 370&nbsp;که یک&nbsp;polybutene succinimide pentamine&nbsp;است، ذرات تیتانیوم &shy;دی &shy;اکساید را به راحتی درون محمل آلی پخش کرد. نقره با استفاده از کربن آبگریز شده و&nbsp;quantum dots&nbsp;می&shy;تواند توسطtrialkyl phosphine&nbsp;که از قبل با پلیمریزاسیون رادیکالی انتقال هسته مدیفای شده، آبگریز شود. ذرات سیلیکا قبل از پخش شدن در منومرهای آبگریز توسط&nbsp;cetyltrimethyl amunium chloride&nbsp;(CTMACl) آبگریز شدند. همچنین می&shy;توان با استفاده از شروع کننده&shy;های&nbsp;Alkoxyamin&nbsp;که بر پایه&shy;ی&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;N-<em>tert</em>-butyl-1- diethylphosphono-2,2-dimethylpropyl nitroxide&nbsp;است و به صورت در مکان بر روی سیلیکا گرفت شده است، آبگریزی لازم را به وجود آورد. از این&nbsp;Alkoxyaminهای گرفت شده برای شروع پلیمریزاسیون زنجیره&shy; های پلی&shy;استایرن بر روی سطح غیر آلی هم استفاده شد.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">روش پخش کردن مستقیم مواد در فاز منومری قبل از مینی&shy; امولسیون کردن، منجر به استفاده از درصد کمی از مواد غیر آلی و تولید نانوکامپوزیت&shy;ها می&shy;شود (&lt;10%) و این به دلیل برهمکنش قوی بین موادی است که&nbsp;&nbsp; &nbsp;می&shy;خواهند کپسوله شوند که در نهایت به تجمع آن&shy;ها منجر می&shy;شود.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">بنابراین یک روش جدید برای تولید نانوکامپوزیت&shy;ها به وجود آمد که باز هم بر مبنای مینی &shy;امولسیون است. سونیکاسیون مضاعف&nbsp;دو فاز دیسپرس شده، یعنی منومر مینی &shy;امولسیفای شده و نانوذرات پخش شده و به دنبال آن انجام پلیمریزاسیون باعث کپسوله شدن موثر ذرات می شود.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><img src=\"http://www.unionpigments.com/public/photos/shares/Blogs/polymerization-process/04.png\" /></span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">شکل 21- تصویر شماتیک فرایند مینی&shy; امولسیونی سونیکاسیون مضاعف</span></span></strong></p>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">با استفاده از این روش ذرات کربن بلاک را میتوان با بازده بسیار بالا با پلیمرهایی مانند پلی&shy;استایرن،&nbsp; پلی&shy;اکریلات&shy;ها، پلی&shy;یورتان&shy;ها کپسوله شوند و نسبت کربن بلاک به پلیمر در آن&shy;ها بسار مختلف است.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><img src=\"http://www.unionpigments.com/public/photos/shares/Blogs/polymerization-process/05.png\" /></span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">شکل 22- تصویر&nbsp;TEM&nbsp;کربن بلاک کپسوله شده با پلی&shy;یورتان</span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">&nbsp;پلیمریزاسیون در واقع در لایه&shy;ی منومر جذب شده بر روی سطح و پایدار شده با مینی&shy; امولسیون کردن انجام می&shy;شود (پلیمریزاسیون ادمینی&shy; امولسیونی). با این روش نانوذرات آلی مختلفی هم می&shy;توانند با بازده بالا با پلیمر کپسوله شوند که نتیجه ساختارهایی هیبریدی با نسبت وزنی پیگمنت به پلیمر 80 به 20 است.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><img src=\"http://www.unionpigments.com/public/photos/shares/Blogs/polymerization-process/06.png\" /></span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">شکل 23- تصویر&nbsp;TEM&nbsp;کلوئیدهای پیگمنت آزو کپسوله شده با پلی&shy;استایرن</span></span></strong></p>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">کپسوله کردن مایعات</span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">نانو کپسول&shy;ها می&shy;توانند از منومرها و پلیمرهای طبیعی و یا مصنوعی مختلفی و با استفاده از تکنیک&shy;های متنوعی حاصل شوند. کپسوله کردن پپتایدها و پروتئین ها با استفاده از تولید میکروکپسول&shy;ها با روش های&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;Double-emulsion، امولسیون سازی/تبخیر حلال، روش نفوذ و یا روش&nbsp;Salting out&nbsp;انجام شده است. یک روش جدید، تکنیک لایه به لایه&nbsp;است که با استفاده از یک قالب به عنوان هسته که پلی الکترولیت های با بارهای مثبت و منفی می&shy;توانند به صورت یکی در میان بر روی آن اضافه شوند. برای مثال ملامین فرمالدهید به عنوان هسته مصنوعی،&nbsp;poly(allylamine hydrochloride)&nbsp;و نمک سدیم&nbsp;poly(acrylic acid)&nbsp;به عنوان الکترولیت به کار رفته &shy;اند. روش&shy;های مختلفی برای نانوکپسوله کردن مایعات به کار می&shy;روند که همگی بر پایه &shy;ی تکنولوژی مینی&shy;امولسیون هستند. در زیر به صورت شماتیک به توضیح آن ها می&shy;پردازیم.</span></p>\r\n\r\n<ol dir=\"rtl\">\r\n	<li><span style=\"font-size:18px\">جدایی فاز در طول پلیمریزاسیون</span></li>\r\n</ol>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">قبل از پلیمریزاسیون منومر و روغن آّبگریز قطراتی همگن را تشکیل می&shy;دهند و بعد پلیمریزاسیون منومرها باعث نانوکپسوله شدن فاز روغنی می شود.</span></p>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<ol dir=\"rtl\" start=\"2\">\r\n	<li><span style=\"font-size:18px\">رسوب&shy;گذاری نانو</span></li>\r\n</ol>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">یک مینی &shy;امولسیون وارونه تشکیل می&shy;شود. این روش برای کپسوله کردن یک جزء آبدوست به کار&nbsp; &nbsp;می&shy;رود. فاز پیوسته شامل مخلوط حلال/غیر حلال است. در حین تبخیر حلال، پلیمر بر روی نانوذرات رسوب می&shy;کند و بعد می&shy;توان نانو کپسول&shy;ها را به فاز آبی منتقل کرد.</span></p>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<ol dir=\"rtl\" start=\"3\">\r\n	<li><span style=\"font-size:18px\">واکنش پلیمریزاسیون بین سطحی روی قطرات مینی &shy;امولسیون</span></li>\r\n</ol>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\">قطرات در مینی &shy;امولسیون وارونه شامل جزء آبدوست برای کپسوله شدن و منومر 1 هستند. با افزودن منومر دوم از طریق فاز پیوسته، پلیمریزاسیون در سطح قطره انجام می&shy;شود و نانوکپسول&shy;ها شکل می&shy;گیرند و بعد می&shy;توان آن را به فاز آبی انتقال داد.</span></p>\r\n\r\n<p dir=\"rtl\"><br />\r\n<span style=\"font-size:18px\">نویسنده : دکتر مجید محسنی</span></p>\r\n\r\n<p style=\"text-align:right\">&nbsp;</p>','/app/articles/1529425725144.jpg','/app/articles/1529425726142.jpg','امولسیون,مقاله,پلیمریزاسیون,نانو ذرات,پلیمر,مواد شیمیایی','فرآیند-پلیمریزاسیون-مینی-امولسیون',1771,2,1,'2018-06-19 20:58:46','2022-01-11 23:06:39'),(2,1,'مقایسه انواع پلیمریزاسیون های امولسیونی','سوسپانسيون­ها، امروزه كاربردهاي وسيعي در صنايع مختلف مانند لاستيك، رنگ، چسب','<p dir=\"RTL\" style=\"text-align:center\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/o5pm3/vt/frame\" width=\"80%\"></iframe></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">سوسپانسيون&shy;ها، امروزه كاربردهاي وسيعيی در صنايع مختلف مانند لاستيك، رنگ، چسب، افزودني&shy;هاي كاغذ و منسوجات، اصلاح چرم و افزودني&shy;هاي مواد ساختماني دارند. همين&shy;طور از آن&shy;ها در پزشكي و كاربردهاي وابسته به داروها و سيستم&shy;هاي تحويل دارو استفاده مي&shy;شود. به دليل مسائل محيط زيستي و قانون&shy;هاي تصويب شده براي جايگزين كردن سيستم&shy;هاي پايه حلالي با محصولات سازگار با محيط زيست و پايه آبي، اين سيستم&shy;ها به سرعت گسترش پيدا كردند. چون سوسپانسيون&shy;هاي پليمري خواص و ويژگي&shy;هاي منحصر به فردي دارند كه آن&shy;ها را براي استفاده در بسياري از بازارها مناسب كرده است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اين محصولات معمولا به روش پليمريزاسيون امولسيوني سنتي تهيه مي&shy;شوند. در اين فرايند، منومر در محلولي از&nbsp;&nbsp;Surfactant&nbsp;در آب با غلظت كمي بيشتر از&nbsp;CMC&nbsp;پخش مي&shy;شود و پليمريزاسيون با سيستم&shy;هاي آغازگر (كه معمولا در فاز آبي قابل حل مي&shy;باشند)، شروع مي&shy;شود. ذرات پليمري با ورود راديكال&shy;ها به درون مايسل&shy;ها (هسته سازي هتروژن)، رشد اليگومرها در فاز آبي (هسته سازي هموژن) و ورود راديكال&shy;ها به قطرات منومري حاصل مي&shy;شوند. اندازه قطرات منومري در حدود 1 تا 10ميكرون است و در مقابل اندازه منومرهاي وارد مايسل شده كه اندازه&shy;اي در حدود 10 تا 20 نانومتر دارند، نسبتا بزرگتر هستند و در نتيجه مساحت سطح (Surface area) مايسل&shy;ها به مراتب از قطرات پليمري بيشتر است. بنابراين احتمال ورود راديكال آزاد به درون قطرات منومري بسيار اندك است و هسته سازي بيشتر به روش&shy;هاي هتروژن و هموژن انجام مي&shy;شود. هنگامي كه هسته سازي انجام شد، ذرات پليمري با واكنش&shy;هاي پليمريزاسيون تشكيل مي&shy;شوند. منومر مورد نياز براي ادامه پليمريزاسيون بايد از طريق نفوذ آنها از قطرات منومري در محلول آبي تامين شود و در برخي موارد اين مكانيزم محدوديت&shy;هايي براي پليمريزاسيون امولسيوني ايجاد مي&shy;كند. مثلا در برخي موارد متصل كردن منومرهاي آبگريز مانند لوريل و استريل متاكريلات&shy;ها به زنجيره اصلي پليمر باعث بالا رفتن مقاومت در برابر آب، در فيلم حاصل از پليمر سوسپانسيون شده مي&shy;شود. اما انتقال جرم اين مواد از قطرات پليمري در محلول آبي شديدا تحت كنترل پديده نفوذ است. بنابراين در پليمريزاسيون امولسيوني امكان استفاده از آنها وجود ندارد. اگر همه&shy;ي قطرات منومري و يا حداقل درصد قابل توجهي از آن&shy;ها تبديل به هسته شوند، نياز به انتقال جرم منومرها در محلول آبي به حداقل مي&shy;رسد و اين زماني رخ مي&shy;دهد كه مساحت سطح قطرات منومري بزرگ و قابل مقايسه با مايسل&shy;ها باشد و اين مستلزم داشتن اندازه ذرات زير ميكرون و در حد نانو است. واژه ميني&shy;امولسيون براي ديسپرسيون روغن در آب به اندازه ذرات زير ميكرون است كه براي مدتي، از چندين ساعت تا چندين ماه پايدار است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">توليد و به كار بردن نانو ذرات پليمري كه در يك محمل غير آلي پخش شده &shy;اند و به لاتكس هاي پليمري معروفند، در علم پليمر يك رنسانس به وجود آورده است. و اين به چند دليل است. از يك طرف به دليل مسائل امنيتي، بهداشتي، زيست محيطي و مسائل مربوط به سلامت، گرايش به فرمولاسيون پليمرها در حلال&shy;هاي سالم و غير آلي كه آب در راس آن ها قراردارد، بيشتر شده است و به همين دليل علم پليمر بايد با مشكلات پخش و توليد پليمرها در آب (علي رغم اين كه ممكن است آب در فرايند پليمريزاسيون مشكل ايجاد كند) مقابله كند. دليل دوم براي گسترش اين مساله، گرايش به توليد فرمولاسيون پليمرها با درصد جامد بالا است كه در نتيجه اثرات مربوط به&nbsp;Shrinkage&nbsp;به حداقل مي&shy;رسد و زمان فرايند هم كم مي&shy;شود. توليد يك پليمر با درصد جامد بالا و در عين حال ويسكوزيته قابل قبول و مناسب فقط با ديسپرسيون&shy;هاي پليمري در آب و يا در حلال هاي آلي ميسر است. سوم اين كه دانشمندان فهميده&shy;اند كه با ديسپرسيون هاي پليمري و مثلا با تنظيم اندازه ذرات، مي&shy;توانند خواص بيشتري را به توده پليمري اضافه كنند. يعني مي&shy;توانند خواصي را ايجاد كنند كه فقط مربوط به طراحي ساختار مولكولي پليمر نيست. مثلا توليد لاستيك&shy;هاي بهتر و يا ترموپلاستيك هاي مقاوم در برابر شوك. بيشتر لاتكس&shy;هاي پليمري با پليمريزاسيون امولسيوني تهيه مي&shy;شوند. با وجودي كه پليمريزاسيون امولسيوني گسترش باور نكردني و كاربردهاي فراواني دارد، از برخي جهات محدوديت هايي هم دارد. و آن اين كه واكنش هاي پليمريزاسيون محدودي هستند كه به اين روش قابل انجام هستند. پليمريزاسيون امولسيوني براي هموپليمريزاسيون راديكالي دسته محدودي از منومرهاي محلول در آب خوب است اما محدوديت&shy;هاي عمده&shy;اي در كوپليمريزاسيون راديكالي و واكنش&shy;هاي ديگر پليمرها دارد. علت اين امر، مكانيزم اين پليمريزاسيون است كه ذرات پليمري كه حاصل اين نوع پليمريزاسيون هستند و با سينتيك كنترل مي&shy;شوند، همه از مركز به سمت سطح ساخته مي&shy;شوند و تمام منومرها بايد توسط نفوذ در فاز آبي انتقال يابند. بنابراين حتي در پليمريزاسيون راديكالي معايبي هم چون نقص در يكنواختي و عدم توانايي به دستيابي به تركيب&shy;هاي مورد نظر وجود دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">روش&shy;هاي ديگري هم براي توليد ديسپرسيون هاي پليمري مانند پليمريزاسيون ميكروامولسيون&shy;ها، پليمريزاسيون سوسپاسيوني و ... وجود دارند كه هر كدام نقايصي همچون استفاده زياد از&nbsp;Surfactantها، كم بودن پايداري كلوئيدي و يا گراني فرايند دارند كه جلو استفاده وسيع آن&shy;ها را در علم پليمر مي&shy;گيرد. مفهوم ايده آلي در پليمريزاسيون هتروژن وجود دارد كه در آن قطرات كوچك يكنواخت و پايدار منومر و يا اليگومر وجود دارند. و بدون اين كه خواص مطلوب خود را از دست بدهند و يا روي سينتيك تاثير نامطلوبي بگذارند به پليمر تبديل شوند. يعني قطرات منومري، محل شروع واكنش&shy;هاي پليمريزاسيون شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>تفاوت&shy;هاي بين پلیمریزاسیون ماكروامولسيون، ميني&shy;امولسيون، ميكروامولسيون و پليمريزاسيون سوسپانسيوني</strong></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ميني&shy;امولسيون در تعريف، فقط به اندازه ذرات محدود نمي&shy;شود، بلكه مكانيزم و عملكرد آن هم متفاوت است. بنابراين در بسياري موارد مي&shy;توان ميني&shy;امولسيون را از ساير روش&shy;هاي پليمريزاسيون هتروژن تفكيك كرد. شكل زیر تا حدودي اين مكانيزم&shy;ها را نشان مي&shy;دهد. پليمريزاسيون در ميكروامولسيون&shy;ها در حالت تعادل ترموديناميكي شروع مي&shy;شود كه توسط مقادير زيادي از مواد و يا سيستم&shy;هاي مواد فعال سطحي فراهم مي&shy;شود. و كشش سطحي حد فاصل روغن و آب به صفر نزديك است. در مقابل، ميني&shy;امولسيون&shy;ها به سختي پايدار مي&shy;شوند و برش و نيروي زيادي براي رساندن آن&shy;ها به حالت پايدار لازم است و كشش سطحي حد فاصل، بسيار بيشتر از صفر است. مقادير زيادي از&nbsp;Surfactant&nbsp;كه در ميكروامولسيون ها به كار مي&shy;رود، تمام سطح ذرات را پوشش مي&shy;دهد. از آن جايي كه واكنش&shy;هاي شروع نمي&shy;توانند به طور همزمان در همه&shy;ي قطرات صورت گيرند، زنجيره&shy;هاي پليمري اوليه، تنها در برخي از قطرات شكل مي&shy;گيرند. اثرات فشار اسمزي و الاستيكي اين زنجيره&shy;ها ميكروامولسيون&shy;هاي ضعيف را ناپايدار مي&shy;كند و معمولا منجر به افزايش اندازه ذرات، تشكيل مايسل&shy;هاي خالي و هسته سازی&nbsp;نوع دوم مي&shy;شود. محصول نهايي، لاتكس&shy;هاي بسيار ريز به اندازه ي 5-50 نانومتر است كه با مقادير زيادي از مايسل&shy;هاي خالي همزيستي مي&shy;كنند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در پليمريزاسيون امولسيوني قطرات منومر بزرگ كه با&nbsp;Surfactant&nbsp;پايدار شده&shy;اند و مايسل&shy;هاي خالي يا منومرهاي وارد مايسل شده، وجود دارند و پليمريزاسيون مي&shy;تواند در همه&shy; ي آن ها شروع شود. شروع كننده&shy;هاي محلول در آب، اليگوراديكال&shy;هايي با حلاليت كم در آب تشكيل مي&shy;دهند و اين تا زماني ادامه مي&shy;يابد كه آن&shy;ها به اندازه&shy;ي كافي آبگريز شوند تا بتوانند وارد مايسل&shy;ها شوند و يا در فاز پيوسته تشكيل هسته بدهند در خلال پلمريزاسيون، منومرها از قطرات بزرگ منومري براي تغذيه مايسل&shy;ها در فاز آبي ادامه نفوذ مي&shy;كنند تا زماني كه قطرات ناپديد شوند. ذراتي به اندازه معمولا بزرگتر از 100 نانومتر تشكيل مي&shy;شوند. با توجه به افزايش مساحت حد فاصل، با پليمريزاسيون كشش سطحي لاتكس افزايش مي&shy;يابد. در پليمريزاسيون امولسيوني اندازه ذرات لاتكس به اندازه قطرات اوليه امولسيون وابسته نيستند و اندازه آنها توسط فاكتورهاي سينتيكي مانند: دما، مقدار شروع كننده، سرعت توليد هسته &shy;ها و پايداري نانوذره &shy;ها اثر مي&shy;پذيرد. اين فاكتورها در ميني&shy;امولسيون بي&shy;اثرند و ذرات لاتكس همان ذرات قطرات منومري اوليه هستند كه پليمريزه شده&shy;اند و اندازه آن&shy;ها وابسته به فرآيند ديسپريون&shy;سازي و مستقل از پارامترهاي پليمريزاسيون است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img alt=\"مقایسه انواع پلیمریزاسیون های امولسیونی\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/01.png\" />&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">پليمريزاسيون سوسپانسيوني شامل قطرات بزرگتري از منومر (1ميكرون تا 1 ميلي&shy;متر) است كه در فاز پيوسته پخش شده است. هسته&shy; سازي غالبا در قطرات انجام مي&shy;شود و هر قطره به صورت يك رآكتور بچ مجزا عمل مي&shy;كند و بسيار شبيه مكانيزم&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;ميني&shy;امولسيون است و تفاوت اصلي در سايز و پايداري ذرات تشكيل شده است. در اين نوع پليمريزاسيون، هسته سازي در قطرات منومري انجام مي&shy;شود و متوسط راديكال&shy;ها به ازاي ذرات، بسيار زياد است (10<sup>6</sup>-10<sup>2</sup>). با توجه به اندازه ذرات بسيار بزرگ، فشار قطرات كم است و&nbsp;Ostwald ripening&nbsp;با سرعت بسيار كمتري صورت مي&shy;گيرد و به همين دليل است كه افزودن آبگريز در پليمريزاسيون سوسپانسيوني معمول نيست.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>كارهاي اخير</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">براي اولين بار&nbsp;Ugelstad&nbsp;نشان داد كه با كوچك شدن اندازه قطرات به اندازه كافي، مكانيزم تشكيل هسته قطره&shy;اي بيشتر مي&shy;گردد و نشان داده شد كه الكل&shy;هاي چرب با زنجيره بلند، قابليت&nbsp;Surfactantهاي آنيوني را در پخش و پايدار كردن ديسپرسيون&shy;هاي روغن در آب افزايش مي&shy;دهد. گزارش شد كه الكل&shy;هاي چرب انرژي بين سطحي را كاهش مي&shy;دهند و باعث مي&shy;شوند كه ذرات به اندازه دلخواه كوچك شوند.&nbsp;Ugelstad،Cetyl alcohol&nbsp;(CA) را با&nbsp;Sodium luryl sulfate&nbsp;(SLS) در آب مخلوط كرد و استايرن را در حال به هم زدن و در دماي 60 درجه سلسيوس به آن افزود و مشاهده كرد كه ميني&shy;امولسيون براي مدت دو هفته پايدار ماند. واكنش را در همان دما شروع كرد و مشاهده شد كه هنگامي كه مقدار كمتري از مواد فعال سطحي به كار مي&shy;رود، ذرات پليمري بيشتر از هسته&shy; سازي قطره&shy;اي حاصل مي&shy;شوند. قبلا هم&nbsp;Ugelstad&nbsp;پايدار سازي امولسيون&nbsp;vinyl Chloride&nbsp;را با مخلوطي از&nbsp;Surfactant&nbsp;آنيوني و الكل&shy;هاي چرب پيشنهاد كرده بود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">كار&shy;هاي جديدي در مورد فرموله كردن و پايدار سازي امولسيون&shy;ها انجام شد.&nbsp;Ugelstad&nbsp;مخلوط&nbsp;hexadecanol/Sodium hexadecyl sulfate&nbsp;را در آب 70 درجه سلسیوس فراهم كرد. مخلوط را تا دماي 60 درجه خنك كرد و بعد منومر استايرن را در 600&nbsp;rpm&nbsp;به آن افزود و فهميد كه اندازه ذرات كاهش پيدا كرد و در نسبت&nbsp;Surfactant&nbsp;به الكل 1 به 3 پايداري افزايش پيدا كرد. ميني&shy;امولسيون با گذشت زمان افت مي&shy;كرد و اين افت در دماهاي بالاتر شديدتر بود. مكانيزمي كه براي امولسيون سازي پيشنهاد شد اين بود كه يك كمپلكس موقتSurfactant/الكل چرب، تشكيل مي&shy;شود كه به امولسيفاي كردن منومر كمك مي&shy;كند. سپس الكل چرب به درون قطره نفوذ مي&shy;كند و پايداري قطره را از بين مي&shy;برد. بر اساس اين مكانيزم، مقدار الكل چرب بايد از طرفي به اندازه&shy;اي كم باشد كه پايداري قطره را به هم نزند و از طرفي به اندازه&shy;اي باشد كه برای انجام وظيفه&shy;اش در امولسيون سازي و تشكيل كمپلكس كافي باشد. اين مكانيزم با آزمايشي تاييد شد. و آن اين بود كه الكل چرب از قبل در منومر استايرن حل شد و نتيجه&shy;اش چيزي جز سيستم هاي ناپايدار نبود. به هر حال مكانيزم بر اين پايه استوار بود كه وظيفه الكل چرب تنها اصلاح سطح قطره است و بعدها نشان داده شد كه درست نيست. در ميني&shy;امولسيون سازي استايرن دو نوع توزيع اندازه ذره وجود داشت كه ذرات بزرگ مربوط به هسته &shy;سازي قطره&shy;اي بود. الكل&shy;هاي چرب باعث كم شدن انرژي بين سطحي شده، باعث مي&shy;شوند كه اندازه ذرات مناسب حاصل شوند. بنابراين فقط در نسبت هاي بالاي الكل چرب به&nbsp;Surfactant، هسته&shy; سازي حاصل شد. الكل&shy;هاي چرب راCosurfactant&nbsp;ناميدند.&nbsp;Azad&nbsp;فهميد كه الكل&shy;هاي چرب با زنجيره هاي طولاني تر پايداري را بيشتر مي&shy;كنند. او و همكارانش با الهام از كار آقايان&nbsp;Hallworth&nbsp;و&nbsp;Carless&nbsp;و همچنين&nbsp;Smith&nbsp;و&nbsp;Davies&nbsp;كه گزارش كرده بودند كه امولسيون نفت سبك، بنزن و هگزان با افزودن مقدار كمي&nbsp;hexadence&nbsp;(HD) به شدت افزايش مي&shy;يابد، تصميم گرفتند از&nbsp;HD&nbsp;در ميني&shy;امولسيون كردن منومرها به جاي الكل هاي چرب استفاده كنند. در آغاز مشاهده كردند كه با دستگاه&shy;هاي همزن معمولي به سرعتي كه به وسيله&shy;ي الكل&shy;هاي چرب با زنجيره طولاني مي&shy;شود، به امولسيون نمي&shy;رسند. بنابراين از سيستم&shy;هاي هموژنايزر با كارايي بالاتر استفاده كردند و با هموژنيزه كردن يك امولسيون حاوي&nbsp;HD&nbsp;با يك دستگاه هموژنايزر فشار بالاي آزمايشگاهي به يك ميني&shy;امولسيون به شدت پايدار رسيدند. هموژنيزه كردن &nbsp;ميني&shy;امولسيون حاوي الكل چرب اثري بر روي پايداري آن نداشت اما در اين مورد پايداري امولسيون، مستقل از طريقه&shy;ي مخلوط كردن آن&shy;ها (اختلاط اولیه) است.&nbsp;Misra&nbsp;و&nbsp;Higushi&nbsp;براي اولين بار بيان كردند كه ناپايداري در امولسيون ها به خاطر اثر نفوذ مولكولي (Ostwald ripening effect) است. اين نظريه بر اين پايه است كه پتانسيل شيميايي قطرات منومري كوچكتر، به خاطر اثرات انرژي سطحي، بيشتر از قطرات منومري بزرگتر و يا سطوح صاف است. بنابراين منومر از قطرات كوچكتر به قطرات بزرگتر نفوذ مي&shy;كند كه نتيجه آن بزرگتر شدن قطرات و ناپايدار شدن سيستم است. آن&shy;ها پيش&shy;بيني كردند كه افزودن كمي از مواد نامحلول، مي&shy;تواند افت (degradation) امولسيون به خاطر اثرات نفوذ مولكولي را به تاخير اندازد. چون سرعت نفوذ كم مواد نامحلول از تعادل منومرها در بين قطرات جلوگيري مي&shy;كند و بنابراين تاخير در پايداري سيستم منوط به تغيير در توزيع جزء، با كمترين سرعت نفوذ است.&nbsp;Smith&nbsp;و&nbsp;Davies&nbsp;اثر مقدار كمي از&nbsp;hexadence&nbsp;در جلوگيري از افت ميني&shy;امولسيون را به همين اثرات گفته شده در بالا نسبت دادند.&nbsp;Dubrin&nbsp;درجات مختلف امولسيون سازي را بررسي كرد و به اين نتجه رسيد كه در يك سيستم استايرن- سرفكتانت آنيوني- آب، بدونCA&nbsp;يا&nbsp;HD&nbsp;هسته&shy; سازي قطره&shy;اي بسيار كم است. كار اخير اساس فرآيند پليمريزاسيون ميني&shy;امولسيوني را بنا كرد. يعني بايد هموژنيزه كردن با انرژي بالا براي كاهش اندازه ذرات اعمال شود و قطرات توليد شده با استفاده از يك جزء نامحلول در آب و يك&nbsp;Surfactant&nbsp;مناسب از لخته شدن و اثرات&nbsp;Ostwald ripening&nbsp;حفظ می&shy;شوند. اين كار حتي نام&shy;گذاري&shy;ها را هم تحت تاثير قرار داد. مثلا در مراجع پليمريزاسيون ميني&shy;امولسيوني، اجزاء نامحلول در آب و با وزن مولكولي پايين معمولا به&nbsp;Cosurfactant&nbsp;ياد مي&shy;شوند. اما به جز الكل&shy;هاي با زنجير بزرگ، تركيباتي مثل&nbsp;hexadence&nbsp;فعاليت سطحي ندارند. به علاوه اثر اصلي اين تركيبات در پايدار سازي، اثر در بالك است و نه در سطح. ماده&shy;اي كه قطرات را در برابر نفوذ مولكولي حفظ مي&shy;كند، به خاطر خاصيت نامحلولي، آبگريز (hydrophobe) هم ناميده مي&shy;شود. با اين كه هر تركيب نامحلول درآب مي&shy;تواند&nbsp;Ostwald ripening&nbsp;را به تاخير بيندازد، اما توانايي آن به شدت وابسته به وزن مولكولي آن است. يعني مواد نامحلول در آب با وزن مولكولي كم، از اين مواد با وزن مولكولي بالا بازده بهتري دارند. به علاوه استفاده از اسم آبگريز، محدود به مواد نامحلول با وزن مولكولي بالا (مانند پليمرها) است. بنابراين نام&nbsp;Costabilizer&nbsp;نامي است كه براي اجزاي نامحلول در آب با وزن مولكولي كم به كار مي&shy;رود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>اثرات مواد فعال سطحی (</strong><strong>Surfactant</strong><strong>)</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">پايداري كلوئيدها معمولا با انتخاب نوع و ميزان&nbsp;Surfactant&nbsp;كنترل مي&shy;شود. ما در اين جا مطالب كلي را در مورد يك&nbsp;Surfactant&nbsp;نمونه (SDS) بيان مي&shy;كنيم. در ميني&shy;امولسيون&shy;ها سرعت اختلاط تعادل موقع هم زدن و بنابراين اندازه قطرات بلافاصله بعد از به تعادل رسدن به ميزان امولسيفاير بستگي دارد. براي سيستم استايرن و&nbsp;SDS&nbsp;يك بازه از 180 نانومتر (3/0% وزنی&nbsp;SDS&nbsp;نسبت به استايرن) تا 32 نانومتر (50% وزنی&nbsp;SDS&nbsp;نسبت به استايرن) وجود دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img alt=\"مقایسه انواع پلیمریزاسیون های امولسیونی\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/02.png\" />&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در مقايسه با پليمريزاسيون ميكروامولسيوني و امولسيوني اين اندازه ذرات نسبت به&nbsp;Surfactant&nbsp;مصرف شده بسيار خوب است. يك لاتكس به اندازه ذرات 32 نانومتر نيمه شفاف است و بسيار نزديك به نتیجه پليمريزاسيون ميكروامولسيوني است و بدون استفاده از آبگريز و با استفاده از مخلوط الكل/SDS&nbsp;به دست آمده است. براي مطالعه&shy;ي بازده&shy;ي&nbsp;Surfactant&nbsp;و چگونگي پيشرفت واكنش نسبت به اندازه ذرات،A<sub>surf</sub>&nbsp;تعریف شده كه عبارت است از متوسط مساحت روغن پايدار شده در آب به ازاي يك مولكول&nbsp;Surfactant&nbsp;كه بستگي شديدي به اندازه ذرات دارد. يعني براي ذرات كوچك يك لايه انبوه از&nbsp;Surfactant، تمام ذره را پوشش مي&shy;دهد و براي ذرات بزرگ لاتكس، اين پوشش كامل نيست. اين یعني ذرات كوچكتر جزء حجمي قابل توجهي دارند، متوسط فاصله سطح به سطح كمتري دارند، حركت نسبي بيشتر و پتانسيل كمتري دارند و بنابراين لايه&shy;ي بزرگتري از&nbsp;Surfactant&nbsp;را روي خود جاي&nbsp;&nbsp; &nbsp;مي&shy;دهند. از آن جا كه لايه غليظ روي ذرات، شيمي برخي چيزها مانند سرعت نفوذ به طرف سطح و يا زياد شده تركيبات قطبي در داخل قطره، با توجه داشت كه در برخي موارد اندازه قطرات بزرگ بهتر است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">مقادير&nbsp;A<sub>surf</sub>&nbsp;در حدود 2/0&nbsp;nm<sup>2</sup>&nbsp;مقادير زياد&nbsp;Surfactant&nbsp;را نشان مي&shy;دهد و در نتيجه مايسل هاي خالي وجود دارند و يا چند لايه روي ذرات جذب شده است كه براي ميني&shy;امولسيون ايجاد مشكل مي&shy;كند و از ناحيه ايده آل آن خارج مي&shy;شود و از طرف ديگر استفاده از مقادير كمتر از 3/0% از&nbsp;Surfactant، كلوئيد ناپايدار حاصل مي&shy;كند و باز هم از ناحيه&shy;ي ايده آل آن خارج مي&shy;شويم. قابل ذكر است كه اثر پوشش دهيSurfactantها، در كشش سطح هاي مختلف لاتكس ها متفاوت است. پلي استايرن بر پایه سنتز ميني&shy;امولسيوني، كه داراي اندازه ذراتي در حدود 100&nbsp;nm&nbsp;&nbsp;است، كشش سطحي در حد آب خالص دارد. اين به اين خاطر است كه اندازه ذرات به قدري بزرگ است كه جذب تعادلي باعث مي&shy;شود كه كمي&nbsp;Surfactant&nbsp;آزاد باقي بماند. قطرات كوچكتر بيشتر پوشيده مي&shy;شوند و غلظت تعادلي&nbsp;Surfactant&nbsp;آزاد بيشتري را ايجاد مي&shy;کنند و البته این غلظت بيشتر، باز هم به خوبي زير&nbsp;CMC&nbsp;است. به زبان ديگر در ميني&shy;امولسيون&shy;ها، مايسل آزاد وجود ندارد و اين در واكنش پذيري شيميايي و سرعت پليمريزاسيون بسيار مهم است. اما در غلظت&shy;های بيشتر (50%&nbsp;SDS)، مايسل&shy;ها ديده مي&shy;شوند كه مي&shy;توان آن را ميني&shy;امولسيون به حساب نياورد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>نوع&nbsp;</strong><strong>Surfactant</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بيشتر توضيحات داده شده، بر پايه استفاده از&nbsp;Surfactant&nbsp;آنيوني&nbsp;SDS&nbsp;است. براي اولين بار در سال 1976 استفاده از&nbsp;Surfactantهاي كاتيوني (مانند&nbsp;octadecyl pridinium bromide) براي تهيه ميني&shy;امولسيون ها شروع شد. وقتي براي تهيه&nbsp;&nbsp; &nbsp;ميني&shy;امولسيون&shy;ها ازSurfactantهاي كاتيوني استفاده مي&shy;شد، نتيجه امولسيون&shy;هايي با توزيع اندازه قطرات پهن بود.&nbsp;EL-Aassar&nbsp;از آن&shy;ها براي تهيه&shy; ي ميني&shy;امولسيون&shy;ها هم اسفاده كرد. كار اخير بر روي ميني&shy;امولسيون&shy;هاي حالت پايدار كه از&nbsp;Surfactantهاي كاتيوني استفاده كرده، منجر به تهيه لاتكسي پايدار با توزيع اندازه ذرات باريك شد. نتايج اندازه گيري&shy;هاي كشش سطحي، ميزان پوشش دهي 30 درصدي قطرات را نشان مي&shy;داد كه حاكي از بازده خوب اين&nbsp;Surfactantها است. گونه جديدي از&nbsp;Surfactantهاي كاتيوني با گروه&shy;هاي سولفوني هم در تهيه&shy; ي ميني امولسيون&shy;ها به كار رفته&shy; اند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">براي توليد ميني&shy;امولسيون&shy;هاي غير يوني مي&shy;توان از 3 تا 5 درصد از مشتقات&nbsp;poly(ethelene oxide)&nbsp;استفاده كرد. اگر چه اندازه ذرات بزرگتر مي&shy;شود اما پايداري بالا است.&nbsp;Chern&nbsp;و&nbsp;Liou&nbsp;از&nbsp;Surfactant&nbsp;غير يوني&nbsp;nonylphenol polyethoxylate&nbsp;استفاده كردند و اندازه ذرات بين 135 تا 280 نانومتر حاصل شد. گزارش شد كه اندازه ذرات، بيشتر به مقدار و نوع آبگريز و اثر&nbsp;Ostwald&nbsp;ripening&nbsp;بستگي دارد.&nbsp;Capek&nbsp;از ماكرومنومرها در ميني&shy;امولسيون&shy;ها استفاده كرد.&nbsp;Chern&nbsp;و&nbsp;Liou&nbsp;از&nbsp;HD&nbsp;به عنوان آبگريز و از &nbsp;&nbsp;&nbsp;poly(methyl methacrylate-<em>b</em>-(diethylamino)ethyl methacrylate)&nbsp;به عنوان&nbsp;Surfactant&nbsp;استفاده كردند و اندازه ذرات بين 150 و 400&nbsp;nm&nbsp;حاصل شد. در پايدار سازي وينيل استات مي توان از&nbsp;PVOH&nbsp;به عنوان&nbsp;Surfactant&nbsp;غير يوني و&nbsp;HD&nbsp;به عنوان آبگريز استفاده كرد.&nbsp;Basker&nbsp;در كاري بسيار جالب در توليد پلي استايرن از كوپليمر&nbsp;Octadecyl acrylate&nbsp;و آكريليك يا متاكريليك اسيد استفاده كرد كه نقش&nbsp;Surfactant&nbsp;و آبگريز را با هم ايفا مي&shy;كند و به لحاظ اقتصادي بسيار مهم است. چون كوپليمر نه در آب و نه در منومر به خوبي حل نمي&shy;شود و مجبور است كه در حد فاصل روغن و آب قرار بگيرند. با تغيير ميزان&nbsp;Surfactant&nbsp;نسبت به منومر مي&shy;توان اندازه ذرات را در بازه زيادي جابجا كرد. شكل زیر، بستگي نوعSurfactant&nbsp;و اندازه ذرات را نشان مي&shy;دهد. لاتكس&shy;هاي حاصله از&nbsp;SDS&nbsp;و&nbsp;cetyltrimethyl ammonium bromide، مستقل از نوع بار&nbsp; كارايي يكساني را نشان مي&shy;دهند. بازده&nbsp;Surfactantهاي غير يوني كمتر است و نمودارهاي آن&shy;ها&nbsp; كلا به درجات بالاتر انتقال يافته&shy; اند.Polydispersity&nbsp;هم براي&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;سيستم&shy;هاي غير يوني&nbsp; پهن تر است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img alt=\"مقایسه انواع پلیمریزاسیون های امولسیونی\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/03.png\" />&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اين به موثرتر بودن پايداري استاتيك نسبت به پايداري استري (steric) مربوط مي&shy;شود. يعني براي پايدار كردن استري به مواد بيشتري نياز است. با اين حال اندازه گيري هاي كشش سطحي لاتكس&shy;ها و تيتراسيون&nbsp;Surfactantها نشان مي&shy;دهند كه ذرات غير يوني كاملا باSurfactant&nbsp;پوشيده نشده&shy;اند و كشش سطحي به خوبي بيشتر از لايه هاي اشباع شده با&nbsp;Surfactant&nbsp;است. به علاوه در سيستم هاي غير يوني ميزان پوشش دهي با كاهش اندازه ذرات افزايش مي&shy;يابد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">براي مطمئن&shy;تر شدن از اطلاعات شكل اخیر در مورد بالاتر بودن بازده&nbsp;Surfactantهاي يوني، در صدد برآمديم تا پايداري استاتيك را با افزودن مقادير مختلف نمك كم كنيم. با افزودن&nbsp;NaCl&nbsp;به ميني&shy;امولسيون مشخص&nbsp;S/HD&nbsp;اندازه ذرات از 80 به200&nbsp;nm&nbsp;رسيد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img alt=\"مقایسه انواع پلیمریزاسیون های امولسیونی\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/04.png\" />&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>تهيه&shy; ي ميني&shy; امولسيون از منومر</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ميني&shy;امولسيون&shy;هاي مناسب براي پليمريزاسيون ميني&shy;امولسيوني ديسپرسيون هاي منومر در آب به اندازه &shy;هاي زير ميكرون هستند كه هم در مقابل افت ناشي از&nbsp;Ostwald ripening&nbsp;و هم تجمع، با يك جزء نامحلول در آب و با وزن مولكولي پايين (Costabilizer) و يك&nbsp;Surfactantمناسب مقاوم شده&shy;اند.&nbsp; نكات كليدي در تهيه &shy;ي ميني&shy;امولسيون از منومرها روش تهيه و فرمول بندي هستند كه در زير به آن&shy;ها مي&shy;پردازيم.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>روش تهيه</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">شكل زير به طور خلاصه روش تهيه ميني امولسيون ها را نشان مي&shy;دهد. سيستم&nbsp;Surfactant&nbsp;در آب و&nbsp;Costabilizer&nbsp;در منومر حل مي شود و همه با هم مخلوط مي شوند. بعد مخلوط تحت يك هموژنايزر با كارايي بالا قرار مي&shy;گيرد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img id=\"Picture_x0020_4\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/05.png\" /></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">روش&shy;هايي ديگري هم گزارش شده&shy;اند. هنگامي كه يك الكل با زنجير طولاني (مانند&nbsp;CA) به عنوان&nbsp;Costabilizer&nbsp;مورد استفاده قرار مي&shy;گيرد، الكل و&nbsp;Surfactant&nbsp;ابتدا در آب در دمايي بالاتر از نقطه ذوب الكل هم زده مي شوند. مخلوط تا دماي محيط سرد مي شود و براي از بين بردن فاز ژل مانند، تحت&nbsp;Sonic&nbsp;قرار مي&shy;گيرد. بعد در هنگام هم زدن منومر اضافه مي شود و مخلوط حاصل براي ميني&shy;امولسيون هموژنيزه، مي شود. اين ايده را ابتدا&nbsp;Ugelstad&nbsp;به كار برد. آنها پي بردند كه الكل مورد نياز براي پايدار كردن سيستم به اين روش كمتر از مقداري است كه ابتدا در منومر حل شود. اما اين روش همانطور كه قبلا هم گفت شد براي مواردي است كه روش هاي هم زدن معمولي به كار مي&shy;رود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Miller&nbsp;نشان داد كه روشي كه اجزا با آن مخلوط مي&shy;شوند (قبل از اين كه هموژنيزه شوند) اثري روي سرعت پليمريزاسيون ندارد. اين نشان مي دهد كه تعداد قطرات ميني&shy;امولسيوني از نوع اختلاط اوليه&shy;ي اجزا تاثير نمي&shy;پذيرد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>اثر آبگريز</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">قبلا هم گفته شد كه اثر مهاجرت مولكولي&nbsp;Ostwald ripening&nbsp;و ناپايداري نانو قطرات را مي&shy;توان با افزودن آبگريز به فاز ديسپرس شده به خوبي كاهش داد. اين مواد هنگامي كه در فاز آلي قرار مي&shy;گيرند، فشار لاپلاس قطرات را خنثي مي&shy;كنند. اين جزء بايد ماده&shy;اي باشد كه نفوذ آن از قطره&shy;ای به قطره&shy;اي ديگر بسيار مشكل باشد و در يك قطره به دام بيفتد. اثر آبگريزها در حفظ پايداري قطرات با مقدار نامحلول آن&shy;ها در فاز پيوسته افزايش مي&shy;يابد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">براي آبگریزها از نام&nbsp;Costabilizer&nbsp;هم استفاده مي&shy;شود. به كار بردن نام&nbsp;Cosurfactant&nbsp;نادرست است، چون در اغلب موارد اين مواد فعال سطحي نيستند.&nbsp;Cosurfactantها موادي هستند كه فعال سطحي هستند و به همراه&nbsp;Surfactant&nbsp;براي كمتر كردن انرژي بين سطحي به كار مي&shy;روند اما به تنهايي نمي&shy;توانند تشكيل مايسل بدهند. با به كارگيري مقادير كافي آبگريز و استفاده از يك فرايند هموژنيزاسيون مي&shy;توان به ميني&shy;امولسيون پايدار رسيد. بعد از عمل هموژنيزه كردن، بايد يك نوع فرايند تعادل سازي سريع اتفاق بيفتد تا پتانسيل شيميايي در هر قطره، كه مي&shy;تواند باعث ايجاد يك فشار باشد، به تعادل برسد. از آن جايي كه تعداد ذرات ثابت هستند، با اين فرايند متوسط اندازه ذرات هم دستخوش تغيير نمي&shy;شود اما توزيع اندازه ذرات تغيير مي&shy;كند. اين فرايند بسيار سريع است و معمولا با آزمايش ثابت نمي&shy;شود. محاسبه مي&shy;شود كه فشار لاپلاس نانوقطره&shy; ها و فشار اسمزي (Osmotic) حاصل از آبگريز هنوز به مقدار زيادي از هم فاصله دارند و فشار لاپلاس هنوز به مقدار قابل توجهي از فشار اسمزي بيشتر است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اگر در بيشترين مقدار اثر&nbsp;Ostwald ripening&nbsp;فشار لاپلاس را با رابطه&shy;ي&nbsp;P<sub>Laplace</sub>=2&gamma;<sub>LL</sub>/R&nbsp;محاسبه كنيم (&gamma;<sub>LL</sub>&nbsp;از روش پوشش دهي سطح حاصل مي شود)، 12 بار مي&shy;شود. فشار اسمزي كه در خلاف جهت فشار لاپلاس عمل مي&shy;كند، از رابطه&shy;ي&nbsp;П<sub>osm</sub>=RT<sub>c</sub>/M&nbsp;محاسبه مي&shy;شود و محاسبه&shy;ي آن، مقدار 5/4 بار را حاصل مي&shy;كند. بنا&shy;براين فشار هر قطره كه منجر به پايداري ترموديناميكي &nbsp;&nbsp;&nbsp;&nbsp;مي&shy;شود صفر نيست اما مجموع قطرات متعادل هستند. فشار لاپلاس با&nbsp;R<sup>-1</sup>&nbsp;تغيير مي&shy;كند در حالي كه فشار اسمزي با&nbsp;R<sup>-3</sup>&nbsp;تغيير مي&shy;كند. بنابراين براي به تعادل رسيدن همه &shy;ي قطرات، يك تغيير در اندازه ذرات رخ مي&shy;دهد. ولي باعث مي&shy;شود كه فشار كل، مقداري مثبت شود. اين باعث مي&shy;شود كه سيستم در مقابل تبادل جرم و به تغييرات اندازه ذرات ايمن شود. مشاهده&shy; ي يك آزمايش نشان مي&shy;دهد كه انداره ذرات ميني&shy;امولسيون&shy;هاي پايدار شده، بعد از مدت زماني طولاني (در مقياس 100 ساعت) بزرگ مي&shy;شوند تا به فشار خالص (P<sub>Laplace</sub>- П<sub>osm</sub>) صفر شود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img alt=\"\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/06.png\" />&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&nbsp;مي&shy;توان با افزودن مقداري&nbsp;Surfactant&nbsp;بعد از مرحله ديسپرسيون پايداري را بيشتر كرد. اين مقدار&nbsp;Surfactant&nbsp;براي كوچكتر كردن اندازه ذرات نيست. بلكه به نواحي خالي نانو قطره&shy; ها جذب مي&shy;شوند و سطح تماس آب و روغن را كاهش مي&shy;دهند و در نتيجه فشار لاپلاس هم كمتر مي&shy;شود. اين ميني&shy;امولسيون ها بعد از ساعت&shy;ها و حتي ماه &shy;ها پايدار مي&shy;مانند. به لحاظ ترموديناميكي پايدار هستند و پتانسيل شيميايي قطرات، مينيمم و براي وقوع واكنش&shy;هاي شيميايي مناسب هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اندازه ذرات قطراتي كه به سرعت پليمريزه مي&shy;شوند، به مقدار آبگريز ربطي ندارد و يا رابطه&shy;ي ضعيفي دارد. يعني اين&shy;طور نيست كه وقتي مقدار آبگريز دو برابر شود، اندازه ذرات نصف شوند. فشار موثر (اختلاف فشار لاپلاس و اسمزي) بايد در همه &shy;ي قطرات يكسان باشد. حداقل مقدار آبگريز نسبت به منومر (نسبت مولي 1به 250) مورد نياز است تا فشار اسمزي كافي حاصل شود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">مشاهده شده كه مقادير اندك از مواد با جرم مولكولي بالا مانند پلي&shy;استايرن مي&shy;تواند در پايدار سازي كمك كند. اما اين پايداري فقط در مرحله&shy;ي پليمريزاسيون است. يك تست ديگر براي اثبات &quot;فشار موثر برابر&quot; ، به اين صورت است: دو ميني&shy;امولسيون با مواد مشابه و با مقادير مختلف آبگريز، با هم مخلوط شدند. قطرات با مقدار كمتر آبگريز كوچكتر شدند و قطراتي كه مقدار بيشتري آبگريز داشتند بزرگ شدند تا زماني كه پتانسيل همه&shy;ي قطرات يكسان شدند. يك ديسپرسيون با دو اندازه ذره حاصل شد ولي تعداد قطرات تغييري نكرد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img id=\"Picture_x0020_1\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/07.png\" /></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">انتخاب آبگريزها بسيار گسترده است.&nbsp;HD،&nbsp;Dyeهاي آبگريز، كومنومرها، پلاستي سايزرها، افزودني هاي ديگر مي توانند استفاده شوند. سيلان&shy;ها سيلوكسان&shy;ها، ايزوسيانات&shy; ها، پلي&shy;استر و آلكان&shy;هاي فلوئوردار هم در جلوگيري از&nbsp;&nbsp;Ostwald ripening&nbsp;موثر هستند. بديهي است كه هر چه تركيب، قابليت انحلال كمتري داشته باشد، مي تواند فشار اسمزي بيشتري توليد كند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><img alt=\"Hydrophobe.bmp\" id=\"Picture_x0020_10\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/employer-polimer/08.png\" /></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Ugelstad&nbsp;نشان داد كه با افزايش طول زنجيره &shy;هاي آبگريز، پايداري ميني&shy;امولسيون افزايش پيدا مي كند.&nbsp;Delgado&nbsp;گزارش داد كه نسبتHD/SDS&nbsp;با نسبت مولي 1 به 4، پايداري خوبي ايجاد مي&shy;كند. كه در برخي موارد رد شد. به هر حال چون&nbsp;HD&nbsp;با&nbsp;SDS&nbsp;در سطح قرار نمي&shy;گيرد و در داخل قطرات است، پيدا كردن نسبت بهينه آن با&nbsp;SDS&nbsp;غير ضروري به نظر مي&shy;رسد.&nbsp;Fontento&nbsp;جزئيات استفاده از پليمر به عنوان آبگريز را توضيح داد. پليمرها به خاطر سازگاري با منومرها و آبگريزي، در بسياري از موارد گزينه&shy; هاي مناسبي هستند. نشاد داده شد كه استفاده از پليمرها به عنوان آبگريز پايداري خوبي براي پليمريزاسيون ايجاد مي&shy;كند.&nbsp;Rumers&nbsp;گفت كه پليمريزاسيون ميني&shy;امولسيوني با افزودن پليمر و يا ذرات ورم كرده پليمر، نتايج يكساني مي&shy;دهد. انتقال جرم بين قطره&shy;اي (بين ذره&shy;اي) با نيروي محركه ترموديناميكي كنترل مي&shy;شود كه مربوط به انرژي بين سطحي و انرژي&shy;هاي هم زدن و تغيير شكل الاستيكي ذره&shy; هاي حاوي پليمر، عامل ورم كننده و يا آبگريز است. اغلب امولسيون&shy;ها، به لحاظ ترموديناميكي ناپايدار هستند اما مي&shy;توان گفت كه به لحاظ سينتيكي پايدار هستند. يعني اثرات مخرب مثلا&nbsp;Ostwald ripening&nbsp;به اندازه&shy;اي كند هستند كه قبل از اين كه مشكلي ايجاد شود، هسته سازي و پليمريزاسيون رخ مي&shy;دهد. يك گزينه ديگر كه همزمان به صورت آبگريز و كوسرفكتانت عمل مي&shy;كند، الكل&shy;هاي زنجيره بلند است. اضافه كردن&nbsp;CA&nbsp;به يك سيستم&nbsp;SDS/آب/روغن، پايداري را نسبت به حالت&nbsp;SDS&nbsp;تنها افزايش مي&shy;دهد. كشش سطحي بين آب و استايرن در حضور مخلوط&nbsp;Surfactantها (SDS/CA&nbsp;و يا&nbsp;CA/CTMA)، بين 5 تا 13&nbsp;mNm<sup>-1</sup>تخمين زده شد. در حالي كه انرژي سطحي ظاهري بين فاز آبي و لايه&shy;ي بين سطحي حاصله، كمتر از 1&nbsp;mNm<sup>-1</sup>&nbsp;بود. يعني با زياد شدن طول زنجير الكل، كشش سطحي هم زياد مي&shy;شود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Lack&nbsp;خواص بين سطحي&nbsp;Cetyl&nbsp;يا&nbsp;Lauryl&nbsp;الكل را بررسي كرد و به اين نتيجه رسيد كه پايداري حاصل از&nbsp;CA&nbsp;فقط به خاطر جلوگيري از نفوذ مولكولي نيست. از آنجایي كه&nbsp;CA&nbsp;كشش سطحي را تحت تاثير قرار مي&shy;دهد، به نظر مي&shy;رسد كه بيشتر به عنوان&nbsp;Cosurfactant&nbsp;عمل مي&shy;كند (همانند چيزي كه در ميكروامولسيون&shy;ها نشان داده شده) تا آبگريز.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Ugelstad&nbsp;و&nbsp;Chou&nbsp;بهترين پايداري ميني&shy;امولسيون استايرن را در نسبت مولي&nbsp;Surfactant&nbsp;يوني به&nbsp;CA&nbsp;1 به 1 و 1 به 3 به دست آوردند.Brouwer&nbsp;اثر حلاليت فاز ديسپرس شده را بر روي ميني&shy;امولسيون حاصل از پخش روغن در فاز ژلي با استفاده از هم زدن ساده بررسي كرد. وي به اين نتيجه رسيد كه با بيشتر شدن حلاليت، ميني امولسيون با&nbsp;CA&nbsp;راحت&shy;تر تهيه مي&shy;شود. اما پايداري كلي آن كاهش مي&shy;يابد.&nbsp;Ugelstadنشان داد كه وقتي كه طول زنجير&nbsp;Costabilizer&nbsp;يا آبگريز افزايش مي&shy;بابد، پايداري ميني&shy;امولسيون زياد مي&shy;شود.&nbsp;Choi&nbsp;اثر طول زنجير الكل و اثر نسبت الكل بلند زنجیر (CA) به&nbsp;SDS&nbsp;به پايداري را، با سانتريفيوژ كردن روغن ديسپرس شده و زمان دادن به آن بررسي كرد. بهترين نتيجه در نسبت&nbsp;CA&nbsp;به&nbsp;SDS، 1 به 3 حاصل شد. و پايداري با ازدياد طول زنجبر الكل چرب افزايش يافت. در مورد&nbsp;CA&nbsp;افزودن مقداري پليمر، فشار اسمزي را زياد مي&shy;كند و پايداري زياد &nbsp;&nbsp;&nbsp;&nbsp;مي&shy;شود.&nbsp;HD&nbsp;و&nbsp;CA&nbsp;براي كاربرد هاي تجارتي نامطلوب هستند. بنابراين اقسام ديگري از آبگريز ها به كار گرفته شدند. براي مثال&nbsp;dodecyl mecaptane&nbsp;(DDM) به عنوان آبگريز و عامل انتقال زنجير عمل مي&shy;كند. ميني&shy;امولسيون&shy;ها با&nbsp;DDM&nbsp;پايداري زيادي را از خود نشان مي&shy;دهند. چون آن ها اثر&nbsp;Ostwald ripening&nbsp;را كاهش مي&shy;دهند. ميني&shy;امولسيون نسبتا پايدار استايرن با استفاده ازDye&nbsp;آبي (Blue 70) آبگريز، با وزن مولكولي پايين حاصل شد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">كومنومرهاي نامحلول هم مي&shy;توانند پايداري خوبي در مقابل نفوذ مولكولي به قطرات بدهند. ميني&shy;امولسيون&shy;هاي استايرن را مي&shy;توان با آبگريزهاي فعال پايدار كرد. اثربخشي اين آبگريزها، به ميزان حلاليت آن&shy;ها بستگي دارد. هر چه آبگريز به ميزان بيشتري در آب قابل حل باشد،Ostwald ripening&nbsp;بيشتر مي&shy;شود. ميزان انحلال پذيري به اين صورت است:&nbsp;CA&gt;DMA&gt;SMA&gt;HD. در مورد&nbsp;DMA، هم اثر نفوذ مولكولي و هم ويسكوز شدن (craming) در دماي 35 درجه سلسيوس ديده مي&shy;شود. در حالي كه براي&nbsp;&nbsp; ميني&shy;امولسيون&shy;هاي حاوي&nbsp;SMA&nbsp;اين طور نيست. قابليت آغازگرهايي با قابليت انحلال خيلي كم مانند&nbsp;Lauryl peroxide&nbsp;(LPO) در حفظ پايداري قطرات منومري و جلوگيري از اثر نفوذ مولكولي بررسي شد و نتايج با&nbsp;Benzoyl peroxide&nbsp;(&zwnj;BPO) و&nbsp;AIBN&nbsp;مقايسه شد و مشاهده شد كه تنها&nbsp;LPO&nbsp;مناسب است. پليمريزاسيون ميني&shy;امولسيوني با استفاده از&nbsp;LPO&nbsp;به عنوان آبگريز انجام شد و نتيجه اين بود كه به اندازه کافی و تا زماني كه پليمريزاسيون آغاز شود، پايدار مي&shy;ماند. اندازه&shy;گيري&shy;هاي پايداري استايرن با استفاده از پايداري&nbsp;Shelf-Life&nbsp;و سانتريفيوژ شديد انجام شد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>اندازه گيري ذرات</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اندازه گيري ذرات پليمر را مي&shy;توان به راحتي به روش پخش نور (Light scattering) و يا روش&shy;هاي ميكروسكوپي انجام داد. چون كه ديسپرسيون ها به راحتي بدون تغيير اندازه ذرات رقيق مي&shy;شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Ugelstad&nbsp;از&nbsp;TEM&nbsp;استفاده كرد.&nbsp;Goetz&nbsp;و&nbsp;El-Aassar&nbsp;از تكنيك&shy;هاي انتشار نور و&nbsp;TEM&nbsp;استفاده كردند.&nbsp;Miller&nbsp;با استفاده از&nbsp;CHDF&nbsp;مشاهده كرد كه در سيستم هاي&nbsp;CA&nbsp;در يك بازه&shy;ي زمان اندازه ذرات به سرعت افزايش مي&shy;يابند و بعد از آن، افزايش اندازه ذرات به آهستگي صورت مي&shy;گيرد. اين مشاهده در مورد سيستم هاي&nbsp;HD&nbsp;ديده نشد. براي آن اندازه&shy;گيري&shy;ها بايد امولسيون را رقيق كرد كه شديدا روي سيستم تغيير ايجاد مي&shy;كند. حتي اگر با آب اشباع شده از منومر هم رقيق سازي انجام شود، به دليل تفاوت در انحلال پذيري، تغييري اندك در اندازه ذرات رخ مي&shy;دهد. برش اعمال شده در روش&nbsp;CHDF&nbsp;هم مي&shy;تواند باعث لخته شدن قطرات شود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اندازه&shy; گيري خواص قطرات امولسيون&shy;ها در محيط&shy;هاي غليظ كار مشكلي است. برخي از روش&shy;هاي غير مستقيم به كار رفتند. مساحت بين سطحي و اندازه ذرات در ميني&shy;امولسيون (آب/SDS/SMA/استايرن) و امولسيون (استايرن/SDS/آب) اندازه&shy;گيري شده، با هم مقايسه شدند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Erden، اندازه ذرات در ميني&shy;امولسيون غليظ را با تيتراسيون صابون، اندازه&shy;گيري كرد و نتايج را با&nbsp;CHDF&nbsp;چك كرد. اندازه ذرات، بدون رقيق كردن سيستم مي&shy;توانند با&nbsp;SANS&nbsp;هم اندازه&shy;گيري شوند. در اين روش سيستم شامل قطرات روغن در آب پروتونه شده است تا&nbsp;Scattering contrast&nbsp;زيادي داشته باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اندازه&shy; گيري فرايندهاي انتقال انجام شده بين قطرات در فاز آبي هم موضوع برخي از مقالات است. جابجايي و تبادل روغن بدون هيچ تاثيري بر روي اندازه ذرات نهايي، انتقال تعادلي با جبراني (Compensated transfer) ناميده مي&shy;شود. انتقال هاي غيرتعادلي، مكانيزم&shy;هاي اصلي پديده&nbsp;Ostwald ripening&nbsp;و لخته شدن هستند. انتقال&shy;هاي غير تعادلي با افزودن آبگريز جلوگيري مي&shy;شوند. اما انتقال&shy;هاي تعادلي همچنان ادامه مي&shy;يابند. در يك مخلوط حاوي قطرات دو امولسيون (يكي&nbsp;tetradecane&nbsp;و ديگري&nbsp;1-bromo tetradecane) نشان داده شد كه انتقال&shy;هاي تعادلي بسيار سريع تر از چيزي هستند كه در&nbsp;Ostwald ripening&nbsp;رخ مي&shy;دهند. دو ميني&shy;امولسيون يكي حاوي&nbsp;MMA&nbsp;و ديگري استايرن به كار رفته&shy; اند كه نشان بدهند منومرها از يك قطره به قطره ديگر انتقال &nbsp;&nbsp;مي&shy;يابند كه البته ابن انتقال ممكن است به خاطر پتانسيل شيميايي متفاوت قطرات باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در جداول زیر کارهای انجام شده بر روی مینی&shy;امولسیون&shy;ها به اختصار آورده شده است:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:justify\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>منبع:</strong></span></span></span></p>\r\n\r\n<p style=\"text-align:justify\">&nbsp;</p>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Jose M. Asua, Miniemulsion polymerization, Institute for Polymer Materials (POLYMAT) and Grupo de Ingenierta Qutmica, Facultad de Ciencias Qufmicas, The University of the Basque Cmmtry, Apdo 1072, 20080 Donostia-San Sebastian, Spain, Progress in polymer science, 2002</span></span></li>\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Markus Antonietti, Katharina Landfester, Polyreactions in miniemulsions, Max Planck Institude of Colloids and Interfaces, Research campus Golm, D-14424 Potsdam, Germany, Progress in polymer science, 2001</span></span></li>\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Jianli Wang, Zhongjie Du, Congju Li, Hangquan Li, Chen Zhang, A Study on Formation and Stability of Epoxy Resin Inverse Concentrated Water/Oil Emulsion, The Key Laboratory of Beijing City on Preparation and Processing of Novel Polymer Materials, Beijing University of Chemical Technology, Beijing 100029, People&rsquo;s Republic of China, Wiley InterScience, 2008</span></span></li>\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Frederick H. Walker, John B. Dickenson, Charles R. Hegedus, Frank R. Pepe,&nbsp;Cationic polymerization of emulsified epoxy resins, Air Products and Chemicals, Inc., 7201 Hamilton Blvd., Allentown, PA 18195-1501, USA, Progress in organic coatings, 2002</span></span></li>\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Zhenzhong Yang, Delu Zhao, Mao Xu, Yuanze Xu, Mechanistic investigation on the formation of epoxy resin multi-hollow spheres prepared by a phase inversion emulsification technique,&nbsp;Polymer Physics Laboratory, Center for Molecular Science, Institute of Chemistry, The Chinese Academy of Sciences,</span></span></li>\r\n</ol>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Beijing 100080, China, Marcomolecular rapin Communications, 2000</span></span></p>\r\n\r\n<ol start=\"6\">\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Kenichi Hibino, Yoshiharu Kimura, Particle Formation of Epoxy Resin in Aqueous Emulsion State, EC Intracorporation, Sanyo Chemical Industries, Ltd., 11-1 Ikkyonomoto-cho, Higashiyama-ku, Kyoto 605-0995, Japan, Marcomolecular materials and engineerin, 2001</span></span></li>\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">HIDEAKI KAWAHARA, TOKIO GOTO, KIYOSHI OHNISHI, HIRONAO OGURA, HIROYUKI KAGE, YOSHIZO MATSUNO, Preparation of Epoxy Resin/Acrylic Composite Latexes by Miniemulsion Polymerization Method, Kansai R&amp;D Center, Dainippon Ink &amp; Chemicals, Inc., 1-3, Takasago, Takaishi, Osaka 592-0001, Japan, 2000</span></span></li>\r\n	<li style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Zhang Zhaoying, Huang Yuhui , Liao Bing, Cong Guanglning, Studies on particle size of waterborneemulsions derived from epoxy resin, G!langzllOu Institute of Chemistry, Chinese Academy of Sciences, Guangzhou 510650, People&#39;s Republic of China, European Polymer Journal, 2000</span></span></li>\r\n</ol>\r\n\r\n<p dir=\"RTL\" style=\"text-align:justify\">&nbsp;</p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">A 103: polyoxyethylenated nonylphenol half ester of sulphosuccinic acid;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">AA: acrylic acid;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Alipal CO-436: ammonium salt of sulfated nonylphenoxy poly(ethylenoxy) ethanol;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">AMBN: 2,2&#39;-azobis(2-methylbutyronitrile);</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">BA: buryl arylate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Brij 35: C<sub>I2</sub>H<sub>25</sub>-O-(C<sub>2</sub>H<sub>4</sub>O)<sub>23</sub>;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">CA: cetyl alcohol;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">DDM: dodecyl mercaptane;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">DMA: dodecyl methacrylate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">DMAEMA: dimethyl amino ethyl methacrylate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">Dowfax 8390: disulfonated alkyl diphenyl oxid Sodium salt;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">EHA: ethylhexyl acrylate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">EHMA: ethylhexyl methacylate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">HD: hexadecane;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">LPO: lauroyl peroxide;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">MAA: methacrylic acid;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">miniEP: miniemulsion polymerization;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">MMA: methyl methacrylate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">n-DM: n-dodecyl mercaptan;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">NP-40: nonyl polyethoxylate with 40 EOs per molecule;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">NE-40: polymerizable nonyl polyethoxylate with 40 EOs per molecule;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">OPB: octadecyl pyridinium bromide;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">PB/Et-<em>co</em>-PEO: poly(butylene/ethylene-<em>co</em>-ethyleneoxide);</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">PMMA: poly(methyl methacrylate);</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">pMMA-b-DMAEMA: poly(methyl methacrylate-b-2-(dimethylamino)&nbsp;ethyl methacrylate block copolymer;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">PS: polystyrene;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">PVOH: polyvinyl alcohol;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">S: styrene;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">SDS: sodium dodecyl sulfate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">SHS: sodium hexadecyl sulfate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">SLS: sodium lauryl sulfate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">SMA: stearyl methacrylate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">VAc: vinyl acetate;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">VC: vinyl chloride;</span></span></p>\r\n\r\n<p style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">?: not disclosed</span></span></p>','/app/articles/1529425858221.jpg','/app/articles/1529425858182.jpg','سوسپانسيون­ها','مقایسه-انواع-پلیمریزاسیون-های-امولسیونی',1237,2,1,'2018-06-19 21:00:58','2022-01-10 12:37:56'),(3,2,'انواع رزین های اپوکسی','استفاده مواد شیمیایی مانند رزین­های اپوکسی به حدود 50 سال پیش بر می­گردد و امروزه از پرکاربردترین مواد شیمیایی در مصارف مختلف هستند','<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">استفاده تجاری از رزین&shy;های اپوکسی به حدود 50 سال پیش بر می&shy;گردد و امروزه از پرکاربردترین مواد در مصارف مختلف هستند. استفاده از آن&shy;ها تنها به صنایع پوششی محدود نمی&shy;شود و در صنایع مختلف مانند هوافضا، مهندسی عمران، صنایع اتومبیل، صنایع شیمیایی، صنایع دریایی و بسیاری دیگر از صنایع به دو صورت خود خشک شونده و گرما خشک به کار می&shy;روند. جدول 1-1 از شرکت&nbsp;Shell&nbsp;تهیه شده و به خوبی گویای استفاده وسیع از این سری رزین&shy;ها می&shy;باشد (جدول 1-1 لیست برخی کاربردها برای رزین های اپوکسی). همان&shy;طور که در جدول 1-1 مشاهده می&shy;شود رزین&shy;های اپوکسی به شدت مستعد این هستند که در صنایع مختلف جای خود را باز کنند. اهمیت رزین&shy;های اپوکسی در دو صنعت پوشش&shy;های سطح و مهندسی عمران بیشتر است و مقادیر استفاده از این رزین در این دو صنایع تقریبا برابر است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین&shy;های اپوکسی در دسته &shy;ی رزین&shy;های مصنوعی و گران&shy;قیمت هستند و بنابراین رزین&shy;های همه کاره محسوب نمی&shy;شوند. یعنی استفاده از آن&shy;ها باید توجیه کافی برای قیمت اضافی&shy;شان را داشته باشد. تقریبا در همه&shy; موارد رزین&shy;های اپوکسی مقاومت شیمیایی و خوردگی خوبی از خود نشان می&shy;دهند و اگر این خصوصیات لازم نباشند فرمولاتور می&shy;تواند از رزین&shy;های ارزان&shy;تر دیگر استفاده کند و از آنجایی که مقاومت خوردگی خصوصیتی است که معمولا با رزین&shy;های دیگر فراهم نمی&shy;&shy;شود، یکی از کاربردهای عمده &shy;آن&shy;ها در تولید پوشش&shy;های ضد خوردگی است. خصوصیت دیگری که فیلم های دارای رزین&shy;های اپوکسی از خود نشان می&shy;دهند مقاومت الکتریکی است و از آن&shy;ها در کاربردهای الکتریکی از قبیل ساخت بردهای الکتریکی و تماس مستقیم با قطعات الکترونیک استفاده می&shy;شود. اولین تلاش&shy;ها برای تولید صنعتی رزین&shy;های اپوکسی، در سال 1927 در ایالات متحده امریکا&nbsp; شروع شد. اما کسانی که رزین اپوکسی را به روشی که امروزه بیشترین راه تولید آن&shy;ها است به دست آوردند،&nbsp;Dr P. Castan&nbsp;از سوئیس و&nbsp;Dr S. Greenlee&nbsp;از امریکا بودند که این کار را با استفاده از&nbsp;Bisphenol A&nbsp;و&nbsp;Epichlorohydrin&nbsp;انجام دادند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">می&shy;توان گفت که رزین&shy;های اپوکسی از سال 1948 به صورت تجاری در دسترس بوده&shy;اند و مصرف جهانی اپوکسی&shy;ها در سال 1990، 550000 تن بوده است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"color:#FF8C00\"><strong><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">پوشش&shy;های سطحی را که با استفاده از رزین&shy;های اپوکسی تهیه می&shy;شوند می&shy;توان به دسته&shy; های زیر دسته بندی کرد.</span></span></strong></span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">-رنگ&shy;های یک جزئی یا دو جزئی که در دمای محیط&nbsp;Cure&nbsp;می&shy;شوند.</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">-رنگ&shy;هایی که در دمای بالا پخت می&shy;شوند.</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">- پوشش&shy;های قوطی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">- رنگ&shy;های خودرویی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">- پوشش&shy;های پودری</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">-پوشش&shy;ها و جوهرهای تابش پخت</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">روش&shy;های اعمال پوشش&shy;های حاوی رزین اپوکسی بسیار متنوع هستند. این روش&shy;ها شامل روش&shy;های با تکنولوژی بالا&nbsp; مانند الکترودیپوزیشن و اسپری الکترواستاتیک برای پوشش&shy;های پودری و یا روش&shy;های معمولی اسپری مایع و روش&shy;های با تکنولوژی پایین مانند استفاده از فرچه و یا رول است. برای مثال قوطی&shy;های مایعات با سرعت 2000 قوطی در دقیقه پوشش داده می&shy;شوند. بنابراین یک روش سریع و سرعت پخت بالا مورد نیاز است. برای لاک&shy;های پایه&shy;آبی در استفاده داخلی معمولا روش اسپری کردن و پخت با گرما به کار می&shy;رود. تجهیزات کشتی&shy;ها اغلب با رنگ&shy;های دو جزئی پخت شونده در محیط (و یا در دماهای پایین) و به روش دستی رنگ می&shy;شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بدنه ماشین&shy;ها ابتدا برای پرایمر به روش الکترودیپوزیشن و بعد با پخت حرارتی پوشش داده می&shy;شوند. رنگ&shy;های رویه&shy; اتومبیلی (که شامل رزین اپوکسی نیستند) می&shy;توانند به روش&shy;های معمولی اسپری شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین&shy;های اپوکسی در دو حالت جامد و مایع یه صورت تجاری موجود هستند. به طور کلی با بالا رفتن جرم مولکولی نقطه&shy; ذوب بالا می&shy;رود. گریدهای مختلف رزین اپوکسی گرانروی&shy;های مختلف دارد و برای کم کردن ویسکوزیته می&shy;توان آن&shy;ها را در حلال&shy;های آلی و یا رقیق کننده&shy;های فعال حل کرد. بعضی از اقسام رزین&shy;های اپوکسی امولسیونی هم موجود هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">مولکول&shy;های رزین&shy;های اپوکسی حداقل یک و معمولا دو (و یا بیشتر) گروه اپوکسی دارند. معمولا رزین&shy;های اپوکی با جرم مولکولی بالاتر همان واحد تکرار شونده&shy; ی اصلی را دارند. رزین&shy;های اپوکسی که امروزه به صورت تجاری استفاده می&shy;شوند بر پایه&shy; ی دی&shy;اپوکساید کردنBisphenol A&nbsp;(دی&shy;فنیل پروپان و یا&nbsp;DPP) هستند. این رزین&shy;ها از واکنش کندانسیون اپی&shy;کلروهیدرین و&nbsp;Bisphenol A&nbsp;حاصل می&shy;شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">علاوه بر مقاومت&shy;های خوردگی و شیمیایی عالی، رزین&shy;های اپوکسی چسبندگی و خواص مکانیکی خوبی هم از خود نشان می&shy;دهند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین&shy;های اپوکسی فقط به تنهایی و با عامل پخت به کار نمی&shy;روند. بلکه با واکنش&shy;های شیمیایی مختلفی اصلاح می&shy;شوند. برخی از دلایل این اصلاحات به شرح زیر است.</span></span></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در برخی موارد برای رفع شکنندگی فیلمی که از 100% رزین اپوکسی تهیه شده است.</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">کاهش قیمت در فرمولاسیون 100% رزین اپوکسی</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">افزودن برخی خواص شیمیایی و مقاومت خوردگی رزین اپوکسی به سیستم&shy;های رزینی دیگر</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">افزایش مقاومت شیمیایی و خوردگی فیلم پخت شده&shy; ی نهایی</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بهبود مقاومت در برابر هوازدگی (مخصوصا گچی شدن) در رزین اپوکسی خالص</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ایجاد حلالیت در آب</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><strong><span style=\"color:#008000\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ایجاد خاصیت تابش&shy; پزی در رزین اپوکسی</span></span></span></strong></p>\r\n\r\n<p style=\"text-align: right;\">&nbsp;</p>\r\n\r\n<p style=\"text-align: right;\">&nbsp;</p>\r\n\r\n<ol>\r\n	<li>\r\n	<ol>\r\n		<li dir=\"RTL\" style=\"text-align: right;\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>ویژگی&shy;های رزین&shy;&nbsp;اپوکسی</strong></span></span></span></li>\r\n	</ol>\r\n	</li>\r\n</ol>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>1-2-1- خصوصیات مکانیکی رزین&shy;های اپوکسی بر پایه&shy; </strong><strong>BA</strong></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">کاربرد رزین&shy;های اپوکسی از زمان تولیدشان به شدت رو به رشد است و پر کاربردترین آن&shy;ها، رزین&shy;های اپوکسی بر پایه&nbsp;BA&nbsp;هستند که در ساختار خود دارای گروه&shy;های هیدروکسیل و گلایسرول هستند. مقاومت شیمیایی آن&shy;ها به خصوص در محیط&shy;های اسیدی و بازی عالی است. به علاوه این رزین&shy;ها سختی بالایی دارند و مقاومت خوبی به آب و حرارت از خود نشان می&shy;دهند. رزین&shy;های اپوکسی بعد از پخت خاصیت جمع شدگی (Shrinkage) کمی از خود نشان می&shy;دهند و در صنایع مختلف از جمله صنایع چسب، الکترونیک و صنایع پوششی و ... به کار می&shy;روند. (3)</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین&shy;های اپوکسی از مایعات ویسکوز تا جامدات سخت و شکننده وجود دارند. رزین با کمترین جرم مولکولی که به صورت تجاری به کار می&shy;رود،DGEBA&nbsp;است که ساختاری کریستالی و نقطه &shy;ی ذوبی زیر 5 درجه سلسیوس دارد و مثلا در یک روز سرد، این می&shy;تواند ایجاد مشکل بکند. همه &shy;ی&nbsp;DGEBAها در دمای معمولی مایعاتی خیلی ویسکوز هستند. رابطه &shy;ی ویسکوزیته با دما در یک نمونه&shy; ی تجاری&nbsp;DGEBA&nbsp;در شکل&nbsp;&nbsp; نشان داده شده است. دقت شود که محور ویسکوزیته لگاریتمی است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">همان&shy;طور که دیده می&shy;شود، هنگامی که دما از 20 دجه به 45 درجه سلسیوس می&shy;رسد، ویسکوزیته از 30pa.s&nbsp;&nbsp;به کمتر از 1&nbsp;pa.s&nbsp;&nbsp;&nbsp;می&shy;رسد و این باعث می&shy;شود که اعمال کردن آن&shy;ها به راحتی امکان&shy;پذیر نباشد. به دلیل همین ویژگی آن&shy;هاست که می&shy;توان رزین&shy;های اپوکسی مایع بدون حلال را (که معمولا با آمین&shy;های بدون حلال و یا عوامل پخت پلی&shy;آمین پخته می&shy;شوند) با اسپری اعمال کرد. یک راه دیگر این است که سیستم اپوکسی را قبل از اعمال کردن با فرچه و یا رول گرم کرد. البته باید ذکر شود که گرم کردن هر سیستم دو جزئی باعث کم شدن&nbsp;Pot Life&nbsp;سیستم خواهد شد.و این باعث می&shy;شود که سیستم رزین زودتر هم گخته گردد. این کم کردن ویسکوزیته باعث بهتر شدن ظاهر فیلم هم می&shy;شود. چون با کم شدن ویسکوزیته خاصیت جاری شدن بهتر&nbsp; می&shy;شود و بعد بلافاصله ویسکوزیته به دلیل واکنش&shy;های پخت بالا می&shy;رود. انواع رزین&shy;های اپوکسی مایع با ویسکزیته&shy;های پایین&shy;تر هم موجود هستند که ساختارهای کریستالی در آن کم شده و یا از بین رفته است.&nbsp;Epikote 828LVنمونه&shy;ای از آن&shy;هاست که در دمای 25 درجه سلسیوس، ویسکوزیته&shy;ای در بازه &shy;ی 10 &ndash; 12&nbsp;pa.s&nbsp;&nbsp;دارد و این در مقایسه با نمونه&shy;های معمولی است که در همان دما ویسکوزیته&shy;اش 12 &ndash; 14&nbsp;pa.s&nbsp;&nbsp;است. اگر در برخی موارد، بالا بردن دما برای کاهش ویسکوزیته کارساز نباشدف یک راه افزودن حلال است که با رویکردهای صنعت امروز سازگار نیست. مخصوصا این که این حلال&shy;ها معمولا&nbsp;Flash Point&nbsp;پایین دارند. مانند استون و یا&nbsp;MEK. رزین&shy;های اپوکسی در حلال&shy;های کتونی با جایگزینی&nbsp;Cellosolve&nbsp;(propoxylated and&nbsp;ethoxylated ethers) قابل تهیه هستند. برای رزین&shy;های اپوکسی حلال&shy;های نسبتا قوی و قطبی مورد نیاز است و هر چه جرم مولکولی بالاتر برود، حلال قوی&shy;تری ورد نیاز است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">راه دیگر استفاده از رقیق کننده&shy;های غیر آتشگیر و یا پلاستی&shy;سایزرها است. در این&shy;جا مشکل پایین بودن&nbsp;Flash&nbsp;Point&nbsp;حلال&shy;ها وجود ندارد. پلاستی&shy;سایزرها مایعاتی تقریبا ویسکوز هستند. در سال&shy;های گذشته استفاده از یک رقیق کننده فعال در یک سیستم حاوی&nbsp;DGEBA&nbsp;بسیار معمول بود. یک رقیق کننده فعال همان&shy;طور که از اسم آن پیدا است به عنوان یک رقیق کننده عمل می&shy;کند (نه حلال) و در فرایند پخت با رزین اپوکسی و عامل پخت رسوب می&shy;کند و یک فیلم تشکیل می&shy;دهد. به دلیل خاصیت تحریک کنندگی بسیاری از رقیق کننده&shy;های فعال این روش کنار گذاشته شده است و به جای آن&shy;ها از رقیق کننده&shy;های جدید استفاده می&shy;شود. این رقیق کننده&shy;ها نوعا گلایسیدیل&shy;اترهای آلیفاتیک هستند که یک گروه اپوکساید دارند مانند&nbsp;butyl glycidyl ether&nbsp;و یا گلایسیدیل&shy;های آروماتیک مانند&nbsp;phenyl glycidyl ether. شکل زیر اثرات برخی از رقیق کننده&shy;های فعال بر ویسکوزیته را نشان می&shy;دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>1-2-2- سمی بودن و خاصیت سرطان&shy;زایی رزین&shy;های اپوکسی بر پایه &shy;ی&nbsp;</strong><strong>Bisphenol A</strong><strong>&nbsp;و&nbsp;</strong><strong>Epichlorohydrin</strong></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در طول سالیان رزین&shy;های اپوکسی بسیار مورد بررسی&shy;های امنیتی قرار گرفته &shy;اند. زمینه&shy;ای که تا نیمه&shy;های سال&shy;های 1995 بسیار مورد توجه قرار گرفته است، سرطان&shy;زا بودن&nbsp;BA&nbsp;است که ماده شروع کننده در تولید بسیاری از رزین&shy;های اپوکسی است که امروزه در صنایع پوششی به کار برده می&shy;شود. به خصوص در مواردی که رزین در تماس مستقیم با مواد غذایی قرار می&shy;گیرد. مانند لاک&shy;های درون قوطی&shy;ها و یا عایق بندی تانک&shy;های آب.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">مشخص است که مقادیر واکنش نداده&shy; ی&nbsp;BA&nbsp;می&shy;توانند از پوشش پخت شده به درون مواد غذایی مهاجرت کنند. مطالعات داروشناسی و پزشکی و ارزیابی&shy;های عملی نشان می&shy;دهد که این مواد می&shy;توانند تعداد اسپرم&shy;ها را در مردان کم کنند و حتی ژنتیک آن&shy;ها را تحت تاثیر قرار دهند. اما مطالعات نشان می&shy;دهند سرطان&shy;هایی هستند که به طور طبیعی رخ می&shy;دهند و تعداد آن&shy;ها بسیار بیشتر از چیزی است که&nbsp;BA&nbsp;باعث آن می&shy;شود و به علاوه تحقیقات نشان می&shy;دهد که بسیاری دیگر از مواد شیمیایی که در صنعت استفاده می&shy;شوند خاصیت سرطان&shy;زایی بیشتری از خود نشان می&shy;دهند. نکته&shy;ای که وجود دارد این است که در تهیه این رزین&shy;ها باید دقت کافی صورت گیرد تا مقادیر اضافی&nbsp;BA&nbsp;در سیستم باقی نماند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">تحقیقات جدید نشان می&shy;دهند که می&shy;توان رزین&shy;های اپوکسی با جرم مولکولی بالاتر را از رزین اپوکسی مایع (DGEBA) در حضور کاتالیزور سوپر اسید و بدون نیاز به&nbsp;BA&nbsp;تهیه کرد. ساختارهای رزین&shy;های اپوکسی جدید با ساختار رزین&shy;های اپوکسی قدیمی که به روش&shy;های قدیمی تهیه می&shy;شوند تفاوت دارند و این محصول بسیار کمتر از رزین&shy;های اپوکسی قدیمی&nbsp;Bisphenol A&nbsp;آزاد دارند که نکته مهمی برای تولید کنندگان قوطی برای نوشیدنی&shy;ها و غذاها است. (2)</span></span></p>\r\n\r\n<p style=\"text-align: right;\">&nbsp;</p>\r\n\r\n<p style=\"text-align: right;\">&nbsp;</p>\r\n\r\n<ol>\r\n	<li>\r\n	<ol start=\"2\">\r\n		<li dir=\"RTL\" style=\"text-align: right;\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><strong>شیمی رزین&shy;های اپوکسی</strong></span></span></span></li>\r\n	</ol>\r\n	</li>\r\n</ol>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اغلب رزین&shy;های اپوکسی که برای استفاده تجاری پوشش&shy;های سطح مایع به کار می&shy;روند، بر پایه ی&nbsp;Diglycidyl Bisphenol A&nbsp;هستند که با بالا رفتن جرم مولکولی، حالت جامد به خود می&shy;گیرند. این رزین&shy;ها از واکنش تراکمی اپی&shy;کلروهیدرین (ECH) &nbsp;با دی&shy;فنیلول&shy;پروپان (DPP) و در حضور کاتالیزور حاصل می&shy;شوند و در شکل زیر آورده شده&shy;اند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">واکنش کوپلینگ&nbsp;BA&nbsp;و&nbsp;ECH، یک فرایند سه مرحله&shy;ای تلقی می&shy;شود. ابتدا&nbsp;DPP&nbsp;با سدیم هیدروکسید واکنش می&shy;دهد و یون فنوکساید را حاصل می&shy;کند که با&nbsp;ECH&nbsp;&nbsp;واکنش می&shy;دهد و بعد با&nbsp;DPP&nbsp;واکنش می&shy;دهد تا دوباره یک یون فنوکساید و گلایسیرول&shy;کلروهیدرین تولید کند. شکل 2-2 به صورت شماتیک این مراحل را نشان می&shy;دهد. (2-2)</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">گلایسیرول&shy;کلروهیدرین (شکل 2-1، ساختار 1) در محیط قلیایی ناپایدار است و به سرعت تخریب شده و یک گروه اپوکساید و سدیم کلرید حاصل می&shy;کند. (شکل 1-2، سلختار 2). واکنش&nbsp;BA&nbsp;با&nbsp;ECH&nbsp;سک واکنش حلقه گشایی گروه اپوکساید است که یک باند اتری و گروه هیدروکسیل نوع دوم حاصل می&shy;کند و برخی موارد به ماده واسطه 1و2گلایسیرول&shy;کلروهیدرین اتلاق می&shy;شود. در حضور سدیم هیدروکسیل این واکنش این واکنش به شدت گرمازا است. ساختار 2 منواپوکساید در شکل 1-2 دوباره می&shy;تواند با&nbsp;ECH&nbsp;ویا&nbsp;BA&nbsp;با ساختار 1 و یا 2 در شکل 2-1 واکنش دهد. هنگامی که&nbsp;Diglycidyl Bisphenol A&nbsp;مایع که معمولا با&nbsp;DGEBA&nbsp;نمایش داده می&shy;شود حاصل شد، ساختار 2 یا 3 در شکل 1-2. واکنش&nbsp;BA&nbsp;می&shy;تواند ادامه یابد و منجر به تولید گونه&shy;هایی با جرم مولکولی بالاتر شود. گروه&shy;های قطبی مانند اپوکسی و هیدروکسیل باعث خواص چسبندگی عالی رزین&shy;های اپوکسی می&shy;شوند. قطعه&shy;های آلیفاتیک میان پل&shy;های اتری انعطاف&shy;پذیری زنجیره را فراهم می&shy;آورند. هر دو گروه&shy;های اپوکسی و هیدروکسی می&shy;توانند در واکنش&shy;های بعدی و مخصوصا واکنش&shy;های پخت شرکت کنند. رزین&shy;های اپوکسی لزوما خطی نیستند و گروه&shy;های انتهایی آن&shy;ها لزوما اپوکساید نیست. اگر از&nbsp;ECH&nbsp;به میزان کمتری استفاده شود، رزین حاصل خطی&shy;تر خواهد بود و در صورتی که میزان&nbsp;ECH&nbsp;بیشتر شود واکنش&shy;های شاخه&shy;ای شدن بیشتر می&shy;شوند. مولکول&shy;های شاخه&shy;ای شده می&shy;توانند به شکل زیر باشند. (2-3)</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در شکل زیر دو ساختار شبکه&shy;ای ممکن نمایش داده شده است. گروه&shy;های اتراپوکسی و یا هیدروکسی هستند. مقدار و درجه شبکه&shy;ای شدن از رزینی به رزین دیگر فرق می&shy;کند و بستگی به تولید کننده دارد. همین&shy;طور&nbsp;functionality&nbsp;(تعداد مولکول&shy;های اپوکساید در مولکول) رزین&shy;های اپوکسی مورد استفاده در پوشش&shy;های سطح از بالای 9/1 برای&nbsp;DGEBA&nbsp;تا 1 برای رزین&shy;های با جرم مولکولی بالاتر کاهش می&shy;یابد. در نتیجه&shy; ی فرایند تولید، گروه&shy;های انتهایی مختلفی به وجود می&shy;آیند که ممکن است شامل گروه&shy;های فنلیک &shy;هیدروکسیل اصلاح شده، گروه&shy;های کلروهیدرین تبدیل شده و گلایکول&shy;های تشکیل شده از شکسته شدن گروه&shy;های اپوکساید باشد. وجود گروه&shy;های هیدروکسیل چه در ساختارهای خطی و چه در ساختارهای شبکه&shy;ای در بسیاری موارد در واکنش&shy;های پخت اهمیت ویژه&shy;ای دارند. یک واکنش جانبی ناخواسته، اضافه شدن گروه فنلیک و تولید 1و3کلروهیدرین است که برگشت&shy;پذیر نیست و منجر به تولید یک رزین اپوکسی باجرم مولکولی بالا و&nbsp;functionality&nbsp;کم می&shy;شود. باند گروه کلرین می&shy;تواند در واکنش&shy;های پخت مشکلاتی ایجاد کند و رزین حاصل در مقابل حرارت زرد می&shy;شود و دارای خواص الکتریکی خواهد بود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزینهای اپوکسی از واکنش&shy;های پیشرفت دادن&nbsp;DGEBA&nbsp;هم حاصل می&shy;شوند محصول، رزین&shy;هایی با درجات مختلف شبکه&shy;ای شدن است و مانند رزین&shy;های تجاری با جرم مولکولی بالا&nbsp;Difunctionality&nbsp;نیستند. علاوه بر تفاوت در گروه&shy;های انتهایی، میزان مواد غیرآلی نظیر سدیم کلرید (که از واکنش سدیم هیدروکسیل با رسوبات&nbsp;ECH&nbsp;حاصل می&shy;شود) در آن&shy;ها بیشتر است که این در برخی از کاربردها نظیر مصارف الکتریکی مهم است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین&shy;های اپوکسی برای پوشش&shy;های پودری نسبت به رزین&shy;های با تعداد واحد تکرار مشابه، توزیع جرم مولکولی باریک&shy;تری دارند. این برای رسیدن به نقطه ذوب دقیق&shy;تر و خواص جریان&shy;پذیری بهتر است. اغلب رزینهای اپوکسی برای مصارف پوشش&shy;های پودری از یک فرایند دو مرحله&shy;ای به دست می&shy;آیند. بعد از تشکیل&nbsp;DGEBA&nbsp;با جرم مولکولی پایین در مرحله بعد با استفاده از مقدار محاسبه شده دقیق&nbsp;BA&nbsp;و کاتالیزور پیشرفت داده می&shy;شود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">نسبت&nbsp;ECH&nbsp;به&nbsp;BA&nbsp;مقدار پیشرفت واکنش و در نتیجه مقدار&nbsp;n&nbsp;را تعیین می&shy;کند. هنگامی که مقدار&nbsp;n&nbsp;افزایش می&shy;یابد نقطه&shy; ی ذوب رزین افزایش می&shy;یابد. جدول زیر تعدادی رزین با مشخصات آن&shy;ها را که مربوط به انتشارات شرکت&nbsp;Shell&nbsp;است نشان می&shy;دهد. (جدول 2-1)</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">همیشه این&shy;طور نیست که با بالا رفتن جرم مولکولی تعداد واحدها زیاد می&shy;شوند ولی فرایند افزودن&nbsp;BA&nbsp;به&nbsp;DGEBA&nbsp;که معمولا به پیشرفت یک رزین اپوکسی تلقی می&shy;شود، گروه&shy;های عاملی هیدرکسیل را ایجاد می&shy;کند که در واکنش&shy;های پخت بسیار مهم هستند. ذکر این نکته ضروری است که به عنوان یک تقریب اولیه تعداد گروه&shy;های اکسیران در واحد مولکولی اپوکسی در 2 ثابت می&shy;ماند و لی تعداد گروه&shy;های هیدروکسیل در واحد مولکول اپوکسی با افزایش&nbsp;n&nbsp;افزایش می&shy;یابد. برای ساده&shy;سازی گفته می&shy;شود که در هر پیشرفت یک گروه هیدروکسیل وجود دارد. تغییرات درصدهای اپوکسی به هیدروکسیل با افزایش جرم مولکولی به طور خلاصه در شکل 2-4 آورده شده است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اغلب رزین&shy;های اپوکسی مورد استفاده در پوشش&shy;های سطح،&nbsp;EEWهای (وزنی از رزین که حاوی یک مول گروه اپوکساید است) بین 180 تا 3200 دارند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">به عنوان دستورالعمل کلی برای کاربردهای مختلف،</span></span></p>\r\n\r\n<ul>\r\n	<li dir=\"RTL\" style=\"text-align: right;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین&shy;های اپوکسی با&nbsp;EEW&nbsp;در بازه&shy; ی 180 تا 475 بیشتر در سیستم&shy;های دوجزئی پخت شوند در دمای محیط و یا دمای پایین استفاده می&shy;شود. همچنین از آن&shy;ها برای شروع واکنش&shy;های پیشرفت و یا در تولید اپوکسی-اکریلات&shy;های تابش پخت استفاده می&shy;شود.</span></span></li>\r\n	<li dir=\"RTL\" style=\"text-align: right;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اپوکسی رزین&shy;های با&nbsp;EEWهای در بازه&shy; ی 700 تا 1000 برای تولید اپوکسی-استرها به کار می&shy;روند.</span></span></li>\r\n	<li dir=\"RTL\" style=\"text-align: right;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اپوکسی رزین&shy;های با&nbsp;EEW&nbsp;در بازه&shy; ی 1500 تا 3200 برای لایه&shy;های نهایی کوره پخت استفاده می&shy;شود.</span></span></li>\r\n	<li dir=\"RTL\" style=\"text-align: right;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین&shy;های اپوکسی با نقطه&shy; ی ذوب در بازه&shy; ی 80 &ndash; 100 درجه سلسیوس در تولید پوشش&shy;های پودری به کار می&shy;روند و این خاصیت از رزین&shy;های با&nbsp;EEW&nbsp;حدود 830 انتظار می&shy;رود.</span></span></li>\r\n	<li dir=\"RTL\" style=\"text-align: right;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اپوکسی رزین&shy;های با&nbsp;EEW&nbsp;در بازه&shy; ی 2500 تا 3200 برای تولید پوشش&shy;های قوطی به کار می&shy;روند ولی در بسیاری موارد یک رزین اپوکسی مایع با&nbsp;EEW&nbsp;180 تا 475 برای رسیدن به این&nbsp;EEW&nbsp;پیشرفت داده می&shy;شود.</span></span></li>\r\n</ul>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">تولید کنندگان رزین&shy;های اپوکسی واکنش&shy;های پیشرفت اپوکسی را انجام می&shy;دهند. ولی بعضی از مصرف کنندگان&nbsp;DGEBA&nbsp;را از تولید کنندگان می&shy;گیرند و واکنش&shy;های پیشرفت را از آن آغاز می&shy;کنند. برخی تولید کنندگان اپوکسی مانند&nbsp;Shell&nbsp;و&nbsp;Dow،&nbsp;DGEBA&nbsp;را با کاتالیزور عرضه می&shy;کنند. دو علت وجود دارد که چرا کارخانه&shy;ها ترجیه می&shy;دهند که واکنش&shy;های پیشرفت را خودشان انجام دهند. اول این که کارخانه&shy;ها می&shy;توانند رزین اپوکسی را دقیقا با همان درجه&shy;ای که لازم دارند تولید کنند. دوم این که با توجه به قیمت&nbsp;BA، قیمت رزین اپوکسی حاصل کاهش می&shy;یابد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در واکنش پیشرفت رزین اپوکسی نسبت بیشتر مقادیر زوج تعداد واحدهای تکرار (n) بسیار مناسب&shy;تر از مقادیر فرد برای آن هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">برای واکنش با هر مولکول&nbsp;BA&nbsp;باید دو مولکول اپوکسی موجود باشد. نسبت&nbsp;BA&nbsp;به&nbsp;DGEBA&nbsp;معلوم &nbsp;می&shy;کند که رزین پیشرفت داده شده با اپوکسی و یا فنوکسی خاتمه یافته است. به طور کلی نسبت&shy;های کم (1/0 &ndash; 56/0&nbsp;wt%)&nbsp;BA&nbsp;به اپوکسی رزین، رزین&shy;های پایان یافته با اپوکسی و نسبت&shy;های بالا (6/0 &ndash; 9/0&nbsp;wt%) رزین&shy;های پایان یافته با فنوکسی حاصل می&shy;کند. مکانسم واکنش پیشرفت که توسطPalackdharry&nbsp;ارائه شده است، در شکل زیر آمده است. (2-5&nbsp;a)&nbsp;Woo&nbsp;و&nbsp;Taman&nbsp;به این نتیجه رسیدند که در طول واکنش پیشرفت اپوکسی، مقداری شاخه&shy;ای شدن هم رخ می&shy;دهد و این مقدار کم را با یک پیک 77&nbsp;ppm&nbsp;در طیف&nbsp;<sup>13</sup>C NMR&nbsp;ثابت کردند. درجه&shy; ی شاخه&shy;ای شدن بسیار کم است. ساختار رزین شبکه&shy;ای آن&shy;ها در شکل زیر آمده است. (2-5b) قابل ذکر است که واکنش&shy;های شبکه&shy;ای شدن در مکان&shy;های گروه&shy;های هیدروکسیل که از واکنش هیدروکسی رزین با&nbsp;BA&nbsp;شکل می&shy;گیرند، انجام می&shy;شود. گروه&shy;های هیدروکسیل که مکان&shy;هایی برای واکنش&shy;های شبکه شدن هستند، به وضوح در واحدهای تکرار قابل مشاهده هستند. واکنش پیشرفت رزین&shy;های اپوکسی بسیار حساس است و برای جلوگیری از ژل شدن باید به شدت تحت کنترل قرل بگیرد. این نوع واکنش&shy;ها ممکن است باعث باقی ماندن&nbsp;BA&nbsp;واکنش نداده در محصول شود و شدیدا باید از این اتفاق جلوگیری کرد. با تنظیم شیمیایی واکنش می&shy;توان این مقدار را کاهش داد. کاتالیزورهای واکنش&shy;های پیشرفت دادن اپوکسی رزین&shy;ها شامل نمک&shy;های فسفونیوم، تری بوتیل آمین، فسفریک اسید، آمونیاک، نمک&shy;های آمونیوم و اکسید کرم هستند. جدول زیر برخی از این کاتالیزورها را با علائم اختصارشان نشان می&shy;دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اخیرا گزارش شده است که افزودن کاتالیزور سوپر اسید پلی&shy;ال حاصل می&shy;کند. کاتالیز کردن با 1% پرکلریک اسید در دمای اتاق، محصولی با وزن مولکولی متوسط 1650 و&nbsp;Polydispersity&nbsp;5 حاصل می&shy;کند. ساختار این پلی&shy;ال با پلی&shy;ال رزین&shy;های اپوکسی قدیمی با جرم مولکولی بالا که با روش&shy;های دیگر به دست می&shy;آیند فرق می&shy;کند و در هر واحد تکرار آن 2 گلایسیدیل وجود دارد. این محصول بسیار کمتر از رزین&shy;های اپوکسی قدیمی رسوب مواد اولیه دارد و از این نظر بسیار مهم است. چون در مصارف خاص و صنایع مربوط به مواد غذایی غلظت&nbsp;BA&nbsp;باید کمتر از 5&nbsp;ppb&nbsp;باشد. مکانیزم این واکنش&shy;ها را در زیر می&shy;آوریم و در مورد آن توضیحاتی می&shy;دهیم.</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">واکنش اولیه، هیدرولیز اپوکساید پروتونه شده است که توسط آب با ثابت سرعت&nbsp;K<sub>1</sub>&nbsp;انجام می&shy;شود و گلایکول&shy;ها را حاصل می&shy;کند. بعد واکنش الکلی شدن اپوکساید رخ می&shy;دهد که ممکن است با حمله به هیدروکسیل درجه اول با ثابت سرعت&nbsp;K<sub>2</sub>&nbsp;و یا هیدروکسیل درجه 2 با ثابت سرعت&nbsp;K&rsquo;<sub>2</sub>&nbsp;صورت می&shy;گیرد. حمله&shy; ی الکل&shy;ها به کربن نوع دوم به اپوکساید پروتونه شده هم احتمال دیگری است که در این شکل نشان داده نشده است.</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اگر K2[ROH]&asymp;K&rsquo;2[ROH]&gt;K1[H2O] باشد، پلیمریزاسیون به صورت مطلوبی انجام خواهد شد. با باز شدن هر اپوکساید، دو حلقه تولید خواهد شد. بنابراین واکنش هیدرولیز، غلظت الکل را افزایش خواهد داد. محاسبه می&shy;شود که محصول نهایی، وزن تقریبی معادل OHای برابر 148 دارد. با فرض دانسیته 16/1 برای پلیمر، این به معنی غلظت 8/7 مولار برای الکل است. برای این منظور غلظت تعادلی آب در فاز دیسپرس باید حدود 14% باشد. حلالیت آب در رزین اپوکسی فقط حدود 5/0 % است و حتی با افزایش میزان آب&shy;دوستی در خلال آزمایش، به نظر می&shy;رسد که باز هم غلظت در فاز دیسپرس به آن حد نمی&shy;رسد. بنابراین با پیشرفت واکنش غلظت گروه&shy;های الکلی از آب بیشتر می&shy;شود. از آنجایی که هسته&shy;دوستی تمایل دارد که به لحاظ ساختاری شبیه باشد و به خوبی می&shy;دانیم که الکل&shy;ها بازهای قویتری نسبت به آب هستند، این می&shy;تواند جنبه&shy;&nbsp; جالبی از پلیمریزاسیون را رو کند. اگر آب و رزین اپوکسی در محلول همگنی پلیمریزه شوند، با کم شدن غلظت آب اولیه، جرم مولکولی افزایش خواهد یافت. در این سیستم دو فازی کم کردن غلظت کلی آب (مانند بالا بردن درصدهای جامد) اثر اندکی روی غلظت تعادلی آب در داخل ذرات دارد و بنابراین اثر کمی روی جرم مولکولی خواهد گذاشت. چون که سرعت نفوذ آب از فاز پیوسته بسیار سریع&shy;تر از سرعت واکنش است. کاهش دما و افزایش غلظت کاتالیزور، منجر به محصول با جرم مولکولی بالاتر می&shy;شود. با توجه به طبیعت شاخه&shy;ای رزین، هر دوی این پارامترها روی متوسط جرم مولکولی بیش از عدد متوسط اثر می&shy;کنند و Polydispersity هم افزایش می&shy;یابد. از رابطه&shy; معکوس دما و غلظت کاتالیزور، می&shy;توان نتیجه گرفت که با افزایش دما، غلظت تعادلی آب در داخل ذرات افزایش می&shy;یابد. یا می&shy;توان به این نتیجه رسید که حساسیت ثابت سرعت واکنش هیدرولیز نسبت به الکل&shy; کافت نسبت به دما بیشتر است.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"https://www.amazontele.com/product/%D9%BE%DA%A9-%D8%B1%D8%B2%DB%8C%D9%86-%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C-%D9%88-%D9%87%D8%A7%D8%B1%D8%AF%D9%86%D8%B1-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%86%D9%88%D8%A8-%D8%B2%DB%8C%D9%88%D8%B1%D8%A2%D9%84%D8%A7%D8%AA-%D9%88-%D8%B3%D9%86%DA%AF-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%A9%D8%A7%D8%B1%D9%87%D8%A7%DB%8C-%D9%87%D9%86%D8%B1%DB%8C\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/آمازون تله اپوکسی.jpg\" style=\"height:480px; width:666px\" /></a></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"https://www.amazontele.com/product/%D9%BE%DA%A9-%D8%B1%D8%B2%DB%8C%D9%86-%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C-%D9%88-%D9%87%D8%A7%D8%B1%D8%AF%D9%86%D8%B1-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%86%D9%88%D8%A8-%D8%B2%DB%8C%D9%88%D8%B1%D8%A2%D9%84%D8%A7%D8%AA-%D9%88-%D8%B3%D9%86%DA%AF-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%A9%D8%A7%D8%B1%D9%87%D8%A7%DB%8C-%D9%87%D9%86%D8%B1%DB%8C\"><span style=\"color:#FF8C00\">جهت خرید پک اپوکسی و هاردنر شفاف روی عکس کلیک کنید</span></a></span></span></p>','/app/articles/1529426037186.jpg','/app/articles/1529426037143.jpg','رزین­های اپوکسی,اپوکسی,قیمت مواد شیمیایی,رزین و چوب,مقاله,رزین شفاف,لیست قیمت,اپوکسی چوب','انواع-رزین-های-اپوکسی',2171,2,1,'2018-06-19 21:03:57','2022-01-11 19:50:59'),(4,2,'معرفی رزین های اپوکسی','امروزه خانواده بزرگ رزین های اپوکسی دارای بالاترین کارآیی‌ها در بین مواد شیمیایی موجود در صنعت می باشد.','<p dir=\"rtl\" style=\"text-align:center\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/LMSse/vt/frame\" width=\"80%\"></iframe></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-size:18px\"><span style=\"color:#ff0000\">در این ویدئو نحوه کار با رزین اپوکسی به نمایش گذاشته شده است&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-size:26px\">برای مشاهده مقاله در خصوص<span style=\"color:#4e5f70\">&nbsp;&quot;</span><span style=\"color:null\">انواع رزین اپوکسی&quot;</span> (<a href=\"https://www.amazontele.com/article/%D8%A7%D9%86%D9%88%D8%A7%D8%B9-%D8%B1%D8%B2%DB%8C%D9%86-%D9%87%D8%A7%DB%8C-%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C\"><span style=\"color:#2980b9\">اینجا</span></a>) کلیک کنید.</span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><strong>رزین اپوکسی</strong></span></span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">امروزه خانواده بزرگ رزین های اپوکسی دارای بالاترین کارآیی&zwnj;ها در بین رزین های موجود در صنعت می باشد. اپوکسی ها عموماً در مقاومت های شیمیایی و &ldquo;از هم پاشیدگی های&rdquo; ناشی از عوامل محیطی و خواص مکانیکی، بالاتر از اکثر انواع رزین های دیگر می&zwnj;باشند که در نتیجه موجب مصرف تقریباً انحصاری این رزین ها در قطعات سازه های هوایی گردیده است. از دیگر سو به دلیل چسبندگی بالای این رزین ها و مقاومتشان در برابر از هم پاشیدگی ناشی از تماس با آب از آنها به عنوان رزین ایده آل برای مصارفی چون تجهیزات صنایع هوا فضا ، چند سازه ای های پیشرفته، صنایع دفاعی، نفت و گاز، دریایی، خودروسازی، برق و الکترونیک، تجهیزات ورزشی، و غیره استفاده می&zwnj;شود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">همچنین امروزه از اپوکسی ها در مصارفی دیگر مانند چسب ها، خمیرهای درزگیر، ترکیبات ریخته گری و سیل کننده ها (آب بندی کننده ها)، لعاب، پوشش های کف و رنگ ها استفاده می&zwnj;گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اصطلاح اپوکسی به گروه مواد شیمیایی اطلاق می&zwnj;شود که در آن یک اتم اکسیژن با دو اتم کربن دیگر که به نوعی به هم پیوند خورده اند متصل می&zwnj;باشد. ساده ترین اپوکسی دارای یک ساختمان حلقوی سه عضوی بوده که اصطلاحاً به آن &ldquo;۱ و ۲ اپوکسی&rdquo; یا &ldquo;آلفا اپوکسی&rdquo; گفته می&zwnj;شود. شکل زیر ساختمان شیمیایی ایده آل یک اپوکسی را نشان می&zwnj;دهد که به عنوان ساده ترین مشخصه هر مولکول پیچیده اپوکسی شناسایی شده است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"http://www.basparan.com/wp-content/uploads/2017/10/EP1.jpg\">&nbsp;</a><img alt=\"https://www.basparan.com/wp-content/uploads/2017/10/EP1.jpg\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/Introduction%20of%20epoxy%20resins/01.jpg\" /></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین های اپوکسی همانند وینیل استرها از ساختمان زنجیره های بلند مولکولی تشکیل شده اند که مکانهای واکنش پذیرشان در انتهای این زنجیره هست با این تفاوت که به جای گروه های استری، این مکان ها از گروه های اپوکسی تشکیل شده اند. نبودن گروه های استری در این رزین ها به معنی داشتن مقاومت بسیار خوب به خصوص در مقابله با آب می&zwnj;باشد. همچنین مولکول های اپوکسی در مرکز خود دارای دوگروه حلقوی اند که بهتر از گروه های خطی قادر به جذب تنش های مکانیکی و حراتی هستند بنابراین رزین های اپوکسی خواص سفتی، چقرمگی و مقاومت حرارتی خیلی خوبی را ارائه می&zwnj;کنند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"http://www.basparan.com/wp-content/uploads/2017/10/EP2.jpg\">&nbsp;</a><img alt=\"https://www.basparan.com/wp-content/uploads/2017/10/EP2.jpg\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/Introduction%20of%20epoxy%20resins/02.jpg\" /></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">تفاوت دیگر رزین های اپوکسی با پلی استر ها در این است که رزین های اپوکسی به جای یک فعال کننده، به وسیله یک &ldquo;سخت کننده&rdquo; پخت می&zwnj;شوند. سخت کننده که اغلب یک آمین می&zwnj;باشد از طریق &ldquo;واکنش افزایشی&rdquo; موجب پخت رزین اپوکسی گردیده و هر دو ماده از طریق این واکنش در ساختار نهایی شرکت می&zwnj;کنند از دیدگاه شیمی معنی این واکنش اتصال خوردن سر دو اپوکسی مجزا با سر یک آمین است. این واکنش یک ساختمان مولکولی سه بعدی پیچیده را که در شکل زیر نشان داده شده تشکیل می&zwnj;دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"http://www.basparan.com/wp-content/uploads/2017/10/EP3.jpg\">&nbsp;</a><img alt=\"https://www.basparan.com/wp-content/uploads/2017/10/EP3.jpg\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/Introduction%20of%20epoxy%20resins/03.jpg\" /></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong>خواص</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ساختمان شیمیایی رزین های اپوکسی طوری است که آنها را در مقابل مواد شیمیایی مقاوم می کـند. رزین های اپوکسی چسبندگی بسیار خوبی به طیف وسیعی از مواد دارند. همچنین ابعاد قالب خود را به خوبی حفظ می کنند. پس از پخت دارای استحکام و انعطاف هستند و مقـــاومت خوبی در مقـــابل سایش از خود نشان می دهند. این رزین ها از جمله رزین های نادری هستند که قادرند در حرارتــــهای بالا مقاومت خوبی نشان دهند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">هر جا که نیاز به استحکام فیزیکی بالا داشته باشیم از سیستم رزین های اپوکسی استفــاده می کنیم.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">علاوه بر این ساختار متنوع، اپوکسی&zwnj;ها دارای ویژگی&zwnj;های ذیل نیز هستند:<br />\r\n۱)&nbsp;مقاومت شیمیایی عالی (بویژه در محیطهای قلیایی)<br />\r\n۲)&nbsp;چسبندگی خوب به مجموعه&zwnj;ای از بسترهای مختلف<br />\r\n۳)&nbsp;استحکام کششی، فشاری و خمشی بسیار بالا<br />\r\n۴)&nbsp;پایین بودن جمع شدگی پخت<br />\r\n۵)&nbsp;پایداری ابعادی<br />\r\n۶)&nbsp;عایق عالی الکتریسیته<br />\r\n۷)&nbsp;دوام بالا در پیری و شرایط سخت محیطی<br />\r\n۸)&nbsp;قابلیت پخت در دماهای مختلف<br />\r\n۹)&nbsp;مقاومت خستگی ممتاز<br />\r\n۱۰)&nbsp;بی بو و بی مزه</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">علاوه بر آن رزین های اپوکسی بطور وسیعی به همراه الیاف و ساختارهای لانه زنبوری برای ساخت ملخ هلی کوپتر استفاده می&zwnj;شود. رزین های اپوکسی تقویت شده با الیاف کربن و آرامید در ساخت قایقهایی که در آنها ضمن حفظ وزن، استفاده بیشتر از فضا در همان استحکام مورد نظر است، بجای پلی استر- شیشه استفاده می&zwnj;شوند.<br />\r\nهمچنین کامپوزیتهای آرامید &ndash; اپوکسی برای جایگزین فولاد در کلاه خودهای جنگی استفاده میشوند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong>طرز تهیه رزین های اپوکسی</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین های اپوکسی از همان اوایل پیدایش جای پای خود را در میان دیگر مواد گوناگون صنایع رنگسازی به عنوان یکی از مواد مهم این صنعت باز نمودند که این موفقیت بیشتر به خاطر خصائص فراوان و متنوع این رزین ها می باشد. درحقیقت دست یک فرمولیست را در ارائه فرمولهای مختلف رنگ از قبیل انواع رنگهای سخت شونده با آمین و کراس لینک شونده بر اثر حرارت که مقاومت بسیار خوبی در مقابل حلالها و مواد شیمیایی دارند باز نموده است. از مصارف مهم رزین های اپوکسی در ساخت رنگهای اپوکسی، چسبها، دوغاب و مواد درزگیر آب می باشد.&nbsp;<br />\r\nرزین های اپوکسی یک رزین ترموست می&zwnj;باشند و بیش از ۸۵ درصد رزین های اپوکسی موجود از واکنش اپی کلر و هیدروین و دی فنیلول پروپان (۲-۲- بیس- ۴- هیدروکسی فنیل پروپان به نام تجاری بیس فنل&nbsp;A)&nbsp;حاصل می&zwnj;شوند که یک نمونه دیگر تولید رزین اپوکسی اولفینی است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"http://www.basparan.com/wp-content/uploads/2017/10/EP4.jpg\">&nbsp;</a><img alt=\"https://www.basparan.com/wp-content/uploads/2017/10/EP4.jpg\" src=\"http://www.unionpigments.com/public/photos/shares/Blogs/Introduction%20of%20epoxy%20resins/04.jpg\" /></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong>طرز تهیه رزین های اپوکسی بیس فنل</strong><strong>&nbsp;,A</strong><strong>رزین های اپوکسی- اولیفینی</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین های اپوکسی که از واکنش بیس فنل&nbsp;A&nbsp;و اپی کلرویدرین تهیه می&zwnj;گردند از مرغوب ترین نوع رزین های اتر- کلسیدی می&zwnj;باشند. بیس فنل&nbsp;A&nbsp;از واکنش تراکمی استن با دومول فنل در حضور کاتالیزور اسیدی به دست می&zwnj;آید و اپی کلروهیدرین از واکنش پروپیلن با کلرین حاصل می&zwnj;شود.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">واکنش یک مول بیس&nbsp;A&nbsp;با حداقل دو مول اپی کلروهیدرین در محیط قلیایی و یا از بین رفتن گروههای فنلی و تشکیل گروههای هیدروکسی، تولید مادۀ واسطه کلریدرین می&zwnj;کند که با ادامه واکنش محصول دی گلیسیدیل اِتربیس فنل&nbsp;A (DGEBA)&nbsp;بدست می&zwnj;آید.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">این رزین ها از طریق اپوکسی نمودن بندهای دوگانه کربن-کربن اولیفینها ساخته می&zwnj;شوند که در پروسه ساخت آنها از اسید پراستیک به عنوان عامل اپوکسی کننده استفاده می&zwnj;شود. به عنوان مثال رزین گلیسیدیل متاکریلات یک رزین اپوکسی متاکریلات می&zwnj;باشد که فیلم حاصل از رزین های اپوکسی- اولیفینی مقاومت بهتر و بیشتری از فیلم های حاصل از رزین های اپوکسی- اترگلیسیدی (بیس فنل) در مقابل آب و مواد دارد و اما بالعکس مقاومت ضعیف تری در مقابل مواد شیمیایی از خود نشان می&zwnj;دهند و به همین علت کمتر از رزین های بیس فنلی در ساخت رنگهای صنعتی- حفاظتی استفاده می&zwnj;گردند. اختلاف دیگر آنها در این است که رزین های اپوکسی- اولیفینی با مواد سخت کننده اسیدی سریعتر از مواد سخت کننده آمینی وارد واکنش می&zwnj;شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong>نقش رزین های اپوکسی در صنایع رنگ و رزین</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">نقش رزین های اپوکسی در صنایع رنگ و رزین را به طوری کلی میتوان به دو قسمت تقسیم نمود یکی به عنوان یک پلی الکل و دیگری به عنوان یک رزین تشکیل دهنده فیلم.<br />\r\nرزین های اپوکسی تشکیل دهنده فیلم ممکن است خود رزین های اپوکسی، اپوکسی استر یا اپوکسی آلکید یا هر رزین دیگری که با اپوکسی اصلاح شده است باشند؛ که در هر دو سیستم هوا- خشک و کوره ای بکار می روند.از آنجائیکه فیلم حاصل از رزین های اپوکسی شکننده است از این رو آنان را با رزین های دیگر کراس-لینک می کنند که تعدادی از آنان با این شرح می باشند:</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong>۱</strong><strong>-&nbsp;</strong><strong>رزین های اپوکسی- فنلینک</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین های اپوکسی فنلی یکی از رزین های بسیار مقاوم در مقابل مواد شیمیایی و حلالها می باشند. از پوششهای مذکور بیشتر جهت پوشش داخلی لوله های استیلی و چاه های حفاری نفتی نام برد و همچنین به علت داشتن مقاومت الکتریکی عالی از آن جهت پوشش سیم های الکتریکی و ساخت تعدادی از سفارشات ارتش که نیازمند به مقاومت شیمیایی بسیار عالی هستند، استفاده میگردد و امروزه به علت ارزان بودن قیمت و داشتن مقاومت شیمیایی بسیار خوب مصرفشان رو به افزایش است.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong>۲</strong><strong>-&nbsp;</strong><strong>رزین های اپوکسی آمینو</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><br />\r\n<span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">فیلم حاصل از اصلاح یک رزین اپوکسی با رزین اوره- فرم آلوئید هرچند که مقاومت شیمیایی کمتری از سیستم اپوکسی فنلیک دارد اما در عوض رنگ روشنتر، درجه حرارت پخت کمتر و مقاومت زنگ زدگی بیشتری دارد. دو فاکتور رنگ روشنتر و درجه حرارت پخت کمتر باعث تقدم انتخاب این سیستم بر سیستم اپوکسی فنلیک میگردد.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong>کاربرد رزین اپوکسی</strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">رزین های اپوکسی در کاربرد های مختلفی از قبیل پوشش سطح ,روکش دهی . ابزارسازی و کامپوزیتها استفاده می شوند.ساخت قالب های وکیوم فرمینگ .الکترو فرمینگ .متال فرمینگ. الگو برداری.قالبهای مقاوم در برابر فشار . دفن قطعات الکترونیکی. ساخت قالب با ابعاد بزرگ . پشت ریز قالبها. ساخت قطعات ریخته گری ماشینی.ساخت قالبهای مقاوم در برابر حرارت. صنایع چسب. صنایع کامپوزیتها (مانند موادی که از فایبر گلاس یا فیبر کربن استفاده می&zwnj;کنند) و تقویت&zwnj;کننده&zwnj;ها (اگرچه پلی&zwnj;استر، وینیل&zwnj;استر و دیگر صمغهای ترموست هم برای پلاستیک تقویت&zwnj;شده با شیشه به کار می&zwnj;روند). کفپوشهاو پوشش روی سطح. مصارف خانگی و دریایی. چند لایه&zwnj;ای رزین اپوکسی از اهمییت فوق العاده ای در صنایع هواپیما سازی برخوردارند.</span></span></p>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بسیاری از قطعات ساختاری از جنس ایاف کربن و رزین اپوکسی جایگزین آلیاژهای فلزی مرسوم شده و نتایج مطلوبی نیز داشته اند . همچنین از این رزین به همراه الیاف آرامید . در ساخت موتور راکت و کپسولهای تحت فشار به روش رشته پیچی استفاده می شود . علاوه بر آن رزین های اپوکسی بطور وسیعی به همراه الیاف و ساختار های لانه زنبوری برای ساخت ملخ هلیکوپتر استفاده می&zwnj;شود. رزینهای اپوکسی تقویت شده با الیاف کربن و آرامید در ساخت قایقهایی که در آنها ضمن حفظ وزن . استفاده بیشتر از فضا در همان مکان استحکام مورد نظراست بجای پلی استر &ndash; شیشه استفاده می شوند. همچنین کامپوزیت های آرامید-اپوکسی برای جایگزین فولاد در کلاه خود های جنگی استفاده می شوند بر اساس نوع کاربرد میتوان از رزین های سردکار&nbsp;( (cold curing&nbsp;و گرما پخت&nbsp;(hot curing)&nbsp;استفاده نمود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><a href=\"https://www.amazontele.com/search_box?q=%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C\"><img alt=\"برای خرید پک اپوکسی و هاردنر بر روی عکس کلیک کنید\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/آمازون تله اپوکسی.jpg\" style=\"height:480px; width:666px\" /></a></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><strong><span style=\"background-color:rgb(255, 255, 255); color:rgb(255, 140, 0); font-family:comic sans ms,cursive; font-size:17.3333px\">رزین اپوکسی را از کجا تهیه کنیم؟</span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><strong><span style=\"color:#2980b9\"><span style=\"font-size:20px\"><span style=\"background-color:null\">برای </span></span></span><span style=\"color:#e74c3c\"><span style=\"font-size:20px\">خرید</span></span><span style=\"color:#2980b9\"><span style=\"font-size:20px\"><span style=\"background-color:null\"> رزین اپوکسی ومشاهده لسیت قیمت </span></span></span><a href=\"https://www.amazontele.com/search_box?q=%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C&amp;status=1\"><span style=\"color:#e74c3c\"><span style=\"font-size:20px\">روی عکس کلیک</span></span></a><span style=\"color:#2980b9\"><span style=\"font-size:20px\"><span style=\"background-color:null\"> کنید</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\">&nbsp;</p>','/app/articles/1529426083525.jpg','/app/articles/1529426083108.jpg','اپوکسی,رزین,پلیمر,مهندسی پلیمر,آمازون تله,فروش مواد شیمیایی,فروش انلاین,قیمت مواد شیمیایی,لیست قیمت,اپوکسی چوب,ویدئو','معرفی-رزین-های-اپوکسی',2989,2,1,'2018-06-19 21:04:43','2022-01-11 22:34:41'),(6,2,'رزین های کلروکائوچو','رزین های کلرکائوچو به شکل جامد پودری می باشند که با اغلب حلال ها قابلیت امتراج دارند.','<h2 dir=\"rtl\" style=\"text-align: center;\"><span style=\"font-size:22px\"><strong>جهت خرید رزین کلرو کائوچو<a href=\"https://www.amazontele.com/product/%D8%B1%D8%B2%DB%8C%D9%86-%DA%A9%D9%84%D8%B1%D9%88-%DA%A9%D8%A7%D8%A6%D9%88%DA%86%D9%88\"><span style=\"color:#008000\"> اینجا </span></a>کلیک کنید</strong></span></h2>\r\n\r\n<h2 dir=\"rtl\" style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">کائوچوی خام موجود در طبیعت نئوپرن یا ایزوپرن پلیمری است با زنجیره فنر مانند که خاصیت ارتجاعی دارد. طی واکنش های کلرینه کردن افزایشی و استخلافی کائوچوی طبیعی در محلول تتراکلرید کربن، رزین کلروکائوچو حاصل می شود.&nbsp;<br />\r\nکلروکائوچوی تهیه شده به شکل پودر سفید رنگ و دارای 65 درصد کلر است که هنگام استفاده، با حلال مناسب به حالت مایع تبدیل می شود.&nbsp;<br />\r\nکلروکائوچو در هیدروکربن های حلقوی، استرها، کتون ها و حلال های کلردار به خوبی حل می شود ولی در هیدروکربن های آلیفاتیک و الکل ها کاملا نامحلول است.<br />\r\nجرم مولکولی رزین کلروکائوچو معمولا بیش از 500 است و هر چه جرم مولکولی افزایش یابد، ویسکوزیته رزین بیشتر خواهد بود. رزین کلروکائوچو به تنهایی و یا به همراه دیگر رزین ها از جمله رزین های آلکید شورت اویل در فرمولاسیون رنگ های استخری، رنگ های دریایی، رنگ های ترافیک و خط کشی جداول خیابان ها کاربرد دارد.&nbsp;<br />\r\nرنگ های کلروکائوچو پوشش خوبی برای فولاد، آهن و سطوح سیمانی هستند و برای بدنه کشتی، پل، دیگ بخار، لوله ها و سقف سوله های صنعتی به کار می روند.&nbsp;<br />\r\nاز خواص بارز این رزین مقاومت خوب آن در مقابل مواد قلیایی و شیمیایی است. این رزین در برابر بیشتر اسیدهای معدنی مقاومت خوبی دارد؛ اگر چه در حرارت بیش از 60 درجه سانتیگراد این رزین تحت اثر تخریبی اسیدهای معدنی غلیظ قرار می گیرد.&nbsp;<br />\r\nدر حضور مواد اکسیدکننده و در دمای اتاق، رزین کلروکائوچو مقاومت خوبی دارد ولی با افزایش دما مقاومت آن کاهش یافته و رنگ تخریب می گردد.&nbsp;<br />\r\nهنگام استفاده از کلروکائوچو در شرایط قلیایی باید توجه داشت که درصد رزین آلکید در فرمولاسیون بسیار کم باشد زیرا رزین آلکید در مجاورت قلیا هیدرولیز و تخریب می شود.&nbsp;<br />\r\nهمچنین بواسطه مقاومت خوب در برابر مواد قلیایی و آب، رنگ&zwnj;های کلروکائوچو برای پوشش سطوح بتنی نیز توصیه می شوند.&nbsp;<br />\r\nکلروکائوچو یک رزین ترموپلاست است و مقاومت حرارتی محدودی دارد به طوری که در محیط مرطوب تا 60 درجه سانتیگراد و در محیط خشک تا 93 درجه سانتیگراد مقاوم است.&nbsp;<br />\r\nخشک شدن رزین از طریق تبخیر حلال است و هیچ گونه واکنش شیمیایی صورت نمی گیرد لذا در دمای بالا رزین نرم شده و شره خواهد کرد. بعلاوه، این رزین تا دمای 32- درجه سانتیگراد مقاومت دارد و در دمای زیر صفر درجه سختی و شکنندگی رزین افزایش می یابد.<br />\r\nجذب ضعیف آب و رطوبت، غیر قابل اشتعال بودن (به واسطه وجود اتم کلر) و مقاومت الکتریکی بالا نوع خاصی از رزین کلروکائوچو را برای ساخت پوشش کابل های برق مناسب کرده است.<br />\r\nرزین کلروکائوچو با بسیاری از رزین های دیگر نظیر آلکید شورت اویل، آکریلیک، فنولیک، اپوکسی، وینیل و همچنین با رزین های طبیعی مانند قیر، کائوچوی نیتریل و کومارون سازگار است.&nbsp;<br />\r\nرزین کلروکائوچو به نور خورشید و اشعه UV آن حساس است و هرگز رنگ بدون رنگدانه برای مصارف خارج ساختمان توصیه نمی&zwnj;شود.&nbsp;<br />\r\nبا استفاده از رنگدانه های مناسب، پایدارکننده ها و یا رزین های اصلاحی مقاومت رزین کلروکائوچو را می توان تا حد مطلوب افزایش داد.</span></span><br />\r\n&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">کلروکائوچو به عنوان رزین، ویژگی های منحصر به فردی دارد. ظاهر آن پودری شیری رنگ متمایل به زرد است، که پس از حل شدن در حلال های مناسب، به صورت یک مایع ویسکوز عسلی در می آید</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">ساختمان کائوچوی خام یا ایزو پرن از نظر نظم مولکولی از سیس و ترانس تشکیل شده است. کلروکائوچو به وسیله ی کلردار نمودن کائوچوی طبیعی در محلول تتراکلرو کربن تهیه می گردد. برای ساخت کلروکائوچو مراحل زیر یکی پس از دیگری</span><br />\r\n<span style=\"color:black\">دنبال می شود. د دوم در محلول تتراکلروکربن حل می گردد چون گاز کلر بی اثر است که مرحله ی کلردار نمودن به وسیله ی گاز کلر است. پایان مرحله ی سوم زمانی است که از راکتور دیگر گاز اسید کلریدریک متصاعد شود و مرحله ی آخر، جداسازی حلال است. یکی از روش های جداسازی روش تقطیر است. در پایان کار، پودر سفید کلروکائوچو به دست می آید. این پودر ناپایدار است و اسید کلرید ریک متصاعد می کند. برای جلوگیری از این رخداد، باید با به کار گیری مواد قلیایی، آن را به پایداری برسانیم. هرچه جرم مولکولی کلروکائوچو بیشتر باشد، گرانروی بیشتر خواهد بود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">گرانروی کمتر در رنگ های قابل اسپری، متوسط برای رنگ های به کار رونده با قلم مو و گرانروی بالا در چسب ها و صنعت کاغذسازی استفاده می شود. کلروکائوچو در هیدروکربن های حلقوی و هیدروکربن های کلردار و استرها به خوبی حل می شود، اما در الکل ها کاملاً نامحلول است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">رزین کلروکائوچو به طور گسترده ای در ساخت انواع رنگ ها مورد استفاده قرار می گیرد. از خواص خوب آن می توان به مقاومت در برابر مواد قلیایی و شیمیایی و کاربرد در رنگ های ضد خورنده اشاره نمود. همچنین کاربرد وسیعی در رنگ های مخصوص کف سیمان و در قسمت های داخلی و خارجی ساختمان های</span><br />\r\n<span style=\"color:black\">فولادی دارد. از رنگدانه های متالیک به همراه این رزین می توان استفاده</span> <span style=\"color:black\">نمود. در</span><br />\r\n<span style=\"color:black\">رنگ های ضد آتش، رنگ های استخری، رنگ های دریایی و رنگ هایی ترافیکی و خط کشی کاربرد گسترده ای دارد. این رنگ، مقاومت خوبی در برابر اسیدهای آلی و غیر آلی و مواد اکسنده، محلول هلی نمکی و نیز مقاومت خوبی در برابر سایش در محیط های خشک و مرطوب دارد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">کلروکائوچو به سبب داشتن کلر در ساختار مولکولی، خاصیت ضد قارچ و کپک دارد و فیلم آن ضد آب است. دارای چسبندگی عالی روی سطوح بتونی است؛ خشک شدن آن سریع و به صورت فیزیکی (تبخیر حلال) است. اشکالات آن به قرار زیر است</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">فیلم آن بسیار شکننده است و نیاز به نرم کننده دارد (از دو نوع نرم کننده ی داخلی و خارجی استفاده می شود؛ نرم کننده ی داخلی همانند رزین آلکید و نرم کننده ی خارجی همچون</span><span dir=\"LTR\"><span style=\"color:black\"> DOP </span></span><span style=\"color:black\">یا پارافین کلره که مخصوص رنگ استخری بر پایه ی کلروکائوچو است</span><span dir=\"LTR\"><span style=\"color:black\">).</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">فیلم حاصل از کلروکائوچو /نرم کننده ی خارجی به سبب نبود گروه های قطبی در ساختار مولکولی آن، سه بعدی نیست و یا</span><span dir=\"LTR\"><span style=\"color:black\"> cross-linked </span></span><span style=\"color:black\">نمی شود، و بازگشت پذیر است و در حلال خود کاملاً حل می شود. پس از اعمال یک لایه رنگ و خشک شدن آن به هنگام اعمال لایه ی دوم با قلم مو، حلال موجود در رنگ، فیلم زیرین را که بازگشت پذیر است در خود حل می کند و فیلم حالت نخی نخی به خود می گیرد. به همین دلیل لایه ی دوم باید اسپری گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">ساختمان شیمیایی کلروکائوچو حدود 67 درصد کلر و کلر کلروکائوچو به سبب نداشتن گروه های مؤثر قطبی در ساختمان مولکولی خود، چسبندگی اندکی به فلزات (آهن) دارد و چون در بسیاری از تأسیسات استخرها فلز نیز به کار رفته، باید برای این نوع کاربرد از نرم کننده ی داخلی (رزین آلکید) استفاده نمود. آلکید بلند دارای بالاترین درصد روغن و بنابراین در مقایسه با</span><span dir=\"LTR\"><span style=\"color:black\"> medium </span></span><span style=\"color:black\">و</span><span dir=\"LTR\"><span style=\"color:black\"> short </span></span><span style=\"color:black\">دارای انعطاف دهندگی بیشتری است، اما استفاده از آلکید بلند امکان پذیر نیست و خطر ژل شدن رنگ وجود دارد، و اختلاف زیاد در تراکم مولکولی دو رزین آلکید بلند و کلروکائوچو، و عدم انحلال کلروکائوچو در وایت اسپریت، حلال اصلی الکید بلند، سبب می گردد از آلکید بلند استفاده نشود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">الکید متوسط اگرچه نسبت به الکید بلند تراکم مولکولی بیشتری دارد اما به سبب عدم سازگاری کلروکائوچو با حلال 402 باز هم خطر ژل شدن رنگ در داخل قوطی در دراز مدت وجود دارد. بنابراین الکید کوتاه مناسب ترین انعطاف دهنده (نرم کن داخلی) برای کلروکائوچو است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"color:fuchsia\">خواص کلروکائوچو</span></strong><span dir=\"LTR\"><span style=\"color:fuchsia\">:</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">کلروکائوچو با نام تجاری پرگوت، پودری شیری رنگ و بدون بو و مزه و غیر صابونی شونده است، بنابراین در برابر اسید ها و قلیاها پایدار است. بر اثر تماس با فلز ،نور و گرما ممکن است اسید کلریدریک تولید نماید. انبار نمودن آن در قوطی، در دراز مدت موجب تغییر در دانه بندی، تغییر</span><span dir=\"LTR\"><span style=\"color:black\"> shade </span></span><span style=\"color:black\">و ایجاد گاز هیدروژن می گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"color:fuchsia\">حلال ها</span></strong><span dir=\"LTR\"><span style=\"color:fuchsia\">:</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">اصلی: استرها (اتیل استات و بوتیل استات) و کتون ها (استن</span><span dir=\"LTR\"><span style=\"color:black\">)</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">کمکی : آروماتیک ها (همچون تولوئن و زایلن</span><span dir=\"LTR\"><span style=\"color:black\">)</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">این رزین در الکل ها و وایت اسپریت نامحلول است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"color:fuchsia\">فرمولاسیون</span></strong><span dir=\"LTR\"><span style=\"color:fuchsia\">:</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">رنگ باید شامل رزین کلروکائوچو، رنگدانه، پرکننده، حلال ها، نرم کننده و دیگرافزودنی ها باشد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">کلروکائوچو ............................ 25 تا 30 درصد</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">رنگدانه و پرکننده ........................ 30 تا 35 درصد</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">نرم کننده ............................... 10 درصد</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی .................................. 5 درصد</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">تینر .................................... 25 درصد</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">رنگدانه: دی اکسید تیتانیم روتایل 20 درصد (و 5 درصد هم خمیرآبی برای رسیدن به فام دلخواه)؛</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">پرکننده: کربنات کلسیم 10 درصد و تالک که کمک به چسبندگی رنگ به سطح کمک می کند (به خاطر ساختار پولکی شکل) خود 5 درصد،</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">نرم کننده: 10 درصد نرم کننده ی داخلی و 10 درصد نرم کننده ی خارجی؛</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی ها شامل پخش کننده (همچون سویا لسیتین یا نوسپرس 657) حدود 2 درصد، و بنتون ژل صنعتی3 درصد؛</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">تینر: مخطوط مساوی زایلن و</span><span dir=\"LTR\"><span style=\"color:black\"> MEK (</span></span><span style=\"color:black\">برای کاهش هزینه می توان از استون نیز استفاده نمود</span><span dir=\"LTR\"><span style=\"color:black\">).</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"color:fuchsia\">نحوه ی ساخت</span><span dir=\"LTR\"><span style=\"color:fuchsia\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:black\">ابتدا تینر را آماده نموده و تحت اختلاط با همزن مکانیکی، به تدریج و با دور متوسط پودر کلروکائوچو را در آن حل می کنیم تا عسلی شود؛ سپس افزودنی ها را در کمی تینر رقیق نموده و به مخلوط در حال هم خوردن می افزاییم، و تیتان و پرکننده را در دور تند اضافه، و سپس نرم کننده و در انتها خمیر آبی را برای تینت نهایی می افزاییم</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>','/app/articles/1548487111316.jpg','/app/articles/1548487111616.jpg','رزین,رنگ,رنگدانه,افزودنی,ضد خوردگی','رزین-های-کلروکائوچو',1715,3,1,'2018-08-15 12:02:26','2022-01-11 18:31:18'),(7,3,'تعاریف رنگ','مفهوم فیزیکی شیمیایی رنگ','<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:#ff0000\">&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><strong><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#ff0000\">تعریف رنگ چیست ؟</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">برای مشاهده سایر مقالات مرتبط <a href=\"https://www.amazontele.com/article/tag/%D9%BE%DB%8C%DA%AF%D9%85%D9%86%D8%AA\">(اینجا)</a> کلیک کنید.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;تاثیر فیزیکی و روانی است که پس از باز تابش نور از جسم به چشم ما میرسد .</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">توسط 3 فاکتور بیان میشود :<br />\r\n1 &ndash; فام : بیانگر نوع رنگ میباشد . ( زرد &ndash; قرمز- آبی و..... )<br />\r\n2- عمق : نشاندهنده کمرنگ و پررنگ بودن میباشد .<br />\r\n3- خلوص : شفافیت رنگ را بیان مینماید .</span></span><br />\r\n&nbsp;</p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;تئوری های موجود در مورد رنگی بودن یک ماده :</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تئوری ویت :<br />\r\nطبق این تئوری &nbsp;ماده رنگزا از 2 قسمت تشکیل شده است :<br />\r\n1 &ndash; chromphor &nbsp;( کروموفور )<br />\r\n2 &ndash; auxochrom &nbsp;( آگزوکروم )</span></span><br />\r\n&nbsp;</p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">یک ترکیب آلی وقتی رنگی است که دارای یک یا چند گروه اشباع نشده داشته باشد که به این گروههای اشباع نشده کروموفور گویند .<br />\r\nگروههای شیمیایی موجود در ترکیب رنگی که باعث افزایش شدت رنگ میشوند آگزوکروم نام دارند .</span></span><br />\r\n&nbsp;</p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تئوری آرمسترانگ :<br />\r\nطبق این تئوری تمام ترکیباتی که ساختار کینوئیدی داشته باشند رنگی هستند .<br />\r\nکه این تئوری دارای مثال نقض میباشد پس این فرضیه رد شد .<br />\r\n&nbsp;&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تئوری &nbsp;:nietzki<br />\r\nهر چقدرجرم مولکولی ماده رنگی ما بالاتر برود رنگ ماده عمیق تر میشود .<br />\r\nکه دارای مثال نقض میباشد .</span></span><br />\r\n&nbsp;</p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تئوری های جدید :<br />\r\nبر پایه 2 اصل بیان شده است :<br />\r\n1 &ndash; کوانتایی بودن انرژی نور<br />\r\n2 &ndash; جذب اشعه توسط مولکول ها</span></span><br />\r\n&nbsp;</p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تئوری پیوند ظرفیتی :<br />\r\nبراساس این تئوری<br />\r\nکروموفور گروههایی از اتم ها هستند که به وسیله ی انرژی جذب شده از حالت پایه به حالت برانگیخته منتقل میشوند ورنگ را ایجاد میکند .<br />\r\nآگزوکروم گروه هایی اند که تمایل دارند فرم رزونانس را با اثر متقابل جفت الکترون های غیر پیوندی آگزوکروم ها با پای الکترون های حلقه آروماتیک افزایش دهند .</span></span></p>','/app/articles/1534322608333.jpg','/app/articles/1534322608888.jpg','فیزیک رنگ,تئوری رنگ,پیگمنت ,رنگدانه,طیف رنگ,رنگ چیست؟,پیگمنت چیست؟','تعاریف-رنگ',941,2,1,'2018-08-15 13:13:28','2022-01-10 02:52:06'),(8,1,'تاخیر اندازهای شعله','دیر سوزکننده ها','<p dir=\"rtl\" style=\"text-align:center\"><a href=\"https://www.amazontele.com/product/%D8%AA%D8%A7%D8%AE%DB%8C%D8%B1-%D8%A7%D9%86%D8%AF%D8%A7%D8%B2-%D8%B4%D8%B9%D9%84%D9%87-%D8%A8%D8%B1-%D9%BE%D8%A7%DB%8C%D9%87-%D8%A2%D9%85%D9%88%D9%86%DB%8C%D9%88%D9%85-%D9%BE%D9%84%DB%8C-%D9%81%D8%B3%D9%81%D8%A7%D8%AA\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/اینجا کلیک کنید.png\" style=\"height:112px; width:250px\" /></a></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><strong><span style=\"color:#0000CD\"><span style=\"font-size:22px\">کاربرد دیرسوز کننده ها یا تاخیراندازهای شعله</span></span></strong></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تاخیر انداز شعله در کاربردهایی نظیر صنایع هواپیماسازی و خودرو سازی، استفاده از پلیمرهایی که در برابر آتش مقاوم باشند حائز اهمیت است. موادی نظیر الفین های آلیفاتیک، پلی استایرن و پلی یورتان ها که از نظر مقاومت ضعیف هستند، باید در این کاربردها توسط دیگر مواد به نام دیر سوزکننده مقاوم گردند.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">دیرسوز کننده ها توسط یک یا تعدادی از مکانسیم های زیر عمل می کنند:</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به طور شیمیایی در مکانیسم انتشار شعله دخالت می کنند.<br />\r\nممکن است حجم بالایی از گازهای احتراق ناپذیر را تولید کنند که از مصرف اکسیژن بکاهند.<br />\r\nممکن است با انجام واکنش و تجزیه شدن از طریق واکنش های گرماگیر، سبب جذب گرما شوند.<br />\r\nبا ایجاد پوشش نفوذ ناپذیر مقاوم در برابر آتش، از دسترسی اکسیژن به پلیمر ممانعت نمایند.<br />\r\nا زدیرسوزکننده ها می توان به گروه های فسفات آلی (مانندتری کرزیل فسفات (TCP)، گروه های هالوژن دار(نظیر پارافین های کلردار، هالوفسفات ها، ترکیبات آروماتیک برم دار مانند تری برموتولوئن و پنتا برموفنیل آلیل اتر)، اکسید آنتیموان، دی اکسید تیتانیم، اکسید روی، اکسید مولیبدن و تری هیدارت آلومنیوم (ATH) اشاره نمود. متاسفانه استفاده از دیرسوز کننده ها در پلیمرها به علت این که تلفات حاصله از آتش سوزی اکثرا به خاطر محصولات سمی ناشی از دود حاصله می باشد، پیچیده می باشد و لذا راه حل های دیگری را الزامی نموده است. از این دسته می توان به استفاده از مواد پفکی شکل که در زمان گرم شدن متورم شده و ماده قابل احتراق را از آتش و اکسیژن دور نگه می دارد اشاره کرد. روش دیگر، سعی در توسعه پلیمرهایی نظیر رزین های فنولی است که با تبدیل شدن به زغالی سخت در حین سوختن، مواد قابل احتراق رزین را محافظت نماید.</span></span></p>','/app/articles/1534323143712.jpg','/app/articles/1534323144280.jpg','تاخیر انداز شعله,کندسوز کننده ها,ATH,پلی آمونیوم فسفات,پلاستیک,رنگ','تاخیر-اندازهای-شعله',879,2,1,'2018-08-15 13:22:24','2022-01-11 05:00:48'),(9,2,'معرفی ساختار شیمیایی رزین اپوکسی','نحوه سنتز رزین اپوکسی و توضیح ساختار شیمیایی و فرمولاسیون رزین اپوکسی به همراه ویدئو آموزشی','<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/uXMLz/vt/frame\" width=\"80%\"></iframe></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در این ویدئو کاربرد رزین اپوکسی در صنایع چوب به نمایش گذاشته شده است.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:24px\">&nbsp;رزین <span style=\"color:#2980b9\"><strong><a href=\"https://www.amazontele.com/product/%D8%B1%D8%B2%DB%8C%D9%86-%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%A9%D9%81%D9%BE%D9%88%D8%B4-%D9%88-%D8%B2%DB%8C%D9%88%D8%B1%D8%A2%D9%84%D8%A7%D8%AA-%D9%88-%D8%B3%D9%86%DA%AF-%D9%85%D8%B5%D9%86%D9%88%D8%B9%DB%8C-%D9%88-%DA%86%D9%88%D8%A8\">اپوکسی شفاف</a></strong></span> و <a href=\"https://www.amazontele.com/product/%D8%B6%D8%AF-%DA%A9%D9%81-%D9%88-%D8%B6%D8%AF-%D8%AD%D8%A8%D8%A7%D8%A8-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%A9%D9%81%D9%BE%D9%88%D8%B4-%D9%87%D8%A7%DB%8C-%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C-%D9%88-%D9%BE%D9%84%DB%8C-%DB%8C%D9%88%D8%B1%D8%AA%D8%A7%D9%86\"><span style=\"color:#2980b9\"><strong>ضد حباب اپوکسی</strong></span></a> را می توانید&nbsp;از آمازون تله خریداری نمایید.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:24px\"><a href=\"https://www.amazontele.com/search_box?q=%D8%B6%D8%AF+%D8%AD%D8%A8%D8%A7%D8%A8\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/Images/ضد حباب.jpg\" style=\"height:400px; width:400px\" /></a></span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رزین اپوکسی یک رزین ترموست است و بیش از 85 درصد رزین های اپوکسی موجود از واکنش اپی کلروهیدرین و دی فنیلول پروپان (با نام تجاری بیس فنول A) حاصل می شوند.&nbsp;<br />\r\nواکنش یک مول بیس فنول A با حداقل دو مول اپی کلروهیدرین در محیط قلیایی و با از بین رفتن گروه&zwnj;های فنولی و تشکیل گروه های هیدروکسی تولید ماده واسط کلریدرین می کند که با ادامه واکنش محصول دی گلیسیدیل اتر بیس فنول A به دست می آید.&nbsp;<br />\r\nدی گلیسیدیل اتر بیس فنول A می تواند مجددا با گروه فعال بیس فنول A موجود در محیط واکنش داده، پلی اتر خطی با جرم مولکولی بالا ایجاد کند.&nbsp;<br />\r\nدر صورت افزایش مقدار زیادی از اپی کلروهیدرین و کنترل واکنش می توان دی گلیسیدیل اتر بیس فنول A را با درصد خلوص بالای 90 درصد به دست آورد.&nbsp;<br />\r\nرزین حاصل از واکنش اپی کلروهیدرین و دی فنیلول پروپان(بیس فنل A)<br />\r\nواکنش تولید ماده واسطه کلریدرین و در ادامه واکنش تولید دی گلیسیدیل اتر بیس فنول A&nbsp;<br />\r\nگروه&zwnj;های شیمیایی موجود در زنجیره رزین خواص ویژه ای به آن می دهند که از آن جمله می توان به موارد زیر اشاره کرد:<br />\r\n▪️ پیوند اتری مقاومت شیمیایی را موجب می شود.&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ پیوند متیل سبب انعطاف و سختی زنجیره می شود.<br />\r\n▪️گروه هیدروکسیل عامل چسبندگی به سطح است.</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️حلقه آروماتیک مقاومت دمایی و سختی را افزایش می دهد.</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️حلقه اپوکسید فقط در دو انتهای زنجیره قرار دارد که عامل ایجاد شبکه سه بعدی و فیلم سخت اپوکسی روی سطح می باشد.<br />\r\nرزین اپوکسی از جرم مولی 200 تا 2700 متغیر است و با تغییر جرم مولی ویسکوزیته رزین و حالت رزین از مایع تا رزین جامد با نقطه ذوب بالا تغییر می&zwnj;کند.&nbsp;<br />\r\nبا افزایش طول زنجیره ها در رزین اپوکسی میزان گروه های عاملی در زنجیره افزایش یافته و میزان گروه های اپوکسید کاهش می یابد که همین موضوع روی خواص مکانیکی شیمیایی رزین اثر دارد.&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به طور کلی رزین های اپوکسی در مقابل اسیدهای معدنی و اسیدهای آلی مقاومت بسیار خوبی دارند که نوع اسید، غلظت اسید و دمای آن از عوامل تعیین کننده هستند.<br />\r\nرزین های اپوکسی در مجاورت مواد اکسیدکننده غلیظ آسیب پذیرند ولی اکسیدکننده های رقیق در کوتاه مدت تخریبی در سیستم اپوکسی ایجاد نمی&zwnj;کنند.<br />\r\nپوشش های اپوکسی در برابر همه انواع مواد قلیایی با هر غلظت و حتی در دماهای بالا مقاومت بسیار خوبی دارند و برای سطوح در مجاورت محلول های نمکی با غلظت زیاد و در دماهای بالا و آب دریا قابل استفاده هستند.&nbsp;<br />\r\nمقاومت رزین اپوکسی در مقابل آب در مقایسه با سایر خواص آن پایین است ولی نسبت به سایر رزین های صنعتی مقاومت بسیار خوبی دارد.<br />\r\nرزین اپوکسی در حضور گازهای خشک نظیر آمونیاک، دی اکسید کربن و گاز کلر شدیدا آسیب می بیند ولی حلال های کلردار به رزین آسیب زیادی نمی&zwnj;زنند. روغن ها و چربی ها نیز روی این رزین اثر ندارند.&nbsp;<br />\r\nرزین های اپوکسی بر روی سطح کاملا تمیز چسبندگی بسیار خوبی دارند ولی میزان تمیزی سطح بر چسبندگی رزین و کیفیت لایه پوشش بسیار مؤثر است.<br />\r\nانواع رزین اپوکسی</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">علاوه بر رزین های اپوکسی مایع یا جامد حاصل از واکنش بین بیس فنول A و اپی کلروهیدرین که با حلال رقیق می شوند و متداول ترین نوع رزین اپوکسی هستند؛ انواع دیگری از رزین های اپوکسی با مقاومت های فیزیکی و شیمیایی وجود دارد که به تعدادی از آنها اشاره &nbsp;می شود.<br />\r\nرزین اپوکسی بیس فنول A بدون حلال&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این رزین تعداد گروه های هیدروکسیل کمتر و تمایل به کریستال شدن کمتری دارد و در دمای اتاق مایع است.&nbsp;<br />\r\nهمچنین به دلیل ویسکوزیته کمتر، حلال کمتری نیاز دارد و با مقاومت شیمیایی بسیار خوب در چسب ها، درزگیرها، بتونه ها و روکش های بدون حلال برای پوشش کف و بدنه مخازن کاربرد دارد.<br />\r\nرزین اپوکسی بر پایه بیس فنول F &nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در مقایسه با رزین اپوکسی بیس فنول A، رزین های اپوکسی بیس فنول F ویسکوزیته کمتر، عدد اپوکسی و ضریب فعالیت بالاتری دارند. این تفاوت سبب می شود که رزین اپوکسی بیس فنول F مقاومت بیشتری نسبت به حلال داشته باشد.&nbsp;<br />\r\nاختلاط این دو نوع رزین، ویسکوزیته را متعادل کرده و برای کاربردهای صنایع ساختمانی مناسب خواهد بود.</span></span></p>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رزین حاصل از واکنش اپی کلروهیدرین و دی فنیلول پروپان(بیس فنل A)</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/epoxy synthesis.jpg\" style=\"height:279px; width:623px\" /></span></span></p>\r\n\r\n<p dir=\"rtl\">&nbsp;</p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">واکنش تولید ماده واسطه کلریدرین و در ادامه واکنش تولید دی گلیسیدیل اتر بیس فنول A</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/epoxy synthesis1.jpg\" style=\"height:279px; width:628px\" /></span></span></p>','/app/articles/1534323650654.png','/app/articles/1534323650542.png','اپوکسی شفاف,اپوکسی بدون حباب,اپوکسی سنگ,لاک اپوکسی ,اپوکسی زیورآلات,اپوکسی کفپوش,رنگ اپوکسی,اپوکسی میز,اپوکسی سه بعدی,اپوکسی,لیست قیمت,ضد حباب','معرفی-ساختار-شیمیایی-رزین-اپوکسی',2204,2,1,'2018-08-15 13:30:50','2022-01-11 16:46:11'),(10,1,'معرفی آلکید رزین ها','آلکید رزینها در رنگهای روغنی کاربرد دارند.','<p dir=\"rtl\" style=\"text-align: justify;\"><strong><span style=\"font-size:22px\"><span style=\"color:#0000FF\"><span style=\"font-family:comic sans ms,cursive\">رزین های آلکید</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رزین های آلکید یکی از متداول ترین و ارزان ترین رزین های سنتزی هستند. رنگ های آلکیدی در مقابل نور خورشید، باران و محیط اسیدی ضعیف مقاومت بسیار خوبی دارند.&nbsp;<br />\r\nرنگ های آلکیدی به تمیزی سطح خیلی حساس نیستند و به سادگی روی سطح می چسبند.&nbsp;<br />\r\nرزین های آلکید در مقابل محیط های خورنده، مقاومت بسیار خوبی دارند؛ بخارات کم اسید سولفوریک و یا پاشیدن اسید رقیق در کیفیت و دوام این رنگ&zwnj;ها تأثیر چندانی ندارد ولی در صورت افزایش غلظت اسید، این رنگ&zwnj;ها هیچ مقاومتی نخواهند داشت.&nbsp;<br />\r\nاستفاده از رنگ&zwnj;های آلکیدی به هیچ وجه در محیط&zwnj;های مجاور با مواد اکسید کننده، اسیدهای آلی و مواد قلیایی توصیه نمی&zwnj;شود.<br />\r\nآلکید رزین حاصل واکنش استری شدن یک پلی ال و یک پلی اسید و یک اسید چرب یک ظرفیتی است. در حقیقت رزین آلکید یک پلی استر است که در ساختمان آن اسید چرب یک ظرفیتی وجود دارد.&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رزین پلی استر سخت و شکننده است ولی وجود روغن یا اسید چرب در زنجیره رزین آلکید قابلیت انعطاف پذیری و دوام رنگ، خاصیت مرطوب کنندگی و قدرت چسبندگی به سطح را بهبود می بخشد و زمان خشک شدن را کندتر می کند.&nbsp;<br />\r\nهمان طور که گفته شد آلکید رزین حاصل واکنش استری شدن یک پلی ال و یک پلی اسید و یک اسید چرب یک ظرفیتی است.&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">☑️ پلی ال؛ الکل هایی هستند که بیش از دو عامل هیدروکسیل دارند. از انواع پلی ال های مصرفی در تولید رزین آلکید می&zwnj;توان به گلیسیرین، پنتا اریتریتول و سوربیتول اشاره کرد.<br />\r\n☑️ پلی اسید؛ اسیدهای آلی با دو یا چند عامل کربوکسیل و یا انیدریدهای آنها از جمله انیدرید فتالیک، انیدرید مالئیک و آدیپیک اسید که نوع پلی اسید مصرفی در خواص نهایی رزین بسیار مؤثر است.<br />\r\n☑️ اسید چرب؛ رزین های تولید شده از اسید چرب به دلیل درجه خلوص بالاتر اسید چرب، رنگ روشن تر و مقاومت شیمیایی بالاتری دارند و در عین حال هزینه تولید رزین در این موارد بیشتر است و مشکلاتی از قبیل خورندگی اسید چرب و زنگ زدگی ظرف وجود دارد.<br />\r\nنوع و مقدار روغن روی خواص رزین از جمله سرعت خشک شدن بیشترین اثر را دارد.&nbsp;<br />\r\nهر چه تعداد پیوندهای دوگانه و سه گانه در زنجیره اسید چرب بیشتر باشد، اتصالات عرضی که عامل ایجاد شبکه هستند بیشتر خواهد بود و شبکه سه بعدی سریع تر تشکیل شده و مقاوم تر خواهد بود.&nbsp;<br />\r\nروغن سویا، کرچک، نارگیل، بزرک و آفتابگردان از انواع روغن&zwnj;های مصرفی در رزین آلکید هستند.&nbsp;<br />\r\nعموما روغن ها بر اساس چگونگی خشک شوندگی در هوا به 3 گروه تقسیم می شوند:</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️روغن های غیر خشک شونده؛ مانند روغن نارگیل، روغن کرچک و روغن پنبه دانه که دارای پیوندهای اشباع هستند و در هوا خشک نمی شوند.&nbsp;<br />\r\nاین روغن ها در رزین های آلکید کوره ای مصرف دارند.&nbsp;<br />\r\n▪️روغن های نیمه خشک شونده؛ نظیر روغن سویا و روغن تال که در هوا به صورت نیمه جامد خشک می شوند و در رزین&zwnj;های آلکید جهت مصارف کوره ای، لاک نیتروسلولز و رنگ&zwnj;های ساختمانی کاربرد دارند.<br />\r\n▪️روغن های خشک شونده؛ مانند روغن بزرک و روغن کرچک آبگیری شده که دارای پیوندهای غیر اشباع در زنجیره هستند و با اکسیژن هوا در دمای محیط واکنش می دهند. تعداد و نحوه قرار گرفتن این پیوندهای غیر اشباع در زنجیره روی سرعت خشک شدن آن مؤثر است.&nbsp;<br />\r\nاز این روغن ها در رزین های مصرفی در رنگ روغنی ساختمانی و ضد زنگ آلکیدی استفاده می شود.<br />\r\nمقدار روغن روی چسبندگی، انعطاف و قابلیت انحلال مؤثر است. هر چه مقدار روغن کمتر باشد چسبندگی کمتر بوده و در حلال&zwnj;های آروماتیک بهتر حل می&zwnj;شود. هر چه درصد روغن بیشتر باشد در حلال های آلیفاتیک بهتر حل شده، رزین نرم تر و سختی فیلم تشکیل شده کمتر خواهد بود.&nbsp;<br />\r\nدر مورد براقیت رزین می توان به طور کلی گفت با افزایش درصد روغن، براقیت افت پیدا می کند. &nbsp;<br />\r\nرزین آلکید بر حسب نوع و میزان روغن یا اسید چرب مصرفی به سه گروه عمده آلکید لانگ اویل، مدیوم اویل و شورت اویل تقسیم بندی می شود.&nbsp;<br />\r\nدر تولید رزین های آلکید مدیوم و شورت اویل از روغن های اشباع غیر خشک شونده مانند کرچک و روغن نارگیل و در فرمولاسیون رزین های آلکید لانگ اویل از روغن های خشک شونده و نیمه خشک شونده غیر اشباع نظیر روغن بزرک، کرچک بی آب و سویا استفاده می شود.&nbsp;<br />\r\nبه همین جهت رزین های آلکید لانگ اویل با جذب اکسیژن هوا خشک می&zwnj;شوند و رزین های آلکید شورت اویل برای خشک شدن به حرارت نیاز دارند.<br />\r\nرزین شورت اویل</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در ساخت رنگ های فوری نیتروسلولزی و رنگ های کوره ای کاربرد دارد.&nbsp;<br />\r\nاز مشخصات این رزین می توان به موارد زیر اشاره کرد:&nbsp;</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️معمولا درصد روغن آن 44-25 درصد است.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ در حلال های آلیفاتیک کمتر و در حلال های آروماتیک (از جمله تولوئن و زایلن) بیشتر انحلال پذیر است.<br />\r\n▪️ به دلیل مقدار کم روغن سیالیت و روانی آن خوب نیست.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ خاصیت قلم خوری ضعیفی دارد و معمولا به روش اسپری اعمال می شود.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ به فیلم رنگ سختی بیشتری می دهد و انعطاف پذیری کمتری دارد.<br />\r\n▪️ در مقابل سایش و ضربه مقاومت کمتری دارد.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ برای خشک شدن به حرارت و یا عامل خشک کننده نیاز دارد و خشک شدن آن در کوره سریع است.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ویسکوزیته بالایی دارد.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️مقاومت شیمیایی و حرارتی بالایی دارد.<br />\r\nرزین مدیوم اویل</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این رزین که حد واسط رزین لانگ اویل و شورت اویل است خواص حد واسط دارد و جهت تولید رنگ های هوا خشک ساختمانی با مقاومت شیمیایی خوب از جمله رنگ سوله&zwnj;های صنعتی، رنگ بدنه دستگاه ها، ماشین آلات و رنگ&zwnj;های کوره ای با حرارت پایین به کار می رود.&nbsp;<br />\r\nاز مشخصات این رزین به موارد زیر اشاره می گردد:</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ درصد روغن آن 55-45 درصد است.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️با توجه به نوع و درصد روغن، خواصی مشابه رزین شورت اویل یا رزین لانگ اویل دارد.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ در مخلوطی از حلال های آلیفاتیک و آروماتیک حل می شود.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️در مقایسه با رزین لانگ اویل، در برابر رطوبت مقاومت بالاتری دارد.<br />\r\nرزین لانگ اویل</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این رزین ارزان ترین رزین آلکید است و کمترین مقاومت را دارد و جهت تولید رنگ های ساختمانی (رنگ روغنی مات و براق) استفاده می شود.&nbsp;<br />\r\nاز جمله خواص این نوع رزین می توان موارد زیر را نام برد:</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ درصد روغن آن 74-54 درصد است.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ در حلال های آلیفاتیک انحلال پذیر است و در حلال های آروماتیک به میزان کم حل می شود.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ سرعت خشک شدن آن کمتر است.<br />\r\n▪️ خاصیت قلم خوری بهتری دارد و با قلم مو یا غلطک به راحتی اعمال می شود.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ انعطاف پذیری بیشتر و ویسکوزیته پایین تری دارد.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ مقاومت در برابر ضربه این رزین بهتر از دو نوع قبلی است.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">▪️ سطح فیلم رنگ سختی کمتری دارد.</span></span></p>','/app/articles/1534324938678.jpg','/app/articles/1534324938248.jpg','رنگ روغنی,آلکید لانگ,آلکید مدیوم,آلکید شورت,طول روغن,اسید چرب,پنتا ارتریتول,پلی اسید,پلی الکل,انیدرید فتالیک','معرفی-آلکید-رزین-ها',1276,3,1,'2018-08-15 13:52:18','2022-01-09 19:45:34'),(11,1,'پوشش های اتیل سیلیکات','رزین های اتیل سیلیکات در پوشش های ضد خوردگی کاربرد دارند','<p dir=\"rtl\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">زینک سیلیکات معدنی</span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این پوشش دو جزئی و به صورت مایع با ویسکوزیته بالا تهیه می شود و به سهولت بوسیله Airspray ، Airless spray بر روی سطوح و ورقه های کربن استیل پوشش داده می شود.&nbsp;<br />\r\nخصوصیت بارز این نوع پوشش حفاظت کاتدیک از سازه های فلزی در برابر عوامل خورنده شیمیایی موجود در محیط بوده و در واقع پس از اجرای این پوشش بر سطح سازه مورد نظر و طی شدن فعل و انفعالات شیمیایی خاص در مجاورت رطوبت هوا، یک لایه جدید فیلم خشک 92 تا 96 درصدی از فلز روی با خلوص 99/99 % تشکیل گردیده که در واقع به عنوان سپری فلزی از سازه&zwnj;های مختلف در برابر آسیب&zwnj;ها و صدمات ناشی از خوردگی و زنگ زدگی (از طریق آزاد سازی الکترون) محافظت می نماید.&nbsp;<br />\r\nدر زینک سیلیکات معدنی ذرات روی در تماس مستقیم با سطح فلز هستند و در این موارد محصولات حاصل از خوردگی خنثی و بی اثر هستند و مانند مانعی در برابر خوردگی عمل می&zwnj;کنند.&nbsp;<br />\r\nمزایای زینک سیلیکات معدنی</span></span></p>\r\n\r\n<p dir=\"rtl\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برخی از ویژگی&zwnj;های منحصر به فرد و بی نظیر این پوشش با مراجعه به نتایج آزمایشگاهی و عملی به ترتیب ذیل قابل بررسی و مشاهده است:<br />\r\n1- فیلم تشکیل شده سخت تر و مقاوم تر از پوشش گالوانیزه گرم است.&nbsp;<br />\r\n2- عملکرد و کارایی این سیستم&zwnj;ها در حضور پوشش رویه تا حد زیادی بهبود پیدا می&zwnj;کند.&nbsp;<br />\r\n3- در مناطق شهری حفاظت در برابر خوردگی زینک سیلیکات معدنی با پوشش گالوانیزه گرم یکسان است.<br />\r\n4- در مناطق ساحلی دوام و ماندگاری زینک سیلیکات معدنی بسیار بالا (very long term) است و بیشتر از پوشش گالوانیزه گرم است.&nbsp;<br />\r\n5- چسبندگی فوق العاده عالی به سطوح فلزی همچون فولاد، آلومینیوم، سطوح غیر فلزی و... دارد.<br />\r\n6- امکان جوشکاری و ماشین کاری بر روی این پوشش به دلیل ماهیت فلزی آن و ترمیم درزها یا ترک&zwnj;های بوجود آمده&nbsp;<br />\r\n7- جلوگیری از سرایت آتش در صورت بروز حوادث غیر مترقبه<br />\r\n8- قابلیت اجرای پوشش در محیط&zwnj;های با درصد رطوبت بالا<br />\r\n9- مکمل و ترمیم کننده گالوانیزه گرم<br />\r\n10- مقاومت حرارتی تا 400 درجه سانتیگراد<br />\r\n11- مقاومت در برابر مواد خورنده اسیدی و قلیایی<br />\r\n12- مقاومت در برابر انواع ضربات مکانیکی، سایش و خراشیدگی<br />\r\n13- مقاومت در برابر تابش اشعه مستقیم خورشید و عدم فرسایش آن<br />\r\n14- انتقال جریان الکتریکی ضعیف تا متوسط بنا بر میزان ضخامت پوشش&nbsp;<br />\r\n15- کاربرد این پوشش بدون نیاز به آستر و حتی رویه<br />\r\n16- سپری کردن آزمایش سالت اسپری به مدت 2000 ساعت (به طور معمول هر 100 ساعت آزمایش سالت اسپری معادل 1 سال مقاومت در محیط&zwnj;های بیرونی است)</span></span></p>','/app/articles/1534325317932.jpg','/app/articles/1534325317209.jpg','پوشش,ضد خوردگی,اتیل سیلیکات ,SILBOND 40,زینک ریچ,زینک فسفات,اکسید آهن میکایی','پوشش-های-اتیل-سیلیکات',1065,2,1,'2018-08-15 13:58:37','2022-01-09 05:43:47'),(12,3,'دید رنگی یا Color vision','دید انسان از اشیاء محیط اطراف بر اساس بر همکنش نور با مخروط های رنگی چشم می باشد','<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;توانایی یک ارگانیسم یا ماشین برای تشخیص اشیا بر اساس طول موج (یا بسامد) از نور بازتابیده، منتشر شده یا انتقال یافته است. رنگ&zwnj;ها می&zwnj;توانند به روش&zwnj;های مختلفی سنجیده یا اندازه&zwnj;گیری شوند. چراکه درک یک شخص از رنگ&zwnj;ها، فرایندی ذهنی است که طی آن،مغز، در پاسخ به محرک&zwnj;های نوری که به انواع مختلفی از یاخته&zwnj;های مخروطی در چشم می&zwnj;رسد، واکنش نشان می&zwnj;دهد. در حقیقت، افراد مختلف، تصویر یکسانی از اشیای روشن یا منبع نور را، به روش&zwnj;های مختلف می&zwnj;بینند.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">????یاخته مخروطی</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">یاخته&zwnj;های دوکی نوعی از یاخته&zwnj;های گیرندهٔ نور هستند که در انتهای چشم و در شبکیه قرار دارند. یاخته&zwnj;های دوکی، برخلاف یاخته&zwnj;های استوانه&zwnj;ای، در نور قوی بیشتر تحریک می&zwnj;شوند. این یاخته&zwnj;ها انرژی نورانی را به پیام عصبی تبدیل کرده و به مغز توانایی دیدن رنگ&zwnj;ها و جزئیات ظریف اشیا را می&zwnj;دهند.<br />\r\nدر انسان ۳ نوع یاختهٔ دوکی وجود دارد که هر کدام از آن&zwnj;ها به طول موج خاصی از نور حساسیت نشان می&zwnj;دهند: ۵۶۰ نانومتر (رنگ قرمز)، ۵۳۰ نانومتر (رنگ سبز)، ۴۲۴ نانومتر (رنگ آبی). از ترکیب این رنگ&zwnj;ها، مغز قادر به دیدن رنگ&zwnj;های طیف مرئی می&zwnj;شود.</span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">منحنی نشان&zwnj;دهندهٔ میزان تحریک هر کدام از ۳ نوع یاختهٔ دوکی با توجه به طول موج:<br />\r\n<img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/TSCurve.jpg\" style=\"height:391px; width:600px\" /></span></span></p>','/app/articles/1534326168228.jpg','/app/articles/1534326168892.jpg','فیزیک رنگ,روانشناسی رنگ,پیگمنت,رنگدانه,مخروط های رنگی,Color vision,کالریمتری','دید-رنگی-یا-Color-vision',850,3,1,'2018-08-15 14:12:48','2022-01-12 00:38:30'),(13,2,'اپوکسی نوالاک و کاربرد آن','خواص اپوکسی نوالاک چیست؟','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><a href=\"https://www.amazontele.com/product/%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C-%D8%B1%D8%B2%DB%8C%D9%86-%D9%88%DB%8C%D8%B3%DA%A9%D9%88%D8%B2%DB%8C%D8%AA%D9%87-%D9%BE%D8%A7%DB%8C%DB%8C%D9%86-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%A9%D9%81%D9%BE%D9%88%D8%B4-%D9%88-%D8%B2%DB%8C%D9%88%D8%B1%D8%A2%D9%84%D8%A7%D8%AA-%D9%88-%D8%B3%D9%86%DA%AF-%D9%85%D8%B5%D9%86%D9%88%D8%B9%DB%8C-%D9%88-%DA%86%D9%88%D8%A8\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/اپوکسی ویسکوزیته پایین.jpg\" style=\"height:495px; width:480px\" /></a></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><a href=\"https://www.amazontele.com/product/%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C-%D8%B1%D8%B2%DB%8C%D9%86-%D9%88%DB%8C%D8%B3%DA%A9%D9%88%D8%B2%DB%8C%D8%AA%D9%87-%D9%BE%D8%A7%DB%8C%DB%8C%D9%86-%D9%85%D8%AE%D8%B5%D9%88%D8%B5-%DA%A9%D9%81%D9%BE%D9%88%D8%B4-%D9%88-%D8%B2%DB%8C%D9%88%D8%B1%D8%A2%D9%84%D8%A7%D8%AA-%D9%88-%D8%B3%D9%86%DA%AF-%D9%85%D8%B5%D9%86%D9%88%D8%B9%DB%8C-%D9%88-%DA%86%D9%88%D8%A8\"><span style=\"color:#2980b9\"><span style=\"font-size:24px\">جهت خرید اپوکسی ویسکوزیته پایین روی عکس کلیک کنید</span></span></a></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:11pt\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">کفپوش&zwnj; اپوکسی نووالاک</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\"> (EPN) </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">به طور قابل ملاحظه&zwnj;ای خواص مقاومت حرارتی و شیمیایی بالاتری در مقایسه با سیستم&zwnj;های کفپوش اپوکسی متداول بر پایه بیس&zwnj;فنول</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\"> A </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">فراهم می&zwnj;کند</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:11pt\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">اپوکسی نووالاک به دلیل تبدیل اپوکسی بر پایه بیس&zwnj;فنول</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\"> A </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">به پیش&zwnj;ماده&zwnj;های اپوکسی نوالاک، عاملیت (میانگین تعداد گروه&zwnj;های فعال در هر مولکول) بیشتری دارد. همچنین این فرمولاسیون دانسیته اتصالات عرضی بالاتری را فراهم می&zwnj;کند که باعث ایجاد مقاومت شیمیایی و خواص حرارتی خوب می شود. این مقاومت شامل مقاومت در برابر شیرابه&zwnj; های غلیظ، سولفوریک اسید (</span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">۹۸%)</span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">، سدیم هیدروکسید (</span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">۵۰%) </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">و آفت&zwnj;کش&zwnj;ها می&zwnj;شود</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:11pt\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">سیستم&zwnj;های کفپوش اپوکسی نووالاک </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">۱۰۰%</span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\"> جامد برای استفاده در مکان هایی که به مقاومت جدی در برابر مواد شیمیایی قوی و حلال&zwnj;ها نیاز باشد، مناسب هستند. سیستم&zwnj;های</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\"> EPN </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">در مخزن&zwnj;های مخصوص حلال، بستر پمپ&zwnj;ها، گودال&zwnj;ها و دیگر سطوحی که در معرض نور بسیاری هستند، استفاده می&zwnj;شوند زیر اپوکسی نووالاک مثل اپوکسی بر پایه بیس فنول آ نبوده و مقاومت مناسبی در برابر نور خورشید دارد که امر باعث می شود رزین</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\"> EPN </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">مثل رزین اپوکسی بر پایه</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\"> Bisphenol A </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">تخریب و گچی نشود. صنایع الکتریکی و بهداشتی و همچنین دستگاه&zwnj;های تصفیه ضایعات و مواد شیمیایی، دستگاه&zwnj;های تولید برق و ماشین&zwnj;آلات نساجی همگی مثال&zwnj;هایی برای مکان&zwnj;هایی هستند که در آن&zwnj;ها استفاده بسیاری از کفپوش اپوکسی نووالاک می&zwnj;شود و همچنین از دیگر کاربری های اپوکسی نووالاک می توان به پی&zwnj;های مقعر، دیواره سدها، دیوار اتاق&zwnj;ها، مخزن&zwnj;ها، گودال&zwnj;ها، جداول، پی&zwnj;های منفرد و &hellip; اشاره کرد</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:11pt\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">این ماده ی به شدت مقاوم، برای استفاده در مجاورت دستگاه&zwnj;های تصفیه فاضلاب تخصیص داده شده&zwnj; است.&nbsp;این را می دانیم که ماهیت خورنده مواد شیمیایی مورد استفاده در فرآیندهای روزانه چالش&zwnj;هایی را در زمان انتخاب یک کفپوش مناسب ایجاد می&zwnj;کند</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:11pt\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">فعالیت های روزانه، بستر را در معرض ریختن شیرابه تغلیظ شده، اسید سولفوریک (</span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">۹۸%)</span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">، سدیم هیدروکسید (</span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">۵۰%) </span></span><span style=\"font-size:13.5pt\"><span style=\"color:#424242\">و آفت&zwnj;کش&zwnj;ها قرار می&zwnj;دهد و حتی در مواردی که ریختن مداوم مواد شیمیایی غلیظ اتفاق میفتد در صورت استفاده نکردن از پوشش مناسب یا بدون پوشش گذاشتن سطح، قسمتی که در تماس با مواد شیمیایی است در طول زمان دچار خوردگی شدید شده و کارایی خود را از دست می دهد. اسید سولفوریک غلیظ به شدت خورنده است. این ماده شیمیایی خطرناک قادر به خوردن پوست، کاغذ، فلزات و حتی در برخی موارد، سنگ می باشد. به خودی خود، فقط اپوکسی نوالاک مقاومت شیمیایی مورد نیاز برای جلوگیری از چنین زیان&zwnj;هایی را عرضه می&zwnj;کند</span></span><span dir=\"LTR\" style=\"font-size:13.5pt\"><span style=\"color:#424242\">.</span></span></span></span></span></p>','/app/articles/1534397114289.jpg','/app/articles/1534397115745.jpg','اپوکسی,نوالاک,مقاومت شیمیایی,پوشش,ضد اسید,رزین,رنگ,پیگمنت,مواد شیمیایی,قیمت,اپوکسی چوب,لیست قیمت','اپوکسی-نوالاک-و-کاربرد-آن',1747,3,1,'2018-08-16 09:55:15','2022-01-11 23:55:51'),(14,3,'تاثیر آب و هوا روی پوشش ها','بیشترین آسیب های آب و هوا روی پوشش ها شامل مواردی چون تشعشات نور خورشید، رطوبت و گرماست','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:22px\"><span style=\"color:#0000FF\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong>تاثیر آب و هوا روی پوشش&shy;ها</strong></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:12pt\"><span style=\"background-color:white\"><span style=\"font-size:inherit\"><span style=\"font-size:16.0pt\"><span style=\"color:black\">بیشترین آسیب های آب و هوا روی پوشش&shy;ها شامل مواردی چون تشعشات نور خورشید، رطوبت و گرماست. نور فرابنفش (<span dir=\"LTR\" style=\"font-size:16.0pt\"><span style=\"color:black\">UV</span></span></span></span><span style=\"font-size:16.0pt\"><span style=\"color:black\">) قسمتی از نور خورشید است که انرژی کافی برای شکستن پیوند&shy;های شیمیایی و شروع واکنش تخریبی رادیکال آزاد در مورد ترکیبات آلی را دارد. این مورد بویژه برای طول موج&shy; های کوتاه&shy;تر یعنی</span></span><span style=\"font-size:16.0pt\"><span style=\"color:black\">&nbsp;<span dir=\"LTR\" style=\"font-size:16.0pt\"><span style=\"color:black\">UV-A</span></span></span></span>&nbsp;<span style=\"font-size:16.0pt\"><span style=\"color:black\">و</span></span><span style=\"font-size:16.0pt\"><span style=\"color:black\">&nbsp;<span dir=\"LTR\" style=\"font-size:16.0pt\"><span style=\"color:black\">UV-B</span></span></span></span>&nbsp;<span style=\"font-size:16.0pt\"><span style=\"color:black\">محتمل&shy;تر است.</span></span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:12pt\"><span style=\"background-color:white\"><span style=\"font-size:inherit\"><span style=\"font-size:16.0pt\"><span style=\"color:black\">شیمی برخی از پوشش&shy;ها مانند اپوکسی و پلی استر، به این تشعشات بسیار حساس هستند و در این شرایط طول عمر بالایی نخواهند داشت، در حالی که برخی دیگر مانند فلوروپلیمر&shy;ها بسیار در این شرایط مقاوم اند. مقاومت در برابر تابش فرابنفش بسیاری از پوشش&shy;ها در حد قابل ملاحظه&shy;ای با افزودنی&shy; های پایدار کننده بهبود می&shy;یابد، اما بطور کامل عملی نخواهد بود. بسیاری از این طرح&shy;های پایداری نیز هنوز سطح وسیعی از پوشش را محافظت نمی&shy;کنند و این سطوح همان جاهایی هستند که تخریب آغاز می&shy;گردد. تخریب سطح معمولا با کاهش براقیت، گچی شدن، ترک، کاهش قدرت رنگی و زرد شدن همراه خواهد بود. اگر نور فرابنفش از پوشش عبور کند، زیرآیند&shy;هایی مانند چوب را تخریب کرده، در نتیجه اتصال بین پوشش و زیرآیند و در نهایت چسبندگی از بین می&shy;رود.</span></span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:12pt\"><span style=\"background-color:white\"><span style=\"font-size:inherit\"><span style=\"font-size:16.0pt\"><span style=\"color:black\">طول موج&shy;های بلندتر فرابنفش(<span dir=\"LTR\" style=\"font-size:16.0pt\"><span style=\"color:black\">UV-A</span></span></span></span><span style=\"font-size:16.0pt\"><span style=\"color:black\">) و هم&shy;چنین نور مرئی می&shy;توانند شروع کننده واکنش تخریب نوری باشند. بسیاری از رنگدانه &shy;ها بخصوص رنگدانه&shy; های آلی، و محصولات حاصل از تخریب نوری مانند پراکساید&shy;ها به این طول موج حساسند. امواج مادون قرمز نزدیک موجود در نور خورشید می&shy;تواند باعث گرم شدن رنگدانه&shy;ها شود چیزی که در مورد رنگ&shy;های تیره خودرو&shy;ها در هوای گرم مشاهده می&shy;شود. این حرارت هم می&shy;تواند از طریق جنبش&shy;های مکانیکی-حرارتی باعث تخریب و هم باعث افزایش نرخ از دست دادن پایدار کننده&shy;ها و تسریع تخریب شیمیایی شود.</span></span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:12pt\"><span style=\"background-color:white\"><span style=\"font-size:inherit\"><span style=\"font-size:16.0pt\"><span style=\"color:black\">رطوبت نیز یک عامل مهم در تخریب پوشش&shy;ها (اعم از آلی یا معدنی) و سطوح است. بسیاری از پوشش&shy;ها بدلیل انجام واکنش هیدرولیز تخریب می&shy;شوند. دلایل تخریبی دیگر ناشی از تورم و آب رفتن (انقباض) از سطح تر به خشک و برعکس است. رطوبت با از بین بردن تثبیت کننده&shy;ها شرایط مناسبی را برای رشد میکروارگانیزم&shy;هایی چون کپک فراهم می&shy;کند. بعضی از پوشش&shy;ها مانند پوشش&shy;های بتنی باید تنفس پذیر (تراوا نسبت به رطوبت) باشند تا امکان تنفس برای زیرآیند فراهم شود در حالی&shy;که پوشش&shy;های محافظتی ضد خوردگی باید کاملا نسبت به رطوبت غیرتراوا باشند تا بتوانند از سطح حفاظت کنند.</span></span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:12pt\"><span style=\"background-color:white\"><span style=\"font-size:inherit\"><span style=\"font-size:16.0pt\"><span style=\"color:black\">هر کدام از پارامتر&shy;های اصلی آب و هوا (رطوبت، نور و حرارت) مستقل نیستند. نور می&shy;تواند دما را تحت تاثیر قرار دهد که آن&shy;هم روی رطوبت اثرگذار است. بعلاوه شرایط بیرونی اصلا پایدار نیست. هرکدام از این پارامتر&shy;ها در هر مکانی و در دوره&shy; ها و بازه&shy; های مختلفی (ساعت، روز، فصل، سال، الگو&shy;های آب و هوایی) با الگو&shy;های پیچیده و غیر قابل بازیافتی تغییر می&shy;کنند. پوشش لوله &shy;ها در کارخانجات صنعتی، یا پوشش&shy;های دریایی می&shy;توانند فشار&shy;های اضافی مهمی را ایجاد کنند. </span></span>&nbsp;</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\">&nbsp;</p>','/app/articles/1534398890223.jpg','/app/articles/1534398890915.jpg','نور uv,UV-A,UV-B,ماوراءبنفش,تخریب پوشش ها,خوردگی,رنگ,پیگمنت,آنتی یو وی,جو زدگی,فرابنفش,تینووین,BASF','تاثیر-آب-و-هوا-روی-پوشش-ها',668,3,1,'2018-08-16 10:24:50','2022-01-11 22:40:30'),(15,1,'مکانیسم دیسپرس شدن پیگمنت ها','دیسپرس رنگدانه در حین چندین مرحله متوالی که تا بخشی هم زمان هستند، اتفاق می افتد: ترشوندگی،  دیسپرس و پایدارسازی.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/iM8Dy/vt/frame\" width=\"80%\"></iframe></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\">در این ویدئو مکانیسم دیسپرس شدن پیگمنتها توضیح داده شده است .امیدوارم از دیدن این ویدئو لذت ببرید.</span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\">This video is about pigment dispersion&nbsp;</span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><strong><span style=\"background-color:white\"><span style=\"color:#333333\">افزودنی های ترکننده و &nbsp;<u><a href=\"https://www.amazontele.com/search_box?q=%D8%AF%DB%8C%D8%B3%D9%BE%D8%B1%D8%B3+%DA%A9%D9%86%D9%86%D8%AF%D9%87&amp;status=1\" style=\"color:blue; text-decoration:underline\">دیسپرس کننده</a></u></span></span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">&nbsp;دیسپرس بهینه و پایدارسازی ذرات رنگدانه عامل اصلی تعیین ویژگی&shy; های نهایی لاک&shy;ها، پوشرنگ &shy;ها و مرکب&shy;های چاپ است. رنگدانه&shy; ها و پرکننده&shy; های فرمولاسیون باید دارای اندازه ذرات کوچک بوده، به &shy;خوبی تر شوند و به&nbsp;بهترین نحو توزیع شوند. تنها در این حالت است که شدت رنگی، براقیت، قدرت پشت&shy; پوشی، پایداری نوری و مقاومت جوی مطلوبی حاصل می&shy;شود.دیسپرس و پایداری ذرات رنگدانه نیازمند زمان و انرژی است و بدون استفاده از افزودنی&shy;های &nbsp;دیسپرس کننده&shy; و ترکننده قابل دست&shy;یابی نیست.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"background-color:white\">چه اتفاقی حین &nbsp;دیسپرس شدن رخ می&shy;دهد؟</span></strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">&nbsp;دیسپرس رنگدانه در حین چندین مرحله متوالی که تا بخشی هم&shy;زمان هستند، اتفاق می&shy;افتد: ترشوندگی، &nbsp;دیسپرس و پایدارسازی.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong><span style=\"background-color:white\">ترشوندگی</span></strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">برای داشتن توزیع خوب ذرات رنگدانه در یک مایع، باید ذرات به خوبی ترشوند. هوای گیرافتاده در پودر رنگدانه بایدکاملا خارج شده و مایع اطراف ذرات رنگدانه را احاطه کند. فرایند ترشوندگی جامد توسط معادله یانگ</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">(Young)</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">بیان می&shy;شود:</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\"><img alt=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/young%20equation.jpg\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/young%20equation.jpg\" style=\"height:190px; width:320px\" /></span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">که در این معادله،</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">ϓs</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">انرژی آزاد سطح جامد،</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">ϓsl</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">انرژی بین&shy;سطحی جامد/مایع،</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">ϓl</span></span></span>&nbsp;&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">کشش سطحی مایع و</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">&theta;</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">زاویه تماس جامد/مایع است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">با ترشوندگی و گسترش خودبه &shy;خودی، زاویه تماس صفر و در نتیجه</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">cos&theta;</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">برابر با 1 می&shy;شود. پس خواهیم داشت:</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">ϓs&nbsp;&ndash;&nbsp;ϓsl&nbsp;=&nbsp;ϓl</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">برای اینکه مایع سطح جامد را تر کند، کشش سطحی مایع باید کم&shy;تر از انرژی آزاد سطح جامد باشد. مایع با کشش&shy;سطحی کم&shy;تر، بهتر از مایع با کشش سطحی بالاتر می&shy;تواند رنگدانه را تر کند. بنابراین، افزودنی&shy; هایی که ترشوندگی را بهبود می&shy;دهند، باید بتوانند کشش سطحی مایع را کم کنند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">اگرچه افزودنی&shy;های ترکننده و &nbsp;دیسپرس کننده&shy; تنها سبب کاهش کشش&shy; سطحی مایع نمی&shy;شوند. این مواد از آن&shy;جایی که توسط گروه&shy; های موجود در سطح رنگدانه جذب می&shy;شوند، مرز&shy;های سطح را نیز تغییر می&shy;دهند. بنابراین کشش سطحی دیگر بین رنگدانه و مایع نیست، بلکه بین افزودنی و مایع است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی &shy;های ترکننده و &nbsp;دیسپرس کننده،&shy; کشش سطحی مایع و کشش بین&shy; سطحی رنگدانه و مایع را کم می&shy;کنند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong>&nbsp;</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong><span style=\"background-color:white\">&nbsp;دیسپرس شدن:</span></strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">پس از ترشدن ذرات رنگدانه توسط محلول رزین در اطرافشان، سطح ذرات توسط یک ماده افزودنی سطح فعال پوشش داده شده است. افزودنی سبب کاهش برهم&shy; کنش&shy; های بین ذرات رنگدانه شده و گرانروی پراکنه پایه را کم می&shy;کند. بدین وسیله می&shy;توان از مقدار بیش&shy;تری از رنگدانه استفاده کرد که در امر &nbsp;دیسپرس مکانیکی حائز اهمیت است. چنین فرمولاسیون&shy;های بهینه شده&shy;ای برای تجهیزات آسیاب مدرن مانند انحلال&shy; دهنده&shy;ها، آسیاب دانه&shy;ای و آسیاب سه&shy; غلتکی مناسب است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در فرایند &nbsp;دیسپرس، ذرات کلوخه رنگدانه به ذرات اولیه و انبوهه&shy;های کوچک&shy;تر شکسته می&shy;شود. معمولا، انبوهه &shy;ها شکسته نمی&shy;شوند. ذرات اولیه در انبوهه&shy; ها با پیوندهای قوی به سطح یکدیگر متصل &shy;اند به نحوی که جدا کردن آن&shy;ها از هم، غیرممکن است. در صنعت، میزان انبوهه&shy; ها تحت کنترل است. </span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">میزان انبوهه</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">&shy;</span></span></span><span style=\"background-color:white\"><span style=\"color:black\">ها بر رنگ رنگدانه اثرگذار است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در فرایند &nbsp;دیسپرس، شکستن کلوخه&shy; ها و انبوهه&shy; ها نیازمند انرژی است. کار لازم برابر است با:</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">dW = &upsih; . dA</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در این معادله</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">W</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">انرژی بین &shy;سطحی سطح،</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">&upsih;</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">کشش سطحی و</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">A</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">مساحت بین&shy;سطحی است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">این معادله بیان می&shy;کند که میزان انرژی</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">dW</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">لازم است تا در کشش سطحی</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">&upsih;</span></span></span><span style=\"background-color:white\"><span style=\"color:black\">، در حین &nbsp;دیسپرس (بر اثر شکستن کلوخه&shy;ها) سطح به میزان</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">dA</span></span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">افزایش یابد. هرچه کشش سطحی کم&shy;تر باشد، افزایش مساحت سطح به ازای اعمال انرژی مشخص، بیش&shy;تر خواهد شد. بنابراین، برای ایجاد تغییری مشخص در مساحت سطح در حضور یک افزودنی &nbsp;دیسپرس کننده&shy; (یعنی در کشش سطحی کم&shy;تر)، انرژی &nbsp;دیسپرس کم&shy;تری مورد نیاز است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><strong><span style=\"background-color:white\">پایدارسازی:</span></strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در فرایند &nbsp;دیسپرس، کلوخه&shy; های ذرات رنگدانه به ذرات اولیه و انبوهه&shy;ها کوچک&shy;تر شکسته می&shy;شود (شکل</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">1a</span></span></span><span style=\"background-color:white\"><span style=\"color:black\">). تشکیل ذرات اولیه منجر به افزایش مساحت مرز ذره و محیط مایع می&shy;شود (شکل</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">1b</span></span></span><span style=\"background-color:white\"><span style=\"color:black\">). هرچه کشش بین &shy;سطحی بالاتر باشد، جامد تلاش بیش&shy;تری برای کاهش سطح مشترک می&shy;کند. پس ذرات کلوخه شده و تشکیل لخته می&shy;دهند (شکل</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">1c</span></span></span><span style=\"background-color:white\"><span style=\"color:black\">). لخته&shy; شدن به معنای تشکیل کلوخه در سوسپانسیون است. افزودنی&shy;های &nbsp;دیسپرس کننده از تشکیل لخته&shy;ها جلوگیری می&shy;کنند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">به منظور پایدارسازی توزیع ذرات، مولکول&shy;های افزودنی باید در سطح رنگدانه جذب شوند. بدین معنا که مولکول&shy;های افزودنی نیازمند گروه&shy;ها و یا بخش&shy;هایی هستند که توانایی برهم&shy;کنش قوی با سطح رنگدانه از طریق پیوندهای یونی، قطبی و هیدروژنی را داشته باشند. بسته به حلال&shy;پایه یا آب&shy;پایه بودن فرمولاسیون، سازوکارهای متفاوتی در این خصوص وجود خواهند داشت.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در پوشش&shy;های آب &shy;پایه، عامل پایدارسازی اصلی، دافعه الکترواستاتیک است. تئوری</span></span>&nbsp;<span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">DLVO</span></span></span><span style=\"background-color:white\"><span style=\"color:black\">، برهم&shy; کنش&shy; های درون فرمولاسیون را توضیح می&shy;دهد. در تفسیر پایداری پراکنه&shy; های آب&shy;پایه، تعامل بین نیروهای جاذبه و دافعه قابل توجه است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مراحل شماتیک دیسپرس شدن در شکل زیر نمایش داده شده است:</span></span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\"><img alt=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/dispersing.jpg\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/dispersing.jpg\" style=\"height:100px; width:500px\" /></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مولکول&shy;های افزودنی جذب شده از طریق پیوندهای یونی و حرکت آزاد کاتیون&shy;ها، لایه دوگانه الکتروشیمیایی را در اطراف ذرات رنگدانه به وجود می&shy;آورد. در این لایه هر ذره رنگدانه در محلولی حاوی یون&shy;های با بار مخالف قرار گرفته که پیوند مستحکمی با ذره دارد.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">هر دو نیروهای جاذبه و دافعه وابسته به جدایش بین ذرات هستند. در حضور لایه دو گانه، وجود دافعه سبب پایداری پراکنه می&shy;شود. اگر لایه دوگانه الکتریکی با افزودن الکترولیت از بین برود، نیروهای جاذبه غلبه کرده و &nbsp;دیسپرس از بین می&shy;رود. برهم&shy; کنش&shy;های الکترواستاتیک به صورت کمی، توسط پتانسیل زتا بیان می&shy;شود که بر اساس اندازه&shy; گیری پتانسیل در لایه برشی یک ذره در حال حرکت در پراکنه است. هنگامی&shy;که پتانسیل زتا به صفر برسد، تمایل ذرات به کلوخه &shy;شدن افزایش می&shy;یابد.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">سامانه &shy;های رنگی حلال&shy; پایه به صورت الکترواستاتیکی پایدار نمی&shy;شوند. با پایدارسازی فضایی، از کلوخه شدن ذرات جلوگیری می&shy;شود. در این روش ازافزودنی&shy;های پلیمری با گروه&shy; هایی که تمایل به رنگدانه دارند استفاده می&shy;شود. این گروه&shy;ها به سطح رنگدانه متصل شده و در سطح افزودنی نیز جذب شده&shy; اند. بخش پلیمری مسئول سازگاری با سامانه آلی است. این گروه&shy; ها با تحمیل به حلال نیز می&shy;توانند باعث پایداری &shy;شوند. اگر ذرات رنگدانه خیلی بهم نزدیک شود، بخش پلیمری نفوذکرده و تحرک را کاهش می&shy;دهد و در نتیجه انتروپی را کم می&shy;کند. بنابراین ذرات رنگدانه با اطراف پلیمر، از یکدیگر دور شده تا این انتروپی از دست رفته را جبران کنند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">به دلیل تقاضای افزودنی&shy;های ترکننده ودیسپرس کننده&shy;، ترکیب دو اثر الکترواستاتیک و فضایی برای داشتن پراکنه پایدار، پرکاربرد خواهد بود که به آن، پایدارسازی الکترواستریک اطلاق می&shy;شود.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی&shy;های ترکننده و&nbsp;دیسپرس کننده&shy; جدید، از پایدارسازی الکترواستریک برای سامانه&nbsp;&shy;های آب&shy; پایه بهره می&shy;برند. تنها چنین افزودنی&shy;هایی هستند که می&shy;توانند پایداری خوب و طول عمر بالا را به ارمغان بیاورند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:12pt\"><span style=\"font-size:18.0pt\"><span style=\"background-color:white\"><span style=\"color:black\"><a href=\"https://www.amazontele.com/search_box?q=%D8%AF%DB%8C%D8%B3%D9%BE%D8%B1%D8%B3&amp;status=1\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/دیسپرس کننده.jpg\" style=\"height:470px; width:500px\" /></a></span></span></span></span></span></p>\r\n\r\n<p style=\"margin-left: 0in; margin-right: 0in; text-align: right;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:24px\">.</span></span></p>\r\n\r\n<p style=\"margin-left: 0in; margin-right: 0in; text-align: right;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:24px\"><a href=\"https://www.amazontele.com/search_box?q=%D8%AF%DB%8C%D8%B3%D9%BE%D8%B1%D8%B3&amp;status=1\">انواع <span style=\"color:#ff0000\">دیسپرس کننده ها</span> را می توانید از آمازون تله تهیه بفرمایید</a></span></span></p>\r\n\r\n<p style=\"margin-left: 0in; margin-right: 0in; text-align: right;\">&nbsp;</p>','/app/articles/1534407717740.jpg','/app/articles/1534407717613.jpg','دیسپرس کننده,رنگدانه,پیگمنت,efka,byk,افزودنی,رنگدهی,پوشش,رنگ,basf,فیلم آموزشی,پیگمنت های رنگی','مکانیسم-دیسپرس-شدن-پیگمنت-ها',2051,2,1,'2018-08-16 12:51:57','2022-01-11 18:46:19'),(16,3,'کمپانی مرک 350 ساله شد.(تاریخچه شرکت مرک)','شرکت مرک (آلمان) تحت عنوان \" گذشته ، حال ، آینده\" سیصدوپنجاهمین سال تأسیس خودرا جشن می گیرد.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong>مرک<span dir=\"LTR\"> (Merck) </span>سیصد و پنجاهمین سال تولدش راجشن می گیرد</strong></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">شرکت مرک (آلمان) تحت عنوان &quot; گذشته ، حال ، آینده&quot; سیصدوپنجاهمین سال تأسیس خودرا جشن می گیرد</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><br />\r\n<span style=\"color:black\">درسال 1668 (میلادی) داروساز آلمانی</span><span dir=\"LTR\"><span style=\"color:black\"> Friedrich Jacob Merck </span></span><span style=\"color:black\">سنگ بنای تشکیلاتی را پی ریزی کرد که امروز شرکت مرک نام دارد ، یک سازمان علمی-تکنولوژیکی فعال، پویا و جهانی . &quot; 350سال ، عدی است بسیاربزرگ بخصوص وقتی مشاهده می شود که علم ازسال 1668 تا به امروز چه دستاوردهائی داشته است&quot; ...&quot; ما امروز بسیار خوشحالینم وافتخار می کنیم به سهمی که مرک درتحقیق وتوسعه داشته ومصمم هستیم که این راه راادامه دهیم ویا&nbsp; به عبارت دیگر : ما بی نهایت کنجکاویم نسبت به آنچه که درآینده رخ خواهدداد&quot; . این جمله (درگیومه)از آقای</span><span dir=\"LTR\"><span style=\"color:black\">&nbsp; Stefan Oschmann </span></span><span style=\"color:black\">مدیر شرکت نقل شده است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">نقطه اوج این بزرگداشت ،کنفرانسی است که تحت عنوان</span><span dir=\"LTR\"><span style=\"color:black\"> &quot; Curious2018 &ndash; Future Insight&quot;</span></span><span style=\"color:black\">درشهر دارمشتات (آلمان) برگزارخواهدشد ،کنفرانسی که درآن 35 دانشمند (جهانی) ،ازجمله پنج برنده جایزه نوبل درسه روز متوالی دستاوردهای خودرا معرفی خواهندکرد ودرباره علم درسالهای پیش رو به بحث وتبادل خواهندپرداخت. دراین همایش یکهزارمحقق برجسته ازسرارسردنیا حضور یافته و موضوعاتی&nbsp; به شرح زیر ،تم های اصلی تبادل نظرها&nbsp; خواهند بود</span><span dir=\"LTR\"><span style=\"color:black\">.<br />\r\n&quot; (Healthcare &bdquo;Healthy Lives &ndash; new breakthrough therapies and diagnostics&ldquo;, Life Science &bdquo;Life Reimagined &ndash; synthetic biology and beyond&ldquo;, Performance Materials &bdquo;Materials &amp; Solutions &ndash; chemistry and beyond&ldquo;).</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">کلمات کلیدی</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"https://www.amazontele.com/search?category[0]=5&amp;status=1\"><span style=\"color:rgb(0, 0, 0)\"><span style=\"font-size:18px\">قیمت مواد شیمیایی</span></span></a></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"https://www.amazontele.com/search_box?q=%DA%A9%D8%A7%D8%AA%D8%A7%D9%84%DB%8C%D8%B3%D8%AA&amp;status=1\"><span style=\"color:rgb(0, 0, 0)\"><span style=\"font-size:18px\">فروشگاه اینترنتی مواد شیمیایی</span></span></a></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"https://www.amazontele.com/collections?sortby=1&amp;status=1\"><span style=\"color:rgb(0, 0, 0)\"><span style=\"font-size:18px\">فروش اینترنتی مواد شیمیایی مرک</span></span></a></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:black\">برگفته شده از وبلاگ مهندس حمید رقمی</span></strong></span></span></span></p>','/app/articles/1534845643363.jpg','/app/articles/1534845643104.jpg','مرک,آزمایشگاهی,آلمان,خرده فروشی,رنگ,رزین,قیمت مواد شیمیایی مرک,مواد شیمیایی خطرناک','کمپانی-مرک-350-ساله-شد-تاریخچه-شرکت-مرک',625,3,1,'2018-08-21 14:30:43','2022-01-09 08:55:31'),(17,3,'تاریخچه رال رنگی','رال(RAL) فام هائی مشخص شده با ارقام','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><br />\r\n<span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:blue\">رال (کلاسیک) ،استانداردهائی&nbsp; برای&nbsp; صنعت وطراحی، با قدمتی هشتادوپنج ساله</span></strong><strong>&nbsp;</strong><br />\r\n<strong><span dir=\"LTR\"><span style=\"color:#009933\">..... </span></span></strong><strong><span style=\"color:#009933\">با چهل فام شروع شد،توسط</span></strong><strong><span dir=\"LTR\"><span style=\"color:#009933\"> :&nbsp;</span></span></strong><br />\r\n<strong><span dir=\"LTR\"><span style=\"color:black\">&quot;</span></span></strong><strong><span style=\"color:black\">کمیسیون رایش*(دولت آلمان) برای شرایط ارسال- مخفف شده با اِر-آ-اِل</span></strong><strong><span dir=\"LTR\"><span style=\"color:black\">&quot;&nbsp;</span></span></strong><br />\r\n<strong><span dir=\"LTR\"><span style=\"color:black\"><strong>... .&ldquo;Der&nbsp;</strong></span></span></strong><strong><u><span dir=\"LTR\"><span style=\"color:#cc0000\">R</span></span></u></strong><strong><span dir=\"LTR\"><span style=\"color:black\">eichs-</span></span></strong><strong><u><span dir=\"LTR\"><span style=\"color:#cc0000\">A</span></span></u></strong><strong><span dir=\"LTR\"><span style=\"color:black\">usschuss f&uuml;r&nbsp;</span></span></strong><strong><u><span dir=\"LTR\"><span style=\"color:#cc0000\">L</span></span></u></strong><strong><span dir=\"LTR\"><span style=\"color:black\">ieferbedingungen &ndash; abgek&uuml;rzt&nbsp;</span></span></strong><strong><u><span dir=\"LTR\"><span style=\"color:#cc0000\">RAL</span></span></u></strong><strong><span dir=\"LTR\"><span style=\"color:black\">&nbsp;&bdquo; ....</span></span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:black\">درسال 1927کمیسیون فوق الذکر جدولی از فام ها را منتشرکرد که ردوبدل کردن اطلاعاتی مربوط به رنگ ها(فام ها)را تسهیل می کرد. تا آنزمان رسم براین بود که نمونه هائی ازپانل های رنگ شده&nbsp; بین سازنده ومصرف کننده (صنعتی)،بعضاً به دفعات در&quot;رفت وآمد&quot; بود تا توافقی روی فام دلخواه مشتری حاصل گردد. با پیدایش &quot;رال&quot; این روش جای خودرا به اعلام یک عدد داد که طی هشت دهه به مروربه یک جدول طولانی ومشخص شده فام های مختلف با اعداد تبدیل گردید. درحال حاضر مجموعه رال کلاسیک بیش از 210 فام رادربرمی گیرد.</span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><strong><span style=\"color:black\">برگفته شده از وبلاگ مهندس حمید رقمی</span></strong></span></span></span></p>','/app/articles/1534849197664.jpg','/app/articles/1534849197720.jpg','رنگ,رال,فام,اشباع,خلوص,ral','تاریخچه-رال-رنگی',643,3,1,'2018-08-21 15:29:58','2022-01-09 08:52:40'),(18,1,'تخریب در پلیمر ها','انواع فرآیند های تخریبی , بسته به شرایط محیطی که یک پلیمر در آن مورد استفاده قرار می گیرد تا تاریخچه ساخت و ساختمان پلیمر مربوطه فرق می کنند','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><strong>تخریب در پلیمرها</strong></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">تخریب پلیمرها از دیر زمان مورد شناخت بوده است . از بین رفتن سلولز در چوب , لاستیک در تایر ماشین ها و ترک خوردن و زرد شدن فیلم های نقاشی , از معدود مثال های معمولی هستند که می توان نام برد . انواع فرآیند های تخریبی , بسته به شرایط محیطی که یک پلیمر در آن مورد استفاده قرار می گیرد تا تاریخچه ساخت و ساختمان پلیمر مربوطه فرق می کنند و این مسائل و مسائل موثر دیگر همگی نقش مکملی را در کنترل مرحله تعیین کننده سرعت کلی تخریب ایفا می کنند</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">تخریب و اکسایش پلیمر های طبیعی اگر چه مدت هاست که شناخته شده اند اما گونه هایی که در طبیعت</span>&nbsp;<span style=\"color:#444444\">رخ می دهند</span>&nbsp;<span style=\"color:#444444\">پیچیده هستند . پشم و سلولز از این نظر انگشت نما هستند به طوری که درک ما از مکانیزم های اصلی تخریب آنها بسیار اندک است و اطلاعات کمی راجع به آنها داریم . با ورود استر های سلولزی مسائل تخریبی دیگری مثل قابلیت شعله وری و ناپایداری از نظر هیدرولیز شدن و رها شدن اسید ها آشکار گردیدند . در حقیقت هرگونه درک اساسی در مورد مکانیزم این فرآیند ها فقط طی سالهای اخیر حاصل</span>&nbsp;<span style=\"color:#444444\">شده است . با ورود ترموپلاستیک های مصنوعی جدید , مسائل جدید بسیاری نیز مطرح شدند زیرا ک هر یک در نوع و چگونگی تخریب با یکدیگر متفاوت بودند . به عنوان مثال در حالی که پلی متیل متاکریلات</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( PMMA ) </span></span><span style=\"color:#444444\">در دماهای بالا تقریبا به طور کامل ( ۱۰۰</span> <span style=\"color:#444444\">٪ ) به مونومر خود واپلیمریزه</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Depolymerise )&nbsp;</span></span><span style=\"color:#444444\">می شود , پلی وینیل کلراید</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( PVC ) </span></span><span style=\"color:#444444\">به یک مکانیزم سلسله وار</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Unzipping mechanism ) </span></span><span style=\"color:#444444\">تخریب میشود و تولید مواد پلیمری سیر نشده و بخارات اسیدکلریدریک</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( HCl ) </span></span><span style=\"color:#444444\">میکند ( به علت ضعیف بودن پیوند سیگمای</span>&nbsp;<span style=\"color:#444444\">موجود</span>&nbsp;<span style=\"color:#444444\">بین کربن و کلر</span>&nbsp;<span style=\"color:#444444\">در</span><span dir=\"LTR\"><span style=\"color:#444444\"> back bone </span></span><span style=\"color:#444444\">اصلی زنجیر ) . پلی تترا فلوئورو اتیلن</span><span dir=\"LTR\"><span style=\"color:#444444\">&nbsp;( PTFE&nbsp;)&nbsp;</span></span><span style=\"color:#444444\">موسوم به تفلون بسیار پایدار است و اغلب در وسایل پخت و پز غیر چسبنده مورد استفاده قرار میگیرد ( به پایداری در دمای پخت و پز توجه کنید</span><span dir=\"LTR\"><span style=\"color:#444444\"> ) .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">در دیدی کلی , انواع فرآیندهای تخریبی را که پلیمر ها در حین مصرف روزمره متحمل آنها میشوند را میتوان به صورت زیر تقسیم بندی کرد</span><span dir=\"LTR\"><span style=\"color:#444444\"> :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span dir=\"LTR\"><span style=\"color:#444444\">1- </span></span><span style=\"color:#444444\">گرمایی</span><span dir=\"LTR\"><span style=\"color:#444444\"> :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">این نوع تخریب هنگام فرآیند کردن و یا به کار گیری پلیمرها در دما های بالا رخ میدهد و ممکن است با اکسایش توام باشد</span><span dir=\"LTR\"><span style=\"color:#444444\"> (&nbsp;Thermoxidation Degradaton&nbsp;) </span></span><span style=\"color:#444444\">و یا اینکه بدون دخالت اکسیژن صورت گیرد</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Thermal Degradation ) .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span dir=\"LTR\"><span style=\"color:#444444\">2- </span></span><span style=\"color:#444444\">مکانیکی</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Mechanical Degradation ) :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">این نوع تخریب بر اثر وارد شدن نیرو و شکست فیزیکی زخ میدهد که میتواند با شکست زنجیری نیز توام باشد</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">۳</span><span dir=\"LTR\"><span style=\"color:#444444\">- </span></span><span style=\"color:#444444\">مافوق صوتی</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Ultrasonic Degradation ) :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">استفاده از صوت با فرکانس های خاص می تواند باعث شود ک زنجیر های یم پلیمر مرتعش شده و به پاره شوند</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">۴</span><span dir=\"LTR\"><span style=\"color:#444444\">- </span></span><span style=\"color:#444444\">آبی</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Hydrolytic Degradation ) :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">این فرآیند در پلیمرهایی رخ می دد ک دارای گروه های فعال حساس به آب می باشند , به ویژه آنهائی که رطوبت زیادی به خود میگیرند</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">۵</span><span dir=\"LTR\"><span style=\"color:#444444\">- </span></span><span style=\"color:#444444\">شیمیائی</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Chemical Degradation ) :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">در این مورد مواد شیمیائی خورنده و یا گازهائی نظیر اکسیژن</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( O2 ) </span></span><span style=\"color:#444444\">و اوزون</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( O3 ) </span></span><span style=\"color:#444444\">میتوانند به عوامل ساختمانی یک پلیمر حمله نموده و باعث پاره شدن زنجیر مولکولی و اکسایش آن شوند</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">۶</span><span dir=\"LTR\"><span style=\"color:#444444\">- </span></span><span style=\"color:#444444\">زیستی</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Biological Degradaton ) :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">این مسئله فقط مخصوص معدودی از پلیمر ها است که حاوی گروه های فعال خاصی هستند و توسط موجودات ذره بینی مورد حمله قرار میگیرند</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">۷</span><span dir=\"LTR\"><span style=\"color:#444444\">- </span></span><span style=\"color:#444444\">تشعشعی</span><span dir=\"LTR\"><span style=\"color:#444444\"> ( Radiation Degradation ) :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">در برابر نور خورشید</span>&nbsp;<span style=\"color:#444444\">و یا تشعشعات پر انرژی , پلیمر و یا ناخالصی های موجود در پلیمر , اشعه را جذب کرده و موجب واکنش های تخریبی و در نتیجه آن افت خواص پلیمر میشود . در مورد تشعشعات پرانرژی ,</span>&nbsp;<span style=\"color:#444444\">زنجیر های مولکولی پلیمر مستقیما پاره میشوند</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\">تغییرات خواص<span dir=\"LTR\"> :</span></span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">تغبیرات خواص در یک پلیمر در اثر تخریب شدن را میتوان به انواع فیزیکی و شیمیائی تقسیم بندی نمود</span><span dir=\"LTR\"><span style=\"color:#444444\"> :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">۱</span><span dir=\"LTR\"><span style=\"color:#444444\">- </span></span><span style=\"color:#444444\">فیزیکی : کاش در وزن مولکولی</span>&nbsp;<span style=\"color:#444444\"> , کاهش</span>&nbsp;<span style=\"color:#444444\">خواص مکانیکی پلیمر ( کاهش در مقاومت کششی , مقاومت ضربه ای و ... ) , کاهش ازدیاد طول در نقطه پارگی , افت شفافیت , ایجاد ساییدگی در سطح و ایجاد ترک های ریز دز توده پلیمر</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-family:calibri,sans-serif\"><span style=\"color:#444444\">۲</span><span dir=\"LTR\"><span style=\"color:#444444\">- </span></span><span style=\"color:#444444\">شیمیائی : تغییر در ساختمان شیمیائی , به وجود آمدن عوامل فعالی نظیر گروه های سیر نشده , هیروکسیل , کربونیل , و هیدرو پراکسید ها که میتوانند سبب افت خواص الکتریکی پلیمر شوند</span> <span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></p>\r\n\r\n<p style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><strong>Ref.</strong></span></span></p>\r\n\r\n<p style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><strong>Fundamentals of Polymer Degradation and Stabilization Norman S. Allen , By&nbsp;&nbsp; M. Edge</strong></span></span></p>','/app/articles/1535010977806.jpg','/app/articles/1535010977584.jpg','Irganox,Igafos,Tinuvin,Hostavin,آنتی اکسیدان,ضد یو وی,bht,Chimassorb','تخریب-در-پلیمر-ها',1274,3,1,'2018-08-23 12:10:27','2022-01-11 21:15:33'),(19,1,'مکانیسم عمل ضد کف ها در سیستم های آب پایه و حلال پایه','ضد کف یک ذره دیسپرس شده هیدروفوب (آبگریز) در آب است.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: center;\"><span style=\"font-size:22px\"><strong>مقاله مرتبط : <a href=\"https://www.amazontele.com/article/%D8%B6%D8%AF-%DA%A9%D9%81-%DA%86%DB%8C%D8%B3%D8%AA\"><span style=\"color:#ff0066\">ضد کف چیست</span></a></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: center;\"><span style=\"font-size:22px\"><strong>جهت خرید ضد کف ها<a href=\"https://www.amazontele.com/search_box?q=%D8%B6%D8%AF+%DA%A9%D9%81&amp;status=1\"><span style=\"color:#0000ff\"> </span><span style=\"color:#9900ff\">اینجا</span><span style=\"color:#0000ff\"> </span></a>کلیک کنید</strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:calibri,sans-serif\">مکانیسم عمل ضد کف<span dir=\"LTR\">:</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">مکانیسم فوم زدایی یک ضد کف را به طور کلی می توان این طور توجیه کرد که ضد کف یک ذره دیسپرس شده هیدروفوب (آبگریز) در آب است. مایع ضد کف به عنوان مدیوم حاملی عمل میکند که میتواند ذرات را به درون لاملا یا دیواره کف هدایت کند<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">(شکل زیر)</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam.jpg\" style=\"float:left; height:202px; width:444px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:calibri,sans-serif\">مکانیسم عمل ضد کف</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">از طرفی عملکرد یک ذره هیدروفوب که همان ذرات ضد کف است ، در مایع لاملا ، که هیدروفوب یا ابدوست می باشد به عنوان یک ذره خارجی ، به ناپایدار سازی کف ، از طریق کاهش نیروهای چسبندگی (<span dir=\"LTR\">cohesive</span>)&nbsp; کمک می کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">از طرف دیگر چنین ذراتی سر آبگریز سورفاکتنت های موجود در لاملا را به خود جذب می کنند یا به دام می اندازند و سبب ترکیدن کف می شوند. (شکل زیر)</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam1.jpg\" style=\"float:left; height:174px; width:455px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">معیار مهم انتخاب همه ی ضد کف ها &quot;ناسازگاری انتخابی آنها با مدیوم آب پایه می باشد. ضد کفی که بیشترین سازگاری را با مدیم آب پایه داشته باشد به درون لاملا مهاجرت نمی کند و در همه جای مدیوم هم نمی تواند وجود داشته باشد. چنین ضد کفی ، مینیمم خواص آنتی فومینگ را دارد و حتی ممکن است باعث پایداری حباب ها شود. از سوی دیگر ، ضد کفهایی با بیشترین ناسازگاری میتواند منجر به عیوب رنگ همچو ، هیزی و وجود حفره شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam2.jpg\" style=\"float:left; height:230px; width:462px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">بنابراین برای انتخاب ضد کف مناسب ، باید بالانسی بین سازگاری و ناسازگاری آن با سیستم آب پایه در نظر گرفت.(شکل زیر)</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam3.jpg\" style=\"float:left; height:187px; width:357px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">البته همانطور که در شکل مشاهده می شود ، مقدار اپتیمم و بهینه زمانی است که هیچ عیبی در رنگ ایجاد نشود. از آنجایی که سیستمهای رنگ آب پایه رنج وسیعی از محصولات با انواع مختلف را تشکیل می دهند ، بنابراین&nbsp; برای همه فرمول ها نمی توان از یک ضد کف استفاده نمود و باید رنجی از ضد کفها برای این کار استفاده شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">میزان سازی عملکرد کف زدایی را می توان با انتخاب دوز مناسب انجام داد:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">به کاربردن بیش از حدلازم ضد کف ، عمل کفزدایی را کامل انجام می دهد ولی موجب ایجاد عیوبی در رنگ می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">استفاده کمتر از حد لازم ، عیوب رنگ را باعث نمی شود ولی سبب میشود کفها در سیستم باقی بمانند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">نیروی برشی هنگام افزودن یک ضد کف فاکتور مهم دیگری است به خصوص اگر ضد کف ناسازگارتر باشد، چه که ، اگر نیروی برشی به قدر کافی زیاد نباشد ، پخش هموژن و یکنواخت ضد کف را نخواهیم داشت و تجمع محلی ضد کف ایجاد شده ، که خود منجر به ایجاد عیوبی در فیلم رنگ مانند ایجاد حفره می شود.برای ضد کفهای خیلی ناسازگار بهتر است انها را در مرحله <span dir=\"LTR\">millbase</span> افزود در حالیکه ضد کفهای سازگارتر با فرمول رنگ ، میتوانند در مرحله <span dir=\"LTR\">let down</span> که نیروی برشی کمتر است افزوده شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam4.jpg\" style=\"float:left; height:78px; width:606px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:calibri,sans-serif\">شیمی ضد کفها:</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">حال به بررسی شیمی ضد کف ها برای سیستمهای آب پایه و حلال پایه و بدون حلال می پردازیم که سازندگان ضد کف هنگام ساخت و سنتز در نظر می گیرند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">ضد کفها برای صنایع مختلفی مانند نساجی و غذایی و فلزی و ... ساخته می شوند ولی آنهایی که برای رنگ طراحی می شوند دارای ساختمان پیچیده تری می باشند چه که باید برای سیستم رزینی خاصی طراحی شده باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">ضد کفهای صنعت رنگ سه دسته می باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">1-&nbsp; ضد کفهای برپایه مینرال اویل</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">2-&nbsp; ضد کفهای سیلیکونی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">3-&nbsp; ضد کفهای پلیمری بدون سیلیکون.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">شیمی ضد کفها:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">حال به بررسی شیمی ضد کف ها برای سیستمهای آب پایه و حلال پایه و بدون حلال می پردازیم که سازندگان ضد کف هنگام ساخت و سنتز در نظر می گیرند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">ضد کفها برای صنایع مختلفی مانند نساجی و غذایی و فلزی و ... ساخته می شوند ولی آنهایی که برای رنگ طراحی می شوند دارای ساختمان پیچیده تری می باشند چه که باید برای سیستم رزینی خاصی طراحی شده باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">ضد کفهای صنعت رنگ سه دسته می باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">1-&nbsp; ضد کفهای برپایه مینرال اویل</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">2-&nbsp; ضد کفهای سیلیکونی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">3-&nbsp; ضد کفهای پلیمری بدون سیلیکون.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam5.jpg\" style=\"float:left; height:271px; width:439px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">البته شکل فوق برای یک پلی دی متیل سیلوکسان اصلاح نشده است. فاکتور کنترل کننده در اینجا طول زنجیر یا وزن ملکولی این ترکیب است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">در صنعت رنگ ، غالبا از نوع اصلاح شده این ترکیب برای تهیه ضد کف استفاده می کنند. و با گرافت ترکیبات آلی ، ضد کف را به بهترین حالت ناسازگاری اصلاح می کنند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">منظور از اصلاح این سیلیکونها این است ، به حد لازم &quot;ناسازگاری انتخابی یا گزینشی &quot; برای آن ایجاد می کنند و با اتصال گروه هایی به زنجیره پلی دی متیل سیلوکسان و کنترل وزن ملکولی آن بهترین خواص ضد کف را ایجاد می کنند. بدیهی است که در این حالت سیلیکون باید گروه <span dir=\"LTR\">Si-H</span>&nbsp; داشته باشد تا بتوان طی یک واکنش تعادلی گروه جانبی را در زنجیره سیلیکون گرافت کرد. شاید بهترین ترکیباتی که می توان برای اصلاح به این سیلیکونها افزود ترکیبات اتری و یا ترکیبات فلوئوری مانند تری فلوئورو متان سولفونیک اسید باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:calibri,sans-serif\">ضد کفهای پلیمری غیر سیلیکونی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">از سایر ترکیبات پلیمری هم می توان ضد کف تهیه نمود که البته خیلی مرسوم نیستند ولی با کنترل میزان قطبیت (برای تنظیم ناسازگاری)&nbsp; و وزن ملکولی (یا صحیحتر توزیع وزن ملکولی پلیمر) می توان از سایر پلیمرها نیز ضد کف تهیه نمود . برخی ملکوهای پلیمری با وزن ملکولی زیاد که زنجیره اصلی آنها اکریلیکی است ، میتوانند هم به عنوان ضد کف عمل کنند و عم به عنوان عامل لولینگ. برای مثال&nbsp; پلی-ان-بوتیل اکریلات با وزن ملکولی بالا</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:calibri,sans-serif\">تست کارایی یک ضد کف</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">برای بررسی کارایی ضد کف ها در آزمایشگاه ، بدیهی است باید شرایطی فراهم آورد تا باشرایط تولید صنعتی رنگ بیشترین شباهت را داشته باشد. که البته به طور کامل امکان پذیر نیست . بنابراین روش زیر به عنوان یک تست اولیه پیشنهاد می شود و می توان آزمایشات تکمیلی تر را هنگام تولید انجام داد. در روش زیر ضد کف ، به دفعات مختلف و هر بار به میزان خیلی کم افزوده می شود تا میزان مناسب آن هم تعیین شود</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">ابتدا یک رنگ آماده شده که ضد کف در آن وجود ندارد را اماده می نماییم. رنگ را در دو&nbsp; سیلندر پلاستیکی همراه با مقداری از دو&nbsp; ضد کف که می خواهیم کارایی آنها را با هم مقایسه کنیم ، می ریزیم. هوادهی توسط دو دیسک که در آنها سوراخهای متعددی ایجاد شده است و به میله ای فلزی فیت(اتصال محکم) شده اند انجام می دهیم. میله را در سیلندر رنگ بالا پایین می بریم تا کل حجم رنگ را بپیماید. پس از انجام چند باره ی این کار ، دانسیته رنگ هوادهی شده را با یک پیکنومتر فلزی اندازه گیری می کنیم.&nbsp; دانسیته هر کدام از رنگها که بیشتر باشد نشاندهنده ی کارایی بهتر آن ضد کف است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam6.jpg\" style=\"float:left; height:245px; width:422px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\"><span style=\"font-family:calibri,sans-serif\">شکل روش فوق برای سنجش کارایی ضد کف</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">برای انجام آزمایش به روش دستی می توان هوادهی را با هر وسیله ی دیگری انجام داد. هوادهی را با هم میکسر دور تند یا شیکر هم می توان انجام داد. به هر روشی که برای هر سیلندر و ضد کف انجام شد باید برای سیلندر و ضد کف دیگر هم همان تکرار شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:calibri,sans-serif\">تست سازگاری ضد کف با رنگ</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">منظور از سازگاری در عنوان بالا مناسب بودن است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">رنگ آماده شده دارای ضد کف را با اپلیکاتور روی شیشه می کشیم. زمانی که سطح فیلم خشک شد ، سطح فیلم را به دقت برای وجود هر نو عیبی(چشم ماهی و ....) جستجو می کنیم. بهترین حالت این است که هیچ نوع ایرادی در سطح فیلم رنگ نباشد</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\">تست سازگاری عملیاتی رنگ اینگونه تعیین می شود که روی سطح گچی صاف یا هر سطحی که رنگ قرار است روی آن استفاده شود ، با غلطک طرحدار به روشی که برای خود تعیین می کنیم (و برای همه ضد کف ها همین روش باید به کار رود) رنگ را اعمال می کنیم. سپس زمان ناپدید شدن حبابهای روی سطح را اندازه گیری می کنیم ، و بعد سطح را از نظر ایرادات مورد توجه قرار می دهیم.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:calibri,sans-serif\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/antifoam7.jpg\" style=\"float:left; height:489px; width:549px\" /></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\">ارائه شده در کنفرانس علمی توسط <strong>آقای مهندس کوروش پردیس</strong> در&nbsp;گروه کارشناسان صنایع رنگ و رزین&nbsp;</span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\">&nbsp;</p>','/app/articles/1535176705612.jpg','/app/articles/1535176705624.jpg','ضد کف,ضد حباب,اپوکسی,defoamer,دفوم,Antifoam,آنتی فوم,antibubble','مکانیسم-عمل-ضد-کف-ها-در-سیستم-های-آب-پایه-و-حلال-پایه',1867,3,1,'2018-08-25 10:28:25','2022-01-11 23:23:06'),(20,1,'مروری بر افزودنی ها در رنگ','مواد افزودنی ترکیبات کلیدی هستند که در فرمولاسیون انواع  رنگ ها و پوشش ها به مقدار کمی بکار می روند.','<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: center;\"><span style=\"font-size:22px\"><strong>جهت مشاهده لیست&nbsp;قیمت و خرید افزودنی ها <a href=\"https://www.amazontele.com/search?category[0]=4&amp;status=1\"><span style=\"font-size:24px\"><span style=\"color:#FF8C00\">اینجا </span></span></a>کلیک کنید</strong></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: center;\"><span style=\"font-size:22px\"><strong>مقالات مرتبط : <a href=\"https://www.amazontele.com/article/%D8%A7%D9%81%D8%B2%D9%88%D8%AF%D9%86%DB%8C-%D9%87%D8%A7%DB%8C-%D9%85%D9%88%D8%B1%D8%AF-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%AF%D8%B1-%D8%B5%D9%86%D8%A7%DB%8C%D8%B9-%D8%B1%D9%86%DA%AF\"><span style=\"color:#800080\">1- افزودنی های مورد استفاده در صنایع رنگ</span></a></strong></span></h2>\r\n\r\n<p dir=\"RTL\" style=\"text-align: center;\"><a href=\"https://www.amazontele.com/article/%D9%85%D9%88%D8%A7%D8%AF-%D8%A7%D9%81%D8%B2%D9%88%D8%AF%D9%86%DB%8C-%D8%B1%D9%86%DA%AF-%DA%86%DB%8C%D8%B3%D8%AA\"><span style=\"font-size:22px\"><strong><span style=\"color:#800080\">2- مواد افزودنی رنگ چیست</span></strong></span></a></p>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#0000FF\">مقدمه</span></span></strong><br />\r\nدر فرمولاسیون پوشرنگ ها ، انواع مختلفی از مواد اولیه استفاده می شود . مواد اولیه مورد استفاده در فرمولاسیون پوشرنگ ها در سه گروه اصلی طبقه بندی می شوند: رزین ،رنگدانه و حلال . علاوه براین یک دسته از دیگر از مواد مورد استفاده در فرمولاسیون پوشرنگ ها مواد افزودنی هستند که به مقدار بسیار کمی در فرمولاسیون وارد می شوند . افزودنی ها در جهت بهبود عملکرد پوشرنگ ها استفاده می شوند . در یک نگاه کلی به فناوری افزودنی ها مشاهده می شود که مسئله تر شدن<span dir=\"LTR\"> (wetting )</span>، دیسپرس شدن<span dir=\"LTR\"> (dispersion&nbsp;&nbsp; )</span>،جریان پذیری<span dir=\"LTR\"> (surface flow&nbsp; )</span>، <span dir=\"LTR\">levelling </span>، کف زدائی<span dir=\"LTR\"> (defoaming )</span>و کنترل رئولوژی از پارامترهای مهم در صنعت پوشش سطوح می باشد<span dir=\"LTR\">.</span><br />\r\nدر اینجا به افزودنی های&nbsp; مورد استفاده در پوشرنگ های حلالی که بر اساس&nbsp; نوع کاربرد شان طبقه بندی شده اند اشاره می شود <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">هنگام تولید: عوامل ترکننده ، دیسپرس کننده</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">هنگام انبار داری : ضد رویه و ضد رسوب</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">هنگام اعمال پوشرنگ:&nbsp; ضد کف ها ، اصلاح کننده های خواص الکترواستاتیکی ، ضد شره ها</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">هنگام تشکیل فیلم : ضد شره ها ،عوامل هم تراز کننده ،ضد کف ها</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">پس از پخت و تشکیل فیلم : ضد خش ها ،افزودنی های مقاومت در برابر آتش ،سر کننده ها<br />\r\n<strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">&nbsp;</span></span></strong></span></span></span><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">1-عوامل تیکسوتروپ کننده</span></span></strong><br />\r\nیک پوشرنگ بایستی همزمان دو ویژگی متضاد را دارا باشد . خاصیت نخست گرانروی پایین که باعث سهولت جریان یافتگی پوشرنگ تحت اعمال تنش می شود و مساله دیگر اینکه پوشرنگ بایستی دارای گرانروی کافی باشد تا هنگام قطع تنش شره نکند تغییرات در گرانروی پوشرنگ تحت عنوان خاصیت تیکسوتروپی شناخته می شود و استفاده از این عوامل در مقادیر زیاد منجر به تجمع و تورم ذرات در پوشرنگ می شود <span dir=\"LTR\">.</span></span></span></span><br />\r\n<span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\">2- دیسپرس کننده رنگدانه (عوامل ترکننده <span dir=\"LTR\">)</span></span></span></strong><br />\r\nدو مکانیزم اساسی برای پایدار سازی پیگمنت های دیسپرس شده در محلول رزین وجود&nbsp; دارد این مکانیزم ها عبارتند از : دافعه الکترواستاتیک و ایجاد ممانعت فضائی<br />\r\nکارکرد عوامل ترکننده در پوشرنگ ها به این صورت می باشد</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">1- کاهش گرانروی خمیر رنگ</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">2- افزایش غلظت رنگدانه در خمیر رنگ</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">3-کاهش زمان دیسپرسیون</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">4-جلوگیری از فلوکه شدن رنگدانه</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">5- کنترل رسوب دهی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">6-افزایش و بهبود شدت رنگ دهی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">7- بهبود براقیت فیلم</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">طبقه بندی عوامل ترکننده از نظر شیمیایی به این صورت می باشد <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">1- ترکیبات آنیونی( الکل سولفونه آلیفاتیک، آلکیل سولفونات <span dir=\"LTR\">)</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">2- ترکیبات کاتیونی(آمین آلیفاتیک ، نمک های آمینی آلیفاتیک</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">3-ترکیبات خنثی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">4- ترکیبات آمفوتریک(نمک های آمینو اسید <span dir=\"LTR\">)</span><br />\r\nو طبقه بندی بهتر عبارتند از مواد افزودنی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">1-دی فلوکه کننده<span dir=\"LTR\"> (defloccutation type )</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">2- فلوکه کننده کنترل&nbsp; شده<span dir=\"LTR\"> (controlled flocculation type )</span><br />\r\n&nbsp;</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">3- مواد کنترل کننده سطح ( ضد کف ها &ndash; هم تراز کننده ها<span dir=\"LTR\">&nbsp; )</span><br />\r\nکف را می توان دیسپرس شدن ذرات ریز هوا در یک مایع نامید <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">کف در پوشش ها همیشه نامطلوب است کفی که در طول فرآنید تولید پوشرنگ ایجاد می شود ، به پر شدن نامطلوب ظرف ها ی تولید منجر شده و موجب ایجاد مشکلاتی در خط بسته بندی می شود حضور کف در سیستم ها به دلایل مختلفی وابسته می باشد <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">کف می تواند طی فرآیند تولید در اثر استفاده نامناسب از ظرف واکنش و پر کردن نامناسب آن و همچنین در طول فرآیند حمل و نقل و یا اعمال ایجاد شود کفها نه تنها ایجاد یک توربولانس و آشفتگی ظاهری در سیستم می شوند بلکه روی تشکیل فیلم و خواص وابسته به آن نیز موثرند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">به عنوان مثال با یک فرمولاسیون مشخص در هنگام استفاده از غلطک ممکن است که هیچ گونه کفی مشاهده نشود در حالیکه اگر همان سیستم توسط اسپری اعمال شود کف زیادی تولید می شود <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">کف در پوشرنگ ها و پوشش ها نه تنها یه ضایعه ی بصری محسوب می شود بلکه باعث کاهش عملکرد محافظتی می گردد . بر همین اساس، یک ضد کف تقریبا در تمامی فرمول های تهیه ی پوشش یک ماده مهم و اساسی محسوب می گردد <span dir=\"LTR\">.</span><br />\r\nضد کف ها&nbsp; مایعاتی با کشش سطحی پایین هستند که به طور کلی باید سه ویژگی زیر را دارا باشند <span dir=\"LTR\">:</span><br />\r\n1-در محیطی که باید کف زدوده شود ، حل نشوند</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">2- ضریب ورود مثبت داشته باشند</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">3- ضریب پخش مثبت داشته باشند<br />\r\nبه خاطر تنوع وسیع سیستمهای پوشرنگ ، یک ضد کف نمی تواند برای کلیه فرمول ها کاربرد بهینه داشته باشد . ضد کف ها بسیار ناسازگارند اند و از طرف دیگر ممکن است منجر به عیوبی نظیر کدری یا چشم ماهی یا پوست پرتقالی شوند . به طور کلی هر چه میزان ضد کف بیشتر باشد کف زدایی بهتر انجام خواهد گرفت <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">اما افزایش بیش از حد ممکن است موجب بروز عیوب یا نمایان شدن آنها گردد . کاهش&nbsp; میزان ضد کف از عیوب فیلم جلوگیری می نماید اما عمل کف زدایی ممکن است کارایی لازم را نداشته باشد <span dir=\"LTR\">.</span><br />\r\nضد کف های تولیدی بر ای سیستمهای آب پایه و حلال پایه را می توان به سه گروه طبقه بندی کرد <span dir=\"LTR\">:</span><br />\r\n1-ضد کف بر پایه روغن های معدنی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">2- ضد کف بر پایه سیلیکون</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">3-ضد کف پلیمری بدون سیلیکون<br />\r\nحامل روغن که در سیستم های پایه آبی استفاده می شود معمولا از خانواده آلیفاتیک انتخاب می شود چرا که روغن های آروماتیک علاوه بر زرد شدگی دارای سمیت نیز هستند ترکیبات پلی اوره آی آلیفاتیک ضد کف هایی با عمر طولانی هستند <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">ضد کف های سیلیکونی بارزش تر از ضد کف های معدنی بوده و اغلب در فرمولاسیون های با کارایی بالا استفاده می شود <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">مزیت استفاده از این ضد کف اثر افزایشی آن است این مواد باعث کاهش براقیت و همچنین تغییر رنگ سیستم های محتوی پیگمنت نمی شوند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">ضد کف های پلیمری بدون سیلیکون رزین های جدید مانند پلی یورتان های دوجزئی آب پایه می توان نام برد <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">برای سیستم های پایه حلالی ضد کف هایی با کشش سطحی پایین تر مورد نیاز است سیلیکون ها و پلی سیلو کسان نقش مهمی را ایفا می کند <span dir=\"LTR\">.</span><br />\r\n&nbsp;</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">4-افزودنی های رئولوژیکی<br />\r\nرئولوژی عبارتست از ارتباط تنگاتنگ بین ویسکوزیته و نیروهای برشی ، و توسط محتوی حلال و حلالیت رزین و همچنین پیگمنته بودن بررسی می شود .مواد افزودنی رئولوژیکی نقش مهمی را در نگهداری و خصوصیات اعمالی سیستم های مایع بازی می کنند <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">این مواد در حوزه پوشش های آب پایه ، تاثیر شگرفی را بر خواص کلیدی چون یکنواختی سطح ، براقیت ، جریان پذیری در حالت عمودی ، ضخامت پوشش ، توان پشت پوشی ، تمایل به ته نشینی و ثبات رنگدانه ها دارند <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">در عین حال مواد افزودنی رئولوژیکی می توانند بطور برجسته ای زمان انبار داری پوشرنگ ها را با کاهش تمایل به رسوب کردن رنگدانه ها و پر کننده بهبود دهند . بدون کنترل مناسب رئولوژی ، اغلب این سیستم ها دچار جدایی فازی می شوند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">افزودنی های دی فلوکه کننده باعث کاهش ویسکوزیته می شوند در حالیکه مواد افزودنی فلوکه کننده باعث افزایش ویسکوزیته و تیکسوتروپی سیستم می شود <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">در اغلب موارد این مواد افزودنی برای جلوگیری از رسوب در هنگام انبار داری وجلوگیری از شره در هنگام اعمال استفاده می شود . علاوه بر مواد افزودنی کنترل کننده رئولوژی قدیمی مثل<span dir=\"LTR\"> Clay&nbsp; </span>، تالک و یا محلولهای پلیمری ، محلولهای جدیدی مثل<span dir=\"LTR\"> N&nbsp; &ndash; </span>متیل پیرولیدون به بازار عرضه می شود<span dir=\"LTR\">.</span><br />\r\n&nbsp;</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">5- ضد شره ها<br />\r\nبرای در اختیار داشتن پوشش های براق با کیفیت بالا لازم است ناهمگونی موجود در سطح پوشش که به هنگام اعمال رنگ و یا در حین خشک یا سخت کردن آن بوجود آمده است تا حد امکان کاهش یابد <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">با استفاده از خاصیت تیکسوتروپی رنگ مقاومت در برابر شره کردن را بالا برد و ظاهر پوشش را بهبود بخشید . عوامل کنترل کننده شره بر پایه آمین ها بسیار کارا بوده و علاوه بر حل مشکل شره کردن ، زبری سطح پوشش را نیز کم می کنند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">ترکیباتی وارد بازار شد که حاصل واکنش هگزا اتیلن در ایزوسیانات<span dir=\"LTR\"> ((HDI&nbsp;&nbsp; </span>و بنزیل آمین<span dir=\"LTR\"> (BA )&nbsp; </span>هستند این ترکیبات با نام<span dir=\"LTR\"> ,,Opaque SCA </span>شناخته شده اند <span dir=\"LTR\">.</span><br />\r\n&nbsp;</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">نتیجه گیری</span></span></strong><br />\r\nافزودنی های پوشش عموماً سیستم های پوشرنگ جدیدی را بوجود نمی آورند ولی عامل مهمی هستند که با عث موفقیت یک سیستم پوششی در بازار می شوند. افزودنی ها از سالها پیش جهت رفع مشکلات پوشش استفاده می شدند تا از ایجاد عیوب جلوگیری نموده و کیفیت پوشش را بهبود بخشند <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">برخی از شرکت های معروف تولید کننده این افزودنی ها عبارتند از :EFKA،&nbsp;BYK،&nbsp;Akzo Nobel&nbsp;،&nbsp;Ciba،&nbsp;Lubrizol،Elementis&nbsp;،Eastman&nbsp;<br />\r\n&nbsp;افزودنی هایی را تولید میکنند که وظایف زیر را بر عهده دارند:</span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<ol>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">دیسپرس کننده های پیگمنت های آلی&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Wetting and dispersing agents</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">دیسپرس کننده های پیگمنت های معدنی&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Wetting and dispersing agents</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">ضد کف های سیلیکونی و غیر سیلیکونی&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Defoamer</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">ضد حباب ها&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Defoaming/Bubble-Release</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">افزودنی های رئولوژیکی از قبیل : غلظت دهنده های پایه معدنی و آلی</span><span dir=\"LTR\"><span style=\"color:#333333\">-&nbsp;</span></span><span style=\"color:#333333\">&nbsp;سلولزی&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Rheology additives</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">همتراز کننده ها&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Flow and leveling agents</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">ضد خش ها&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Slip and mar additives</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">افزاینده هدایت الکتریکی&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">conductivity promoter</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">کاتالیست ها و پراکسید ها&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Curing catalysts</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">شتابت دهنده ها&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Accelerator</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">خشک کن ها&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Driers or Siccatives</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">مات کننده ها&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Matting agents</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">ضد رویه&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Anti-skinning agents</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">ضد قارچ و باکتری&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Biocides</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">واکس ها&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Wax and Wax Dispersions</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">عوامل تشکیل دهنده فیلم&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Film formation agents</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">تنظیم کننده های&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">pH</span></span>&nbsp;&nbsp;<span dir=\"LTR\"><span style=\"color:#333333\">pH Adjusting Agents</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">آنتی اکسیدان ها&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Antioxidants</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">جاذب های اشعه یو وی&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">UV absorbers</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">پایدار کننده های نوری&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Light stabilizers</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">افزودنی تر کننده سطح&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Wetting agents-Surfactant</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">افزودنی ضد خوردگی&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Corrosion inhibitors</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">شروع کننده های واکنش&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Initiators</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">کمک آسیاب پیگمنت ها&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Grinding Aid</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">چکشی کننده سطوح&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Hammertone additive</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">بهبود دهنده های چسبندگی&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Adhesion promoters</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">افزودنی آنتی فلود و آنتی فلوتینگ پیگمنت ها&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Anti-Float/Anti-Flooding additives</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">آنتی ژل&nbsp;&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Antigel</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">رطوبت گیر ها&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Moisture scavengers</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">هاردنر ها&nbsp;</span><span dir=\"LTR\"><span style=\"color:#333333\">Hardeners</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"color:#333333\">نرم کننده ها&nbsp;</span><em><span dir=\"LTR\"><span style=\"color:#333333\">Plasticizers</span></span></em></span></span></span></h2>\r\n	</li>\r\n</ol>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>','/app/articles/1535696550846.jpg','/app/articles/1535696552167.jpg','ادتیو,افزودنی,رنگدانه,دیسپرس کننده,ضد کف,ضد حباب,پلاستی سایزر,ضد رویه,خشک کن,همتراز کننده,غلظت دهنده,ضد باکتری,ضد یو وی,آنتی یو وی','مروری-بر-افزودنی-ها-در-رنگ',1602,3,1,'2018-08-31 10:52:32','2022-01-11 16:00:30'),(21,3,'تیتان چیست','تیتان پر مصرف ترین رنگدانه یا پیگمنت سفید در جهان می باشد.','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><span style=\"font-size:22px\"><strong>جهت خرید پیگمنت سفید تیتان<a href=\"https://www.amazontele.com/product/%D9%BE%DB%8C%DA%AF%D9%85%D9%86%D8%AA-%D8%B3%D9%81%DB%8C%D8%AF-%D8%AA%DB%8C%D8%AA%D8%A7%D9%86-Pigment-White-7\"><span style=\"font-size:24px\"><span style=\"color:#cc3300\"> اینجا </span></span></a>کلیک کنید</strong></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><strong><span style=\"font-size:22px\">مقالات مرتبط :</span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><strong><span style=\"font-size:22px\"><a href=\"https://www.amazontele.com/article/%D8%AF%DB%8C-%D8%A7%DA%A9%D8%B3%DB%8C%D8%AF-%D8%AA%DB%8C%D8%AA%D8%A7%D9%86%DB%8C%D9%88%D9%85-%DA%86%DB%8C%D8%B3%D8%AA\"><span style=\"color:#800080\">1-&nbsp;<span style=\"font-family:iransans\"><span style=\"font-family:comic sans ms,cursive\">دی اکسید تیتانیوم چیست</span></span></span></a>&nbsp;؟</span></strong></h2>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><strong><span style=\"font-size:22px\"><a href=\"https://www.amazontele.com/article/%D8%AF%DB%8C-%D8%A7%DA%A9%D8%B3%DB%8C%D8%AF-%D8%AA%DB%8C%D8%AA%D8%A7%D9%86%DB%8C%D9%85-%D9%88-%D8%B3%D8%A7%DB%8C%D8%B1-%D9%BE%DB%8C%DA%AF%D9%85%D9%86%D8%AA-%D9%87%D8%A7%DB%8C-%D8%B3%D9%81%DB%8C%D8%AF\"><span style=\"color:#800080\"><span style=\"font-family:iransans\"><span style=\"font-family:comic sans ms,cursive\">2-&nbsp;</span></span><span style=\"font-family:comic sans ms,cursive\">دی اکسید تیتانیم و سایر پیگمنت های سفید</span></span></a></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><strong><span style=\"font-size:22px\"><a href=\"https://www.amazontele.com/article/%D8%AE%D9%88%D8%A7%D8%B5-%D9%81%DB%8C%D8%B2%DB%8C%DA%A9%DB%8C-%D9%88-%D8%B4%DB%8C%D9%85%DB%8C%D8%A7%DB%8C%DB%8C-%D8%AA%DB%8C%D8%AA%D8%A7%D9%86\"><span style=\"color:#800080\"><span style=\"font-family:comic sans ms,cursive\">3- خواص فیزیکی و شیمیایی تیتان</span></span></a></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><a href=\"https://www.amazontele.com/article/%D9%85%D9%88%D8%A7%D8%AF-%D8%B4%DB%8C%D9%85%DB%8C%D8%A7%DB%8C%DB%8C-%DA%86%DB%8C%D8%B3%D8%AA\"><strong><span style=\"font-size:22px\"><span style=\"color:#800080\"><span style=\"font-family:comic sans ms,cursive\">4-مواد شیمیایی چیست ؟</span></span></span></strong></a></p>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/o5pm3/vt/frame\" width=\"80%\"></iframe></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">تیتانیوم دی اکسید (<span dir=\"LTR\"><span style=\"background-color:white\">Titanium dioxide</span></span>) یا تیتان چیست؟</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">دی اکسید تیتان یا تیتانیا<span dir=\"LTR\"> (Tio2) </span>اولین بار در سال1923 به طور تجاری تولید شد. این ماده از سنگ معدن های مختلف از جمله ایلمنیت به دست آمده است. ماده حجیم<span dir=\"LTR\"> Tio2 </span>در سه نوع کلی روتایل، آناتاز و بروکیت وجود داد. در میان آن ها ،<span dir=\"LTR\">Tio2&nbsp; </span>بیشتر به صورت فازهای روتایل و آناتاز یافت می شود که هر دوی آن ها ساختارهای تتراگونال دارندرنگدانه تیتان از قدیمی ترین رنگدانه های پوششی محسوب می شود ایلمنت در حقیقت تیتانات آهن دو ظریفتی است که بسیاری از نقاط دنیا از جمله هندوستان و نروژ، آمریکا، کاناداو سوئد یافت می شود. نوع روتیل آن در حقیقت تیتانیوم دی اکسید طبیعی است که برای جدا سازی آن از سایر مواد از روش کلراید استفاده می کنند و ماده اولیه مناسبی برای این روش است<span dir=\"LTR\">.</span><br />\r\nپیگمنت های دی اکسید تیتانیم<span dir=\"LTR\">(Tio2) </span>عامل ایجاد پشت پوشی و رنگ سفید در فیلم پوشش هستند و برگستره وسیعی از دیگران خصوصیات فیلم تأثیر می گذارند.&nbsp; معرفی و توسعه دی اکسید تیتانیم درسراسر قرن بیستم امکان تولید پوشش هایی مطمئن و با کیفیت بالا را برای استفاده بر سطوح داخلی و خارجی فراهم آورده است . هرچند فرآیندهای تولید صنعتی دی اکسید تیتانیم نسبتا گران بوده و لذا این پیگمنت اغلب گرانترین ماده خام مورد استفاده در رنگهای امولسیونی است<span dir=\"LTR\">.</span><br />\r\nطی سالیان متمادی فن آوریهای متعددی به منظور استفاده بهینه از دی اکسید تیتانیم و کاهش مقدار مصرف آنها ، با حفظ خصوصیات کاربردی پوشش معرفی شده و توسعه یافته اند. در مدتی بیش از 30 سال سازندگان پر کننده ها، تولیدات خود را گسترش و استفاده از این مواد را به عنوان روشی در صرفه جویی در مصرف دی اکسید تیتانیم معرفی نموده اند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"background-color:white\">یک پیگمنت در حقیقت یک پودر جامد غیر قابل حل در یک بایندر (رزین) می باشد که میتوان آنرا در همان بایندر بسهولت پخش نمود و پیگمانهای سفید، مواد غیر آلی (معدنی) فلزات سرب، روی و تیتانیم می باشند و وقتی کاملا ًسفید بنظر خواهند رسید که تمامی طول موجهای قابل دید تابش برخود را منعکس نمایند</span><span dir=\"LTR\"><span style=\"background-color:white\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"background-color:white\">پیگمان دی اکسید تیتانیم سفید ترین پیگمان سفید بوده که بعلت قدرت پوشش بیشتر و قیمت کمتر از دیگر سایر پیگمانهای سفید مصرف بیشتری در ساخت رنگ دارد و یا به جرأت میتوان گفت که امروزه از دی اکسید تیتان بعنوان تنها پیگمان سفید استفاده مینمایند زیرا که علاوه بر خواص فوق خواص کلی دیگر پیگمانهای سفید را نیز در بر دارد. مثلاً نوع روتایل آن بیشتر از اکسید روی خاصیت کنترل گچ یا خاک شوندگی فیلم حاصل بر سطوح بیرونی را دارد. نوع روتایل 20 الی 30 درصد قدرت پوشش بیشتری از نوع آناتاز دارد. نوع آناتاز با اینکه سفید تر از نوع روتایل است اما جهت ساخت مصارف بیرونی بعلت میل گچ شوندگی توصیه نمیگردد</span><span dir=\"LTR\"><span style=\"background-color:white\">.</span></span><br />\r\n<span style=\"background-color:white\">رنگدانه دی اکسید تیتان فوق العاده غیر فعال بوده و بعلاوه غیر محلول در اسیدهای رقیق آلی و معدنی، بازها، آب و حلالهای آلی میباشد ولی در اسیدهای سولفوریک و فلوئدریک گرم و غلیظ حل میشود، این ماده سمی نبوده و در برابر حرارت مقاومت خوبی داشته و خنثی نیز می باشد. بعلاوه در اثر برخورد با گاز ئیدروژن سولفوره و دیگر گازها ئیکه در جو میباشند بیرنگ نمیشود، از موارد مصرف تیتان صنایع رنگ سازی، کاغذ سازی، پلاستیک، لاستیک، سرامیک، مرکب و غیره را میتوان نام برد<span dir=\"LTR\"><span style=\"background-color:white\">.</span></span> ضرایب شکست(</span><span dir=\"LTR\"><span style=\"background-color:white\">R.I</span></span><span style=\"background-color:white\">) تیتان آناتاز و روتایل عبارتند از :</span><br />\r\n<span dir=\"LTR\">&nbsp;<span style=\"background-color:white\">آناتاز ، متبلور ، </span><span dir=\"LTR\"><span style=\"background-color:white\">R.I= 2.55</span></span></span><br />\r\n<br />\r\n<span dir=\"LTR\">&nbsp;<span style=\"background-color:white\">روتایل، متبلور ، </span><span dir=\"LTR\"><span style=\"background-color:white\">R.I= 2.71</span></span></span><br />\r\n<span style=\"background-color:white\">اتمهای تیتان در حالت روتایل بسیار توهم تر( چگالتر) از نوع آناتاز میباشند بنابراین فرم یا حالت روتایل بسیار ثابت تر بوده و در نتیجه چنین آرایش مولکولی فرم آناتاز برنگ سفید مایل به آبی و نوع روتایل برنگ سفید مایل به زرد میباشد<span dir=\"LTR\"><span style=\"background-color:white\">.</span></span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"background-color:white\">رنگدانه های سفید بجز تیتان از قدیمی ترین رنگدانه های پوششی محسوب میشوند که امروزه مصرف تعدادی از آنان تقریباً به صفر رسیده زیرا نوع جدیدتر و بهتری جایگزین آنها شده است که به دی اکسید تیتان معروف است. رنگدانه های سفید سربی عبارتند از کربنات، سولفات و سیلیکات بازی سرب و از دیگر رنگدانه های سفید میتوان اکسیدروی، اکسید روی سرب دار، اکسید آنتی مونی، لیتوپون و دی اکسید تیتانیم را نام برد. تفاوتهای اساسی درخواص فیزیکی و شیمیایی آنان وجود دارد که یک فرمولیست می بایستی با آن تفاوتها آشنایی کامل داشته تا قادر به ارائه یک فرمول مناسب باشد. از عمده تفاوتهای فیزیکی میتوان ضریب شکست، پوشش ، اندازه ذرات، قدرت جذب روغن ،وزن مخصوص ظاهری، فام، و غیره را نام برد. از میان رنگدانه های سفید فقط کربنات بازی سرب و اکسید روی هستند که خصلت واکنش پذیری با اسیدهای موجود در بعضی از رزینها را دارند و بقیه رنگدانه های سفید بی اثرند. نتیجه واکنش این رنگدانه ها با اسیدهای چرب آزاد موجوددر بعضی از رزینها، صابون و یانمک روی و سرب خواهد بود که اثرات جانبی منفی از قبیل طولانی تر شدن زمان آسیاب، ایجاد ته نشینی ، افزایش ویسکوزیته و کاهش عمر مفید فیلم یک رنگ از خود باقی میگذارند. به غیر از اسیدهای آزاد در رزینها، اسیدهای دیگری از قبیل فرمیک، استیک و پروپیونیک در محیط موجودند که در دراز مدت و در نتیجه مکانیزم اکسیداسیون این نوع رزینها به وجود می آیند</span><span dir=\"LTR\"><span style=\"background-color:white\">.</span></span><br />\r\n<span style=\"background-color:white\">تولیدات حاصل از واکنش دو رنگدانه سفید واکنش پذیر فوق الذکر با اسیدهای تولیدی حاصل از مکانیزم اکسیداسیون نیز اثرات معکوسی بر بعضی از خواص فیلم از قبیل سختی، انعطاف پذیری ، مقاومت در مقابل آب، براقیت و مقاومت، خارجی یک فیلم میگذارند<span dir=\"LTR\"><span style=\"background-color:white\">.</span></span></span><br />\r\n<span style=\"background-color:white\">لذا در ساخت رنگهای مصرفی بر سطوح خارجی از ترکیب هر دو نوع پیگمان یعنی واکنش پذیر و واکنش ناپذیر جهت ایجاد خواص ماگزیمم استفاده می نمایند، زیرا که فیلم حاصل از تمامی پیگمانهای سفید به غیر از اکسیدروی مصرفی بر سطوح بیرونی، در دراز مدت حالت زردی یایلوئینگ به خود می گیرد که این تغییر حالت ناشی از ایجاد پراکسیدی است که بر اثر واکنش اکسیداسیونی بند دو گانه رزین های روغنی به وجود می آید. بنابراین استفاده از حدود 10% اکسید روی همراه دیگر پیگمانهای سفید، بعلت جذب اشعه های نورانی نور خورشید، نه تنها زرد گرائی فیلم را بکلی از بین خواهد برد و یا حتی المقدور کاهش میدهد و بلکه همچنین از فاسد شدن فیلم نیز جلوگیری بعمل خواهد آورد<span dir=\"LTR\"><span style=\"background-color:white\">.</span></span></span><br />\r\n<span style=\"background-color:white\">اگر سطوحی که با رنگ محتوی رنگدانه سفید سربی رنگ آمیزی شده اند را در هوای آزاد آغشته به گاز ئیدروژن سولفوره قرار دهید، بر اثر تولید سولفید سرب<span dir=\"LTR\"><span style=\"background-color:white\"> (pbs) </span></span><span style=\"background-color:white\">که سیاهرنگ هست سیاه می گردند و به عکس سطوح رنگ آمیزی شده با رنگهای محتوی درصد کمی اکسید روی در چنین هوایی سیاه نمیگردند زیرا سولفید روی</span><span dir=\"LTR\"><span style=\"background-color:white\"> (Zns) </span></span><span style=\"background-color:white\">حاصل بر عکس سولفید سرب سفید رنگ می باشد و بنابراین تأثیری بر رنگ نهائی فیلم نخواهد داشت. از پیگمانهای سربی به همراه اکسید روی در ساخت رنگهای مصرفی بر سطوح خارجی جهت افزایش چسبندگی، فلو و خاصیت برس خوری بهتر استفاده میشود و اما از آنجائی که سمی می باشند در ساخت رنگهای مصرفی بر سطوح داخلی استفاده نمیگردند</span><span dir=\"LTR\"><span style=\"background-color:white\">.</span></span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"rtl\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"rtl\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"background-color:white\"><strong>روش تهیه تیتانیوم دی اکسید</strong><strong> </strong></span></span></span></span><br />\r\n&nbsp;</h2>\r\n\r\n<h2 dir=\"rtl\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong>روش سولفات</strong></span></span></span></span></h2>\r\n\r\n<h2 dir=\"rtl\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">در این روش ایلمنیت به عنوان ماده خام بکار می رود، پس از خرد کردن سنگ معدن، مواد همراه آن جدا می گردد، پس از آسیاب کردن، خشک و سپس در اولئوم حل می شود که این واکنش آرام است، در حالی که با اسید سولفوریک غلیظ واکنش شدید می باشد. محلول اولئوم بتدریج با اسید سولفوریک و سپس با آب رقیق می گردد. در اثر این عمل، محلولی از سولفات تیتانیوم، سولفات فرو سولفات فریک همراه با سیلیس غیر محلول بدست می آید. از طریق فیلتراسیون، سیلیس نامحلول جدا و سپس مقداری آهن قراضه به محلول آن اضافه می کنند تا تمام آهن موجود به املاح دو ظرفیتی آهن تبدیل شود. سپس محلول را جدا می کنند و پس از صاف کردن به دستگاه تبخیر در خلاء انتقال می دهند . بدین ترتیب سولفات فرو به صورت کریستال جدا می شود .<br />\r\nمرحله بعد از این نظر که کنترل کننده اندازه ذرات و ماهیت رنگدانه می باشد، مرحله مشکل و تعیین کننده ای است. در این مرحله ابتدا محلول را می جوشانند تا سولفات تیتانیوم هیدرولیز و به هیدروکسید تیتانیوم تبدیل گردد. شرایط عمل هیدرولیز باید دقیقاً کنترل شود. رسوب هیدروکسید با آب کاملاً شسته می شود تا اسید و آهن آن خارج گردد، پس از فیلتراسیون و خارج کردن رسوب هیدروکسید تیتانیوم آن را در کوره دواری با دمای c ◦ 800 کلسینه می کنند.<br />\r\nدر این روش تیتانیوم دی اکسید &nbsp;نوع آناتازتهیه می شود . نوع روتیل از طریق وارد کردن ذرات روتیل (نشاندن ذرات روتیل در درون ذرات هیدروکسید تیتانیوم) یا فزودن نمک روی قبل از مرحله هیدرولیز، تهیه می گردد.</span></span></span></h2>\r\n\r\n<h2 dir=\"rtl\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"background-color:white\"><strong>روش کلراید</strong></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">در این روش گاز کلردر دمای 900 درجه سانتی گراد از روی مخلوط سنگ معدن روتیل و زغال کک عبور داده می شود، سنگ معدن روتیل 96-95% اکسید تیتانیوم دارد و واکنش زیر انجام می گیرد<span dir=\"LTR\">:<br />\r\n&nbsp;</span><br />\r\nتتراکلرید تیتانیوم فرار است ولی با کلرید فریک، که به علت وجود ناخالصیهای آهن در سنگ معدن تشکیل می شود، مخلوط می گردد. در هنگام سرد کردن گازها، کلرید فریک در دمای بالاتر از نقطه جوش تتراکلرید تیتانیوم به مایع تبدیل می شود. تتراکلرید تیتانیوم با سرد کردن بیشتر به مایع تبدیل و بوسیله تقطیر خالص می گردد<span dir=\"LTR\">.</span><br />\r\nتتراکلرید تیتانیوم در حرارت 1000 درجه سانتی گراد در مجاورت اکسیژن می سوزد که در اثر اکسید شدن آن تیتانیوم دی اکسید &nbsp;بدست می آید<span dir=\"LTR\">.<br />\r\n&nbsp;</span><br />\r\nبرای اطمینان از تشکیل رنگدانه نوع روتیل، اکسیژن مصرفی اندکی رطوبت دارد و علاوه بر آن مقدار کمی کلرید آلومینیوم نیز با تتراکلرید تیتانیوم مخلوط می شود که همزمان اکسیده می گردد<span dir=\"LTR\">.</span><br />\r\nتیتانیوم دی اکسید &nbsp;حاصل، برای جدا کردن ، اسید، کاملاً شستشو می شود و پس از عملیات بهبود سازی سطح خشک می گردد<span dir=\"LTR\">.</span><br />\r\nبا کنترل دقیق فرایند اکسیداسیون، تیتانیوم دی اکسید &nbsp;خالص تری بدست می آید که در نتیجه رنگ آن کاملاً سفید و اندازه ذرات آن تقریباً یکسان است<span dir=\"LTR\">.</span><br />\r\nعملیات بهبود سازی خصوصیات سطح رنگدانه<br />\r\nبرای بهتر شدن بعضی خواص عملی و کارآیی تیتانیوم دی اکسید &nbsp;(مثل قابلیت مرطوب شدن، سهولت پخش شدن و مقاومت در برابر گچی شدن ) با استفاده از اکسیدها&nbsp; یا هیدروکسید آلومینیم، سیلیسیوم و روی، عملیاتی روی سطح آن انجام می شود این عملیات شامل رسوب دادن مواد فوق از محلول نمکهای مربوطه بر روی سطح ذرات رنگدانه می باشد که پس از آن عملیات شستشو و خشک کردن انجام می گیرد. عملیاتی که روی سطح رنگدانه انجام می شود سبب کاهش فعالیت کاتالیزوری سطح رنگدانه می گردد، که در مورد روتیل فعالیت کاتالیزوری سطح خیلی کم می شود<span dir=\"LTR\">.</span><br />\r\nمقدار نسبی اکسیدهای مصرفی و مقداری که برای پوشش دار کردن سطح رنگدانه بکار می رود، بستگی به نوع کاربرد روتیل دارد، مثلاً آیا در رنگهای نهایی براق تزئینی ، مصرف می شود، یا لعابهای کوره ای صنعتی، یا رنگهای امولسیونی و غیره.مقدار تیتانیوم دی اکسید &nbsp;موجود در رنگدانه ای که عملیات بهبود سازی سطح بر روی آن انجام شده است می تواند بین 95-90% متغیر باشد<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">خواص تیتانیوم دی اکسید</span></span> </strong><br />\r\nدر میان رنگدانه های سفید، تیتانیوم دی اکسید &nbsp;دارای قدرت پوشانندگی بیشتر و همرنگ کنندگی بهتری می باشد و به همین علت به عنوان رنگدانه سفید بیشترین مصرف را به خود اختصاص داده است. این رنگدانه غیر سمی است و در مقابل حلالهایی که در رنگ بکار می روند مقاوم است و پایداری حرارتی خوبی هم دارد. همچنین پایداری شیمیایی آن خوب است، و تنها در اسید سولفوریک غلیظ حل می شود که سرعت واکنش خیلی کم است <span dir=\"LTR\">.</span><br />\r\nاین رنگدانه در دو نوع آناتاز و روتیل وجود دارد. ساختمان کریستالی هر دو یکسان است اما وزن مخصوص آناتاز کمتر از روتیل می باشد که به علت فاصله بیشتر بین اتمهای تیتانیوم و اکسیژن است. هر دو نوع رنگدانه زمانی که در معرض اشعه فرابنفش قرار می گیرند به شدت آن را جذب می کنند. نوع آناتاز در اثر جذب اشعه شدیداً تحریک می شود و فعالیت کاتالیستی سطحی زیادی از خود نشان میدهد، اما، تهییج و فعالیت کاتالیستی نوع روتیل بسیار کم بوده، و بیشتر انرژی جذب شده را به صورت گرما از دست می دهد<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"rtl\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong>گچی شدن یا سفیدک زدگی</strong></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">زمانی که دراثر تجزیه لایه سطحی رنگ پایه ، رنگدانه های آزاد (بدون اتصال شیمیایی) به وجود بیایند، این پدیده مشاهده می شود.دراین صورت در اثر سائیدن نوک انگشت روی سطح رنگ ، رنگدانه به صورت پودر سفید یا گچ جدا می گردد<span dir=\"LTR\">.</span><br />\r\nاین پدیده در فیلم رنگ محتوی آناتاز یا روتیل، بعد از مدتی که در مجاورت آتمسفر قرار می گیرد ، اتفاق می افتد. گچی شدن در نوع آناتاز سریعتر از نوع روتیل اتفاق می افتد و تخریب فتوشیمیایی فیلم شدیدتر از نوع روتیل انجام می گیرد. در واقع نوع روتیل، بخصوص نوعی که فرایند سطحی روی آن انجام شده، مقاومت بهتری در برابر گچی شدن نشان می دهد، به همین علت نوع روتیل در رنگهای رویه بیرونی بکار می رود. البته باید در نظر داشت که نوع رزین مصرفی در تمایل رنگ به گچی شدن مؤثر است<span dir=\"LTR\">.</span><br />\r\nبطور کلی رنگ طوری فرمولبندی می شود که در عین مقاومت در مقابل گچی شدن ، ظاهر سفید تمیزی نیز داشته باشد، به همین علت از مخلوط روتیل و آناتاز استفاده می شود. تخریب لایه سطحی رزین که منجر به گچی شدن فیلم رنگ می شود، به علت آن است که درمجاورت تیتانیوم دی اکسید &nbsp;سرعت اکسیداسیون افزایش می یابد. در این اکسیداسیون تیتانیوم دی اکسید &nbsp;نقش کاتالیزور را بازی می کند که نوع آناتاز بسیار فعالتر از نوع روتیل است. تحقیقات انجام شده نشان می دهد که آناتاز اکسیژن بیشتری را نسبت به روتیل جذب می کند. چنین تصور می شود که در لایه فیلم رنگ هم اکسیژن و هم بعضی از اجزای رنگ پایه بر روی سطح فعال شده تیتانیوم دی اکسید &nbsp;جذب می شوند، و چون جذب مواد اولیه بر روی سطح یک جامد عموماً منجر به کاهش انرژی فعالیت واکنش می گردد، بنابراین عمل فوق باعث تسریع اکسیداسیون لایه رنگ می شود. دانشمندانی که بر روی این مسئله تحقیق کرده اند، اظهار می دارند که وقتی تیتانیوم دی اکسید &nbsp;در اثر جذب اشعه فرابنفش تحریک می شود، واکنشهای انتقال الکترون بین اکسیژن و آب اتفاق می افتد و موجب بوجود آمدن مواد اکسید کننده می گردد<span dir=\"LTR\">.</span><br />\r\nاگرچه اکسایش رنگ پایه و تخریب بعدی آن ممکن است بر روی سطح تیتانیوم دی اکسید &nbsp;انجام گیرد، اما این عمل در سرتاسر سطح لایه رنگ پایه ، که حتی بخش اعظم آن اصلاً در تماس با رنگدانه نیز نیستند، اتفاق می افتد، چنین بنظر می رسد که این عمل بدین خاطر است که بعضی از ذرات پلیمری که در روی سطح تیتانیوم دی اکسید &nbsp;اکسید شده اند به سایر نقاط لایه رنگ نفوذ کرده و به اکسایش سایر مولکولها کمک می کنند و یا احتمالاً موجب یک سری واکنشهای زنجیره ای با مکانیزم رادیکال آزاد یا فعال سازی می گردند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"background-color:white\"><strong>موارد استفاده تیتانیوم دی اکسید </strong></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">زمانی که در رنگی رنگدانه سفید لازم است، معمولاً از تیتانیوم دی اکسید &nbsp;استفاده می شود. نوع روتیل در رنگهای تزئینی، رنگهای براق صنعتی، رنگهای تزئینی نیمه براق، رنگهای نهایی مات و پوست تخم مرغی، رنگهای دریایی، آستریها و رنگهای امولسیونی برای مصارف داخلی و خارجی بکار می رود<span dir=\"LTR\">.</span><br />\r\nنوع آناتاز در رنگهای صنعتی که سفیدی رنگ مسئله مهمی است ولی مقاومت آن در مقابل آب وهوا چندان اهمیتی ندارد، مانند رنگهای وسایل خانگی و تجهیزات بیمارستانی، بکار می رود<span dir=\"LTR\">.</span><br />\r\nشناسایی تیتانیوم دی اکسید<br />\r\nمقاومت شیمیایی بسیار خوب این رنگدانه ما را قادر می سازد که بتوانیم آن را از اکثر رنگدانه های دیگر جدا کنیم (البته این عمل در مورد بعضی از رنگدانه یارها عملی نیست. اما، با وجود این، چنین موادی در آزمایشات شناسائی ایجاد مزاحمت نخواهد کرد. شناسایی تیتانیوم دی اکسید &nbsp;با آزمایش ساده زیر انجام می گیرد<span dir=\"LTR\">.</span><br />\r\nمقدار کمی رنگدانه را در یک شیشه ساعت ریخته و آن را با اسید سولفوریک غلیظ مرطوب می کنیم. افزودن چند قطره محلول پر اکسید هیدروژن و ایجاد رنگ نارنجی یا زرد مایل به نارنجی نشان دهنده وجود اکسید تیتانیوم است<span dir=\"LTR\">.</span><br />\r\n<span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><strong>سمی بودن تیتانیوم دی اکسید </strong></span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">این رنگدانه غیر سمی است اما ذرات حاصل از حمل و نقل آن آزاردهنده می باشد<span dir=\"LTR\">.</span><br />\r\nمتر مکعب/ میلی گرم 10= مقدار حد مجاز ایمنی تیتانیوم دی اکسید <span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><a href=\"https://www.amazontele.com/article/%D8%AF%DB%8C%D8%B3%D9%BE%D8%B1%D8%B3-%D8%B4%D8%AF%D9%86-%D8%AA%DB%8C%D8%AA%D8%A7%D9%86\"><span style=\"color:#FF8C00\">&quot; یک مطلب جالب دیگر بخوانید &quot; </span><span style=\"color:#0000CD\">مکانیسم دیسپرس شدن تیتان&nbsp;<input alt=\"\" src=\"https://www.amazontele.com/article/%D8%AF%DB%8C%D8%B3%D9%BE%D8%B1%D8%B3-%D8%B4%D8%AF%D9%86-%D8%AA%DB%8C%D8%AA%D8%A7%D9%86\" type=\"image\" /></span></a></h2>','/app/articles/1535698363630.jpg','/app/articles/1535698363377.jpg','تیتان,تیتانیوم دی اکسید,اکسید تیتان,TiO2,Titanium dioxide,رنگ,پوشش,رنگ سفید,پیگمنت,تیتان چین,تیتان آلمان,روتایل,آناتاز,کرونوس,فیلم آموزشی','تیتان-چیست',8672,2,1,'2018-08-31 11:22:43','2022-01-11 21:10:07'),(22,1,'ضد کف چیست','ضد کف ها مواد شيميايی هستند که برای پيشگيری از توليد و ساخت کف بکار می روند و همچنين کف های ايجاد شده را می شکنند .','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><span style=\"font-size:22px\"><strong>جهت مشاهده لیست قیمت و خرید ضد کف ها<a href=\"https://www.amazontele.com/search_box?q=%D8%B6%D8%AF+%DA%A9%D9%81&amp;status=1\"><span style=\"color:#cc9900\"><span style=\"font-size:24px\"> اینجا </span></span></a>کلیک کنید</strong></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><span style=\"font-size:22px\"><strong>مقالات مرتبط :<a href=\"https://www.amazontele.com/article/%D8%B6%D8%AF-%DA%A9%D9%81-%D8%B3%DB%8C%D9%84%DB%8C%DA%A9%D9%88%D9%86%DB%8C-Silicone-antifoam\"><span style=\"color:#ff0000\"> 1- <span style=\"font-family:iransans\"><span style=\"font-family:comic sans ms,cursive\">ضد کف سیلیکونی Silicone antifoam</span></span></span></a></strong></span></h2>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><span style=\"font-size:22px\"><strong><a href=\"https://www.amazontele.com/article/%D8%B3%D8%A7%D8%AE%D8%AA%D8%A7%D8%B1-%D8%B6%D8%AF-%DA%A9%D9%81-%D9%87%D8%A7\"><span style=\"color:#ff0000\"><span style=\"font-family:iransans\"><span style=\"font-family:comic sans ms,cursive\">2-ساختار ضد کف ها</span></span></span></a></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><span style=\"font-size:22px\"><strong><a href=\"https://www.amazontele.com/article/%D8%B6%D8%AF-%DA%A9%D9%81-%D8%A2%D9%86%D8%AA%DB%8C-%D9%81%D9%88%D9%85-%DA%86%DB%8C%D8%B3%D8%AA\"><span style=\"color:#ff0000\"><span style=\"font-family:iransans\"><span style=\"font-family:comic sans ms,cursive\">3-</span></span><span style=\"font-family:iransans\">ضد کف (آنتی فوم) چیست؟</span></span></a></strong></span></p>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"background-color:white\">ضد کف چيست ؟</span>&nbsp;</span></span></strong><br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">ضد کف ها مواد شيميايی هستند که برای پيشگيری از توليد و ساخت کف بکار می روند و همچنين کف های ايجاد شده را می شکنند . برای پيشگيری از توليد کف و تمايل به کف کردن به مدار بسته آمين در گردش مواد ضد کف تزريق می شود و گاهی برای واکنش به کف ايجاد شده اقدام به تزريق می گردد و سرانجام مواد ضد کف سرتاسر محلول پخش شده و در برج های احياء و تماس همراه محلول آمين می چرخد . در بازار هزاران نوع ضد کف مختلف موجود می باشد . البته هر ماده ای که اثرات بی ثبات کنندگی روی کف ايجاد کند ضد کف می باشد و کارايی آن بستگی به خواص شيميايی محلول ، شرايط عملياتی و عوامل فعال در سطح که سبب کف می شود دارد . ضد کف های کارا معمولا&quot; مخلوط هايی ازترکيب مايعات و ذرات جامد تشکيل شده اند دسته بندی براساس ساختار اصلی شامل :</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">1 - روغن های غير قطبی : مواد معدنی و سيليکون ها .</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">2 - روغن های قطبی : الکل های چرب ، اسيدهای چرب ، الکيل آمين ها و آلکيل آميدها</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">3 - ذرات جامد نا سازگار با آب : سيليس تصفيه شده ، آلومينيوم اکسايد و پلی پروپيلن اين ترکيبات تقريبا&quot; هميشه حاوی مواد اضافی فعال در سطح هستند و برای افزايش خواص ديگر در مخلوط نهايی ، اضافه می شوند همانند : مرطوب کننده های سطح ، امولسيون&zwnj; سازي&zwnj; ، پاشنده ذرات شوينده ها .يکی از جوانب گيج کننده در کاربرد ترکيبات شيميايی عناصر فعال در سطح با خواص ضد کف کنندگی درمحلول ديگر به عنوان از بين برنده امولسيون است . فرمولاسيون مولکولی متنوع با پيچيدگی خواص فيزيک و شيميايی مابين سطحی و نياز به کنترل کف های ايجاد شده بيانگر وسعت انواع ضد کف ها می باشد . در وضعيت های عادی دستور العمل کاربرد ضد کف بنا به شرايط اختصاصی می باشد بنابراين بندرت جزييات و نحوه عملکرد ضد کف منتشر می گردد و در بيشتر مواقع از روش سعی و خطا برای تجويز ضد کف سازگار و مناسب استفاده می شود .در بسياری از حالت ها هنر شکستن کف و پيشگيری از کف به اندازه توليد کف پيچيده می باشد و با اطمينان می گوييم مطالعات سنگينی روی پديده کف کنندگی و عمل ضد کف در جريان است البته تا کنون دستورالعمل سريع و محکمی که تاثير يک نمونه ضد کف را برای هر کاربردی خاص تجويز کند موجود نمی باشد که بيشتر مواقع اطلاعات عملياتی بدست آمده با در نظر گرفتن عوامل فيزيک و شيميايی سازگار مورد پذيرش می باشد . عواملی که بر کارکرد ضد کف موثرند شامل موارد زير ند :</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">1- حلاليت 2 &ndash; اندازه قطره 3- حضور ذرات ناسازگار با آب 4 &ndash; نيروهای جانبی محيطی 5 &ndash; کف کردن مکرر 6 &ndash; رقابت شيميايی اجزاء سازنده 7 &ndash; تمرکز مواد در سطح 8 &ndash; انواع نمک های محلول و غلظت آنها</span></span>&nbsp;<br />\r\n<br />\r\n<strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"background-color:white\">اساس کف کردن</span>&nbsp;</span></span></strong><br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">به منظور درک مکانيزم های عمل ضدکف يک درک پايه ای از ساختارکف ضروری می باشد. حباب های کف محفظه هايی با شکل چند وجهی از جنس مايع هستند که مولکول های گاز را دربر گرفته اند . سطوح جدا کننده محفظه حباب ها ی مجاور را </span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">Lamellae</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> گويند . محل اتصال حباب هارا که از ديگر بخش های محفظه ضخيم تر است را مرز مسطح </span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">Plateau Border</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> ناميده اند . محل اتصال چند حباب در بخش مرز مسطح را قله يا راس </span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">Vertexes</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> ناميده اند . مرز های مسطح و محل تلاقی راس های حباب ها ، ساختار شبکه لوله کشی کف را تشکيل می دهند . مرزهای مسطح در ساختار کف بهم پيوسته و متصل می باشند و معبر يا کانال تخليه کف هستند . از اين مسير ها مايعات اضافی از ساختار کف تخليه می شود تا اينکه تعادل بين نيروی وزن و نيروی موينگی لايه ها برقرار گردد . انعطاف پذيری کف حاصل حضور مايع در ساختارش می باشد . هرگاه ساختار کف از مايع تخليه گردد حباب ها از شکل گرد ياکروی به شکل چند وجهی و کمی سفت با اشکال کريستالی تغيير شکل می دهد. کف حاصل از لايه مواد فعال در سطح که لايه های نازک </span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">Lamellae</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> را تشکيل داده اند به دليل اينکه ضعيفترين و نازکترين بخش محفظه حباب های کف هستند هدف ضدکف های سريع می باشند . ساختار لايه بين يک ماده فعال در سطح و محلول در جايی که مقداری از مواد محلول بين دو لايه های مواد فعال در سطح محاصره شده است بمحض اينکه ساختار کف تخليه می گردد سطوح جانبی نازک می شود و دو لايه مواد فعال در سطح به يکديگر نزديک تر می شوند . هرگاه لايه ها بسيار به يکديگر نزديک شدندجذب الکترو شيميايی مولکول ها شروع می گردد . آنها نيز در طول لايه جانبی پهلو به پهلو به يکديگر فشار وارد می کنند . در نتيجه تقابل الکتروشيميايی ساختار حباب بيشتر بلوری ، چند وجهی و سفت می شود . مواد فعال در سطح طبيعتا&quot;لايه های بين سطحی را به جهت ساختارهای شيميايی شکل می دهند . فضای نا منظم بين مولکول های مواد فعال در سطح در لايه و ذرات با بار الکتريکی در بيانگر اتفاقی است که بيش از يک نوع مواد فعال در سطح در محلول و سطح تماس مايع و گاز حضور دارند .فضای متغيرايجاد شده توسط دم های نا سازگار با آب از مولکول های مختلف مواد فعال در سطح پايداری هر دو لايه های بوجود آمده و ذرات با بار الکتريکی را کاهش می دهد .محلول های مخلوط از مواد فعال در سطح ذرات با بار الکتريکی ولايه های نا پايدار توليد می کنند . ذرات با بار الکتريکی کم پايدار از خود واکنش نشان می دهندو بصورت برشی از يکديگر جدا می شوند در نتيجه لايه های مولکول های مواد فعال در سطح توسعه و افزايش می يابد .گرچه لايه هايی که توليد شده اند نا پايدار ند .يکی از اهداف کلی استفاده از ضد کف ، نا پايدار کردن لايه های مواد فعال در سطح با اضافه کردن ديگر مواد فعال در سطح دارای دم های هيدروکربوری بلند می باشدبطوريکه فواصل بين مولکولی بين موادفعال در سطح که توليد لايه های بين سطح کرده اند ايجاد می گردد . موادفعال در سطح طبيعتا&quot; کشش سطحی و بين سطحی محلول های آبی را کاهش می دهند . کشش سطحی ميزانی از تقابل مولکولی در سطح تماس بين گاز و مايع می باشد . يک آب پاک کشش سطحی تقريبا&quot; برابر با 72 (دين / سانتی متر مربع ) دارد .يک محلول </span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">MDEA 40%</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> گرفته شده از </span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">Surge Drum</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> با دو روز تزريق ضد کف کشش سطحی حدود 55 ( دين / سانتيمتر مربع ) دارد . چنانچه از همان نمونه بعد از چند ساعت تزريق نمونه برداريم و آزمايش کنيم کشش سطحی عدد متفاوتی را نشان می دهد . در محلول های آبی باکشش های سطحی کم طبيعتا&quot; بدين معنی است که در مقطع تماس مايع و گاز با تمرکز زياد مواد فعال در سطح مواجه می باشيم . اگرچه اطلاعات کشش سطحی بدست آمده به تنهايی ممکن است گمراه کننده باشد . برای مثال در پيش بينی تمايل محلول تصفيه گاز به کف کنندگی به جهت آلودگی موادفعال در سطح قادر نيستيم فقط به تنهايی با داشتن مقدارکشش سطحی پيش بينی درستی انجام دهيم بعضی از مواد فعال در سطح برای مثال : ضد کف ها و هيدروکربورهای مايع تمايل به کف کنندگی را کاهش داده در حاليکه کشش سطحی را هم کاهش می دهند . از آنجايکه اينگونه ترکيبات در سطح فعال می باشند آنها بر کشش سطحی موثرند همانگونه که مواد فعال در سطح که سبب کف می گردد . مثال با ارزش ديگر از برداشت فريبنده اطلاعات بدست آمده از آزمايش ومحاسبه کشش سطحی فرض اينکه کارايی ذغال فعال از دست رفته و برای تعويض آن اقدام شود .</span></span>&nbsp;<br />\r\n<br />\r\n<strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"background-color:white\">مکانيزم تخريب کف توسط ضد کف</span>&nbsp;</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"background-color:white\"><span style=\"color:black\">قطرات نا محلول روغنی معلق در محلول وارد لايه ی سطحی می گردد که توسط مواد فعال در سطح تشکيل شده به عنوان حباب گازی که روی سطح کلی جابجا می شود. نيرويی که قطره نيازدارد به درون لايه غشاء نفوذ کند بنام نيروی مانع يا مقاوم ورودی لايه غشاء ناميده شده است . مطالعات نشان داده است که ذرات معلق نا سازگار با آب در ضد کف ها نيروی مانع ورودی به لايه غشاء را کاهش می دهد و ضد کف را بسيار کارا و موثر می سازد . ساختار کف بفوريت شروع به تخليه می شود بعد از اينکه لايه حباب کف ضعيف و لاغر می شود . قطره ضد کف در طول لايه غشاء يک عدسی روغنی می سازد . قطره کشيده می شود همانگونه که لايه های غشاء با يکديگر مماس و فشرده می شوند و در نهايت با پاره شدن قطره کشيده شده حباب کف می ترکد . اين عمل در حدود چند ثانيه رخ می دهد بطوريکه جزء مشخصه های ضد کف های سريع می باشد . اگر قطره روغنی نتواند وارد غشاء شود و کف را تخريب کند طبيعتا&quot; درمرزهای حباب کف به تله افتاده و بعنوان يک مايع اضافی در ساختار مجرای تخليه کف به بيرون از حباب هدايت می شود .</span></span>&nbsp;<br />\r\n<br />\r\n<span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\"><span style=\"background-color:white\">چرا استفاده از ضد کف محدود است ؟</span>&nbsp;</span></strong></span><br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">بيشتر توليدکنندگان و فروشندگان محلول های آمين توصيه می کنند در کوتاه مدت و به نسبت محدود از ضد کف در کاربرد محصولشان استفاده شود و بندرت دلايل قانع کننده و کافی در رابطه با کف کنندگی ارائه می نمايند . همانطور که در مقدمه اين مقاله اشاره شد بنظر نمی رسددر بيشتر واحدهای تصفيه گاز کف کردن مشکل حادی باشد با تزريق ضد کف عمليات ادامه داشته و خود را به يک روز کاری ديگر می رسانند توليدکنندگان و فروشندگان راست گفته اند اگر مجبوريم به يک واحد ضدکف تزريق کنيم يقينا&quot;واحدتصفيه گاز با مشکلی مواجه است که بايستی آن مشکل را از بين برد . در زير نتايجی که از تزريق ضدکف که بيش از موارد گهگاهی استفاده گرديده آورده شده است :</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">1 - هرگونه ماده شيميايی که در کنار مولکول های آمينی در فرآيند جذب گازهای اسيدی که در سطح انتقال جرم از گاز به مايع وارد گردد و در فرآيند جذب دخالت کند اجبارا&quot; کارايی حذف گازهای اسيدی را کاهش خواهد داد .ترکيبات شيميايی فعال در سطح طبيعتا&quot; در سطح تماس بين گاز و مايع تجمع می کنند . مطالعات انجام شده ممانعت انتقال جرم گاز به مايع توسط مواد فعال در سطح را تاييد کرده اند . يک مطالعه که اخيرا&quot; انجام شده و ضد کف به عنوان مواد فعال درسطح بوده است کاهش 55% در کارايی </span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">MDEA</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> را نشان داده است . همچنين مطالعات در باره توانايی تاثير مواد فعال در سطح روی انتفال حرارت را نشان داده اند .</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">2 - مطالعات انجام شده روی بعضی از ضد کف ها با فرمولاسيون معين بيانگر غير فعال شدن آنها با افزايش تمرکز در سطح می باشد .</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">3 - ضد کف عوامل کف زا را حذف و يا از نظر شيميايی غيرفعال نمی کند . ضد کف بطور موقت پايداری ساختار کف ها ی توليد شده را کاهش می دهند .</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">4 - ذغال فعال بسياری از مولکول های مواد آلی و نا محلول در آب همانند مايعات هيدروکربوری را جذب می کند . هيدروکربورهای با ساختار مولکولی بزرگتر و پرشاخه بصورت موثرتری جذب می شوند . از گذشته دور مشخص شده است که ذغال فعال با راندمان بالا ضد کف های سيليکونی را جذب می کند و مطالعات همچنين نشان داده است ذغال فعال ضد کف های غير يونی را جذب سطحی می کند .</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">5 - عکس های ميکروسکوپی دريافت شده مربوط به يک واحد تصفيه گاز حباب های ضد کف که در محلول آمين ذرات سولفيد آهن را جذب نموده و تشکيل توده بهم فشرده ای را داده است . اين عکس ها نشانگر خروج قطرات ضد کف بهم چسبيده همراه ديگر مواد زائد از بستر ذغال فعال که سبب گرفتگی صافی های مکانيکی و مسدود شدن نا بهنگام آنها می شود را نشان می دهد.</span></span>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">6 - ضد کف ها خودشان مواد فعال در سطح هستند و در اندازه کشش سطحی موثرند استفاده از اطلاعات کشش سطحی توليدکنندگان و فروشندگان محلول های آمين و يا نتايج آزمايشگاهی برای نشان دادن حضور کف در حلال ناشی از مواد فعال در سطح را غير ممکن می سازد . 7 - حضور ضد کف در سيستم شديدا&quot; از تفکيک عوامل مکانيکی به نسبت شيميايی که تمايل به کف کردن دارند پيشگيری می کند اگر چه هردو تحت تاثير چند درجه کاهش نسبت از کشش سطحی واقع شده اند .</span></span>&nbsp;<br />\r\n<br />\r\n<strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"background-color:white\">نتيجه گيری</span></span></span></strong>&nbsp;<br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">فرآيند کف کردن يک مشکل عملياتی است که نيازمند اقدام سريع در تمامی صنايع بويژه در فرآيندهای شيرين سازی گاز طبيعی و پالايشگاه های نفت می باشد .ياد گيری و آموزش به نسبت لازم در باره ماهيت و تاثيرات مواد شيميايی افزودنی به واحدهابرای افراد در گير در عمليات ضروری می باشد .تزريق مواد شيميايی ضد کف در محلول آمين درگردش کار روزانه اوپراتورهادر واحد های تصفيه گاز می باشد . اين مطلب بخوبی بايستی درک شود اگر چه ضد کف ممکن است در کوتاه مدت درمانی برای عمليات باشد ولی بصورت بالقوه مشکلات حادی در نتيجه استفاده نا بجا و بی اندازه پديدارمی شود . نياز به تزريق ضد کف بصورت گهگاهی درمانی موقت است . راه حل اساسی حذف عوامل کف زا می باشد</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">.</span></span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"background-color:white\"><span style=\"color:black\">منبع وب سایت شرکت یکتا پژوه</span></span>&nbsp;</span></span></span></h2>\r\n\r\n<h2 style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>','/app/articles/1535724779496.jpg','/app/articles/1535724779768.jpg','ضد کف,آنتی فوم,دفوم,ضد حباب,اپوکسی,آکریلیک,سیلیکونی,غیر سیلیکونی,رنگ,پوشش','ضد-کف-چیست',1606,3,1,'2018-08-31 18:42:59','2022-01-11 14:55:12'),(23,2,'پلی یورتان چیست','پلی‌یورتان از دو منومر تهیه می‌شود، یک دی‌ال و یک دی‌ایزوسیانات.','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">نخستین پلی یورتان در سال ۱۹۳۷توسط اتوبایر</span>&nbsp;<span style=\"color:#444444\"> در</span>&nbsp;<span style=\"color:#444444\">آلمان</span>&nbsp;<span style=\"color:#444444\">کشف شد و پس از آن، </span>&nbsp;<span style=\"color:#444444\">این مواد به علت داشتن خواص ویژه پیشرفت بسیار زیادی را در انواع صنایع جهان داشتند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">پلی یورتان</span><span dir=\"LTR\"><span style=\"color:#444444\"> (PU) </span></span><span style=\"color:#444444\">نام عمومی بسپارهایی است که دارای پیوند یورتانی می باشند. پیوند یورتانی از طریق واکنش افزایشی بین یک گروه ایزوسیانات و یک ترکیب دارای هیدروژن فعال مثل گروه هیدروکسیل تشکیل شده است. گروه های ایزوسیانات به شدت واکنش پذیر بوده و به همین علت پیشرفت واکنش آنها نیاز به افزایش دما ندارد. (واکنش در دمای محیط صورت می گیرد</span><span dir=\"LTR\"><span style=\"color:#444444\">).</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">پلی یورتان در اشکال مختلف مانند: فوم، فیلم، الاستومرها، پودرها، مایعات و امولوسیون ها قابل تولید هستند. ترکیباتی که دارای گروه ایزوسیانات هستند عبارتند از</span><span dir=\"LTR\"><span style=\"color:#444444\">:</span></span></span></span></span></h2>\r\n\r\n<ol>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">۲و۴ یا ۲و۶ تولوئن دی ایزوسیانات</span> <span style=\"color:#444444\">&nbsp;(</span><span dir=\"LTR\"><span style=\"color:#444444\">TDI</span></span><span style=\"color:#444444\">)</span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">۴و۴ یا ۲و۴ دی فنیل متان دی ایزوسیانات (</span><span dir=\"LTR\"><span style=\"color:#444444\">MDI</span></span><span style=\"color:#444444\">)</span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">۱و۶ هگزا متیلن دی ایزوسیانات (</span><span dir=\"LTR\"><span style=\"color:#444444\">HDI</span></span><span style=\"color:#444444\">)</span></span></span></span></h2>\r\n	</li>\r\n</ol>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">علاوه بر موارد ذکر شده، ترکیبات ایزوسیاناتی دیگری نیز وجود دارند</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">ترکیباتی که دارای بیش از دو گروه هیدروکسیل</span><span dir=\"LTR\"><span style=\"color:#444444\">(OH) </span></span><span style=\"color:#444444\">باشند را پلی اُل می نامند و در سنتز پلی یورتان معمولا از گونه های زیر استفاده می شود</span><span dir=\"LTR\"><span style=\"color:#444444\">:</span></span></span></span></span></h2>\r\n\r\n<ol>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">پلی اتر پلی ال</span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">پلی استر پلی ال</span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">پلی کربنات پلی ال</span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">پلی کاپرولاکتون پلی ال</span></span></span></span></h2>\r\n	</li>\r\n</ol>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">به علاوه، به جای گروههای هیدروکسیل، ترکیباتی مثل اسیدهای کربوکسیلیک و آمینها، که دارای هیدروژن فعال هستند نیز می توانند در ترکیب با ایزوسیاناتها مورد استفاده قرار گیرند. اگر به جاي دي الكل، يك دي آمين با ايزوسيانات وارد واكنش شود، بسپار به دست آمده در خانواده پلي اوره ها قرار مي گيرد. اسپاندکس بسپاري با ساختاري پيچيده است كه هر دو گروه عاملي اوره و یورتان را دربردارد. بنابراين گوناگوني واكنشگرهايي كه در برابر ايزوسيانات ها قرار مي گيرند به توليد پلي یورتان ها در انواع گوناگون با ويژگي هاي متفاوت مي انجامد. به همین دلیل، زمانیکه صحبت از پلی یورتانها می شود، می توان گفت که گونه های بیشماری از آنها وجود دارد</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:#444444\">كاربردها</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">هزينه توليد از جمله نكته هايي است كه در كاربردهاي يك ماده بايد مورد توجه قرار گيرد. پلي یورتان هاي آليفاتيك از انواع آروماتيك آن گران ترند. از اين رو از پلي یورتان هاي گران تر، بيش تر به عنوان پوشش بيروني وسايل استفاده مي شود در حالي كه، انواع آروماتيك و ارزان تر در توليد رنگ هاي پايه و پوشش هاي اوليه كاربرد دارند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">در مجموع، تهيه صندلي هاي نرم، قالب هاي نارسانا، درپوش و واشرهاي ريزساختار، لاستيك هاي بادوام براي خودروها. مواد درزگير، چسب و جلادهنده از جمله كاربردهاي پلي یورتان ها به شمار مي روند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"rtl\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong>بر گرفته شده از وب سایت سیماب رزین</strong></span></span></h2>','/app/articles/1535777126480.jpg','/app/articles/1535777127343.jpg','هاردنر,ایزوسیانات,MDI,HDI,TDI,رزین هیدروکسیل دار,پلی اول,کفپوش,دزمادور','پلی-یورتان-چیست',1066,2,1,'2018-09-01 09:15:27','2022-01-11 22:09:40'),(24,2,'مروری بر رزین های آکریلیک','رزین های آکریلیک محصول پلیمریزاسیون اسیدهای آکریلیک ، متاکریلیک و مشتقات آنها می باشد','<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong><span style=\"color:#2e3192\">رزین </span><span style=\"color:#2e3192\">های </span><span style=\"color:#2e3192\">اکریلیک</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">رزین های آکریلیک محصول پلیمریزاسیون اسیدهای آکریلیک ، متاکریلیک و مشتقات آنها می باشد که تفاوت اسید متاکریلات با اسید آکریلیک در این است که در اسید متاکریلیک گروه متیلی بجای اتم هیدروژن کربن، اکریلات نشسته است.&nbsp;در کل رزین های آکریلیک به دو گروه عمده ترموپلاست و ترموست تقسیم می شوند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">۱<span dir=\"LTR\">-</span>رزین های آکریلیک ترموست</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">رزین های آکریلیک ترموست همو پلیمر یا کوپلیمر استرهای اسید آکریلیک و یا اسید متاکریلیک می باشند که با خود و یا با یک کوپلیمر دیگری که دارای عامل فعال ئیدروکسیل کربوکسیل ، متیلول آمید و یا اپوکسی می باشد تحت حرارت کراس لینک نموده و تشکیل یک فیلم سختی را می دهند.&nbsp;رنگهای آکریلیکی ترموست نه تنها براقیت و حفظ براقیت خوبی دارند، بلکه در محلول قابل اسپری از درصد جامد مناسبی برخوردار بوده و مقاومت شیمیایی بیشتری نیز از آکریلیک های ترموپلاست دارند،هرچند که مقاومت بیرونی آنان ممکن است به خوبی رزین های ترموپلاست نباشند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">۲<span dir=\"LTR\">-</span>رزینهای آکریلیک ترموپلاست</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">این رزین ها هموپلیمر یا کوپلیمر استرهای اسید آکریلیک و یا اسید متاکریلیک می باشند و از آنجاییکه منومر های آکریلیک و متاکریلیک امتزاج پذیری خوبی با هم دارند از اینرو می توان آنها را به هر نسبتی کوپلیمراز نمود.&nbsp;رزینهای آکریلیک ترموپلاست ساختمانی مشابه رزین های ترموست دارند با این تفاوت که بر خلاف آنان فاقد هر گونه گروه فعال بوده و به علاوه دارای وزن مولکولی نسبتا زیادی بوده و در ضمن بوسیله ی مکانیزم تبخیر حلال خشک و سخت می گردند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">رزین های اکریکیک پایه آبی در دو فرم معلق در آب (امولسیونی) و محلول در آب تولید می گردند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#4f81bd\"><strong><strong><span style=\"color:#333333\">بر گرفته شده از وب سایت سیماب رزین</span></strong></strong></span></span></span></span></h2>','/app/articles/1535778468588.jpg','/app/articles/1535778469396.jpg','آکرلیک ترموست,آکرلیک ترموپلاست,آکریلیک دو جزئی,آکریلیک آب پایه,پلیمریزاسیون رادیکالی','مروری-بر-رزین-های-آکریلیک',996,3,1,'2018-09-01 09:37:49','2022-01-09 12:20:38'),(25,1,'غلظت دهنده های پلی یورتانی','غلظت دهنده ها بر اساس مكانیسم غلظـت دهنـدگي بـه دو گـروه همگرا و غيرهمگرا تقسيم مي شوند','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><a href=\"https://www.amazontele.com/search_box?q=1214\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/اینجا کلیک کنید.png\" style=\"height:112px; width:250px\" /></a></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:22px\">مقالات زیر را از دست ندهید ! </span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:22px\"><a href=\"https://www.amazontele.com/article/%D9%BE%D9%84%DB%8C-%DB%8C%D9%88%D8%B1%D8%AA%D8%A7%D9%86-%DA%86%DB%8C%D8%B3%D8%AA\"><span style=\"color:#800000\">1- پلی یورتان چیست</span></a>&nbsp;؟</span></strong></h2>\r\n\r\n<p dir=\"RTL\"><a href=\"https://www.amazontele.com/article/%D8%A7%D9%81%D8%B2%D9%88%D8%AF%D9%86%DB%8C-%D9%87%D8%A7%DB%8C-%D8%AC%D8%A7%D8%B0%D8%A8-%D8%B1%D8%B7%D9%88%D8%A8%D8%AA-%D8%AF%D8%B1-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85-%D9%87%D8%A7%DB%8C-%D9%BE%D9%84%DB%8C-%DB%8C%D9%88%D8%AA%D8%A7%D9%86\"><span style=\"color:#800000\"><strong><span style=\"font-size:22px\">2- افزودنی های جاذب رطوبت در سیستم های پلی یورتان</span></strong></span></a></p>\r\n\r\n<p dir=\"RTL\"><a href=\"https://www.amazontele.com/article/%D9%BE%DB%8C%D8%B4%D9%86%D9%87%D8%A7%D8%AF-%D9%81%D8%B1%D9%85%D9%88%D9%84%D8%A7%D8%B3%DB%8C%D9%88%D9%86-%DA%A9%D9%81%D9%BE%D9%88%D8%B4-%D9%87%D8%A7%DB%8C-%D9%BE%D9%84%DB%8C-%DB%8C%D9%88%D8%B1%D8%AA%D8%A7%D9%86\"><span style=\"color:#800000\"><strong><span style=\"font-size:22px\">3- </span></strong><span style=\"font-size:22px\"><strong>پیشنهاد فرمولاسیون کفپوش های پلی یورتان</strong></span></span></a></p>\r\n\r\n<p dir=\"RTL\">&nbsp;</p>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong>غلظت دهنده های پلی یورتانی چیست؟</strong></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">غلظت دهنده ها بر اساس مكانیسم غلظـت دهنـدگي بـه دو گـروه همگرا و غيرهمگرا تقسيم مي شوند. ساختار غلظت دهنده&zwnj;هاي همگـرا شامل يك بدنه آبدوست با سرهاي آبگريز مي باشد. زماني كه اين مواد در داخل آب قرار مي گيرند، قسمتهاي آبدوست تمايل به حـل شـدن در آب دارند، در حالي كه قسمت هاي آبگريز بـه سـمت هـم جـذب ميشوند به &nbsp;دليل اين تفاوت رفتاري مايسل هايي در سيـستم تـشكيل ميگردد. بعضي از زنجيره ها نيز مابين اين مايسلها قـرار مـي گيرنـد و نقش يك پل را بـازي مـي كننـد . ابعـاد ايـن مايـسل هـا و نيـز تعـداد زنجيرهايي كه ما بين آنها قرار مي گيرد، بر روي بازده غلظت دهنـدگي اين مواد مؤثر مـي باشـند . ولـي مكانيـسم اصـلي غلظـت دهنـدگي، در غلظت دهنده&zwnj;هاي غيرهمگرا، بـر اسـاس تـورم مولكـول هـاي پليمـري غلظت دهنده و گره هاي مولكولي بين زنجيره ها مي باشـد . بنـابراين ، در اين مواد وزن مولكولي پليمر نقش اساسـي در بـازده غلظـت دهنـدگي ایفا میکند. غلظت دهنده هاي پلي يورتاني، جزء گروه غلظت دهنده هـاي همگـرا ميباشند. ساختار اين مواد، همچون ساير غلظت دهنده هـاي همگـرا از يك بدنة آبدوست و انتهـاي آبگريـز تـشكيل شـده اسـت . در سـاخت غلظت دهنده هاي پلـي يورتـاني از پلی ال پلـي اتـيلن گليكـول اسـتفاده مي شود . دليـل اسـتفاده از ايـن پلـي ال ايجـاد قـسمت آبدوسـت در غلظت دهنده پلي يورتـاني اسـت</span><span dir=\"LTR\"><span style=\"color:#444444\"> .</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#444444\">بـراي سـاخت ايـن مـواد از دو روش استفاده مي شود. در روش اول گروه آبگريز كه شامل يك گروه عـاملي هيدروكسيل است، طي واكنش با گروه هاي</span><span dir=\"LTR\"><span style=\"color:#444444\"> NCO </span></span><span style=\"color:#444444\">انتهايي پيش پليمـر تشكيل شده در مرحلة او ل، به زنجيرة آبدوست اسـتخلاف مـي گـردد . ولي در روش دوم گروه آبگريز كه شامل يك گروه عـاملي ايزوسـيانات ميباشد، طي واكنش با گروه هاي عاملي هيدروكسيل انتهـايي پلـي ال، به طور مـستقيم بـه زنجيـرة آبدوسـت پلـي ال اسـتخلاف مـي گـردد . غلظت دهنده هايي كه با روش اول ساخته مي شوند، غلظت دهندة رشـد مرحله ای یافته</span><span dir=\"LTR\"><span style=\"color:#444444\"> (S-G HEUR) &nbsp;</span></span><span style=\"color:#444444\">و غلظت دهنـده هـايي كـه بـا روش دوم تهيه مي گردند، غلظت دهنده هاي با توزيع وزن مولكولي نـسبتاً &nbsp;باریک</span><span dir=\"LTR\"><span style=\"color:#444444\"> (Uni-HEUR)</span></span><span style=\"color:#444444\">ناميده مـي شـوند</span><span dir=\"LTR\"><span style=\"color:#444444\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#4f81bd\"><strong><strong><span style=\"color:#333333\">بر گرفته شده از وب سایت سیماب رزین</span></strong></strong></span></span></span></span></h2>','/app/articles/1535779033236.jpg','/app/articles/1535779033303.jpg','غلظت دهنده پلی یورتان ,غلظت دهنده آب پایه,رزین آب پایه,رنگ آب پایه','غلظت-دهنده-های-پلی-یورتانی',808,2,1,'2018-09-01 09:47:13','2022-01-09 05:45:06'),(26,2,'رزین سلولز استات بوتیرات','برای تولید سلولز استات بوتیرات نیاز به سلولز بسیار خالص است','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><span style=\"font-size:22px\"><strong>جهت مشاهده لیست قیمت و خرید رزین سلولز استات بوتیرات<a href=\"https://www.amazontele.com/search_box?q=cab&amp;status=1\"><span style=\"color:#ff0099\"><span style=\"font-size:24px\"> اینجا </span></span></a>کلیک کنید</strong></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">رزین سلولز استات بوتیرات <span dir=\"LTR\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;CAB</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:#800080\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\"><span dir=\"LTR\">Cellulose Acetate Butyrate&nbsp; </span>&nbsp;&nbsp;</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سلولز مهمترین ماده تشکیل دهنده گیاهان است. مولکول های سلولز یک زنجیر خطی پلی ساکارید است که از واحد های گلوکزی از طریق پیوند های گلیکوزیدی به هم متصل شده اند ، تشکیل شده است. وزن مولوکلی آن بین 500000 تا &nbsp;<span dir=\"LTR\">g/mol</span>1000000 است که در هر مولکول آن بین 3000 تا 5000 واحد گلوکزی وجود دارد . مولکول ها به صورت کشیده بوده و تشکیل ماسیل های بلوری را می دهند که این امر توجیه کننده استحکام فوق العاده سلولز است. از آنجایی که پلیمر هایی با مایسل های بلوری قابلیت انحلال در حلالها را ندارند ، در نتیجه یک ماده نامناسب برای پوشش ها ست. مهمترین کاربرد سلولز ها کاربرد سلولز استفاده آنها در منسوجات است. انجام یک سری اصلاحات بر روی سلولز با استفاده از استر ها ، اتر ها و نیترات ها باعث می شود که استفاده از سلولز در پوشش ها میسر شود . در بیس کوت ها ی حلال پایه سلولز استات بوتیرات مهمترین مشتق سلولز است که در این لایه استفاده می شود .</span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برای تولید سلولز استات بوتیرات نیاز به سلولز بسیار خالص است.در گذشته این سلولز از پنبه تهیه می شد. اما امروزه از چوب تهیه می شو ند. الیاف سلولزی در دمای 50 تا <span dir=\"LTR\">C</span>80<sup>0</sup> در استیک اسید پراکنده شده و سپس با استفاده از یک مخلوط انیدرید استیک ،&nbsp; انیدرید بوتیریک و مقداری اسید سولفوریک اصلاح می شوند. تقریبا تمامی گروه های هیدروکسیلی به گروهای استری تبدیل می شوند . سلولز های استری شده حاصل در اسید استیک قابل حل هستند در واقع مولکول های بزرگ به مولکول های کوچکتر شکسته می شوند که میزان آنها بستگی به دمای مورد استفاده و زمان انحلال بستگی دارد. شکست اسیدی پیوند های گلوکوزیدی باعث می شود تا مولکول ها فقط 100 تا 350 واحد گلوکزی داشته باشند. برای رسیدن به حلالیت و سازگاری ، برخی از گروه های استری با افزایش آب به مخلوط واکنش صابونی می شوند. این امر باعث تجزیه مولکول پلیمر می گردد. ساختار مولکول پلیمر سلولز استات بو تیرات به شکل زیر می باشد:<br />\r\n<img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/Cellulose Acetate Butyrate.jpg\" style=\"float:left; height:170px; width:426px\" /></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 style=\"text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">انواع سلولز استات بوتیرات های موجود ، اندازه مولکول (تعریف و اندازه گیری شده و از روی ویسکوزیته محلول مورد آزمایش) تعداد گروه های استات و بوتیرات و تعداد گروهای هیدروکسیل آزاد آنها با هم متفاوت هستند. به عنوان مثال در یک نوع سلولز استات بوتیرات مورد استفاده در یک بیس کوت متالیکی دارای 13تا 16 درصد وزنی گروه استات ، 33 تا 38 درصد وزنی گروه بوتیرات&nbsp; و متوسط گروه هیدروکسیلی آزاد آنها 1.8 درصد وزنی خواهد بود. ویسکوزیته دینامیکی آن حدود 700 الی 1900 سانتی پویز (محلول 15% وزنی در بوتیل استات) است. این نو از سلولز استات بوتیرات ، در استر ها ، کتون ها، گلیکول اتر ها و گلیگول اتر استر ها حل می شوند. همچنین با کمک حلال هایی مثل هیدروکربن های آروماتیکی یا الکل ها و یا هر دو رقیق می شوند. با توجه به اینکه این ترکیبات گروه هیدروکسیل آزاد دارند ، مشارکت آنها در واکنش شبکه ای شدن امکان پذیر است. با وجود اینکه فرایند های استری شدن به میزان زیادی بلوریت سلولز را از بین می برند ، مولکول های استات بوتیرات مخصوصا آنهایی که جرم مولکولی بالایی دارند باز هم تمایل به همبسته شدن دارند. این تمایل آنها به اتحاد مولکول ها باعث ایجاد حوزه هایی در ساختار فیلم می شوند . وجود این مناطق و حوزه ها باعث بر هم زدن جلوه های ویژه نمی شوند.بلکه این مزیت دارد که باعث افزایش مقاومت بیس کوت ها در برابر دوباره حل شدن نیز می شوند. وجود این حوزه ها با میکروسکوپهای تداخلی قابل مشاهده است.هر چه جرم مولکولی سلولز استات بوتیرات بیشتر باشد مقاومت آن در برابر دوباره حل شدن نیز بیشتر خواهد بود و همچنین مقاومت بیس کوت ها در برابر مواد شیمیایی ، حلال ها و تنشهای مکانیکی بهتر می شود . اما سازگاری آن ها با رزین های دیگر کمتر می گردد و درصد جامد آن ویسکوزیته کاربردی بیس کوت کمتر خواهد شد. اثرات سلولز استات بوتیرات با جرم مولکولی کمتر نیز برعکس اثرات ناشی از سلولز استات بوتیرات با جرم مولکولی بالاست.مقادیر بیشتر بوتیرات باعث بهبود حلالیت و سازگاری می شود در حالی که مقادیر بیشتر استات باعث افزایش مقاومت فیلیم در برابر دوباره حل شدن آن می شود. مقادیر بیشتر گروهای هیدروکسیلی هم باعث بهبود سازگاری آن با ترکیب رزینی می شود.</span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به خاطر سازگاری مولکولی سلولز استات بوتیرات و تمایل مولکول های آن به برقراری اتصال و همبسته شدن ، خواص محلول های سلولز استات بوتیرات تا حدی با رزین های مرسوم فرق دارند . در ایتدا تبخیر حلال خیلی سریعتر از رزین های دیگر است و در انتهای فرایند خشک شدن فیزیکی فیلم ، ساختار پیچیده شده مولکول های سلولز استات بوتیرات حلال باقیمانده را در خود نگه داشته و با سرعت کمتری آزاد می کنند. در واقع چنین خصوصیتی مزیت این مواد به حساب می آید که باعث افزایش مقاومت فیلم در برابر دوباره حل شدن و بهبود خاصیت همتراز شدن فیلم رنگ می شود. نمونه های تجاری از سلولز استات بوتیرات ها با نام <span dir=\"LTR\">CAB</span> توسط کمپانی ایستمن <span dir=\"LTR\">Eastman</span> امریکا با کد بندی های مختلف تولید و در بازار های جهانی برای کاربرد های مختلف عرضه می گردد:</span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-171-15</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-171-15NF</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-321-0.1</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-381-0.1</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-381-0.5</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-381-2</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-381-2BP</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-381-20</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-381-20BP</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-500-5</span> </span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-531-1</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-551-0.01</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-551-0.2</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">Eastman CAB-553-0.4</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ارائه شده توسط مهندس میثم سیروس رضائی &ndash; کارشناس ارشد مهندسی رنگ</span></span></h2>','/app/articles/1535874890910.jpg','/app/articles/1535874890962.jpg','سلولز استات بوتیرات ,CAB,Eastman,ایستمن,CAB-381-2,CAB-381-20,CAB-381-0.1,CAB-551-0.2','رزین-سلولز-استات-بوتیرات',6633,2,1,'2018-09-02 12:24:50','2022-01-11 20:16:55'),(27,1,'همتراز کننده ها در رنگها','از آنجا که همترازی سطح پوشش نهایی (Levelling) شاخص مهمی در خواص ظاهری و فیزیکی آن است نقش همتراز کننده ها جدی میباشد.','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><strong><span style=\"font-size:22px\">برای مشاهده سایر مقالات همتراز کننده&nbsp;<span style=\"font-size:24px\"><span style=\"font-family:iranyekan\"><a href=\"https://www.amazontele.com/article/%D9%85%D9%88%D8%A7%D8%AF-%D8%A7%D9%81%D8%B2%D9%88%D8%AF%D9%86%DB%8C-%D9%87%D9%85%D8%AA%D8%B1%D8%A7%D8%B2-%DA%A9%D9%86%D9%86%D8%AF%D9%87-Leveling-agent\"><span style=\"color:rgb(52, 152, 219)\">اینجا</span></a></span></span><span style=\"font-family:iranyekan\"><span style=\"font-size:24px\">&nbsp;</span>کلیک کنید.</span></span></strong></h2>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><strong><span style=\"font-size:22px\"><span style=\"font-family:iranyekan\">برای مشاهده لیست قیمت leveling agent <span style=\"font-size:24px\"><a href=\"https://www.amazontele.com/search_box?q=%D9%87%D9%85%D8%AA%D8%B1%D8%A7%D8%B2&amp;status=1\"><span style=\"color:#3498db\">اینجا</span></a> </span>کلیک کنید.</span></span></strong></p>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:rgb(255, 140, 0)\"><strong><span style=\"font-size:22px\"><span style=\"font-family:iranyekan\">همتراز کننده ها ( لولینگ ایجنت ها )</span></span></strong></span></h2>\r\n\r\n<div>&nbsp;</div>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:iranyekan\"><strong><span dir=\"LTR\">&nbsp;Leveling Agents</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">همترازی یک پوشش به طور ماکروسکوپی معمولا تاثیری بر روی خواص حفاظتی حفاظتی آن ندارند. پوششها با همترازی و یا جریان پذیری ضعیف همان خواص کاربردی را دارند که پوششها با جریان پذیری قوی ، مانند حفظ براقیت و یا خواص حفاظت<strong> </strong>در مقابل خوردگی که یک رنگ با همترازی خوب از خود نشان می دهد. ظاهر یک پوشش اما به جریان پذیری و همترازی آن پوشش بستگی دارد. وقتی کیفیت سطح کالایی مانند خودرو خوب باشدآن کالا نما ی بهتری دارد. عیوب سطحی که ممکن است تاثیر منفی روی خواص کلی سطوح از نظر همترازی و جریان پذیری بگذارد به شرح ذیل می باشند:</span></span></h2>\r\n\r\n<ul>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">اثر پوست پرتقالی شدن <span dir=\"LTR\"><span style=\"background-color:white\">Orange peel</span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">حفره آتشفشانی <span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:#222222\">Crater</span></span></span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">چشم ماهی <span dir=\"LTR\">Fisheye</span></span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">حساسیت به جریان هوا و مشکلات خیس شدن سطح</span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">باقی ماندن جای قلم</span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">سینه دادن</span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">دانه دانه شدن</span></span></h2>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:right\">\r\n	<h2 style=\"text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">حفره ته سنجاقی <span dir=\"LTR\"><span style=\"background-color:white\">Pinholes</span></span><span style=\"background-color:white\"><span style=\"color:#222222\"> ......</span></span></span></span></h2>\r\n	</li>\r\n</ul>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">همترازی و جریان پذیری فرایندها ی بسیار پیچیده ای هستند که ممکن است تحت تاثیر منفی فاکتور های مختلفی قرار بگیرید.</span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">همترازی را میتوان در فیلم های رنگ به صورت تر یا خشک اندازه گیری کرد. برای اندازه گیری همترازی فیلم تر پوششهای مایع را می توان توسط درجه های همترازی مختلف روی صفحات متضاد رنگی یا سطوح مناسب دیگر به کار برد و به وسیله یک دستگاه <span dir=\"LTR\">flowout</span> آن را تشخیص داد. این نوع اندازه گیری همترازی ، امروزه فقط برای پوششهای تزئینی استفاده می شود.</span></span></h2>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/4KXrH/vt/frame\" style=\"display: block;padding-top: 57%\" width=\"80%\"></iframe></span></span></p>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\">اندازه گیری همترازی پوششهای خشک نسبت به فیلم تر اهمیت بیشتری داردزیرا فرایند و حالت کاربرد (دما ، رطوبت هوا، ضخامت فیلم، رقیق شدن ، اتمیزه شدن و غیره) ممکن است تاثیر بسیار زیادی روی نتیجه نهایی داشته باشد. اندازه گیری بصری همترازی نیز بسیار مهم است ، اما اندازه گیری های نوری توسط عدسی ها &nbsp;تکرار پذیر هستند . همچنین یک روش دیگر برای اندازه گیری همترازی وجود داردکه &nbsp;<span dir=\"LTR\">DOI</span> یا وضوح تصویر نامیده می شود مخفف <span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">Distinctness of Image</span></span></span><span style=\"background-color:white\"><span style=\"color:black\"> می باشد و برای مدت زیادی برای پوشش های خودرویی استفاده شده است. این اندازه گیری براساس تصویر آینه ای از یک پوشش با براقیت بالا انجام می گیرد توسط این دستگاه مقدار تصویر آینه ای که توسط سطح ناهموار پوشش آشفته می شوداندازه گیری می شود.نور پراکنده شده در پوششها با براقیت بالا توسط گونیو فوتومتر </span></span><em><strong><span dir=\"LTR\"><span style=\"background-color:white\">Goniophotometer</span></span></strong></em><span style=\"background-color:white\"> اندازه گیری می شود و اندازه شکلهای آزاد همترازی را به دو امواج ، کوتاه و بلند تقسیم می کند . تصویر های کوچکتر همترازی بهتری دارند.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\"><span style=\"background-color:white\"><span style=\"color:black\">از آنجا که همترازی سطح پوشش نهایی</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\"> (Levelling) </span></span></span><span style=\"background-color:white\"><span style=\"color:black\">شاخص مهمی در خواص ظاهری و فیزیکی آن است نقش همتراز کننده ها جدی میباشد. بدین منظور انواع همتراز کننده های پلیمری، سیلیکونی، فلئوری، و حلال ها برای کاهش کشش سطحی و بهینه نمودن خواص در هنگام اعمال پوشش استفاده میشوند. همتراز شدن پوششهای نیوتونی وابسطه به دما، گرانروی مایع پوششی، کشش سطحی، ضخامت مایع پوششی و نوع همتراز کننده مورد استفاده است. همتراز کننده های سیلیکونی و فلئوری ، قدرت کاهش کشش سطحی زیادی دارند و لیکن کاهش چسبندگی بین لایه ایی، کاهش خواص چسبندگی و تبع آن خواص محافظتی، پوشش دهی مجدد لایه ی بعد، و پایدارسازی حباب و کف از معایب آنهاست. همتراز کننده های حلال، گونه های فرار با کشش سطحی کمینه هستند که درصورت استفاده موجب آلودگی، خشک شدن آهسته سطح و گاها با کاهش گرانروی و مشکلات شره کردن در پوششها میشوند. در صورتی که همتراز کننده های پلیمری اثر زیادی بر کاهش کشش سطحی ندارند، و با ایجاد سطح یکنواخت فیزیکی، اختلافات کشش سطحی در نقاط گوناگون سطح</span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\"> را از بین می برند. این گونه از همتراز کننده ها</span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\"> تنها در صورت استفاده بیش از حد سطح را کمی چسبناک می کنند و هیچ اثر منفی دیگری ندارند</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">.&nbsp;</span></span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-size:18px\"><span style=\"font-family:iranyekan\"><span style=\"background-color:white\"><span style=\"color:#333333\">ارائه شده توسط مهندس میثم سیروس رضائی &ndash; کارشناس ارشد مهندسی رنگ</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\"><span style=\"font-size:18px\">&nbsp;</span></h2>','/app/articles/1535976704189.jpg','/app/articles/1535976706467.jpg','همتراز کننده,basf,byk,efka,akzonobel,افزودنی,رنگ,سیلیکونی,آکریلاتی,قیمت همتراز کننده','همتراز-کننده-ها-در-رنگها',1516,2,1,'2018-09-03 16:41:46','2022-01-11 04:07:56'),(28,3,'مروری بر اندازه گیری جلوه های ظاهری در پوشش های خودرویی','كنترل جلوه ظاهري روكشهاي سـطح خـودرويي بـراي شـركتهـاي معتبـر خودروسـازي جهـان از اهميـت فراوانـي برخـوردار اسـت.','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:#0000FF\"><strong><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">مروری بر اندازه گیری جلوه های ظاهری در پوشش های خودرویی</span></span></strong></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">كنترل جلوه ظاهري روكشهاي سـطح خـودرويي بـراي شـركتهـاي معتبـر خودروسـازي جهـان از اهميـت فراوانـي برخـوردار اسـت. ايـن شركتها بر اين باورند كه آنچه قابل اندازهگيري نيـست، قابـل كنتـرل نيز نميباشد. بر اين اساس دستيابي بـه روشهـا و دسـتگاههـايي كـه توسط آن بتوان جلوه ظاهري روكشهاي سطح خودرويي را با دقـت و صحت بالايي اندازهگيري نمود، به نحوي كه &nbsp;انـدازه گيـريهـا بـا نتـايج ارزيابي چشمي همخواني داشـته باشـد، تبـديل بـه مـسالهاي چـالش برانگيـز در ايـن صـنعت گرديـده اسـت. در حـال حاضـر هـر يـك از شركت هاي خودروسازي شاخصها و استانداردهايي را با حدود رواداري معين تعريف نموده است كه با استفاده از آنها به ارزيابي جلوه ظـاهري محصولات خود ميپردازند. اين شاخصها تركيبي از مهمتـرين صـفات هندسی نظیر براقیت (<span dir=\"LTR\">Gloss</span>)، وضوح تصویر (<span dir=\"LTR\">Distinctness of image (DOI)</span>) و پوسـت پرتقـالي (<span dir=\"LTR\">Orange peel</span>) با وزنهاي متفاوت ميباشد. تعيين حدود رواداري قابل قبول و غيرقابـل قبول براي اين شاخصها توسط مشاهدهكننـدگان و اغلـب بـا در نظـر گرفتن عوامل موثر بر جلوه ظاهري نظير روشنايي، نـوع رنـگ، كـلاس خودرو، افقي و عمودي بودن سطح و قيمت محصول صورت مـي گيـرد . در بررسي جلوه ظاهري روكشهاي سطح خودرويي، مهمترين ويژگيهايي كه اندازهگيري دقيق آنها به منظور تـدوين اسـتانداردهاي ظاهري مطابق با ارزيابي هـاي چـشمي از سـوي خودروسـازان سراسـر جهان مورد توجه است، عبارتند از رنگ، براقيت، وضوح تصوير و پوست پرتقــالي . بــراي انــدازه گيــري رنــگ بــه صــورت متــداول از اسپكتروفوتومترها و گونيواسپكتروفوتومترها استفاده ميشود. در كنـار رنگ، اندازه گيري و كنترل ويژگيهاي هندسـي سـطح نيـز از اهميـت فراواني برخوردار است. در ارزيابي چشمي جلوه ظاهري، مشاهده كننده كليه صفات هندسي سطح را با هم و به صورت همزمان ارزيابي نمـوده و نتيجـه را اعـلام مـينمايـد. در حـالي كـه بـه منظـور انـدازهگيـري دستگاهي، هر يك از اين صفات بـه صـورت جداگانـه توسـط دسـتگاه مربوطه اندازهگيري شده و يك دستگاه به تنهايي قادر به برآورد كامـل جلوه ظاهري سطح نيست. علاوه بـر ايـن، انتظـار مـيرود هـر يـك از ويژگيهاي هندسي سطح سهم متفاوتي در ارزيابي جلوه ظـاهري كـل داشته باشد. از اين رو يافتن عوامل موثر بر ادراك جلوه ظاهري ورابطه ميان آنها به نحوي كه اين رابطه با برآورد بصري افراد از جلوه ظـاهري كل همخواني داشته باشد، يكي از اصليترين دغدغه هاي محققين ايـن حوزه در سالهاي اخير به شمار ميرود .</span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">براقيت يكـي از مهـمتـرين صـفات هندسـي يـك روكـش سـطح خودرويي ميباشد كه منشا آن انعكاس نور از سطح در زاويـه انعكـاس آيينه اي است. براي اندازه گيري براقيت يـك روكـش سـطح خـودرويي عمدتا از دستگاه براقيت سنج (<span dir=\"LTR\">Gloss meter</span>) استفاده ميگردد. وضوح تـصوير يكـي از &nbsp;جنبه هاي براقيت به شمار ميرود و به عنوان ميزان واضح بودن تـصوير تشكيل شده از يك شيء روي سـطح تعريـف مـي گـردد و در ارزيـابي جلوه ظاهري روكشهاي سطح خودرويي كه براقيـت بـالايي دارنـد، از اهميت شاياني برخوردار است. اين ويژگي هندسي روكشهـاي سـطح خودرويي &nbsp;با دستگاه های موج سنج (<span dir=\"LTR\">Wave scan</span>) و گونيوفوتومتر(<span dir=\"LTR\">Goniophotometer</span>) &nbsp;با دو روش مختلف &nbsp;اندازه گيري ميگردد .نايكنواختي هاي سطحي و موج يبودن روكش سطح خودرويي كه تحت عنوان پوست پرتقـالي شـناخته مـي شـود، از عوامل موثر بر جلوه ظاهري خودرو ميباشد. در حال حاضر بـه منظـور اندا زهگيري ميـزان پوسـت پرتقـالي روكـشهـاي سـطح خـودرويي از دستگاه موج سنج استفاده ميگردد. اين دستگاه پروفايـلهـاي اپتيكـي سطح را نقطه به نقطه در فواصل 0.027 سانتيمتـري ضـبط نمـوده و براي مشابه سازي با قدرت تفكيـك چـشم انـسان در فواصـل مختلـف، مقدار سيگنالها با استفاده از توابع فيلتر رياضـي در چنـدين محـدوده طول موجي مختلف از 0.1 تا 30 ميليمتر به صـورت ميـانگين دامنـه موجها تحت عنوان &quot;ساختارهاي سطح&quot; گزارش ميگـردد. هـر يـك از ساختارهاي سطح <span dir=\"LTR\">(Dullness,Wa,Wb,Wc,Wd,We)</span> در مقیاس های 0 تا 100 &nbsp;گزارش ميگردند. ساختارهايي با اندازه 10 تـا 30 ميلـيمتـر در فاصله 3 متري قابل مشاهده هستند و تحت عنوان طول موجهاي بلند &nbsp;<span dir=\"LTR\">LW</span> یا <span dir=\"LTR\">Long wave</span> شناخته ميشوند و ساختارهاي كوچك در محـدوده 0.1 تا 1 ميليمتر تنها در فواصل خيلـي نزديـك قابـل مـشاهده هـستند و تحت عنوان طول موجهـاي كوتـاه سـطح <span dir=\"LTR\">SW </span>&nbsp;یا <span dir=\"LTR\">Short wave</span> شـناخته مـيشـوند. همچنين اين دستگاه مقدارهاي<span dir=\"LTR\"> LW </span>و<span dir=\"LTR\"> SW </span>را نيز گزارش مـيكنـد .نتايج تحقيقات اخير نشان داده است كه از ميان اين عوامـل، <span dir=\"LTR\">Wd </span>و<span dir=\"LTR\"> LW </span>رابطه خوبي با نتايج حاصل از ارزيابي چـشمي پوسـت پرتقـالي دارند .در تحقيقات انجام گرفتـه بـر روي سـطوح عمـودي و افقي مدلهاي مختلف خودرو با رنگ مشكي متاليك، مشخص گرديده كه سطوحي كه در طيـف سـاختاري آنهـا مقـدار<span dir=\"LTR\"> Wb </span>بيـشتر از 25 و مقدار<span dir=\"LTR\"> Wd </span>بيشتر از 13 اسـت، جلـوه ظـاهري نامناسـبي دارنـد .همانگونه كـه اشـاره شـد، اسـتانداردها و دسـتگاه هـاي انـدازه گيـري ويژگيهاي ظاهري همواره از سوي محققين اين حوزه در حـال ارتقـاء مــيباشــد و هريــك از شــركتهــاي خودروســازي شــاخصهــا و استانداردهايي را با حدود رواداري معين تعريف نموده و بـا اسـتفاده از آنها ارزيابي جلوه ظاهري محصولات خود را انجام ميدهند كه در اغلب اين استانداردها تمايل به بالابودن براقيت و وضوح تصوير و پايين بودن ميزان پوست پرتقالي به چشم ميخورد. بـه عنـوان نمونـه در شـركت خوذرو سازی فورد يك شاخص تركيبي بـا وزنهـاي متفـاوتي از سـه عامل درخشندگي <span dir=\"LTR\">Luster</span> بـه عنـوان &nbsp;معياري ازبراقیت ، وضوح <span dir=\"LTR\">Sharpness</span> به عنوان معیاری از وضوح تصوير و پوست پرتقالي بـراي ارزيـابي جلـوه ظـاهري از &nbsp;تعريف شده است. همچنين شركت خودروسـازي دايملـر كرايـسلر شاخص ديگري كه از تركيب سه عامل براقيت، وضوح تصوير و پوسـت پرتقالي به دست آمده است، استفاده مينمايد .</span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><span style=\"background-color:white\"><span style=\"color:#333333\">ارائه شده توسط مهندس میثم سیروس رضائی &ndash; کارشناس ارشد مهندسی رنگ</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&nbsp;</span></span></h2>','/app/articles/1535979943289.jpg','/app/articles/1535979944423.jpg','فیزیک رنگ,افزودنی,CAB,پوست پرتقالی,byk,ظاهر اشیا,جلوه ویژه,متالیک,رنگ خودرو','مروری-بر-اندازه-گیری-جلوه-های-ظاهری-در-پوشش-های-خودرویی',868,3,1,'2018-09-03 17:35:44','2022-01-10 17:38:09'),(29,4,'خواص فیزیکی پیگمنت ها','در مقاله زیر به برخی از خواص فیزکی مهم و کاربردی پیگمنت ها پرداخته می شود.','<h2 dir=\"RTL\" style=\"text-align:center\"><span style=\"font-size:22px\"><strong>جهت مشاهده لیست قیمت و خرید پیگمنت ها<a href=\"https://www.amazontele.com/search?category[0]=3&amp;status=1\"><span style=\"color:#990099\"><span style=\"font-size:24px\"> اینجا </span></span></a>کلیک کنید</strong></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"text-align:center\"><strong><span style=\"font-size:22px\">مقالات مرتبط :<span style=\"color:#00FF00\"> </span><a href=\"https://www.amazontele.com/article/%D9%BE%DB%8C%DA%AF%D9%85%D9%86%D8%AA-%D9%87%D8%A7%DB%8C-%D8%A2%D9%84%DB%8C-%D9%88-%D9%85%D8%B9%D8%AF%D9%86%DB%8C-%D9%88-%D9%85%D8%B3%D8%AA%D8%B1%D8%A8%DA%86\"><span style=\"color:#6633ff\">1- پیگمنت های آلی و معدنی و مستربچ</span></a></span></strong></h2>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><a href=\"https://www.amazontele.com/article/%D8%B1%D9%86%DA%AF%D8%AF%D8%A7%D9%86%D9%87-%D9%87%D8%A7-%DB%8C%D8%A7-%D9%BE%DB%8C%DA%AF%D9%85%D9%86%D8%AA-%D9%87%D8%A7\"><span style=\"color:#6633ff\"><strong><span style=\"font-size:22px\">2- رنگدانه ها یا پیگمنت ها</span></strong></span></a></p>\r\n\r\n<p dir=\"RTL\" style=\"text-align:center\"><a href=\"https://www.amazontele.com/article/%D8%B1%D9%86%DA%AF%D8%B1%D8%B2%DB%8C-%D8%A8%D8%A7-%D9%BE%DB%8C%DA%AF%D9%85%D9%86%D8%AA-Pigment-Dyeing\"><span style=\"color:#6633ff\"><strong><span style=\"font-size:22px\">3- رنگرزی با پیگمنت</span></strong></span></a></p>\r\n\r\n<h2 dir=\"RTL\" style=\"text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/GoMzv/vt/frame\" width=\"80%\"></iframe></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:#f39c12\"><strong>در این ویدئو&nbsp; انواع پیگمنتهای موجود در سایت آمازون تله معرفی شده است</strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"text-align:justify\"><span style=\"color:#800080\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\"><strong>ضریب شکست</strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ضریب شکست یک جسم مثل یک پیگمنت از لحاظ علمی عباتست از نسبت سرعت نور در هوا به سرعت نور در همان جسم ضریب شکست</span> <span style=\"color:black\">در جدول ذیل به ضریب شکست چند جسم اشاره شده است</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><span style=\"color:black\">شعاعهای نورانی ممکن است بر اثر برخورد به یک سطح تجزیه، جذب، منعکس، و یا منکسر شوند بطوریکه ضریب شکست پیگمنت سفید دی اکسید تیتان (۷۱/۲-۵۵/۲) بزرگتر از ضریب شکست بایندر یا تشکیل دهنده فیلمی است که در آن قرار دارد (۶۰/۱-۴۰/۱)، اکستندرها که اکثراً بصورت توده ای ترانسپارنت میباشند بصورت پودری سفید رنگ بوده و پوششی در رنگ ایجاد نمیکنند زیرا ضریب شکست آنان چندان فرقی با محیطی که در آن پخش میشوند ندارد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<div id=\"15458269782296584\" style=\"text-align: justify;\">&nbsp;</div>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">بنابراین هرچه ضریب شکست یک پیگمنت بیشتر باشد قدرت پوشش آن نیز بیشتر خواهد بود و به عکس. مثلا در میان پیگمنتهای سفید، دی اکسید تیتانیم ضریب شکست بزرگتری از سایر دیگر پیگمنتها سفید داشته و از اینرو قدرت پوشش بیشتری نیز دارد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">▪ </span></span><strong><span style=\"color:red\">اندازه ذرات</span><span dir=\"LTR\"><span style=\"color:red\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">پیگمنتها ممکن است بطریق معدنی یا طبیعی و شیمیائی یا مصنوعی تهیه شوند که اندازه ذرات آنان بر خواص رنگ و فیلم نهائی حاصل از آنان اثرات ذیل را میگذارد</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ بر قدرت پوشانندگی</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ بر قدرت رنگدهندگی</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ بر براقیت فیلم حاصل</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">(</span></span><span style=\"color:black\">ماگزیمم قطر یک ذره جهت ماگزیمم ضریب شکست و در نتیجه بیشترین براقیت میبایستی نصف طول موج نور در هوا یعنی حدود ۲/۰ الی ۴/۰ میکرون باشند</span><span dir=\"LTR\"><span style=\"color:black\">.)</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ بر سرعت ته نشینی</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ بر ویسکوزیته رنگ از نقطه نظر قدرت جذب روغن ذرات</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ فلودینگ و فلوتینگ</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">اندازه ذرات عموماً از میکرون (کربن سیاه) تا تقریباً ۵۰ میکرون مثل بعضی از اکستندرها متغیر است و هیچ پیگمنتی وجود ندارد که اندازه تمامی ذرات آن یکسان و مساوی باشد بلکه در عوض اندازه ارائه شده توسط کارخانه سازنده میانگینی است از مجموعه اندازه های موجود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">قدرت جذب روغن نیز تابعی است از اندازه ذرات پیگمنت زیرا که در یک وزن ثابت هرچه اندازه ذرات ریزتر باشند سطح قابل تماس بیشتر و در نتیجه مقدار جذب روغن توسط آنان افزایش مییابد</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">▪ </span></span><strong><span style=\"color:red\">شکل ذرات</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">همانطوریکه قبلا نیز اشاره شد پودرها یا طبیعی هستند و یا مصنوعی که نوع طبیعی از معادن بدست میآید و از این دو شکل این ذرات بصورت منظم نمیباشد و اما در عوض پودرهای مصنوعی بعلت دقت و کنترلی که در مراحل مختلف واکنشهای شیمیائی ساخت آنان میآید معمولا دارای خواص شیمیائی یکسان و شکلهای منظمتر و اندازه های مرتب تری از نوع معدنی هستند که ممکن است دارای شکل ظاهری کروی، مکعبی، گره ای یا قلنبه ای، سوزنی و صفحه ای یا ورقه ای باشند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">از آنجائیکه فرم ذرات در پخش آنان موثر است از اینرو در قدرت پوشانندگی آنان نیز اثر میگذراد. مثلا نوع سوزنی شکل ممکن است که بر فیلم فشار وارد آورده و بصورت دانه های نوک تیز از آن بیرون بزند که از اینرو ممکن است براقیت آنرا کاهش ودر عوض چسبندگی خوبی با رنگ رویه ایجاد نماید و لذا بهتر است که از این فرم ذرات در ساخت آستریها بیشتر استفاده گردد. ظاهر براق و نفوذ ناپذیری رنگهای آلومینیومی نوع لیفینگ یا &laquo;هم پوشش&raquo; نیز بستگی به اتصال گوشه ذرات صفحه ای شکل پیگمنت های آلومینیومی دارد. میکانیز دارای چنین شکلی است و از اینرو خاصیت نفوذ ناپذیری خوبی در قبال آب دارد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">▪<strong> </strong></span></span><strong><span style=\"color:red\">قدرت جذب روغن</span><span dir=\"LTR\"><span style=\"color:red\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ذرات یک پیگمنت زمانیکه در مایع حل کننده یا بایندری قرار میگیرند و توسط میکسری پخش میشوند مقداری از بایندر را بدور خود جذب مینمایند بطوریکه در حالت اختلاط خوب قشری از مایع مزبور دور هر ذره را احاطه مینماید . حالت ایده آل پخش موقعی بدست میآید که بایندر قدرت مرطوب کنندگی و پیگمنت خصلت مرطوب پذیری عالی ای داشته باشند. خاصیت ذرات پودر در جذب بایندر به اطراف خود متفاوت بوده و بایندرها نیز در خاصیت ایجاد قشر بدور ذرات با هم متفاوت میباشند بنابراین، مینیمم مقدار رزین لازم جهت مرطوب نمودن یک سطح معینی از ذرات پیگمنت از برای هر پیگمنت متفاوت بوده و تابعی از نوع رزین، طبیعت سطح پیگمنت، مقدار کار لازم، فشار وارد جهت اجرای این امر، و زمان لازم جهت میکسر میباشد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">روش استاندارد جهت تعیین قدرت جذب یک پیگمنت بدین ترتیب است که به ۱۰۰ گرم از آن به اندازه ای از زوغن بذرک بصورت قطره قطره و با حالت میکس با فشار زیاد اضافه مینمایند که تا مخلوط بصورت خمیر درآید. در این صورت مقدار روغن اضافه شده برحسب گرم را قدرت جذب روغن آن پیگمنت گویند. هرچه قدرت جذب روغن پودری بیشتر باشد اثر آن پودر در یکنواخت تر نمودن رنگ بیشتر خواهد بود و قدرت جذب روغن با ویسکوزیته نسبت مستقیم دارد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">▪ </span></span><strong><span style=\"color:red\">براقیت</span><span dir=\"LTR\"><span style=\"color:red\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">جهت شناخت بهتر مکانیزم فیلم یک رنگ ابتدا بهتر است که مختصراً یادآوری شود که نور یک نوع انرژی بوده و نوع قابل دید و یا سفید آن جزء خیلی کوچک یک طیف الکترومغناطیسی است که ارزانترین منبع تولیدی آن خورشید میباشد. نور و گرما هر دو به یک طریق تولید میگردند و اختلاف آنان فقط در مقدار انرژیهای آنان است. تابش یک نور بر سطحی، ممکن است که توسط آن سطح جذب، منعکس، منکسر و یا ترکیبی از آنان باشد. و این انعکاس نور تابش بر سطح فیلم یک رنگ است که بر براقیت آن اثر مستقیمی می گذارد بدین صورت که هر چه انعکاس نور بیشتر باشد براقیت آن فیلم نیز بیشتر است و بالعکس و یا بعبارت ساده تر براقیت یک فیلم وقتی ماگزیمم است که زاویه تابش برابر با زاویه انعکاس باشد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">علت اینکه چرا اگر انعکاس نور از سطح یک فیلم ماگزیمم باشد براقیت آن فیلم نیز ماگزیمم است اینست که انعکاس کامل نور تابش بر جسمی، تمامی زوایای آن جسم را بر چشم منعکس مینماید و از اینرو جسم کاملا براق به نظر میرسد. و اگر جسمی ناصاف باشد همانند فیلم حاصل از رنگی که پیگمنت بکار رفته در ساخت آن کاملا پخش نشده باشد مقداری از شعاعهای انعکاس را منکسر و از اینرو تمامی نور تابش شده به چشم نرسیده و لذا براقیت فیلم کاهش مییابد. انعکاس کامل نور تابع ضریب شکست، اندازه ذرات، فرم ذرات و درجه پخش پیگمنت بکار رفته در ساخت رنگ فیمل حاصل از آن و همچنین خشک شدن کامل فیلم و زاویه تابش خود نور میباشد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span dir=\"LTR\"><span style=\"color:black\">▪ </span></span><span style=\"color:red\">قدرت پوشانندگی</span><span dir=\"LTR\"><span style=\"color:red\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">میزان مخفی نگهداشتن سطحی توسط پوشش با یک لایه از رنگ را قدرت پوشش آن رنگ گویند. جهت پوشش یک سطح عموماً یک لایه از رنگ کافی است و اگر به لایه های بیشتری نیاز باشد نبایستی ضخامت آن بیشتر از حدی باشد که عموماً جهت تشکیل یک فیلم صاف و دلپذیر مورد نیاز است. قدرت پوشانندگی تابعی است از ضریب انکسار و اندازه و فرم ذرات پیگمنت در بایندر که هر چه ذرات ریزتر باشند تعداد آنان در واحد حجمی بیشتر و در نتیجه قدرت پوشش بیشتر میگردد و همچنین هرچه ضریب شکست پودر بیشتر باشد قدرت پوشانندگی آن نیز بیشتر خواهد بود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">قدرت پوشش یک رنگ عبارتست از متر مربع از سطحی که با یک لیتر از رنگ به ضخامت کافی پوشانیده گردد و قدرت پوشش یک پیگمنت متر مربع از سطحی است که توسط یک کیلو گرم از پیگمنت که در رنگ پخش شده است پوشانیده گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">البته توجه داشته باشید بدین صورت نیست که هر چه از درصد پیگمنت بیشتری در ساخت رنگی استفاده نمائید پوشش آن بهتر است بلکه بعکس مقدار قابل استفاده دارای حدی است و جهت بهتر شدن آن به دیاگرام ذیل توجه نمائید</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">به عنوان مثال پیگمنت سفید دی اکسید تیتانیم موقعی ماگزیمم پوشش را ایجاد مینماید که غلظت حجمی پیگمنت آن</span><span dir=\"LTR\"><span style=\"color:black\"> (PVC) </span></span><span style=\"color:black\">چیزی حدود ۱۰% باشد و قدرت پوشش یک پیگمنت موقعی ماگزیمم است که قطر ذرات آن حدود نصف طول موج اشعه نور باشد که بر فیلم حاصل از آن میتابد. و بطور خلاصه درجه حائل پیگمنتها نسبت به نور بستگی به شرایط ذیل دارد</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ تفاوت ضریب انکسار پیگمنت و محیطی که در آن پخش میشود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ اندازه و فرم ذرات</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ـ فاصله ذرات پیگمنت در حال تعلیق</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span dir=\"LTR\"><span style=\"color:black\">▪ </span></span><span style=\"color:#FF0000\">درجه سهولت مرطوب پذیری و پخش شوندگی<span dir=\"LTR\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در اینمورد باید حالت بهم پیوستگی یا تجمعی پیگمنتها را که ناشی از اثر نیروهای بین مولکولی و یا نیروهای جاذب موجود بین سایر موارد رنگ میباشد خاتمه داده و از بین برد. در این امر سه عامل رل اساسی را ایفا مینمایند که یکی خصلت مرطوب پذیری خود پیگمنت و دیگری خصلت مرطوب کنندگی بایندر یا رزینی که پیگمنت در آن پخش میشود و آخری کار لازم جهت تحقق بخشیدن به این امر است که توسط دستگاههائی از قبیل میکس، پرمیل، سند میل، بال میل، داینومیل و غیره انجام میگیرد. توجه داشته باشید که این دستگاهها باعث جداسازی تجمعی پیگمنتها ازهم و پخش آنان در رزین میگردند نه اینک ساختمان مولکولی آنان را بشکنند. شرح مختصری از هر یک از آسیابهای فوق الذکر در پایان همین فصل آمده است. سطح رنگدانه ها نسبت به مایعات بسیار حساس میباشد بطوریکه بعضی آبدوست یا هیدروفیلیک</span><span dir=\"LTR\"><span style=\"color:black\"> (Hydrophilic) </span></span><span style=\"color:black\">بوده که بسهولت با آب مرطوب میشوند تا مایعات آلی، بعضی دیگر آبدوست نبوده و بسهولت با مایعات آلی مرطوب مشوند تا آب به آنها هیدروفوبیک</span><span dir=\"LTR\"><span style=\"color:black\"> (Hydrophilic) </span></span><span style=\"color:black\">گویند. بهترین حالت پخش رنگدانه ها حالتی است که هوای موجود فی مابین ذرات آنان کاملاً با حمل کننده ای پر گردد و تا عمل پخش رنگدانه در حمل کننده تسریع گردد. پخش خوب پیگمنتها تاثیر بسیار زیادی بر براقیت، فام، قدرت پوشانندگی، روانی، سرعت ته نشین شدن و سایر خواص مقاومتی دیرگ رنگ دارد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">یکی از مقاصد مهم بکار گرفتن پیگمنتها در ساخت یک رنگ بوجود آوردن فام یا رنگهای دلخواه است. اصولاً لازم است رنگ را به صورت علمی تعریف نموده تا بتوان به خاصیت فوق بیشتر و بهتر پی برد. رنگها اشعه های نورانی ای هستند که بعد از عبور از عدسیهای چشم و برخورد به نقطه زرد یا مرکز اعصاب دریافتی چشم حس میشوند و یا به بیان ساده تر دیده میشوند. این نور سفید که از خورشید و یا یک منبع نورانی دیگری تابش میشود متشکل از رنگهای مختلفی است که در اثر ترکیب با یکدیگر تشکیل نور سفید یا نور کامل را داده اند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">همین نور در اثر برخورد با یک محیط شفاف (منشور) بنورهای قرمز، نارنجی، زرد، سبز، آبی و بنفش (همانند قوس و قزح) تجزیه میگردند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">طول موج رنگ بنفش برابر است با ۴۶۵-۴۰۰ میکرون</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">طول موج رنگ آبی برابر است با ۵۱۰-۴۶۵ میکرون</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">طول موج رنگ سبز برابر است با ۵۸۰ -۵۱۰ میکرون</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">طول موج رنگ زرد برابر است با ۵۹۰-۵۸۰ میکرون</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">طول موج رنگ نارنجی برابر است با ۶۲۰-۵۹۰ میکرون</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">طول موج رنگ قرمز برابر است با ۷۰۰-۶۲۰ میکرون</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">رنگهای فوق را رنگهای اصلی مینامند که ترکیب آنها با یکدیگر رنگهای متنوع و متعددی را که در طبیعت دیده میشوند بوجود میآورند. دلیل علمی دیدن اشیاء بصورت رنگی بدین ترتیب است که وقتی شیئی در معرض نور سفید قرار میگیرد قسمتی از رنگهای نور سفید را جذب و قسمتی را منعکس مینماید، لذا فیمل برنگ شعاعهائی دیده میشود که منعکس شده اند. وقتیکه نوری به یک سطحی برخورد مینماید ممکنست کاملاً از سطح عبور نماید، منعکس گردد، منکسر شود جذب و یا پخش گردد</span><span dir=\"LTR\"><span style=\"color:black\"> .</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span dir=\"LTR\"><span style=\"color:black\">▪</span><span style=\"color:#FF0000\"> </span></span><span style=\"color:#FF0000\">قدرت رنگ دهندگی<span dir=\"LTR\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در ساخت اکثر رنگهای رنگی پیگمنت سفید نیز بکار رفته که جهت تبدیل آنان به فام رنگی دلخواه از خمیرهای پیگمنتی که اصطلاحاً به آنها پیست میگویند (توسط عمل تینت نمودن و یا استفاده از پیگمنتهای رنگی بطور مستقیم) استفاده مینمایند. اگر به مقدار زیادی از یک پیست پیگمنت رنگی، جهت رساندن یک رنگ سفید به فام دلخواه نیاز باشد اصطلاحاً میگویند که قدرت رنگدهندگی آن پیگمنت رنگی کم است. قدرت رنگدهندگی یک پیگمنت تناسبی با قدرت پوشش ندارد و نسبتاً پیگمنتهائیکه از قدرت پوشش کمتری برخوردارند قدرت رنگدهندگی بیشتری دارند همانند پیگمنتهای رنگی آلی ترانسپارنت</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span dir=\"LTR\">▪<span style=\"color:red\"> </span></span><span style=\"color:red\">وزن مخصوص</span><span dir=\"LTR\"><span style=\"color:red\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">وزن حجمی یک پودر که عبارتست از وزن یک گالن از آن پودر بر حسب کیلوگرم یا پاند بر گالن را وزن مخصوص آن پودر گویند که وزن مخصوص پودرها با هم متفاوت بوده و این تفاوت میتواند بمقدار بسیار زیادی باشد. اصولاً پودرها بصورت وزنی خریداری میشوند و در حالیکه رنگ حاصل از آنان بصورت حجمی فروخته میشود و بدین ترتیب جهت محاسبه قدرت تمام شده یک رنگ لازم است که حتماً وزن مخصوص پودرها معلوم و مشخص باشد. دانستن وزن مخصوص که علاوه بر محاسبه قدرت در موارد متعدد دیگری هم مورد استفاده قرار میگیرد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span dir=\"LTR\"><span style=\"color:black\">▪ </span></span><span style=\"color:red\">وزن مخصوص ظاهری</span><span dir=\"LTR\"><span style=\"color:red\">:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">وزن مخصوص ظاهی یک پودر عبارتست از تعداد گالنی که توسط ۱۰۰ پاند از پیگمنتی و یا تعداد لیتری که توسط ۹۸۴/۱۱ کیلوگرم از آن پیگمنت اشغال میگردد. آگاهی از وزن مخصوص ظاهری امری است لازم و ضروری زیرا که دو پیگمنت ممکن است بر حسب وزنی دارای قیمت یکسانی باشند اما آن پیگمنتی که وزن مخصوص ظاهری بیشتری دارد، بوضوح حجم بیشتری از رنگ را تولید خواهد نمود و در نتیجه (از آنجائیکه رنگها بصورت حجمی فروخته میشوند تا وزنی) مقورن به صرفه تر خواهد بود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</h2>','/app/articles/1536128515283.jpg','/app/articles/1536128516848.jpg','پیگمنت,رنگدانه,دیسپرس کننده,جذب روغن,پشت پوشی,پوشرنگ,پیگمنت های رنگی','خواص-فیزیکی-پیگمنت-ها',1879,2,1,'2018-09-05 10:51:56','2022-01-10 13:34:28'),(30,1,'مات کننده چیست؟','امروزه انواع بسیار ریز سیلیکاها یا دی اکسید سیلیکون به عنوان یک ماده مات کننده عمومی مورد قبول قرار گرفته اند.','<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><a href=\"https://www.amazontele.com/product/%D9%85%D8%A7%D8%AA-%DA%A9%D9%86%D9%86%D8%AF%D9%87-%D8%A8%D8%B1-%D9%BE%D8%A7%DB%8C%D9%87-%D8%B3%DB%8C%D9%84%DB%8C%DA%A9%D8%A7%DB%8C-%D8%B1%D8%B3%D9%88%D8%A8%DB%8C\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/اینجا کلیک کنید.png\" style=\"height:112px; width:250px\" /></a></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#FF8C00\">مات کننده چیست؟</span></span></strong></span></h2>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#FF8C00\">جهت خرید مات کن OK412 با ما در ارتباط باشید</span></span></strong></span></p>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">براقیت را باید به عنوان خصوصیتی از یک سطح دانست که نور را همانند یک آینه منعکس می کند. با توجه به این تعریف، منظور از حفظ براقیت توانایی فیلم رنگ برای نگهداری براقیت اولیه می باشد. در نتیجه، اگر رنگی براقیت خود را به مدت نامحدودی حفظ کند می گویند قدرت حفظ برق عالی دارد و اگر برق خود را بسرعت از دست بدهد می گویند قدرت حفظ برق آن ضعیف است</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">.&nbsp;</span></span></span><br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">دو عامل مهم در براقیت فیلم رنگ، نوع رنگپایه و رنگدانه مصرفی در آن می باشد. اما، برای کنترل برق فیلم رنگ از مواد افزودنی خاصی نیز استفاده می شود که بعضی از آنها موجب کاهش برق (مواد مات کننده) و بعضی دیگر موجب افزایش برق می گردند</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">.&nbsp;</span></span></span><br />\r\n<span style=\"background-color:white\"><span style=\"color:black\">امروزه انواع بسیار ریز سیلیکاها</span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">یا <span style=\"background-color:white\"><span style=\"color:black\">دی اکسید سیلیکون</span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">به عنوان یک ماده مات کننده عمومی مورد قبول قرار گرفته اند، اما بعضی از انواع آنها که شدیداً اسیدی هستند برای استفاده در لاکهای وینیلی یا پوششهای اوره- آلکید کاتالیز شده با اسید مناسب نیستند، زیرا بر روی پایداری سیستم اثر می گذارند</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">.&nbsp;</span></span></span><span style=\"background-color:white\"><span style=\"color:black\">استئارات روی</span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">نیز از جمله مواد مات کننده مصرفی در صنایع</span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">رنگسازی</span></span>&nbsp;<span style=\"background-color:white\"><span style=\"color:black\">است. استئارات کلسیم یک ماده کننده خوب برای رنگها، روغن های جلا و لاکها، به خصوص برای مواردی که گرانروی پایین مورد نظر است می باشد</span></span><span dir=\"LTR\"><span style=\"background-color:white\"><span style=\"color:black\">.</span></span></span></span></span></span></span></h2>\r\n\r\n<p dir=\"RTL\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">شرکت اوونیک آلمان بزرگترین تولید کننده مات کننده تحت برند&nbsp;<span style=\"color:rgb(33, 37, 41)\">ACEMATT&reg; OK 412 می باشد.</span></span></span></p>','/app/articles/1536215908486.jpg','/app/articles/1536215908844.jpg','مات کننده,زینک استئارات,پوشش ,افزودنی,OK 412,مات کن,رنگ مات,دگوسا','مات-کننده-چیست',2547,2,1,'2018-09-06 11:08:28','2022-01-11 11:57:53'),(31,2,'رزین سیلیکونی چیست؟','رزین های سیلیکونی از اتم های سیلیسیم و اکسیژن تشکیل شده اند','<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: center;\"><a href=\"https://www.amazontele.com/product/%D8%B1%D8%B2%DB%8C%D9%86-%D8%B3%DB%8C%D9%84%DB%8C%DA%A9%D9%88%D9%86%DB%8C-%D9%85%D9%82%D8%A7%D9%88%D9%85-%D8%A8%D9%87-%D8%AD%D8%B1%D8%A7%D8%B1%D8%A7%D8%AA\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/2/اینجا کلیک کنید.png\" style=\"height:112px; width:250px\" /></a></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:red\">رزین سیلیکونی<strong> </strong>چیست؟</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">رزین های سیلیکونی از اتم های سیلیسیم و اکسیژن تشکیل شده اند که همین ساختمان مقاومت بیشتر آن ها در برابر گرما را سبب می گردد. این رزین ها پایه ی معدنی دارند و کربن و نیتروژن و هیدروژن را می توان به ساختار آن ها افزود<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">ساختار اصلی رزین با پیوند اتم سیلیس و اکسیژن با یکدیگر رشد می کند و بنیان های آلی اضافه شونده همانند آلکیل و بنیان آریل اغلب به سیلیسیم اتصال می یابند. ترکیبات سیلیکونی در سه نوع گوناگون ساخته می شوند<span dir=\"LTR\">:</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\">1</span>- روغن های سیلیکونی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">2- سیلیکون کلروکائوچو</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">3- رزین های سیلیکونی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">رزین های سیلیکونی را پلی سیلوکسان هم می نامند. ترکیبات هالوژن دار هیدروکربورهای اشباع شده در دمای بالا مستقیماً با سیلیسیم ترکیب می شوند و آنچه به دست می آید مونومری به نام سیلان است<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">وجود سیلیس در این رزین ها سبب می گردد که در برابر مواد شیمیایی و گرمازا مقاومت بسیاری از خود نشان دهند. از سوی دیگر وجود ترکیبات آلی در این رزین ها باعث می شود تا میزان فعالیت شیمیایی خاصیت انحلال پذیری و نرمی این گونه ترکیبات افزایش یابد. هرچه سهم ترکیبات آلی در این رزین بیشتر باشد طبیعت آن به سوی ترکیبات آلی گرایش خواهد یافت<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">رزین های سیلیکونی معمولاً به حالت محلول عرضه می گردند زیرا بافت مولکولی ویژه و متراکم آن ها در صورت عرضه این رزین به حالت صددرصد کاربردشان را دشوار می سازد. معمولاً رزین های سیلیکونی با درصد جامد 50 تا 80 درصد حمل می شوند. وزن مولکولی آن ها حدود 2000 تا 5000 است و در 200 تا 250 درجه سانتیگراد پخت می گردند. چنانچه بخواهیم آن را در دمای اتاق خشک کنیم می بایست از خشک کن های فلزی (روی یا منگنز یا کبالت) استفاده نماییم. این رزین ها چسبندگی خوبی به آلومینیوم و فولاد دارند و در حلال های قطبی مانند متیل الکل های سبک به سختی اما در کتون ها و حلال های آروماتیک به خوبی حل می شوند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">برای رقیق کردن بهتر است از مخلوط چند حلال (برای مثال تولوئن یا زایلن یا سیکلوهگزانون تولوئن یا زایلن با اتیل یا بوتیل استات زایلن با بوتانل) استفاده نمود<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">کاربرد رزین های سیلیکونی<span dir=\"LTR\">:</span></span></span></span></strong></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">رزین های سیلیکونی در رنگ هایی به کار می روند که برای آن ها مقاومت در برابر گرما نیاز باشد. البته این رزین ها قیمت بالایی ندارند. رزین های سیلیکونی به گستردگی در صنایع الکتریکی مورد استفاده قرار می گیرند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\"><strong>سازگاری</strong><span dir=\"LTR\">:</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">این گونه رزین ها می توانند همراه با پلی ایزوسیانات ها در دمای اتاق پخت شوند و مقاومت خوبی در برابر خوردگی و دما از خود نشان دهند. به هنگام انبارداری نمی بایست با سرب یا ترکیبات سرب تماس یابند. این رزین ها با با رزین های سیلیکونی اصلاح شده سازگارند و نیز با آلکید ملامین اوره و اپوکسی اندکی سازگاری دارند. لازم به توجه است که این گونه رزین ها با روغن بزرک سازگار نیستند<span dir=\"LTR\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\">&nbsp;</h2>','/app/articles/1536853451559.jpg','/app/articles/1536853452973.jpg','رزین حرارتی,رنگ ضد حریق,رزین ren 60,رزین ren 80 ,سیلیکون واکر,رزین سیلیکون,مقاوم به حرارت,wacker,Silres','رزین-سیلیکونی-چیست',4295,2,1,'2018-09-13 20:14:12','2022-01-11 19:58:23'),(32,1,'آشنایی با فرمولاسیون پوشش های پودری','پوشش های پودری، پوشش هایی هستند که تقریباً تمام مواد اولیه آنها را مواد جامد تشکیل می دهند.','<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">آشنایی با فرمولاسیون پوشش های پودری</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">پوشش های پودری، پوشش هایی هستند که تقریباً تمام مواد اولیه آنها را مواد جامد تشکیل می دهند. این پوشش ها پس از مطالعات بسیار در سال 1962 وارد بازار مصرف شدند. با افزایش مصرف و تکامل دانش تولید آنها در سال های بعد، ظرفیت تولید رشد روز افزونی یافت، به نحوی که میزان تولیدآنها در سال 1969 به 1300 تن در سال رسید. علاوه بر مزایای زیست محیطی می توان به خواص عالی در پوشش نهایی لایه رنگ اشاره کرد. یکی از ویژگی های اساسی پوشش های پودری در مقایسه با رنگ های مایع، عدم استفاده از حلال های آلی است. به همین علت است که این نوع پوشش ها فاقد معایبی چون اتلاف مواد اولیه، خطر آتشگیری، افزایش مصرف انرژی، ایجاد پساب صنعتی و موارد دیگر است.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">اجزای یک پوشش پودری</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مواد تشکیل دهنده پوشش های پودری را می توان به شکل زیر دسته بندی کرد:<br />\r\n1)رنگ پایه</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">2)رنگدانه</span>&nbsp;<br />\r\n<span style=\"color:black\">3)پرکننده</span>&nbsp;<br />\r\n<br />\r\n<strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">رنگ پایه:</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">رنگ پایه شامل رزین، سخت کننده ها و مواد افزودنی است.رزین از مواد پایه و اساسی تشکیل دهنده یک پوشش پودری است که باعث تشکیل یک لایه منسجم و پیوسته برای اختلاط مواد و پدید آمدن لایه ای یکنواخت با خواص مطلوب و دلخواه می شود. رزین پوشش های پودری را می توان به دو دسته زیر تقسیم نمود:</span>&nbsp;<br />\r\n<span style=\"color:black\">الف)رزین گرما نرم</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ب)رزین گرما سخت</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">سخت کننده ها یا عوامل پخت موادی هستند که در واکنش با رزین ها در کوره در زمان و دمای مناسب عمل پخت را انجام می دهند. این مواد همچون سایر مواد تشکیل دهنده باید جامد، جریان پذیر و دارای دمای ذوب بالا باشند و طی فرایند آسیاب و دانه بندی ایجاد مزاحمت نکنند.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">رنگدانه ها</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در اثر وجود رنگ دانه ها در مخلوط اولیه خواصی چون ایجاد پوشش، فام و افزایش مقاومت در برابر خوردگی حاصل می شود. رنگدانه ها می توانند سفید، سیاه، یا به رنگ های دیگر باشند. این رنگدانه ها به دو گروه آلی و معدنی تقسیم می شوند.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;<br />\r\n<strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\">پرکننده ها</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">این مواد را می توان به دودسته پر کننده ها و افزایش دهنده های طول زنجیر تقیسم کرد. افزایش مناسب این دسته از مواد، علاوه بر کاهش قیمت تمام شده موجب بهبود برخی از خواص از جمله مقاومت جوی و در بعضی از موارد افزایش پوشش دهی می گردد.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;<br />\r\n<strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\">مواد افزودنی</span></span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مواد افزودنی گروهی از مواد اولیه هستند که برای اصلاح نحوه کاربرد و شکل ظاهری رنگ های پودری به کار می روند. این افزودنی ها ممکن است به صورت زیر دسته بندی شوند:</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">1-عوامل جریان یابی</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Flow Agent</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">2-عوامل گاز دار</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Degassing Agent</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">3-مات کننده ها</span><span dir=\"LTR\"><span style=\"color:black\">Agent Matting</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">4-عوامل بافت دهی (جرمی، چروک، چکشی و ...)</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Texturing Agent</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">5-پایدار کننده های نوری</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Light Stabilizers</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">6-عوامل جریان یابی خشک</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Dry Flow Agent</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">7-کاتالیزورها</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Catalysts</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">8-موم ها</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Waxes</span></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">9-افزودنی های ضد الکتریسیته</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Electrostatic Additives</span></span>&nbsp;</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:black\">مات کننده ها، شکل دهنده های سطح، کاتالیزورها و افزودنی های ضد الکتریسیته ساکن برای گروه دیگری از ترکیبات مناسب اند.</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی مناسب باید جامدی با دمای ذوب یا دمای انتقال شیشه ای بیش از 50 درجه سانتی گراد باشد تا در مقادیر اندک بتواند فعال و موثر باشد. اگر افزودنی مورد استفاده به حالت مایع باشد، باید به شکل</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">Master batch</span></span>&nbsp;<span style=\"color:black\">یا جاذب حامل سیلیکا به کار رود.</span>&nbsp;<br />\r\n<span style=\"color:black\">عوامل جریان یابی عوامل جریان یابی به رنگ های پودری اضافه می شوند تا عیوب و نقص های سطح مانند دهانه آتشفشانی را برطرف کرده و به افزایش همواری و یکنواختی پوشش پودری کمک کنند. خیس شوندگی زیر لایه نیز برای رسیدن به چسبندگی و پیوستگی مطلوب عامل مهمی به شمار می رود.هرچند نقش افزودنی ها کاملاً معلوم نشده است، اما اثر آنها روی کشش سحطی رنگ و یک نواختی مواد روی سطح نیز از عوامل اساسی به شمار می آید.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">به منظور ایجاد بیشترین خیس شوندگی در زمان پخت، هر دو عامل کشش سطحی و زاویه تماس رنگ پودری در فاز باید تا حد امکان کمترین مقدار را داشته باشد. زیر لایه نیز باید عاری از آلودگی های با کشش سطحی کم باشد. چنین آلودگی هایی ممکن است به طور جزئی در پوشش پودری حل شوند و جریانی به سمت نواحی مجاور که کشش سطحی بالاتری دارند، ایجاد کنند. این امر می تواند باعث تشکیل دهانه های آتشفشانی شود. مکانیسم دیگری که باعث این پدیده می شود، اختلاف بین کشش سطحی در سطح پوشش پودری است. این دو اثر با افزایش روان کننده ها به حداقل ممکن می رسد، زیرا این مواد انتقال مکان های نا مناسب به طرف سطح را به حداقل رسانده و باعث یکنواختی کشش سطحی می شوند.افزودن یک ماده مناسب برای به دست آوردن یک کشش سطحی کم به حذف دهانه های آتشفشانی کمک می کند.</span>&nbsp;<br />\r\n<span style=\"color:black\">از طرف دیگر کشش سطحی کم به فرایند پراکندگی رنگدانه ها در طول عملیات روزن رانی (</span><span dir=\"LTR\"><span style=\"color:black\">Extrusion</span></span><span style=\"color:black\">) کمک می کند و ماده ای با گرانروی و کارایی کمتر ارائه می دهد . بنابر این ، در پوشش های پودری باید توازن و تعادلی بین خواص عوامل جریانی در محصول ایجاد شود تا جریانی یکنواخت و روان به وجود آید. همچنین، می توان ار هوپومرها ی بوتیل آکریلیک یا کوپولیمر های 2-اتیل هگزین آکریلیک با وزن ملکولی 5000 تا 100000 نیز استفاده کرد. این مواد به شکل های مختف تجاری در دسترس هستند و معمولاً به شکل مایع 100% گرانرو یا 10-5 %</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">master batch</span></span>&nbsp;<span style=\"color:black\">در رزین پایه یا به همراه یک ماده حامل سیلیکا با میزان فعالیت حدود 60% به کار برده می شوند. معمولاً با مصرف حدود 5/0 % ماده فعال در ترکیب می توان کم شدن ایجاد دانه های آتشفشانی را انتظار داشت ، ولی برای بهبود سطح و یکنواختی لایه رنگ این مقدار می تواند تا 5/1 % افزایش یابد. مصرف بیش از این مقدار باعث ایجاد ضخامت در پوشش رنگ پودری می شود.. برای غلبه بر این مشکل، واکنشگرها به نوعی تکامل یافته اند تا با رزین واکنش دهند.</span>&nbsp;<br />\r\n<span style=\"color:black\"><strong>رزین پلی استر و رزین های پلی استر اصلاح شده با پلی سیکلو هگزان در مقادیر 5/0-1/0 % کشش سطحی کمتری نسبت به پلی اکریلیک ها ایجاد می کنند. شفافیت آنها از شفافیت پلی اکریلیک ها در پوشش های شفاف بیشتر است، اما باید به شکل</strong></span><strong>&nbsp;</strong><strong><span dir=\"LTR\"><span style=\"color:black\">Master batch</span></span></strong><strong>&nbsp;</strong><strong><span style=\"color:black\">به عنوان یک حامل سیلیکا مورد استفاده قرار می گیرند.فلوئوروکربن ها نیز به عنوان یک عامل جریان یابی، هنگامی که به مقدار بسیار کم افزوده شوند، خواص مطلوبی به رنگ می دهند.ولی به دلیل گران بودن آنها، کمتر مورد استفاده قرار می گیرند. این ترکیبات یکی از موثرترین مواد برای پودرهایی است که باید روی سطوح آلوده اعمال شوند.چند ماده گرمانرم با وزن مولکولی زیاد، مثل بوتیرات استات سلولز</span></strong><strong>&nbsp;</strong><strong><span dir=\"LTR\"><span style=\"color:black\">CAB</span></span></strong><strong>&nbsp;<span style=\"color:black\">نیز به عنوان عوامل ضد ایجاد دهانه آتشفشانی مطرح اند.</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong>&nbsp;</strong><br />\r\n<span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\">عوامل گاز زدا</span></strong></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;<br />\r\n<span style=\"color:black\">از بنزوئین در پوشش های پودری پلی استر و پلی استراپوکسی به مقدار 1-2/0 % به عنوان عامل گاز دار و ضد ایجاد سوراخ سوزنی برای ایجاد یکپارچگی در لایه رنگ استفاده می شود.</span>&nbsp;<span style=\"color:black\">اما تاکنون مکانیسم دقیق این فرایند و چگونگی ترکیب شدن این ماده مشخص نشده است . استفاده از این ماده به ویژه در رنگ های روشن به علت ایجاد پدیده زرد شدن باید به حداقل برسد. از مواد دیگری که به عنوان عوامل گاز دار نام برده می شوند عبارت است از:</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">آلومینیوم استئارات، استئاریک اسید، موم پلی پروپیلن، روغن کوچک هیدروژن دار شده و هیدروکسیل آلومینیوم بلوری شده.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#215868\">پایدار کننده های نوری</span>&nbsp;<span style=\"color:black\">استفاده از پایدار کننده های نوری در پوشش های پودری به منظور حفاظت لایه رنگ در برابر اثر مخرب تابش فرابنفش خورشید است. پرتو</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">UV</span></span>&nbsp;<span style=\"color:black\">باعث تشکیل رادیکال های آزاد شده و منجر به تخریب محمل می شود. دو نوع پایدار کننده</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">UV</span></span><span style=\"color:black\">وجود دارند که معمولاً با هم به کار می روند: اولی جاذب پرتو و دومی ممانعت کنده رادیکال های آزاد که به آنها پایدار کننده های نوری آمینی ممانعت کننده نیز می گویند.همچنین یک پوشش پودری ، وقتی که مدت زیادی در شرایط پخت قرار می گیرد برای مقابله با پدیده زرد شدگی، نیاز به یک پایدار کننده نوری دارد.<br />\r\nافزودنی های جریان یابی خشک افزودنی های جریان یابی خشک برای بهبود بخشیدن به نحوه انتقال خصوصیات سیالیت و جریان پودر، در لایه نهایی رنگ به کار می روند. اگر این مواد قبل از آسیاب کردن اضافه شوند، ممکن است باعث آسیاب شدن بهتر پودر شوند. موادی با پایه دی اکسید سیلیکون ، بدون شکل منظم و بسیار ریز، می توانند افزودنی جریان یابی خشک مناسبی برای ایجاد شرایط یاد شده باشند.همچنین ممکن است یک سطح آبگریز نیز به وجود آورند. این مواد بسیار نرم و ریز و با اندازه</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">nm40-10</span></span><span style=\"color:black\">هستند که با تشکیل یک پوشش روی اجزای پودر وارد ترکیب شوند. این مواد باید در کمترین مقدار ممکن که معمولاً حدود 2/0 % است، مورد استفاده قرار گیرند .</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;<span style=\"color:#215868\">کاتالیزور ها</span>&nbsp;<span style=\"color:black\">کاتالیزورها سرعت پخت را افزایش داده و زمان یا دمای پخت را کاهش می دهند. آنها باید طوری انتخاب شوند، که پخت زودرس و نا بهنگام در طول مدت روزن رانی، اتفاق نیفتد. همچنین باید اطمینان حاصل شود که روی ویژگی های جریان یابی و یکنواختی رنگ اثر نگذارد و به پایداری شیمیایی آن در طول مدت نگهداری آسیبی وارد نشود. فناوری های سودمند تجزیه ویسکوالاستیک گرمایی و گرما سنجی پویشی تفاضلی می توانند در ارزیابی کاتالیزورها کمک کنند.</span>&nbsp;<br />\r\n<span style=\"color:#215868\">موم ها</span>&nbsp;<span style=\"color:black\">از موم ها برای اهداف متعددی در پوشش های پودری استفاده می شود.افزایش مقاومت خراشیدگی و سختی، افزایش لغزش، کاهش براقیت، کمک روزن رانی، عامل بافت دهی از جمله ویژگی موم ها است. همچنین از این مواد برای جلوگیری از سوراخ سوزنی شدن ناشی از پف زدایی مواد اولیه متخلخل در کوره پخت استفاده می شود. برای رسیدن به این اهداف ممکن است موم ها با مواد خام اولیه به وسیله فرایند روزن رانی ترکیب شوند یا به صورت مخلوط کردن خشک به مواد پایه اضافه گردند.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#008000\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">1-موم های پلی اتیلن:</span></span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">این موم ها ، محصولات سیر شده با وزن مولکولی 1000تا 3000 و دمای ذوب در محدوده 125-85 درجه سانتی گراد هستند. زمانی که مقدار مصرف آن ها کمتر از 3/0% باشد، ضمن اینکه براقیت سطح تغییر نمی کند، می توان روی سطح پخت شده ، دوباره رنگ اعمال کرد.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"color:#008000\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong>2-موم های پلی پروپیلن:</strong></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">دمای ذوب این موم ها در محدوده 149 تا 150 درجه سانتی گراد است و برای بهبود بخشیدن به سختی رنگ های پودری به کار می رود. ولی این مواد در سیالیت رنگ های پودری ایجاد اختلال می کنند. هرچه قدر دمای مواد بالاتر باشد ، برای کاهش براقیت مطلوب ترند.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#008000\"><strong>3-موم پلی اتیلن بهبود یافته با&nbsp;</strong><strong><span dir=\"LTR\">Poly tetra fluoro ethylene(PTFE</span></strong><strong>)</strong><strong>&nbsp;</strong></span><br />\r\n<span style=\"color:black\">این موم ها مخلوطی از موم های پلی اتیلن و پلی تترافلوئورو اتیلن هستند. موم</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">PTFE</span></span>&nbsp;<span style=\"color:black\">در سامانه اکثر پوشش های پودری وارد می شود. این ترکیب ذوب نمی گردد و تا 320 درجه سانتی گراد نسبت به گرما مقاوم است.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#c00000\">نتیجه گیری :</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">با توجه به محدودیت های موجود در فراورش، دمای پخت، نوع سطح زیر کار و نیز با توجه به تنوع موجود در پوشش های مایع، پوشش های پودری دارای محدودیت های ویژه ای هستند. ولی ، با به کارگیری قوانین محدود کننده زیست محیطی در سال های اخیر شاهد رشد و توسعه در صنعت رنگ های بدون حلال نظیر رنگ های بر پایه آب و همچنین پوشش های پودری بوده ایم. با توجه به عوامل یاد شده ، مواد افزودنی دارای نقش مهمی بوده و توسعه کمی و کیفی این مواد می توانند بازار آینده این صنعت باشند.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\"><a href=\"http://paintshop.persianblog.ir/post/318/\" title=\"Link\"><strong><span style=\"color:#506470\">آیا پوشش های پودری ، پوشش بهینه چوب تلقی می شوند؟</span></strong></a></span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:black\">پوشش های پودری به عنوان جایگزین زیست محیطی پوشش های حلال پایه، مشخصاً با انتشار کمتر ترکیبات آلی فرار و مواد خطرناک آلاینده هوا شناخته می شوند.علاوه بر این، فرایندهای پوشش پودر از مصرف انرژی و تولید پسماند می کاهند. و این در حالی است که این نوع پوشش ها در بعضی بازار ها کلیدی مختص این صنعت مثل چوب، چند سازه های چوبی و پلاستیک ها عمدتاً حضور ندارند.در اوایل کاربرد این نوع فناوری، دمای آستانه پخت عامل اصلی محدود کننده در استفاده از پوشش های پودری برای زیرآیندهای حساس به دما بود. با وجود این در سال های اخیر فناوریهای نوین استفاده از پوشش های پودری برای مثال پوشش های پودری سخت شونده با</span>&nbsp;</strong><strong><span dir=\"LTR\"><span style=\"color:black\">UV</span></span></strong><strong>&nbsp;</strong><strong><span style=\"color:black\">را برای طیف گسترده ای از زیرآیندها امکان پذیر نموده است. ویژگی های سطحی اثر زیادی روی پوشش های پودری پخت شونده با</span></strong><strong>&nbsp;</strong><strong><span dir=\"LTR\"><span style=\"color:black\">UV</span></span></strong><strong>&nbsp;</strong><strong><span style=\"color:black\">دارند و از جمله عوامل تعیین کننده در این فناوری به حساب می آیند.شرکت</span></strong><strong>&nbsp;</strong><strong><span dir=\"LTR\"><span style=\"color:black\">Surface Specialties</span></span></strong><strong>&nbsp;</strong><strong><span style=\"color:black\">رزین هایی را عرضه نموده که آنها را می توان در یک دوره زمانی قابل قبول و در فرمولاسیون پوشش های پودری کم دما پخت با سخت کننده های مناسب در دمای پایین پخت کرد. در این مقاله خواص و کارایی دو سامانه پوشش پودری تجارتی یکی پودر</span></strong><strong>&nbsp;</strong><strong><span dir=\"LTR\"><span style=\"color:black\">UV</span></span></strong><strong>&nbsp;<span style=\"color:black\">و دیگری پودر کم دما پخت به کار رفته بر روی فیبر چگالی متوسط ارائه و مقایسه شود.</span></strong></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">کاربرد پوشش پودری روی</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">MDF</span></span><span style=\"color:black\">: اصول کلی و منافع اقتصادی</span>&nbsp;<br />\r\n<span style=\"color:black\">فن آوری کاربرد پودر، روشی سریع، تمیز و از نظر اقتصادی جذاب برای به دست آوردن محصولاتی با کیفیت بالا روی</span>&nbsp;<span dir=\"LTR\"><span style=\"color:black\">MDF</span></span>&nbsp;<span style=\"color:black\">است.</span></span></span></span></h2>\r\n\r\n<h2 style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</h2>','/app/articles/1545827589526.jpg','/app/articles/1545827589690.jpg','پوشش پودری,Powder coating, BASF,AkzoNobel,افزودنی,رنگ,رزین,ادتیو,پلی استر,اپوکسی,هیبرید,ضد خوردگی','آشنایی-با-فرمولاسیون-پوشش-های-پودری',2195,3,1,'2018-09-15 20:26:00','2022-01-11 06:17:11'),(33,3,'مقدمه ای بر علم رزین ها و پوشش ها','مهمترين جزء يك پوشش ، رزين آن است . نوع رزين يا پليمر به قدري مهم است كه رنگ را برحسب آن نامگذاري و مي فروشند','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong>عنوان : </strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950946\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">انواع پوشش و شكستهاي متداول :</span> <span style=\"font-size:12.0pt\">4</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950947\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">رزين ها&nbsp; و روغن هاي طبيعي :</span> <span style=\"font-size:12.0pt\">4</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950948\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">رزين هاي طبيعي :</span> <span style=\"font-size:12.0pt\">5</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950949\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">روغن ها :</span> <span style=\"font-size:12.0pt\">8</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950950\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">الكيدها و اپوكسي استرها :</span> <span style=\"font-size:12.0pt\">12</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950951\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 2 .1 الكيدها :</span> <span style=\"font-size:12.0pt\">12</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950952\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">استرهاي اپوكسي :</span> <span style=\"font-size:12.0pt\">17</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950953\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 .3 اپوكسي ها :</span> <span style=\"font-size:12.0pt\">18</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950954\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 3 .1 عامل هاي آميني و آميدي عمل آورنده رزين هاي اپوكسي :</span> <span style=\"font-size:12.0pt\">20</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950955\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 3 . 2 انواع شكست اپوكسي :</span> <span style=\"font-size:12.0pt\">25</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950956\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 4 اپوكسي هاي اصلاح شده :</span> <span style=\"font-size:12.0pt\">32</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950957\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 4 . 1 اپوكسي هاي اكريليك :</span> <span style=\"font-size:12.0pt\">32</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950958\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 4 . 2 اپوكسي هاي قطران :</span> <span style=\"font-size:12.0pt\">33</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950959\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 4 . 3 فنوليكهاي اپوكسي :</span> <span style=\"font-size:12.0pt\">34</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950960\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 5 فنوليكها :</span> <span style=\"font-size:12.0pt\">35</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950961\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 5 . 1 فنوليك هاي </span>RESOLE<span style=\"font-size:12.0pt\">&nbsp; :</span> <span style=\"font-size:12.0pt\">35</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950962\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 .2 .2 فنوليكهاي </span>novalac<span style=\"font-size:12.0pt\"> :</span> <span style=\"font-size:12.0pt\">36</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950963\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 5 . 3 انواع شكست فنوليكها :</span> <span style=\"font-size:12.0pt\">37</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950964\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 6 آمينو رزين ها :</span> <span style=\"font-size:12.0pt\">37</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950965\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 7 . اكريليك ها :</span> <span style=\"font-size:12.0pt\">40</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950966\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 7 . 1 اكريليك هاي محلولي :</span> <span style=\"font-size:12.0pt\">41</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950967\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 7 . 2 پوششهاي اكريليك </span>latex<span style=\"font-size:12.0pt\"> :</span> <span style=\"font-size:12.0pt\">44</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950968\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 7 . 3 اكريليك هاي ترموست :</span> <span style=\"font-size:12.0pt\">49</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950969\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">مشكلات احتمالي پوششهاي اكريليك/ </span>MF<span style=\"font-size:12.0pt\"> عبارتند از :</span> <span style=\"font-size:12.0pt\">52</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950970\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5-8 پلي استرها :</span> <span style=\"font-size:12.0pt\">53</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950971\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 8 . 1 پلي استرهاي اصلاح شده :</span> <span style=\"font-size:12.0pt\">54</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950972\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 8 . 2 پلي استرهاي اشباع نشده :</span> <span style=\"font-size:12.0pt\">58</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950973\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 9 پلي يورتانها :</span> <span style=\"font-size:12.0pt\">60</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950974\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 9 . 1 پوششهاي دو جزئي پلي ايزوسيانات / پوليول :</span> <span style=\"font-size:12.0pt\">63</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950975\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 9 . 2 پور الكيدها :</span> <span style=\"font-size:12.0pt\">68</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950976\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 9 . 3 پلي يورتانهاي گيرش يافته با رطوبت :</span> <span style=\"font-size:12.0pt\">69</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950977\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 9 . 4 لعابها و </span>dispersion<span style=\"font-size:12.0pt\"> هاي پلي يورتان :</span> <span style=\"font-size:12.0pt\">71</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950978\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 9 . 5 پلي يورتانهاي دو جزئي </span>water &ndash; borne<span style=\"font-size:12.0pt\"> :</span> <span style=\"font-size:12.0pt\">72</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950979\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 </span><span style=\"font-size:12.0pt\">&ndash;</span><span style=\"font-size:12.0pt\"> 10 وينيل ها:</span> <span style=\"font-size:12.0pt\">73</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950980\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 10 . 1 وينيل هاي محلولي :</span> <span style=\"font-size:12.0pt\">74</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950981\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 10 . 2 پلاسيتسولها و ارگانوسولها :</span> <span style=\"font-size:12.0pt\">75</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950982\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 10 . 3 وينيل فلورايدها :</span> <span style=\"font-size:12.0pt\">76</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950983\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 .10 .4 پلي (وينيل بوتيرال)</span> <span style=\"font-size:12.0pt\">77</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950984\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 10 . 5 : وينيل هاي&nbsp; </span>latex<span style=\"font-size:12.0pt\"> :</span> <span style=\"font-size:12.0pt\">78</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950985\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 11 پوششهاي قيري :</span> <span style=\"font-size:12.0pt\">80</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950986\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 </span><span style=\"font-size:12.0pt\">&ndash;</span><span style=\"font-size:12.0pt\"> 12 پوششهاي غير آلي و سيليكوني اصلاح شده :</span> <span style=\"font-size:12.0pt\">84</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950987\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 . 12 . 1 پوششهاي سيليكوني :</span> <span style=\"font-size:12.0pt\">84</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"color:blue\"><u><a href=\"#_Toc460950988\" style=\"color:blue; text-decoration:underline\"><span style=\"font-size:12.0pt\">5 .12 . 2 پوششهاي سيليكاتي :</span> <span style=\"font-size:12.0pt\">88</span></a></u></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950946\"></a><a name=\"_Toc460950832\">انواع پوشش و شكستهاي متداول :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:14pt\"><span style=\"font-size:16.0pt\">مهمترين جزء يك پوشش ، رزين آن است . نوع رزين يا پليمر به قدري مهم است كه رنگ را برحسب آن نامگذاري و مي فروشند . پوشش الكيدي يا اپوكسي براي همه آشناست ولي كسي تا به حال نام پوشش دي اكسيد تيتانيم يا متيل اتيل كتون به گوشش نخورده است . در اين فصل ، انواع رزين يا پليمرهاي مورد استفاده در پوشش بهمراه نقاط ضعف و قوت آنها بحث مي شود . حتي در يك خانواده پوشش ، ممكن است پوششهاي با خواص فيزيكي و شيميايي كاملاً متفاوت وجود داشته باشد . يكي از جذابيتهاي علم پليمر ، گسترده بودن آن است مثلاً تغييرات جزئي در ساختار مونومر يك اكريليك ، پليمري با خواص كاملاً متفاوت ايجاد خواهد كرد. اپوكسي ممكن است سخت و شكننده يا نسبتاً نرم و انعطاف پذير باشد . در اين بحث هاي كلي بايستي مواظب استثناها بود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950947\"></a><a name=\"_Toc460950833\">رزين ها&nbsp; و روغن هاي طبيعي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">قرنها است كه از اين مواد براي ساخت پوشش تزئيني و محافظ استفاده&nbsp; مي شود . اين مواد از منابع طبيعي نظير باقيمانده گياهان ، حيوانات و فسيلها بدست مي آيند . هر چند روغنهايي مثل روغن بزرك يا روغن ماهي ، رزينهاي طبيعي هستند ولي به صورت جداگانه توضيح داده مي شوند .</span></span></span></p>\r\n\r\n<p style=\"text-align:right\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950948\"></a><a name=\"_Toc460950834\">رزين هاي طبيعي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\">بسياري از رزينها طبيعي از شيره درختان حاصل مي شوند كه براي حفاظت درخت در برابر بريدگيها و زخمها از آن تراوش مي نمايد . بسياري از آنها داراي گروه عامل كربوكسيل و اسيدي هستند كه اسيدي بودن آن برحسب عدد اسيد بيان مي شود (ميليگرم هيدروكسيد پتاسيم لازم براي خنثي كردن اسيد يك گرم رزين). رزين هاي طبيعي معمولاً وزن ملكولي نسبتاً بالا و در حالت خالص در دماي اطاق ، جامدند ، اغلب براي توليد روغن جلا ، آنها را با مقادير مختلف روغن نباتي ، حرارت مي دهند. رزين طبيعي باعث سختي ، جلا ، مقاومت در برابر رطوبت و بهبود زمان خشك شدن مي شود در حاليكه روغن نباتي باعث انعطاف پذيري و دوام مي شود .</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">المي ، كوپال ، دامار و روسين نمونه هايي از رزين هاي طبيعي هستند كه از درختان ، گياهان و فسيلها بدست مي آيند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">المي رزين نرم داراي محدوده ذوب </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\"> 120 </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> 80 و عدد اسيد پايين&nbsp; (35 - 20) است كه از درختي در فيليپين بدست مي آيد . با بسياري از رزينها و حلالها سازگار است و به لعاب و جلا ، انعطاف پذيري مي بخشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بر خلاف المي ،كوپال ماده سخت داراي وزن ملكولي بالا و دماي ذوب بالا&nbsp; (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\"> 149) است و عدد اسيد آن در انواع نيوزيلندي 50 و در انواع آفريقاي مركزي 140 است . داراي مواد فسيل شده كه از درختان مختلف </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TROPICAL</span><span style=\"font-size:16.0pt\"> بدست مي آيد مي باشد كه اگر تحت دما و فشار ، تقطير نشود كاربرد كمي خواهد داشت . پس از تقطير ، جلاهاي با دوام و مقاومت اتمسفري عالي توليد مي نمايد . كوپال مانيلي كه در فيليپين يا هند شرقي بدست مي آيد فسيل نيست بلكه از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tapping</span><span style=\"font-size:16.0pt\"> درختان زنده بدست&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي آيد كه تا حدي نرمتر از كوپال فسيلي و در الكل قابل حل است . انواع فسيلي&nbsp;&nbsp;&nbsp; سخت تر نيز در دسترس مي باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">دامار رزين نسبتاً نرمي با محدوده ذوب </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\">113 </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> 70 و عدد اسيد پايين (30 - 20) است . دامار از درختان خاصي در هند شرقي بدست مي آيد و حتي در حلالهاي هيدروكربني ضعيف نيز قابل حل است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اين ماده براي جلاها ، لعاب هاي نيتروسلولزي و حتي به عنوان اصلاح كننده در پوشش هاي الكيدي خاصي استفاده مي شود . دامار براقيت و دوام رنگ را بهبود&nbsp; مي بخشد.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">روسين كه به كولوفوني نيز معروف است يكي از كاربردي ترين رزين هاي طبيعي است كه داراي نقطه ذوب حدود </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\">80 است . بسيار اسيدي( داراي عدد اسيد 180 - 150) و در الكل و هيدروكربنها قابل حل است . از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Pine</span><span style=\"font-size:16.0pt\"> درختان تراوش مي شود و بصورت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">DOMESTICALLY</span><span style=\"font-size:16.0pt\"> مي تواند بدست آيد . از نظرشيميايي داراي مشتقات فنان ترين (هيدروكربن آروماتيك چند&nbsp;&nbsp; هسته اي) نظير اسيد ابتيك (شكل 5-1)است.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">روسين معمولاً مقاومت ضعيفي در برابر آب و قلياها دارد ، با گذشت زمان اكسيد&nbsp;&nbsp; مي شود تا حدي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TACKY</span><span style=\"font-size:16.0pt\"> است . بخاطر اين نواقص ، اغلب از روسين بعنوان </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PRECURSOR</span><span style=\"font-size:16.0pt\"> در ساخت ديگر رزين ها استفاده مي شود . وقتي روسين با گليسرول يا ديگر الكل هاي پلي هيدريك واكنش بدهد به محصولي بنام </span><span dir=\"LTR\" style=\"font-size:14.0pt\">GUM</span><span style=\"font-size:16.0pt\"> استري تبديل مي شود كه ماده اي سخت و براي توليد جلا از آن استفاده مي شود . واكنش ، بين گروه اسيدكربوكسيليك (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">- COOH</span><span style=\"font-size:16.0pt\">) روسين و گروه هيدروكسيل گليسرول براي توليد استر با وزن ملكولي بالاتر ، انجام مي پذيرد.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وقتي روسين با ايندريك مالئيك (شكل 5-2) و سپس با گليسرول (شكل5-3) واكنش بدهد استرهاي مالئيك روسيني ايجاد مي شود . عدم اشباع </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CONJUGATED</span><span style=\"font-size:16.0pt\"> روسين اوليه حذف مي گردد بنابراين دوام رنگ بيشتر مي شود و محصول كه داراي وزن ملكولي بالاتر است&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TACKINESS</span><span style=\"font-size:16.0pt\"> روسين را ندارد . استرهاي مالئيك روسين همراه با روغن هاي نباتي براي توليد چسب هايي كه به مرور زرد نخواهد شد ، براي بهبود براقيت و سختي الكيدها و در ساخت جلاها استفاده مي شوند . شلاك يك رزين طبيعي است كه نسبت به موادي كه تاكنون توضيح داده شد داراي منشاء كاملاً متفاوت مي باشد . شلاك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">EXCRETION</span><span style=\"font-size:16.0pt\"> حشره </span><span dir=\"LTR\" style=\"font-size:14.0pt\">LAC</span><span style=\"font-size:16.0pt\"> است كه بومي هند و تايلند&nbsp; مي باشد.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">EXCRETION</span><span style=\"font-size:16.0pt\"> خشك شده ، خرد و شسته مي شود سپس ذوب و بصورت ورقه هاي خشك مي شود كه در اثر شكسته شدن به پولكي تبديل شده ، سپس در الكل حل مي شود . براي توليد سيلرهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">KNOT</span><span style=\"font-size:16.0pt\"> و لعابها استفاده مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">استفاده عمده رزين هاي طبيعي جلا است در ساخت جلا ، رزين طبيعي با روغن خشك كننده اي نظير روغن بزرگ پخت مي شود تا محلولي يكنواخت بدست آيد سپس اين محلول را رقيق مي نمايند تا وسيكوزيته آن به حدي برسد كه قابل كار كردن باشد . اين جلاها به نام جلاهاي اولئورزين معروفند كه هنوز هم براي كاربردهاي خاصي استفاده مي شود ولي عمدتاً توسط&nbsp; رزين هاي مصنوعي كه كارايي بهتر و در حلالهاي پيراموني كمتر حل مي شوند جايگزين شده اند هرچند لغت&laquo;جلا &raquo; هنوز هم براي توصيف اين پوششهاي ترانسپارنت به كار مي رود تعداد كمي از آنها به معني واقعي كمه جلا هستند.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950949\"></a><a name=\"_Toc460950835\">روغن ها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">عمده ترين رزين طبيعي معرفي ، روغنهاي نباتي و تا حد كمتري روغن ماهي است كه قرنهاست به منظور ايجاد پوششهاي تزئيني و حفاظتي استفاده مي شوند . در سدة نوزدهم و اوايل قرن بيستم ، اين مواد ، عمده ترين چسب رنگها بودند . هر چند رنگهايي كه فقط داراي چسب روغني باشند هنوز هم وجود دارند ولي بازار </span><span dir=\"LTR\" style=\"font-size:14.0pt\">NICHE</span><span style=\"font-size:16.0pt\"> بصورت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PRESER VATIVE</span><span style=\"font-size:16.0pt\"> هاي چوب و&nbsp;&nbsp; فيلم هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">VARNISH</span><span style=\"font-size:16.0pt\"> دارند . با اين حال در ساخت پوششهاي پيچيده تر نظير الكيدها و اپوكسي استرها به مقدار زياد از اين روغنها استفاده مي شود.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">گليسرول و انواع اسيدهاي چرب ، اسيدهاي كربوكسيلي هستند كه گروه هيدروكربني آليفاتيك اشباع شده يا نشده معمولاً به طول 17-15 اتم كربن دارند مثل اسيد اولئيك (شكل 5-4) . روغن (تري گليسريد) داراي ساختار معمولي (شكل 5-5) است كه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">R</span><span style=\"font-size:16.0pt\"> از انواع اسيدهاي چرب بدست مي آيد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">فرمول بعضي از مهمترين اسيدهاي چرب به قرار زير است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><a name=\"_Toc460950836\"><span style=\"font-size:16.0pt\">اسيد استئاريك </span></a><span dir=\"LTR\" style=\"font-size:14.0pt\">CH3 (CH2) 16 COOH</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">&nbsp;<a name=\"_Toc460950837\">اسيد پالمتيك&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </a></span><span dir=\"LTR\" style=\"font-size:14.0pt\">CH3 (CH2) 14</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><a name=\"_Toc460950838\"><span style=\"font-size:16.0pt\">اسيد اولئيك&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></a><span dir=\"LTR\" style=\"font-size:14.0pt\">CH3 (CH2)7 CH = CH (CH2)7 COOH</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><a name=\"_Toc460950839\"><span style=\"font-size:16.0pt\">اسيد لينوئيك&nbsp;&nbsp;&nbsp; </span></a><span dir=\"LTR\" style=\"font-size:14.0pt\">CH3 (CH)4 CH =&nbsp; CH CH = CH&nbsp;&nbsp; = CH (CH2)7 COOH</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><a name=\"_Toc460950840\"><span style=\"font-size:16.0pt\">اسيد لينولينك&nbsp;&nbsp; </span></a><span dir=\"LTR\" style=\"font-size:14.0pt\">CH3 CH = CH = CH CH = CH = CH CH = CH = CH (CH2)7 COOH</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><a name=\"_Toc460950841\"><span style=\"font-size:16.0pt\">اسيد ري سيلنوليك &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></a><span dir=\"LTR\" style=\"font-size:14.0pt\">CH3 (CH2)5 COH HCH2 CHCH = CH (CH2)7 COOH</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><a name=\"_Toc460950842\"><span style=\"font-size:16.0pt\">اسيد الئوستريك&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></a><span dir=\"LTR\" style=\"font-size:14.0pt\">CH3 (CH2)3 CH = CH CH = CH CH = CH (CH2)7 COOH</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">روغنهاي طبيعي داراي يك تري گليسريد كه از گليسرول و يك اسيد چرب ساخته شده باشد نيستند بلكه داراي مخلوطي از تري گليسريدهايي هستند كه از اسيدهاي چرب مختلف آمده است . جدول 5-1 تركيب بعضي از روغنهايي كه بيشتر استفاده مي شوند را نشان مي دهد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">]</span><span style=\"font-size:16.0pt\">1</span><span dir=\"LTR\" style=\"font-size:14.0pt\">[</span> </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">تركيب روغن از روي نام روغن مشخص است بجز مواردي مثل روغن بزرك كه از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PLAX</span><span style=\"font-size:16.0pt\"> بدست مي آيد و روغن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TALL</span><span style=\"font-size:16.0pt\"> كه محصول فرعي ساخت كاغذ </span><span dir=\"LTR\" style=\"font-size:14.0pt\">KRAFH</span><span style=\"font-size:16.0pt\"> از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PULP</span><span style=\"font-size:16.0pt\"> چوبي است.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">روغنها به سه دسته روغنهاي خشك شوند ،نيمه خشك شونده و غير خشك شونده تقسيم مي شوند . روغنهاي خشك شونده در اثر تماس با هوا فيلم جامد نسبتاً سخت ايجاد مي نمايند . روغن هاي نيمه خشك شونده فيلم هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TACKY</span><span style=\"font-size:16.0pt\"> و روغنهاي غير خشك شونده عمدتاً بصورت مايع و باقي مي مانند اينكه روغن به كداميك از اين سه دسته تعلق دارد عمدتاً به مقدار پيوند دوگانه كربن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> كربن يا عدم اشباع اسيدهاي چرب مانند اين روغنها بستگي دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مكانيزم خشك شدن يا پيوندعرضي روغن كاملاً پيچيده و شامل اكسيد شدن پيوندهاي دوگانه است كه با ايجاد راديكال آزاد شروع مي شود . راديكال ملكولي است كه داراي الكترون غير اشتراكي باشد پروكسيدها و هيدرپروكسيدها (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">ROOH</span><span style=\"font-size:16.0pt\">) كه معمولاً به مقدار كم وجود دارند به طور جزئي عامل ايجاد راديكالهاي آزاد هستند (شكل 5-6)</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اين راديكالها آزاد اتم هيدروژن را به سمت ملكول متيلن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CH2</span><span style=\"font-size:16.0pt\"> در مجاورت پيوند دوگانه مي نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بنابراين در يك يا چند گروه از اسدهاي چرب روغن ، توليد راديكال آزاد مي نمايند . دو راديكال آزاد روي دو ملكول تري گليسريد مجزا با هم تركيب مي شوند تا ذره خنثي ايجاد نمايند بنابراين اين واكنشهاي انتشار و تراكم زنجيره (پيوند عرضي= </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CROSS LINKING</span><span style=\"font-size:16.0pt\">)&nbsp; آغاز مي شود كه منجر به افزايش جزئي وزن ملكولي و توليد فيلم جامد نسبتاً سخت مي شود . كل فرايند به نام اكسيد اسيون خود بخود معروف است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">سرعت واكنش اكسيد اسيون خود بخود مي تواند كاملاً كم باشد كه براي سرعت بخشي از كاتاليست استفاده مي شود اين كاتاليست يا &laquo;خشك كن&raquo; اغلب نمك هاي اسيدهاي كاتانويك يا نفتنيك است . بعضي از آنها نظير نمكهاي كبالت و منگنز عمدتاً پيوند عرضي در سطح پوشش را كاتاليزه نموده كه به خشك كن هاي سطحي معروفند . ديگر كاتاليست ها نظير نمكهاي زيركونيم ، پيوند عرضي در حجم پوشش را كاتاليزه مي نمايند و به خشك كن هاي حجمي معروفند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هر چند پوششهاي پايه روغني با فرمول صحيح طي چند ساعت خشك و قابل لمس مي شوند فرايند پيوند عرضي اكسيد اسيون تا چند سال مي تواند ادامه يابد واكنش راديكالهاي آزاد ممكن است منجر به تورق پيوند و در نتيجه محصولات فرعي با وزن ملكولي پايين ايجاد نمايد . بنابراين پوششهاي پايه روغني با روغنهاي خشك شونده طي گذشت چند سال ، ترد و بيرنگ مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\">بر خورد با پوششهاي داراي چسب هايي كه فقط از روغنهاي طبيعي درست شده اند نسبتاً نادر است وقتي اين پوششها به تنهايي استفاده شوند اين روغن ها پوششهايي نرم (ولي با گذشت زمان ترد خواهند شد) ، مقاومت ضربه ، مقاومت سايش و مقاومت شيميايي ضعيفي دارند . با اينحال اين روغنها به صورت گسترده در دسته بعدي پوششها ـ الكيدها و استرهاي اپوكسي استفاده مي شوند .</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950950\"></a><a name=\"_Toc460950843\">الكيدها و اپوكسي استرها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950951\"></a><a name=\"_Toc460950844\">5 . 2 .1 الكيدها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">الكيدها يكي از پاهاي ثابت صنعت پوشش در عمده قرن بيستم بوده است . عليرغم منافع پوششهاي پيچيده كاراتر نظير اپوكسي و يورتانها ، الكيدها همچنان در بازار براي نگهداري ساختمانها و تجهيزات صنعتي به كار مي روند. با اينحال حركت به سمت قانونهايي كه استفاده از پوششهايي كه داراي كمترين تركيبات آلي فرار هستند را توصيه مي نمايد نهايتاً ممكن است منجر به افول آنها گردد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">الكيدها در اصل پلي استرهاي اصلاح شده با روغن هستند كه از واكنش پوليولها ، اسيدهاي دو بازي و اسدهاي چرب (يا روغنهايي كه از اسيد چرب درست شده اند) ايجاد مي شوند . هر چند پوليولهاي متنوعي مي توانند در اينجا استفاده شوند دو تا از متداولترين آنها گليسرول (شكل5-3) و پنتا اري تريتول(شكل 5-7) مي باشد . متداوليترين اسيد دو بازي به صورت انيدريدي استفاده مي شود و داراي انيدريد فتاليك (شكل5-8) مي باشد . اسيد ايزوفتاليك (شكل 5-9) نيز تا حدي متداول است.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">براي توليد الكيدها دو فرايند وجود دارد . فرايند مونوگليسريد و فرايند اسيد چرب ، دو فرايند مونوگليسريد روغن (نظير روغن بزرك) با پوليول (معمولاً گليسرول) پخت مي شوند كه منجر به واكنش </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TRANSESTRIFICATION</span><span style=\"font-size:16.0pt\"> براي ايجاد مونو گليسريد مي گردد (شكل5-10) وقتي مونوگليسريد تشكيل شد اسيد&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">DIBASIC</span><span style=\"font-size:16.0pt\">&nbsp; نظير انيدريد فتاليك اضافه مي شود . گروههاي اسيد (يا انيدريد) انيدريد فتاليك با گروه هيدروكسيل مونو گليسريد واكنش و ايجاد پلي استرهاي اصلاح شده با روغن يا الكيدها را مي دهد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اگر مطلوبست كه از پوليولي غير از گليسرول استفاده شود واكنش بالا نمي تواند استفاده شود . در اين حالت فرايند اسيد چرب استفاده نمي شود كه در آن بجاي روغن ها (تري گليسريدها) از اسيدهاي چرب استفاده مي شود و اسيدهاي چرب ، پوليولها و اسيدهاي</span><span dir=\"LTR\" style=\"font-size:14.0pt\"> DIBASIC</span><span style=\"font-size:16.0pt\"> در محفظه در يك مرحله واكنش مي دهند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">دو روش همپوشان براي دسته بندي الكيدها وجود دارد : ممكن است الكيدها برحسب خشك شونده يا&nbsp; غيرخشك شونده (گاهي به عنوان الكيد شونده يا غير اكسيد كننده ناميده مي شوند) يا از روي مشخصه طول روغن شناخته&nbsp; شوند.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">الكيدها عمدتاً با واكنش اكسيد اسيون خودبخود كه قبلاً براي روغنهاي طبيعي كه از آنها ساخته مي شوند توضيح داده شد گيرش مي يابند . بنابراين الكيدها&nbsp; برپايه روغنهاي خشك شونده (روغنهايي كه اسيدهاي چرب آنها با پيوندهاي دوتايي كربن ـ كربن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CONJUGATED</span><span style=\"font-size:16.0pt\"> شده است) نظيرروغن بزرك براي ايجاد فيلم جامد ، خشك يا اكسيد مي شوند بنابراين براي استفاده بصورت پوشش مناسب هستند . در مقابل الكيدهاي برپايه روغنهاي اشباع شده خشك شونده ، گيرش نمي يابند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بلكه عمدتاً بصورت مايعات ويسكوز باقي مي مانند اين الكيدها براي پوشش دهي مناسب نيستند بلكه اغلب به عنوان نرم كننده استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">طول روغن اشاره به طول زنجيره اسيد چرب (يعني </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C16 </span><span style=\"font-size:16.0pt\">برحسب </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C18</span><span style=\"font-size:16.0pt\"> ) ندارند بلكه به مقدار واقعي روغن (يا اسيد چرب) مصرف شده برحسب درصد وزني .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">الكيدها با طول روغن بزرگتر از 60 (%60 وزني روغن) الكيدهاي روغن طويل ناميده مي شوند الكيدهاي داراي حدود %60-40&nbsp; روغن ، الكيدهاي روغني متوسط هستند و آنهايي كه كمتر از 40 درصد روغن دارند الكيدهاي روغني كوتاه هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در صورتيكه تمام موارد ديگر يكسان باشند الكيدهاي روغني طويل داراي واكنش سطحي كمتر و بنابراين خواص خيس كنندگي بهتري نسبت به الكيدهاي روغني كوتاه مي باشند . آنها </span><span dir=\"LTR\" style=\"font-size:14.0pt\">more tolerant of marginally prepared surfaces </span><span style=\"font-size:16.0pt\">&nbsp;و آلودگيهاي آلي قابل حل نظير روغن و گريس را بهتر بلند و جابجا مي كنند . همچنين بهتر قادر به نفوذ و احاطه مقادير كم زنگ يا پوسته مي باشد(نسبت به الكيدهاي با روغن كوتاه&nbsp; فيلم نرمتر و قابل انعطاف تري (حداقل در ابتدا) ايجاد مي كنند) . دسته دوم براي (پرايمرزني در مغازه) استفاده مي شوند كه سريعاً خشك شده و به محل كا ر، منتقل تا در آنجا نصب و رنگ بعدي روي آن زده شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">با اين حال چون عمل آمدن با اكسيژن براي رزين هاي الكيدي چند سال طول مي كشد خواص نهايي پوشش با خواص اوليه ممكن است بسيار متفاوت باشد . الكيد روغن طويل كه داراي مقدار زيادي روغن خشك شونده باشد طي سالها مي تواند تردتر از الكيدهاي با روغن كوتاه داراي مقدار كمي روغن خشك شونده شود . اين مطلب نشان مي دهد كه نمي توان در مورد خواص گروهي از پوششها به صورت كلي بحث كرد . تغييرات ساخت مي تواند اثرات زيادي بر خواص پوشش حاصل نسبت به خواص آن گروه ايجاد نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در بسياري از كاربردها ، الكيدها يك پوشش همه كاره هستند . با اين حال عمدتاً بخاطر اينكه اساس پوشش بر اتصالات نسبتاً فعال استري بيشمار استوار است الكيدها در برابر قلياها مقاومت ضعيفي دارند . واكنش اسيد و الكل براي ايجاد استر يك واكنش برگشت پذيراست بويژه تحت شرايط قليايي مرطوب تخريب برگشت پذير استر به الكل و اسيد ، هيدروليز يا صابوني شدن ناميده مي شود . چون واكنش تحت شرايط قليايي اتفاق مي افتد نمك اسيد بجاي اسيد آزاد تشكيل مي شود . نمك اسيد براحتي با روشهاي آناليز آشكار شدني است در نتيجه صابوني شدن مشخص مي شود.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">علاوه بر صابوني شدن ، الكيدها به حمله شيميايي و نور خورشيد (در پيوند&nbsp; دوگانه باقيمانده) حساس هستند . مواد شيميايي خاصي نظير اسيدهاي معدني مي تواند به پيوندهاي دوگانه اضافه شود . عدم اشباع نيز محلهايي براي اكسيد اسيون و واكنش راديكالهاي آزاد فراهم مي نمايد شكست ديگري كه در الكيدها اتفاق مي افتد موج برداشتن است كه زماني اتفاق مي افتد كه سريعتر از داخل خشك مي شود در اينحالت سطح منقبض مي شود و چون داخل هنوز &laquo;خميري&raquo; است بهمراه انقباض سطح ، كشيده مي شود در نتيجه موج ايجاد مي شود اين حالت در موردي اتفاق مي افتد كه پوشش ، بيش از اندازه ضخيم باشد يا اينكه سرعت خشك كن هاي سطح و داخل ، مساوي نباشد . راه هاي زيادي براي اصلاح خواص اكسيدها وجود دارد از جمله فنليكها ، استايرن ها ، وينيل تولوئن و رزين هاي سيليكوني .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي فنلي توسط واكنش فنل جانشيني با فرمالدئيد ايجاد مي شوند (شكل 5-11) و به مقدار كم براي بهبود چسبندگي ، سختي و مقاومت خوردگي الكيدها به آن اضافه مي شوند . الكيدهاي فنلي گاهي پرايمرهاي فلزي اونيورسال ناميده مي شوند چرا كه مي توانند با انواع مختلفي از پوش هاي پايه حلالي بدون ترس از بلند شدن و موج برداشتن كه گاهي در پوششهاي الكيدي اصلاح شده نسبتاً حساس به حلال اتفاق&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي افتد پوشش مجدد داده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي الكيدي مي توانند با پختن اضافه نيز اصلاح شوند كه با استايرن (شكل 5-12)يا وينيل تولوئن (شكل 5-13) واكنش داده شوند كه باعث ايجاد رزين هاي با وزن ملكولي سنگينتر مي شود كه سرعت خشك شدن را سريعتر و مقاومت در برابر رطوبت و قليايي را تا حدي زياد مي نمايد . با اصلاح و ينيلي ، مقاومت كافي در برابر حلالها و هيدروكربن هاي آليفاتيك نظير روغن و گريسها ايجاد نخواهد شد . الكيدها با رزين هاي سيليكوني نيز اصلاح مي شوند . مزيت اصلي آنها عبارتست از دوام بيشتر و مقاومت حرارتي.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950952\"></a><a name=\"_Toc460950845\">استرهاي اپوكسي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">از نظر فني، استرهاي اپوكسي يك نوع الكيد اصلاح شده تلقي مي شوند ولي چون استر اپوكسي ناميده مي شوند نه الكيدهاي اصلاح شده با اپوكسي ، در اينجا قسمت جداگانه اي برايشان در نظر گرفته شده است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوشش هاي با رزين اپوكسي يكي از مهمترين پوششهاي كارا مي باشد . استرهاي اپوكسي پوششهاي اپوكسي نيستند و نبايستي با آنها قاطي شوند لذا بهتر است الكيدهاي اصلاح شده با اپوكسي ناميده شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">از نظر شيميايي ، گروه عامل اپوكسي (كه گروه اكسيران هم ناميده مي شوند) حلقه سه عضوي از دو اتم كربن و يك اتم اكسيژن&nbsp; است . بيشتر رزين هاي اپوكسي براساس اتردي گليسيريل بي فنل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">A</span><span style=\"font-size:16.0pt\"> (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">DGEBA</span><span style=\"font-size:16.0pt\">) درست&nbsp; شده اند كه داراي ساختاري مشابه (شكل 5-14) مي باشد . رزين هاي اپوكسي متداول ، محصولات تراكم </span><span dir=\"LTR\" style=\"font-size:14.0pt\">DGBEA </span><span style=\"font-size:16.0pt\">با ساختار مشابه (شكل 5-15)هستند كه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">n</span><span style=\"font-size:16.0pt\"> معمولاً 1 تا 12 است . رزين ها داراي گروه هيدروكسيل و اكسيژن هستند كه با گروه اسيد كربوكسيليك اسيد چرب الكيد واكنش داده و استر اپوكسي ايجاد مي كنند . اين رزينهاي اپوكسي تا حدي با همديگر واكنش داده (گروه هيدروكسيل دوم ملكول با گروه اكسي ران ملكول دوم واكنش&nbsp;&nbsp; مي دهد) كه با اتخاذ روش پخت مناسب ، اين كار به حداقل مي رسد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">خواص استرهاي اپوكسي بسته به طول روغن الكيدها ، بسيار متنوع است . استرهاي اپوكسي با طول روغن زياد بيشتر شبيه الكيدها هستند و در حلالهاي آليفاتيك نظير الكلهاي معدني قابل حل هستند استرهاي اپوكسي با طول روغن كوتاه بيشتر شبيه اپوكسي هستند و نياز به حلالهاي قويتر آروماتيك نظير گزيلن دارند با اينحال حتي استرهاي اپوكسي با طول روغن كوتاه نيز بيشتر شبيه الكيدها هستند تا اپوكسي .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">استرهاي اپوكسي در مقايسه با الكيدها مي توانند با مزاياي متعدد و البته معايب ضمني آنها ساخته شوند مي توانند سريعتر خشك شوند و فيلم هاي سخت تر با چسبندگي بهتر و مقاومت بهتر شيميايي (هر چند به صابوني شدن حساس هستند) ايجاد نمايند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هر چند از نظر خواص فزيكي و شيميايي سخت به اپوكسي هاي واقعي ضعيفترند كاربرد آنها راحتر و سخت به آلودگي سطحي كم ، حساس نيستند ولي متاسفانه مشابه اپوكسي ها در برابر آفتاب ، گچي مي شوند . در مقايسه معايب و مزاياي اپوكسي با الكيدها ، از لحاظ نوع شكست ، يكسان هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950953\"></a><a name=\"_Toc460950846\">5 .3 اپوكسي ها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وقتي رزين هاي اپوكسي اولين بار در اوايل دهه 1940 مورد مصرف تجاري قرار گرفتند به صورت چسب استفاده مي شدند . امروزه آنها مهمترين گروه پوشش هاي ترموست كارا هستند . اپوكسي به صورت پوشش دو جزئي عمل آمدني در محيط ، به صورت سيستم پخت در دماي بالا ، به صورت اسپري سريع عمل آمدني صد درصد جامد و حتي به صورت پوشش مواد پودري ساخته مي شوند . در مقايسه با الكيدها و استرهاي اپوكسي ، چسبندگي مقاومت خوردگي و شيميايي و خواص فيزيكي و مكانيكي بهتر دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وزن ملكولي رزين هاي اپوكسي از 400 (1= </span><span dir=\"LTR\" style=\"font-size:14.0pt\">n</span><span style=\"font-size:16.0pt\">) تا حدود 4000 (12=</span><span dir=\"LTR\" style=\"font-size:14.0pt\">n</span><span style=\"font-size:16.0pt\">) در شكل 15-5 است با افزايش وزن ملكولي ، اكسي والان وزني (تعداد گرم رزين هاي&nbsp; يك اكسي والان گروه اپوكسي) نيز زياد مي شود . در بعضي رزين هاي اپوكسي با وزن ملكولي بسيار بالا (50000-15000) اپوكسي بقدري كم است كه (گروه اكسي ران ، دو انتهاي ملكول بزرگ را تشكيل مي دهد) .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">&nbsp;كه رزين در واقع شبيه الكل داراي چند عامل است . اين رزينها ، رزينهاي فنوكسي ناميده مي شوند كه به عوامل عمل آورنده نيازي ندارند وقتي به عنوان پرايمر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">SINGLE &ndash; PACKED</span><span style=\"font-size:16.0pt\"> باشند مقاومت شيميايي و چسبندگي خوبي دارند و در بعضي موارد ، مقاومت ضربه وسايشي آنها از اپوكسي هاي ترموست دو جزئي بيشتر است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وقتي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&nbsp;&nbsp; n</span><span style=\"font-size:16.0pt\"> ، 1 يا كمتر باشد رزين ها ، مايعات و يسكوز هستند اگر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">n</span><span style=\"font-size:16.0pt\"> حدود 2&nbsp; باشد رزين ، جامد آمورف با اكي والان وزني اپوكسي حدود 500-450 (وزن ملكولي 1000-900) كه در حدود </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\"> 75-65 نرم يا ذوب مي شود مي باشد . اين رزينها معمولاً به صورت محلولهاي با درصد جامد بالا (حدود %70) در حلالهاي آروماتيك يا كتوني فروخته شده و براي توليد پوشش هاي&nbsp; اپوكسي دو جزيي&nbsp; عمل آمدني&nbsp; در محيط كه امروزه استفاده مي شوند كاربرد دارند.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چون رزين هاي اپوكسي داراي وزن ملكولي پايين و در واقع ، مايعات&nbsp; ويسكوزهستند تنها وقتي كه پيوند عرضي ايجاد نموده مواد با وزن ملكولي بالاتري ايجاد نمايند پوشش هاي خوب ايجاد مي كنند هر چند بعضي از اين واكنش هاي ترموست بر گروه دوم هيدروكسيل در شاخه اصلي رزين اپوكسي استوار است بيشتر آنها داراي گروههاي اپوكسي انتهايي بسيار فعال هستند اين گروهها قادر به واكنش با تقريباً هر ملكولي كه اتم هيدروژن فعال داشته باشد از جمله آمينها ، اسيدهاي كربوكسيليك ، فنليك ها ، رزين هاي آميني ، انيدريدها و ايزوسياناتها مي باشد. خواص لايه عمل آمده ، بستگي عمده به نوع عامل عمل آوردني مورد استفاده دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950954\"></a><a name=\"_Toc460950847\">5 . 3 .1 عامل هاي آميني و آميدي عمل آورنده رزين هاي اپوكسي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">آمينها و آميدهاي داراي گروه آميني جزو عمده ترين عوامل عمل آورنده پوششهاي اپوكسي كاراي صنعتي كه در محيط گيرش پيدا مي نمايند هستند . آمينهاي اوليه آليفاتيك و سيكلوآليفاتيك با رزين اپوكسي با مكانيزمي مطابق شكل 5-16 واكنش&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي دهد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">آمين ثانويه اي كه به اين ترتيب توليد مي شوند با سرعت كمتري بواسطه&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(</span><span dir=\"LTR\" style=\"font-size:14.0pt\">HINDRANCE</span><span style=\"font-size:16.0pt\">) ممانعت استئاريك با ملكول ديگر اپوكسي واكنش مي دهد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">آمينهاي ساده آليفاتيك اصلاح نشده نظير تري آمين دي اتيلن (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">DGTA</span><span style=\"font-size:16.0pt\">) (شكل 5-17) بسيار فعال مي باشد و منجر به ايجاد پوششهايي با عمر پس از مخلوط كوتاه&nbsp; مي شود چون </span><span dir=\"LTR\" style=\"font-size:14.0pt\">DETA</span><span style=\"font-size:16.0pt\"> دو هيدروژن آمين اوليه و سه هيدروژن آمين ثانويه با تعداد گروههاي عامل 5 دارد پوشش با دانسيته پيوند عرضي بسيار بالا با مقاومت شيميايي و حرارتي عالي و استحكام پيوستگي عالي ايجاد مي نمايد با اين حال بخاطر مقدار بالاي پيوند عرضي ، انعطاف پذيري و مقاومت ضربه آسيب خواهد ديد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">جايگزين هاي مهم ديگر عوامل آميني ساده كه عامل پيوند عرضي هستند پلي آميدها مي باشند كه از واكنش آميني نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">DETA</span><span style=\"font-size:16.0pt\"> با اسيدهاي چرب دي مر براي ايجاد پلي آميدهاي منتهي به آمين ايجاد مي شوند . اسيدهاي چرب دي مر ،اسيد هاي كربوكسيليك با وزن مولكولي نسبتاً بالا هستند كه از واكنش دو اسيد چرب </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C18</span><span style=\"font-size:16.0pt\"> بدست مي آيند . وقتي اين اسيدهاي دي مر با </span><span dir=\"LTR\" style=\"font-size:14.0pt\">DETA</span><span style=\"font-size:16.0pt\"> يا آمين هاي ديگر داراي چند گروه عامل واكنش مي دهند پلي آميدهاي داراي گروه عامل آميني توليد مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هر چند اين عوامل پيوند عرضي گروه عامل آميدي دارند گاهي اطلاق عامل پيوند عرضي به پلي آميد تا حدي گيج كننده است چون گروه فعال واقعي ، گروههاي آميني هستند (بويژه گروههاي آمين اوليه در دو انتهاي مولكول) .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشابه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">adduct</span><span style=\"font-size:16.0pt\"> هاي آميني انواع مختلفي از پلي آميدهاي ايجاد كننده پيوند عرضي در بازار موجود است كه تا حدي از نظر خواص با محصول نهايي اپوكسي متفاوتند . چون تمام پلي آميدها ملكولهاي بسيار بزرگتري نسبت به پيوند دهنده هاي عرضي آميني ساده هستند و چون فاصله بسيار بيشتري بين گروههاي آميني اصلي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">terminal</span><span style=\"font-size:16.0pt\">&nbsp; بسيار فعال وجود دارد دانسيته پيوند عرضي پوشش اپوكسي پلي آميد بسيار كمتر از اپوكسي عمل آمده با آمين است . سرعت واكنش ، پائين تر ، عمر پس از مخلوط كردن بيشتر و نسبت حجم مخلوط معمولاً 1:1 يا 2:1 و سمي بودن و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blushing</span><span style=\"font-size:16.0pt\"> و خطاهاي ناشي از نسبت مخلوط ، كاهش يافته(ولي حذف نشده اند) .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">براساس خواص فيلم هاي گيرش يافته ، اپوكسي هاي پلي آميد معمولاً فيلم انعطاف پذير تر با دانسيته كمتر پيوند عرضي نسبت به اپوكسي هاي عمل آمده با آمين ايجاد مي كنند . انعطاف پذيري و مقاومت ضربه و چسبندگي بهبود مي يابد . با اين حال مقاومت شيميايي و مقاومت در برابر حلال مطلوب نيست هر چند كه هنوز در مقايسه با بسياري از پوششهاي عمومي ، خوب است . تركيب سهولت كار برد نسبي و خواص فيزيكي و شيميايي خوب ، پوششهاي اپوكسي پلي آميدي را يكي از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">workhorse</span><span style=\"font-size:16.0pt\"> هاي پوششهاي صنعتي عمومي نموده است . همچنين در بعضي پوششهاي خاص نظير صنايع غذايي ، دريايي و آستري هاي آلي غني از روي .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">عوامل پيوند عرضي آميد و آمين بواسطه واكنش با اسيدهاي چرب داراي يك گروه عامل بجاي اسيدهاي چرب ديمري ، با پلي آميدهاي داراي وزن ملكولي پايين ايجاد مي شوند . در مقايسه با آمينهاي ساده اصلاح نيافته ، آميد و آمينها ، وزن ملكولي بالاتر و تعداد گروه عامل كمتري دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">واكنش پيوند عرضي عمدتاً در گروه تكي آمين اصلي در انتهاي آميني ملكول با سرعت واكنش بسيار كمتر ناشي از آمينهاي ثانويه اي ممكن است در حجم ملكول باشند پيشرفت مي نمايد . دانسيته پيوند عرضي در مقايسه با اپوكسي ساده عمل آمده با آمين ، بسيار كم است و حتي كمتر از اپوكسي پلي آميد . چنين پوششهايي عمر پس از مخلوط بسيار طولاني دارند ، به كندي گيرش پيدا مي نمايد و انعطاف پذيري و مقاومت ضربه بهتري حتي نسبت به اپوكسي پلي آميدي دارند . در حاليكه مقاومت شيميايي آنها قابل مقايسه با اپوكسي پلي آميدي (و تا حدي برتر از اپوكسي عمل آمده با آمين) است مقاومت حلالي آنها به طور قابل ملاحظه اي ضعيفتر است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">ketimin</span><span style=\"font-size:16.0pt\"> ها نوع تقريباً خاصي از عوامل گيرش هستند كه عمر پس از مخلوط طولاني و يسكوزيته رنگ زني پايين بويژه در آنها مهم است . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">ketimin</span><span style=\"font-size:16.0pt\"> ها عوامل گيرش </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blicked</span><span style=\"font-size:16.0pt\"> در نظر گرفته مي شوند و بواسطه واكنش كتون داراي وزن ملكولي پايين مثل متيل اتيل كتون (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">MEK</span><span style=\"font-size:16.0pt\">) با آمين اوليه آليفاتيك ساخته مي شوند . ساختار يك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">ketimin</span><span style=\"font-size:16.0pt\"> متداول كه از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MEK</span><span style=\"font-size:16.0pt\"> ساخته مي شود در شكل 5-18 نشان داده شده است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چون</span><span dir=\"LTR\" style=\"font-size:14.0pt\">ketimin</span><span style=\"font-size:16.0pt\">&nbsp; ها آمين هاي سه تايي هستند در مقابل گروههاي اپوكسي فعاليت بسيار كمي نشان مي دهند در اثر تماس با رطوبت اتمسفر دچار تجزيه شده ، تشكيل آمين اوليه و در مثال بالا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MEK</span><span style=\"font-size:16.0pt\"> مي دهند . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MEK</span><span style=\"font-size:16.0pt\"> از فيلم فرار مي نمايد در نتيجه آمين اوليه را آزاد مي گذارد تا با رزين اپوكسي واكنش بدهد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">آمين هاي سيكلو آليفاتيك گروه خاصي از آمين هاي آليفاتيك هستند . دو مثال از آمين هاي سيكلوآليفاتيك ، سيكلو هگزان دي آمين (شكل 5-19) و ايزوفوران دي آمين (شكل 5-20) است . وقتي آمين هاي سيكلو آليفاتيك بواسطه اسيدهاي آلي كه نقش سريع كننده دارند اصلاح شوند گيرش كافي در حوالي دماي انجماد اتفاق مي افتد . هر چند اينها كمتر فرار هستند و بنابراين اين نسبت به </span><span dir=\"LTR\" style=\"font-size:14.0pt\">cyclic counter part</span> <span style=\"font-size:16.0pt\">&ndash;</span> <span dir=\"LTR\" style=\"font-size:14.0pt\">non</span><span style=\"font-size:16.0pt\"> هاي خود </span><span dir=\"LTR\" style=\"font-size:14.0pt\">less irritating</span><span style=\"font-size:16.0pt\"> هستند . هنوز هم اغلب با مقدار كمي اپوكسي داراي وزن ملكولي بسيار پايين براي كاهش فراريت و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blushing</span><span style=\"font-size:16.0pt\"> واكنش داده مي شوند . علاوه بر گيرش دماي پايين ، داراي چسبندگي خوبي به سطوح مرطوب مي باشند بعلاوه مقاومت بهتر شيميايي ، حلال و رطوبت مربوط به اپوكسي ، با اين حال تمايل به تردي دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">mannich base</span><span style=\"font-size:16.0pt\"> ها نوع ديگري از عوامل گيرش براي حصول گيرش دماي پايين و چسبندگي به سطوح </span><span dir=\"LTR\" style=\"font-size:14.0pt\">damp</span><span style=\"font-size:16.0pt\"> است . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">mannich base</span><span style=\"font-size:16.0pt\"> ها توسط واكنش بين متيل فنل و آمين اوليه داراي چند گروه عامل ايجاد مي شود . هيدروكسيل فنلي شتاب دهنده قدرتمندي براي واكنشهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">epoxy</span> <span style=\"font-size:16.0pt\">&ndash;</span> <span dir=\"LTR\" style=\"font-size:14.0pt\">ring</span> <span style=\"font-size:16.0pt\">&ndash;</span> <span dir=\"LTR\" style=\"font-size:14.0pt\">opening</span><span style=\"font-size:16.0pt\"> هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوششهاي پودري گروه خاصي از پوششهاي اپوكسي هستند كه حلال ندارند و به صورت پودر تهيه مي شوند . رزين اپوكسي ، رنگدانه و عوامل گيرش مخلوط و بواسطه ذوب در اكسترودرها تركيب و سپس سرد و به صورت پودرهاي يكنواخت آسياب مي شوند . پودر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">virgin</span><span style=\"font-size:16.0pt\"> ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">tg</span><span style=\"font-size:16.0pt\"> به اندازه كافي بالا دارد كه حين نگهداري به صورت جزئي ذوب نخواهد شد . اين پوششها توسط دستگاههاي خاص يا روي زير لايه داغ يا در دماي اطاق اعمال مي شوند كه سپس پخت خواهند شد تا به سيلان و حداكثر پيوند عرضي برسند . عامل گيرش كه معمولاً در پوشش پودر اپوكسي استفاده مي شود دي سيان دي آميد (شكل 5-21)است . پوششهاي پودري در ساخت تجهيزات اوليه بي شماري (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">OEM</span><span style=\"font-size:16.0pt\">) نظير جعبه ها و لوازم برق و بويژه در خطوط لوله زير زميني كاربرد دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950955\"></a><a name=\"_Toc460950848\">5 . 3 . 2 انواع شكست اپوكسي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">&nbsp;انواع مختلفي از رزين هاغي اپوكسي وجود دارند كه مي توانند با تعداد زيادتري عوامل گيرش ، واكنش دهند . همچنين تعداد زيادي رنگدانه ، كاتاليست ، افزودني و حلال براي انتخاب وجود دارد . مشكل و گاهي خطرناك است كه راجع به پوشش هاي اپوكسي (يا هر گروه از پوششها) كلي گويي كرد . نويسنده اغلب عبارتي نظير اينرا شنيده است: ( اين مطلب براي اپوكسي ، طبيعي به نظر نمي رسد) . پشتيباني از چنين مشاهداتي اغلب مشكل است مگر اينكه شخص تجربه قبلي در مورد محصول خاص مورد نظر را داشته باشد يا اينكه دسترسي به داده هاي منتشر نشده در مورد خواص فيزيكي و شيميايي پوشش مورد نظر داشته باشد . بعضي نتايج كلي اگر گاهي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">tentative</span><span style=\"font-size:16.0pt\"> باشد راجع به كارايي گروههاي خاصي از اپوكسي و راجع به مكانيزمهاي شكست آنها وجود دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در مقايسه با پوششهاي ترموپلاستيك و الكيدها ، اپوكسيها خواص چسبندگي بهتر و مقاومت بسيار بهتر در برابر مواد شيميايي ، حلالها ، آب و دماي بالا دارند . مقاومت ]]] ، انعطاف پذيري و مقاومت سايشي برحسب نوع اپوكسي بسيار متفاوت است . در بعضي موارد، تردي ممكن است مهمترين نقص باشد . مقاومت خوردگي اپوكسي داراي ساخت صحيح معمولاً كاملاً خوب و خيلي بهتر از ترموپلاستيك ها و الكيدها است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">&nbsp;يكي از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">draw back</span><span style=\"font-size:16.0pt\"> هاي عمده بيشتر اپوكسي ها ، مقاومت ضعيف در برابر نور خورشيد است بخاطر ساختار آروماتيك اپوكسي ها ، نور ماوراء بنفش داراي طول موج نسبتاً بلند بخوبي بالاتر از ناحيه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">cut off</span><span style=\"font-size:16.0pt\"> نور طبيعي خورشيد را جذب مي نمايد . علاوه بر زرد شدن ، جذب نور ماوراء بنفش باعث شكست سطح رزين اپوكسي مي گردد كه منجر به لايه نازكي از ماده گچي ضعيف مي شود . عمق اين تغيير ، بسيار نازك و از خواص فيزيكي و شيميايي پوشش ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">detract</span><span style=\"font-size:16.0pt\">&nbsp; نخواهد كرد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اين كار در صورتي كه زيبايي مهم باشد ممكن است </span><span dir=\"LTR\" style=\"font-size:14.0pt\">objectable</span><span style=\"font-size:16.0pt\"> باشد همچنين در صورت حذف شدن مي تواند باعث مشكلات جدي در مورد چسبندگي لايه هاي اعمالي بعدي گردد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">گاهي اوقات ممكن است اپوكسي تنها طي يك هفته تماس با محيط بيرون به اندازه كافي گچي شود كه پوششهاي خاصي به خوبي به آن نچسبد . در اين موارد مقدار گچي شدن بقدري كم است كه براحتي قابل مشاهده نيست .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشكل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blush</span><span style=\"font-size:16.0pt\"> آميني يا آميدي با استفاده از پيوند دهنده هاي عرضي با وزن ملكولي بالاتر نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">adduct</span><span style=\"font-size:16.0pt\"> هاي آميني و پلي آميدها يا با رعايت زمان </span><span dir=\"LTR\" style=\"font-size:14.0pt\">induction</span><span style=\"font-size:16.0pt\"> كاهش&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي يابد . با اين حال غير ممكن است كه كاملاً حذف شود . اغلب ، اين مشكل&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي تواند با شستن پوشش با آب قبل از اعمال رنگ بعدي ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">migitate</span><span style=\"font-size:16.0pt\"> گردد . اگر روي پوشش در محدوده زماني مورد نظر ، رنگ سازگار با </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blush</span><span style=\"font-size:16.0pt\"> (نظير پوشش اپوكسي ديگر) زده شود مشكلي از نظر چسبندگي وجود نخواهد داشت . با اين حال اين يك دانش غير واقعي است چون نويسنده تعداد زيادي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blush</span><span style=\"font-size:16.0pt\"> ديده كه به طور موفق رنگ زده شده هر چند مقدار كمي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blush</span><span style=\"font-size:16.0pt\"> مي تواند باعث شكست جدي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">به طور كلي جداي از مشكلات ناشي از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blushing</span><span style=\"font-size:16.0pt\"> و گچي شدن ،روي اپوكسي ها خاص و ديگر پوششهاي ترموست براحتي نمي توان رنگ زد چون صاف و سخت&nbsp; هستند . در صورتيكه رنگ جديد داراي حلال نسبتا ضعيف باشد كه نتواند به سطح اپوكسي گيرش يافته نفوذ يا آنرا نرم نمايد مشكل بيشتر مي شود . سازندگان اغلب به محدوده زماني رنگ زني مجدد اشاره دارند كه بعد از اين مدت ، رنگ زني مجدد مشكل است . اغلب توصيه مي شود سطح توسط بلاست&nbsp; سايشي يا ماسه اي زبر به صورت جزئي خشن شود معمولاً از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Applicator</span><span style=\"font-size:16.0pt\"> براي مالش دادن سطح با حلال قوي يا با اسپري كه چنين حلالي را روي اپوكسي مي پاشد براي نرم كردن جزئي آن قبل از رنگ بعدي استفاده مي نمايند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشكل ديگر مربوط به انواع خاصي از اپوكسي ، تنش است . تمام پوششها در موقع گيرش ، تمايل به انقباض دارند كه بويژه براي پوششهاي دو جزئي ترموست نظير اپوكسي ها درست است . اگر بهر دليل جلو انقباض پوشش گرفته شود تنش داخلي زيادي در آن ايجاد مي شود ممكن است در برابر تنشهاي اضافه تر محيطي نتواند مقاومت نمايد در نتيجه ترك يا انواع ديگر شكست در آن اتفاق بيفتد . </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بهر حال معمولاً اپوكسي ها براي آزاد كردن تنش ، منقبض مي شوند در صورتيكه اپوكسي روي زير لايه يا پوششهاي خاصي استفاده شود كه داراي استحكام پيوستگي ضعيفي باشد چون آزاد شدن تنش داخلي اپوكسي منجر به انتقال تنش به پوشش زيرين يا زير لايه مي شود اين مسأله مي تواند مشكل ساز باشد . اين تنش انقباض گاهي مي تواند منجر به شكست عمده پيوستگي (شكافته شدن) لايه زيرين شود . يك مثال كلاسيك در اين نوع شكست ، استفاده از اپوكسي دو جزئي پايه حلالي بعنوان پوشش نهايي روي پركننده هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">block</span><span style=\"font-size:16.0pt\"> وينيل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> روي ديواره هاي ساختماني&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي باشد . پركننده هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">block</span><span style=\"font-size:16.0pt\"> (داراي رنگدانه) استحكام پيوستگي ضعيفي دارند و نسبت به حلالهاي نسبتاً قوي در اپوكسي نيز حساس است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشكل ديگر اپوكسي داراي دانسيته بيشتر پيوند عرضي (يا هر پوشش با دانسيته زياد پيوند عرضي) ، تردي ذاتي آنهاست . معمولاً روي سطوح ضخيم ثابت نظير فولاد ساختماني سنگين اگر ضربه نخورد مشكلي ايجاد نمي شود ولي اگر زير لايه در </span><span dir=\"LTR\" style=\"font-size:14.0pt\">wind</span><span style=\"font-size:16.0pt\"> شديد ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">flex</span><span style=\"font-size:16.0pt\"> نمايد يا تحت تأثير انقباض و انبساط نيروهاي حرارتي قرار گيرد پوشش قادر به </span><span dir=\"LTR\" style=\"font-size:14.0pt\">flex</span><span style=\"font-size:16.0pt\"> با آن نخواهد بود . </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در اين حالت ، يكي از اين دو اتفاق بسته به مقدار چسبندگي به زير لايه ممكن است بيفتد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اگر پوشش چسبندگي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">marginal</span><span style=\"font-size:16.0pt\"> به زير لايه داشته باشد تنش سادگي با جدايش پوشش از زير لايه آزاد مي شود . اگر پوشش نازك (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">mil</span><span style=\"font-size:16.0pt\"> 2-1) باشد ممكن است بصورت پوسته هاي كوچك جدا شود (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">come off</span><span style=\"font-size:16.0pt\">) اگر ضخيم (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">mil</span><span style=\"font-size:16.0pt\">&nbsp; 5</span><span dir=\"LTR\" style=\"font-size:14.0pt\">&gt;= </span><span style=\"font-size:16.0pt\">&nbsp;) باشد بصورت قطعات بزرگ جدا شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هيچ كدام از انتخاب ها مطلوب نيست .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشكل احتمالي ديگر در مورد اپوكسي ها يا هر پوشش ديگر كه عمر پس از مخلوط فقط چند ساعته دارند به كارگيري پوشش در نزديكي انتها يا اندكي پس از اين زمان است . مهم است بخاطر بسپاريم كه واكنش رزين اپوكسي و پيوند دهنده هاي عرضي بلافاصله پس از مخلوط كردن دو جزء شروع مي شود . تركيب&nbsp; شيميايي رنگ در ظرف ، مدام تغيير مي كند و رنگي كه دو ساعت پس از مخلوط كردن زده شود در مقياس ملكولي مشابه رنگي كه دو دقيقه پس از مخلوط كردن اعمال شود نيست . بيشترين اختلاف بين رنگ &laquo;دو دقيقه اي&raquo; و &laquo;دو ساعتي&raquo; ، وزن ملكولي و ويسكوزيته است . اين دوعامل مرتبط اثرات مهمي برسيلان و خيس كردن پوشش دارند . هر چند تشكيل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">incipient</span><span style=\"font-size:16.0pt\"> فيلم سه جزئي داراي پيوند عرضي احتمالاً منجر به افزايش كشش سطحي مي شود اگر روي سطح فلزي زده شود كشش سطحي پوشش ، هنوز كمتر از زير لايه است و خيس كردن به صورت تئوري اتفاق مي افتد . با اين حال ، مقاومت در برابر سيلان در نتيجه افزايش و يسكوزيته هنوز مانع از خيس كردن زير لايه توسط پوشش مي باشد . كاملاً ممكن است كه نواحي خاصي داراي چسبندگي ضعيف بسادگي بعلت طول دوره زماني از مخلوط كردن تا زدن رنگ وجود داشته باشد . توضيح بالا در مورد انواع شكست با اين فرض است كه اعمال رنگ ، ايرادي نداشته باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">عقيده عمومي از جمله نويسنده بر اين است كه عمده شكست رنگها در اثر خطاهاي نقاش است با اين حال اين عقيده با مشاهدات&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">piecemeal</span><span style=\"font-size:16.0pt\">&nbsp;&nbsp; و تجربيات خاص ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Glean</span><span style=\"font-size:16.0pt\">&nbsp; شده است و كوشش براي اطلاق درصد واقعي به تعدا شكست هاي ناشي از نقاش ، كاملاً فرضي است . براساس تجربيات نويسنده مطمئناً بيش از نصف تمام شكست پوششها مربوط به نقاش است . اپوكسها بواسطه همان خطاهاي نقاش كه بر كارائي ديگر پوششها اثر مي گذارد شكست مي خورند . پوششهاي مدرن با كارايي بالا نسبت به پوششهاي ساده نظير الكيدهاي پايه روغني ، كمتر به نقاش </span><span dir=\"LTR\" style=\"font-size:14.0pt\">FORGIVING</span><span style=\"font-size:16.0pt\"> هستند . آماده سازي سطح ضعيف رقيق كردن بيش از حد ، تفنگ اسپري ضعيف ، آلودگي يا رنگ زدن موقعي كه هوا بيش از اندازه گرم ، سرد يا مرطوب است يا اينكه پوشش ، بيش از اندازه نازك يا ضخيم باشد مي تواند منجر به شكست اپوكسي شود بعلاوه در پوششهاي دو جزئي خطاي خاص مربوط به نقاش وجود دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يكي از متداولترين اين خطاها ، مخلوط كردن نادرست اپوكسي است كه در پوششهاي اپوكسي گيرش يافته با آمين كه نسبت مخلوط بين دو جزء ،&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">DIS PARTE</span><span style=\"font-size:16.0pt\"> نظير 10 قسمت جزء </span><span dir=\"LTR\" style=\"font-size:14.0pt\">A</span><span style=\"font-size:16.0pt\"> به 1 قسمت جزء </span><span dir=\"LTR\" style=\"font-size:14.0pt\">B</span><span style=\"font-size:16.0pt\"> است محتمل تر مي باشد . احتمال خطاهاي مخلوط كردن در پوششهايي كه نسبت مخلوط ساده نظير 1=1 يا 1=2 دارند چندان زياد نيستند . با اين حال نويسنده بيش از يك مورد شكست پوشش مشاهده نموده كه ناشي از اضافه كردن يكي از اجزاء پيونده دهنده عرضي (يا مبدل) بوده است . در موقع آناليز پوشش اپوكسي از نظر خطاهاي احتمالي در مخلوط كردن دو مورد بايستي دقت شود : اول اينكه چون پوشش در محل (كارگاه)و نه آزمايشگاه مخلوط مي شوند انحرافات جزئي از نسبت مخلوط ايده آل ، محتمل مي باشد . اگر پوشش به گونه اي است كه بايستي با نسبت دقيق 00/1 گالن جزء </span><span dir=\"LTR\" style=\"font-size:14.0pt\">A</span><span style=\"font-size:16.0pt\"> با 00/1 گالن جزء </span><span dir=\"LTR\" style=\"font-size:14.0pt\">B</span><span style=\"font-size:16.0pt\"> مخلوط شود و گرنه شكست اتفاق خواهد افتاد تجاري بودن اين محصول ، جاري سؤال دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">عامل دوم هنگام بررسي مخلوط شدن ناصحيح رنگ مورد نظر اين است كه آيا سازنده رنگ را به صورت صحيح توليد نموده است يا نه . اينكه پوشش ، رزين كمتري نسبت به مقدار مورد نظر دارد لزوماً به اين معني نيست كه نقاش مقصر است . اشتباه ممكن است در كارخانه سازنده اتفاق افتاده باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">خطاهاي ديگر اعمال اپوكسي ، عدم رعايت زمان </span><span dir=\"LTR\" style=\"font-size:14.0pt\">INDUCTION</span><span style=\"font-size:16.0pt\"> (كه ممكن است </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BLUSHING</span><span style=\"font-size:16.0pt\"> يا شكست چسبندگي ميان لايه اي ايجاد نمايد) به كارگيري پوشش در يا خارج از محدوده زماني مجاز پس از مخلوط كردن (كه منجر به شكست چسبندگي مي شود)و اعمال رنگ بعدي در خارج از محدودة زماني مجاز (كه احتمالاً منجر به شكست چسبندگي ميان لايه اي مي شود) مي باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950956\"></a><a name=\"_Toc460950849\">5 . 4 اپوكسي هاي اصلاح شده :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">شيمي اپوكسي بسيار انعطاف پذير است و انواع عوامل گيرشي و مسيرهاي واكنش ، بقدري بيشمار است كه نمي توان همه را در كتاب حاضر آورد . با اين حال چند كلاس مهم اپوكسي هاي اصلاح شده كه محقق شكست پوشش احتمالاً با بيشتر آنها برخورد خواهد داشت در اينجا گفته مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950957\"></a><a name=\"_Toc460950850\">5 . 4 . 1 اپوكسي هاي اكريليك :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">كلمه اپوكسي اكريليك ممكن است </span><span dir=\"LTR\" style=\"font-size:14.0pt\">INCONGRUOUS</span><span style=\"font-size:16.0pt\"> به نظر برسد چون اكريليك ها اغلب به عنوان پوششهاي پايه آبي نرم و اپوكسي ها به عنوان پوششهاي پايه حلالي سخت در نظر گرفته مي شوند . همچنانكه سه عضوي اپوكسي تمايل زيادي به گروههاي عامل داراي هيدروژن فعال دارد ممكن است با اسيدهاي كربوكسيليك نيز واكنش دهد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اگر گروه اسيدكربوكسيليك به رزين اكريليك متصل باشد اپوكسي اكريليك ايجاد شده است . اين پوشش براي گيرش كامل نياز به كاتاليست و پخت در دماي نسبتاً بالا دارد. چنين پوششهايي داراي خواص بين اكريليك و اپوكسي هستند و تمايل به سختي ، چسبندگي و مقاومت سايشي بهتري نسبت به اكريليك و پايدار در برابر نور و انعطاف پذيري بهتر نسبت به اپوكسي ها دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950958\"></a><a name=\"_Toc460950851\">5 . 4 . 2 اپوكسي هاي قطران :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اپوكي هاي قطران گروه مهمي از اپوكسي ها هستند كه&nbsp; بخاطر خواص ممانعت خوب، مقاومت نسبتاً خوب شيميايي و رطوبت و قيمت نسبتاً ارزان بصورت گسترده در صنايع آب و&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">SEWAGE</span><span style=\"font-size:16.0pt\"> استفاده مي شوند . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PITCH</span><span style=\"font-size:16.0pt\"> هاي قطران تصفيه شده با نسبت تقريبي دو يا سه برابر مقدار اپوكسي / پيوند دهنده عرضي استفاده مي شوند . قطران و عوامل پيوند دهنده عرضي به صورت يك جزء درآمده ، رزين اپوكسي جزء دوم را تشكيل مي دهد . بسياري از عوامل گيرشي كه قبلاً توضيح داده شد مي توانند استفاده شوند . هر چند مقدار قطران بالاتر باشد منجر به پوششهاي نرمتر با گيرش آهسته تر و با مقاومت شيميايي و حلالي كمتر مي شود در حاليكه اپوكسي بيشتر منجر به پوشش تردتر ، سخت تر و گيرش سريعتر مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">خواص اپوكسي ها اصلاح نشده ناشي از عوامل گيرش مختلف در اپوكسي هاي قطران نيز قابل مشاهده است آمين ها پوشش با گيرش سريعتر و فيلم سخت تر مقاومتر به سايش داراي مقاومت شيميايي ايجاد مي كنند در حاليكه سيستم هاي پلي آميد معمولاً انعطاف پذيري و خواص خيس كنندگي بهتري ايجاد مي كنند . در فاضلابها ، مزيت ديگر آمين ها ، مقاومت بهتر در برابر سولفيد هيدروژن و باكتريها است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اپوكسي هاي قطران معمولاً به رنگ سياه هستند و مقاومت ضعيفي در برابر ماوراء بنفش داشته در برابر نورخورشيد ، برنزه مي شوند . همچنين رنگ زدن مجدد آنها بسيار مشكل است بنابراين معمولاً بايستي به صورت يك پوشش ضخيم زده شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950959\"></a><a name=\"_Toc460950852\">5 . 4 . 3 فنوليكهاي اپوكسي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي فنوليك با واكنش فنل (شكل 5-11) يا فنل جانشيني با فرمالدئيد (شكل 5-22) براي ايجاد ساختاري مطابق شكل 5-23 ايجاد مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">گروه هيدروكسيل فنوليك ، نسبتاً فعال است و وقتي با اپي كلرور و هيدرين (شكل 5-24)يكي از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PRECURSOR</span><span style=\"font-size:16.0pt\"> هاي رزين اپوكسي ، واكنش&nbsp; دهد گروه عامل اپوكسي در شاخه اصلي رزين فنوليك ، شاخه دار مي شود . پوششهايي كه از اين رزين ها ساخته شوند چسبندگي در نوع دگر پوششهاي عالي و داراي دانسيته پيوند عرضي بالا هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">دو نوع ديگر پوششهاي فنوليك اپوكسي ، رزين فنوليك ممكن است عامل پيوند عرضي در نظر گرفته شود و از طريق گروه هيدروكسي فنوليك خود (در موردي نووالاك هاي فنوليك) با حلقه اپوكسي روي رزين اپوكسي واكنش دهد . اين نوع پوشش بهترين سيستم موجود از نظر مقاومت شيميايي با چسبندگي عالي مي باشد كه معمولاً به پخت در محدوده204-149 درجه سانتيگراد براي رسيدن به خواص بهينه نياز دارد و اغلب در مواردي كه تماس شيميايي طولاني مدت ضروري است نظير پوشش تانكرهاي راه آهن به كار مي رود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950960\"></a><a name=\"_Toc460950853\">5 . 5 فنوليكها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي فنوليك توسط واكنش فرمالدئيد با فنل يا فنولهاي جانشيني توليد مي شوند. وقتي واكنش تحت رايط قليايي انجام شود رزين به نام فنوليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">RESOLE</span><span style=\"font-size:16.0pt\"> ناميده&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود و وقتي تحت شرايط اسيدي انجام شود فنوليكهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">NOVALAC</span><span style=\"font-size:16.0pt\"> ناميده&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950961\"></a><a name=\"_Toc460950854\">5 . 5 . 1 فنوليك هاي </a><span dir=\"LTR\" style=\"font-size:14.0pt\">RESOLE</span>&nbsp; :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">ساختار كلي فنوليك هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">RESOLE</span><span style=\"font-size:16.0pt\"> كه از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">RESOLE</span><span style=\"font-size:16.0pt\"> تهيه مي شوند در شكل&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 5-23 نشان داده شده است ديگر فنل جانشيني كه معمولاً استفاده مي شود متيل فنل و بوتيل فنل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">P-TERTIARY</span><span style=\"font-size:16.0pt\"> است . بسته به شرايط واكنش ، بعضي از مونومرهاي فنوليك با پل اتري (-</span><span dir=\"LTR\" style=\"font-size:14.0pt\">CH2-O-CH2</span><span style=\"font-size:16.0pt\">-) بجاي پل متيلن ، پيوند عرضي ايجاد مي كنند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بسته به مواد خام استفاده شده و مقدار واكنش ، دو نوع فرعي مختلف </span><span dir=\"LTR\" style=\"font-size:14.0pt\">RESOLE</span><span style=\"font-size:16.0pt\"> ممكن است توليد شود يكي آنهايي كه در حلالهاي اكسيژنه حل مي شوند (فنوليك هاي قابل حل در الكل) و آنهايي كه در حلالهاي هيدروكربني قابل حل هستند (فنوليكهاي قابل حل در روغن)</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي فنوليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">RESOLE</span><span style=\"font-size:16.0pt\"> قابل حل در الكل براي گيرش نياز به پخت ، معمولاً در حضور كاتاليست اسيدي دارند . تحت اين شرايط رزين از طريق واكن بين گروههاي هيدروكسيل فنوليكي يا بين اين گروههاي هيدروكسيل و گروههاي متيول خود بخود متراكم مي شود . در اين فرآيند اتصال اتري اتفاق مي افتد و آب يا فرمالدئيد آزاد&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چون تمام اتصالهاي پوشش فنوليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">RESOLE</span><span style=\"font-size:16.0pt\"> پخته شده يا از نوع متيلن و يا اتري هستند هيچ چيز براي هيدروليز وجود ندارد . اين پوششها در برابر آب و قلياها بسيار مقاومند . بخاطر پايداري اين اتصالات همراه با دانسيته پيوند عرضي بالا ، اين پوششها مقاومت شيميايي عالي و نفوذ پذيري كم دارند كه باعث مقاومت شيميايي عالي&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي گردد . چسبندگي نيز كاملاً خوب است . چنين پوششهايي براي تانكها در شرايط شيميايي سخت و نيز براي پوشش ظروف صنايع غذايي و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">beverage</span><span style=\"font-size:16.0pt\"> به كار مي رود . با اين حال بخاطر دانسيته پيوند عرضي بالا تمايل به تردي و اغلب نياز به نرم كننده دارند . بخاطر آروماتيك بودن ، ممكن است حين پخت يا تماس با نور خورشيد بطور قابل ملاحظه تيره شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يكي از استفاده هاي اصلي فنوليك هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Resole</span><span style=\"font-size:16.0pt\"> قابل حل در نفت توليد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">varnish</span><span style=\"font-size:16.0pt\"> هاي با كيفيت بالا است . فنوليكها گاهي پر از اولين اصلاح با </span><span dir=\"LTR\" style=\"font-size:14.0pt\">rosin</span><span style=\"font-size:16.0pt\"> ، با روغن بزرك يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">tung</span><span style=\"font-size:16.0pt\"> پخت مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950962\"></a><a name=\"_Toc460950855\">5 .2 .2 فنوليكهاي </a><span dir=\"LTR\" style=\"font-size:14.0pt\">novalac</span> :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">فنوليكهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">novalac</span><span style=\"font-size:16.0pt\"> ساختار كلي مطابق شكل 5-23 دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي فنوليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">novalac</span><span style=\"font-size:16.0pt\"> يا بدون گروه عامل متيول يا داراي گروه عامل متيول كمي هستند و معمولاً بصورت خودبخود متراكم نخواهند شد . چنين رزينهايي ترموپلاستيك هستند . آنها معمولاً در الكل يا حلالهاي ديگر اكسيژنه قابل حل هستند ولي اگر از بوتيل فنل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">p-tertiary</span><span style=\"font-size:16.0pt\"> تهيه شود حلاليت در هيدروكربنها ايجاد مي شود . بصورت تنهايي بعنوان پوشش كمتر كاربرد دارند با اينحال تا حدي در توليد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">varnish</span><span style=\"font-size:16.0pt\"> استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950963\"></a><a name=\"_Toc460950856\">5 . 5 . 3 انواع شكست فنوليكها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">دو تا از بزرگترين مشكلات فنوليك ها تردي و مشكلات مربوط به پخت آنها است . تردي نتيجه ساختار آروماتيك صلب و دانسيته بالاي پيوند عرضي آنها است . توسط نرم كننده هاي خارجي مي توان تا حدي اين مشكل را </span><span dir=\"LTR\" style=\"font-size:14.0pt\">ameliorate</span><span style=\"font-size:16.0pt\"> نمود يا تا حد كمتري با استفاده از گروههاي هيدروكربني طويلتر در مونوفنوليك جايگزين شده اين مشكل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">ameliorate</span><span style=\"font-size:16.0pt\"> مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در محيط كنترل شده كارخانه ، مشكلات ناشي از حرارت پوشش فيلم نازك ظروف نسبتاً نادر است . با اين حال گاهي اگر پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">higher&nbsp; build</span><span style=\"font-size:16.0pt\"> براي ظروف بزرگ نگهداري يا تانك راه آهن استفاده شود اين ظروف ، مشكل ساز است . اغلب از منابع حرارتي قابل حمل در چنين مواردي استفاده مي شوند و كنترل دمايي دقيق ثابت گاهي مشكل است . چون حين پخت ، فنوليكها تيره مي شوند مقدار تغيير رنگ براي تعيين گيرش كافي استفاده مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950964\"></a><a name=\"_Toc460950857\">5 . 6 آمينو رزين ها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزينهايي كه در اين قسمت توضيح داده مي شوند گاهي به نام آمينو رزين ها شناخته مي شوند و داراي خواص فيزيكي مناسبي كه بواسطة آنها تشكيل پوشش بدهند نيستند. با اينحال به عنوان پيوند دهنده عرضي با بسياري از رزين ها ، كاربرد گسترده اي دارند . بجاي توصيف آنها بصورت&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">pecemeal</span><span style=\"font-size:16.0pt\"> در فصل هاي بعدي ، در اينجا به صورت يك گروه معرفي مي شوند . امينو رزين ها معمولاً حدود 30درصد يا كمتر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">vwhicle</span><span style=\"font-size:16.0pt\"> غير فرار پوششهاي ترموست مختلف را تشكيل مي دهند و عامل عمده پيوند عرضي چنين پوششهايي هستند كه مي توانند با اكريليك ها ، پلي استرها ، الكيدها ، استرهاي اپوكسي و حتي اپوكسيها به كار بروند . برخلاف پوششهاي اپوكسي ترموست كه در قسمت قبلي توضيح داده شد پوششهاي ترموستي كه با آمينورزين ها پيوند عرضي ايجاد نموده اند تقريباً هميشه بجاي دو جزئي بودن ، تك جزئي هستند . اين امر بخاطر سرعت بينهايت پايين واكنش در دماي كم امكان پذير است و به منظور گيرش بايستي پخت شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">متداولترين آمينورزين هاي مورد استفاده ، پايه ملامين يا 2 ، 4 ، 6 </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> تري آمينو </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> 1 ، 3 ، 5 </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\">تري آزين (شكل 5-25) هستند . سه گروه اوليه آمينورزين هاي روي ملامين ، آنرا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">precueser</span><span style=\"font-size:16.0pt\"> بسيار انعطاف پذير مي سازد . ملامين خالص به تنهايي به عنوان عامل پيوند عرضي نيست بلكه با فرمالدئيد و الكل واكنش مي دهد . اولين قدم واكنش با فرمالدئيده منجر به ايجاد ملامين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">methyolate</span><span style=\"font-size:16.0pt\"> مي شود . ساختار ملامين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">methyolated</span><span style=\"font-size:16.0pt\"> (ملامين هگزامتيول) در شكل 5-26 آمده است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بسته به نسبت استيوكيوتري ملامين به فرمالدئيد ، ممكن است ملامين كاملاً </span><span dir=\"LTR\" style=\"font-size:14.0pt\">methyolated</span><span style=\"font-size:16.0pt\"> ايجاد نشود . مرحله بعدي درتوليد رزين فرمالدئيد ملامين &laquo;اتري شدن&raquo; ناميده مي شود كه شامل واكنش با الكل داراي وزن ملكولي پايين (معمولاً متيل يا بوتيل الكل) است . بسته به مقدار </span><span dir=\"LTR\" style=\"font-size:14.0pt\">methyolation</span><span style=\"font-size:16.0pt\"> ملامين اوليه ، نوع الكل و نسبت ملامين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">methyolated</span><span style=\"font-size:16.0pt\"> به الكل ، انواع مختلف رزين هاي مفيد پيوند عرضي فرمالدئيد ملامين توليد خواهد شد . يكي از متداولترين آنها ، هگزا متوكسي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> متيل ملامين (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">HMMM</span><span style=\"font-size:16.0pt\">)(شكل 5-27) است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">علاوه بر واكنش اتري شدن بين گروههاي متيول و الكل (كه در مورد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">HMMM</span><span style=\"font-size:16.0pt\"> متانول است) ممكن است تراكم خودبخود (اتري شدن خودبخود) تا حدي بين گروه متيول دو ملكول مجاور ملامين متيول اتفاق بيفتد . تشكيل مقدار كمي دي مر حين توليد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">HMMM</span><span style=\"font-size:16.0pt\"> يا ديگر رزين هاي ملامين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> فرمالدئيد غير معمول نيست .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي بنزوگوامين (شكل 5-28) شايد گروه بعدي عوامل پيوند عرضي آمينو داراي بيشترين استفاده باشند . شبيه ملامين ، بنزوگوامين نيز برپايه تري آزين ايجاد&nbsp;&nbsp; مي شود . بنز و گوامين با ملامين فقط در جابجايي يكي از گروههاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">NH2</span><span style=\"font-size:16.0pt\"> - با گروه فنيل تفاوت دارد . همان نوع واكنش با فرمالدئيد و الكل را كه ملامين دارد بنزو- گوآمين هم دارد كه منجر به عوامل پيوند عرضي مشابه ولي با تعداد گروه عامل كمتر مي گردد . اوره (شكل 5-29) نيز مي تواند با فرمالدئيد براي ايجاد مشتقات متيول واكنش دهد . اين مشتقات شبيه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">coubter part</span><span style=\"font-size:16.0pt\"> هاي ملامين و بنز و گوآمين آن بعداً با الكل ، اتري شده ، تشكيل رزين هاي پيوند عرضي اوره </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> فرمالدئيد مي دهند . شبيه رزين ملامين و بنز و گوآمين براي توليد دي مر مقداري تراكم خودبخود اتفاق&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي افتد. گروه ديگر آمينورزين ها برپايه گيكلوريل (شكل 5-30) تشكيل مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">گيگلوريل با فرمالدئيد براي تشكيل تترا متيول گليكويوريل (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">TMGU</span><span style=\"font-size:16.0pt\">) واكنش&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي دهد. برحسب </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PH</span><span style=\"font-size:16.0pt\"> واكنش آنالوگ هاي متوسط </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Lower methyolated</span><span style=\"font-size:16.0pt\"> يا محصولات تراكم خودبخود ايجاد خواهد شد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">واكنش اتري شدن كه قبلاً بين آمينورزين هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">methyolated</span><span style=\"font-size:16.0pt\"> ديگر و الكل اشاره شد براي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TM GU</span><span style=\"font-size:16.0pt\"> نيز اتفاق مي افتد كه منجر به ايجاد رزين هاي گليكويوريل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> فرمالدئيد مي شود . تترامتوكسي متيل گليكويوريل جامدي است كه به عنوان پيوند دهنده عرضي در پوششهاي پودري خاص استفاده مي شود . رزين هاي اتري مخلوط شده نظير دي متوكي متيل دي اتوكسي متيل گليكوريل مايع هستند و در پوشش دهي ظروف و كويلها براي ايجاد انعطاف پذيري بالاتر از بسياري آمينورزين هاي ديگر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">}</span><span style=\"font-size:16.0pt\">1</span><span dir=\"LTR\" style=\"font-size:14.0pt\">{</span><span style=\"font-size:16.0pt\"> به كار&nbsp;&nbsp;&nbsp; مي رود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950965\"></a><a name=\"_Toc460950858\">5 . 7 . اكريليك ها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">دقيقتر ين تعريف رزين اكريليك هر رزين است كه از مشتقات اسيد اكريليك (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">CH2 = CH = COOH</span><span style=\"font-size:16.0pt\">) تشكيل شده باشد . اين تعريف ساده ، انواع پيچيدگي&nbsp; رزين هاي اكريليك را </span><span dir=\"LTR\" style=\"font-size:14.0pt\">belies</span><span style=\"font-size:16.0pt\"> مي نمايد كه در كاربردهاي متنوعي نظير پلاستيكها ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">caulks and sealants fabrics</span><span style=\"font-size:16.0pt\"> ، رنگهاي ساختماني </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> و پوششهاي ترموست با كارايي بالا استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">جدول 5-2 ساختار بعضي از مونومرهاي متداول اكريليك كه در پوشش استفاده&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود مي باشد . هر چند استايرن ممكن است مشتقي از اسيد اكريليك در نظر گرفته شود . بخاطر استفاده گسترده از آن در بسياري از اكريليك ها ، در جدول ذكر شده است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي اكريليك از مونومرهاي اكريليك با واكنش افزودن راديكال آزاد كه در محل پيوند دو گانه كربن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\">كربن اتفاق مي افتد ايجاد مي شود . انواع تقريباً بيشماري از پليمرها بسته به مونومر استفاده شده ، نسبت آنها و شرايط واكنش ساخته مي شود . پوششهاي اكريليك به صورت وابسته به يكي از سه گروه اكريليك هاي محلولي ، پوششهاي اكريليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> و اكريليك هاي ترموست در نظر گرفته مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950966\"></a><a name=\"_Toc460950859\">5 . 7 . 1 اكريليك هاي محلولي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اكريليك هاي محلولي كه به لعابهاي اكريليك نيز معروفند اولين گروه پليمرهاي اكريليك هستند كه بعنوان پوشش استفاده شدند . چون پوششهاي تك جزئي و ترموپلاستيك هستند كه فقط به واسطه تبخير حلال ، خشك و گيرش مي يابند به نام لعابهاي اكريليك نيز معروفند . روي اثاثيه و قبلاً به مقدار زياد براي پوشش اتومبيلها استفاده مي شدند . كاربرد آنها در صنايع اتومبيل سازي امروزه عمدتاً محدود به بازار </span><span dir=\"LTR\" style=\"font-size:14.0pt\">refinishing</span><span style=\"font-size:16.0pt\"> است . همچنين به صورت گسترده در </span><span dir=\"LTR\" style=\"font-size:14.0pt\">aerosol</span><span style=\"font-size:16.0pt\"> هاي اكريليك براي استفاده مشتريان عرضه مي گردد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چون اكريليك هاي محلولي پيوند عرضي ايجاد نمي كنند خواص فيزيكي و شيميايي آنها بايستي در زمان ساخت ايجاد گردد . وزن ملكولي نسبتاً بالا (معمولاً 75000 يا بالاتر) و در نتيجه داراي مقدار جامد كم براي رسيدن به وسيكوزيته لازم براي كاركردن مي باشند . علاوه بر وزن ملكولي ، خاصيت مهم ديگر اكريليك محلولي ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> آن است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> تعاريف مختلفي دارد كه تقريباً تمام آنها معروفند . متداولترين تعريف در صنعت پوشش عبارتست از اينكه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> دمايي است كه زير آن ، پليمر ترد و شيشه اي و بالاي آن نرم و لاستيك مانند است تعريف مفيد ديگر اين است كه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> دمايي است كه افزايش ناگهاني غير پيوسته در حجم آزاد پليمر وجود دارد . حجم آزاد تقريباً مقدار فضاي قابل دسترسي براي اجزاء يا زنجيره هاي پليمر براي چرخش آزاد يا حركت به اطراف است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">با يك مثال مي خواهيم نشان&nbsp; دهيم كه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> براي لعابهاي اكريليك پارامتر مهمي است (** با متن اصلي چك شود) اگر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> پوشش خيلي كم باشد (چندين درجه زير دما اطاق) پوشش ، انعطاف پذير (يك چيز خوب) و نرم (يك چيز بد) خواهد بود و اجسام سنگين نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">bookend</span><span style=\"font-size:16.0pt\"> ها ممكن است به پوشش بچسبد . برعكس اگر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> بيش از اندازه بالا باشد پوشش ، سخت(يك چيز خوب) و ترد (يك چيز بد) خواهد بود و اجسام سنگين (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">bookend</span><span style=\"font-size:16.0pt\"> يك مثال خوب است) كه روي پوشش بيفتد بخوبي ممكن است باعث ترك برداشتن آن شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در پوشش ترموپلاستيك نظير اكريليك ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> تا حدي با وزن ملكولي قابل كنترل است. مثلاً </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> هومرپليمر متيل اكريلات 10 در جه سانتيگراد است در حاليكه براي هومرپليمر متيل متاسيلات 105 درجه سانتيگراد است </span><span dir=\"LTR\" style=\"font-size:14.0pt\">}</span><span style=\"font-size:16.0pt\">1</span><span dir=\"LTR\" style=\"font-size:14.0pt\">{</span><span style=\"font-size:16.0pt\">&nbsp; . معمولاً </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> يك خاصيت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">additive</span><span style=\"font-size:16.0pt\"> مشخصه نسبت مونومرهاي استفاده شده است . بنابراين پليمر ساخته شده از مخلوط 50/50 متيل اكريلات و متيل متاكريلات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> حدود 58 درجه سانتيگراد بايستي داشته باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بررسي ساختار رزين هاي اكريليك نشان مي دهد كه داراي گروههاي استرسي است . چنين گروههايي دچار هيدروليز قليايي يا صابوني شدن خواهند شد . با اينحال گروههاي استرسي ساختار اصلي پوششهاي اكريليك را تشكيل نمي دهند بلكه در عوض به آن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">pendant</span><span style=\"font-size:16.0pt\"> شده اند . هر چند لعاب اكريليكي ممكن است صابوني شود حاصل آن معمولاً به </span><span dir=\"LTR\" style=\"font-size:14.0pt\">disastrous</span><span style=\"font-size:16.0pt\"> صابوني شدن الكيد نيست . بعضي مزاياي لعاب هاي اكريليك شامل مقاومت خوب به ماوراء بنفش ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">gloss retention</span><span style=\"font-size:16.0pt\"> ، انعطاف پذيري و مقاومت خوب در برابر قلياها است . معايب آن ، مشكل در بدست آوردن پوشش داراي رنگدانه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">high &ndash; gloss</span><span style=\"font-size:16.0pt\"> ، چسبندگي نسبتاً ضعيف ، مقاومت حلالي بسيار ضعيف و مقدار </span><span dir=\"LTR\" style=\"font-size:14.0pt\">voc</span><span style=\"font-size:16.0pt\"> بالا است . لعابهاي اكريليك امروزه نسبت به 10 سال قبل ، مشتري كمتري دارد . محدود شدن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">voc</span><span style=\"font-size:16.0pt\"> احتمالاً آنها را از دور خارج خواهند نمود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950967\"></a><a name=\"_Toc460950860\">5 . 7 . 2 پوششهاي اكريليك </a><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span> :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اكريليك هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> به مقدار فراوان در صنعت رنگ استفاده مي شود . اينها اساس پوششهاي ساختماني را تشكيل و امروزه در حوزه تعمير و نگهداري صنعتي سهم قابل&nbsp; ملاحظه اي دارد . داراي اين مزيت قابل ملاحظه است كه داراي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">voc</span><span style=\"font-size:16.0pt\"> بسيار كم (حلال اصلي آنها آب است) بدون داشتن وزن ملكولي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">sacrifice</span><span style=\"font-size:16.0pt\"> مي باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> عمدتاً ذرات ريز پليمري پراكنده (فاز ناپيوسته) در آب (فاز پيوسته) است . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> معمولاً با فرايندي بنام پليمريزاسيون امولسيون ساخته مي شود . در اين نوع پليمريزاسيون ، مقادير نسبتاً زيادي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">surfacant</span><span style=\"font-size:16.0pt\">ها مخلوط و در آب داغ بهم زده&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شوند . وقتي غلظت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">surfacant</span><span style=\"font-size:16.0pt\"> ها از حدي كه بنام غلظت بهراني </span><span dir=\"LTR\" style=\"font-size:14.0pt\">micelle</span><span style=\"font-size:16.0pt\"> (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">MC</span><span style=\"font-size:16.0pt\">) است تجاوز نمايد . بصورت كره هاي مجزا يا ذراتي بنام </span><span dir=\"LTR\" style=\"font-size:14.0pt\">micelle</span><span style=\"font-size:16.0pt\"> در مي آيند . انتهاي هيدروفوبيك آنها به سمت داخل و سر هيدروفيليك آنها به سمت خارج قرار&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي گيرد. در داخل كره ، محيط غني از كربن رسانا براي حل ملكولهاي آبي وجود دارد: وقتي مونومرهاي اكريليك به اين مخلوط سورفساتها و آب اضافه شود همراه با آغاز كننده هاي پليمريزاسيون به داخل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">micelles</span><span style=\"font-size:16.0pt\"> نفوذ و تشكيل پليمر شروع خواهد شد. يكي از مزاياي اين نوع سيستم اين است كه وسيكوزيته آن بستگي عمده به فاز پيوسته (آبي) دارد . پليمرهاي داراي وزن ملكولي بسيار بالا (چند صد هزار) مي توانند در </span><span dir=\"LTR\" style=\"font-size:14.0pt\">micelle</span><span style=\"font-size:16.0pt\">ها تشكيل شوند بدون افزايش ويسكوزيته سيستم .مشابه اكريليك هاي محلولي ، خواص پليمر نهايي با انتخاب </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Judicious</span><span style=\"font-size:16.0pt\"> مونومرها و شرايط واكنش كنترل مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اينكه پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> چگونه تشكيل فيلم مي دهند هنوز تحت بررسي هاي قابل ملاحظه اي قرار دارد . عقيده كلي بر اين است كه اين عمل يك فرآيند چند مرحله اي است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">&nbsp;اولين مرحله ، تبخير آب است كه به ذرات مجزاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> اجازه تماس فيزيكي&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي دهد . قدم بعدي كه توسط </span><span dir=\"LTR\" style=\"font-size:14.0pt\">incorporation</span><span style=\"font-size:16.0pt\"> مقادير كم </span><span dir=\"LTR\" style=\"font-size:14.0pt\">co-solvent</span><span style=\"font-size:16.0pt\"> (حلالهاي)آلي يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">coalscling</span><span style=\"font-size:16.0pt\"> (وسايل تجمعي) انجام مي شود ذوب ذرات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> در همديگر است . قدم نهايي ، تبخير آب باقيمانده و با گذشت زمان ، تبخير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">co-solvent</span><span style=\"font-size:16.0pt\">ها است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">تجمع ذرات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> در حصول خواص پوشش ، بحراني است . دو عامل مهم در حصول خواص رطوبت و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> امولسيون اكريليك است . براي تجمع ، ذرات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> بايستي در تماس نزديك با هم قرار گيرند كه تا زمانيكه بيشتر آب از پوشش تبخير نشود اتفاق نخواهد افتاد سرعت تبخير آب در شرايط مرطوب بسيار كمتر از شرايط خشك است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وقتي ذرات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> در تماس نزديك با هم قرار گرفتند در صورتيكه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex Tg</span><span style=\"font-size:16.0pt\"> به طور قابل ملاحظه اي بالاتر از دماي محيط باشد تجمع اتفاق نخواهد افتاد . در اين حالت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> به صورت شيشه اي با حجم آزاد كم و حركت ملكولي محدود خواهد بود . فيلم هاي ايجاد شده در اين شرايط ، استحكام پيوستگي كم و نفوذ پذيري بالا دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">معمولاً حصول پوشش نهايي با </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> چند&nbsp; درجه بالاتر از دماي محيط مطلوب است . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> كه پايين تر از دماي محيط باشد پوشش را نرم و چسبناك و متخلخل خواهد كرد . پنجره ها به </span><span dir=\"LTR\" style=\"font-size:14.0pt\">window sill</span><span style=\"font-size:16.0pt\">ها خود خواهند چسبيد ، رنگهاي خانگي كثيفي ها را جذب و در خود نگاه خواهد داشت و پوششهاي فلزي به رطوبت و احتمالاً مواد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">deleterious</span><span style=\"font-size:16.0pt\"> ديگر اجازه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">ingress</span><span style=\"font-size:16.0pt\"> آسان خواهند داد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يك روش براي حل اين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">conundrum</span><span style=\"font-size:16.0pt\"> با كمك وسايل تجمعي است كه داراي نقش دوتايي نرم كننده هاي فرار است . حين تشكيل فيلم ، وسايل تجمعي يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">co-solvent</span><span style=\"font-size:16.0pt\"> آلي براي حل ونرم كردن ذرات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> تجمعي كمك مي كند . بنابراين&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> آنها را تا زير دماي محيط </span><span dir=\"LTR\" style=\"font-size:14.0pt\">depress</span><span style=\"font-size:16.0pt\"> مي نمايد . با اينحال حين يك يا دو روز پس از زنگ زدن ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">co-solvent</span><span style=\"font-size:16.0pt\"> بصورت عمده تبخير شده و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> فيلم خشك شده حالا بيشتر از دماي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">prevailing</span><span style=\"font-size:16.0pt\"> محيط است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">دو مونومري كه بصورت روتين براي افزودن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> استفاده مي شود متيل متاسيلات (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> هوموپليمر 105 درجه سانتيگراد) است و استايرن (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> هوموپليمر 100 درجه سانتيگراد است )مي باشند . متيل متاسيلات باعث دوام </span><span dir=\"LTR\" style=\"font-size:14.0pt\">exterior</span><span style=\"font-size:16.0pt\"> و گروه متيل ، هيدروليز را بواسطه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">hindrance</span><span style=\"font-size:16.0pt\"> استئاريك مشكل تر مي نمايد . همچنين استايرن بخاطر اينكه هيچ اتصال استري ندارد كه هيدروليز انجام دهد مقاومت خوبي در برابر هيدروليز ايجاد مي نمايند هر چند در تماس با نور خورشيد ممكن است باعث زرد شدن و تخريب گردد . اغلب در آسترهاي براي بهبود سختي ، مقاومت در برابر آب و نفوذپذيري كمتر از استايرن استفاده مي شود . پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> اكريليك ، اساس بازار رنگهاي ساختماني وپوششهاي معماري را تشكيل مي دهند . دو مزيت بزرگ براي مشتري دارند : بوي كم و راحت تميز شدن با آب . مزيت بزرگ در </span><span dir=\"LTR\" style=\"font-size:14.0pt\">arena</span><span style=\"font-size:16.0pt\"> منظم ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">voc</span><span style=\"font-size:16.0pt\"> بينهايت كم است . وقتي اولين بار ، رنگهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> به بازار فرستاده شدند در مقايسه با رنگهاي پايه روغن </span><span dir=\"LTR\" style=\"font-size:14.0pt\">inferior tried and true</span><span style=\"font-size:16.0pt\"> بودند ولي بهبودهاي سريع در تكنولوژي ، به سرعت اين فاصله را پوشانيد . علاوه بر مزاياي كاربردي و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">voc</span> <span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> هاي اكريليك ، نسبت به رنگهاي پايه روغني ، تمايل به </span><span dir=\"LTR\" style=\"font-size:14.0pt\">breathable</span><span style=\"font-size:16.0pt\"> بيشتري دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\">آنها به رطوبت داخل قطعه اجازه نفوذ راحت از ميان پوشش را مي دهند بنابراين نسبت به محصول پايه روغني ، تمايل كمتري به تاول زدن دارند .</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">علاوه بر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex , breathability</span><span style=\"font-size:16.0pt\">هاي اكريليك معمولاً انعطاف پذيرتر از رنگهاي پايه روغني هستند مخصوصاً پس از اينكه در رنگهاي پايه روغني يك يا دو سال از اكسيداسيون و گيرش آنها گذشته باشد . اكريليك ها از چوبي كه دچار انبساط / انقباض متوالي ناشي از تغييرات رطوبت و دمايش پوسته شده و جدا خواهند شد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">با اينحال پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> اكريليك به خوبي پوششهاي پايه روغني در داخل صفره هاي چوب نفوذ نمي كنند كه تا حدي باعث </span><span dir=\"LTR\" style=\"font-size:14.0pt\">compromising</span><span style=\"font-size:16.0pt\"> چسبندگي اوليه&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود . پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> اغلب داراي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">plethora</span><span style=\"font-size:16.0pt\"> از افزاينده هايي كه براي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">fhne tune</span><span style=\"font-size:16.0pt\"> خواص سيلاني پوشش لازم است مي باشند . بسياري از اينها درآب حل&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شوند بنابراين فيلم خشك شده به آب حساس خواهد بود . بعضي افزودنيها پايه سلولزي هستند بنابراين پوشش داخل ظرف را به حملات ميكروبي حساس خواهند نمود . بخاطر نيازهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">tighter VOC</span><span style=\"font-size:16.0pt\"> ، استفاده از پوششهاي اكريليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> به صورت گسترده در فولاد ساختماني شروع شده است . ساخت با افزودنيهاي با حساسيت كمتر به آب لازم است . چون كشش سطحي بالاتر و توانايي انحلال ضعيفتري دارند آماده سازي سطحي براي اين پوششها بايستي كاملاً خوب باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بسياري از شكست هاي پوشش اكريليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> يا ناشي از حساسيت به آب يا ناسازگاري با پوشش فعلي يا بعدي است .حساسيت به آب مي تواند ناشي از گيرش (تجمع) ضعيف (شايد در اثر دماي پايين يا رطوبت بالا) باشد . هر چند تبخير آب از فيلم ارتباط زيادي با رطوبت بالا دارد تبخير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CO-solvent</span><span style=\"font-size:16.0pt\"> با عامل تجمع چنين نيست. وقتي نهايتاً رطوبت پايين مي رود و آب نهايتاً تبخير مي شود </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CO-solvent</span><span style=\"font-size:16.0pt\"> به مقدار كافي براي تسريع تشكيل لايه خوب موجود نيست . حساسيت به آب نيز مي تواند ناشي از استفاده بيش از اندازه يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">non-Judicious</span><span style=\"font-size:16.0pt\"> افزودنيها باشد . پوششهاي اكريليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> داراي حلال آلي نيستند و معمولاً داراي گروههاي عامل با قطبيت كم تا متوسط كه توانايي كمي براي ايجاد پيوندهاي كووالانت دارند مي باشند . همچنين توانايي كمي براي نرم كردن يا پيوند با پوشش هاي سخت صاف دارند . اين پوششها معمولاً جهت كاربرد روي پوششهاي ترموست (از جمله الكيدهايي كه مدتي از زمان زدن آنها گذشته است) توصيه مي شوند . به طريق مشابه ، پوششهاي غني از حلال داراي تنش بالا ، نظير اپوكسي ها لايه زيرين اكريليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> را نرم (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">coldsoften</span><span style=\"font-size:16.0pt\">) و بلند&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي نمايد.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اكريليك هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ldquo;</span><span style=\"font-size:16.0pt\">احياء كننده آب</span><span dir=\"LTR\" style=\"font-size:14.0pt\">&rdquo;</span><span style=\"font-size:16.0pt\"> يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ldquo;</span><span style=\"font-size:16.0pt\">قابل حل در آب</span><span dir=\"LTR\" style=\"font-size:14.0pt\">&rdquo;</span><span style=\"font-size:16.0pt\"> با اكريليك هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> ارتباط دارند . اكريليك هاي احياء كننده آب با </span><span dir=\"LTR\" style=\"font-size:14.0pt\">incorporation</span><span style=\"font-size:16.0pt\"> مقدار خاصي اسيد كربوكسيليك با گروههاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">pendant</span><span style=\"font-size:16.0pt\"> در ريشه اصلي اكريليك ايجاد مي شوند . اين كار معمولاً با استفاده از چند درصد مونومر نظير اسيد كربوكسيليك انجام مي پذيرد . تا آن وقت استفاده از آمين حلال نظير آمونيا براي واكنش با گروههاي اسيدي ، نمك هايي ايجاد مي شود كه به رزين اجازه پراكندگي يا احياء در آب را مي دهد . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PH</span><span style=\"font-size:16.0pt\"> اين پوششها معمولاً بخوبي بالاي 8 است . اين رزينها اغلب بصورت جزئي از سيستم ترموست پخته شده بجاي لعابهاي دماي اطاق استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950968\"></a><a name=\"_Toc460950861\">5 . 7 . 3 اكريليك هاي ترموست :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">استفاده متداول ديگر رزين هاي اكريليك در سيستم هاي پخته شده ترموست براي اتومبيلها ، لوازم خانگي و ديگر پرداخت هاي سطحي در تجهيزات اوليه (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">OEM</span><span style=\"font-size:16.0pt\">) است . اكريليك هاي استفاده شده در اين فرمولاسيون داراي گروههاي عاملي هستند كه به آنها اجازه واكنش با رزين پيوند دهنده عرضي ديگر را مي دهد . چون وزن ملكولي ، حين پخت بصورت دراماتيك زياد خواهد شد وزن ملكولي اوليه رزين اكريليك مي تواند كم باشد (20000-10000) كه منجر به ايجاد محصول داراي جامد نسبتاً بالا و در نتيجه (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">Concomitantly</span><span style=\"font-size:16.0pt\">) </span><span dir=\"LTR\" style=\"font-size:14.0pt\">VOC</span><span style=\"font-size:16.0pt\">&nbsp; كم خواهد شد . متداول است كه از مونومرهاي نظير هيدروكسي اتيل متاكريلات براي ايجاد مقدار خاص گروههاي هيدوكسيل در اكريليك استفاده نمايند . بيشتر ديگر مونومرهاي استفاده شده در رزين هاي ترموست اكريليك مشابه آنهايي كه در لعابهاي&nbsp; اكريليك استفاده مي شوند&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي باشند . اين رزينها معمولاً با رزين هاي ملامين فرمالدئيد (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\">) با بنزوگوآنيمين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> فرمالدئيد (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\">) پيوند عرضي مي دهند . اين رزينها در قسمت 5-6 توضيح داده شدند.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">برخلاف ديگر انواع پوششهاي ترموست ، پوشش اكريليك</span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF </span><span style=\"font-size:16.0pt\">يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\"> تنها از يك جزء درست شده است . واكنش پيوند عرضي در دماي اطاق چنان كند است كه عامل مهم محسوب نمي شود . با اينحال سرعت واكنش صفر نيست به گونه اي كه انتخاب كاتاليست در صورتيكه رنگ در قوطي بيش از 6 ماه باقي بماند مهم است . معمولاً پوشش استفاده شده در </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\">121 يا بالاتر براي گيرش كافي پخت مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">واكنش بين رزين اكريليك داراي عامل هيدروكسيل (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">R-OH</span><span style=\"font-size:16.0pt\">) و رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF </span><span style=\"font-size:16.0pt\">&nbsp;يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\"> در هر دو گروه هيدروكسيل واتر اتفاق مي افتد . واكنشها توسط مقادير كم اسيدهاي قوي نظير اسيد سولفونيك تولوئن- </span><span dir=\"LTR\" style=\"font-size:14.0pt\">P </span><span style=\"font-size:16.0pt\">(</span><span dir=\"LTR\" style=\"font-size:14.0pt\">PTSA</span><span style=\"font-size:16.0pt\">) كاتاليزه (تسريع) مي شوند . چنانكه انتظار مي رود اكريليك هاي داراي گروه عامل هيدروكسي اوليه سريعتر از آنهايي كه داراي گروه عامل ثانويه هستند واكنش مي دهند . سرعت وكنش با رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\"> تا حدي بستگي به اعتبار&nbsp; الكل ايجاد شده دارد . هر چه محصولات واكنش ، سريعتر فيلم را ترك نمايد واكنش بيشتر به سمت راست جابجا خواهد شد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">معمولاً رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> با مقدار %30-20 جامد رزين استفاده مي شود . مقادير بالاتر رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> معمولاً منجر به پوشش ترد مي شود كه شايد به دليل تراكم خودبخود بيش از اندازه باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مقدار كاتاليست اسيدي مي تواند بر خواص چندي از فيلم گيرش يافته و پايداري حين نگهداري در قوطي تأثير بگذارد . مقادير بالاتر كاتاليست اثرات مفيدي در كاهش دماي گيرش دارند در عين حال در بعضي موارد ، دوام پوشش گيرش يافته را </span><span dir=\"LTR\" style=\"font-size:14.0pt\">COMPROMISE</span><span style=\"font-size:16.0pt\"> مي نمايد . اين كار به اين دليل است كه علاوه بر پيوند عرضي بين گروههاي هيدروكسيل و رزين هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">mf</span><span style=\"font-size:16.0pt\"> ،پيوند عرضي ممكن است بين گروههاي اسيد كربوكسيليك و گروههاي هيدروكسيل روي رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> انجام گيرد كه منجر به تشكيل اتصال استري مي شود كه بعداً بواسطه هيدروكسيل تخريب خواهد شد . اين تخريب هيدروژني با اسيد باقيمانده در فيلم كاتاليزه مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوششهاي ترموست اكريليك / </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> مي توانند به گونه اي ساخته شوند كه داراي محدوده گسترده اي از خواص باشند چون خواص نهايي آنها نه فقط بستگي به اكريليك رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> خاص دارد و بلكه از نوع و مقدار كاتاليست ، رنگدانه و حتي شرايط گيرش بدست مي آيد . پوشش درست ساخته شده و درست گيرش يافته مقاومت چسبندگي و شيميايي عالي دارند و مقاومت اتمسفري و ماوراءبنفش بهتر . بي دليل نيست كه به صورت گسترده در پوشش نهايي اتومبيل استفاده مي شوند همچنين براي لوازم خانگي&nbsp; و كويلها استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950969\"></a><a name=\"_Toc460950862\">مشكلات احتمالي پوششهاي اكريليك/ </a><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span> عبارتند از :</strong></span></span></p>\r\n\r\n<ol>\r\n	<li dir=\"RTL\" style=\"text-align:justify\">\r\n	<p style=\"text-align:right\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در صورتيكه بيش از زمان مجاز نگهداري شود اعمال آنها ممكن است مشكل شود .</span></span></span></p>\r\n	</li>\r\n	<li dir=\"RTL\" style=\"text-align:justify\">\r\n	<p style=\"text-align:right\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اگر كاتاليست اسيدي بيش از اندازه در فيلم گيرش يافته موجود باشد به هيدروليز حساس خواهد بود .</span></span></span></p>\r\n	</li>\r\n</ol>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشكلات ديگر مربوط به گيرش است . گيرش بيش از اندازه كم منجر به پوشش نرم غير منتظره با دانسيته پيوند عرضي پايين و خواص فيزيكي و شيميايي كم مي شود . پخت بيش از اندازه منجر به پوشش ترد و حتي زرد شدن مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وقتي پوشش اكريليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span> <span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> گيرش پيدا مي نمايد واكنش هاي رقابتي بيشماري اتفاق مي افتد . دو واكنش رقابتي كه بيشتر در ديد هستند واكنش اكريليك </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span> <span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> و تراكم خودبخود رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> با خودش است . معمولاً استوكيومتري و كاتاليست به ازاء زمان و دماي بهينه است . اگر شرايط واقعي گيرش متفاوت باشد سرعت نسبي واكنش ها تغيير خواهد كرد در نتيجه منجر به پوششهايي با خواص پايين تر از حد بهينه خواهد شد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي بنزوگوآنيمين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> فرمالدئيد (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\">) معمولاً براي پيوند عرضي با اكريليك ها استفاده مي شوند . چون فقط دو گروه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">NH2</span><span style=\"font-size:16.0pt\"> در هر ملكول به ازاء سه تا روي رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> وجود دارد دانسيته پيوند عرضي كمتر خواهد بود . پوشش هاي تهيه شده با رزين هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\"> مقاومت قليايي و شوينده بهتري نسبت به رزين هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> دارند . با اينحال آنها از نظر دوام اتمسفري ضعيفتر هستند . رزين هاي اكريليك مي توانند با ايزوسياناتها پيوند عرضي بدهند . با اينحال پوششهايي كه به اين روش توليد مي شوند بعنوان </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ldquo;</span><span style=\"font-size:16.0pt\">يورتانها</span><span dir=\"LTR\" style=\"font-size:14.0pt\">&rdquo;</span><span style=\"font-size:16.0pt\"> در نظر گرفته مي شوند كه شيمي آنها در قسمت 5-9 شرح داده&nbsp;&nbsp;&nbsp; مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950970\"></a><a name=\"_Toc460950863\">5-8 پلي استرها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي استرها پليمرهايي هستند كه با واكنش اسيدهاي چرب داراي چند گروه عامل يا انيدريد با الكل هاي داراي چند گروه عامل (الكهاي پلي هيدريد) براي ايجاد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BACK bone</span><span style=\"font-size:16.0pt\"> پليمري داراي گروه استري ايجاد مي شوند . از اين نظر آنها مشابه الكيدها هستند ولي بدون اصلاح اضافه ناشي از روغن هاي طبيعي در نتيجه رزين ها يا پليمرهايي كه ساختار بسيار ساده تري نسبت به الكيدها دارند بدست مي آيد&nbsp; .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در نتيجه فقدان اصلاح توسط روغن ، پلي استرها داراي خواص اسيدهاي چرب الكيدها نيستند . اسيدهاي استفاده شده در ساخت رزين هاي پلي استر داراي پيوندهاي دوتايي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">conjugate</span><span style=\"font-size:16.0pt\"> نيست . چون اين پيوندهاي دوگانه محلي براي پيوند عرضي (گيرش) اكسيد اسيوني رزين هاي الكيدي است واضح است كه رزين هاي پلي استر بايستي برمكانيزم گيرش ديگري بجز الكيدها استوار باشد . مكانيزم گيرش ، عمدتاً بستگي به اين دارد كه رزين پلي استر اشباع شده يا نه . مناسب است پلي استرهاي را به يكي از دو گروه زير تقسيم بندي نمائيم .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950971\"></a><a name=\"_Toc460950864\">5 . 8 . 1 پلي استرهاي اصلاح شده :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بجز اين اختلاف عمده در پلي استرهاي اشباع شده ، اصلاح توسط روغن صورت&nbsp;&nbsp;&nbsp; نمي گيرد ساخت آنها بسيار شبيه الكيدها است . اين پلي استرها از نظر تعدادي زيادي الكل و اسيد داراي دو و/ يا چند گروه عامل تهيه مي شوند .بعضي از اجزاء متداول شروع كننده آنها در جدول 5-3 و 5-4 نشان داده شده است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي پلي استري از نظر اين توانايي كه خواص مورد نظر آنها براساس ملكول آنها طراحي مي شود معادل يا شايد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">surpass</span><span style=\"font-size:16.0pt\"> رزين هاي اكريليك مي باشند . با چنين تعداد زياد مخلوط مواد شروع كننده ، پلي استرها با محدوده اكريليك مي باشند . با چنين تعداد زياد مخلوط مواد شروع كننده ، پلي استرها با محدوده گسترده اي از خواص فيزيكي و شيميايي تهيه مي شوند . خواص پلي استرها تحت تأثير رزيني است كه باعث پيوند عرضي مي گردد . بنابراين خطر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">lumping</span><span style=\"font-size:16.0pt\"> تمام پلي استرها با هم در اثر بي احتياطي وجود دارد </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">نوع الكل ، نوع اسيد ، استوكيومتري و شرايط واكنش ، خواص رزين پلي استر را معين مي نمايد 4 تا از مهمترين خواص وزن ملكولي ، نوع گروه انتهايي ، مقدار شاخه اي شدن و انتخاب مونومرها است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشابه هر رزين محلولي ، وسيكوزيته ، تابعي از وزن ملكولي و در نتيجه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">VOC</span><span style=\"font-size:16.0pt\"> است بيشتر رزين هاي پلي استري وزن ملكولي نسبتاً پايين معمولاً در محدوده 10000-5000 دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي توليد شده با واكنش يك ديول نظير اتيلن گليكول با دي اسيد نظير اسيد ايزوفتاليك، خطي هستند . اگر جزء داراي سه (يا بيشتر) گروه كاري استفاده شود شاخه اي شدن اتفاق مي افتد . پليمرهاي شاخه اي نسبت به پليمرهاي خطي داراي وزن ملكولي قابل مقايسه ، وسيكوزيته بالاتري دارند و نهايتاً فيلم هاي با دانسيته بيشتر پيوند عرضي و مقاومت شيميايي بهتر و انعطاف پذيري و مقاومت ضربه كمتر توليد مي نمايند . اگر تمام شرايط يكسان باشد پلي استر داراي مقدار بالاي پنتا اريتريتول (داراي 4 گروه عامل هيدروكسيل) منجر به پوشش با مقاومت شيميايي بالاتر و&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سخت تر نسبت به 1 ، 6- هگزان ديول مي شود . پوشش دوم زماني كه انعطاف پذيري و مقاومت ضربه لازم است بسيار بهتر تحمل مي نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">فاصله بين گروههاي عامل نيز برخواص نهايي پوشش اثر دارد . پلي استرهاي تهيه شده از اسيد ساكسينيك كه در آنها گروههاي اسيدي فقط به اندازه دو اتم كربن فاصله دارد داراي انطاف پذيري كمتري نسبت به پلي استرهاي تهيه شده از اسيدهاي آزلائيك كه گروههاي اسيدي آن 5 اتم كربن فاصله دارند مي باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چون پلي استرها در شاخه اصلي خود داراي گروههاي استري هستند مشابه الكيدها به هيدروليز قليايي (صابوني شدن) حساس هستند . با اين حال نسبت به الكيدها داراي مقاومت بيشتري نسبت به هيدروليز هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">حداقل در بعضي موارد اين افزايش مقاومت ناشي از اثرات استئاريك به نظر مي رسد كه سرعت واكنش هيدروليز را كاهش مي دهد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">}</span><span style=\"font-size:16.0pt\">2</span><span dir=\"LTR\" style=\"font-size:14.0pt\">{</span><span style=\"font-size:16.0pt\"> . مثلاً پلي استرهاي توليد شده از نئوپنتيل گليكول در برابر هيدروليز از پلي استرهاي توليد شده از 1 ، 6- هگزان ديول هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي پلي استر اشباع شده مكانيزم گيرش ندارند بنابراين پوششهاي تهيه شده از آنها از رزينهاي پيوند دهنده عرضي نظير رزين ملامين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> فرمالدئيد (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\">) ، بنزوگوآنيمين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> فرمالدئيد (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\">) يا اپوكسي استفاده مي نمايند . پلي استرهاي طراحي شده براي پيوند عرضي با رزين هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\"> با يك پوليول اضافه كه گروههاي انتهايي داراي عامل هيدروكسيل باشند شروع به ساخت مي نمايند در حاليكه آنهايي كه براي پيوند عرضي با اپوكسي ها طراحي شده اند از اضافه اسيد براي مشاركت با گروه كربوكسيلات استفاده مي نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">واكنش پيوند عرضي پلي استر منتهي به هيدروكسيل با رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\"> بسيار شبيه اكريليك هاي داراي عامل هيدروكسيل كه قبلاً توضيح داده شد هستند . معمولاً كاتاليست هاي اسيدي و دماي پخت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\"> 149-121 استفاده مي شوند . ويژگيهاي ناشي از رزين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BF</span><span style=\"font-size:16.0pt\"> مشابه آنهايي كه ناشي از رزين هاي اكريليك است و در قسمت 5 . 7 . 3 . توضيح داده شد مي باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي استرهاي توليد شده با گروههاي انتهايي اسيد كربوكسيليك در محل اكسي ران رزين اپوكسي پيوند عرضي مي دهد (شكل 1-1 را ببينيد) . اين واكنش تا حدي كندتر از واكنش </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MF</span><span style=\"font-size:16.0pt\"> هيدروكسيل است و دماهاي حدود </span><span dir=\"LTR\" style=\"font-size:14.0pt\">C</span><span style=\"font-size:16.0pt\">204 لازم دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\">پوششهاي توليد شده از پلي استرهاي اصلاح شده داراي كاربردهاي گسترده اي نظير انبارهاي كلاف پوشش دهي ظروف ، رنگهاي پايه اتومبيل ، رنگهاي لوازم خانگي ، رنگ اثاثيه فلزي و سطوح خارجي فلزي مي باشد . در بسياري از كاربردها بجز آنهايي كه زيبايي ، بسيار مورد توجه است پلي استرها مي توانند بصورت پودري ساخته و اعمال شوند . همچنين مي توان پوشش هاي پلي استر اشباع پايه آبي ساخت كه با كمك پلي استرهاي منتهي به اسيد كربوكسيليك كه با آمين هاي فرّار خنثي شده اند تا در آب پراكنده گردند ساخته مي شوند. مجدداً ، اينها با عوامل مناسب گيرش ، پيوند عرضي داده ، پخته مي شوند . پلي استرهاي اشباع نشده ممكن است &zwj; با ايزوسياناتها براي ايجاد يورتانها واكنش بدهند . سواي از هر مشكل مربوط به تميز كاري يا پيش عمليات ناكافي سطوح فلزي كه اين پوششها روي آنها اعمال مي شود مشكلات احتمالي ناشي از عدم ساخت صحيح و خطاهاي گيرش مي باشد .</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">عدم ساخت صحيح بويژه در مواردي كه كاربرد نهايي محصول دانسته شده باشد نادر است . هميشه احتمال خطاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Batching</span><span style=\"font-size:16.0pt\"> وجود دارد . قراردادن نمونه اي داراي نصف مقدار رزين فرمالدئيد در هواي آزاد منجر به محصول نهايي با دوام كم و مقاومت شيميايي نامطلوب خواهد شد . در هر محصولي كه پخت نياز دارد در موقع شكست بايستي اولين موردي باشد كه مد نظر قرار مي گيرد . استفاده از كوره هايي كه دماي آنها بخوبي ثبت نمي شود يا دستگاهي كه ثبات دمايي آن بصورت دقيق كاليبره نشده است توسط سازندگان ، غير معمول نيست . تغييرات سرعت خط نيز ممكن است بر گيرش اثر بگذارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950972\"></a><a name=\"_Toc460950865\">5 . 8 . 2 پلي استرهاي اشباع نشده :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي پلي استر اشباع نشده با كمك اسيد اشباع نشده بجاي اسيد اشباع شده تهيه مي شوند . معمولاً اسيدهاي استفاده شده ، انيدريد مالئيك (شكل 5-31) يا اسيد فوماريك (شكل 5-32)&nbsp; است . وقتي حلقه انيدريد مالئيك باز مي شود نظير موقع واكنش با آب ، اسيد مالئيك ايجاد مي شود كه بسادگي ايزومر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span> <span dir=\"LTR\" style=\"font-size:14.0pt\">CIS</span><span style=\"font-size:16.0pt\"> اسيد فوماريك و پروپيلن گليكول است . پلي استرهاي ساخته شده از اسيد فوماريك نسبت به آنهايي كه از اسيدمالئيك ساخته شده اند تمايل به سختي بيشتر دارند . با جايگزيني اسيد آليفاتيك نظير اسيد آديپيك براي بعضي از اسيدهاي ايزوفتاليك انعطاف پذيري ايجاد مي شود . در بعضي موارد ، رزين ها با استفاده از مواد اپوكسي بجاي قسمتي از جزء ديول ساخته مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي استرهاي اصلاح نشده با پليمريزاسيون راديكال آزاد در محل پيوند دوگانه گيرش پيدا مي كنند . استفاده از پروكسيدهايي نظير پروكسيدبنزوئيل يا پروكسيدمتيل اتيل كتون همراه با تسريع كننده هايي نظير نفتنات كبالت براي شروع و كاتاليز واكنش راديكال آزاد متداول است . استايرن حلال خوبي براي پلي استر است . بواسطه پيوند دوگانه ، باآن واكنش مي دهد در نتيجه پوشش را قادر مي سازد كه تا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">VOC</span><span style=\"font-size:16.0pt\"> حدود صفر ، ساخته شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اكسيژن مي تواند با واكنش با راديكال و &laquo;درپوش گذاري&raquo; واكنش ، مانع از واكنش راديكال آزاد شود . اين &laquo;ممانعت كننده هوايي&raquo; در سطح پوششها اتفاق مي افتد بنابراين آنرا چسبناك مي نمايد .يك روش غلبه براين مشكل ساخت ، قرار دادن كمي واكس در فرمول پوشش است . واكس به سطح نفوذ و به صورت جزئي آنرا نسبت به اكسيژن آب بندي مي نمايد . افزودنيهاي ديگر نيز مي توانند براي كاهش ممانعت هوايي استفاده شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي استرهاي اشباع نشده در صنعت فايبر گلاس خيلي متداولتر از صنعت پوشش هستند . مشابه پوششها ، اينها اغلب براي سيستم هاي گيرش در اثر تابش كه لامپهاي ماوراءبنفش يا منبع پرتوالكتروني ، پروكسيد را به عنوان آغاز كننده راديكال آزاد جايگزين مي نمايد همچنين به عنوان آستري در تماس با محيط شيميايي سخت نظير سطح داخلي ظروف نگهداري مواد شيميايي استفاده مي شوند . در اين كاربرده اغلب با دستگاه اسپري </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Plural</span><span style=\"font-size:16.0pt\"> اعمال مي شوند . زيرا وقتي كاتاليزه شدند عمر پس از مخلوط بسيار كمي دارند . الياف (بريده هاي)فايبرگلاس نيز ممكن است يكي از اجزاء اين پوشش باشد . فايبرگلاس باعث استحكام بهتر ، نفوذ پذيري كمتر و اجازه كاربردهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">high build</span><span style=\"font-size:16.0pt\"> را مي دهد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وينيل استرها كه شايد مناسبتر باشد بعنوان اكريليك در نظر گرفته شوند با پلي استرهاي اشباع نشده در ارتباط هستند وينيل استرها معمولاً با واكنش اسيد اكريليك يا اسيد متاكريليك با اپوكسي ايجاد مي شود . ساختار كلي آن در شكل 5-33 آمده است. تنها گروههاي استري روي اين رزينها در انتها قرار دارند بنابراين پايداري هيدروليز بهتري نسبت به پوششهاي پلي استر اشباع نشده متداول ايجاد مي نمايد . مشابه پلي استرهاي اشباع نشده ، اينها نيز با پليمزيزاسيون راديكال آزاد كه توسط كاتاليست هاي پروكسيد آغاز شده گيرش مي يابند . همچنين داراي استايرن به عنوان رقيق كننده واكنش پذير مي باشد . وينيل استرها و پلي استرهاي اشباع نشده معمولاً باعث تنش انقباضي قابل ملاحظه مي شوند و بسيار سفت هستند پس تميز كاري و ريزي سطحي در بدست آوردن چسبندگي خوب بسيار مهم هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950973\"></a><a name=\"_Toc460950866\">5 . 9 پلي يورتانها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي يورتانها يكي از مهمترين پوششهاي چندكاره است كه از پوششهاي لعاب مانند نسبتاً ساده تا پوششهاي با كيفيت بالاي اتومبيل را مي پوشاند . اين پوششها معمولاً با واكنش الكل (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">R-OH</span><span style=\"font-size:16.0pt\">) با ايزوسيانات (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">R-NCO</span><span style=\"font-size:16.0pt\">) براي ايجاد يورتان يا كربامات كه ساختار آن در شكل 5-34 نشان داده شده است ايجاد مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشابه اپوكسي ها ، پلي يورتانها معمولاً داراي دو جزء هستند كه بايستي قبل از زدن با هم مخلوط شوند . يك جزء معمولاً داراي پوليول است در حاليكه ديگري داراي ايزوسيانات است . گروه ايزوسيانات معمولاً بسيار فعال و داراي دو يا چند گروه عامل براي پيوند عرضي هر تعداد رزين كه گروههاي عامل داراي هيدروژنهاي فعال دارد استفاده مي شود . هر چند رزين هاي داراي گروه هيدروكسيل ، پاي ثابت صنعت هستند ايزوسيانات ها مي توانند با آمين هاي اوليه آروماتيك و آليفاتيك اسيدهاي كربوكسيليك و آمين هاي ثانويه اوره و آب واكنش دهند . تمام اين واكنشها منجر به ايجاد اتصال يورتان نمي شود پس اين پوششها از نظر تكنولوژي ، يورتان نيست . مثال كلاسيك اين فهرست گيج كننده ، &laquo;يورتان گيرش يافته با رطوبت&raquo; است كه در حالت كلي يك يورتان نيست بلكه در واقع پلي اوره است . وقتي ديول بادي- ايزوسيانات واكنش و هر يك پليمر خطي روي شاخه اصلي اتصال يورتان ايجاد مي شود . اگر آب موجود باشد مي تواند با ايزوسيانات براي تشكيل اسيد كرباميك واكنش دهد (شكل 5-35) . اسيد كرباميك پايدار نيست و براحتي تجزيه مي شود تا آمين و دي اكسيد كربن ايجاد نمايد . چون آمين ها نسبت به گروههاي ايزوسيانات بسيار فعال هستند با آنها واكنش مي دهند تا اوره پراكنده (متفرق) ايجاد نمايد (شكل 5-36) .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هر چند واكنش ايزوسيانات با آب كندتر از واكنش ايزوسيانات با گروه هيدروكسيل اوليه است سرعت واكنش ايزوسيانات با گروه هيدروكسيل اوليه بيشتر از واكنش ايزوسيانات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> هيدروكسيل اوليه است . با اينحال سرعت نسبي واكنش با تغيير غلظت ، دما و كاتاليست تغيير خواهد كرد كه مطالعه اين پوشش را پيچيده تر (و جذابتر)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وقتي اوره جانشيني تشكيل شد ممكن است گوناگوني زياد شود همچنين اوره ممكن است با ايزوسيانات واكنش بدهد تا بي اورت توليد نمايد&nbsp; (شكل 5-37) .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">همه واكنشهاي بالا در دماي اطاق اتفاق مي افتند و با استفاده از كاتاليستهايي&nbsp; نظير آمين هاي سه تايي و تركيبات آلي (بويژه دي بوتيل بتن ديلااورت) تسريع مي شوند . ايزوسيانات در دماي بالا با اسيد كربوكسيليك واكنش مي دهند تا آميد ايجاد نمايند . ايزوسياناتهاي استفاده شده در پوششها معمولاً به دو نوع آروماتيك و آليفاتيك تقسيم بندي مي شوند . متداولترين ايزوسياناتهاي استفاده شده در جدول 5-5 نشان داده شده است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">دو عيب مهم ايزوسياناتها ، سمّي بودن و فراريت آنها است . معمولاً از ايزوسياناتهاي با وزن ملكولي بيشتر استفاده مي نمايند . بنابراين هم 2 ، 4- تولوئن دي ايزوسيانات (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">TDI</span><span style=\"font-size:16.0pt\">) و هم 1 ، 6- هگزا متيلن دي ايزوسيانات (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">HDI</span><span style=\"font-size:16.0pt\">) بعنوان </span><span dir=\"LTR\" style=\"font-size:14.0pt\">trimer</span><span style=\"font-size:16.0pt\"> آنها متداول هستند كه ايزوسيانااورات ها&nbsp; ناميده مي شوند . راه ديگر كاهش مشكل ، استفاده از &laquo;پليمرهاي اوليه&raquo; ايزوسيانات كه بواسطه واكنش ايزوسيانات اضافه با تركيب پلي هيدروكسي ساخته مي شود مي باشد . بسته به پوليول استفاده شده ، پلي يورتانهاي پايه ايزوسيانات آروماتيك نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TDI</span><span style=\"font-size:16.0pt\"> و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MDI</span><span style=\"font-size:16.0pt\"> ساخته مي شود كه پوشش سخت با مقاومت شيميايي و حرارتي عالي توليد مي نمايد . متأسفانه ضعف پلي يورتانهاي پايه ايزوسيانات آروماتيك ، تمايل آنها به بي رنگ شدن و گچي شدن در اثر تماس با نور خورشيد است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي يورتانهاي پايه ايزوسيانات آليفاتيك نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">HDI</span><span style=\"font-size:16.0pt\"> و ايزوفوران دي ايزوسيانات (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">IPDI</span><span style=\"font-size:16.0pt\">) تا حد زيادي نسبت به آروماتيك ها از نظر مقاومت در برابر اتمسفر بهترند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">همچنين مقاومت شيميايي عالي دارند . با اينحال گاهي نسبت به آروماتيك ها سرعت گيرش پايينتر و قيمت بالاتري دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950974\"></a><a name=\"_Toc460950867\">5 . 9 . 1 پوششهاي دو جزئي پلي ايزوسيانات / پوليول :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">متداولترين نوع پوشش يورتان ، انواع </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Solvent-borne</span><span style=\"font-size:16.0pt\"> دو جزئي است كه يك جزء شامل پلي ايزوسيانات و ديگري پوليول مي باشد . جزء رنگدانه معمولاً داراي پوليول است در حاليكه مقادير رطوبت ناشي از رنگدانه ها اثري بر عمر انباري آن ندارد . هم ايزوسياناتهاي آليفاتيك و هم آروماتيك استفاده مي شوند كه اولي داراي بقاي رنگ و مقاومت اتمسفري بسيار بهتر دارد . متداولترين نوع پوليول ها ، اكريليك هاي با گروه عامل هيدروكسيل ، پلي استرها و پلي اترها هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">گروه عامل هيدروكسيل معمولاً با تركيب مقدار خاصي 2- هيدروكسيل متاكريليك (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">HEMA</span><span style=\"font-size:16.0pt\">) به مخلوط مونومر به اكريليك تبديل مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">HGM</span><span style=\"font-size:16.0pt\"> گروههاي هيدروكسيل اوليه براي اتصال عرضي با ايزوسيانات فراهم&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي نمايد . معمولاً 2- هيدروكسيل متاكريلات استفاده مي شود . گروه عامل هيدروكسيل ثانويه داراي نقص سرعت واكنش كمتر با ايزوسيانات ولي داراي اين مزيت است كه عمر پس از مخلوط بيشتري دارد . وزن ملكولي رزين هاي اكريليك استفاده شده در پوششهاي يورتان معمولاً پايين شايد در مرتبه 25000 مي باشد كه در مقايسه با لعاب اكريليك متداول </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Single &ndash; pack</span><span style=\"font-size:16.0pt\"> كاملاً پايين است ولي وزن ملكولي فيلم پيوند عرضي نهايي كاملاً بالا است . وزن ملكولي پايين رزين اكريليك و ايزوسيانات اجازه ساخت پوشش با درصد&nbsp; بالاي جامد داراي وسيكوزيته متوسط تا پايين را امكانپذير مي نمايد . چنانكه در قسمت 5-7 توضيح داده شد تنوع مونومرها محدوده گسترده اي در طراحي ملكولي رزين هاي اكريليك را اجازه مي دهد . مونومرهاي مشابهي براي پلي يورتانهاي اكريليك &laquo;</span><span dir=\"LTR\" style=\"font-size:14.0pt\">tailor&nbsp; making</span><span style=\"font-size:16.0pt\">&raquo; با خواص متنوع وجود دارد . با اين حال يك عامل بحراني ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> پوشش نهايي است . مطلوبست كه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> پوشش كاملاً گيرش يافته ، كمي پايينتر از دماي گيرش (كه عمدتاً دماي اطاق است) باشد . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> پوشش با افزايش مقدار گيرش زياد مي شود . وقتي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> پوشش جزئي گيرش يافته برابر يا بيشتر از دماي گيرش پوشش مي شود زياد مي شود وقتي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> پوشش جزئي گيرش يافته برابر يا بيشتر از دماي گيرش پوشش مي شود كاهش سريع در حجم آزاد اتفاق مي افتد . زنجيره هاي پليمري جاي بسيار كمتري براي جابجايي خواهند داشت و جاجايي ، كاهش و نهايتاً متوقف و واكنش به صورت كامل انجام نخواهد شد . يك روش براي حذف اين مشكل ، گيرش دادن پوشش در دماي بالا است ولي اين كار براي پوششهاي صنعتي امكان پذير نيست .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي استرهاي داراي گروه عامل هيدروكسيل ، كاربرد عمده اي در ساخت پلي يورتانهاي دو جزئي دارند . شيمي و خواص پلي استرهاي داراي گروه عامل هيدروكسيل در قسمت 5-8 توضيح داده شده است . همانند اكريليك هاي داراي گروه عامل هيدروكسيل ، پلي استرهاي استفاده شده براي ساخت پلي يورتانها داراي وزن ملكولي نسبتاً پايين هستند . اين كار باعث ايجاد پوششهاي با درصد بالاي جامد و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">VOC</span><span style=\"font-size:16.0pt\"> پايين مي شود . همان ملاحظات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Tg</span><span style=\"font-size:16.0pt\"> كه براي پلي يورتانهاي پلي استر اشاره شد براي پلي يورتانهاي اكريليك نيز به كار مي رود . پلي يورتانهاي اكريليك نيز به كار مي رود . پلي يورتانهاي پلي استري در مقايسه با اكريليك ها تمايل به&nbsp; ايجاد پوششهاي داراي جامد بالاتر و چسبندگي تا حدي بهتر به فلزات دارند . اكريليك ها معمولاً ارزانتر ، داراي دوام اتمسفري و مقاومت به هيدروليز بهتري هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي استرهاي داراي گروه عامل هيدروكسيل نيز براي ساخت پلي يورتانهاي دو جزئي استفاده مي شوند . چون اتصال اتري نسبت به بسياري از ديگر گروههاي كاري از جهت چرخش ملكولي محدوديت بسيار كمتري دارند و چون تمايل به گروههاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">bulky side</span><span style=\"font-size:16.0pt\"> ندارند پلي يورتانهاي پلي اتري بسيار انعطاف پذيرتر و با مقاومت ضربه بسيار بهتر نسبت به پلي يورتانهاي اكريليك و پلي استر كه بسيار سخت تر هستند&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي باشند . بواسطه نرمي براي بسياري كاربردها نامناسبند با اينحال تشكيل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">lining</span><span style=\"font-size:16.0pt\"> (آستره)&nbsp; و پوشش الاستومري </span><span dir=\"LTR\" style=\"font-size:14.0pt\">high&nbsp; build</span><span style=\"font-size:16.0pt\"> عالي مي دهند و در محيط هاي نسبتاً خشن مي توانند دوام بياورند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هر چنر اكريليك ها ، پلي استرها و پلي اترها متداولترين رزينهاي داراي گروه عامل هيدروكسيل هستند كه در يورتانهاي دو جزئي استفاده مي شوند ولي رزينهاي استفاده شده منحصر به اينها نيست . چون رزينهاي الكيدي گروههاي هيدروكسيل واكنش نداده دارند با ايزوسيانتها نيز مي توانند پيوند عرضي بدهند همچنانكه رزين هاي اپوكسي با گروه هيدروكسيل ثانويه خود مي توانند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يورتانهاي دو جزئي پايه حلالي شايد اولين سيستم پوشش در كاربردهايي كه نياز به بقاي رنگ عالي و براقيت و مقاومت شيميايي خوب دارند باشند . براساس توضيحات بالا ، واضح است كه با انتخاب وسيع پوليولها و پلي ايزوسياناتهاي در دسترس ، متخصص شيمي پليمر ، پوشهاي يورتاني توليد مي نمايد كه داراي محدوده وسيعي از خواص فيزيكي و شيميايي باشد . برخلاف تنوع ، مشخصات ويژه اي بين يورتانهاي مختلف از نظر نوع شكست وجود دارد . اين مطلب بويژه با در نظر گرفتن رفتار آنها در آب صحيح است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">ايزوسياناتها بسيار فعالند و با آب براي تشكيل اوره متفرق (پراكنده) واكنش مي دهد . محصول اين واكنش ، دي اكسيد كربن است كه در دماي اطاق ، گاز است . واكنش با آب نه فقط مسير گيرش طراحي شده پوشش را قطع مي نمايد كه منجر به خواص فيزيكي و شيميايي غير منتظره و اغلب نامطلوب مي شود بلكه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CO2</span><span style=\"font-size:16.0pt\"> حبس شده باعث ايجاد حفره هاي بيشمار در داخل پوشش گيرش يافته مي شود . اين اثر &laquo;پنيرسويسي&raquo; نتايج جدي بر نفوذپذيري و استحكام مكانيكي پوشش دارد آب ممكن است از منابع مختلف فراهم شود از جمله اگر پس از اعمال رنگ باران ببارد ، رنگ زدن حين دوره هاي بسيار مطلوب سال ، استفاده از حلالهاي غير يورتاني كه داراي مقدار كمي رطوبت هستند . زنگ در خطوط رنگ و عدم آب بندي صحيح مخازن پس از بازكردن اگر آب در نتيجه رسيدن به نقطه شبنم روي زير لايه موجود است نه فقط منجر به ايجاد حفره مي شود بلكه باعث چسبندگي ضعيف نيز خواهد شد . براي كمك به حفاظت در برابر امكان خسارت ناشي از رطوبت بر پوشش گيرش يافته ، يورتانهاي زيادي با مقدار كمي اضافه ايزوسيانات ساخته مي شوند . نسبت ايزوسيانات به هيدروكسيل 1:1 تا 1:0 متداول است . در صنعت رنگ شنيده نشده است كه مقاطعه كار ، پوشش را با حلال اشتباه رقيق نمايد . اغلب اين كار ، اثرات كمي دارد با اين حال اگر يورتان دو جزئي با حلال داراي الكل رقيق شود الكل داراي يك گروه عامل با ايزوسيانات واكنش و فرايند پيوند عرضي را متوقف خواهد نمود . اين اثرات بستگي دارد به اينكه چه مقدار الكل استفاده شده ولي مي تواند فاجعه آميز باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\">همانند هر پوشش دو جزئي ، همواره احتمال نسبت مخلوط كردن اشتباه وجود دارد . بخاطر پيچيدگي واكنشهاي مختلف كه در يورتان گبرش يافته انجام مي شود هميشه نمي توان مشخص كرد كه دقيقاً چه مقدار خطا در نسبت مخلوط بر خواص پوشش اثر مي گذارد با اينحال اضافه پوليول تقريباً هميشه منجر به ايجاد پوشش نرمتر خواهد شد چون هيچ واكنش جنبي وجود ندارد كه پوليول در آن شركت نمايد . در نتيجه پوليول به عنوان نرم كننده عمل خواهد كرد .</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\">در كابردهاي صنعتي ، يورتانهاي دو جزئي ، اغلب به عنوان پوشش نهايي روي لايه هاي مياني اپوكسي زده مي شوند در حاليكه وقتي پوشش ، فقط يورتان باشد مشكلي ايجاد نمي شود يورتان (و ديگر پوششها) حتي نسبت به مقادير كم پوشش گچي روي سطح اپوكسي بسيار حساس هستند . در بعضي موارد ، اين لايه بينهايت نازك اپوكسي گچي شده كه گاهي فقط يك يا دو هفته ايجاد مي شود باعث جدايش لايه يورتان از اپوكسي مي شود .</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950975\"></a><a name=\"_Toc460950868\">5 . 9 . 2 پور الكيدها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يورالكيدها كه گاهي الكيدهاي يورتاني نيز ناميده مي شوند نبايستي با يورتانهاي دو جزئي كه بواسطه واكنش بين ايزوسيانات و گروههاي هيدروكسيل يك رزين اكريليك اتفاق مي افتد اشتباه شود در عوض ، اينها عمدتاً الكيدهاي اصلاح شده هستند كه مقداري از انيدريدفتاليك آنها با ايزوسياناتي نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TDI</span><span style=\"font-size:16.0pt\"> جايگزين شده است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يورالكيدها پوششهاي تك جزئي هستند كه معمولاً سريعتر از الكيدهاي معمولي خشك و از آنها سخت تر مي شوند . همچنين آنها داراي مقاومت سايشي و مقاومت در برابر هيدروليز بهبود يافته هستند متأسفانه آنها گرانتر و بخاطر استفاده از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TDI</span><span style=\"font-size:16.0pt\"> آروماتيك ، بقاي رنگ ضعيفتري دارند . مشكل بقاي رنگ مي تواند با استفاده از ايزوسياناتهاي آليفاتيك بهبود يابد ولي هزينه بالاتر مي رود . اين رنگها توسط فرايندي مشابه رزينهاي الكيدي گيرش مي يابند بنابراين بايستي داراي خشك كن هايي مشابه انواعي كه در الكيدها استفاده مي شوند باشند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يورالكيدها به طور عمده بعنوان جلا استفاده مي شوند هر چند كه از نظر فني جلاي واقعي نيستند . يورالكيدها در مواردي كه سختي و مقاومت سايشي خوب باشد بعنوان جلاي شفاف روي چوب استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950976\"></a><a name=\"_Toc460950869\">5 . 9 . 3 پلي يورتانهاي گيرش يافته با رطوبت :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">ODDLY ENOUGH</span><span style=\"font-size:16.0pt\"> هر چند رطوبت در يورتانهاي دو جزئي معمولاً آلوده كننده محسوب مي شوند در پلي يورتانهاي گيرش يافته با رطوبت ، همراه با ايزوسياتانها عامل اوليه پيوند عرضي هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">منبع آب ، رطوبت اتمسفر است و پليمر ايجاد شده پلي يورتان نيست بلكه پلي اوره است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در مورد يورتان دو جزئي اكريليك يا پلي استر ، عمده فيلم گيرش يافته نهايي از موارد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">STATING</span><span style=\"font-size:16.0pt\"> اكريليك يا پلي استر ساخته شده كه در ابتدا وزن ملكولي 25000-15000 داشته اند . با اين حال آنالوگ هيدروكسيل به پلي استر يا اكريليك آب است . كه داراي وزن ملكولي 18 مي باشد بنابراين پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">VIABLE</span><span style=\"font-size:16.0pt\"> نمي تواند بسادگي توسط واكنش آب با ايزوسياناتهاي داراي وزن ملكولي نسبتاً پايين كه در پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TWO &ndash; PACK</span><span style=\"font-size:16.0pt\"> متداول استفاده مي شوند ساخته شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">ايزوسياناتهاي به كار رفته در يورتانهاي گيرش يافته با رطوبت ، رزين هايي هستند كه در هر ملكول ، دو يا بيشتر گروه ايزوسيانات دارند . آنها معمولاً از پلي استرهاي منتهي به هيدروكسيل كه با اضافه ايزوسياناتهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ldquo;</span><span style=\"font-size:16.0pt\">متداول </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ldquo;</span><span style=\"font-size:16.0pt\"> نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TDI</span><span style=\"font-size:16.0pt\"> يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MDI</span><span style=\"font-size:16.0pt\"> يا اگر بقاي رنگ مهم است با ايزوسيانات آليفاتيك واكنش مي دهند ساخته مي شوند . همچنين ايجاد تعدا خاصي اتصال يورتان اجتناب ناپذير است . اين پوششها محصولات تك جزئي هستند و وقتي زده شوند بواسطه واكنش با رطوبت هوا گيرش مي يابند سرعت گيرش بستگي به رطوبت دارد . زير رطوبت نسبي حدود 30 درصد ، گيرش نسبتاً كند است و بالاتر از 80 درصد ، سرعت خروج دي اكسيدكربن از واكنش گيرش بحدي زياد است كه در پوشش ، حباب ايجاد مي نمايد ، بنابراين رطوبت بين %80-30 ترجيح داده مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يكي از مهمترين مزاياي يورتانهاي گيرش يافته با آب ، اين واقعيت است كه آنها تك جزئي هستند . اين كار باعث حفظ زمان براي مقاطعه كار و جلوگيري از نسبت مخلوط نادرست كه ممكن است عامل شكست باشد مي گردد . ديگر مزايا شامل توانايي اعمال اين&nbsp; محصولات بر روي سطوح مرطوب ، گيرش سريع و پوشش نهايي سخت ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TOUGH</span><span style=\"font-size:16.0pt\"> و تا حدي انعطاف پذير و چسبندگي خوب به فلزات و مقاومت شيميايي خوب مي باشد . پايداري آنها در برابر نور متغير است كه بستگي زيادي به ايزوسيانات استفاده شده در آنها دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">يكي از بارزترين معايب يورتانهاي گيرش يافته با رطوبت ، حساسيت آنها به رطوبت است . آنها اغلب تحت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">BLANKET</span><span style=\"font-size:16.0pt\"> نيتروژن بسته بندي مي شوند و پس از باز شدن بايستي طي چند روز مصرف شوند تا ژله اي نشوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">همچنين در انتخاب و جابجائي رنگدانه ها بايستي دقت زيادي شود چرا كه بسياري از رنگدانه ها داراي ردپايي از رطوبت هستند كه روي پايداري حين نگهداري در انبار ، اثر مخرب دارد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">ديگرعيب احتمالي يورتانهاي گيرش يافته با رطوبت ، ايجاد حباب بواسطه توليد سريع </span><span dir=\"LTR\" style=\"font-size:14.0pt\">CO2</span><span style=\"font-size:16.0pt\"> در شرايط بسيار مرطوب است . اين مشكل در </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Highpilm build</span><span style=\"font-size:16.0pt\"> ها ، </span><span dir=\"LTR\" style=\"font-size:14.0pt\">exacerbated</span><span style=\"font-size:16.0pt\"> است اگر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">high film build</span><span style=\"font-size:16.0pt\"> مطلوبست گاهي لازم است چندين لايه نازك زد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">همانند يورتانهاي دو جزئي معمولي ، الكل نبايستي در اين پوششها وارد شود . اگر از اين رقيق كننده استفاده شود الكل با گروه ايزوسيانات واكنش داده و در واكنش گيرش، به شدت مزاحمت ايجاد خواهد كرد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950977\"></a><a name=\"_Toc460950870\">5 . 9 . 4 لعابها و </a><span dir=\"LTR\" style=\"font-size:14.0pt\">dispersion</span> هاي پلي يورتان :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">لعابهاي پلي يورتان پايه حلالي تك جزئي و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">dispersion</span><span style=\"font-size:16.0pt\"> هاي پلي يورتان تك جزئي در آب نيز موجودند . اين لعابها به سادگي پليمرهاي خطي ترموپلاستيك داراي وزن ملكولي بالا هستند كه توسط واكنش ديواره با دي ايزوسياناتها ساخته مي شوند . اينها پوشش هاي داراي جامد كم مي باشند كه بواسطه تبخير حلال ، خشك و روي زمينه هاي انعطاف پذير مثل </span><span dir=\"LTR\" style=\"font-size:14.0pt\">fabric</span><span style=\"font-size:16.0pt\"> ها و </span><span dir=\"LTR\" style=\"font-size:14.0pt\">learther</span><span style=\"font-size:16.0pt\"> زده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">dispersion</span><span style=\"font-size:16.0pt\"> هاي پلي يورتان در اصل يورتانهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> هستند و در ساخت آنها از روشهاي مختلفي استفاده مي شود . گيرش آنها مشابه اكريليك هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span><span style=\"font-size:16.0pt\"> براساس تبخير آب و تجمع (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">coalesence</span><span style=\"font-size:16.0pt\">) مي باشد</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950978\"></a><a name=\"_Toc460950871\">5 . 9 . 5 پلي يورتانهاي دو جزئي </a><span dir=\"LTR\" style=\"font-size:14.0pt\">water </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span dir=\"LTR\" style=\"font-size:14.0pt\"> borne</span> :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بخاطر قوانين روزافزون محدود كننده </span><span dir=\"LTR\" style=\"font-size:14.0pt\">voc</span><span style=\"font-size:16.0pt\"> ، اخيراً پلي يورتانهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">water &ndash;borne</span><span style=\"font-size:16.0pt\"> توليد شده اند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشكلات ساخت اين پوششها آشكار است چون حلالها (در اين حالت آب) با جزء ايزوسيانات مي تواند واكنش بدهد . چند روش استفاده مي شود . از جمله استفاده از ايزوسياناتهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blocked</span><span style=\"font-size:16.0pt\"> و آماده سازي پوليول پلي يورتان كه يا با استفاده از سورفسانتها در آب امولسيون شده يا اينكه در آببواسطه واكنش مقداري گروه عامل اسيدكربوكسيليك به پليمر و ايجاد نمك از طريق افزودن آمين فرار </span><span dir=\"LTR\" style=\"font-size:14.0pt\">reducible</span><span style=\"font-size:16.0pt\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شوند.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">قبل از زدن ، جزء پوليول </span><span dir=\"LTR\" style=\"font-size:14.0pt\">water &ndash; borne</span><span style=\"font-size:16.0pt\"> با ايزوسيانات سازگار كه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">water &ndash; borne</span><span style=\"font-size:16.0pt\"> نيست مخلوط مي شود . سپس ايزوسيانات به فاز پوليول كه عمدتاً توسط پوليول امولسيون مي شود و بعداً با آن پيوند عرضي ايجاد مي نمايد نفوذ مي نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هر چند ايزوسيانات پوليول سريعتر از فاز آب واكنش مي دهد واضح است كه آب&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي بايست حداقل مقداري از آنرا مصرف نمايد . بنابراين نسبت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">NCO : OH</span><span style=\"font-size:16.0pt\"> 2:1 اغلب براي ساخت آن به كار مي رود . سرعت نسبي واكنشهاي مختلف در كنار عوامل ديگر به دما و رطوبت نسبي در زمان اعمال رنگ بستگي دارد . اگر دما بالا ورطوبت پايين باشد براي واكنش پوليول </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> ايزوسيانات بسيار مطلوب خواهد بود اگر دما پايين و رطوبت نسبي بالا باشد واكنش آب </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> ايزوسيانات خيلي راحت ادامه مي يابد . به وضوح ممكن است بعضي پوششهاي استفاده شده در همان محل خواص كاملاً متفاوتي براساس آب و هواي زمان رنگ زني يا اگر سيستم پخت شده است خواص آن به طور عمده تحت تأثير شرايط آن قرار خواهد گرفت .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950979\"></a><a name=\"_Toc460950872\">5 </a>&ndash; 10 وينيل ها:</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">از نظر تئوري ، هر پوشش تكيل شده از پليمريز اسيون افزايش مونومروينيل يا تركيبي از مونومرهاي وينيل باشد مي تواند وينيل در نظر گرفته شود مونومر وينيل هر ملكولي است كه داراي ساختار زير باشد :</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">CH2 = CR1 CR2</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بر اين اساس مشخص مي تواند استدلال نمايد كه پلي(متيل متاكريلات) هم يك وينيل است . با اين حال در صنعت پوشش پذيرفته شده كه لغت &laquo;وينيل&raquo; به گروه نسبتاً كوچكي از مونومرها عمدتاً داراي وينيل استات ، وينيل كلرايد ، وينيليدين فلورايد و وينيل بوتيرال اطلاق مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950980\"></a><a name=\"_Toc460950873\">5 . 10 . 1 وينيل هاي محلولي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وينيل هاي محلولي معمولاً براساس كوپليمرهاي وينيل كلرايد (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">VC</span><span style=\"font-size:16.0pt\">) و وينيل استات (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">VA</span><span style=\"font-size:16.0pt\">) ايجاد مي شوند . كوپليمر </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVC-PVA</span><span style=\"font-size:16.0pt\"> حاصل كه حدود %14 وينيل استات است داراي وزن ملكولي 70000 يا بالاتر است و بسادگي با تبخير حلال خشك&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود . در نتيجه پوشش توليد شده از آنها داراي جامد بسيار كمي است كه با شديد شدن روز افزون قوانين </span><span dir=\"LTR\" style=\"font-size:14.0pt\">VOC</span><span style=\"font-size:16.0pt\"> هر روز كمتر از قبل استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">هر چند كاربرد وينيل هاي محلولي در حال افول است داراي چندين خاصيت مطلوب از جمله مقاومت خوب در برابر اسيدها ، بازها و آب و انعطاف پذيري و مقاومت ضربه خوب مي باشد . زماني اين پوششها كاربرد گسترده اي در صنعت آب و فاضلاب ، در سيستم هاي شيميايي و كاغذ و ساختمانهاي غوطه ور نظير سدها و بندها داشتند . وينيل هاي محلولي علاوه بر مقاومت حلالي بسيار ضعيف ، چسبندگي نسبتاً ضعيفي نيز دارند . به منظور بهبود چسبندگي آنها به فلزات ، مقدار كمي اسيد مالئيك يا وينيل الكل با وينيل استات / وينيل كلرايد كوپليمريزه شود . ساختار قطبي تر اين گروه به صورت عمده چسبندگي را بهبود مي بخشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950981\"></a><a name=\"_Toc460950874\">5 . 10 . 2 پلاسيتسولها و ارگانوسولها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي (وينيل كلرايد) (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVC</span><span style=\"font-size:16.0pt\">) به تنهايي رزين مناسبي براي پوشش نيست چون ترد ، داراي مشكل انحلال و چسبندگي ضعيف مي باشد . با اينحال در صنعت پلاستيك ، ذرات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVC</span><span style=\"font-size:16.0pt\"> داغ داراي وزن ملكولي بالا در نرم كننده كه به پلاستيول معروف است پراكنده مي شوند و كاربردهاي متنوعي دارند . هر چند </span><span dir=\"LTR\" style=\"font-size:14.0pt\">route</span><span style=\"font-size:16.0pt\"> مناسبي براي رنگ يا پوشش نيست وقتي اين پلاستيسولها با حلال رقيق شدند ارگانوسولهاي حاصل ، كاربرد قابل ملاحظه اي براي پوشش دهي كلافها جهت استفاده در سقف و ديوارها دارند . پس از اعمال ، اين پوششها پخت مي شوند تا ذرات پليمري ويژه در فيلم پيوسته ذوب شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">ارگانوسولهاي گيرش يافته داراي خواص مطلوب بسياري كه در قسمت قبل براي وينيل هاي محلولي توضيح داده شد مي باشند . با اينحال انها داراي مشكلات احتمالي خاص خود هستند . بارزترين مشكل آنها چسبندگي ضعيف است چون سيستم رزين ، هنوز </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVC</span><span style=\"font-size:16.0pt\"> بسيار غير قطبي است بنابراين استفاده از آستري بعنوان پوشش واسطه براي بهبود چسبندگي سيستم پوشش به فلز و / يا استفاده از پوشش تبديلي روي فولاد براي بهبود چسبندگي متداول است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">ديگر مشكل احتمالي ارگانوسولها تبخير نرم كننده است هر چند اين كار مي تواند با انتخاب مواد صحيح كاهش يا حذف گردد در صورتيكه نرم كننده اشتباه در محيط بسيار گرم جنوبي استفاده شود تردي پوشش طي يك دوره زماني بتدريج اتفاق&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي افتد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">مشكل احتمالي سوم ارگانوسولها اين واقعيت است كه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVC</span><span style=\"font-size:16.0pt\"> تحت تأثير تخريب بواسطه تماس با حرارت و نور قرار دارد . </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVC</span><span style=\"font-size:16.0pt\"> مي تواند در اثر آزاد كردن اسيد هيدروكلريك و توليد پيوندهاي دو گانه در شاخه اصلي وينيلي دي هيدروكلرينه شود . نه فقط اسيد هيدروكلريك آزاد شده اثر مخربي بر رنگدانه ها و نرم كننده هاي پوشش دارد بلكه سيستم گسترده ايجاد شده ممكن است باعث بي رنگ شدن شديد پوشش شود . بعلاوه با گذشت زمان ، پليمر در اينحالت بواسطه فرايند اكسيد اسيون خودبخود مشابه الكيدها شروع به پيوند عرضي مي نمايد بنابراين منجر به دانسيته پيوند عرضي بيشتر و تردي ناشي از آن مي شود . اين مشكل با استفاده از عوامل تثبيت كننده مناسب به صورت عمده تسكين مي يابد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950982\"></a><a name=\"_Toc460950875\">5 . 10 . 3 وينيل فلورايدها :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوششها مي تواند از پليمرهاي وينيل فلورايد ساخته شوند كه مهمترين آنها پلي (وينيليدين فلورايد) (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVDF</span><span style=\"font-size:16.0pt\">) است پليمر در متداولترين محلولهاي آبي به راحتي حل نمي شود بنابراين به صورت يك پراكندگي شبه پلاستيسول در محلول رزين اكريليك استفاده مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوششهاي پايه </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVDF</span><span style=\"font-size:16.0pt\"> داراي مقاومت شيميايي ، مقاومت در برابر حلال ، مقاومت حرارتي و اتمسفري عالي مي باشد همچنين نسبتاً انعطاف پذير هستند بخاطر دماي بالاي 206-204 درجه سانتيگراد لازم براي ذوب ذزات </span><span dir=\"LTR\" style=\"font-size:14.0pt\">PVDF</span><span style=\"font-size:16.0pt\"> بصورت پوشش چسبنده منسجم ، اينها بصورت عمده به عنوان پوشش هاي با كارايي بالا در </span><span dir=\"LTR\" style=\"font-size:14.0pt\">COIL STOCK</span><span style=\"font-size:16.0pt\"> كه براي ساختمانهاي تجاري به كار مي روند استفاده مي شوند . انعطاف پذيري ، اجازه خم شدن و شكل گرفتن بدون ترك برداشتن را به آنها مي دهد . اين پوششها معمولاً به روش غلطكي معكوس به ضخامت </span><span dir=\"LTR\" style=\"font-size:14.0pt\">MIL</span><span style=\"font-size:16.0pt\">5/1 يا كمتر زده مي شوند.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950983\"></a><a name=\"_Toc460950876\">5 .10 .4 پلي (وينيل بوتيرال)</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي(وينيل بوتيرال) ابتدا با هيدروليز جزئي پلي(وينيل استات) براي توليد كوپليمر وينيل استات و وينيل الكل تهيه مي شود . سپس اين كوپليمر با بوتيرالدئيد براي توليد پلي (وينيل بوتيرال) واكنش مي دهد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">ديگر پلي(وينيل استات) ها با استفاده از الدئيدي غير از بوتيرالدئيد ساخته مي شوند . اين پوششها داراي وزن ملكولي بالا و جامد كم مي باشند . بنابراين با مقادير بسيار كمتر از آنچه بوده اند استفاده مي شوند . چون داراي تعداد خاصي گروه هيدروكسيل ثانويه هستند با مقداري از رزينهاي ديگر در دماي بالا واكنش مي دهند تا خواص خود را اصلاح نمايند . مثلاً وقتي با فنليكها و اپوكسيها واكنش دهند شكل پذيري آستره هاي ظرف(</span><span dir=\"LTR\" style=\"font-size:14.0pt\">CAN</span><span style=\"font-size:16.0pt\">) را زياد مي نمايند</span><span dir=\"LTR\" style=\"font-size:14.0pt\">}</span><span style=\"font-size:16.0pt\">2</span><span dir=\"LTR\" style=\"font-size:14.0pt\">{</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">در صنعت نگهداري پوشش ، پلي (وينيل بوتيرال) ها به عنوان آسترهاي &laquo;</span><span dir=\"LTR\" style=\"font-size:14.0pt\">WASH</span><span style=\"font-size:16.0pt\">&raquo; معروفند كه پوششهاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">TWO-package</span><span style=\"font-size:16.0pt\"> داراي رنگدانه كرومات كه يك جزء داراي مقدار زيادي اسيد سولفوريك است مي باشند . وقتي به عنوان پيش عمليات روي سطح فلز استفاده شوند تشكيل پيوندهاي شيميايي اوليه با فلزي مي دهند و در نتيجه چسبندگي پوششهاي خاص بعدي نظير وينيل هاي اصلاح شده با اسيد مالئيك ، الكيدها و اپوكسي ها را بهبود مي بخشند . اين محصول به خطاي ساخت حساس است بايستي با ضخامت بسيار كم (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">mil</span><span style=\"font-size:16.0pt\">3/. </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> 1/.) اعمال شود و رنگ نهايي طي يك روز يا گاهي فقط پس از چند ساعت اعمال مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950984\"></a><a name=\"_Toc460950877\">5 . 10 . 5 : وينيل هاي&nbsp; </a><span dir=\"LTR\" style=\"font-size:14.0pt\">latex</span> :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">شايد بيشترين كاربرد انحصاري پوششهاي ونييلي ، رنگهاي ساختماني پايه و نييلي لاتكس است . وزن ملكولي بالاي رزين ونييلي ، مشكل ساز نيست چون پوشش ، و سيكوزيته فاز پيوسته كه در اينحالت آب است را </span><span dir=\"LTR\" style=\"font-size:14.0pt\">take on</span><span style=\"font-size:16.0pt\"> مي نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span dir=\"LTR\" style=\"font-size:14.0pt\">tg</span><span style=\"font-size:16.0pt\"> پلي دونييل استات خالص بزرگترند آن است كه در دماي اطاق ، همبستگي خوبي ايجاد شود . هر چند يك روش حل اين مشكل ، استفاده از نرم كننده است پليمريزاسيون مونومرونييل استات با مونواكريليك داراي&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">tg</span><span style=\"font-size:16.0pt\"> پايين متداولتر است كه منجر به توليد وينيل هاي لاتكس اصلاح شده با اكريليك مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">وينيل ها و وينيل هاي اصلاح شده با اكريليك نسبت به اكريليك هاي لاتكس %100 هم از نظر اتمسفر هم هيدروليز ، به وضوح ضعيف است بنابراين به صورت عمده به عنوان پوششهاي داخلي استفاده ميشوند . بيشتر رنگهاي مسطح جداره هاي داخلي ، وينيل لاتكس ها هستند . همچنين در پركننده هاي بلوك ، كاربرد لاتكس ها كه پوشش هاي داراي رنگدانه زياد هستند متداول است كه عمدتاً بعنوان آستري براي پر كردن نقايص ديواره هاي زبر معماري قبل از اعمال رنگ نهايي براقتر و هموارتر به كار مي روند .هر چند پوشش هاي وينيل لاتكس در كاربردهاي خارجي نسبت به اكريليك ها ضعف هستند اين ضعيف مانع از كاربرد آنها در اين قسمت نيست ، بعلاوه اگر به عنوان پركننده بلوك داخلي استفاده شوند در صورتيكه نفوذ آب از ميان جداره خارجي اتفاق بيفتد يا اگر داراي نقص ساخت باشند يا اگر در جاي اشتباه نظير تجهيزاتي كه زير باران قرار دارند&nbsp; ممكن است دچار شكست زودرس شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">شكست در اين پوششها معمولاً زماني كه با پوششهاي پايه حلالي داراي تنش بالا نظير اپوكسي هاي دو جزئي پوشانيده شوند اتفاق مي افتد . حلال اپوكسي ، وينيل حساس به حلال را نرم و تنش انقباض اپوكسي در حال گيرش براي ايجاد شكست پيوستگي در وينيل ضعيف شده كافي است .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چنين شكستهايي در اثر ضخامت بالاتر وينيل يا اپوكسي و با دماي گيرش پايين وينيل پركننده بلوك كه اغلب ممكن است حين ساخت جديد اتفاق بيفتد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">exacerbated</span><span style=\"font-size:16.0pt\">&nbsp;&nbsp;&nbsp;&nbsp; مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950985\"></a><a name=\"_Toc460950878\">5 . 11 پوششهاي قيري :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">عبارت</span><span dir=\"LTR\" style=\"font-size:14.0pt\">&rdquo;</span><span style=\"font-size:16.0pt\"> پوشش قيري </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ldquo;</span><span style=\"font-size:16.0pt\"> در اصل به دليل ماهيت نامشخص موادي كه از انها ساخته&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود باعث گيجي مي شود . در اصل ، منشاء پوشش قيري آسفالت يا قطران است هر چند اين گروه داراي رزين هاي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">coumaron&nbsp; idene</span><span style=\"font-size:16.0pt\"> (كه از كوره هاي كك سازي بدست مي آيد) و رزين هاي هيدروكربني برپايه هيدروكربنهاي با وزن ملكولي كم اشباع نشده كه از محصولات نفت (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">gasoline</span><span style=\"font-size:16.0pt\">) بدست مي آيد نيز مي باشد . تاكنون بيشترين مقدار اين پوششها ، قطران ها و آسفالتها بوده است . هر دو عمدتاً بخاطر معلق بودن ذرات ريز كربن عنصري سياه يا قهوه اي سياه مي باشند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">آسفالت يا از منابع طبيعي يا بصورت باقيمانده تقطير انواع خاصي از روغنهاي نفت خام مي باشد . آسفالت در اصل مخلوط نيم جاري از هيدروكربنهاي بيشمار است كه بيشتر آنها ماهيت آليفاتيك دارند . وقتي آسفالت از منابع طبيعي بدست آيد با مقادير مختلفي مواد معدني ارتباط دارد . آسفالت حاصل از ترينيداد از نظر مقدار مواد معدني در سطح بالايي قرار دارد و عمدتاً براي فرش كردن جاده ها استفاده مي شود در عوض </span><span dir=\"LTR\" style=\"font-size:14.0pt\">GILSONITE</span><span style=\"font-size:16.0pt\"> كه در آمريكاي جنوبي ازرسوبات بدست مي آيد جامد ترد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Jet black</span><span style=\"font-size:16.0pt\"> با مقدار مواد آلي بسيار كم است و براي پوشش هاي آسفالتي مناسب است . اين ماده در حلالهاي كربني حل شده ، با بسياري از روغنها ورزين ها سازگار است . در جلاهاي آسفالتي بسيار براق تا حدي از اين ماده استفاده مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">انواع خاصي از روغنهاي گيرش يافته نظير </span><span dir=\"LTR\" style=\"font-size:14.0pt\">wyoming-sour</span><span style=\"font-size:16.0pt\"> خام ، بيش از %40 آسفالت دارند . آسفالت از باقيمانده فرايند تقطير بدست مي آيد . آسفالت حاصل از نفت خام ، معمولاً به صورت پوشش ترجيح داده مي شوند چون داراي تركيب يكنواخت تر و ناخالصي معدني كمتري مي باشند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوشش هاي آسفالتي نسبتاً خنثي و داراي مقاومت شيميايي و مقاومت در برابر آب عالي هستند همچنين ارزان مي باشند . علاوه بر كاربرد شناخته شده آنها در سقف ساختمانها ، بعنوان پوشش براي فولاد </span><span dir=\"LTR\" style=\"font-size:14.0pt\">Buried</span><span style=\"font-size:16.0pt\"> و ساختمانهاي بتوني استفاده مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">قطران تركيب پيچيده اي از هيدروكربنهاي ، عمدتاً آروماتيك است كه قسمت اصلي مايع تراكم حاصل از تقطير زغال سنگ يا كك را&nbsp; تشكيل مي دهد در نتيجه توليد قطران رابطه نزديكي با توليد فولاد دارد . هر چند توليد فولاد به صورت يكنواخت افزايش پيدا كرده توليد قطران اينگونه نبوده ات چون كوره هاي بلند با بازدهي بيشتر نياز به كك كمتري دارند . هر چند نفتالين عمده ترين تركيب قطران است . فقط در حد %10-6 در آن وجود دارد . تخمين زده مي شود كه قطران داراي 10000-5000 تركيب مختلف باشد كه فقط 300 تا از آنها شناخته شده است </span><span dir=\"LTR\" style=\"font-size:14.0pt\">}</span><span style=\"font-size:16.0pt\"> 3 </span><span dir=\"LTR\" style=\"font-size:14.0pt\">{</span><span style=\"font-size:16.0pt\">. اين تركيبات از مواد داراي وزن ملكولي كم تا اجزاء داراي وزن ملكولي بالا مثل قير قطران مي باشد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">قطران در پوششهاي ضخيم گرم براي تانكها و خطوط لوله استفاده مي شود و در پوششهاي دماي اطاق با مقدار جامد پانيتر براي فولادي كه در آن غوطه ور مي گردد استفاده مي شود اغلب در صنع فاضلاب از آن استفاده مي شود . مشابه آسفالت ، داراي مقاومت شيميايي خوب و مقاومت عالي در برابر رطوبت ، ارزان و بصورت پوششهاي مانعي ضخيم استفاده مي شود . پوششهاي آسفالتي و قطران بخاطر ساختار&nbsp; هيدروكربني ساده ، مقاومت شيميايي بسيارخوب و مقاومت در برابر آب عالي دارند . همچنين داراي نواقصي هستند كه جنبه هاي زيبايي كوچكترين آنهاست . علاوه&nbsp; بر اينكه فقط پوششهاي قطران فقط به يك رنگ ظاهر مي شوند . در برابر نور پايداري كمي دارند كه شايد نتيجه اين مطلب است كه عمدتاً آروماتيك هستند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بخاطر عدم اشباع نسبتاً زياد ، سطح بالايي پوششهاي قيري تماس به اكسيد شدن و تردي دارند . بنا براين ممكن است ترك خورده يا موج بردارد . بعلاوه بخاطر مقاومت ضعيف در برابر حلال ، كاربردهاي خاصي وجود دارد كه اين پوششها در انجا كاربرد ندارد . نه فقط حلالهاي يك محيط صنعتي مي تواند.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">به آنها خسارت بزند بلكه عموماً نبايستي روي آنها پوششهاي پايه حلالي&laquo;متداول&raquo;زده شود چون </span><span dir=\"LTR\" style=\"font-size:14.0pt\">blead through</span><span style=\"font-size:16.0pt\"> سياهرنگ ممكن است ايجاد شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">شايد مهمترين گروه پوشش هاي قيري ، اپوكسي قطران باشد . برخلاف پوشش آسفالت و قطران ، اين پوششها موارد دو جزئي ترموست مي باشند . اپوكسي و شيمي پيوند عرضي مشابه مطالبي است كه در قسمت 5-3 گفته شد ولي هر دو جزء با مقدار زيادي قطران اصلاح شده اند چون علائمي وجود دارد كه اجزاء قطران به آهستگي با رزين هاي اپكسي واكنش مي دهند بسياري از فرمول رنگها داراي جزء قطران همراه با جزء مبدل مي باشند . قطران بخاطر مقاومت شيميايي و مقاومت در برابر آب بهتر ، بجاي آسفالت استفاده مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">قطران واكنش شيميايي كمي با سيستم اپوكسي / مبدل مي دهد ولي از نظر مقاومت شيميايي و مقاومت در برابر آب ، پوشش را بهبود مي بخشد همچنين خواص </span><span dir=\"LTR\" style=\"font-size:14.0pt\">high-buid</span><span style=\"font-size:16.0pt\"> را . همانگونه كه قطران خواص مطلوب خود را با اپوكسي به شراكت مي گذارد اپوكسي نيز از جمله مقاومت به حلال ، استحكام همبستگي بالا ، سختي ، مقاومت در برابر سايش و ضربه را . هر چند اپوكسي ها از نظر مقاوت در برابر نورخورشيد ، معروف نيستند ولي اپوكسي هاي قطران نسبت به قطران نسبت به قطرانها مقاومت آب و هوايي بهتر دارند . با اينحال در ظاهر سطحي آنها ايرادي به نام برنزه شدن اتفاق&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي افتد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اپوكسي هاي قطران ، پوشش بسيار قوي غير قابل نفوذ با مقاومت شيميايي عالي ايجاد مي نمايند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بهمين دليل بصورت گسترده در صنايع دريايي ، صنعت آب و فاظلاب استفاده&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">علاوه بر برنزه شدن سطح اپوكسي قطران ، نواقص ديگر ، شامل مشكلات اعمال و پوشش دهي مجدد است . اين پوششها دو جزئي و بسيار وسيكوز هستند و هميشه احتمال مخلوط كردن ناصحيح وجود دارد . شبيه ديگر موارد دو جزئي ، اعمال آنها در نزديكي انتهاي عمر پس از مخلوط آنها ممكن است مشكلات خيس كردن و كاهش چسبندگي ايجاد نمايد ، بعلاوه اين پوششها ، سريع گيرش پيدا مي كنند و پرداخت نسبتاً صاف ، سخت و دنس ايجاد مي نمايند كه زمان رنگ زني مجدد آنها كوتاه (يك يا دو روز) خواهد بود . براي جلوگيري از جدايش ميان لايه اي اغلب مطلوبست كه آنها را به صورت يك لايه اعمال نمائيم .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950986\"></a><a name=\"_Toc460950879\">5 </a>&ndash; 12 پوششهاي غير آلي و سيليكوني اصلاح شده :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950987\"></a><a name=\"_Toc460950880\">5 . 12 . 1 <strong>پوششهاي س</strong></a>يليكوني :</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">تمام انواع پوششهاي كه تاكنون توضيح داده شده اند براساس چسب هاي آلي (پايه كربني) ساخته مي شوند يا اينحال ، رزين هاي غير آلي پايه سيليكوني و سيليكاتي نيز نقش مهمي در صنعت پوشش دارند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">سيليكونها كه پلي سيلوكسانها نيز ناميده مي شوند داراي ساختار عمومي شكل 5 </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> 38 مي باشند . مونومرهاي استفاده شده براي تهيه اين رزينها ، كلروسيلانهايي نظير تري متيل كلروسيلان و دي فنيل دي كلروسيلان هستند . كلروسيلانها با آب واكنش&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي دهند تا سيلانول توليد نمايند كه با حذف رطوبت متراكم و توليد رزين سيليكوني (يا پلي سيلوكسان)مي نمايد.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اگر از كلروسيلانها استفاده شود پلي سيلوكسان ، خطي خواهد بود . اگر مقداري تري كلروسيلان هم استفاده شود ساختار شاخه اي سه بعدي بدست مي آيد . وجود مونوكلروسيلانها منجر به </span><span dir=\"LTR\" style=\"font-size:14.0pt\">termination</span><span style=\"font-size:16.0pt\"> زنجيره و توليد مواد اليگومري با وزن ملكولي پايين مي شود . اين اليگومرها همانهايي هستند كه به عنوان سيالات يا روغنهاي سيليكوني معروفند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">رزين هاي سيليكوني كه براي پوشش استفاه مي شوند عمدتاً بر پايه دي كلروسيلانها هستند ولي مقدار خاصي مونومر داراي سه گروه عامل لازم است تا زنجيره به شاخه اي شدن و پيوند عرضي كافي برسد.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">اين رزينها معمولاً داراي وزن ملكولي پايين هستند و وقتي اعمال شوند بايستي پخت شوند تا به گيرش كامل و در نتيجه خواصي كه از انها انتظار مي رود برسند . اين واكنش ترموست ، سريع نيست و ممكن است در دماي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">c</span><span style=\"font-size:16.0pt\">232-204 يك ساعت طول بكشد . از كاتاليست هاي خاصي براي پايين آوردن زمان يا دما مي توان استفاه نمود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">بيشترين رزين هاي سيليكوني بر پايه متيل يا فنيل كلروسيلان يا تركيبي از هر دو&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي باشد . تمام آنها داراي مقاومت در برابر اتمسفر و تخريب ماوراءبنفش عالي هستند و بقاي رنگ و براقيت عالي دارند . همچنين در برابر حرارت ، بسيار مقاومند. مقاومت شيميايي آنها بهتر از الكيدها است ولي نه به خوبي بعضي پوششهاي آلي ترموست با كيفيت بالا . همانطور كه انتظار مي رود سيليكونهاي با نسبت متيل به فنيل بالا داراي براقيت و پايداري رنگ بيشتري نسبت به گروههايي كه فنيل بيشتر دارند مي باشند وهمچنين انعطاف پذيرترند . آنهايي كه بيشتر گروه فنيل دارند تا متيل ، در برابر دما مقاومترند . در دماهاي بسيار بالا ، هر جزء آلي كه در پوشش وجود داشته باشد خواهد سوخت و سيليكون ، پيوند عرضي را ادامه مي دهد تا دي اكسيد سيليكون (در اصل ، شيشه) كه داراي وزن ملكولي بالايي است ايجاد نمايد . رنگ دودكش داراي رنگدانه پولكي آلومينيوم ، سالهاست كه براساس اين مكانيزم استفاده مي شود . تا زماني كه پوشش ترد شيشه مانند ، تخريب نشده است در دماي بالا حفاظت دراز مدت ايجاد خواهد نمود .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوشش هاي سيليكون خالص عمدتاً در جاهايي كه مقاومت دمايي ارجح است به كار مي روند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">كاربردهاي متداول عبارتند&nbsp; از : </span><span dir=\"LTR\" style=\"font-size:14.0pt\">staks</span><span style=\"font-size:16.0pt\">&nbsp; ،&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">mufflers</span><span style=\"font-size:16.0pt\">&nbsp; ،&nbsp; </span><span dir=\"LTR\" style=\"font-size:14.0pt\">cookware</span><span style=\"font-size:16.0pt\"> و تجهيزات موتور</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پوششهاي سيليكوني نسبتاً گران هستند و موارد زيادي وجود دارد كه مقاومت حرارتي عالي ، ضروري نيست . در اين موارد ، كارآيي پوششهاي آلي متداول با اصلاح آنها توسط درصد&nbsp; خاصي از سيليكون به مقدار زياد بهبود مي يابد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">شايد متداولترين اين نوع پوششها ، الكيدهاي اصلاح شده با سيليكون مي باشند . در بسياري از موارد ، اين پوشش يك پوشش معمولي است كه با سيليكون به صورت سرد ، همزده يا مخلوط شده است . اين كار به منظور بهبود دوام خارجي الكيد صورت مي گيرد هر چند افزايش مقاومت حرارتي نيز يك اثر جانبي مفيد است . افزودن حدود 20 يا 30 درصد سيليكون ، متداول است خواص اين پوشش در صورتيكه سيليكوني با وزن ملكولي پايين به صورت شيميايي با اكسيد واكنش دهد . بهبود بيشتري مي يابد . واكنش معمولاً بين گروه هيدروكسيل الكيد و گروه سيلانول سيليكون اتفاق مي افتد.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">سيليكونها مي توانند براي اصلاح پلي استرها نيز استفاده شوند . اين رزين بواسطه واكنش سيليكون با پلي استر داراي گروه عامل هيدروكسي تهيه مي شود . محصول بايستي پس از اعمال پخت و پيوند عرضي بيشتري اغلب با رزين هاي فرمالدئيد ملامين ايجاد نمايد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">پلي استرهاي اصلاح شده با سيليكون داراي مجموع اي از خواص عالي نظير انعطاف پذيري ، سختي ، چسبندگي ، مقاومت حرارتي و اتمسفري دارند . بصورت گسترده در فلزات كه پوشش دهي غلطكي مي شوند براي پانلهاي ديوارها و نيز اجاق گاز ولوازم خانگي استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">سيليكونها براي اصلاح اكريليك ها نيز استفاه مي شوند . معمولاً اينها نيز براي پوشش دهي غلطكي استفاده مي شوند و پخت و با رزين ملامين ، پيوند عرضي مي دهند . اين دسته از پوششها ، پرداخت نهايي بسيار عالي ايجاد مي كنند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:16pt\"><strong><a name=\"_Toc460950988\"></a><a name=\"_Toc460950881\">5 .12 . 2 پوششهاي سيليكاتي :</a></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چسب هاي بر پايه تترا اتيل ارتوسيليكات (شكل 5-39) بصورت عمده براي ساخت يكي از مهمترين انواع آسترهاي صنعتي به نام آسترهاي غني از روي غير آلي استفاده مي شوند . چون معمولاً اجزائي داراي گروههايي غير از اپوكسي در آنها استفاده&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي شوند اين پوششها گاهي سيليكاتهاي الكيل يا الكوكسي ناميده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چسب هاي سيليكات اتيل توسط محلولي از تترا استيل ارتوسيليكات كه در اتيل الكل حل مي شود ايجاد مي شود . وقتي مقدار كمي آب به اين محلول اضافه شود هيدروليز جزئي اتفاق مي افتد و درصد خاصي از گروههاي اپوكسي با گروههاي هيدروكسيل جايگزين مي شوند كه مقداري اتيل الكل (</span><span dir=\"LTR\" style=\"font-size:14.0pt\">oh</span><span style=\"font-size:16.0pt\">5</span><span dir=\"LTR\" style=\"font-size:14.0pt\">h</span><span style=\"font-size:16.0pt\">2</span><span dir=\"LTR\" style=\"font-size:14.0pt\">c</span><span style=\"font-size:16.0pt\">)آزاد مي شود . مقداري از&nbsp;&nbsp; تترا اتيل ارتوسيليكات جزئي هيدروليز شده براي ايجاد پليمر اليگو مريك متراكم مي شود و در نتيجه و سيكوزيته زياد مي گردد . </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">چسب هاي جزئي هيدروليز شده قبل از اعمال با مقدار زيادي&nbsp; رنگدانه كرد روي فلزي مخلوط مي شوند (%80 وزني روي متداول است) تا آستري غني از روي توليد شود . پس از اعمال آستري ، پليمر اوليه با رطوبت اتمسفر واكنش و مطابق شكل 5-40 متراكم مي شود . لغت شيميايي براي چسب استفاده شده . اسيد پلي سيليسك است و باور بر اين است كه تا حدي با مقادير كم نمكهاي روي كه به صورت طبيعي در رنگدانه گرد روي فلز موجودند واكنش مي دهد . آستري هاي غني از روي ، مقاومت خوردگي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">suoerb</span><span style=\"font-size:16.0pt\"> دارند چون بالاتر از غلظت حجمي بحراني رنگدانه با رنگدانه (گرد روي) كه فعالتر از آهن است ساخته مي شوند . وقتي روي با فولاد در تماس الكتريك باشدآنرا به صورت گالوانيك محافظت خواهد كرد . بعلاوه وقتي مقداري از روي شروع به خوردگي نمايد محصولات خوردگي تمايل به پر كردن تخلخل پوشش داراي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">pvc</span><span style=\"font-size:16.0pt\"> زياد خواهند نمود بنابراين خاصيت مانعي را بهبود&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مي بخشد . آستري هاي غني از روي غير آلي ، سخت و مقاوم در برابر سايش ، داراي چسبندگي عالي به فولاد درست بلاست شده و مقاومت بسيار خوب در برابر حلالها و حرارت دارند . آنها در حجم زياد براي كاربردهاي مختلف در فولادهالي ساختماني استفاده مي شوند .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">با اين حال آستري هاي غني از روي غير آلي نقايص خاص خود را دارند . مشابه هر پوشش ديگر كه بالاتر از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">cpvc</span><span style=\"font-size:16.0pt\"> ساخته شود ترد و استحكام همبستگي ضعيف و مقاومت ضربه پايين دارند . چون واكنش گيرش با رطوبت اتمسفري در سطح آغاز و مسير خود را به سمت پايين طي مي نمايد . پوششهاي بسيار ضخيمتر از </span><span dir=\"LTR\" style=\"font-size:14.0pt\">mil</span><span style=\"font-size:16.0pt\">4 تمايل به </span><span dir=\"LTR\" style=\"font-size:14.0pt\">mud &ndash; crack</span><span style=\"font-size:16.0pt\"> دارند . هر چند پوششهاي غني از روي غير آلي چسبندگي بسيار خوبي به فولاد دارند چسبندگي ضعيفي نسبت به رنگي از جنس خود دارند اگر پوشش اول ، بيش از حد نازك باشد معمولاً نمي توان پوشش دوم اعمال نمود . خوشبختانه پوشش 5/1 يا </span><span dir=\"LTR\" style=\"font-size:14.0pt\">mil</span><span style=\"font-size:16.0pt\">2 حفاظت خوردگي عالي ايجاد مي نمايد بويژه اگر با ميان لايه اي يا لايه نهايي سازگار پوشش داده شود . مشكل ديگر پوششهاي غني از روي ، شكست در معلق نگهداشتن صحيح رنگدانه گرد روي دنس در ظرف ، حين اسپري است اگر پوشش همزده نشود نسبت رنگدانه به چسب ، نامنطبق خواهد شد .</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in\"><span style=\"font-family:iranyekan\"><span style=\"font-size:10pt\"><span style=\"font-size:16.0pt\">شايد متداولترين مشكل يا شكستي كه يك محقق در چنين پوششهايي با آن برخورد مي نمايد ترك برداشتن آستري در موقع پوشيده شدن با ميان لايه اي اپوكسي (سيستمهاي روي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> اپوكسي </span><span dir=\"LTR\" style=\"font-size:14.0pt\">&ndash;</span><span style=\"font-size:16.0pt\"> يورتان در شرايط صنعتي ، متداول هستند) مي باشد . اغلب اين مطلب بواسطه آستري غني از روي است كه در موقع زدن رنگ نهايي ، هنوز گيرش كافي پيدا نكرده است . در نتيجه حلالهاي نسبتاً قوي اپوكسي فيلم ضعيف (از نظر پيوستگي) موجود را نرم و ضعيف خواهد نمود و تنش انقباض اپوكسي در حال گيرش به اندازه كافي است كه آستري را از همه جدا نمايد . زمان گيرش آستري هاي غني از روي غير آلي بستگي زيادي به رطوبت دارد ، واقعيتي كه در برگه اطلاعات سازندگان رنگ ، تشخيص داده نمي شود .</span></span></span></p>','/app/articles/1544525971547.jpg','/app/articles/1544525972724.jpg','رزین، رنگ، پوشش، پیگمنت ، افزودنی','مقدمه-ای-بر-علم-رزین-ها-و-پوشش-ها',3446,2,1,'2018-12-11 14:29:32','2022-01-11 10:31:55'),(34,1,'افزودنی های مورد استفاده در صنایع رنگ','افزودنی های مورد استفاده در صنایع رنگ موادی هستند که برای دستیابی به خواصی ویژه در فرمولاسیون انواع رنگ استفاده می شوند.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی های مورد استفاده در صنایع رنگ موادی هستند که برای دستیابی به خواصی ویژه در فرآیند تولید، انبارداری، اعمال پوشرنگ و همچنین خواص نهایی پوشش به مقدار کم (در حدود ۰.۱ تا ۲ درصد کل فرمول) در فرمولاسیون انواع رنگ استفاده می شوند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"color:#800080\"><span style=\"font-size:20px\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">انواع افزودنی های مهم مورد مصرف در صنایع رنگ عبارتند از:</span></span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۱-&nbsp;&nbsp;&nbsp;&nbsp; مرطوب کننده و دیسپرس کننده ها</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۲-&nbsp;&nbsp;&nbsp;&nbsp; دیسپرس کننده های پلیمری</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۳-&nbsp;&nbsp;&nbsp;&nbsp; همتراز کننده</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۴-&nbsp;&nbsp;&nbsp;&nbsp; ضد کف</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۵-&nbsp;&nbsp;&nbsp;&nbsp; اصلاح کننده های رئولوژی</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">6-&nbsp;&nbsp;&nbsp;&nbsp; تثبیت کننده نور</span><span dir=\"LTR\"><span style=\"color:black\">&nbsp;UV</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">7-&nbsp;&nbsp;&nbsp; افزودنی پلی یورتان</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">8-&nbsp;&nbsp;&nbsp; ضد رویه</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی های رنگ عمدتا مواد پلیمری عامل دار با جرم مولکولی نسبتا پائین و با ساختارهای منظم می باشند. عملکرد افزودنی های رنگ به ماهیت شیمیایی وساختار آنها بستگی دارد. عوامل شیمیایی اثرگذار روی ساختار پلیمری افزودنی های رنگ شامل گروه های هیدروکسیل، کربوکسیل، فسفات و یا آمین ها می باشند. ساختار افزودنی های رنگ عمدتا بصورت کوپلیمرهای دسته ای (</span><span dir=\"LTR\"><span style=\"color:black\">Block Copolymers</span></span><span style=\"color:black\">) یا پیوندی (</span><span dir=\"LTR\"><span style=\"color:black\">Graft Copolymers</span></span><span style=\"color:black\">) می باشند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی های رنگ ممکن است غیر یونی یا باردار باشند(بار مثبت یا منفی). نوع بار بستگی به نوع عوامل شیمیایی در ساختار افزودنی های رنگ دارد، برای مثال به کمک عوامل کربوکسیل می توان بارهای منفی در ساختار افزودنی ها ایجاد کرد و با عوامل آمینی بار مثبت در ساختار افزودنی ها ایجاد می گردد. به کمک اطلاعات شیمیایی از قبیل عدد هیدروکسیل، عدد اسیدی و عدد آمینی هر نوع افزودنی می توان به نوع عامل های شیمیایی، نوع بار در ساختار و نوع عملکرد فیزیکی و های رنگ پی برد. منومر های تشکیل دهنده افزودنی های رنگ عمدتا به وسیله پلیمریزاسیون تراکمی، حلقه گشا و یا رادیکالی، بطور منظم به یکدیگر متصل شده تا در نهایت ساختار ویژه ای برای انجام وظیفه خاصی، تشکیل شود. اتصالات شیمیایی در ساختار افزودنی های رنگ می تواند استری ، اتری، یورتانی، اوره ای و یا سیلوکسانی باشد.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در ساخت افزودنی های رنگ چیدمان منظم عوامل شیمیایی در ساختار های پلیمری و رسیدن به جرم ملکولی موثر، اهمیت فراوانی دارد. ممکن است برای تهیه یک نوع از افزودنی، دو یا چند نوع از ساختارهای پلیمری با عوامل شیمیایی متفاوت با نسبت های معین با یکدیگر فرموله شود. بدین ترتیب اجزاء تشکیل دهنده افزودنی جدید عملکرد یکدیگر را تقویت کرده و برای رسیدن به یک عملکرد ویژه مقادیر کمتری در فرمولاسیون رنگ مورد نیاز خواهد بود. در سالهای اخیر این نوع از افزودنی های اهمیت فراوانی پیدا کرده اند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">&nbsp;افزودنی های مرطوب کننده و دیسپرس کننده</span></span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی های مرطوب کننده و دیسپرس کننده مورد مصرف در صنایع رنگ از لحاظ ساختار شیمیایی و بار در پنج گروه مختلف تقسیم بندی می شوند :</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۱-&nbsp;&nbsp;&nbsp;&nbsp; دیسپرس کننده های غیر یونی بر پایه کوپلیمرهای آکریلیک- پلی اتر</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۲-&nbsp;&nbsp;&nbsp;&nbsp; دیسپرس کننده های های آنیونی بر پایه کوپلیمرهای پلی کربوکسیلیک اسید-پلی اتر</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۳-&nbsp;&nbsp;&nbsp;&nbsp; مرطوب کننده و دیسپرس کننده &nbsp;های غیر یونی بر پایه کوپلیمرهای دسته ای پلی استر- پلی اتر</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۴-&nbsp;&nbsp;&nbsp;&nbsp; مرطوب کننده و دیسپرس کننده های کاتیونی بر پایه آلیفاتیک پلی آمیدو آمینها</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">۵-&nbsp;&nbsp;&nbsp;&nbsp; مرطوب کننده و دیسپرس کننده های کاتیونی بر پایه پلی اتر-آمینو آکریلاتها</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">تنوع ساختار شیمیایی در این پنج گروه باعث تنوع کاربرد در انواع سیستم های رنگ های پایه آبی و حلالی می شود. بنابراین برای افزا یش دامنه تنوع کاربرد افزودنی های مرطوب کننده و دیسپرس کننده مورد مصرف در صنایع رنگ می توان انواع گریدهای هر کدام از گروه های پنج گانه بالا را توسعه داد.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">&nbsp;افزودنی های همترازکننده</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">افزودنی های همتراز کننده مورد مصرف در صنایع رنگ، کوپلیمرهای پلی سیلوکسان-پلی اترمی باشند. بخش پلی سیلوکسان در کوپلیمرهای همتراز کننده دی متیل سیلوکسان یا متیل فنیل سیلوکسان است و بخش پلی اتر نیز متوکسی پلی اتیلن اکساید یا متوکسی پلی پروپیلن اکساید می باشد.ساختار کوپلیمرها می تواند بصورت کوپلیمرهای پیوندی یا کوپلیمرهای دسته ای باشد. هر کدام از این ساختارها خواص ویژه ای را دارند و برای انواع کاربرد در صنایع رنگ طراحی و ساخته شده اند. نوع دیگری از همتراز کننده ها با ساختار کوپلیمرهای پلی سیلوکسان-پلی اتر آکریلات اخیرا طراحی و ساخته شده است که هردو عملکرد دیسپرس کنندگی وهمتراز کنندگی را به عهده دارند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">&nbsp;افزودنی های ضد کف</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ساختار افزودنی های ضد کف مورد مصرف در صنایع رنگ عمدتا کوپلیمرهای پلی دی متیل سیلوکسان-پلی اتر خطی با جرم ملکولی پائین می باشند&nbsp; .</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">&nbsp;</span><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\">اصلاح کننده های رئولوژی</span></span></strong></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">اصلاح کننده های رئولوژی ساختارهای شیمیایی متعددی دارند. خواص رئولوژی این نوع افزودنی ها به ساختار شیمیایی آنها بستگی دارد. اصلاح کننده های رئولوژی بر پایه سلولز شامل سلولز اترها، کربوکسیل سلولز ها و آمینو سلولزها هستند. در سالهای اخیر انواع جدیدی از های رئولوژی ساخته شده است که نسبت به انواع سلولزی دارای جرم ملکولی پایین بوده و از طریق پدیده تجمعی باعث تغییر رئولوژی فرمولاسیون انواع رنگها می شوند. این نوع از اصلاح کنندها می توانند بدون بار یا دارای بار منفی باشند. برای مثال هرگاه گرید مناسب از پلی اتیلن گلیکول بوسیله دی ایزوسیاناتهای آلیفاتیک تبدیل به پلیمرهای با انتهای ایزوسیانات شده و با اتصال الکلهای چرب مناسب، نواحی غیر آبدوست به دو انتهای آبدوست پلیمر یورتان اتوکسیله متصل شودساختا رهای پلیمری تشکیل شده دارای بدنه آبدوست در وسط و نواحی غیر آبدوست در دو انتها هستند. این ترکیبات از طریق پدیده تجمعی باعث اصلاح رئولوژی فرمولاسیون های رنگ می شوند</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">تثبیت کننده نور<span dir=\"LTR\">&nbsp;UV</span></span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">این افزودنی به صورت مایع می باشد که در فرمولاسیون رنگ به منظور افزایش مقاومت فیلم رنگ در برابر اشعه</span><span dir=\"LTR\"><span style=\"color:black\">&nbsp;UV&nbsp;</span></span><span style=\"color:black\">استفاده می شود. این افزودنی بر پایه هیدروکسی فنیل بنزوتیرازول است و در تمام حلال ها امتزاج پذیر می باشد</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:black\">همچنین برای هر دو پوشش های آب پایه و حلالی استفاده می شود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><br />\r\n<strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">افزودنی پلی یورتان</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">از جمله افزودنی های پلی یورتان شتاب دهنده ها می باشند که در فوم ها، پوشش ها و چسب های پلی یورتان استفاده می شوند. این افزودنی به صورت مایع می باشد و مصرف آن باعث افزایش سرعت ژلاسیون می شود، همچنین موجب می شود سریع تر زمان</span><span dir=\"LTR\"><span style=\"color:black\">&nbsp;Tack-free&nbsp;</span></span><span style=\"color:black\">اتفاق افتد. و خواص مکانیکی را نیز در فوم ها بالا می برد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><br />\r\n<strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">ضد رویه</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">این افزودنی در رنگ های هوا خشک و مرکب ها استفاده می شود. هنگامی که حلال رنگ های پایه حلالی از بین میرود موجب می شود که لایه ای از مواد در رنگ باقی بماند. با اضافه کردن این افزودنی در رنگ از تشکیل این لایه بر روی رنگ جلوگیری می شود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">اهمیت اقتصادی مواد افزودنی در رنگ</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">اگر چه از مواد افزودنی در فرمولاسیون رنگ ساختمانی و رنگ دکوراتیو به مقدار کم&nbsp; استفاده میشود،ولی مقدار مصرف کل آنها بیش از 350 هزار تن در سال تخمین زده شده است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">اهمیت مواد افزودنی در رنگ ساختمان و رنگ های دکوراتیو را نمیتوان براحتی با مقدار تولید یا فروش یا حجم مصرفی توضیح دادو مهمترین اثر تکنولوژیکی مواد افزودنی بر روی خواص نهایی رنگ ساختمانی و رنگ دکوراتیو دیده میشود.با در نظر گرفتن این مطلب که این خود بهترین توضیح در سهم آن برای افزایش کیفیت پوششها می باشد،این اهمیت هنوز به شکل اقتصادی قابل توصیف نیست.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p style=\"margin-left: 0in; margin-right: 0in; text-align: right;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;<img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/3/paper/افزودنی های مورد استفاده در صنایع رنگ.png\" style=\"height:290px; width:500px\" /></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">همانطور که در جدول بالا مشاهده میشود ،وزن مواد افزودنی در رنگها نسبت به مواد دیگر کمتر میباشد.ولی قیمت مواد افزودنی نسبت به متوسط قیمت مواد مصرفی در رنگ ساختمانی و رنگ دکوراتیو بیشتر میباشد.باوجود بر این،مواد افزودنی سهم کمی در قیمت کل رنگ های ساختمانی و رنگ های دکوراتیو&nbsp; و پوششها دارند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">در گذشته مواد افزودنی رنگ جز فرمولاسیون اصلی رنگ ساختمان و رنگ دکوراتیو نبوده و معمولا بعنوان مواد اضافی موضعی یرای اصلاح رنگ ساختمانی و رنگ دکوراتیو،به غیر از مشخصاتی که مورد نظر بوده استفاده میشد.به تدریج این تصور تغییر کرد،وامروزه مواد افزودنی در بسیاری از موارد بعنوان جز مکمل فرمولاسیون مواد رنگی است و از ابتدای ساخت رنگ ساختمان و رنگ دکوراتیو&nbsp; در یک نسخه رنگ گنجانده میشود و برای فرمول نویس رنگ ساختمان و رنگ دکوراتیو یک ضرورت است.&nbsp;</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">برگرفته از وب سایت:</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"http://www.unionpigments.com/blog/%D8%A7%D9%81%D8%B2%D9%88%D8%AF%D9%86%DB%8C-%D9%87%D8%A7%DB%8C-%D9%85%D9%88%D8%B1%D8%AF-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%AF%D8%B1-%D8%B5%D9%86%D8%A7%DB%8C%D8%B9-%D8%B1%D9%86%DA%AF\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">WWW.UnionPigments.Com</span></span></span></a></span></p>','/app/articles/1545564599658.jpg','/app/articles/1545564600660.jpg','افزودنی ,رنگ ,Additive,آمازون تله,فروش مواد شیمیایی,فروش انلاین','افزودنی-های-مورد-استفاده-در-صنایع-رنگ',986,2,1,'2018-12-23 15:00:00','2022-01-10 00:57:22'),(35,3,'تاثیر آب و هوا روی پوشش ها      ','پوشش­ها باید ویژگی­های کلیدی همچون ظاهر(رنگی یا براق)، ویژگی­های عملکردی(بازتاب در پوشش­های سقف) و یا ویژگی­های حفاظت در برابر خوردگی داشته باشند','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-size:22px\"><span style=\"color:mediumblue\">تاثیر آب و هوا روی پوشش ها</span>&nbsp;&nbsp; &nbsp;</span> &nbsp; &nbsp;</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">پوشش&shy;ها باید ویژگی&shy;های کلیدی همچون ظاهر(رنگی یا براق)، ویژگی&shy;های عملکردی(بازتاب در پوشش&shy;های سقف) و یا ویژگی&shy;های حفاظت در برابر خوردگی(برای پل&shy;&nbsp;های فلزی یا کارخانجات صنعتی) داشته باشند. این سه عامل حتی می&shy;توانند در شرایط محیط بیرونی موجب شکست پوشش گردد. ما باید در توسعه و تحقیق محصولات خود آن&shy;ها را به اندازه کافی آزمایش کرده تا متوجه شویم که چگونه می&shy;توان دوام و پایداری آن&shy;ها را بهبود بخشید و یا زمان سرویس و تعمیر آن&shy;ها را دریابیم. هم&shy;چنین باید عملکردشان در شرایط جوی متفاوت، روش متفاوت اجرای هر کدام، انواع زیرآیند&shy;ها و سایر شرایط بحرانی و تعیین کننده را نیز درنظر بگیریم</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">تاثیر آب و هوا روی پوشش&shy;ها</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">بیشترین آسیب&shy; های آب و هوا روی پوشش&shy;ها شامل مواردی چون تشعشات نور خورشید، رطوبت و گرماست. نور فرابنفش (</span><span dir=\"LTR\"><span style=\"color:black\">UV</span></span><span style=\"color:black\">) قسمتی از نور خورشید است که انرژی کافی برای شکستن پیوند&shy;های شیمیایی و شروع واکنش تخریبی رادیکال آزاد در مورد ترکیبات آلی را دارد. این مورد بویژه برای طول موج&shy; های کوتاه&shy;تر یعنی&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">UV-A</span></span><span style=\"color:black\">&nbsp;و&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">UV-B</span></span><span style=\"color:black\">&nbsp;محتمل&shy;تر است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">شیمی برخی از پوشش&shy;ها مانند اپوکسی و پلی استر، به این تشعشات بسیار حساس هستند و در این شرایط طول عمر بالایی نخواهند داشت، در حالی که برخی دیگر مانند فلوروپلیمر&shy;ها بسیار در این شرایط مقاوم اند. مقاومت در برابر تابش فرابنفش بسیاری از پوشش&shy;ها در حد قابل ملاحظه&shy;ای با افزودنی&shy; های پایدار کننده بهبود می&shy;یابد، اما بطور کامل عملی نخواهد بود. بسیاری از این طرح&shy;های پایداری نیز هنوز سطح وسیعی از پوشش را محافظت نمی&shy;کنند و این سطوح همان جاهایی هستند که تخریب آغاز می&shy;گردد. تخریب سطح معمولا با کاهش براقیت، گچی شدن، ترک، کاهش قدرت رنگی و زرد شدن همراه خواهد بود. اگر نور فرابنفش از پوشش عبور کند، زیرآیند&shy;هایی مانند چوب را تخریب کرده، در نتیجه اتصال بین پوشش و زیرآیند و در نهایت چسبندگی از بین می&shy;رود.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">طول موج&shy;های بلندتر فرابنفش(</span><span dir=\"LTR\"><span style=\"color:black\">UV-A</span></span><span style=\"color:black\">) و هم&shy;چنین نور مرئی می&shy;توانند شروع کننده واکنش تخریب نوری باشند. بسیاری از رنگدانه &shy;ها بخصوص رنگدانه&shy; های آلی، و محصولات حاصل از تخریب نوری مانند پراکساید&shy;ها به این طول موج حساسند. امواج مادون قرمز نزدیک موجود در نور خورشید می&shy;تواند باعث گرم شدن رنگدانه&shy;ها شود چیزی که در مورد رنگ&shy;های تیره خودرو&shy;ها در هوای گرم مشاهده می&shy;شود. این حرارت هم می&shy;تواند از طریق جنبش&shy;های مکانیکی-حرارتی باعث تخریب و هم باعث افزایش نرخ از دست دادن پایدار کننده&shy;ها و تسریع تخریب شیمیایی شود.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">رطوبت نیز یک عامل مهم در تخریب پوشش&shy;ها (اعم از آلی یا معدنی) و سطوح است. بسیاری از پوشش&shy;ها بدلیل انجام واکنش هیدرولیز تخریب می&shy;شوند. دلایل تخریبی دیگر ناشی از تورم و آب رفتن (انقباض) از سطح تر به خشک و برعکس است. رطوبت با از بین بردن تثبیت کننده&shy;ها شرایط مناسبی را برای رشد میکروارگانیزم&shy;هایی چون کپک فراهم می&shy;کند. بعضی از پوشش&shy;ها مانند پوشش&shy;های بتنی باید تنفس پذیر (تراوا نسبت به رطوبت) باشند تا امکان تنفس برای زیرآیند فراهم شود در حالی&shy;که پوشش&shy;های محافظتی ضد خوردگی باید کاملا نسبت به رطوبت غیرتراوا باشند تا بتوانند از سطح حفاظت کنند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">هر کدام از پارامتر&shy;های اصلی آب و هوا (رطوبت، نور و حرارت) مستقل نیستند. نور می&shy;تواند دما را تحت تاثیر قرار دهد که آن&shy;هم روی رطوبت اثرگذار است. بعلاوه شرایط بیرونی اصلا پایدار نیست. هرکدام از این پارامتر&shy;ها در هر مکانی و در دوره&shy; ها و بازه&shy; های مختلفی (ساعت، روز، فصل، سال، الگو&shy;های آب و هوایی) با الگو&shy;های پیچیده و غیر قابل بازیافتی تغییر می&shy;کنند. پوشش لوله &shy;ها در کارخانجات صنعتی، یا پوشش&shy;های دریایی می&shy;توانند فشار&shy;های اضافی مهمی را ایجاد کنند. &nbsp;</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">علاوه بر این، بسیاری از شرایط ثانویه جویمانند باد، آلودگی&shy;های جوی و سایر می&shy;توانند به این لیست اضافه شوند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">آزمون&shy;های جوی</span></span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">شرایط جوی متنوعی در سرتاسر جهان وجود دارد. به طور کلی، سه دسته از آب و هوا که اثرات تخریبی روی مواد و از جمله پوشش&shy;ها دارند شامل: گرم/ مرطوب (زیر مجموعه گرمسیری)، گرم و خشک(بیابانی) و سردسیری هستند. پوششی که به شیمی و الزامات عملکردی خاصی وابسته باشد، می&shy;تواند در شرایط جویمختلف، بسیار متفاوت عمل کند. این امر معمولا نیازمند انجام آزمون&shy;های بیرونی در شرایط جوی متفاوت است. با این حال، آب و هوای نیمه گرمسیری و گرم و مرطوب فلوریدای جنوبی به لحاظ تاریخی به عنوان مرجع اولیه انجام آزمون&shy;های جویبرای انواع پوشش&shy;ها استفاده شده &shy;است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">این امر بدلیل ترکیب شرایط ناشی از تابش شدید نور خورشید، درجه حرارت بالا و رطوبت شدید است که نسبت به مواد آلی بسیار محرک عمل می&shy;کنند. سایر نقاط جهان آب و هوای مشابهی دارند مانند منطقه اطلس و هند. اما جنوب فلوریدا به دلایل ذکر شده به عنوان شاخص اصلی جهانی برای بررسی آزمون&shy;های پوشش تبدیل شده است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">بسیاری از استاندارد&shy;های عملکردی پوشش&shy;ها نیازمند انجام آزمون&shy;های غوطه وری در منطقه فلوریداست. بسیاری از شرکت&shy;های پوشش در سراسر جهان، مکان&shy;هایی را در این منطقه برای انجام آزمون&shy;های تجاری نگه داری می&shy;کنند. شرکت اطلس یک شبکه نمایشی جهانی با بیش از 25 مکان آزمایشی را برای تولیدکنندگانی که نیاز به آزمایشات در شرایط جویمنطقه ای دیگر دارند، فراهم آورده&shy;است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">غوطه&shy;وری پوشش&shy;های فلوریدای جنوبی ممکن است در جهات مختلفی انجام شود. امروزه قرار گیری و غوطه&shy;وری مستقیم به سمت مناطقی چون استوا متمایل است و بیش&shy;تر آزمون&shy;های جهانی در نوار&shy;هایی با عرض جغرافیایی 15 تا 35 درجه که به دلیل تابش زیاد خورشید دمای بالایی دارند، انجام می&shy;شود. با این&shy;حال برخی از مکان&shy; های با آب و هوای سرد نیز وجود دارند که می&shy;تواند برای پوشش و زیرآیند&shy;های حساس به رطوبت و سرما مهم باشند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مکان&shy;های آزمایشی بسیار گرم مانند آزمایشگاه&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">DSET</span></span><span style=\"color:black\">&nbsp;اطلس در صحرای سونور آریزونا و صحرای کالاهاری در آفریقای جنوبی برای انجام آزمایشات پوشش&shy;های خودرویی استفاده می&shy;شوند. به طور میانگین، منطقه آریزونا حدود 20% بیش&shy;تر از منطقه فلوریدا در معرض تابش نور فرابنفش قرار دارد اما حدود 5% مرطوب&shy;تر بوده و دمای تابستان بالاتر و زمستان پایین&shy;تری (زیر نقطه انجماد) دارد. به همین دلیل قرارگیری در منطقه آریزونا می&shy;تواند در مورد تخریب پیوند&shy;ها و از دست رفتن قدرت رنگی از جهت تابش فرابنفش شدید&shy;تر باشد.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">شتاب دهنده&shy;های جوی</span></span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">تحقیق و توسعه پوشش&shy;ها و آزمایشات همیشه نمی&shy;توانند منتظر آزمون&shy;های غوطه&shy;وری در معرض نور طبیعی بیرونی باشند. چرا که اینکار برای تصمیم &shy;گیری&shy;های پیرامون فرمولاسیون بسیار زمان بر است. از این رو به آزمون&shy;های سریع&shy;تر نیاز است که به دو روش انجام می&shy;پذیرند: آزمون&shy;های تسریع شده بیرونی با استفاده از نور خورشید متمرکز و آزمون&shy;های آزمایشگاهی با استفاده از شبیه سازی نور خورشید و شرایط آب و هوایی.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">شرکت اطلس از سال 1958 در استفاده از نور خورشید متمرکز برای آزمایشات پوشش با دستگاه&shy;های&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">EMMA</span></span><span style=\"color:black\">&nbsp;و&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">EMMAQUA</span></span><span style=\"color:black\">&nbsp;پیشرو است. در این دستگاه از ده تابنده ویژه فرسنل برای متمرکز کردن نور خورشید و تابش فرابنفش بر روی نمونه &shy;ها استفاده شده&shy;است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">این دستگاه&shy; ها در طول روز نور خورشید را ردیابی می&shy;کنند و ده تصویر از خورشید را روی نمونه هدف متمرکز می&shy;کند. سپس نمونه&shy; های هدف به منظور این&shy;که دمای آن&shy;ها نزدیک به دمای شرایط آزمایش شود، خنک می&shy;شوند. برای تر کردن سطح یا ایجاد شوک حرارتی بصورت روزانه یا در طول شبانه روز می&shy;تواند توسط اسپری&shy;های آبرسانی دوره ای برنامه ریزی شده انجام گیرد.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">به عنوان مثال در مورد شبیه ساز نور خورشید، تمرکز نور حدود 8 برابر قرار گیری در معرض نور مستقیم است. این شتاب بصورت فصلی وابسته به خورشید است و بنابراین شدت آزمون در فصل تابستان بیش&shy;تر است. تغییرات ویژه برای کنترل درجه حرارت و رطوبت بمنظور ایجاد ارتباط بهتر برای مواجهه با این عوامل امکان پذیر است. این تکنیک معمولا بطور گسترده در پوشش&shy;های خودرویی و معماری روی فلز بکار می&shy;رود. البته این روش در سطوح چوبی به دلیل هدایت حرارتی کم و حساسیت دمایی و رطوبتی آن، مطلوب نیست. بدلیل نیاز به شرایط جوی ویژه، این دستگاه&shy; ها فقط برای آماده&shy; سازی در آب و هوای خشک همانند منطقه آریزونا مناسب هستند.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">انتقال شرایط جوی به آزمایشگاه</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ایجاد شرایط آزمایشگاهی مطابق با شرایط بیرونی برای اولین بار توسط شرکت اطلس و برای معرفی دستگاه&shy; های لامپ آرک زنون در سال 1916 بمنظور آزمایش محو شدن رنگ آغاز شد. با پیشرفت&shy;های تکنولوژی در شبیه&shy;سازی منابع نوری و مراقبت&shy;های محیط زیستی، شرکت اطلس اولین روش آزمایش شتاب داده شده پوشش&shy;ها را بوسیله دستگاه&shy;های</span><span dir=\"LTR\"><span style=\"color:black\">Weather-Ometer</span></span><span style=\"color:black\">&nbsp;و&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">Xenotest</span></span><span style=\"color:black\">&nbsp;و&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">Sunset</span></span><span style=\"color:black\">&nbsp;توسط لامپ آرک زنون و فیلتر&shy;های نوری ارائه داد.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">دستگاه غوطه&shy;وری دیگری به نام&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">fluorescent-condensatino</span></span><span style=\"color:black\">&nbsp;بر اساس امواج&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">UV-A340</span></span><span style=\"color:black\">&nbsp;و لامپ فلوروسنت فرابنفش بوجود آمد. قرار گرفتن در معرض نور معمولا طی یک دوره متراکم رطوبتی تاریک تغییر می&shy;کند. این دستگاه &shy;ها از قبیل&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">UVTest</span></span><span style=\"color:black\">&nbsp;در توسعه و تحقیق پوشش&shy;ها استفاده می&shy;شوند. این روش در مورد نمونه&shy; های مقاوم در برابر نور فرابنفش و رطوبت نسبتا ارزان و بسیار کارامد است. از آنجایی که همبستگی با شرایط جوی بیرونی برای ویژگی&shy; های ظاهری مانند براقیت و پایداری رنگی می&shy;تواند ضعیف باشد، لذا به عنوان یک دستگاه تطبیق دهنده شرایط جویبه حساب نمی&shy;آید. این عدم همبستگی برای محیط&shy; های بیرونی به دلیل محدودیت طیف لامپ&shy; های فرابنفش و کنترل دمای محدود شده در مقایسه با دستگاه زنون است.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مطابقت طیفی با تابش تشعشات واقعی، همراه با کنترل دما و رطوبت، استاندارد&shy;های لامپ آرک زنون برای&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">ISO</span></span><span style=\"color:black\">،&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">DIN</span></span><span style=\"color:black\">،&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">ASTM</span></span><span style=\"color:black\">&nbsp;و سایر استاندارد&shy;های بین المللی و جزء اساسی تخمین زمان سرویس دهی پوشش&shy;ها در مطالعات تحقیق و توسعه می&shy;باشد. در حالی&shy;که اولین دستگاه زنون برای شرایط جویتوسط شرکت اطلس معرفی شد، اما این نوآوری پس از سال 1979 و با معرفی دستگاه تابش اتوماتیک(بر اساس شدت نور)، نظارت و کنترل شد. این روش بخصوص برای پوشش&shy;های صنایع خودروسازی و برای پوشش&shy;های بیرونی سازگاری داشت.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">کمیته&shy;های استاندارد مانند&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">ISO</span></span><span style=\"color:black\">،&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">ASTM</span></span><span style=\"color:black\">،&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">SAE</span></span><span style=\"color:black\">&nbsp;و ... روش&shy;های آزمون&shy; استاندارد را بر اساس بهترین دانش فنی موجود و تکنولوژی ابداع کردند. در همان وقت، متاسفانه فرآیند مدرن کردن و نوسازی استاندارد&shy;ها خودبخود با روش&shy;هایی که کمترین تکنولوژی و سازگاری بیش&shy;تر با سیستم&shy;های قدیمی&shy;تر را داشت، مقایسه می&shy;شد. این امر بویژه در سال 2000 در صنعت خودروسازی ایالت متحده آمریکا، به سر آمد</span></span></span></span></p>','/app/articles/1545565575195.jpg','/app/articles/1545565575529.jpg','رنگ,پوشش,آزمونهای جوی','تاثیر-آب-و-هوا-روی-پوشش-ها-1',497,3,0,'2018-12-23 15:16:15','2022-01-11 06:03:55'),(36,3,'پیگمنت های آلی و معدنی و مستربچ','رنگدانه‌های معدنی طبیعی از پوسته زمین استخراج می‌شوند، خرد شده، شسته شده، از لحاظ اندازه درجه‌بندی می‌شوند','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"font-size:22px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">پیگمنت های آلی و معدنی و مستربچ</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><strong><span style=\"color:#006400\">۱<span dir=\"LTR\">- </span>معدنی<span dir=\"LTR\"> :</span></span></strong><br />\r\n<span style=\"color:black\">رنگدانه&zwnj;های معدنی طبیعی از پوسته زمین استخراج می&zwnj;شوند، خرد شده، شسته شده، از لحاظ اندازه درجه&zwnj;بندی می&zwnj;شوند. غالباً برای این رنگدانه&zwnj;های طبیعی، معادل مصنوعی هم وجود دارد، یعنی رنگدانه از اجزاء دیگری در اثر یک فرایند شیمیایی ساخته می&zwnj;شود. ظاهراً از نظر شیمیایی با نمونه طبیعی یکسان است، ولی اغلب خواص متفاوتی دارد و معمولاً به خاطر شکل بلوری مطلوبتر، خلوص بیشتر و دانه&zwnj;بندی مطلوبتر ، مرغوبتر از نوع طبیعی می باشد. پیگمنت&not;های غیر پوششی یا اکستندر مثل کربنات کلسیم و باریت و تالک و &hellip; هم وجود دارد. پیگمنت سفید پیگمنت معدنی طبیعی است. پیگمنت رنگی معدنی مثل اکسید زرد آهن اکسید قرمز آهن اکسید سیاه آهن پیگمنت رنگی معدنی مصنوعی مثل کرم سبز و سرب قرمز اکسید مس پیگمنت های فلزی معدنی مصنوعی مثل پودر آلومینوم برنز و روی</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">عمده&zwnj;ترین رنگدانه&zwnj;های معدنی</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">&nbsp;&nbsp;&nbsp; <span style=\"color:black\">پیگمانهای سفید</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">&nbsp;&nbsp; <span style=\"color:black\">پیگمانهای قرمز سرنج</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">&nbsp;&nbsp;&nbsp; <span style=\"color:black\">شنگرف</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">&nbsp;&nbsp;&nbsp; <span style=\"color:black\">پیگمانهای زرد و نارنجی</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">&nbsp;&nbsp;&nbsp; <span style=\"color:black\">پیگمانهای آبی</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">&nbsp;&nbsp;&nbsp; <span style=\"color:black\">پیگمانهای لاجورد یا اولترامارین</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">&nbsp;&nbsp;&nbsp; <span style=\"color:black\">پیگمانهای سبز</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"font-size:18px\"><span style=\"color:#006400\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\">۲<span dir=\"LTR\">-</span>آلی<span dir=\"LTR\"> :</span></span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">امروزه رنگدانه&zwnj;های آلی به مراتب بیشتر از رنگدانه&zwnj;های معدنی می&zwnj;باشند. بعضی از جدیدترین رنگدانه&zwnj;ها ساختمان آلی فلزی دارند. بیشتر رنگدانه&zwnj;های آلی، مواد شیمیایی آلی هستند که روی یک هسته معدنی هیدروکسید آلومینیوم رسوب داده شده&zwnj;اند. از مهمترین رنگدانه&zwnj;های آلی می&zwnj;توان به گروه فتالوسیانین&zwnj;ها اشاره کرد که طیف رنگهای آبی و سبز را در بر می&zwnj;گیرند و فتالوسیانین مس ، رنگدانه آبی می&zwnj;باشد که به علت خواص مقاومتی خوب در برابر عوامل مختلف، یک رنگدانه با ارزش به شمار می&zwnj;رود. فتالوسیانین&zwnj;ها را از فتالیک و اوره سنتز می&zwnj;کنند. رنگدانه&zwnj;های آلی، به صورتی که امروزه در صنعت استفاده می&zwnj;شوند، در طبیعت یافت نمی&zwnj;شوند و تقریباً همه آنها سنتزی می&zwnj;باشند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">تفاوت پیگمنت آلی و معدنی در خواص زیر است</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">یک فیلم براق و جذاب در فام های گوناگون با پیگمنت آلی بدست می آید تا با معدنی، خالص ترین پیگمنت سفید دی اکسید تیتانیم و سیاه ترین پیگمنت سیاه کربن بلک است که هر دو جزء پیگمنت معدنی است و بدین ترتیب پیگمنت آلی به صورت سیاه و سفید موجود نمی باشد. تعداد بسیار کمی از پیگمنت های آلی در بالاتر از ۳۰۰ درجه سانتیگراد پایدار می باشندکه ممکن است متلاشی یا ذوب گردند در حالیکه پیگمنت معدنی بالعکس</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">مهمترین ویژگی هایی که در انتخاب یک پیگمنت مورد توجه قرار میگیرند، عبارتند از</span><span dir=\"LTR\"><span style=\"color:black\"> :</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">طبیعت شیمیایی</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">ساختار کریستالی</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">شکل ذرات</span><br />\r\n<span style=\"color:black\">ابعاد ذرات و توزیع آن</span><br />\r\n<span style=\"color:black\">ضریب شکست</span><br />\r\n<span style=\"color:black\">مشخصات پخش شدگی</span><br />\r\n<span style=\"color:black\">رنگ بندی و سایر مشخصات فیلم رنگ</span><br />\r\n<span style=\"color:black\">مقاومت دربرابر شرایط مختلف جوی و نوری</span><br />\r\n<span style=\"color:black\">مقاومت در برابر اسیدها و بازها</span><br />\r\n<span style=\"color:black\">مقاومت در برابر حرارت</span><br />\r\n<span style=\"color:black\">و سایر فاکتورهای مهمی که در بخش ماندگاری و مقاومتی مد نظر هستند</span><span dir=\"LTR\"><span style=\"color:black\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:#fdfdfd\"><span style=\"color:black\">زمان استفاده از پیگمنت ها، آلی و معدنی بودن روی خواص حرارتی و نوری تاثیر میگذارد و مهم می باشد. پیگمنت معدنی تا ۲۰۰ درجه سانتیگراد را تحمل میکند و پیگمنت های آلی تا دمای ۳۰۰ درجه سانتیگراد را تحمل می&not;کند. پیگمنت های آلی نسبت به پیگمنت های معدنی خواص نوری بهتری دارند و برای مصارف بیرون ساختمانی مخصوصا شلنگ و کابل ها بهتر است از پیگمنت های آلی استفاده شود، زیرا در معرض آفتاب رنگ پیگمنت های معدنی میپرد. پیگمنت های معدنی اکسید هستند و به سختی رنگ باز میکنن و رنگ محصول نهایی را مات میکند. همچنین استفاده از پیگمنت های معدنی خواص را به شدت کاهش می دهد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">یک مستربچ رنگی از چه اجزایی تشکیل شده است؟</span><br />\r\n<span style=\"color:black\">مستربچ از رنگدانه , پخش کننده و عامل حمل کننده تشکیل شده است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">عامل اول, رنگ دانه ها</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><br />\r\n<span style=\"color:black\">رنگدانه به دو دسته تقسیم می شود, پیگمنت و دای. عموما پیگمنت ها به دو دسته تقسیم می شوند, آلی نظیر فتالو سیانین سبز و پیگمنت رنگی معدنی نظیر اکسید آهن قرمز و یا تیتانیوم. دای مانند یک جوهر یا رنگ بی اثر است. عموما&rdquo; نمی توان دای را برای رنگ کردن پلی اولفین استفاده کرد. از طرف دیگر باعث مهاجرت می گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">تفاوت اصلی این دو گروه در استاندارد</span><span dir=\"LTR\"><span style=\"color:black\"> (DIN 559444) </span></span><span style=\"color:black\">به اختصار چنین بیان شده است, تحت شرایط عمومی فرایند, پیگمنت ها موادی هستند که در پلاستیک حل نمی شوند در حالی که دای ها در پلاستیک حل می شوند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">عامل دوم پخش کننده</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><br />\r\n<span style=\"color:black\">موجب می شود سطح رنگدانه مرطوب گردد و این موضوع برای پخش شدن بیشتر در پیگمنت مفید است ضمنا&rdquo; رزین را نیز پایدار می کند بدون آنکه روی کیفیت رنگ محصول تاثیر بگذارد. پلی اتیلن با جرم مولکولی پایین یا واکس یا استئارات روی نیز به عنوان پخش کننده استفاده می گردد. در مستربچ پلاستیک های مهندسی از واکس, استئارات منیزیم و استارات کلسیم برای این منظور استفاده می گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">عامل سوم حمل کننده</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><br />\r\n<span style=\"color:black\">رزین حمل کننده موجب می شود که پیگمنت یکنواختی توزیع گردد و به راحتی به شکل گرانول در بیاید. باید سازگاری با رزین و عامل پخش باشد. سیالیت حامل بایستی از سیالیت رنگدانه و رزین بیشتر باشد و این بطور مشابه بر روی کیفیت محصول پس از رنگ شدن تاثیر می گذارد. برای مثال ما پلیمری با شاخص مذابی انتخاب می کنیم که می تواند مستربچ را در خود حل کند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">ما</span><span dir=\"LTR\"><span style=\"color:black\"> LDPE&nbsp; </span></span><span style=\"color:black\">را به عنوان حامل رنگ مستربچ</span><span dir=\"LTR\"><span style=\"color:black\"> PP/PE&nbsp; </span></span><span style=\"color:black\">انتخاب می کنیم</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">فرمول کلی اکثر مستربچ های رنگی تشکیل یافته از</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><br />\r\n<span style=\"color:black\">دو نوع پایدار کننده و دو نوع روان کننده داخلی و خارجی رنگینه و پایه پلیمری مورد نظر, بنابر این مستربچ هرگز یک رنگدانه تنها نیست, بلکه اغلب با دو نوع پایدار کننده و یک یا دو نوع روان کننده دیگر همراه است. با کمک مستربچ پلاستیک مورد نظر را به رنگ های مختلفی می توان در آورد. نوع دیگری از مستربچ وجود دارد که کدر است و معمولا برای رنگ آمزی پلاستیک های غیر شفاف مورد استفاده قرار می گیرد. نکته بسیار مهم در انتخاب مستربچ, سازگاری پلاستیک با رنگ و سایر افزودنی های همراه آن مستربچ است که معمولا شرکت های سازنده, این مورد را برای مصرف کننده دقیقا مشخص می کنند. از آنجا که مستربچ ها برای تعداد محدودی از پلاستیک های پر مصرف صنعتی ساخته می شوند, لازم است در مورد توانایی رنگ آمیزی پلاستیک ها با رنگ دانه نیز اطلاعاتی ارائه کرد. بنابر ماهیت شیمیایی پلاستیک می توان رنگ مورد نظر را برای آن انتخاب نمود. با توجه به اطلاعات بیان شده در جدول زیر مثلا پلی اتیلن, پلی پروپیلن و پی وی سی را توسط تیتان می توان به رنگ سفید در آورد و یا آنرا با اکسید های کروم به رنگ زرد یا قهوه ای در آورد. ولی از رنگ های ترکیبات آبی آهن نمیتوان در فرمولاسیون پلی اتیلن و پلی پروپیلن استفاده نمود. برای پخش رنگ های معدنی در آمیزه, اختلاط اجزای فرمول روی دستگاه غلتک</span><span dir=\"LTR\"><span style=\"color:black\"> (roll mill)&nbsp; </span></span><span style=\"color:black\">معمول است که گاه از یک نرم کننده مانند</span><span dir=\"LTR\"><span style=\"color:black\"> (DOP) </span></span><span style=\"color:black\">نیز استفاده می شود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">فرایند تولید مستربچ</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><br />\r\n<span style=\"color:black\">برای اختلاط رنگ و افزودنی با پایه پلیمری و تولید مستربچ از اکسترودر دو پیچه همسو گرد نیز استفاده می گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">این فرایند شامل: وزن کردن, وارد کردن خوراک, انتقال, ذوب کردن, پخش کردن و همگن کردن, خارج کردن گازهای مزاحم , فیلتر کردن و گرانول کردن می باشد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">اختلاط شامل ۴ مرحله است</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><br />\r\n<span style=\"color:black\">مرطوب کردن پیگمنت افزودنی و پرکننده</span><br />\r\n<span style=\"color:black\">مخلوط کردن و پخش کردن پیگمنت و افزودنی در پلیمرپایه</span><br />\r\n<span style=\"color:black\">توزیع پیگمنت,افزودنی و پرکننده در مذاب پلیمری</span><br />\r\n<span style=\"color:black\">پایدار کردن این مخلوط و جلوگیری از گلوله یا کلوخه شدن</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\">&nbsp;</p>','/app/articles/1545566786571.jpg','/app/articles/1545566787842.jpg','پیگمنت,مستربچ,آلی,معدنی,آمازون تله, فروش مواد شیمیایی,فروش انلاین','پیگمنت-های-آلی-و-معدنی-و-مستربچ',1634,3,1,'2018-12-23 15:36:27','2022-01-11 08:09:01'),(37,2,'اهمیت تولید کفپوش  اپوکسی در صنایع دارویی','کاربرد رزین اپوکسی در صنایع دارویی ایران','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:22px\"><span style=\"color:#000080\">اهمیت تولید کفپوش اپوکسی در صنایع دارویی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:22px\"><span style=\"color:#FF8C00\">تولید کفپوش اپوکسی در صنایع دارویی ایران</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تولید دارو و در واقع صنعت دارو از اهمیت بسزایی برخوردار است . و از شروع خرید مواد اولیه تا خط تولید و بسته بندی و نگهداری آن در انبار و عرضه آن به مشتریان باید کاملا نکات بهداشتی رعایت گردد و کوچک ترین بی توجهی به اپوکسی در صنایع دارویی آن مشکلات خطرناکی را برای بیماران ایجاد می نماید خوشبختانه مسئولین بهداشت و صنایع در این مورد بر اهمیت جایگزینی کفپوش اپوکسی و کفپوش پلی یورتان تذکر داده حتی بخش نامه ای صادر نموده اند که در صورت عدم اجرای آن مراکز مربوطه با مشکلات قانونی رو به رو خواهند گردید و متأسفانه در خطوط تولید دارو تاکید بر کف سالن ها شده در صورتی که عوامل میکروبی ، باکتری ، قارچی و &hellip; در و دیوار سالن ها و سقف آن ها نیز وجود دارد در صورت یکپارچه کردن است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">نکات مهم انتخاب اپوکسی در صنایع دارویی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۱-تمامی فضای سالن ها با کفپوش اپوکسی و بیرون سالن ها.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۲-کفپوش پلی یورتان به صورت یکپارچه و بدون درز اکثر مشکلات بهداشتی را حل نمود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۳-همین قدر که حداقل به بخشی از سالن ها که در واقع کف سالن های خط تولید دارو تذکر داده شده است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۴-در صورت اجرایی شدن کفپوش اپوکسی در سالن ورزشی در خط تولید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۵-انبار ها و اپوکسی در صنایع دارویی در فضای بیرون تولید دارو.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۶-کمک شایانی را جهت بهداشتی محصول نهایی تولید خواهد نمود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۷-طی بررسی و کارشناسی دست اندرکاران تولید اپوکسی و پلی یورتان در صنعت.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۸-بازار بسیار وسیعی وجود دارد که تولیدکنندگان و مجریان می توانند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۹-خدمات شایانی را به تولید کنندگان دارو و یا لوازم پزشکی اولیه بیمارستانی می نماید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">۱۰-مصرف کنندگان با اطمینان بیشتری از این محصولات استفاده نمایند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اپوکسی در صنایع دارویی و استفاده در بتن</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در این&nbsp; نوع از محصول بتن سبک وزن با شکوه ، بهترین انتخاب و هم چنین نیاز به باز سازی ، ترمیم و یا تعمیر کردن کمی نسبت به دیگر انواع دارد&nbsp; ولی لازم به ذکر است که استفاده از این نوع اپوکسی متفاوت بوده و پیشنهاد میشود اپوکسی در صنایع دارویی در شرایط خاص استفاده شود که در برابر ساییدگی و نور بیش از اندازه حساس است .&nbsp; کف اندکی از خانه ها را به اینگونه می بینیم&nbsp; که حتما خانه هایی هستند که از نور طبیعی در دسترس استفاده می کنند، بیشتر این نوع&nbsp; اپوکسی ها را در زمستان های طولانی در کانادا استفاده می کنند.</span></span></p>','/app/articles/1545567797787.jpg','/app/articles/1545567798771.jpg','اپوکسی,دارویی,کفپوش,قیمت,مواد شیمیایی,epoxy,فروش مواد شیمیایی,اپوکسی چوب','اهمیت-تولید-کفپوش-اپوکسی-در-صنایع-دارویی',786,3,1,'2018-12-23 15:53:18','2022-01-11 21:48:56'),(38,3,'رنگدانه‌ها یا پیگمنت ها','مواد جامد تزئینی هستند که در شکل و اندازه‌های مختلف در حلالهای مربوط به حالت معلق تهیه و بکار می‌روند و مشتمل بر مواد سیاه – سفید و رنگی است','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><iframe frameborder=\"0\" height=\"400\" scrolling=\"no\" src=\"https://www.aparat.com/video/video/embed/videohash/QS1FO/vt/frame\" width=\"80%\"></iframe></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:22px\">در این ویدئو نحوه ترکیب <strong><a href=\"https://www.amazontele.com/search_box?q=%DA%AF%D9%84%DB%8C%D8%AA%D8%B1&amp;status=1\"><span style=\"color:#2980b9\">گلیتر </span></a></strong>ها با <strong><a href=\"https://www.amazontele.com/product/%D9%87%D8%A7%D8%B1%D8%AF%D9%86%D8%B1-%D8%A7%D9%BE%D9%88%DA%A9%D8%B3%DB%8C-50-%D8%B3%DB%8C%DA%A9%D9%84%D9%88-%D8%A2%D9%84%D9%81%D8%A7%D8%AA%DB%8C%DA%A9-%D9%BE%D9%84%DB%8C-%D8%A2%D9%85%DB%8C%D9%86-%D8%A7%DB%8C%D8%AA%D8%A7%D9%84%DB%8C%D8%A7-%D8%A8%D8%B3%DB%8C%D8%A7%D8%B1-%D8%B4%D9%81%D8%A7%D9%81\"><span style=\"color:#2980b9\">رزین اپوکسی</span></a></strong> به نمایش در آمده است</span></span></p>\r\n\r\n<div style=\"page-break-after: always\"><span style=\"display:none\">&nbsp;</span></div>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:24px\"><strong><a href=\"https://www.amazontele.com/search?category[0]=3&amp;status=1\"><img alt=\"\" src=\"https://www.amazontele.com/laravel-filemanager/photos/shares/28753574_349818352189381_846117714182275072_n.jpg\" style=\"height:400px; width:400px\" /></a>&nbsp;</strong></span></span></p>\r\n\r\n<p style=\"text-align:center\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:24px\"><strong>جهت خرید پیگمنت (<a href=\"https://www.amazontele.com/search?category[0]=3&amp;status=1\"><span style=\"color:#2980b9\">اینجا</span></a>) کلیک کنید&nbsp;</strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">رنگدانه یا پیگمنت چیست؟</span></span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مواد جامد تزئینی هستند که در شکل و اندازه&zwnj;های مختلف در حلالهای مربوط به حالت معلق تهیه و بکار می&zwnj;روند و مشتمل بر مواد سیاه &ndash; سفید و رنگی بوده ، موارد استفاده زیادی در رویه زدن ، رنگرزی انبوه و دیسپرسیون در هوا دارند پیگمنت در صنعت رنگسازی نقش مهمی از قبیل ایجاد رنگ پوشش براقیت سختی مقاومت حفاظت افزایش چسبندگی و غیره را ایفا می کند موارد استعمال عمده پیگمانها در لاکها ، رنگهای روغنی ، ورنی&zwnj;ها ، رنگهای سلولزی ، رنگهای پلاستیکی ، مرکبهای چاپ و رنگرزی کاغذ و تاسیسات آهنی می&zwnj;باشد. صنایع پوششی عمده&zwnj;ترین موارد استعمال پیگمنت ها می&zwnj;باشد. امروزه پوشش سطح وسایل فلزی و چوبی بناها ، وسایل نقلیه و &hellip; اهمیت فراوانی دارد زیرا این وسایل توسط رنگ از عوامل مختلف مثل هوا ،رطوبت و ترکیبات شیمیایی محافظت می&zwnj;شوند. وهمچنین در رنگ زدن اشیا به زیباتر شدن آنها کمک می&zwnj;کند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">پیگمنتها به دو صورت</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><strong><span dir=\"LTR\">1- </span>معدنی</strong></span></span><span dir=\"LTR\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><strong> </strong></span></span><span style=\"color:black\">:</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp; <span style=\"color:black\">رنگدانه&zwnj;های معدنی طبیعی از پوسته زمین استخراج می&zwnj;شوند، خرد شده ، شسته شده ، از لحاظ اندازه درجه&zwnj;بندی می&zwnj;شوند. غالباً برای این رنگدانه&zwnj;های طبیعی ، معادل مصنوعی هم وجود دارد، یعنی رنگدانه از اجزاء دیگری در اثر یک فرایند شیمیایی ساخته می&zwnj;شود. ظاهراً از نظر شیمیایی با نمونه طبیعی یکسان است، ولی اغلب خواص متفاوتی دارد و معمولاً به خاطر شکل بلوری مطلوبتر ، خلوص بیشتر و دانه&zwnj;بندی مطلوبتر ، مرغوبتر از نوع طبیعی می باشد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span dir=\"LTR\">2- </span>آلی</span></span></strong><span dir=\"LTR\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"> :</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">امروزه رنگدانه&zwnj;های آلی به مراتب بیشتر از رنگدانه&zwnj;های معدنی می&zwnj;باشند. بعضی از جدیدترین رنگدانه&zwnj;ها ساختمان آلی فلزی دارند. بیشتر رنگدانه&zwnj;های آلی ،مواد شیمیایی آلی هستند که روی یک هسته معدنی هیدروکسید آلومینیوم رسوب داده شده&zwnj;اند. از مهمترین رنگدانه&zwnj;های آلی می&zwnj;توان به گروه فتالوسیانین&zwnj;ها اشاره کرد که طیف رنگهای آبی و سبز را در بر می&zwnj;گیرند و فتالوسیانین مس ، رنگدانه آبی می&zwnj;باشد که به علت خواص مقاومتی خوب در برابر عوامل مختلف ، یک رنگدانه با ارزش به شمار می&zwnj;رود . فتالوسیانین&zwnj;ها را از فتالیک و اوره سنتز می&zwnj;کنند. رنگدانه&zwnj;های آلی ، به صورتی که امروزه در صنعت استفاده می&zwnj;شوند، در طبیعت یافت نمی&zwnj;شوند و تقریباً همه آنها سنتزی می&zwnj;باشند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;<span style=\"color:black\">و نیز پیگمنتهای غیر پوششی یا اکستندر مثل کربنات کلسیم و باریت و تالک و ... هم وجود دارد. پیگمنت سفید پیگمنت معدنی طبیعی است. پیگمنت رنگی معدنی مثل اکسید زرد آهن اکسید قرمز آهن اکسید سیاه آهن پیگمنت رنگی معدنی مصنوعی مثل کرم سبز و سرب قرمز اکسید مس پیگمنت های فلزی معدنی مصنوعی مثل پودر آلومینوم برنز و روی</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">تفاوت پیگمنت آلی و معدنی در خواص زیر است</span><span dir=\"LTR\"><span style=\"color:black\"> :</span></span><br />\r\n<span style=\"color:black\">یک فیلم براق و جذاب در فام های گوناگون با پیگمنت آلی بدست می آید تا با معدنی خالص ترین پیگمنت سفید دی اکسید تیتانیم و سیاه ترین پیگمنت سیاه کربن بلک است که هر دو جزء پیگمنت معدنی است و بدین ترتیب پیگمنت آلی به صورت سیاه و سفید موجود نمی باشد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span><br />\r\n<span style=\"color:black\">تعداد بسیار کمی از پیگمنت های آلی در بالاتر از 300 درجه سانتیگراد پایدار می باشندکه ممکن است متلاشی یا ذوب گردند در حالیکه پیگمنت معدنی بالعکس</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">مهمترین ویژگی هایی که در انتخاب یک پیگمنت مورد توجه قرار میگیرند، عبارتند از</span><span dir=\"LTR\"><span style=\"color:black\"> :<br />\r\n&nbsp;<br />\r\n&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">طبیعت شیمیایی</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">ساختار کریستالی</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">شکل ذرات</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">ابعاد ذرات و توزیع آن</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">ضریب شکست</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">مشخصات پخش شدگی</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">رنگ بندی و سایر مشخصات فیلم رنگ</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">مقاومت دربرابر شرایط مختلف جوی و نوری</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">مقاومت در برابر اسیدها و بازها</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">مقاومت در برابر حرارت</span><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">و سایر فاکتورهای مهمی که در بخش ماندگاری و مقاومتی مد نظر هستند</span><span dir=\"LTR\"><span style=\"color:black\"> .</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">پیگمنت سفید<span dir=\"LTR\">:</span></span></span></strong><br />\r\n<span style=\"color:black\">مواد معدنی فلزات سرب روی تیتانیوم می باشند. و وقتی کاملا سفید به نظر خواهند رسید که تمامی طول موجهای قابل دید تابش بر خود را منعکس نمایند. از میان پیگمنت های سفید فقط کربنات بازی سرب و اکسید روی هستند که خصلت واکنش پذیری با اسید های موجود در بعضی از رزینها را دارندو بقیه رنگدانه های سفید بی اثرند</span><br />\r\n<span style=\"color:black\">فیلم حاصل از پیگمنت سفید به غیر از اکسید روی مصرفی بر سطوح بیرونی در دراز مدت حالت زردی یا یلوئینگ به خود میگیرند.بنابراین استفاده از حدود 10 درصد اکسید روی همراه دیگر پیگمنتهای سفید به علت جذب اشعه نور خورشید نه تنها زرد گرایی فیلم را به کلی از بین خواهد برد بلکه از فاسد شدن فیلم نیز جلوگیری میکند.از کربنات بازی سرب بعنوان استابلایزر استفاده می گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">اکسید روی</span></span></strong><span dir=\"LTR\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">:</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">از اکسید روی جهت جهت کنترل کپک زدگی یلویینگ ساییدگی گچ و خاک شوندگی فیلم استفاده می نمایند. از عیوب آن مصرف بیش از حد آن در ساخت یک رنگ مقاومت فیلم حاصل را در برابر آب کاهش می دهد و ثانیا در هوای در هوای رطوبتی وآغشته به</span><span dir=\"LTR\"><span style=\"color:black\">SO2 </span></span><span style=\"color:black\">به سولفات روی تبدیل که این امر نه تنها باعث جوش زدگی فیلم بلکه رنگ رویه بعدی را بصورت لایه ای از خود جدا خواهد کرد.اکسید روی بر اثر گرما به رنگ زرد در می آید و سرد بلعکس</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">لیتوپن</span></span></strong><span dir=\"LTR\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">:</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">مخلوط 29% سولفید روی و 71%سولفات باریم می باشد.در مقابل نور خورشید حساسیت دارد و به رنگ سیاه تبدیل میشود.این مشکل را می توان با افزایش حدود 15% نمک کبالت برطرف نمود. لیتوپن به همراه</span><span dir=\"LTR\"><span style=\"color:black\"> TiO2 </span></span><span style=\"color:black\">علاوه بر ارزانی اثرات جانبی مفید دیگری از قبیل برس خوری بهتر،یکنواختی بهتر و براقیت عالی بر جای میگذارد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">اکسید آنتی موان</span></span></strong><span dir=\"LTR\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">:</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">امروزه ازآن بیشتر در ساخت رنگهای نسوز و یا تاخیر انداز حرارت استفاده می کنند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><a href=\"https://www.amazontele.com/product/%D9%BE%DB%8C%DA%AF%D9%85%D9%86%D8%AA-%D8%B3%D9%81%DB%8C%D8%AF-%D8%AA%DB%8C%D8%AA%D8%A7%D9%86-Pigment-White-7\">دی اکسید تیتانیم&nbsp;<span dir=\"LTR\">:</span></a></span></strong><br />\r\n<span dir=\"LTR\"><span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">در دو نوع روتایل و آناتاز موجود است. نوع روتایل 20 الی 30 درصد قدرت پوشش بیشتری از نوع آناتاز دارد نوع آناتاز با اینکه سفید تر است اما جهت ساخت مصارف بیرونی بعلت میل به گچی شدن توصیه نمی شود برای شناسایی مقداری از آن را با اسید سولفوریک مرطوب نموده سپس چند قطره پراکسید ئیروژن اضافه کرده ایجاد رنگ نارنجی یا زرد مایل به نارنجی می کند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"font-size:20px\"><strong><span style=\"color:#008000\">اکستندرها</span></strong></span><span dir=\"LTR\"><span style=\"font-size:20px\"><strong><span style=\"color:#008000\">:</span></strong></span><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">پیگمنتهای سفید معدنی هستند که بعلت داشتن ضریب شکست بسیار پایین فاقد هرگونه پوششی بوده و بعلت پایین آوردن قیمت حفظ ماتی و جلوگیری از ته نشینی و تنظیم ویسکوزیته مصرف میشوند.اکستندرها (فیلر) هایی که قدرت جذب روغن بیشتری دارند ممکن است به جهت افزایش ویسکوزیته در رنگ مورد استفاده قرار گیرند مثل کربناتها و سیلیکات ها و سولفات ها</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">کربنات کلسیم(گچ سفید</span></span></strong><span dir=\"LTR\"><strong><span style=\"color:#008000\"><span style=\"font-size:20px\">:(</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">این فیلر از آنجاییکه اندکی بازی است، میبایستی با رزینهای اسیدی و با پیگمنتهای رنگی از قبیل کرم سبز و مولیبیدات نارنجی که با بازها حساسیت دارند بکار نرود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">سولفات باریم (باریت)(بلانک فیکس</span></span></strong><span dir=\"LTR\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">(</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">وزن ظاهری زیاد و دارای جذب روغن کم است و بنابراین در رنگ سریع تهنشین شده وجهت جلوگیری ازتهنشینی آن میبایستی از مواد ضد تهنشینی مثل استئارات آلومینیوم استفاده نمود.نوع طبیعی به باریت معروف است از آنجاییکه جذب روغن کمی دارد خاصیت پرکنندگی خوبی داشته جهت افزایش پیگمنت به بایندر در رنگهای مات و نیمه مات ترافیک استفاده میگردد .بدون اینکه باعث افزایش ویسکوزیته گردد.باریت حفظ براقیت سمباده خوری و استفاده در رنگ های مقاوم مواد شیمیایی است.نوع مصنوعی یا رسوبی آن به بلانک فیکس معروف است.یون باریم این فیلر در رزینهای وینیلی عمل تثبیت کنندگی را ایفا می کند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">تالک (سیلیکات منیزیم<span dir=\"LTR\">(</span></span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;<span style=\"color:black\">بیشتر در رنگهای رویه مصرف دارد و در مقابل اسید و باز خنثی است و در رزینها بسادگی خیس شده نیازی به آسیاب نمی باشد .از این فیلر بعنوان قابلیت سمباده خوری و همچنین یک عامل مات کننده بکار میرودذراتشان سوزنی شکل و به آسانی تهنشین میشوند و زود هم پخش می شوندسختی و چسبندگی خوبی به فیلم میدهند به همین دلیل در رنگهای ترافیک مصرف دارد.استفاده از آن در رنگهای سفید که باساچمه های استیلی پرمیل می شوند مناسب نبوده زیرا بعلت مقاومت در برابر سایش باعث تیرگی رنگ سفید می شوند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">سیلیکات آلومینوم(کائولین یا خاک چینی</span></span></strong><span dir=\"LTR\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">(</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">به علت خصلت میل مرطوب پذیری با آب در ساخت رنگهای امولسیونی و پلاستیک جهت ایجاد برس خوری و یکنواختی و افزایش مقاومت در مقابل آب و از لحاظ شیمیایی نیز خنثی هستند.در رنگ پلاستیک کائولین قابلیت پخشی در مدت انبار بودنو کنترل خوردگی قوطی و مقداری خاصیت پوششی دارد.که میتوان 10 الی 20 از حجم پیگمنت سفید رنگهای پلاستیک و اکرلیک و یا حتی آلکید رابا سیلیکات جایگزین کرد و جهت جلوگیری از حالت جدایی رزین پلی وینیل استات و پیگمنت ها در دراز مدت در رنگهای پلاستیک بکار میرود و گاهی از آن بعنوان ماده ضد سایش استفاده میکنند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">سیلیکات مضاعف آلومینوم و پتاسیم(میکا</span></span></strong><span dir=\"LTR\"><strong><span style=\"font-size:20px\"><span style=\"color:#008000\">(</span></span></strong><br />\r\n<span style=\"color:black\">&nbsp;</span></span><span style=\"color:black\">به رنگ طوسی و مغز پسته ای بوده در رنگهای پلاستیک باعث چسبندگی و برس خوری بهتر و در رنگهای روغنی باعث کنترل گچ و خاک شوندگی میشود. رل اصلی میکا در اصل بر اثر میکس باعث سهولت پخش سریعتر پیگمنت تهنشین شده در هنگام مصرف میگردد همچنین از آن میتوان در صورت خراب نکردن حالت لیفینگ جهت کاهش قیمت رنگهای آلومینیومی نوع لیفینگ استفاده نمود. اما در مقابل رنگی که حرارت و آتش مد نظر باشدحضور میکا واقعا لازم و کارش بسیار مفید است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">سیلیس یا سیلیک</span><span dir=\"LTR\"><span style=\"color:black\">:<br />\r\n&nbsp;</span></span><span style=\"color:black\">در رنگهای ترافیک و اپوکسی کف و مقاوم در مقابل سایش مصرف میگرد</span><span dir=\"LTR\"><span style=\"color:black\">.<br />\r\n&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">سیلیس طبیعی</span><span dir=\"LTR\"><span style=\"color:black\"> :</span></span><br />\r\n<span style=\"color:black\">بعلت بد پخش شدن مصرف کم دارد و جذب روغن بسیار کم داردو در ساخت پولیشها ورنگهای مصرفی بر کف منازل و عرشه کشتیها (بعلت مقاومت سایشی استفاده میگردد</span><span dir=\"LTR\"><span style=\"color:black\">(</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">&bull;&nbsp;&nbsp; &nbsp;</span></span><span style=\"color:black\">نوع دیاتومه</span><span dir=\"LTR\"><span style=\"color:black\"> :</span></span><br />\r\n<span style=\"color:black\">قدرت جذب روغن زیاد بهمین خاطر در رنگهای مات و نیمه مات مصرف میگردد.در رنگهای پلاستیک و عایق حرارت نیز استفاده میگردد. بخاطر نوع شکل جهت مصرف در رنگهای مقاوم در مقابل آب و مواد شیمیایی مناسب نبوده و بعکس جهت ساخت رنگهای نفوذ پذیری و نشری مناسبند و از ایجاد کراکینگ در فیلم نیز جلوگیری بعمل می آورند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\">&nbsp; &nbsp;&nbsp;</span></span><span style=\"color:black\">سلیس طبیعی</span><span dir=\"LTR\"><span style=\"color:black\"> :</span></span><br />\r\n<span style=\"color:black\">غیر قابل حل درآب و مقاوم در مقابل بسیاری از مواد شیمیایی میباشد. قدرت مات کنندگی و قدرت جذب روغن بالایی دارد و در رنگهای پلی استر غیر اشباع مانع از شره شدن رنگ میگردد از این فیلر در لاک ها و وارنیش ها ی مات مخصوص چوب و ترکیبات پولیش کننده استفاده فراوان می گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">پنبه نسوز (آزبست</span><span dir=\"LTR\"><span style=\"color:black\">(<br />\r\n&nbsp;</span></span><span style=\"color:black\">این فیلر سیلیکات های معدنی هستندکه ترکیب آنان از سیلیکات های منیزیم ساده گرفته تا کمپلکسهای سیلیسی منیزیم و آهن و سدیم متغیر است .که بصورت الیافهای پشمی با قدرت جذب روغن بسیار زیاد بیشتر در رنگهای عایق حرارتی و رنگهای آسفالت پشت بام ها مصرف میگردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">استئارات آلومینوم</span><span dir=\"LTR\"><span style=\"color:black\">:<br />\r\n&nbsp;</span></span><span style=\"color:black\">بعنوان یک ماده روان سازنده و پخش کننده مصرف میگردد واز آنجاییکه تمایل زیادی به ژل کردن رزینها دارد و باید به مقدار کم مصرف شود. مقدار مصرفی آن حدود 25% کل وزن پیگمنت مصرفی نتایج رضایت مندی دارددر ساختمان بتونه ها از حالت بلیدینگ و جدا شدن رزین از پیگمنت جلوگیری بعمل می آورد. از دیگر خواص آن دفع آب و افزایش ویسکوزیته و ضد تهنشینی خصوصا در بتونه ها می باشد و از آن بعنوان ضد کف در حفاری چاه ها نفتی نیز استفاده می شود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><br />\r\n<span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">سیلیکات کلسیم</span><span dir=\"LTR\"><span style=\"color:black\">:</span></span><br />\r\n<span style=\"color:black\">قدرت جذب روغن متوسط از آن میتوان بعنوان بافر در ساخت رنگهای لاتکس استفاده نمود باعث افزایش پوشش در بیشتر رنگهای محلول در آب میگردد. از نوع مصنوعی ان می توان بعنوان یک ماده مات کننده نیز استفاده کرد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">اساس فیزیکی</span></span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">پیگمنت&zwnj;ها رنگی را ایجاد می&zwnj;کنند که خودشان نیز به همان رنگ هستند چرا که آنها بصورت انتخابی طول موجهای معینی از نور مرئی را جذب و منعکس می&zwnj;نمایند. ترکیب طیف کامل نور مرئی با طول موجی متغیر از ۳۷۵ یا ۴۰۰ نانومتر الی ۷۶۰ یا ۷۸۰ نانومتر، با نور سفید تقریباً برابری می&zwnj;کند. وقتی که این نور با یک پیگمنت برخورد می&zwnj;کند، قسمت&zwnj;هایی از طیف توسط پیوندهای شیمیایی سیستم&zwnj;های کونژوگه و دیگر اجزای پیگمنت جذب می&zwnj;شود. برخی دیگر از طول موج&zwnj;ها یا قسمتهایی از طیف، منعکس و یا پخش می&zwnj;شود. بیشتر پیگمنت&zwnj;ها، کمپلکس انتقال بار محسوب می&zwnj;شوند. مثل کامپاندهای فلز واسطه با باند جذب وسیعی که بیشتر رنگ&zwnj;های نور سفید تابشی را کسر می&zwnj;کنند. طیف جدید منعکس شده ظاهر یک رنگ را بوجود می&zwnj;آورد. پیگمنت&zwnj;ها بر خلاف مواد <a href=\"https://www.amazontele.com/search_box?q=%D9%81%D9%84%D9%88%D8%B1%D8%B3%D9%86%D8%AA&amp;status=1\">فلورسنت </a>یا فسفورسنت، می&zwnj;توانند فقط طول موجها را از نور منبع کسر نموده و هرگز مورد دیگری به آن اضافه نکنند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">ظاهر پیگمنت&zwnj;ها نزدیک به رنگ نور منبع می&zwnj;باشد. نور خورشید از دمای رنگ بالا و یک طیف نسبتاً یکدستی برخوردار بوده و معیار استانداردی برای نور سفید محسوب می&zwnj;شود. منابع نور مصنوعی تمایل زیادی برای دستیابی به پیک عالی در برخی قسمتهای طیف خود و همچنین شیاری عمیق دارند. با مشاهده این شرایط، پیگمنت&zwnj;ها در رنگ&zwnj;های متفاوتی ظاهر می&zwnj;گردند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">فضاهای رنگی که برای نمایش رنگها از حیث عدد مورد استفاده قرار می&zwnj;گیرد باید منبع نوری خود را تعیین نمایند. درسنجش مدل رنگ ال ای بی، فرض بر این است که اندازه&zwnj;گیری&zwnj;ها زیر منبع نوری</span><span dir=\"LTR\"><span style=\"color:black\">&nbsp;D65&nbsp;</span></span><span style=\"color:black\">یا &quot;روشنی روز &nbsp;۶۵۰۰ کلوین&nbsp;</span><span dir=\"LTR\"><span style=\"color:black\">&ldquo;</span></span><span style=\"color:black\">انجام شده است که تقریباً همان دمای رنگ نور خورشید می&zwnj;باشد، مگر آنکه خلاف آن قید شود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">دیگر ویژگی&zwnj;های یک رنگ همچون اشباع بودن یا سبکی آن، ممکن است توسط دیگر مواد همراه با پیگمنت، تخمین زده شود. رنگپایه و فیلرهایی که به مواد شیمیایی پیگمنت&zwnj;ها افزوده می&zwnj;شود نیز الگوهای بازتاب و جذب خاص خود را دارند که می&zwnj;توانند بر طیف نهایی تأثیر گذار باشند. به همین ترتیب، درمخلوطهای پیگمنت/رنگپایه، امکان برخورد مولکول&zwnj;های پیگمنت با اشعه&zwnj;های مجزای نوری وجود ندارد و ممکن است به همان صورت که وجود دارند، منعکس گردند. این اشعه&zwnj;های پراکنده نور منبع با یک رنگ کمتر اشباع شده، سهیم می&zwnj;شوند. پیگمنت خالص به نور سفید خیلی کوچک اجازه فرار را داده و بدین ترتیب یک رنگ بسیار اشباع شده تولید می&zwnj;کند. مقدار کمی از پیگمنت با مقدار زیادی از رنگپایه سفید مخلوط می&zwnj;شود، ولی به دلیل فرار مقدار زیادی نور سفید ،نتیجه حاصله، اشباع نشده و رنگ پریده می&zwnj;گردد</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\"><span style=\"color:black\"><img alt=\"http://ranginfo.com/uploaded_files/DCMS/wysiwyg/images/pigment1.jpg\" src=\"http://ranginfo.com/uploaded_files/DCMS/wysiwyg/images/pigment1.jpg\" style=\"height:193px; width:310px\" /></span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:black\">تعداد زیادی از طول موج&zwnj;ها (رنگها) با یک پیگمنت برخورد می&zwnj;کنند. این <a href=\"http://www.amazontele.com/search?category[0]=3&amp;status=1\">پیگمنت </a>نور <a href=\"https://www.amazontele.com/search_box?q=%D9%82%D8%B1%D9%85%D8%B2&amp;status=1\">قرمز </a>و <a href=\"https://www.amazontele.com/search_box?q=%D8%B3%D8%A8%D8%B2&amp;status=1\">سبز </a>را به خود جذب کرده ولی نور آبی را منعکس می&zwnj;کند و سبب ایجاد رنگ آبی می&zwnj;شود نور خورشید با <a href=\"https://www.amazontele.com/search?category[0]=3&amp;status=1\">پیگمنت</a> &rdquo; آبی بنیادی</span><span dir=\"LTR\"><span style=\"color:black\">&rdquo; Rosco R80&nbsp;</span></span><span style=\"color:black\">برخورد می&zwnj;کند. محصول طیف منبع و طیف بازتاب پیگمنت، نهایتاً به طیف نهایی و ظاهر آبی منجر می&zwnj;شود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;سایر مقالات مرتبط</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\"><a href=\"https://www.amazontele.com/article/%D8%B1%D9%86%DA%AF%D8%AF%D8%A7%D9%86%D9%87-%D9%87%D8%A7%DB%8C-%D9%85%D8%B9%D8%AF%D9%86%DB%8C-%D8%B2%D8%B1%D8%AF-%DA%A9%D8%B1%D9%85\"><span style=\"color:#008000\">مقاله ای جالب در خصوص پیگمنت زرد کروم</span></a></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><a href=\"https://www.amazontele.com/article/%D8%AA%D8%B9%D8%B1%DB%8C%D9%81-%D8%B1%D9%86%DA%AF%D8%AF%D8%A7%D9%86%D9%87-%D9%87%D8%A7%DB%8C-%D8%AC%D9%88%D9%87%D8%B1-%D8%AA%D9%88%D9%86%D8%B1-%D9%88-%D9%84%DB%8C%DA%A9-%D8%AF%D8%B1-%D9%85%D9%88%D8%A7%D8%AF-%D8%B1%D9%86%DA%AF%D8%B2%D8%A7\"><span style=\"color:#008000\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:20px\">تفاوت پیگمنت جوهر ، پیگمنت تونر و پیگمنت لیک</span></span></span></a></p>','/app/articles/1545568447438.jpg','/app/articles/1545568447225.jpg','پیگمنت,رنگدانه,رنگزا,لیست قیمت مواد شیمیایی,اتومبیلی,مقاوم به UV,خرید و فروش پیگمنت,پیگمنت های رنگی','رنگدانه-ها-یا-پیگمنت-ها',2068,2,1,'2018-12-23 16:04:07','2022-01-11 20:41:03'),(39,4,'8دلیل علاقه افراد به خرید از فروشگاه اینترنتی','چرا افراد به خرید از فروشگاه اینترنتی علاقه مند هستند؟','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">8دلیل علاقه افراد به خرید از فروشگاه اینترنتی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">چرا افراد به خرید از فروشگاه اینترنتی علاقه مند هستند؟</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:20px\"><span style=\"color:#800080\"><span style=\"font-family:comic sans ms,cursive\">دلایل علاقه کاربران به خرید اینترنتی</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">سهولت</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;با خرید از فروشگاه اینترنتی، افراد به راحتی و حتی بدون نیاز به تعویض لباس خود می توانند خرید کنند. با خرید از فروشگاه اینترنتی دیگر نیازی به منتظر ماندن در صف برای پرداخت پول و تکمیل فرآیند خرید توسط فروشنده نیست شما می توانید در مدت زمان بسیار کوتاهی خرید خود را تنها با چند کلیک تکمیل کنید. این امر موجب صرفه جویی در زمان و هزینه ها می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">قیمت های بهتر</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;شما می توانید محصولات را با قیمت بهتر و ارزان تری از فروشگاه انترنتی تهیه کنید زیرا در این حالت محصولات بدون واسطه و به طور مستقیم از تولید کننده به دست مشتری می رسد. علاوه بر این بسیاری از فروشگاه های اینترنتی بن های تخفیف و حراج ارائه می کنند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تنوع</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;در فروشگاه اینترنتی شما قادر خواهید بود چندین برند و محصول را در یک محل دریافت کنید. در واقع شما در فروشگاه اینترنتی قادر خواهید بود از فروشندگان سراسر جهان بدون محدودیت در منطقه جغرافیایی خرید کنید. در فروشگاه اینترنتی ، امکان انتخاب محصولات در رنگ ها، طرح ها و اندازه های مختلف وجود دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">هزینه کمتر</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;در خرید معمولی نیاز به صرف هزینه بیشتری علاوه بر خرید محصول مورد نظر است. این هزینه شامل هینه رفت و آمد، غذا و غیره خواهد بود. اما در خرید اینترنتی شما بدون این هزینه ها تنها قیمت محصول را پرداخت می کنید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">امکان مقایسه قیمت ها</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;در طراحی فروشگاه اینترنتی ، قابلیت بررسی و مقایسه قیمت ها و محصولات با یکدیگر ارائه شده است. همچنین شما در فروشگاه اینترنتی قادر به اشتراک گذاری اطلاعات خود با سایر خریداران خواهید بود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><strong><span style=\"font-family:comic sans ms,cursive\">عدم وجود شلوغی و ازدحام</span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;خرید معمولی اکثر مواقع به دلیل وجود خسته کننده است و وجود ازدحام موجب می شود خرید را با عجله به پایان برسانیم. علاوه بر این زیادی جمعیت مشکل کمبود محل پارک را نیز ایجاد می کند. اما در خرید از فروشگاه اینترنتی این مشکل نیز به وجود نمی آید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">عدم خرید اجباری</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;در خرید معمولی گاها به دلیل مهارت سخنوری فروشنده و مغازه داران شما مجبور به خرید محصولی می شوید که به آن علاقه و یا نیازی ندارید. اما در خرید اینترنتی شما آزادهنه و بدون دخالت شخص فروشنده به راحتی محصول مورد نظر خود را خریداری می کنید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">خرید بدون شرمندگی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;خرید برخی از محصولات از فروشگاه های فیزیکی ممکن موجب خجالت در فرد شود. در فروشگاه اینترنتی شما قادر خواهید بود به صورت خصوصی و بدون شرمندگی خرید خود را انجام دهید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#e74c3c\"><span style=\"font-size:22px\">فروشگاه اینترنتی آمازون تله اولین فروشگاه آنلاین در خصوص فروش مواد شیمیایی می باشد شما می توانید با جستجوی کالای مورد نظر خود در نوار جستجوی سایت ،از قیمت مواد شیمیایی آگاه شده و</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#e74c3c\"><span style=\"font-size:22px\">به صورت آنلاین سفارش دهید.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:right\">&nbsp;</p>','/app/articles/1545647860898.png','/app/articles/1545647862694.png','فروشگاه اینترنتی ,فروشگاه آنلاین,Amazon MAG,فروش اینترنتی مواد شیمیایی','8دلیل-علاقه-افراد-به-خرید-از-فروشگاه-اینترنتی',570,3,1,'2018-12-24 14:07:42','2022-01-09 09:18:31'),(40,4,'هفت قانون فروش موفق','فروش حرفه‌ای مانند آشپزی ترکیبی از علم و هنر است. هرگز بدون این هفت ماده اولیه ارزشمند، قدم به آشپزخانه نگذارید.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:22px\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#0000FF\">هفت قانون فروش موفق</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">فروش حرفه&zwnj;ای مانند آشپزی ترکیبی از علم و هنر است. هرگز بدون این هفت ماده اولیه ارزشمند، قدم به آشپزخانه نگذارید. اگر برای طبخ غذای خود، هر یک از آن&zwnj;ها را در اختیار ندارید و یا آن&zwnj;ها را با نسبت یا ترتیب اشتباه با&zwnj;هم ترکیب کنید، هیچ فروشی انجام نمی&zwnj;شود<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">بیایید از تشبیه دیگری استفاده کنیم. فروش مانند شماره&zwnj;گیری یک شماره تلفن هفت&zwnj;رقمی است. اگر می&zwnj;خواهید با فرد آن&zwnj;طرف خط ارتباط برقرار کنید، باید این اعداد را با ترتیب صحیح وارد کنید. در فروش نیز باید از این فرایند مشخص هفت&zwnj;مرحله&zwnj;ای پیروی کنید تا بیشترین مقدار فروش، فروش مجدد و مشتریان معرفی&zwnj;شده را برای خود تضمین کنید<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#009311\">قانون ۱: تشخیص مشتریان واقعی</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">اولین قانون موفقیت در فروش &laquo;تخصیص زمان بیشتر به مشتریان احتمالی بهتر&raquo; است. ممکن است مشتریان احتمالی زیادی برای محصولات و خدمات شما وجود داشته باشند، اما همه آن&zwnj;ها مشتریان احتمالی مناسب شما نیستند. همان&zwnj;طور که در فصل ۵ درباره استراتژی بازاریابی هشدار دادیم، در این بخش نیز درباره فرایند فروش هشدار می&zwnj;دهیم. اغلب مشتریان احتمالی برای شرکت شما و محصولات و خدمات شما مناسب نیستند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">خریداران اصلی محصولات و خدمات شما چه کسانی هستند؟ در بسیاری از کسب&zwnj;و&zwnj;کارها، ۲۰ درصد مشتریان، ۸۰ درصد محصولات و خدمات را می&zwnj;خرند. کار مهم شما پیدا کردن آن ۲۰ درصد از مشتریان است. اگر در کار معامله سهام هستید، باید مشتریانی پیدا کنید که بیش از همه معامله می&zwnj;کنند. اگر تبلیغات می&zwnj;فروشید، باید مشتریانی پیدا کنید که بیشترین تبلیغات را می&zwnj;خرند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">این موضوع کاملا واضح است، اما بسیاری از صاحبان کسب&zwnj;و&zwnj;کارها هیچ شناختی از بهترین مشتریان خود ندارند. وقتی از شرکت&zwnj;های مختلفی بازدید می&zwnj;کنیم که تحقیقات گسترده&zwnj;ای در بخش بازاریابی انجام می&zwnj;دهند، با این وجود تیم فروش آن&zwnj;ها هدر دادن همه&zwnj;جانبه زمان و پول را متوقف نمی&zwnj;کند، به&zwnj;شدت متعجب می&zwnj;شویم. افراد بخش خدمات مشتری، تیم بازاریابی و نیروی فروش خود را گرد&zwnj;هم آورید تا درباره بهترین خریداران بازار صحبت کنند<span dir=\"LTR\">.</span><br />\r\nاولین کار شما تشخیص مشتریان واقعی از افراد مردد است. وقت کافی اختصاص داده و سوالاتی بپرسید. انرژی و منابع فروش شما محدود هستند. نمی&zwnj;توانید آن&zwnj;ها را برای افرادی هدر دهید که نمی&zwnj;توانند یا نمی&zwnj;خواهند از شما خرید کنند<span dir=\"LTR\">.</span><br />\r\nمشتری احتمالی مناسب ویژگی&zwnj;هایی دارد که می&zwnj;توان آن&zwnj;ها را اینگونه طبقه&zwnj;بندی کرد<span dir=\"LTR\">:</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\">&bull; </span>زمان&zwnj;بندی: مشتری احتمالی نیازی واقعی دارد که توسط محصولات و خدمات شما برآورده می&zwnj;شود و هم&zwnj;اکنون این نیاز وجود دارد<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\">&bull; </span>مشکل: مشتری احتمالی مشکلی شفاف و مشخص دارد که محصول و خدمت شما آن&zwnj;را حل می&zwnj;کند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\">&bull; </span>ارزش: مشتری احتمالی هدف مشخصی دارد که با کمک محصولات و خدمات شما با هزینه&zwnj;ای بسیار کمتر از ارزش خود هدف، می&zwnj;تواند به آن دست یابد<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\">&bull; </span>درد: مشتری ناراضی است و یا ناخرسندی&zwnj;هایی&zwnj; دارد که برطرف کردن آن&zwnj;ها از عهده محصولات و خدمات شما ساخته است<span dir=\"LTR\">.<br />\r\n&bull; </span>نتیجه: مشتری احتمالی نیازی دارد و یا می&zwnj;خواهد به نتایج مشخصی دست یابد و محصولات و خدمات شما باعث می&zwnj;شود که سریع&zwnj;تر، بهتر و ارزان&zwnj;تر به آن نتیجه دست یابد و بدون استفاده از این محصولات و خدمات چنین امکانی برایش میسر نمی&zwnj;شد<span dir=\"LTR\">.</span><br />\r\nشفافیت مهم&zwnj;ترین عامل در هر شرایطی است. هم شما و هم مشتری احتمالی باید به&zwnj;وضوح بدانید که چه نیاز، مشکل، هدف، نتیجه یا دردی وجود دارد و چرا محصول یا خدمت شما روشی مقرون&zwnj;به&zwnj;صرفه برای مواجهه با آن&zwnj;هاست<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#009311\">قانون ۲: ایجاد صمیمیت و اعتماد</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">با&zwnj;وجود همه داده&zwnj;ها و تخصص&zwnj;هایی که در فرایند فروش مورد استفاده قرار می&zwnj;گیرد، اکثریت قریب&zwnj;به&zwnj;اتفاق تصمیمات خرید بر پایه احساسات، مخصوصا احساس خریداران (یا اطرافیان آن&zwnj;ها) نسبت به محصول و فروشنده اتخاذ می&zwnj;شود. نوع احساس خریدار به فروشنده، نوع احساس او نسبت به کل شرکت را شکل می&zwnj;دهد<span dir=\"LTR\">.</span><br />\r\nبهترین فرایند فروش فرایندی است که طی آن، مشکلات مصرف&zwnj;کننده را &ndash; با جزئیات واقعی &ndash; به او گوشزد کرده و سپس مزایای حاصل از راه&zwnj;حل&zwnj;های خود را به او نشان می&zwnj;دهید. البته، بزرگ&zwnj;ترین بخش فروش تا بعد از فروش ادامه پیدا می&zwnj;کند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">وقتی فروشی انجام می&zwnj;دهید، باید خدمت یا محصول را تحویل دهید و مطمئن شوید که به&zwnj;طور رضایت&zwnj;بخشی نصب شده و مورد استفاده قرار می&zwnj;گیرد و تا زمان مشخصی بعد از فروش، پاسخگوی شکایات و نگرانی&zwnj;های مشتریان باشید. به همین دلیل، مشتری در ابتدا به&zwnj;دنبال ارتباط است. تا زمانی که مشتری نگران است، ارتباط با فروشنده بسیار مهم&zwnj;تر از خود محصول یا خدمت است<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">قانونی با عنوان &laquo;قانون تلاش غیر&zwnj;مستقیم&raquo; در فروش وجود دارد. بر اساس این قانون هرچه بر ارتباطات (رویکرد غیرمستقیم) تمرکز کنید، فروش بهتری خواهید داشت. اما هرچه بیشتر بر فروش تمرکز کنید و ارتباطات را نادیده بگیرید، احتمال فروش یا برقراری ارتباط خوب با مشتری ضعیف&zwnj;تر خواهد شد<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">اعتماد و اعتبار مهم&zwnj;ترین عوامل در ارتباطات فروش هستند. مشتری باید کاملا به شما (فروشنده) اعتماد کند و اطمینان قطعی داشته باشد که به تعهدات خود عمل خواهید کرد. مشتری باید معتقد باشد که کارایی محصول و خدمت شما همان است که در ابتدا گفته&zwnj;&zwnj;اید و به همان ترتیب هم باقی خواهد ماند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">صحبت به فروش منجر نمی&zwnj;شود. بین تعداد سوالاتی که درباره نیازها و خواسته&zwnj;های مشتری می&zwnj;پرسید و قدرت ارتباطی که شکل می&zwnj;دهید، رابطه&zwnj;ای مستقیم وجود دارد. صحبت به فروش منجر نمی&zwnj;شود، پرسیدن به فروش منجر می&zwnj;شود<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">به علاوه، بین گوش&zwnj;دادن دقیق به پاسخ&zwnj;های مشتریان و میزان علاقه و اعتماد مشتری به شما رابطه مستقیمی وجود دارد. واقعیت این است که گوش دادن اعتماد به&zwnj;وجود می&zwnj;آورد. برای ایجاد ارتباطی قابل&zwnj;اعتماد بین فروشنده و مشتری، هیچ راهی سریع&zwnj;تر و موثرتر از پرسیدن سوالات بسیار از مشتری و گوش سپردن دقیق به پاسخ&zwnj;ها نیست<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">هر&zwnj;چه دقیق&zwnj;تر به سخنان مشتری گوش بسپارید، علاقه و اعتماد او به شما افزون&zwnj;تر شده و پذیرای محصولات و خدمات شما خواهد بود. سوالات، کلید کار و اعتماد، عامل حیاتی در این فرایند هستند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#009311\">قانون ۳: تشخیص دقیق نیازها</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">بسیاری از مشتریان وقتی با شما صحبت می&zwnj;کنند نمی&zwnj;دانند نیازی دارند که برآوردن آن از عهده محصول یا خدمت شما ساخته است. آن&zwnj;ها افرادی مردد هستند و صرفا به جمع&zwnj;آوری اطلاعات می&zwnj;پردازند<span dir=\"LTR\">.</span><br />\r\nوقتی با مشتری صحبت می&zwnj;کنید، ممکن است نیازی داشته باشد که مشخص، نا&zwnj;مشخص یا غیرواقعی باشد. اگر نیاز مشخص باشد، ممکن است</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">مشتری روش دقیق برآورده کردن آن&zwnj;را بداند و یا نداند. ممکن است نیاز واقعی او با آنچه فکر می&zwnj;کند نیاز دارد، بسیار متفاوت باشد<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">اگر نیاز نامشخص و مبهم باشد، شما و مشتری تنها از طریق معاینه و تشخیص می&zwnj;توانید نیازهای موجود را به&zwnj;دقت بشناسید و روش برآورده کردن آن&zwnj;ها به&zwnj;وسیله محصولات و خدمات خود را مشخص کنید<span dir=\"LTR\">.</span><br />\r\nدر بسیاری از موارد، مشتری ممکن است فکر کند نیازی دارد، در&zwnj;حالی&zwnj;که شرایط او واقعا رضایت&zwnj;بخش است. او به محصول یا خدمت شما احتیاجی ندارد و کار شما به&zwnj;عنوان فروشنده حرفه&zwnj;ای آن است که این موضوع را به او گوشزد کنید<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">پرسیدن سوالات مختلف کلی و جزئی و گوش&zwnj;سپردن به پاسخ آن&zwnj;ها، روش دقیق تعیین نیازها است. پردرآمدترین فروشنده&zwnj;ها، سوالات خود را از قبل به&zwnj;دقت آماده می&zwnj;کنند، آن&zwnj;ها را یاداشت کرده و به&zwnj;ترتیب می&zwnj;پرسند<span dir=\"LTR\">.</span><br />\r\nبدترین فروشنده کسی است که هرچه به ذهنش می&zwnj;رسد را بیان کند ودر حین مکالمه فروش، از یک مطلب به مطلب دیگر بپرد. پرسیدن سوالات نامرتبط بدون شک از اعتبار شما می&zwnj;کاهد و دستیابی به فروش را بسیار دشوار می&zwnj;کند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#009311\">قانون ۴: ارائه متقاعد&zwnj;کننده</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">ارائه همان چیزی است که منجر به فروش واقعی می&zwnj;شود. در فرایند فروش می&zwnj;توانید اشتباهات زیادی مرتکب شوید، اما کیفیت ارائه، تعیین&zwnj;کننده خرید یا عدم خرید مشتری است<span dir=\"LTR\">.</span><br />\r\nبهترین روش فروش، نشان دادن، توضیح دادن و پرسیدن یک سوال است. برای مثال می&zwnj;گویید: &laquo;این یک نرم&zwnj;افزار حسابداری برای مشاغل کوچک است که با آن می&zwnj;توانید همه اعداد کسب&zwnj;و&zwnj;کار خود را مدیریت کنید. آیا به این موضوع علاقه دارید؟<span dir=\"LTR\">&raquo;</span><br />\r\nدر ارائه فروش از &laquo;فروش آزمایشی&raquo; استفاده کنید. این سوالی است که می&zwnj;تواند بدون متوقف&zwnj;کردن فرایند فروش، جوابی &laquo;منفی&raquo; داشته باشد، زیرا فرصت دیگری برای ارائه پاسخ در اختیار فروشنده قرار می&zwnj;دهد. برای مثال<span dir=\"LTR\">:</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">فروشنده: آیا مایلید این نرم&zwnj;افزار را روی کامپیوتر منزل خود نصب کنید؟<br />\r\nمشتری: نه ترجیح می&zwnj;دهم در دفتر خود از آن استفاده کنم<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">فروشنده: مشکلی نیست. این نرم&zwnj;افزار هم روی کامپیوترهای خانگی کار می&zwnj;کند و هم روی سیستم&zwnj;های سرور<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">به&zwnj;علاوه، در ارائه فروش قوی و حرفه&zwnj;ای، مرتبا به تجارب مشتریانی که با موفقیت از این محصول یا خدمت استفاده کرده&zwnj;اند اشاره می&zwnj;شود. داستانمشتریانی را تعریف کنید که شرایطی نزدیک یا مشابه با مشتریان احتمالی داشته&zwnj;، محصول یا خدمت شما را خریده&zwnj;اند و از نتایج آن راضی هستند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#009311\">قانون ۵: پاسخ&zwnj;گویی مؤثر&nbsp;به اعتراضات</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">هیچ فروشی بدون اعتراض انجام نمی&zwnj;شود. اعتراض&zwnj;ها نشانگر علاقه هستند. هر&zwnj;چه مشتری احتمالی سوالات بیشتری درباره محصولات و خدمات شما بپرسد، احتمال اینکه علاقه کافی برای خرید آن&zwnj; پیدا کند، بیشتر است<span dir=\"LTR\">.<br />\r\n&laquo;</span>قانون شش&raquo; در مورد اعتراضات صدق می&zwnj;کند. این قانون می&zwnj;گوید تعداد اعتراضات به یک خدمت یا محصول بیشتر از شش مورد نیست. گاهی فقط یک یا دو مورد وجود دارد اما بیشتر از شش نخواهد شد. یک ورق کاغذ بردارید و پاسخ این سوال را بنویسید<span dir=\"LTR\">:</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span dir=\"LTR\">&laquo;</span>مشتری احتمالی متناسب ممکن است چه دلایلی برای عدم خرید محصولات و خدمات من ارائه دهد؟<span dir=\"LTR\">&raquo;</span><br />\r\nحتی اگر ظرف مدت یک هفته یا یک ماه اعتراضات زیادی دریافت می&zwnj;کنید، می&zwnj;توان همه آن&zwnj;ها را در شش گروه یا کمتر طبقه&zwnj;بندی کرد. اعتراضات&nbsp; احتمالی مهم را مشخص کنید و پاسخ&zwnj;هایی منطقی و مستحکم برای هر کدام از آن&zwnj;ها در نظر بگیرید تا وقفه&zwnj;ای در فرایند فروش ایجاد نشود<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#009311\">قانون ۶: قطعی&zwnj;کردن فروش</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">بازیکنان گلف می&zwnj;&zwnj;گویند: &laquo;اولین ضربه را برای نمایش می&zwnj;زنیم، اما در ضربات بعد، پول جایزه را نشانه می&zwnj;رویم<span dir=\"LTR\">.&raquo;</span><br />\r\nتاکنون همه مراحل فروش که درباره آن&zwnj;ها صحبت کرده&zwnj;ایم را انجام داده&zwnj;ا&zwnj;ید، اما توانایی شما برای قطعی کردن فروش و وادار کردن خریدار به اتخاذ تصمیم خرید همان زمانی است که &laquo;پول را نشانه می&zwnj;روید<span dir=\"LTR\">.&raquo;</span><br />\r\nقدرتمندترین واژه در فرایند فروش &laquo;درخواست&raquo; است. افراد زیادی از عدم پذیرش و یا شنیدن واژه &laquo;نه&raquo; در مکالمه فروش هراسانند و به همین دلیل، هیچگاه درخواست نمی&zwnj;کنند. آن&zwnj;ها منفعلانه می&zwnj;نشینند و امیدوارند مشتری پیشقدم شده و خدمات و محصولات آن&zwnj;ها را بخرد. اما چنین اتفاقی به&zwnj;ندرت روی می&zwnj;دهد. حتی اگر مشتری محصولی را بخواهد، به آن نیاز داشته باشد، بتواند از آن استفاده کند و استطاعت مالی خرید آن را داشته باشد، مسئولیت فروشنده این است که به این موضوع پرداخته و از مشتری درخواست خرید کند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">دعوت به خرید. شاید ساده ترین تکنیک قطعی&zwnj;کردن فروش دعوت به خرید است. وقتی محصول را ارائه کردید، بپرسید: &laquo;آیا نگرانی یا سوالی دارید که در موردش صحبت نکرده باشیم؟<span dir=\"LTR\">&raquo;</span><br />\r\nوقتی مشتری می&zwnj;گوید: &laquo;نه، فکر می&zwnj;کنم در مورد تمام موارد صحبت شد.&raquo; با گفتن جمله &laquo;خوب، پس چرا آن&zwnj;را امتحان نمی&zwnj;کنید؟&raquo; مشتری را دعوت به خرید می&zwnj;کنید<span dir=\"LTR\">.</span><br />\r\nهمچنین، می&zwnj;توانید درباره نحوه تحویل محصول یا خدمت صحبت کنید<span dir=\"LTR\">.</span><br />\r\nبسیاری از مشتریان تنها به&zwnj;اندازه یک درخواست با خرید فاصله دارند. تنها چیزی که احتیاج دارند کمی تشویق و ترغیب است. وقتی از آن&zwnj;ها می&zwnj;پرسید &laquo;اگر علاقه&zwnj;مند هستید، چرا آن&zwnj;را امتحان نمی&zwnj;کنید؟&raquo; از شنیدن پاسخ &laquo;حتما، چرا که نه؟&raquo; شگفت&zwnj;زده خواهید شد<span dir=\"LTR\">.</span><br />\r\nخبر خوب این که اگر اعتماد و صمیمیت کافی ایجاد کنید، نیازها را به&zwnj;دقت تشخیص دهید، یک ارائه منفعت&zwnj;محور شفاف تدارک ببینید و به تمامی اعتراضات مشتری احتمالی پاسخ دهید، فروش خود&zwnj;به&zwnj;خود به&zwnj;سوی قطعی&zwnj;شدن پیش می&zwnj;رود. این کار ساده، آسان و تقریبا از پیش تعیین&zwnj;شده است. هیچگاه از درخواست کردن نترسید<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#009311\">قانون ۷: تکرار فروش و جذب مشتریان توصیه&zwnj;شده</span></span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">این قانون، مهم&zwnj;ترین بخش فرایند فروش است. هدف همه کارهایتان باید مراقبت از مشتریان و حفظ آن&zwnj;ها به&zwnj;گونه&zwnj;ای باشد که منجر به خریدهای مجدد آن&zwnj;ها شده و باعث شود شما را به دوستان و آشنایان خود نیز توصیه کنند. با هر مشتری مانند مشتری میلیون&zwnj;دلاری برخورد کنید و فرض کنید که توانایی خرید حجم عظیمی از محصولات و خدمات شما را دارد و شما را به تعداد قابل&zwnj;توجهی از مشتریان احتمالی دیگر توصیه خواهد کرد<span dir=\"LTR\">.</span><br />\r\nبه&zwnj;طور میانگین، هر&zwnj;کس سیصد نفر را به اسم می&zwnj;شناسد، این افراد می&zwnj;توانند دوستان، اقوام، معلمان، همکلاسی&zwnj;ها، همکاران، افرادی که در حیطه کاری خود با آن&zwnj;ها سرو&zwnj;کار دارید و یا معاشران شما مانند بانکدار یا حسابدار باشند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">فرض کنید تنها ۱۰ درصد افرادی که مشتریان شما می&zwnj;شناسند، مشتریان احتمالی محصولات یا خدمات شما باشند. پس اگر با مشتری خود به بهترین نحو برخورد کنید، او می&zwnj;تواند سی مشتری دیگر به شما معرفی کند. هر&zwnj;کدام از این سی مشتری نیز ۳۰۰ نفر را می&zwnj;شناسند و تقریبا ۱۰ درصد آن افراد نیز می&zwnj;توانند مشتریان احتمالی شما باشند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">پس می&zwnj;بینیم که خریدار محصولات و خدمات شما می&zwnj;تواند ظرف چند ماه آینده ۹۰۰ مشتری احتمالی دیگر برای شما به&zwnj;ارمغان آورد. آیا جالب&zwnj;توجه نیست؟ آیا این موضوع، در نحوه برخورد شما با مشتریانی که اکنون روبرویتان ایستاده&zwnj;اند، تفاوتی ایجاد نمی&zwnj;کند؟ امیدواریم این&zwnj;طور باشد<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">فروش به مشتری معرفی&zwnj;شده به یک&zwnj;پانزدهم زمان، پول و انرژی لازم برای فروش تلفنی و یا فروش به یک مشتری جدید نیاز دارد. در خرده&zwnj;فروشی مواد مصرفی، وقتی مشتری راضی شما را به فردی توصیه می&zwnj;کند، ۹۵ درصد فرایند فروش قبل از اولین دیدار انجام شده است. توصیه شفاهی &ndash; اگر به&zwnj;طور منظم و اصولی&nbsp; به&zwnj;کار گرفته شود &ndash; روشی بسیار قدرتمند برای رشد کسب&zwnj;و&zwnj;کار است<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">درخواست برای ارجاع. &laquo;قابل توصیه بودن&raquo; کلید جذب مشتریان توصیه شده است. ارائه خدمات عالی و اطلاعات آموزشی به مشتری موجب می&zwnj;شود که با اطمینان شما را به دوستان، خانواده و آشنایان خود توصیه کند. وقتی از مشتریان خود مراقبت می&zwnj;کنید، آن&zwnj;ها راغب می&zwnj;شوند دوستان&zwnj;شان نیز از چنین تجربه لذت&zwnj;بخشی برخوردار شوند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">در هر فرصت ممکن درخواست ارجاع کنید. می&zwnj;توانید بگوئید: &laquo;مشتری گرامی، من واقعا علاقه&zwnj;مندم با افرادی مانند شما کار کنم، آیا افراد فوق&zwnj;العاده دیگری مانند خودتان می&zwnj;شناسید که شاید به محصولات و خدمات ما علاقه&zwnj;مند باشند؟<span dir=\"LTR\">&raquo;</span><br />\r\nچه کسی ممکن است به شما بگوید هیچ فرد&zwnj;فوق&zwnj;العاده دیگری را نمی&zwnj;شناسد؟<br />\r\nوقتی یک مشتری راضی، مشتری احتمالی جدیدی معرفی می&zwnj;کند، نتیجه کار را به مشتری معرف گزارش دهید و جزئیات را برای او تعریف کنید. مردم نسبت به آنچه به دوستان و آشنایان آن&zwnj;ها گفته&zwnj;اید و پاسخ آن&zwnj;ها، کنجکاوی بیش&zwnj;از&zwnj;حدی دارند<span dir=\"LTR\">.</span></span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">وقتی مشتری ارجاعی خرید می&zwnj;کند، یک نامه تشکر و یا حتی یک هدیه برای فردی که او را معرفی کرده بفرستید. گزینه مورد&zwnj;علاقه من سبد هدیه&zwnj;ای پر از خوراکی&zwnj;های خوشمزه است. مردم همیشه از دریافت هدایا خوشحال می&zwnj;شوند و اگر قدردانی&zwnj;تان را به آن&zwnj;ها نشان دهید، احتمالا در آینده نیز شما را به دیگران توصیه خواهند کرد<span dir=\"LTR\">.</span><br />\r\nکتاب&zwnj;ها، مقالات، سی&zwnj;دی&zwnj;ها و برنامه&zwnj;های آموزش فروش بسیاری به این هفت گام فرایند فروش پرداخته&zwnj;اند. نکته مهم آن است که گاهی بهبودی کوچک در یک حوزه، منجر به موفقیت&zwnj;های بزرگ می&zwnj;شود<span dir=\"LTR\">.</span></span></span></span></p>','/app/articles/1545648266553.jpg','/app/articles/1545648266431.jpg','موفقیت,فروش موفق,هفت قانون فروش موفق,Amazon MAG,فروش آنلاین','هفت-قانون-فروش-موفق',717,2,1,'2018-12-24 14:14:26','2022-01-11 11:46:23');
INSERT INTO `articles` VALUES (41,4,'کارآفرینی اینترنتی: استفاده از شبکه جهانی وب برای کسب درآمد','امروزه اینترنت به بخش بزرگی از کسب و کارهای کوچک و بزرگ تبدیل شده است. تعداد بیشماری از افراد در دنیای اینترنت حضور دارند','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:22px\"><span style=\"color:#0000FF\"><span style=\"font-family:comic sans ms,cursive\">کارآفرینی اینترنتی: استفاده از شبکه جهانی وب برای کسب درآمد</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">امروزه اینترنت به بخش بزرگی از کسب و کارهای کوچک و بزرگ تبدیل شده است. تعداد بیشماری از افراد در دنیای اینترنت حضور دارند و از طریق تبلیغات شبکه&zwnj;های اجتماعی با روش&zwnj;های جدید تجارت آنلاین آشنا می&zwnj;شوند، که این امر موجب پیدایش نسل جدیدی از افراد تحت عنوان کارآفرین اینترنتی شده است. کارآفرین اینترنتی کسی است که به قدرت گسترده اینترنت برای شروع یا رشد کسب و کار خود توجه می&zwnj;کند. کسی که می&zwnj;خواهد به یک کارآفرین اینترنتی موفق تبدیل شود و کاری اصولی انجام دهد، بایستی این فناوری جدید را با روش&zwnj;های سودمند کسب و کار سنتی به خوبی ترکیب کند<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">کارآفرینی به عنوان توانایی و اشتیاق برای راه اندازی، سازماندهی و مدیریت سرمایه&zwnj;گذاری در عرصه&zwnj;ای جدید برای ایجاد سود، همراه با پذیرش تمام خطرات مرتبط با آن تعریف می&zwnj;شود. باید توجه داشت که در این مقطع زمانی، تبدیل شدن به یک کارآفرین موفق به هیچ&zwnj;وجه کار آسانی نیست و موفق&zwnj;ترین کارآفرینان نیز ممکن است تلاش زیادی برای موفقیت انجام دهند ولی در نهایت کسب و کارشان شکست بخورد<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">استیو جابز، یکی از بنیانگذاران و مدیر عامل شرکت اپل می&zwnj;گوید &quot;من متقاعد شده&zwnj;ام که تقریباً نیمی از چیزی که کارآفرینان موفق را از افراد غیر موفق جدا می&zwnj;کند، استقامت است&quot;، که این صحبت نشان دهنده اهمیت تلاش و حفظ امید برای موفق شدن یک کارآفرین اینترنتی می&zwnj;باشد<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">علاوه بر این، تیم اشمیت (کارآفرین اینترنتی موفق) عنوان می&zwnj;کند که نوآوری و ریسک پذیری، ویژگی&zwnj;های اساسی روحیه یک کارآفرین اینترنتی است. برای اینکه هر کارآفرینی بتواند در بازار جهانی که بسیار رقابتی و همواره در حال تغییر است موفق شود، دارا بودن این صفات شخصیتی ضروری است. این حقایق به معنای منصرف ساختن مردم از کارآفرینی نیستند. در واقع، اکثر اقتصادهای جهانی وابسته به افرادی هستند که کسب و کار کوچکی را راه اندازی می&zwnj;کنند تا به کاهش آمار بیکاری کمک کنند. با این حال، مهم است که چالش&zwnj;های خاصی که هر کارآفرین با آن مواجه است را بشناسیم و درک کنیم<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">کارآفرینی اینترنتی چیست؟</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ویکی پدیا یک کارآفرین اینترنتی را تحت عنوان یک کارآفرین، مالک، بنیانگذار و مدیر یک کسب و کار مبتنی بر اینترنت تعریف می&zwnj;کند که با ریسک پذیری و نوآوری، درآمدزایی می&zwnj;کند. بنابراین، بزرگترین تفاوت بین کارآفرینان این است که کارآفرین اینترنتی، از اینترنت برای کسب درآمد بهره می&zwnj;گیرد، درحالی که روال کاری کارآفرینان سنتی بر پایه اینترنت نیست. البته این به مفهوم عدم استفاده کسب و کارهای غیر اینترنتی از اینترنت نیست، بلکه بدان معناست که درآمد آنها از اینترنت به دست نمی&zwnj;آید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">اصول شروع کارآفرینی اینترنتی </span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">آیا تاکنون به این موضوع فکر کرده&zwnj;اید که در منزل خود بنشینید و با داشتن یک وب سایت و چند ساعت کار در روز بتوانید درآمدی بیشتر از یک کارمند به دست آورید؟ </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اگر می&zwnj;خواهید این فکر را عملی کنید پس باید به فکر راه&zwnj;&zwnj;اندازی کسب و کاری اینترنتی باشید. انجام آن نیز نیازمند برنامه&zwnj;ریزی و پیروی از اصولی است که ما در زیر برایتان شرح می&zwnj;دهیم<span dir=\"LTR\">: </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">1- </span>میزان استقبال از محصول&zwnj;تان را ارزیابی کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در ابتدا باید در مورد ایده کاری&zwnj;تان تحقیق کنید و ببینید که آیا محصول مورد نظر شما خواهان دارد یا نه. برای این کار هم باید دقت کنید که نظرات اطرافیان&zwnj;تان برای شما کاربردی ندارد، چون آنها می&zwnj;خواهند از شما حمایت کنند و قطعاً از فکر شما استقبال می&zwnj;کنند که این موضوع باعث گمراهی شما خواهد شد. پس حتماً به دنبال منابع مؤثر بروید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">2- </span>استراتژی کاری خود را مشخص کنید<span dir=\"LTR\">.&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">یک کارآفرین اینترنتی باید بداند که چگونه برای تبلیغات هزینه کند. محصول خود را به صورت درست قیمت گذاری کند. میزان نفوذ و تسلط رقبای خود در بازار را بداند. طریقه جذب مشتریان جدید را بداند. عوامل مؤثر در موفقیت خود را شناسایی کند. حال با این دانسته&zwnj;ها می&zwnj;توانید برنامه&zwnj;ای واقعی برای کسب و کار خود چیده و به شیوه&zwnj;ای صحیح و قدرتمند وارد بازار شوید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">3- </span>باید از رقبایتان متفاوت باشید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">قطعاً محصول شما تنها توسط شما در اینترنت به فروش نخواهد رسید. همچنین قیمت محصول شما نیز نمی&zwnj;تواند با دیگر رقبایتان تفاوت زیادی داشته باشد. پس شما باید خدمات خود را به گونه&zwnj;ای منحصر به فرد ارائه دهید تا بتوانید مشتریان را به سمت خودتان جذب کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">4- </span>احتمال نیاز به افزایش سرمایه&zwnj;گزاری را در نظر داشته باشید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">جدا از میزان استقبال و محبوبیت محصول&zwnj;تان، شما باید سرمایه کافی برای رقابت در بازار داشته باشید. نکته مهم در این موضوع، پیش&zwnj;بینی مبلغی بالاتر از برآورد اولیه&zwnj;تان برای مقابله با شرایط پیشرو می&zwnj;باشد که این موضوع می&zwnj;تواند کسب و کار شما را در شرایط بحران نجات دهد<span dir=\"LTR\">.&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">5- </span>شرایط کاری&zwnj;تان را با زندگی شخصی خود هماهنگ کنید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">همانند سایر مشاغل، کارآفرینی اینترنتی هم سختی&zwnj;های خاص خود را دارد. اگر شما می&zwnj;خواهید در کنار فعالیت اصلی خود، کسب و کاری اینترنتی هم راه اندازی کنید، بایستی پشتکار زیادی داشته باشید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">جدا از داشتن یک برنامه مشخص کاری، شما بایستی در زمان&zwnj;های غیر اداری و تعطیلات نیز پاسخگوی مشتریان خود باشید. پس برای اینکه در زندگی شخصی خود دچار مشکل نشوید نیاز به برنامه&zwnj;ریزی قبلی دارید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">چگونه میزان پیشرفت کسب و کار اینترنتی خود را بسنجیم؟</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برای اطلاع از میزان پیشرفت کسب و کارتان، همواره باید آن را با یک شاخص از پیش تعیین&zwnj;شده&zwnj;ای که به آن شاخص&zwnj; عملکردی می&zwnj;گویند، بسنجید. البته باید توجه داشته باشید که برای پیشرفت در کسب و کار بایستی این شاخص را به صورت دوره&zwnj;ای ارتقا داد. این امر شما را مجبور می&zwnj;کند که پشتکار خود را به صورت مداوم افزایش دهید که نتیجه آن رونق کسب و کار اینترنتی شما خواهد بود<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در هر کسب و کار اینترنتی بسته به نوع فعالیت می&zwnj;توان از یک یا چند شاخص عملکردی به صورت جداگانه و یا تلفیقی استفاده کرد. ما در اینجا تعدادی از این شاخص&zwnj;ها را برایتان توضیح می&zwnj;دهیم که به شما کمک می&zwnj;کنند تا از همان زمان شروع کسب و کارتان، پیشرفت خود را سنجیده و برنامه&zwnj;های&zwnj;تان را تجزیه و تحلیل کنید<span dir=\"LTR\">.&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">- </span>میزان تعامل در وب سایت شما</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این معیار مشخص کننده مقدار موفقیت وب سایت شما در زمینه جذب مشتری&zwnj;های بالقوه می&zwnj;باشد<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">- </span>میزان بازدید</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این معیار، تعداد بازدید از وب سایت شما را در دوره زمانی خاصی مثل یک روز یا یک هفته یا... نشان می&zwnj;دهد. از بالا بودن این تعداد می&zwnj;توان نتیجه گرفت که شرایط کاری شما خوب است. البته نمی&zwnj;توان به صورت کامل روی این عدد حساب کرد، چون برخی از بازدیدکنندگان به صورت تصادفی به وب سایت شما سر می&zwnj;زنند و به لیست مشتریان اضافه نخواهند شد، پس این معیار میزان اندکی خطا با خود به همراه خواهد داشت<span dir=\"LTR\">.&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">- </span>میزان دقیق بازدیدکنندگان</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در معیار قبلی تعدد بازدید یک بازدیدکننده خاص نیز شمرده خواهد شد. ولی در این معیار، اگر یک کاربر چندین بار به وب سایت شما سر بزند فقط بار اول آن ثبت خواهد شد و بازدیدهای بعدی او دیگر شمارش نخواهد شد<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">- </span>میزان بازدید مجدد </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این معیار تعداد نفراتی را نشان می&zwnj;دهد که بازدید مجددی از سایت شما داشته&zwnj;اند. پس افزایش این تعداد، نشان دهنده کارایی وب سایت، پیشرفت کاری و جذب مشتریان بیشتر برای شما خواهد بود<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مقاله مرتبط: گوگل آنالیتیکس و هر آنچه برای کار با آن باید بدانید</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">- </span>متوسط میزان زمان صرف شده توسط هر بازدیدکننده</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این معیار نشان دهنده زمانی است که هر بازدید کننده در وب سایت شما سپری می&zwnj;کند. در واقع این مورد از معیارهای کلیدی برای سنجش میزان موفقیت شما می&zwnj;باشد، چون میزان جذابیت و مفید بودن مطالب موجود در وب سایت شما برای کاربران را نشان می&zwnj;دهد<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مسیرهای دسترسی مشتریان به وب سایت خود را شناخته و تحلیل کنید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">از کاربردی&zwnj;ترین مسائلی که یک کارآفرین اینترنتی باید از آن اگاه باشد، مسیرهای ورود و دسترسی بازدیدکنندگان از وب سایت او می&zwnj;باشد. در اینجا ما 4 مسیر را به عنوان مسیرهای ورودی اصلی بازدیدکنندگان به شما معرفی می&zwnj;کنیم<span dir=\"LTR\">: </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ورود مستقیم </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ورود از لینک&zwnj;های موجود در سایر وب سایت&zwnj;ها </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ورود به کمک موتورهای جستجوگر </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ورود به واسطه تبلیغات شما در سایر وب سایت&zwnj;ها</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">باید توجه داشته باشید که دانستن مسیر ورودی بازدیدکنندگان از وب سایت شما بسیار کلیدی می&zwnj;باشد. البته نباید فراموش کنید که جذب بازدیدکنندگان مؤثر که تبدیل به مشتریان شما بشوند، بسیار مهمتر &zwnj;از داشتن تعداد بالایی بازدیدکننده بی&zwnj;ثمر می&zwnj;باشد. پس باید تلاش کنید که با ارائه مطالب خوب، بازدیدکنندگان را به وب سایت خود جذب کنید، در غیر این صورت آنها سریعاً از وب سایت شما خارج می&zwnj;شوند که این موضوع هیچ سودی برای شما به همراه نخواهد داشت<span dir=\"LTR\">.&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">مزایای کارآفرینی اینترنتی</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مزایای گوناگونی در راه اندازی کسب و کاری مبتنی بر اینترنت وجود دارد، ولی اکثر مردم چون دید بسیار کمی از کسب و کار اینترنتی دارند از مزایای آن بی&zwnj;اطلاعند و به سراغ آن نمی&zwnj;روند<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ما در اینجا 6 مزیت کارآفرینی اینترنتی را برای شما معرفی می&zwnj;کنیم و امیدواریم که با مطالعه آنها انگیزه لازم جهت شروع کار در اینترنت را به دست آورید<span dir=\"LTR\">:</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">1- </span>طیف گسترده&zwnj;ای از فرصت&zwnj;های کاری مبتنی بر اینترنت وجود دارند<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">واقعیت موضوع این است که شما می&zwnj;توانید هر کاری را به صورت آنلاین انجام دهید. شما برای فروش اموال دست دوم خود در اینترنت محدودیتی ندارید. در واقع فرصت&zwnj;های کسب درآمد در اینترنت بی&zwnj;پایان است. همه کاری که باید انجام دهید این است که کمبودها و نیازهای افراد را شناسایی کنید، یک طرح کاری برای خود تعریف کنید و برای موفقیت تلاش کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برای مثال می&zwnj;توانیم اسنپ را تحلیل کنیم، همه ما تا حدودی نسبت به اسنپ آشنایی داریم و با آن کار کرده&zwnj;ایم و تا حدودی نسبت به آن رضایت داریم، چرا اسنپ با درصد بالایی از رضایت مردم روبرو شد؟ به این دلیل که رفت و آمد یک مسئله مهم برای افراد محسوب می&zwnj;شود و اینکه شما بدون هیچ تماسی و فقط با اینترنت بتوانید مقصد خود را تعیین کنید و در کمترین زمان یک ماشین به دنبال شما بیاید خیلی خوشایند است. پس کسب و کار اینترنتی باید طوری طراحی شود که زمان را تسریع کند، هزینه&zwnj;ها را تا حدودی کاهش دهد و افراد را در کوتاه&zwnj;ترین زمان به نیازشان برساند<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">2- </span>به دنبال رویاها و آرزوهای خود می&zwnj;روید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">با توجه به ماهیت فعالیت در کسب و کارهای آنلاین، می&zwnj;توانید در زمینه مورد علاقه خود کار کنید. هنگامی که شما یک کارمند هستید، به رشد دیگران در زمینه کاریشان کمک می&zwnj;کنید ولی هنگامی که شما برای خودتان کار می&zwnj;کنید و یا یک کارآفرین هستید، درآمد خود را با انجام کاری که دوست دارید به دست می آورید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">3- </span>پتانسیل درآمدی&zwnj; خود را افزایش می&zwnj;دهید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">یکی از معایب کارمند بودن این است که درآمد شما همیشه محدود خواهد بود، ولی اگر شما برای خودتان کار کنید، می&zwnj;توانید به همان اندازه که می&zwnj;خواهید، درآمد کسب کنید. البته میزان درآمد شما به نوع کسب و کار و میزان تلاش&zwnj;تان&zwnj; بستگی دارد<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">4- </span>ساعات کاریتان را انتخاب می&zwnj;کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اینترنت برای فعالیت در تمامی ساعات روز در دسترس است. بنابراین، شما می&zwnj;توانید ساعت کاری خود را انتخاب کنید. با این حال، مهم است توجه داشته باشید که در شرایط واقعی، ساعات کار شما تا حد زیادی توسط مشتریان و شرایط کاریتان تعیین می&zwnj;شود<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">5- </span>خدمات اینترنتی قابل ارائه به مشتریان پیشرفت کرده است<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">فضای آنلاین به شما امکان می&zwnj;دهد که خدمات بی&zwnj;نظیری را به مشتریان خود ارائه دهید. شما به واسطه آنلاین بودن، از انعطاف پذیری بالایی برای برقراری ارتباط با مشتریان خود از طریق کانال&zwnj;های مختلف از قبیل شبکه&zwnj;های اجتماعی، ایمیل و همچنین برنامه&zwnj;های پیام رسانی برخوردار خواهید بود<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">6- </span>کاهش هزینه شروع و انجام یک فعالیت </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">کسب و کار مبتنی بر اینترنت باعث کاهش و صرفه جویی هزینه&zwnj;های سنتی مدیریت کسب و کار خواهد شد. به عنوان مثال، شما مجبور نیستید برای ملاقات با مشتریان خود هزینه رفت و آمد پرداخت کنید. لازم نیست فاکتورهای کاغذی چاپ کنید. و اگر مدل کسب و کار شما اجازه بدهد، شما حتی نیازی به فضای اداری هم ندارید و تمام کارکنان شما می&zwnj;توانند دورکار باشند<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">مشکلات و محدودیت&zwnj;های کارآفرینی اینترنتی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">1- </span>قوانین</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">هنگامی که شما به صورت اینترنتی کار می&zwnj;کنید، اگر کاربرانی از کشورهای مختلف به وب سایت شما دسترسی داشته باشند، شما ملزم به رعایت قوانین آن کشورها هستید. کسب و کار اینترنتی شما تحت قوانین حریم خصوصی، قوانین حق چاپ و تکثیر در سراسر جهان و قوانین مالیاتی محل شرکت شما بستگی دارد. اگر محصولاتی دارید که نباید در دسترس افراد زیر سن خاصی قرار گیرند، برای ادامه کار وب سایت خود باید قوانین آنها را در نظر بگیرید. با توجه به موارد گفته شده بایستی در هنگام ساختن وب سایت، با یک مشاور حقوقی مشورت کنید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">2- </span>عدم اعتماد</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مصرف کنندگان معمولاً در هنگام خرید اینترنتی بسیار محطاتانه رفتار می&zwnj;کنند. برای جلب اعتماد مشتریان می&zwnj;توانید از سازمان&zwnj;های امنیتی آنلاین تأییدیه دریافت کنید. هنگامی که شما یک کسب و کار اینترنتی را راه اندازی می&zwnj;کنید، نمی&zwnj;توانید به صورت حضوری با مشتریان ارتباط برقرار کنید، بنابراین باید برای ایجاد اعتماد از شیوه&zwnj;های دیگری استفاده کنید. حتی با تمام اقداماتی که برای جلب اعتماد انجام می&zwnj;دهید، باز هم بخشی از مردم ممکن است برای ارائه اطلاعات پرداخت خود در اینترنت احساس خوبی نداشته باشند<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">3- </span>تقلید و الگوبرداری</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">از آنجایی که روزانه میلیون&zwnj;ها نفر در سراسر جهان به اینترنت دسترسی دارند، بسیار مهم است که از ایجاد رقیب برای خود جلوگیری کنید. یکی از مشکلات کارآفرینی اینترنتی این است که دیگران می&zwnj;توانند ایده&zwnj;های موجود در وب سایت شما را برای خود بردارند. باید توجه داشته باشید که اگر یک کسب و کار اینترنتی موفق ایجاد کنید، احتمال زیادی وجود دارد که کسی سعی کند آن را کپی کرده و مشتریان شما را به سمت خودش بکشاند. در واقع ناتوانی شما در محافظت از ایده&zwnj;های&zwnj;تان یکی دیگر از مشکلات کارآفرینی اینترنتی می&zwnj;باشد<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">4- </span>دشواری گسترش روابط </span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">با وجود اینکه کارآفرینی اینترنتی می&zwnj;تواند درهای ورود به بازارهای موجود در سراسر جهان را باز کند، اما گسترش روابط تجاری با مشتریان خارج از کشور بسیار دشوار است. در حالیکه شما در ایران زندگی می&zwnj;کنید، احتمالاً فرصتی برای دیدار با مشتری در ژاپن یا استرالیا نخواهید داشت. درست است که تکنولوژی&zwnj;هایی مانند ویدئو کنفرانس به شما امکان می&zwnj;دهد تا افراد را از طریق صفحه رایانه ببینید، ولی قطعاً این ارتباط، تأثیر ملاقات حضوری را نخواهد داشت<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">5- </span>حریم خصوصی و نگرانی&zwnj;های امنیتی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حتی اگر شما اقدامات احتیاطی مانند راه&zwnj;اندازی یک صفحه پرداخت امن برای خرید مشتری&zwnj;های خود را انجام دهید، باز هم ممکن است افرادی سیستم شما را هک کرده و اطلاعات شخصی شما را سرقت کنند. این مورد ممکن است شامل تخلیه حساب&zwnj;های بانکی مشتریان شما و یا سرقت هویت آنها نیز بشود<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">6- </span>محدودیت&zwnj;های برخی از کسب و کارها</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برخی از انواع کسب و کارها ممکن است برای اینترنت مناسب نباشد، به خصوص اگر برای خرید محصولات نیاز به استفاده از حواس باشد. به عنوان مثال، اگر محصول شما چیزی مثل عطر باشد، شما برای توصیف آن در اینترنت مشکل خواهید داشت. چون همیشه افرادی هستند که ترجیح می&zwnj;دهند بعد از دیدن و لمس یک محصول آن را بخرند؛ محصولاتی مانند خودرو، لباس، کفش، مبلمان و<span dir=\"LTR\"> ... </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">12 </span>نکته برای کمک به موفقیت شما به عنوان یک کارآفرین اینترنتی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حالا که تعدادی از مزایای کارآفرینی اینترنتی را به شما معرفی کردیم، می&zwnj;خواهیم چند مورد برای کمک به موفقیت شما نیز مطرح کنیم<span dir=\"LTR\">:</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">1- </span>پشتکار داشته باشید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حتی اگر در مرحله&zwnj;ای از کار خود دلسرد شدید، بسیار مهم است که به تلاش برای رسیدن به هدف خود ادامه دهید. علاوه بر این، مهمترین ویژگی شخصیت یک کارآفرین موفق، داشتن پشتکار و ثبات قدم است<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">2- </span>کمبودهای بازار را پیدا کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">از خانه بیرون بزنید و شرایط بازار را بررسی کرده و نیازهای فعلی آن را شناسایی کنید. به دنبال نقاط ضعف در کالاهای موجود فعلی برای نیازهایی مانند راه&zwnj;های کاهش وزن و جلوگیری از پیری بروید و کم و کاست&zwnj;های تولیدات موجود در بازار را پیدا کنید. شما نباید تمرکز خود را فقط بر روی شبکه&zwnj;های اجتماعی مانند فیسبوک، توئیتر یا ... بگذارید. برای دستیابی به شانس بیشتر در کسب موفقیت، بایستی ریسک پذیر باشید و کار جدید انجام دهید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">3- </span>ابتکار به خرج دهید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">یک کارآفرین اینترنتی موفق همواره باید خود را از دیگران متمایز کند. افراد به دنبال&nbsp; کارآفرینان متخصص می&zwnj;گردند و شما باید همان متخصصی باشید که آنها به دنبالش هستند. شما می&zwnj;توانید با ساخت یک وب سایت حرفه&zwnj;ای تخصص خود را نشان دهید. وب سایتی بر پایه اعتماد و اطمینان بسازید. در دنیای کسب و کار اینترنتی، ایجاد حس اعتماد و اطمینان، از هرچیزی با ارزش&zwnj;تر است<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">4- </span>یک مدل اجرایی برای کسب و کار تهیه کنید</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">یک مدل کاری، شبیه به مسیر از پیش برنامه&zwnj;ریزی شده یک هواپیما برای رسیدن به مقصد می&zwnj;باشد. این مسیر از پیش تعیین&zwnj;شده علاوه بر تعیین مسیری که هواپیما باید از آن عبور کند، به خلبان و مهندسین پرواز نیز در محاسبه مقدار سوخت مورد نیاز برای رسیدن هواپیما به مقصد کمک می&zwnj;کند. اگر مسیری از پیش تعیین&zwnj;شده وجود نداشته باشد، ممکن است که هواپیما به مقصد خود نرسد<span dir=\"LTR\">..</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">همچنین بایستی در مورد زمینه کاری خود تحقیقات کاملی انجام دهید. ایده کاری شما ممکن است به نظر سود آور باشد، اما تا زمانی که در مورد افراد مشغول در این زمینه تحقیق نکرده باشید، نمی&zwnj;دانید که در کجای کار قرار دارید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">باید بدانید که اگر شما کارکرد و مدل کسب و کار خود را درک نکرده&zwnj;اید و شرح کاری برای خودتان تعریف نکرده&zwnj;اید، نمی&zwnj;توانید اهداف از پیش تعیین&zwnj;شده خود را بدست آورید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">5- </span>اجازه دهید کسب و کارتان رشد و تکامل پیدا کند<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تجربیات شخصی نشان داده است که باید انعطاف پذیر بوده و اجازه دهید قالب کسب و کار شما همگام با فضای اینترنت که همیشه در حال تغییر است، تکامل پیدا کند.. نیاز مشتری تغییر می&zwnj;کند؛ بنابراین، به منظور به روز بودن برندتان، بایستی اجازه دهید که چارچوب کسب و کار شما تغییر کند. به عبارت دیگر، واجب است که نیازهای مخاطبان هدف خود را در اولویت قرار داده و کسب و کار خود را در راستای برآورده سازی این نیازها تغییر دهید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">6- </span>فنون کسب و کار را یاد بگیرید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برای تبدیل شدن به یک کارآفرین موفق، بایستی دوره&zwnj;های کسب و کار و مدیریت را بگذرانید، چون پیشرفت در تجارت نیاز به آموزش دارد. به آموزش تجارت نیاز دارید. البته چون در کسب و کار اینترنتی شما رئیس خود هستید، نیازی به گرفتن مدرک دانشگاهی برای ارتقا ندارید و فقط گذراندن دوره&zwnj;های آموزشی برای شما کفایت می&zwnj;کند<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">همچنین شما باید مهارت اولیه&zwnj;ای نیز در استفاده از کامپیوتر داشته باشید که بتوانید آسیب&zwnj;های وارده احتمالی به کسب و کارتان را برطرف کنید. در غیر این صورت شما بایستی از خدمات شرکت&zwnj;های بازاریابی اینترنتی استفاده کنید که احتمالاً هزینه&zwnj;های زیادی برای شما در پی خواهد داشت<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">7- </span>کسب و کار خود را ثبت کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اولین گام برای حضور در کسب و کار اینترنتی این است که<span dir=\"LTR\"> DOMAIN </span>خود را ثبت کنید. باید سعی کنید که این نام جذاب و با زمینه کاری شما مرتبط باشد. سپس یک<span dir=\"LTR\"> HOST </span>دریافت نمایید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در مرحله بعد بایستی کسب و کار اینترنتی خود را ثبت کرده و برای آن یک مجوز رسمی از دولت بگیرید. مرحله بعدی، ساخت یک وب سایت است که گامی مهم برای یک کارآفرین اینترنتی می&zwnj;باشد و باید مطمئن شوید که استفاده از آن برای شما و مشتریان&zwnj;تان آسان باشد. بازدیدکنندگان باید بتوانند بدون دریافت پیام خطا در وب سایت شما بچرخند و اطلاعاتی را باید درباره کسب و کار شما بدانند، مشاهده کنند<span dir=\"LTR\">.&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">8- </span>اضافه کردن ویژگی&zwnj;های کاربر پسند</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سبد خرید یا زیرساخت&zwnj;های دیگر را در وب سایت اضافه کنید. یکی از نیازهای مهم تبدیل شدن به یک کارآفرین اینترنتی موفق، قرار دادن ابزارهای مورد نیاز درون وب سایت است. شرایطی را برای مشتریان فراهم کنید تا بتوانند خرید خودشان را به راحتی انجام دهند<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">از نظرسنجی&zwnj;ها برای پیدا کردن مسیر صحیح کسب و کارتان استفاده کنید. هر کسب و کاری نیاز به روشی برای پیگیری فروش&zwnj;ها و شناسایی مخاطبان هدف دارد. ابزارهای جامع وب می&zwnj;توانند یک طرح بازاریابی پیشرفته را به شما ارائه کنند. از ویژگی&zwnj;های وب استفاده کنید تا نیازهای مشتریان خود را برطرف کنید<span dir=\"LTR\">.&nbsp; </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برنامه&zwnj;های تلفن هوشمند را گسترش دهید. این بعد از کسب و کارهای اینترنتی به سرعت در حال رشد است و شما باید خود را با آن تطبیق دهید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">9- </span>کنترل و بهینه سازی هزینه&zwnj;های تبلیغاتی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تبلیغات را به صورت مناسب انجام دهید. نیازهای تبلیغاتی برای هر کسب و کار اینترنتی متفاوت است. اینکه دقیقاً بر روی همان چیزی که کسب و کارتان نیاز دارید دست بگذارید، بخش بزرگی از موفقیت شما به عنوان یک کارآفرین اینترنتی را تضمین می&zwnj;کند. با این حال، یک ایده خوب این است که مشتریان اینترنتی بالقوه را در همان جایی که آنها فعالیت می&zwnj;کنند، هدف قرار دهید، پس بایستی برای خرید فضای تبلیغاتی در موتورهای جستجو، وب سایت&zwnj;ها و برنامه&zwnj;های دیگر، هزینه کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برای اطلاع از سایر وب سایت&zwnj;هایی که مشتریان شما بازدید می&zwnj;کنند، به تجزیه و تحلیل ارائه شده توسط موتورهای جستجوی مشهور نگاه کنید. این اطلاعات به شما می&zwnj;گوید مشتریان شما به چه وب سایت&zwnj;هایی سر می&zwnj;زنند، چه چیزی را در وب سایت شما جستجو می&zwnj;کنند و خیلی موارد دیگر. حتی وب سایت&zwnj;های دیگری را که بازدید می&zwnj;کنند، به شما نشان می&zwnj;دهد. شما می&zwnj;توانید از این اطلاعات برای سرمایه گذاری در تبلیغات خود استفاده کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">همچنین می&zwnj;توانید از شبکه&zwnj;های اجتماعی هم به عنوان روشی رایگان و آسان برای تبلیغ کسب و کار خود استفاده کنید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">و در نهایت بایستی تبلیغ فیزیکی را هم اضافه کنید؛ زیرا بسیاری از کاربران که به طور منظم از اینترنت استفاده نمی&zwnj;کنند و برای شناساندن کسب و کار خود به آنها نیاز به راه&zwnj;های دیگری دارید که تبلیغات فیزیکی یکی از آنهاست<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">10- </span>همه مراحل کاری شما بایستی به صورت خودکار عمل کند<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">از فن آوری&zwnj;های جدید استفاده کنید. مردم هنگام خرید محصولات یا کالاها به صورت اینترنتی، به دنبال آن هستند که همه کارها به صورت خودکار انجام شود. ابزارهای اینترنتی گسترده&zwnj;ای وجود دارند که شما می&zwnj;توانید برای رفع این نیازتان از آنها استفاده کنید. سیستم&zwnj;های ثبت سفارش و تحویل خودکار، سیستم پرداخت مطمئن و کاربر پسند، و سایر روش&zwnj;های مورد استفاده، به شما کمک می&zwnj;کند که شما بتوانید به صورت شبانه روزی از&nbsp; کسب و کار خود درآمد کسب کنید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">11- </span>فعالیت&zwnj;های خود را برون سپاری کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برون سپاری یکی از عناصر کلیدی برای هر کارآفرین اینترنتی است. شما می&zwnj;توانید با صرف هزینه کم از دستیارهای مجازی کمک بگیرید. شما می&zwnj;توانید از سایت&zwnj;های مخصوص به منابعی عالی از کارکنان با مهارت&zwnj;های تخصصی در حسابداری، مدیریت پایگاه داده، میزبانی وب، نوشتن مقاله و غیره دست پیدا کنید. سعی کنید وظایف کاری خود را به دیگران محول کرده و خودتان بر روی فعالیت&zwnj;های اصلی کسب و کارتان تمرکز کنید<span dir=\"LTR\">.</span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span dir=\"LTR\">12- </span>با مخاطبان خود ارتباط برقرار کنید<span dir=\"LTR\">. </span></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">با مخاطبان آنلاین خود ارتباط برقرار کرده و این اتصال را محکم کنید.. از تمایلات و احساسات آنها در تولید محتوای وب سایت خود استفاده کنید. نظرات در مورد محصولات، نظرات درج شده در وبلاگ، صفحات تبادل نظر و مطالعات موردی، منابعی عالی برای درج در بانک اطلاعاتی شما هستند<span dir=\"LTR\">.</span></span></span></p>','/app/articles/1545649478947.jpg','/app/articles/1545649478945.jpg','کارآفرینی,اینترنت,فروشگاه آنلاین,Amazom MAG,شبکه اجتماعی','کارآفرینی-اینترنتی-استفاده-از-شبکه-جهانی-وب-برای-کسب-درآمد',661,3,1,'2018-12-24 14:34:38','2022-01-10 00:27:05'),(42,2,'پلی اورتان ها و کاربرد آن ها','پلی اورتان و مشتقات آن بسپارهایی پر کاربرد در صنایع گوناگون، در سراسر جهان هستند.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">پلی اورتان ها و کاربرد آن ها</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">پلی اورتان و مشتقات آن بسپارهایی پر کاربرد در صنایع گوناگون، در سراسر جهان هستند. فرمول بندی این بسپارها به گونه ای است که دامنه گسترده ای از مواد سخت، خشک و فشرده را در بر می گیرد. پلی اورتان ها از واکنش افزایشی میان گروههای عاملی ایزوسیانات و عامل هیدروکسیل تشکیل می شوند. اگر به جای دی الکل ، یک دی آمین با ایزوسیانات وارد واکنش شود، بسپار به دست آمده در خانواده پلی اوره ها قرار می گیرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">گروه های ایزوسیانات به شدت واکنش پذیر بوده و به همین علت پیشرفت&nbsp; واکنش آن ها به افزایش دما نیاز ندارد. مهمترین ویژگی این گروه از پلیمر ها این است که پس از واکنش ساختار پایداری به وجود می آید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">نخستین پلی اورتان ها در سال 1937توسط اتوبایر طی واکنش میان یک دی ایزوسیانات زنجیری و یک دی آمین به دست آمد. گروه عاملی ایزوسیانات با هر مولکولی که دارای یک هیدروژن فعال باشد واکنش می دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بنابراین ترکیباتی همچون کربوکسیلیک اسیدها و آمین ها که مانند گروه هیدروکسیل، از هیدروژن فعال برخوردارند می توانند با ایزوسیانات واکنش دهند.از این رو، هنگامی که پلی اورتان ها صحبت به میان می آید. گونه ها ی بی شماری از این مواد را می توان در نظر گرفت. بنابراین گوناگونی واکنشگرهایی که در برابر ایزوسیانات ها قرار می گیرند به تولید پلی اورتان ها در انواع گوناگون با ویژگی های متفاوت می انجامد.در واقع خواص تمام پلی اورتان ها برگرفته از تآثیر انواع پلی اول ها بر انواع ایزوسیانات می باشد.تعداد این گروه ها در یک ساختار مولکولی و همچنین نحوه ی قرار گیری آن ها در کنار ساختمان اصلی شیمیایی هر یک از مواد در تعیین خواص بسیار مهم است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">پلی اورتانها دسته ای از پلیمرهای پرمصرف با خواص عالی هستند. به همین خاطر طراحان و متخصصین صنایع پوشش دهی به خوبی توان بهره برداری از این ترکیبات را در کاربردهای گوناگون دارند مثال های متعددی برای کاربردهای فراوان این ترکیبات وجود دارد. از جمله پوشش شفاف برای پوشش دهنده های تک لایه مخصوص بام ها و رنگ های مشخص کردن محل گذر عابر پیاده و ...</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">پلی اورتان آلیفاتیک از نوع آروماتیک گرانتر هستند. به همین خاطر انواع آروماتیک و نمونه های اپوکسی دار در استری ها، رنگ های پایه و پوشش های رابط بکار می روند. در&nbsp; حالی که آلیفاتیک ها ویژه پوشش نهایی هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">رزین های پراکنشی پلی اورتانی(pud)</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">روش مرسوم در ساخت رزین های پراکنشی پلی اورتانی بر پایه آّب، تهیه پیش پلیمری با گروه پایانی ایزوسیانات است که پلی ال اصلاح کننده در ساختار زنجیر، گروه عاملی کربوکسیلیک اسید را به وجود می آورد و در مرحله بعد این ماده با آمین نوع سوم در آب پخش می شود تا مراکز یونی به وجود آورد. به این ترتیب ذرات پلیمری پایدار می شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در برخی مخلوط ها نسبت مولی گروه های NCO به OH دقیقا 2 به 1 است. در نسبت مولی حدود 1 به 1 گرانروری بسیار زیاد می شود و تهیه رزین های پراکنشی پلی اورتانی با مشکل رروبرو می شود. در ضمن خطر ژله ای شدن نابهنگام هم وجود دارد. ولی اگر این نسبت کمتر از 5/1 به 1 باشد خطر ژله ای شدن کمتر می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برای پایین آوردن سریع دما در حین تهیه مخلوط های پلی اورتانی از یخ استفاده می کنند . در نتیجه سرعت واکنش بین آب و گروه ایزوسیانات کم می شود. بهترین حالت این است که پیش پلیمر با گروه پایانی NCO با افزاینده زنجیر آمینی واکنش دهد . با این حال پراکنده کردن پیش پلیمر در آب به ویژه یک واحد صنعتی نیازمند زمان مشخصی است. در هر صورت واکنش های جانبی نامطلوب بین آب و ایزوسیانات رخ می دهد.با سرد کردن مخلوط خنثی تا زیر 5 درجه سانتی گراد واکنش های جانبی را به حداقل میزان خود می رسد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">پلی اورتان وپلی یوریا- تشابه و تفاوت:</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">شیمی پلی اورتان بر اساس واکنش گرمازا بین دی یا پلی ایزوسیانات و ترکیبات حاوی گروه پایانی هیدروکسیل، چون پلی اول ها، یا ترکیبات حاوی هیدروژن فعال چون آمین ها می باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این تفاوت ساختار، زمان واکنش بسیار سریع و متعاقبا زمان ژل شدن، خشک شدن سطحی و خشک شدن کامل سریع تر پلی یوریا نسبت به پلی اورتان را توجیه می نماید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">باندC-N در ساختار پلی یوریا از باندC-O در الاسترومر پلی اورتان قوی تر است. این خاصیت باعث خصول دوام حرارتی بهتر پلی یوریا نسبت به پلی اورتان می شود. در نتیجه سیستم پلی یوریای 100 درصد جامد دوام حرارتی و خواص ضد شوره بهتری را در برابر الاسترومر پلی اورتان بروز می دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">پوشش های الاسترومر پلی یوریایی 100 در صد جامد، شامل ساختار بلوکی نرم و&nbsp; سخت است. جزء دی ایزوسیانات به عنوان hard block و پلی اترآمین به عنوان soft block عمل می نماید. خصوصا آمین ها به طور اعم از ستون فقرات پلی اکسی پروپیلن نرم و انعطاف پذیر برخوردارند که بر خلاف پلی اورتان منجر به حصول ماهیت هیدروفوبیک/ ضد آب پلی یوریا می گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">پوشش پلی یوریا نسبت به رطوبت حساس نبوده و عیوب مرتبط با رطوبت چون ایجاد حباب، کف و تورم را بروز نمی دهد.عدم وجود کاتالیست جهت سخت شدن و طبیعت اتوکاتالیست پلی یوریا، باعث تامین خواص عالی در معرض نور uv و یا دماهای بالا می شود. چرا که وجود کاتالیست در سیستم، تخریب و افت خواص پلیمر را در شرایط مزبور افزایش می دهد.حفظ خواص فیزیکی پلی یوریای آلیفاتیک در شرایط مختلف جوی، بهتر از پلی اورتان آلیفاتیک است که حاوی کاتالیست می باشد.اگر چه در سیستم های الاسترومر پلی یوریای آروماتیک تمایل به زردگرایی پلی اتر آمین و سایر واکنش گرهای آمینی، کمی بیشتر از پلی اورتان های بر پایه هیدروکسیل پلی اول می باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در دنیای امروزی پلی یوریا اثبات کرده است که انتخابی مؤثر کارا و اقتصادی در صنعت پوشش های محافظتی و ضد خوردگی و صنایع مرتبط به حساب می آیند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تولید محصولاتی با خواص بهبود یافته و پیشرفته ترین تجهیزات و پاشش جهت حصول بهترین کیفیت و تامین خواسته مصرف کنندگان، هر روز بر محبوبیت این پوشش در صنایع جهان می افزاید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</p>','/app/articles/1545650485595.jpeg','/app/articles/1545650485227.jpeg','پلی اورتان,ایزوسیانات,آمازون تله,فروش مواد شیمیایی,فروش انلاین','پلی-اورتان-ها-و-کاربرد-آن-ها',1436,3,1,'2018-12-24 14:51:25','2022-01-11 20:48:22'),(43,4,'اصول و مقررات ايمني در صنايع رنگ و رزين','صنايع توليدكننده رنگ و پوشش ساخت رزينهاي مورد مصرف در رنگسازي و بخش‌هاي رنگ‌آميزي قطعات فلزي و چوبي در سالهاي اخير در جهان پيشرفت قابل توجهي داشته اند','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:22px\"><span style=\"color:#0000FF\"><span style=\"font-family:comic sans ms,cursive\">اصول و مقررات ايمني در صنايع رنگ و رزين</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">صنايع توليدكننده رنگ و پوشش ساخت رزينهاي مورد مصرف در رنگسازي و بخش&zwnj;هاي رنگ&zwnj;آميزي قطعات فلزي و چوبي در سالهاي اخير در جهان پيشرفت قابل توجهي داشته اند و تنوع مواد اوليه و تعدد فرايندهاي توليد و روشهاي اجرائي رنگ&zwnj;آميزي، باعث توليد فراورده&zwnj;هاي متنوعي در اين بخش از صنعت شده است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">امروزه صنعتگراني كه در اين رشته فعاليت دارند، اضافه بر جلب رضايت مشترشي و ارتقاء كيفي محصولات خود، حفظ ايمني و سلامتي و عدم آلوده&zwnj;سازي محيط زيست را نيز در برنامه كار خود قرار داده&zwnj;اند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به جرات مي&zwnj;توان گفت كه اكثر مواد اوليه توليد رنگ شامل رزينها، افزودني&zwnj;ها و حلالها كم و بيش خطرساز هستند. اين خطرات بيولوژيكي، شيميايي و فيزيكي است و ممكن است همراه با آتش&zwnj;سوزي و يا انفجار نيز باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در اين مقاله به بررسي خطرات ناشي از مواد و محصولات صنايع رنگ و رزين پرداخته و ضمن مطالعه حدود و مقررات بين&zwnj;المللي، ضوابط بسته&zwnj;بندي، حمل و نقل و نصب برچسب روي ظروف حاوي اين مواد، نيز مورد بررسي قرار مي&zwnj;گيرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><strong><span style=\"font-family:comic sans ms,cursive\">خطرات</span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">خطرات موجود در صنايع رنگ و رزين به دو گروه اصلي تقسيم مي&zwnj;شود :</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">الف- خطرات شيمي فيزيكي مواد</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ب- تاثير مواد بر سلامتي</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">خطرات شيمي فيزيكي</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">خطرات شيمي فيزيكي ماده شامل قابليت اشتعال، انفجار و اكسيدكنندگي اين مواد است كه مي&zwnj;تواند باعث بروز صدمات و خسارات جاني و مالي جبران&zwnj;ناپذير گردد. اثرات سوء مواد شيميايي بر سلامتي انسان، در صورت تماس مستقيم، استنشاق و يا بلعيدن اين مواد ايجاد مي&zwnj;گردد و مي&zwnj;تواند باعث مرگ، بروز سرطان، مسموميت شديد، حساسيت و يا در طولاني مدت باعث ايجاد دغدغه در بدن گردد. يكي از راههاي آشنائي افراد با خطرات مواد شيميايي استفاده از برگه&zwnj;هاي اطلاعات ايمني [Safety Data Sheet (SDS)] مي&zwnj;باشد كه در كليه بخشهاي ذخيره&zwnj;سازي و انبار، بخش توليد، آزمايشگاه و نيز در حين حمل و نقل بايد در دسترس بوده و مورد توجه قرار گيرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">قابليت اشتعال مواد در صنايع رنگ و رزين</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بسياري از حلالها، رزينها و افزودني&zwnj;ها و همچنين محصولات صنايع رنگ و رزين، چنانچه به طور صحيح حمل و يا ذخيره نشوند، امكان بروز آتش&zwnj;سوزي را به شدت افزايش مي&zwnj;دهند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">از اين گروه، حلالها نسبت به ساير مواد خطر بيشتري دارند. خطر اصلي حلالها قابليت اشتعال آنهاست، اگرچه برخي از آنها سمي نيز هستند. اكثر حلالها و برخي از رزينها در زمره مواد با قابليت اشتعال بالا دسته&zwnj;بندي مي&zwnj;گردند كه در اثر جرقه و يا هواي داغ باعث بروز آتش&zwnj;سوزي مي&zwnj;گردند. قابليت اشتعال حلالها با نقطه اشتعال (Flash Point) آنها مشخص مي&zwnj;گردد. نقطه اشتعال حداقل دمائي است كه در آن بخشي از حلال تبخير شده و بر روي سطح مايع محيط اشتغال&zwnj;زا ايجاد مي&zwnj;&zwnj;كند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حلالها بر اساس نقطه اشتعال داراي دو حد زير هستند :</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">حد پايين اشتعال (Lower Flammable Limit)(LFL)</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">معادل با درصدي از حجم يك ماده است كه با يك حجم خوا مخلوط شده و اين مخلوط ضعيف&zwnj;تر از آن باشد كه مشتعل شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><strong><span style=\"font-family:comic sans ms,cursive\">حدبالاي اشتعال (Upper Flammable Limit)(UFL)</span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">درصدي از حجم يك ماده است كه با يك حجم هوا مخلوط شده و مخلوط غني&zwnj;تر از آن است كه مشتعل شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">يكي ديگر از ويژگيهاي حلالها، دماي خود اشتعالي يا اشتعال خودبه&zwnj;خود (Autoignition Temp) است و آن حداقل دمائي است كه يك ماده تحت شرايط متفاوتي بصورت خودبه&zwnj;خود و بدون هيچ منبع حرارتي مشتعل مي&zwnj;شود. بايد توجه داشت كه بين نقطه اشتعال ماده و دماي اشتعال خودبه&zwnj;خود آن هيچ ارتباطي وجود ندارد، به عنوان مثال استن داراي نقطه اشتعال پايين ولي دماي خوداشتعالي بسيار بالايي است و برعكس آن حلال وايت&zwnj;اسپريت است نقطه اشتعال بالاتر از استن داشته ولي حدود 300 درجه سانتيگراد نقطه خوداشتعالي آن پايين&zwnj;تر است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ويژگي ديگر حلالها كه در توليد و حمل مشكل&zwnj;آفرين است، قابليت توليد و هدايت الكتريسيته ساكن است. حتي حلالهايي مانند تولوئن و زايلن با قابليت هدايت الكتريكي كم، در حين حمل الكتريسيته ذخيره مي&zwnj;نمايند و اين ذخيره در دستگاههاي توليد مانند مخلوط&zwnj;كن، فيلتر، لوله&zwnj;ها و پمپ&zwnj;ها و دستگاه هاي پاشش تاثير نامطلوب مي&zwnj;گذارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">براي جلوگيري از ذخيره الكتريسيته ساكن در حلالها، ساده&zwnj;ترين روش استفاده از سيم اتصال به زمين در مخازن و تانكرهاي حمل و ذخيره&zwnj;سازي آنهاست.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به&zwnj;جز حلالها، برخي ديگر از مواد اوليه مصرفي در صنايع رنگ و رزين نيز آتشگير هستند. به ويژه موادي كه در ساخت رزينها مصرف مي&zwnj;شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">لازم به ذكر است كه مواد پودري نيز در حين حمل الكتريسيته ساكن ذخيره مي&zwnj;كنند و لذا غبار برخي از آنها در مجاورت اكسيژن هوا قابليت انفجار دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">قابليت انفجار و اكسيدكنندگي مواد </span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">همانگونه كه گفته شد خطرات شيميايي فيزيكي مواد شامل قابليت اشتعال انفجار و اكسيدكنندگي آنهاست.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">گروهي از مواد اوليه مصرفي در ساخت رزينها داراي خواص اكسيداسيون و انفجاري هستند، اين مواد مي&zwnj;توانند به صورت جامد ، مايع يا خميري&zwnj;شكل باشند و در واكنشي گرمازا توليد گاز كرده و اين گاز در گرما منفجر شده و يا توليد شعله مي&zwnj;نمايد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">پراكسيدهاي آلي، آغازگرها و مواد توليدكننده راديكال آزاد كه در فرايند توليد رزين اكريليك و رزين پلي استر غيراشباع مصرف مي&zwnj;شود مانند دي &zwnj;&zwnj;بنزيل &zwnj;پراكسيد و سيكلو هگزانون &zwnj;پراكسيد از اين گروه هستند كه پتانسيل منفجرشدن دارند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به همين دليل، اين مواد در زمان بسته&zwnj;بندي و عرضه با پلاستي&zwnj;سايزرها مخلوط شده تا احتمال خطر انفجار و آتش&zwnj;سوزي آن به شدت كاهش يابد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">تاثير مواد بر سلامتي</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اگرچه خطر آتش&zwnj;سوزي و انفجار، يك خطر جدي در محيط كارخانه است ولي اثرات سوء كه مواد شيميايي براي سلامتي افراد ايجاد مي&zwnj;كنند را نبايد ناديده گرفت. مواد شيميايي را مي&zwnj;توان از نظر تاثير بر سلامتي انسان به سه گروه تقسيم نمود :</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مواد بسيار سمي&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Very Toxic</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مواد سمي&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Toxic</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مواد مضر&nbsp; Harmful</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">واژه بسيار سمي به موادي اطلاق مي&zwnj;گردد كه موجب مرگ و يا آسيب مزمن در انسان مي&zwnj;گردد و به همين ترتيب مواد مضر اثر كمتري نسبت به بسيار سمي دارند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اثرات سوء مواد فوق بوسيله استنشاق، بلعيدن و تماس با پوست و چشم ايجاد مي&zwnj;گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در صنايع رنگ، در طي عمليات ساخت رنگ، رنگ&zwnj;آميزي و يا پخت رنگ، افراد در معرض بخارات، غبار، ذرات جامد پودر و الياف موجود در فضاي واحد قرار مي&zwnj;گيرند كه بر سلامتي آنها اثر مخرب دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اين غبارات از طريق تنفس و جذب پوست و چشم وارد بدن شده و چنانچه از تراكم اين مواد در محيط كار جلوگيري نشود در كوتاه&zwnj;مدت و يا بلندمدت باعث بيماري مي&zwnj;گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">براي جلوگيري از آلودگي محيط كار در واحدهاي رنگ و رزين ضروري است كه با &laquo;حد آستانه&raquo; هريك از اين مواد آشنا باشيم تا بتوانيم مقدار آن را در محيط كار در حد مناسب و غيرمضر كنترل كنيم.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">معيارهاي حد آستانه مواد در اين مورد راهنماي خوبي است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">معيارهاي &laquo;حد آستانه&raquo;</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">معيارهاي حد آستانه مقداري از مواد را نشان مي&zwnj;دهد كه وجود بيشتر آن در هوا و آب و در تماس با انسان خطرناك است. از معيارهاي معتبر مي&zwnj;توان انواع زير را نام برد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">حد آستانه ترشولد : (Threshold Limit Value)</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اين معيار آمريكائي در اكثر كشورهاي جهان معتبر است. در اين استاندارد دو زير گروه A2,A1 سرطان&zwnj;زا بودن و مشكوك به سرطان&zwnj;زا بودن مواد را نشان مي&zwnj;دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:20px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">حد آستانه ماك : (MAK Limit Value)</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اين معيار آلماني شامل چندين زير گروه است كه مواد سرطان&zwnj;زا، توليدكننده تومورهاي مشكوك به سرطان&zwnj;زائي و &hellip; را شامل مي&zwnj;گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><strong><span style=\"font-family:comic sans ms,cursive\">حد آستانه OELS : (Occupational Exposure Limits)</span></strong></span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اين معيار انگليسي شامل سه بخش استاندارد تماس شغلي (OES) و ماکزيمم حد تماس (MEL) و متوسط زمان (TWA) مواد خطرساز مي&zwnj;باشد و حدمجاز تماس انسان با مواد شيميايي را مشخص مي&zwnj;كند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اين حد آستانه و يا حد تماس مواد با انسان، با دو معيار حجمي و وزني اندازه&zwnj;گيري مي&zwnj;شوند :</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">قسمت حجم ماده در ميليون قسمت حجم هوا : ppm</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ميلي&zwnj;گرم ماده در متر مكعب حجم هوا : mg/m3</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به جز اين دو حد آستانه ، براي ذرات الياف در هوا معيار ديگري نيز هست و آن واحدي است كه ميزان الياف در ميلي ليتر هوا را نشان مي&zwnj;دهد : Fibre/ml</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">برگه اطلاعات ايمني Safety Data Sheet </span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اين برگه&zwnj;ها حاوي اطلاعاتي است كه براي كاركردن با مواد خطرناك و حمل و نقل و ذخيره آنها مورد نياز مي&zwnj;باشد. در صنعت رنگ و رزين تهيه برگه ايمني براي مواد اوليه، مواد حد واسط و محصول نهائي و نيز كمكهاي اوليه مورد نياز در زمان بروز حوادث ناشي از اين مواد ضروري است. در برگه اطلاعات ايمني مقادير و حدآستانه مواد بر اساس قوانين ملي هر كشور تعيين مي&zwnj;گردد و مطابق همين اطلاعات برچسب روي مواد و محصول بايد تنظيم شود. بر اساس تقسيم&zwnj;بندي بين&zwnj;المللي مواد خطرناك به چند گروه اصلي تقسيم مي&zwnj;گردند و براي نمايش هر گروه علامت خاصي نيز در نظر گرفته شده است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">عبارات ايمني و هشداردهنده&zwnj;اي كه در برگه&zwnj;هاي اطلاعات ايمني ذكر مي&zwnj;گردد همگي بايد بر اساس معيارهاي موجود بوده و مفهوم مشخصي داشته باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">يك برگه اطلاعات بايد داراي مشخصات زير در مورد هر ماده باشد :</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">نام محصول و شركت توليدكننده</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">نوع تركيبات و اجزاء سازنده</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">معرفي خطرات و مسموميتهاي ناشي از آن</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">كمكهاي اوليه موردنياز</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اطفاء حريق ويژه ماده و راههاي جلوگيري از حريق</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">معرفي حوادث اجتماعي مانند خطرات ناشي از جابجائي و نگهداري</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">خواص فيزيكي و شيميايي مانند رنگ و بو، pH ، نقطه&zwnj;جوش و نقطه ذوب، نقطه اشتعال، دماي خوداشتعالي، قابليت انفجار و اكسيدكنندگي، فشار بخار، انحلال در آب و &hellip;&hellip;..</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مراقبتهاي فردي در تماس با ماده</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">پايداري يا واكنش&zwnj;پذيري</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اطلاعات سم&zwnj;شناسي، زيست&zwnj;محيطي</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">نحوه معدوم&zwnj;كردن آن</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اطلاعات حمل و نقل</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">قوانين و مقررات ملي در مورد ماده</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تمام برگه&zwnj;هاي ايمني بايد داراي تاريخ تدوين و زمان بازبيني باشند كه فاصله اين دو معمولا يكسال مي&zwnj;باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">برچسبهاي ظروف حاوي مواد اوليه و محصول</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">نصب برچسب روي ظروف بسته&zwnj;بندي مواد شيميايي ضروري است و در بسته&zwnj;بندي مواد خطرناك برچسب&zwnj;&zwnj;&zwnj;زني از اهميت ويژه&zwnj;اي برخوردار است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اطلاعاتي كه بر روي برچسب مواد شيميايي بايد درج گردد شامل نام و آدرس و تلفن توليدكننده، نام تجاري محصول، تركيب خطرناك موجود در آن، نشانه خطر و عبارات هشدار دهنده خطر و حفظ ايمني و سلامتي است. اين اطلاعات ويژه مصرف&zwnj;كننده است ولي برچسبهائي براي حمل مواد بوسيله وسائل نقليه وجود دارد كه عبارات آن خاص حمل و نقل است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در مجموع بر روي برچسب ، عبارات استاندارد هشداردهنده، همراه با علائم مربوطه براي شناسائي مواد مضر، سمي و خطرناك بايد قيد گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">عبارات خاص برچسب محصولات رنگ و رزين</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بر اساس مقررات بين&zwnj;المللي اين عبارات بايد بر روي چسب محصولات رنگ و رزين قيد گردد :</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ و پوشش حاوي سرب</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">روي برچسب اين محصولات چنانچه حاوي بيش از 15% درصد وزني سرب در كل وزن رنگ باشد بايد عبارات زير قيد گردد:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&laquo; حاوي سرب است. در محلي كه احتمال تماس كودكان و حيوانات اهلي وجود دارد، مصرف نشود.&raquo;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اگر رنگ حاوي سرب در ظرف كوچك باشد (كمتر از 125 ميلي&zwnj;ليتر) ذكر عبارت &laquo;مراقب باشيد، حاوي سرب است&raquo; كفايت مي&zwnj;كند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگها و رزين حاوي ايزوسيانات</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بر روي برچسب بسته&zwnj;بندي رنگها و رزين&zwnj; حاوي ايزوسيانات (به صورت منومر، اوليگومر و پليمر و يا مخلوط آنها) بايد عبارات زير قيد گردد:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&laquo; محتوي ايزوسيانات است. به نكات ارائه شده بوسيله سازنده توجه گردد.&raquo;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ و رزين حاوي اپوكسي</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">چنانچه رنگ و پوشش حاوي رزين اپوكسي با متوسط وزن ملكولي 700 باشد، روي برچسب ظروف آن بايد عبارات زير ذكر شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&laquo; حاوي تركيبات اپوكسي است. به نكات ارائه شده توسط سازنده توجه گردد.&raquo;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برچسب ويژه حمل و نقل مواد Labelling For transport</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در حمل و نقل و جابجائي مواد شيميايي در بين كشورها مقررات دقيق بين&zwnj;المللي وجود دارد و بر آن اساس برچسب&zwnj;هاي ويژه حمل و نقل نيز بايد حاوي اطلاعات ايمني دقيقي باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">قوانين و مقررات بين&zwnj;المللي در مورد حمل و نقل عبارتند از :</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حمل و نقل جاده&zwnj;اي : قوانين انتقال مواد خطرناك در جاده : ADR</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حمل و نقل ريلي(قطار) : قوانين انتقال مواد خطرناك بوسيله قطار : RID</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حمل و نقل دريائي : قوانين انتقال مواد خطرناك در انتقال دريائي : IMDG</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">حمل و نقل هوائي : قوانين انتقال مواد خطرناك در انتقال هوائي : IATA</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">قوانين سازمان ملل در حمل و نقل خطرناك : UN orange book</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به عنوان مثال بر اساس مقررات سازمان ملل (UN) بايد طبقه&zwnj;بندي، شماره مربوطه به نوع خطر و گروه بسته&zwnj;بندي در برچسب حمل و نقل قيد گردد و چنانچه مواد بوسيله تانكر و يا فله حمل مي&zwnj;شود روي وسيله نقليه برچسب حمل و نقل نصب گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">روي برچسب حمل و نقل، نوع خطرات تحت عنوان كد خطر (Danger Code) و نشانه&zwnj;ها تحت عنوان علامت خطر&nbsp;&nbsp; (Danger sing)نام&zwnj;گذاري مي&zwnj;گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در حمل و نقل دريائي چنانچه نشت مواد در آب باعث آلودگي و مرگ ماهيها خواهد شد اضافه&zwnj;بر ،برچسب حمل و نقل برچسب &laquo;آلوده&zwnj;كننده دريا&raquo; هم اضافه گردد. به عبارت ديگر هر ماده&zwnj;أي كه حاوي 10% از مواد آلوده&zwnj;كننده درياها (بر اساس فهرست بين&zwnj;المللي) و يا 1% از مواد آلوده&zwnj;كننده شديد درياها باشد بايد در حمل آن برچسب &laquo;آلوده&zwnj;كننده&zwnj; دريا&raquo; نيز نصب گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">كنترل خطرات ناشي از مواد در واحدهاي رنگ و رزين</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">كارفرما بايد ابزار كنترل خطرات حاصل از مواد را در واحد پيش&zwnj;بيني نمايد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">قوانين و مقررات ايمني به زبان ساده و خلاصه در اختيار كاركنان قرار گيرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">كاركنان بايد از ضوابط و ابزار كنترل خطرات بادقت استفاده نمايند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">چهارچوبي براي جلوگيري از بروز حوادث تعيين گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">كارفرما بايد از سلامت دستگاههاي هشداردهنده خطر بوسيله آزمايش مستمر آن مطمئن باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">يخش كمكهاي اوليه واحد مجهز گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">كاركنان براي مواقع اضطراري و بروز حادثه آموزش ببينند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در انبار و محل ذخيره مواد و محصول برچسب&zwnj;هاي ويژه مواد سمي، مضر، خورنده، سوزش&zwnj;آور، قابل اشتعال و &hellip;. نصب گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بر روي ظروف حاوي مواد، برچسب نحوه مصرف با ذكر نكاتي در مورد كنترل خطرات در حين كار با مواد قيد گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در مواقع لزوم كاركنان از دستكش، ماسك و عينك ايمني و يا البسه محافظ استفاده نمايند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">مقررات كنترل آلودگي&zwnj;ها : IPC </span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">مقررات بين&zwnj;المللي كنترل آلودگي&zwnj;ها (Integrated Pollution Control) به اختصار IPC ناميده مي&zwnj;شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اين مقررات اصول كنترل آلودگي وارده از يك منبع آلوده&zwnj;كننده را به هوا، آب و خاك، نشان مي&zwnj;دهد. واحدهاي توليدكننده رنگ و رزين نيز در سطح بين&zwnj;المللي ملزم به رعايت قوانين IPC هستند از آن جهت كه مواد اوليه و محصولات اين صنعت در صورت عدم رعايت اصول ايمني، مي&zwnj;تواند به عوامل زيستي صدمه برساند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">صنايع توليدكننده رزين به واسطه مصرف منومرها و مواد حد واسط سمي و خطرناك در زمره واحدهائي است كه در فهرست IPC رتبه اول را به لحاظ خطر دارند. يكي از معيارهاي قوانين IPC حد آستانه ترشولد Thershold Limit Valueاست. اين معيار كه بيشتر در مورد حلالها بايد رعايت گردد، تاكيد دارد دستگاههاي توليدي كه مصرف حلال آنها بيشتر از 150 كيلوگرم در ساعت مي&zwnj;باشد حتما بايد سرپوشيده باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">آلودگي&zwnj;هاي محيط زيست فقط محدود به آب و خاك و هوا نيست و مقررات IPC در ورود آلودگي&zwnj;هاي ارتعاش، صدا، حرارت و انرژي نيز به محيط زيست مقررات و ضوابطي دارد</span></span></p>','/app/articles/1545719666979.jpg','/app/articles/1545719667764.jpg','Amazon MAG,اصول و مقررات ایمنی,خطرات موجود در صنایع رنگ ورزین,آمازون تله,فروش مواد شیمیایی,فروش انلاین','اصول-و-مقررات-ايمني-در-صنايع-رنگ-و-رزين',679,2,1,'2018-12-25 10:04:27','2022-01-11 19:21:30'),(44,3,'روان شناسی رنگ ها',' قرمز: رنگ انرژی و ماجراجویی است','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"color:#0000FF\"><strong><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">روانشناسی&nbsp;رنگ ها</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#FF0000\">قرمز</span></strong>:&nbsp;رنگ انرژی و ماجراجویی است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است در اتاق پذیرایی از رنگ قرمز استفاده شود چون شما را اجتماعی تر می کند و همچنین اشتهای شما را تحریک می کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#ff66ff\">صورتی</span></strong>:&nbsp;رنگ عشق است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است در اتاق خواب از این رنگ به کار رود.در آن صورت اتاقی راحت و آرام بخش خواهید داشت.همچنین صورتی پررنگ علاقه و اشتیاق را در شما ایجاد می کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#ff3300\">نارنجی</span></strong>:&nbsp;اطمینان و حرارت است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است برای اتاق نشیمن و پذیرایی از این رنگ استفاده شود.اگر در اتاق خواب به کار رود باعث کم خوابی شده و اتاق را کوچک نشان می دهد.با این وجود اگر می خواهید از این رنگ در اتاق خواب استفاده کنید باید از وجود نور زیاد در اتاق اطمینان حاصل کنید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#008000\">سبز</span></strong>:&nbsp;رنگ طبیعت و انرژی ،امنیت و امیدواری است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است در اتاق خواب و نشیمن از رنگ سبز استفاده شود .دفعات مکرر استفاده از این رنگ شما را خسته می کند.پس بهتر است برای شدیدتر شدن اثر آن در کنار سبز،از رنگ قرمز یا نارنجی استفاده کنید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#0066ff\">آبی</span></strong>:&nbsp;رنگ آرام بخش ، وفاداری و قدرت است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است برای اتاق خواب و دیوارهای حمام از این رنگ استفاده شود. آبی رنگ سردی است که برای از بین بردن سردی آن باید از یک رنگ گرم استفاده شود.ترکیب آن با قرمز و زرد بسیار زیبا می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"font-size:20px\"><span style=\"color:#ffcc00\"><strong>زرد</strong></span></span>:&nbsp;رنگ خورشید و انرژی ،شگفتی و پادشاهی است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است برای آشپزخانه&nbsp; و اتاق پذیرایی و اتاق های شمالی به کار رود. این رنگ برای اتاق خواب مناسب نیست،اگر شما احساس پریشانی می کنید،رنگ زرد حال شما را بدتر می کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#9900cc\">بنفش</span></strong>:&nbsp;رنگ روحانی، رنگ آخرت و رنگ مونث است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است برای اتاق خواب و دیوارهای حمام به کار رود.بنفش رنگی بی روح است که با نقره ای و سیاه زنده می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#0066ff\">ارغوانی</span></strong>:&nbsp;رنگ خلاقیت است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">بهتر است برای اتاق خواب به کار رود</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong><span style=\"color:#996600\">قهوه ای</span></strong>:&nbsp;رنگ امنیت و استواری است</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این رنگ برای اتاق پذیرایی مناسب است،البته باید از یک رنگ زنده تر مانند سبز یا آبی همراه این رنگ استفاده کرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><strong>سیاه</strong>:&nbsp;رنگ مرگ،غرابت و رنگی غم انگیز</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ سیاه برای اعتدال به کار می رود و به عنوان رنگ پایه شناخته شده است.بهتر است فقط یک دیوار خانه را به این رنگ در آورید.</span></span></p>','/app/articles/1545720039217.png','/app/articles/1545720039124.png','روانشناسی,روانشناسی رنگ,رنگ,پیگمنت,فروش مواد شیمیایی,آمازون تله,فروش انلاین','روان-شناسی-رنگ-ها',499,3,1,'2018-12-25 10:10:39','2022-01-10 14:14:49'),(45,3,'کاربرد فناوری نانو در صنعت رنگ','فناوری نانو با ساختارهای مختلف ماده که دارای ابعادی از مرتبه ی یک میلیاردم متر9-10  هستند سروکار دارد.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">کاربرد فناوری نانو در صنعت رنگ</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">فناوری نانو با ساختارهای مختلف ماده که دارای ابعادی از مرتبه ی یک میلیاردم متر9-10&nbsp; هستند سروکار دارد. این فناوری توانمندی تولید مواد، ابزار و سیستم های جدید با کنترل سطوح مولکولی و اتمی برای استفاده از خواصی است که در آن سطوح ظاهر می شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">استفاده از فناوری نانو در رنگ باعث ایجاد خواص جدید در رنگ، افزایش کیفیت رنگ و کاهش مصرف آن می گردد. کاربرد فناوری نانو در صنایع رنگ و پوشش در بخش مواد اولیه بیشتر شامل رنگدانه هاست. در بحث رنگدانه ها اندازه ذرات اهمیت بسزایی دارد و با پیش رفتن به سمت مقیاس نانو و افزایش سطح فعال نانو ذرات (به دلیل دارا بودن تعداد بسیار زیاد اتم در سطح)</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">خواص متفاوت و جدیدی مانند ضدسایش، آنتی باکتریال، خودتمیزشونده، ضدخش، ضدسایش و خواص حفاظت الکترومغناطیس در رنگ ایجاد می شود. بنابراین رنگ های نانو با بهره گیری از نانو ذرات فعال و گروه های عاملی مناسب در ساختار خود، قادرند تا در مقابل محرک های محیطی عکس العمل های هوشمندانه محافظتی از خود نشان می دهند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">امروزه فناوری نانو به یکی از بهترین شاخه های پیشرفت علم در بسیاری از زمینه های علوم و مهندسی از جمله درمان، بهداشت و تشخیص پزشکی، الکترونیک، ارتباطات، انرژی های نو، محیط زیست، حمل و نقل، صنایع هوانوردی و صنعت ساخت وساز تبدیل شده است به طور کلی در تمام صنایع و درهر بخشی که بهبود خواص مواد و ابزار مورد استفاده دارای اهمیت است، فناوری نانو راه حل هایی برای ارائه دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اثرات تحول آفرین و باورنکردنی این علم و فناوری در روند تحقیق و توسعه باعث گردیده که نظر تمامی کشورهای بزرگ به این موضوع جلب گردد و فناوری نانو را به عنوان یکی از مهمترین اولویت های تحقیقاتی خویش طی دهه ی اول قرن 21 محسوب نمایند. توسعه ی رنگ های پیشرفته مبتنی&nbsp; بر فناوری نانو در سال های اخیر دریچه های جدیدی را به روی متقاضی رنگ های پیشرفته گشوده است.برخی از محصولات متنوع در این زمینه عبارتند از:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ ترافیکی نانو</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ خودتمیز شونده</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ عایق حرارتی نانو</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ ترموپلاست بر پایه رزین اکریلیک نانو کامپوزیت</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">رنگ ترک تزئینی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اورکا نانوپینت</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">استفاده از نانو تکنولوژی در صنعت رنگ باعث افزایش کیفیت رنگ وکاهش مصرف آن می گردد. نانو تکنولوژی به دو صورت به این بخش کمک می کند، یکی در انتخاب مواد مناسب در رنگ و دیگری در روش های بهینه رنگ کردن. نانو ذرات با اندازه های مختلف، نورهایی با فرکانس های متفاوت ساطع می کند که می تواند برای تولید رنگ های گوناگون مورد استفاده واقع شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">امروزه با گسترش تکنولوژی نانو، رنگ های پایه آبی نیز از این امر متأثر گشته اند، مزایای عالی این نوع رنگ ها با اعمال این تکنولوژی دو چندان شده است. این رنگ ها از رزین های دیسپرس شونده در آب با ابعاد نانو و نیز از نانو پیگمنت ها و افزودنی هایی در اندازه ی نانو استفاده می شوند که باعث کیفیت بهتر رنگ های معمولی پایه آبی گردیده است از جمله ویژگی های این محصولات می توان به موارد ذیل اشاره کرد:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">دارای خواص مکانیکی ویژه ای هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">دارای خواص ضد خوردگی ویژه ای هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">استفاده از نانو پیگمنت ها باعث افزایش نفوذ این پوشش ها به درون شکاف ها و منافذ بسیار ریز موجود درسطح فلز می گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">با استفاده از رنگهای نانو چسبندگی روی سطح هفتاد مرتبه بیشتر می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ضخامت اعمال پوشش نانو فقط 30 میکرون می باشد که در مقایسه با ضخامت رنگهای معمولی بسیار پایین می باشد و موجب صرفه جویی در مصرف رنگ می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">به دلیل پایین بودن درصد حلال های فرار با محیط زیست سازگارند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">از لحاظ ظاهری فیلم حاصله بسیار صاف و براق است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">فناوری نانو یکی از بزرگترین فناوری های نوین در قرن حاضر است. که استفاده از آن در راستای برطرف نمودن نیازهای صنایع می تواند راهگشا باشد. همگام با توسعه فناوری نانو در صنایع مختلف، توجه به کاربردهای این علم، در صنعت رنگ و پوشش منجر به پیشرفت هایی در این زمینه گردیده است. رنگ ها و پوشش های ضد آب نانویی، نمونه ای از کاربرد این فناوری در صنعت رنگ است که در چند سال اخیر مورد استقبال و توجه بسیاری از شرکت ها قرار گرفته اند و فرصت های جدیدی را در بازارهای جهانی ایجاد کرده اند.</span></span></p>','/app/articles/1545724059851.jpg','/app/articles/1545724059854.jpg','رنگ,نانو,پیگمنت,نانو رنگ,رنگ ضد خش,فروش مواد شیمیایی,آمازون تله, فروش انلاین','کاربرد-فناوری-نانو-در-صنعت-رنگ',1486,2,1,'2018-12-25 11:17:39','2022-01-11 08:35:44'),(46,1,'حلال ها و نقش آنها در صنعت رنگ','نقش حلالها که مایعات فراری میباشند در سهولت کار و استفاده از رزینها و رنگهای حاصل از آنان بر همگان روشن است','<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">نقش حلالها که مایعات فراری میباشند در سهولت کار و استفاده از رزینها و رنگهای حاصل از آنان بر همگان روشن است زیرا که استفاده از رزینهای صددرصد غیر فرار در هنگام مصرف: کاری بسیار مشکل بوده و شکی نیست که جهت جاری ساختن و امکان برداشت مقدار مورد نیاز از مخازن نقل و انتقال آنان از قبیل بشکه، تانکر و غیره نیاز به حرارت داشته که این خود مستلزم وقت و هزینه سنگینی است . لذا از همین روست که آنان را به کمک حلالها از صددرصد به ۳۰ الی ۸۰ درصد غیر فرار تبدیل می نمایند تا بدین ترتیب حلال اضافی نه تنها رزین یا رنگ مورد نظر را در خود حل نماید و بلکه همچنین وسیکوزیته را کاهش و در نتیجه قدرت جاری شدن را نیز افزایش و کار با آن را بسیار ساده تر نمایند. کاربرد حلال و کاهش درصد غیر فرار در صنایع رنگسازی بسیار مهمتر از دیگر صنایع بوده زیرا که برس زدن، اسپری کردن، تشکیل فیلم یکنواخت، براقیت، زمان خشک شدن و سخت شدن همگی تابع درصد غیر فرار رنگ مورد نظر بوده و این حلال است که با قدرت انحلال کنندگی خود رنگ را به درصد مورد نیاز، دلخواه و قابل مصرف میرساند. انتخاب درست یک حلال از عوامل مهم بوده و بر خواص ویسکوزیته، برس خوری، زمان خشک شدن و غیره اثر مستقیم داشته و از اثرات جانبی آن نیز میتوان بلیدینگ، جوش زدن، فلوئینیگ ضعیف و امثالهم را نام برد. یک حلال در پایان عمل در فیلم یک رنگ باقی نمیماند اما اثرات کارهائی که انجام میدهد باقی میمانند.</span></p>\r\n\r\n<p style=\"direction: rtl;\">&nbsp;</p>\r\n\r\n<div style=\"direction: rtl; text-align: justify;\">&nbsp;</div>\r\n\r\n<div style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">حلال باید دارای خصوصیات مورد انتظار باشد بطوری&shy;که قابلیت حل کردن رزین را دارا بوده و ویسکوزیته رنگ را به مقدار بهینه جهت کاربری کاهش دهد. انتخاب درست حلال بر پارامترهای کیفی ویسکوزیته، خاصیت برس&shy;خوری، سرعت خشک شدن و چند خاصیت پنهانی دیگر اثر می&shy;گذارد. مهمترین خواص حلال های مصرفی در صنعت رنگسازی عبارتند از:</span></div>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">&nbsp;قدرت حلالیت، سرعت تبخیر، نقطه جوش، طیف تقطیر، نقطه اشتعال، دانسیته، سمیت، درصد آب، قدرت اسیدی و یا قلیایی.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">حلال&shy;ها با توجه به پایه ساخت آنها به گروه های زیر تقسیم می شوند که هر کدام دارای خصوصیات متفاوتی می باشند.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">الف) حلال &shy;های الکلی&nbsp; متانول، اتانول، ایزو پروپیل الکل و...</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ب) حلال &shy;های کتونی ( استون، متیل اتیل کتون، متیل ایزو بوتیل کتون و&hellip;&nbsp;</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ج) حلال &shy;های اتری ( دی اتیل اتر، دی ایزوپروپیل اتر و&hellip; )</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">د) حلال های استری ( متیل استات، اتیل استات، نرمال بوتیل استات و&hellip;)</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ه) حلال های ترپنی ( روغن کاج، دی پنتن و&hellip; از قدیمی&zwnj;ترین گونه حلال&zwnj;ها می&zwnj;باشد که از درختان کاج و صنوبر به دست می آیدو در گذشته مصرف بسیار زیادی در ساخت رنگ&zwnj;های ساختمانی، ورنی&zwnj;ها و رنگ&zwnj;های هنری داشته&zwnj;اند.)</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">و) حلال های هیدروکربنی آروماتیک ( بنزن، تولوئن و&hellip;)</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">&nbsp;ز) حلال های هیدروکربنی الیفاتیک (وایت اسپریت، نفت و &hellip;)</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ح) حلال های هیدروکربنی کلره (متیلن کلراید، تری کلرواتیلن و &hellip;)</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\">&nbsp;</p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">۱) نیتروپارافینها</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">از این حلالها میتوان جهت انحلال پذیری رزینهای وینیلی، آکرلیکی، اپوکسی، نیتروسلولزی، استات سلولز، بیوتایرات، روغنها، چربیها، واکسها و دایها استفاده نمود. نیتروپارافینها در چهار نوع تجارتی در دسترس بوده که نوع ۲- نیتروپرویان با درجه تبخیری برابر با نرمال بیوتیل استات و سمیت کمتر مصرف بیشتری در صنایع رنگسازی دارد. علاوه بر این از نیتروپریان بعلت حلالیت قوی و بوی کم میتوان در رزینهای وینیلی بجای کیتونها در مواقع ایکه بو مسئله مهمی باشد استفاده نمود. حلالهای نیتروپارافینی گرانقیمت و اندکی نیز سمی هستند.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">&nbsp;۲) آب</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">امروزه استفاده از آب چه بصورت تنها یا مخلوطی از الکل و اترالکلها بعنوان یک حلال بدلایل بهداشتی و عدم خطر آتش سوزی و سمی نبودن مصرف فراوانی پیدا کرده خصوصاً جهت انحلال رنگهای پلاستیکی، رزینهای محلول در آب و رزینهای امولسیونی و کلوئیدی؛ بنابراین از مهمترین دلائلی که امروزه آب را بعنوان یک جانشین خوب برای حلالهای آلی توصیه مینمایند میتوان فراوانی، ارزانی، بی بوئی، غیر سمی و اشتعال ناپذیر بودن آنرا نام برد. البته آب یک حلال ایده آلی نمیباشد زیرا که با تمامی دیگر حلالهای آلی امتزاج پذیر نبوده و فیلم حاصل از رنگ محلول در آب براقیت عالی ای نداشته و همیشه نسبت به آب نیز حساس میباشد.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">▪ رزینهای سلولزی</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">۱) رزینهای نیترو سلولزی:</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">پلی مرهای سلولزی که در رنگهای فوری یا لاکها، پلاستیک، مواد منفجره، فیلم عکاسی، الیاف مصنوعی، هواپیما، شیشه اتومبیل و چسب بکار میروند اصولا از نوع استر یا اتر سلولزی بوده که استرها از قبیل نیترو سلولزو استات سلولز واترها از قبیل اتیل سلولز، بنزیل سلولز و غیره می باشند. لازم به توضیح است که رزین نیترو سلولز در حقیقت نیترات سلولز می باشد که امروزه به غلط و برحسب عادت به همان نیتروسلولز معروف است. پلی مرهای نیترو سلولزی بعلت داشتن خواص ویژه از قبیل سریع خشک بودن، مقاومت خوب فیلم حاصل و سختی مناسب مصرف فراوانی در صنایع رنگ سازی دارند هرچند که انعطاف پذیری و چسبندگی آنان در مقایسه با دیگر رزینها نسبتاً خوب نمی باشد. هرچه وزن مولکولی رزینهای نیترو سلولزی افزایش یابد قدرت فیلم حاصل نیز افزایش و بعکس انحلال پذیری کاهش می یابد و لذا از آنجائیکه وزن مولکولی پلی مرهای سلولزی بالاست چسبندگی آنان بر روی سطوح کم بوده و از اینرو جهت افزایش چسبندگی آنان معمولا از پلاستی سایزرهای رزینی با روغنهای خشک نشونده و یا پلاستی سایزرهای شیمیائی استفاده می نمایند. البته ناگفته نماند که نقش پلاستی سایزرها علاوه بر افزایش چسبندگی و براقیت بیشتر، ایجاد یک محلول قابل اسپری نیز می باشد.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">رزین نیترو سلولز مصرفی در صنایع رنگسازی که شامل عوامل نیترات می باشد و نه نیترو در اصل همان نیترات سلولز می باشد که به غلط به نیترو سلولز مشهور است و از واکنش سلولز خالص با اسید نیتریک در حضور اسید سولفوریک تهیه میگردد که حضور اسید بدان خاطر است که بتواند آب حاصل از واکنش را از محیط خارج تا عمل نیتراسیون بدلخواه صورت پذیرد.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">مکانیزم عمل بدین صورت است که اسید نیتریک با عمل ئیدرو گسیل موجود بر مولکول سلولز واکنش نموده و تشکیل یک استر را می دهد. در صنعت، نیترات سلولز را میتوان با درصد نیتروژنهای متفاوت از قبیل ۵/۱۰ تا ۸/۱۳ درصد تولید نمود و نوعیکه در صنایع رنگسازی مصرف بیشتری دارد نوع با حدود ۷/۱۰ الی ۲/۱۲ درصد نیتروژن می باشد.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">در صنعت رزینهای نیترو سلولزی در سه نوع استاندارد RS، AS، SS و در انواع ویسکوزیته یافت میشوند که در صنایع رنگسازی از نوع RS بیشتر از دو نوع دیگر استفاده میگردد و هر سه نوع دارای حدود % ۳ الکل اتانل، ایزوپروپانل و یا نرمال بیوتانل می باشند. با توجه به اینکه حدود % ۳ الکل (الکل اتیلیک) همراه رزینهای نیترو سلولزی می باشد اما از آنجائیکه جامد و پودری می باشند ظاهراً % ۱۰۰ بنظر می آیند. بنابراین بایستی توجه داشت که رزینهای نیترو سلولزی موجود در بازار % ۱۰۰ جامد نمی باشند و لذا می بایستی این مهم را در هنگام فرمولیزاسیون مد نظر داشت.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">&nbsp;ـ حلالهای مصرفی در رنگهای نیتروسلولزی</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">از آنجائیکه مکانیزم سخت شوندگی فیلم حاصل از رنگهای نیتروسلولزی بر اثر تبخیر حلال می باشد لذا یکی از پارامترهای مهم در ارائه فرمول یک رنگ یا کلر فوری همانا انتخاب و تعیین دقیق حلالهای مصرفی می باشد که نیاز به شناخت و تجربه کافی فرمولیست در این زمینه دارد. حلالها اثرات زیادی در یکنواخت شدن فیلم و کیفیت نهائی آن داشته و معمولا یک حلال فوری به خاطر تکنیک پیچیده و قیمت از سه نوع حلال اصلی، کمکی و رقیق کننده تشکیل میشود که حلال رقیق کننده نه تنها باعث کاهش قیمت نهائی میگردد و بلکه انحلال پذیری بهتری نیز به نیتروسلولز در حلال اصلی خود میبخشد. حلالیت نیترو سلولز نسبت عکس با مقدار ازت موجود در آن دارد بطوریکه هرچه مقدار ازت بیشتر باشد حلالیت آن در حلالهای معمولی تجارتی کمتر است.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">۱) حلالهای اصلی یا فعال</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ـ استرها (اتیل استات، بوتیل استات و &hellip;)</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ـ کیتونها (استن، متیل اتیل کیتون و متیل ایزو بوتیل کیتون)</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">نیترو سلولز نه تنها در استرها و بلکهدر کیتونها نیز به خوبی حل می گردد. کیتونها معمولا با قدرت حل کنندگی زیاد ارزانقیمت تر بوده و از طرفی نسبت رقیق شوندگی شان نیز با حلالهای غیر واقعی بطور قابل ملاحظه ای بالاست بطوریکه اگر محلولهائی با دیسکوزیته مساوی از کیتونها و استرها تهیه شوند محلول حاصل از کیتونها قابلیت بیشتری در ایجاد فیلم خواهد داشت. کیتونها براحتی در تهیه محلول نیترو سلولزی با درصد جامد زیاد و با ویسکوزیته پائین بکار میروند و استرها در تهیه محلولهائی با درصد جامد کم یا متوسط و با ویسکوزیته بالا بکار میروند. معمولا استفاده از کیتونها با وزنهای مولکولی کمتر بیشتر ترجیح داده می شود تا استرهای مشابه زیرا که کیتونها امکان استفاده بیشتر از حلالهای غیر واقعی که ارزانتر ند را داده بدون آنکه بر قابلیت حل کنندگی محلول حاصل اثرات محسوسی بگذارند. کیتونها در مواردیکه احتیاج به حداکثر مواد جامد با حداقل ویسکوزیته باشد بکار میروند در صورتیکه از استرها در مواردی استفاده میگردد که احتیاج به حداکثر ویسکوزیته با حداقل و یا حد متوسط درصد جامد باشد.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\">&nbsp;</p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">۲) حلالهای کمکی یا الکلها</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">رزینهای نیترو سلولزی در الکلها به از متانل قابل حل نیستند و اما افزایش مقدار کمی الکل به حلالهای اصلی افزایش مقدار کمی الکل به حلالهای اصلی افزایش چشمگیری بر قدرت حلالیت حلالهای اصلی خواهد داشت. استفاده مستقیم (یا تنها) از الکل بعنوان یک حلال نیترو سلولزی بنا بدلائل ذیل امکان پذیر نمی باشد:</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ـ الکلها به تنهائی نمی توانند محلول روشنی از نیتروسلولز ایجاد نمایند.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ـ الکلها به تنهائی نمی توانند نیترو سلولز را در خود حل نمایند.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">ـ تبخیر الکلها به تنهائی نمی تواند در ایجاد فیلم یکنواخت و رضایت بخش نقشی داشته باشد.</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\">&nbsp;</p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">۳) حلالهای رقیق کننده یا غیر فعال</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">&ndash; ئیدرو کربنهای آلفتیک یا غیر فعال</span></p>\r\n\r\n<p style=\"direction: rtl; text-align: justify;\"><span style=\"font-size:16px\">از عمده حلالهای رقیق کننده میتوان حلالهای ئیدرو کربنی آلفتیک و آروماتیک مثل تولوئن، زایلن و نفتا با نقطه اشتغال بالا را نام برد که به هیچ وجه به تنهائی قادر به انحلال رزینهای نیتروسلولزی در خود نمی باشند و اما از آنجائیکه استفاده از حلالهای فعال و نیمه فعال جهت انحلال رزینهای فوق باعث افزایش قیمت نهائی تولید حاصل خواهد گشت از اینرو جهت کاهش قیمت نهایی از حلالهای غیر فعال نیز جهت رقیق کردن محلول حاصل از انحلال رزینهای نیترو سلولزی در مخلوط حلالهای فعال و نیمه فعال استفاده می نمایند. معمولا حلالهای رقیق کننده را بر مبناء نسبت رقیق کنندگی آنان انتخاب می کنند. نسبت رقیق کنندگی دو حلال بهم عبارتست از نسبت آن مقدار مینیمم یک حلال رقیق کننده به مقدار حلال واقعی که ایجاد یک محلول کدری را نماید.</span></p>','/app/articles/1545725434795.jpg','/app/articles/1545725434436.jpg','افزودنی ها,حلال ها,حلالهای رنگ,فروش مواد شیمیایی,آمازون تله,فروش انلاین','حلال-ها-و-نقش-آنها-در-صنعت-رنگ',5748,2,1,'2018-12-25 11:40:34','2022-01-11 22:45:41'),(47,4,'استفاده از مفهوم رنگها در طراحی وب سایت و فروشگاه های آنلاین','مردم به روشهای مختلف از جمله شیوه های روانشناختی و اجتماعی بوسیله رنگ تحت تاثیر قرار می گیرند.','<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:blue\">استفاده از رنگ در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">مردم به روشهای مختلف از جمله شیوه های روانشناختی و اجتماعی بوسیله رنگ تحت تاثیر قرار می گیرند. با رنگ می توان بیانه ای ایجاد نمود ، خلق و خو را تغییر داد و توجه را جلب کرد. به همین دلیل</span>&nbsp;<em><span style=\"color:red\">روانشناسی رنگها</span></em>&nbsp;<span style=\"color:black\">در</span>&nbsp;<u><span style=\"color:#0213b0\">طراحی وب سایت</span></u>&nbsp;<span style=\"color:black\">بسیار مهم است. صفحات مختلف در ایجاد بیانیه و جذب کاربر نقش حیاتی ایفا می کنند. اگر در طراحی وب سایت رنگ مناسب بکار گرفته شود این رنگ می تواند علاوه بر انتقال پیام به کاربر انرژی نیز دهد. اگر می خواهید یک فضای گرم و حرفه ای در وب سایت ایجاد کنید ، بایستی در استفاده از رنگ در طراحی وب سایت دقت نمایید</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:white\">نکته</span><span style=\"color:#0213b0\">بازاریابی</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:green\">دقت داشته باشید که وب سایت یکی از اجزاء تاثیر گذار در بازاریابی بویژه</span>&nbsp;<u><span style=\"color:#0213b0\">برندسازی</span></u>&nbsp;<span style=\"color:green\">است. پس یکپارچگی میان فعالیت فیزیکی و مجازی بویژه در نظر گرفتن رنگ در این اقدامات بسیار مهم است</span><span dir=\"LTR\"><span style=\"color:green\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:blue\">رنگ در طراحی وب سایت</span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:blue\">روانشناسی رنگها</span></span></span><br />\r\n&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">درک</span>&nbsp;<span style=\"color:#0213b0\">تاثیر روانشناسی رنگها</span>&nbsp;<span style=\"color:black\">بر روی افراد می تواند یک مزیت قابل توجه برای طراحان و بازاریابان به صورت مشابه باشد. اگر چه کسب درک عمیق از روانشناسی رنگ زمان بر و نیازمند تجربه است. چندین راهنمایی ساده وجود دارد که به شما در درک مفهوم و معنای موجود در هر رنگ به شما کمک می کند. پس به</span>&nbsp;<span style=\"color:#0213b0\">استفاده از رنگ در طراحی وب سایت</span>&nbsp;<span style=\"color:black\">توجه داشته باشید</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><img alt=\"\" src=\"http://www.amazontele.com/laravel-filemanager/photos/3/paper/Color Web.jpg\" style=\"height:618px; width:618px\" /></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\">&nbsp;</h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">روانشناسی رنگ سیاه در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:#ff6600\">رنگ مشکی با قدرت ، وقار ، رسمیت ، مرگ ، شر و رمز راز مرتبط است</span><span dir=\"LTR\"><span style=\"color:#ff6600\">.</span></span>&nbsp;<span style=\"color:black\">رنگ مشکی نمونه خوبی است از اینکه چگونه از یک رنگ می توان برای نشان دادن معانی مختلف ، بسته به شرایط استفاده نمود. در</span>&nbsp;<span style=\"color:#0213b0\">طراحی وب سایت</span>&nbsp;<span style=\"color:black\">استفاده از رنگ مشکی و سفید می تواند هماهنگی و ظرافت خاصی به وب سایت دهد. همچنین یک روش عالی برای توجه به سایر عناصر صفحه است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span dir=\"LTR\"><span style=\"color:red\">&bull;</span></span><span style=\"color:black\">سعی کنید از رنگ مشکی برای اطلاعات عمومی استفاده نمایید. از رنگ های سبز و یا قرمز می توانید برای جلب توجه در سرفصل های سایت و یا دکمه های تماس به صورت حرفه ای استفاده نمایید</span><span dir=\"LTR\"><span style=\"color:black\">.</span><span style=\"color:red\">&bull;</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:red\">روانشناسی رنگ قرمز در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">قرمز رنگ آتش و خون است. رنگ قرمز معمولاً با انرژی ، قدرت ، عزم و اشتیاق همراه است. در برخی از فرهنگها قرمز مترادف با خطر و جنگ است. هنگام</span>&nbsp;<span style=\"color:#0213b0\">طراحی وب سایت</span>&nbsp;<span style=\"color:black\">، سعی کنید از رنگ قرمز بویژه برای جلب توجه استفاده نمایید. از رنگ قرمز برای دادن پیام های مرتبط با خطا نیز استفاده می شود. بنابراین در نظر داشته باشید که</span>&nbsp;<span style=\"color:#0213b0\">روانشناسی رنگ قرمز</span>&nbsp;<span style=\"color:black\">منعکس کننده موارد منفی نیز است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:red\">قرمز نسبت به سایر رنگ ها سریعتر توجه مخاطب را جلب می کند</span><span dir=\"LTR\"><span style=\"color:red\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:green\">روانشناسی رنگ سبز در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:green\">رنگ سبز ، رنگ طبیعت ، نماد رشد ، رفاه ، طراوت و باروری است. در طراحی وب سایت ها ، رنگ سبز رنگی است که برای هدایت بازدیدکنندگان به سطوح مختلف قیف فروش استفاده می شود</span><span dir=\"LTR\"><span style=\"color:green\">.</span></span>&nbsp;<span style=\"color:black\">افراد بر روی دکمه های طراحی شده با رنگ سبز بیشتر کلیک می کنند. همچنین برندهایی که از بازاریابی سبز در استراتژی کسب و کار خود استفاده می کنند از این رنگ برای نشان دادن فلسفه کاری خود به شدت استفاده می کنند</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:#ff6600\">روانشناسی رنگ نارنجی در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">رنگ نارنجی ترکیبی از انرژی قرمز که با شادی رنگ زرد همراه است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:#ff6600\">رنگ نارنجی با گرما ، شور و شوق ، شادی و آفتاب همراه است</span><span dir=\"LTR\"><span style=\"color:#ff6600\">.</span></span>&nbsp;<span style=\"color:black\">رنگ نارنجی یکی از رنگ های مورد استفاده در طراحی های وب سایت ها در سال ۲۰۱۶ بود. از رنگ نارنجی به عنوان طراحی نقطه کانونی استفاده می شود</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"color:#FF8C00\"><span style=\"font-size:18px\">روانشناسی رنگ زرد در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">رنگ زرد درخشان ترین رنگ در طیف رنگی است. رنگ زرد رنگ آفتاب است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:#0213b0\">روانشناسی رنگ زرد</span>&nbsp;<span style=\"color:black\">اغلب با عقل و انرژی مرتبط است. برای ایجاد احساس فضای دوستانه و آرامش در طراحی وب سایت از رنگ زرد استفاده می شود. رنگ زرد هنگامی که به درستی استفاده شود می تواند خوشبینی و شادی را در ذهن کاربر ایجاد نماید</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:blue\">روانشناسی رنگ آبی در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">آبی رنگ آسمان و دریا است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:#0213b0\">روانشناسی رنگ آبی</span>&nbsp;<span style=\"color:black\">اغلب با عمق و ثبات همراه است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:blue\">رنگ آبی اغلب نماد اعتماد و وفاداری است. از آنجا که به دست آوردن اعتماد مشتری برای موفقیت هر کسب و کاری بسیار مهم است ، جای تعجب نیست که رنگ آبی محبوب ترین رنگ مورد استفاده در طراحی لوگوها و برندسازی است</span><span dir=\"LTR\"><span style=\"color:blue\">.</span></span>&nbsp;<span style=\"color:black\">رنگ آبی اغلب نقطه شروعی برای طراحی وب سایت های حرفه ای است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:purple\">روانشناسی رنگ بنفش در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;&nbsp;<span style=\"color:black\">بنفش ترکیبی از آبی و قرمز است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:#0213b0\">روانشناسی رنگ بنفش</span>&nbsp;<span style=\"color:black\">نشان دهنده ثبات و انرژی در یک محیط است. بنفش با حق امتیاز و قدرت همراه است</span><span dir=\"LTR\"><span style=\"color:black\">.&nbsp;</span></span><span style=\"color:purple\">بسیاری از برندهای لوکس از رنگ بنفش در برندسازی و طراحی لوگوی خود استفاده می کنند</span><span dir=\"LTR\"><span style=\"color:purple\">.</span></span>&nbsp;<u><span style=\"color:#0213b0\">برند فدکس</span></u><u><span dir=\"LTR\"><span style=\"color:#0213b0\"> (FedEx)</span></span></u>&nbsp;<span style=\"color:black\">به صورتی کاملاً حرفه ای از رنگ بنفش در طراحی لوگو و وب سایت خود استفاده نموده است</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:black\">روانشناسی رنگ</span>&nbsp;<span style=\"color:#000000\">سفید&nbsp;</span><span style=\"color:black\">در طراحی وب سایت</span></span></span></strong></h2>\r\n\r\n<h2 dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:#0213b0\">روانشناسی رنگ سفید</span>&nbsp;<span style=\"color:black\">با نور ، پاکی و بی گناهی همراه است. افراد سفید را به تمیزی و پاکیزگی نسبت می دهند. رنگ سفید همچنین به صورت یک بوم فوق العاده برای سایر رنگ عمل می کند و به خوبی در هر ترکیب رنگی عمل می کند. تقریباً در وب سایتی می توانید رنگ سفید را مشاهده کنید.اگر شما به دنبال ایجاد لایه ای از تمیزی و تجربه کاربر هستید ، بایستی تا حد امکان از رنگ سفید در طراحی وب سایت خود استفاده نمایید</span><span dir=\"LTR\"><span style=\"color:black\">.</span></span></span></span></h2>','/app/articles/1545811972852.jpg','/app/articles/1545811972545.jpg','فروشگاه آنلاین,فروش اینترنتی,برند سازی,طراحی فروشگاه اینترنتی,فروش مواد شیمیایی,آمازون تله,روانشناسی رنگ ها,پیگمنت ها,رنگدانه,رنگینه','استفاده-از-مفهوم-رنگها-در-طراحی-وب-سایت-و-فروشگاه-های-آنلاین',1053,3,1,'2018-12-26 09:11:16','2022-01-11 22:29:13'),(48,1,'انواع سورفکتانت‌ها','سورفکتانت ها Surfactatnt مخفف (Surface Active Agents) به توزیع یک فاز در فاز دیگر کمک می کند.','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">انواع سورفکتانت&zwnj;ها</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سورفکتانت ها Surfactatnt مخفف (Surface Active Agents) به توزیع یک فاز در فاز دیگر کمک می کند. این تعریف محدود به سوسپانسیون های جامد &ndash; مایع نیست و ممکن است شامل سیستم های مایع &ndash; مایع هم بشود. هنگامی که این مواد برای پایدارسازی ذرات جامد در مایع به کار می روند به آن ها دیسپرسانت می گویند. مولکول های تشکیل دهنده سورفکتانت ها تمایل زیادی به تجمع در فصل مشترک دارند. این امر به این علت رخ می دهد که ساختار آن ها از دو بخش تشکیل شده است که یک بخش آن محلول در حلال و بخش دیگر آن نامحلول است. این مولکول ها به صورت ترجیحی به شکلی جهت گیری می کنند که بخش محلول با مایع پیوند پیدا کرده و بخش نامحلول به سطح جامد پیوند پیدا می کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سورفکتانت ها معمولا بر اساس میزان بار بخشی از مولکول که به سطح جذب می شود تقسیم بندی می شود: غیر یونی، آنیونی و کاتیونی. سورفکتانت های غیر یونی سورفکتانتی است که هیچ گروه یونیزه ای ندارد که از جمله می توان به الکل های چرب ROH، اسیدهای چرب R(CO)OR&rsquo; که R&rsquo; پلیمرهای آلی با زنجیره کوتاه هستند، اشاره کرد. ساختار اسید اولئیک C17H34(CO)OH است که حاوی زنجیره آلی C17H34 و یک گروه عاملی (CO)OH است. سورفکتانت های غیر یونی معمولا در حلال های آلی موثرند. جذب روی ذرات توسط جاذبه واندوالس یا پیوند قوی تر همسایگی صورت می گیرد. همانطور که در شکل روبرو نشان داده شده است با استفاده از مفهوم اسید و باز لوئیس اتمی که در گروه عاملی سورفکتانت قرار دارد و دارای جفت الکترون غیر پیوندی است (مانند N و O) ممکن است مانند باز لوئیس عمل کرده و یک پیوند با اتمی مانند Al روی سطح که لایه تکمیل نشده از الکترون دارد (اسید لوئیس) برقرار می کند. پایدار سازی معمولا توسط ممانعت فضایی بین دنباله های آلی یا مایسل که درون حلال آلی قرار دارند رخ می دهد ایجاد می شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">نمونه هایی از سورفکتانت های غیر یونی معمول در شکل زیر نمایش داده شده است. روغن ماهی منهادن (Menhaden Fish Oil) به طور گسترده برای پراکنده سازی Al2O3 ، BaTio3 و بسیاری از پودر های اکسیدی در حلال های آلی به کار می رود. این ماده شامل مخلوطی از اسیدهای چرب باز و زنجیره های کوتاه فرمول R(CO)OH با زنجیره الکیل (R) است که حاوی پیوندهای دو گانه C=C است و در انتهای گروه عاملی آن اسید کربوکسیلیک (CO)OH قرار دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سدیم اولئات C17H34 (CO)O&ndash;Na+ یک سورفکتانت آنیونی است زیرا به یون Na+ و یون اولئات منفی تجزیه می شود. نمک های اسیدهای چرب، مانند سدیم اولئات، سدیم استئاراتC17H35(CO)O&ndash;Na+&nbsp; و سولفونات ها مانند سدیم الکیل سولفونات R(SO2)O&ndash;Na+ که R زنجیره آلکیل متشکل از ۱۰ تا ۲۰ اتم کربن است معمولا سورفکتانت های آنیونی هستند. سورفکتانت های آنیونی در حلال های آبی موثرند. معمولا اجزای اکسیژنی با بار منفی از تجزیه سورفکتانت های آنیونی به وجود می آیند. جذب سورفکتانت معمولا توسط جاذبه الکترواستاتیک با سطح ذرات با بار مثبت رخ می دهد. پایدار سازی سوسپانسیون&nbsp; معمولا به وسیله دافعه الکترواستاتیک بین بارهای منفی ایجاد می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">دو دسیل آمونیوم استات C12H25(N+H3)CH3(CO)O&nbsp; یک سورفکتانت کاتیونی است زیرا یون استات محلول در آب CH3(CO)O&ndash; و یون دو دسیل آمونیوم با بار مثبت تجزیه می شودC12H25(N+H3) که روی فصل مشترک تجمع می کنند، تجزیه می شود. سورفکتانت های کاتیونی معمولا از اجزای نیتروژنی با بار مثبت در هنگام تجزیه برخوردارند. به جز جابه جا شدن علامت بارها روی سورفکتانت و سطح ذرات مکانیزم های جذب و پایدار سازی مشابه مورد سورفکتانت های آنیونی است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تجزیه سورفکتانت های آنیونی و کاتیونی برای تشکیل گروههایی با سر مثبت و منفی، پایدارسازی با سورفکتانت با بار منفی و پایدار سازی با مایسل منفی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">برخی از سورفکتانت ها در pH پایین، بار مثبت، در pH متوسط بدون بار و در pH بالا بار منفی دارند. به سورفکتانتهای آمفوتریک موسومند. اگر یک مولکول خنثی گروهی با بار مثبت (مانند یون آمونیوم) و گروهی با بار منفی مانند (یون کربوکسیلات داشته باشد به یون zwitterionic موسومند. نمونه ای از سورفکتانت های زویتریونیک آمینو اسیدها R(N+H2)CH2CH2(CO)O&ndash; هستند. این ترکیب ها ممکن است آمفوتریک هم باشند و در pH پایین کاتیونی و در pH کاتیونی و در pH بالا آنیونی باشند. حضور این دو بار مخالف منجر به ایجاد ممان دو قطبی بزرگی می شود و در نتیجه این مولکول به شدت به سطح پلاریزه جذب می شود. این سورفکتانت ها می توانند روی سطوح با بارهای مختلف جذب شوند زیرا بخش مثبت مولکول به سطوحی با بار منفی و بخش منفی مولکول به سطوحی با بار مثبت جذب می شود.</span></span></p>','/app/articles/1545804387466.jpg','/app/articles/1545804387316.jpg','افزودنی,سورفکتانت,انواع سورفکتانت,فروش مواد شیمیایی,آمازون تله,فروش انلاین','انواع-سورفکتانت-ها',1330,2,1,'2018-12-26 09:36:27','2022-01-11 21:59:53'),(49,1,'کاربرد سورفکتانت ها در فرمولاسیون های دارویی','سورفکتانت ها یا عوامل فعال سطحی دسته ای از مواد جانبی می باشد که کاربرد فراوانی در صنعت داروسازی دارند','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">کاربرد سورفکتانت ها در فرمولاسیون های دارویی</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سورفکتانت ها یا عوامل فعال سطحی دسته ای از مواد جانبی می باشد که کاربرد فراوانی در صنعت داروسازی دارند همانطور که از نام این مواد مشخص می گرددSurface active agents (Surfactant) ، تقش عمده این مواد جانبی کاهش کشش سطحی می باشد ، کشش سطحی به عنوان یک فاکتور بحرانی در انحلال و نیز در امتزاج مواد با قطبیتهای مختلف محسوب می گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سورفکتانتها به چهار دسته کلی تقسیم بندی می گردند و هر دسته نیز به گروه های کوچکتری تقسیم می گردد:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">1-&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سورفکنانتهای آنیونی که دارای گروه عاملی آنیونی فعال هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">2-&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سورفکنانتهای کاتیونی که دارای گروه عاملی کاتیونی فعال&nbsp; هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">3-&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سورفکنانتهای آمفولیتیک که دارای گروه های کاتیونی و آنیوینی هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">4-&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سوفکتانتهای غیر یونی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در اشکال دارویی جامد از سورفکتانتها به عنوان عامل تر کننده و نیز کمک کننده به انحلال&nbsp; استفاده می گردد . همانطور که می دانیم مواد موثره دارویی براساس طبقه بندی FDA به چهار دسته از نظر بایو اکی والانسی تقسیم میگردند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">Class 1: High Solubility &ndash; High Permeability</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">Class 2: Low Solubility &ndash; High Permeability</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">Class 3: High Solubility &ndash; Low Permeability</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">Class 4: Low Solubility &ndash; Low Permeability</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">&nbsp;</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">تا جایی که بنده اطلاع دارم عمده دسته دارویی در دسته ای قراردارند که حلالیت پایین و نفوذ بالا دارند لذا جهت این دسته&nbsp; ازداروها باید فاکتور انحلال را به عنوان فاکتور اصلی در جذب و یا شاید بشود گفت اثربخشی دارو در نظر گرفت. پس هر عاملی که باعث افزایش سرعت انحلال در شیره های گوارشی را گردد مستقیما باعث&nbsp; افزایش جذب دارو نیز می گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">توضیح تکمیلی بحث مطرح شده آن است که در اشکال دارویی جامد فاکتوری یه عنوان زمان متلاشی شدن (Disintegration time) وجود دارد در این زمان اشکال دارویی جامد اعم از قرص یا کپسول باید به اندازه اجزا سازنده دربیایند تا حداکثر سطح تماس با شیره های گوارشی برای جذب ممکن باشد.در این بین دو عامل به صورت عمومی می تواند تولید اشکال نماید اول آنکه ذرات هوای حبس شده در گرانول و در سطح ذرات مانع از تماس شیره های گوارشی با سطح گرانول می گردد و دوم آنکه به علت استفاده از مواد چرب کننده یا لوبریفیان در تولید محصولات جامد در مرحله آخر تولید معمولا سطح گرانول های چرب هست و این عامل چربی نقش آبگریزی را در گرانول باعث می گردد ، مقدار اثر این عامل کاملا وابسته به مقدار مصرف شده در تولید و زمان چرخش نهایی این ماده جانبی با گرانول در زمان تولید می باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">این موضوع به شکل ریاضی در معادله ای به نام یانگ آمده است براساس معادله یانگ ترشدگی ذرات جامد (اصطلاحا پخش مایع تر کننده برروی سطح ذره جامد شونده) زمانی اتفاق می افتد که کشش سطحی بحرانی جامد تر شونده کمتر از کشش سطحی مایع تر کننده&nbsp; باشد. با توجه به اینکه در شرایط عادی شیره های گوارشی دارای کشش سطحی مشخصی هستند باید کشش سطحی نمونه ماده دارویی جامد را کاهش داد تا امکان تر شوندگی این ذرات در شیره های گوارشی فراهم گردد. استفاده از سورفکتانتهای با توجه به ساختار ویژه ای سر قطبی و دم غیر قطبی باعث افزایش پلاریته ذره جامد وافزایش انرژی آزاد سطحی و&nbsp; کاهش کاشش سطحی می گردد وهمچنین عملا باعث خنثی کردن نقش لوبریفیان (چرب کننده) در خاصیت آب گریزی ان می گردد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">در خصوص استفاده از سورفکتانت های در اشکال دارویی نیمه جامد نیز از خاصیت ذاتی سورفکتانتها که لیپوفیل &ndash; هیدروفیل هستن استفاده می شود ، همانطور که اشاره شد مولکولهای سورفکتانت یک سر قطبی دارند و یا دم غیر قطبی و به علت این ویژگی فیزیکی قابلیت امتزاج مواد با قطبیتهای مختلف رو به هم می دهند. سورفکتانتها در این نقش در سطح تماس مواد با قطبیت مختلف دخالت می کنند و باعت امتزاج دو فاز درهم می شوند البته بسته به تعداد زنجیر کربنی و یا بهتر بگوییم دم غیر قطبی مولکول سورفکتانت قدرت و حلالیت آنها فرق می کند. به همین دلیل به این مواد مواد امولسیفایر و یا امولسیون کننده نیز گفته می شود که باعث ایجاد امولیسون های پایداری در فرمولاسیون های دارویی می گردند. این ویژگی یعنی تعداد و قدرت لیوفیلیسیته دم و قدرت هیدروفیلیسته سر سورفکتانت به ویژگی منحصر به فردی در سوفکتانتها منجر می گردد و آن عدد HLB می باشد. (Hydrophilic lipophilic balance) اصطلاحا این عدد که بین 1 تا 40 می باشد&nbsp; که میزان هیدروفیل و یا لیپوفیل بودن سورفکتانت را مشخص می کند به نحوی که هر قدر مقدار HLB بالاتر باشد قدرت هیدروفیلی آن بالاتر است و هر قدر کمتر باشد قدرت لیپوفیلی آن بیشتر است از عدد HLB حهت انتخاب امولیسفایر مناسب بسته به کاربرد مد نظر باید استفاده کرد به نحوی که HLB های کمتر از 5 عمدتا در Antifoaming agent ها و سیستم های امولیسون آب در روغن کاربرد دارد و عوامل فعال سطحی در HLB حدود 8 تا 9 انتخاب می گردد سپس&nbsp; به ترتیب افزایش HLB امولیسونهای آب در روغن و شوینده ها و تر کننده ها قرار دارند. در فرمولاسیون های دارویی باید براساس هیدروفیلیسیته و لیپوفیلیسیته فرمولاسیون مقدار HLB مورد نیاز را محاسبه نمود که از معادلات اصطلاحا گریفن برای این منظور استفاده می گردد.</span></span></p>','/app/articles/1545804676470.jpg','/app/articles/1545804676710.jpg','افزودنی ها,سورفکتانت ها,سورفکتانت های دارویی,صنعت دارو,فروش مواد شیمیایی,آمازون تله,فروش انلاین','کاربرد-سورفکتانت-ها-در-فرمولاسیون-های-دارویی',1631,2,1,'2018-12-26 09:41:16','2022-01-11 23:21:03'),(50,1,'سورفکتانت چیست؟','سورفکتانت به زبان ساده ماده ای است که هنگامی که به مقدار بسیار ناچیز استفاده می شود کشش سطحی آب را به میزان قابل توجهی کاهش می دهد','<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><strong><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">سورفکتانت چیست؟</span></span></strong></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">سورفکتانت به زبان ساده ماده ای است که هنگامی که به مقدار بسیار ناچیز استفاده می شود کشش سطحی آب را به میزان قابل توجهی کاهش می دهد.</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">كلمه سورفكتانت مجموعه از کلمات &quot; Surface active agent &quot; می باشد. سورفکتانت ها معمولاً ترکیباتی آلی هستند که دارای گروههای هیدروفوبیک (دافع آب) که نقش دم و دنباله را دارد و گروههای هیدروفیلیك (جاذب آب) که نقش سر را دارد می باشند، بنابراین به تناسب ساختار مولكولی در حلالهای آلی و آب حل می شوند و باعث كاهش كشش سطحی در فصل مشترك هوا- آب و یا روغن- آب می شوند.</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">ساختار شیمیایی این مواد اغلب شامل یك مولكول نسبتا طولانی با یك انتهای آب گریز و انتهای دیگر آبدوست می&zwnj;باشد. قسمت آب گریز این مواد (یك دنباله هیدروكربنی طولانی) با رزین سازگار بوده و در جهت آن حركت می&zwnj;كند در حالیكه قسمت آب دوست به سمت بیرون جهت گیری نموده (بسمت فاز آب) و با احاطه نمودن رزین باعث سازگاری آن با آب می&zwnj;شود.درواقع سورفکتانت ها موادی هستند که میتوانند انرژی سطحی را بین سطوح به میزان زیادی تغییر دهندخاصیت یک سورفکتانت ناشی از دو شخصیتی بودن ساختمان ملکولی آن است به این معنی که همزمان دارای گروههای آبدوست و آبگریز میباشند. سورفکتانت ها نقش مهمی در بسیاری از کاربردهای عملی و محصولات بازی میکنند مثلاً : شوینده ها، انعقاد سازها (مثل: خون)، امولسیون کننده ها (مثل: كرم)، جوهرسازی، کف سازی (مثل: شامپو) ،دیسپرسنتها (جداكننده ها) ،پلیمر( مثل: لاستیك ماشین) و...</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">سورفکتانت ها معمولاً بوسیله گروههای باردار به 4 گروه سورفکتانت آنیونی (دارای بار منفی) ،سورفکتانت کاتیونی (دارای بار مثبت)، سورفکتانت غیر یونی (بدون بار) و آمفوتریک (دارای بار در مجموع خنثی) تقسیم بندی می شوند.</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">سورفکتانت های nonionic در قسمت سر خود بی بار هستند اگر بار منفی باشد سورفکتانت آنیونی و اگر مثبت بود سورفکتانت کاتیونی داریم. گاهی قسمت سر دارای هر دو بار منفی و مثبت است که به آن آمفوتریک گوئیم .</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">سورفکتانت&zwnj;ها ترکیباتی آلی هستند که دارای گروه&zwnj;های هیدروفوبیک (دافع آب) که نقش دم و دنباله را دارد و گروه&zwnj;های هیدروفیلیك (جاذب آب) که نقش سر را دارد می باشند، بنابراین به تناسب ساختار مولكولی در حلال&zwnj;های آلی و آب حل می&zwnj;شوند و باعث كاهش كشش سطحی در فصل مشترك هوا-آب و یا روغن-آب می&zwnj;شوند</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">بسیاری از ترکیبات شیمیایی کف و سطوح مرطوب ایجاد میکنند ولی جزء مواد فعال سطحی دسته بندی نمیشوند (مانند متیل الکل در محلول آبی) .</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">خصلت اصلی یک شوینده این است که تجمع آن در سطح مایع بیشتر از درون مایع است. این پدیده جذب نام دارد و در سطوح ما بین مایع-جامد، مایع-مایع و هوا-مایع ایجاد می شود.</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">رشد ریوی جنین</span></span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\"><span style=\"color:#454545\">از هفته 33 بارداری سورفاکتانت در ریه جنین شروع به ساخت می کند. بنابراین اگر از این هفته به بعد کودک بدنیا بیاید مشکل کمتری از نظر تنفسی خواهد داشت. ولی تولد نوزاد زودرس با ایجاد سندرم زجر تنفسی جنین ممکن است موجب مرگ شود. برای تسریع در رشد ریه جنین هنگامی که احتمال زایمان زودرس وجود دارد به مادر داروهای کورتیکواستروئیدی تجویز می شود. همچنین سورفکتانت ریوی غیر تب زا و استریل موجود می باشد که فقط از راه داخل تراشه ای استفاده می شود. می توان سورفکتانت را بعد از به دنیا آمدن نوزاد از راه داخل تراشه به ریه نوزاد تزریق کنند و مشکل تنفسی نوزاد را حل کنند. سورونتا عصاره طبیعی ریه گاو می باشد که حاوی فسفولیپیدها، چربی های خنثی، اسیدهای چرب، و پروتئین های وابسته به سورفکتانت می باشد که به این ترکیب کولفوسریل پالمیتات (دی پالمیتوئیل فسفاتیدیل کولین)، پالمیتیک اسید، و تری پالمیتین افزوده شده است تا ترکیب استانداردی ایجاد شود که خواصی مشابه خواص پایین آورنده کشش سطحی سورفکتانت ریه طبیعی را نشان دهد.</span></span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"background-color:white\">&nbsp;</span></span></span></p>\r\n\r\n<p dir=\"rtl\" style=\"margin-left: 0in; margin-right: 0in; text-align: justify;\"><strong><span style=\"font-size:20px\"><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"background-color:white\">خواص ضدعفونی کننده</span></span></span></span></strong></p>\r\n\r\n<p dir=\"rtl\" style=\"text-align: justify;\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\"><span style=\"color:#454545\">سورفکتانت&zwnj;های کاتیونی درمحلول آبی به یک کاتیون نسبتا بزرگ فعال و یک یون کوچک غیرفعال یونیزه&zwnj;می&zwnj;شود.ترکیبات کاتیونی علاوه براثرات امولسیون&zwnj;کننده و پاک&zwnj;کننده دارای&zwnj;فعالیت باکتری&zwnj;کش علیه باکتریهای گرم&zwnj;مثبت و گرم منفی می باشند. بسیاری از ترکیبات ضدعفونی کننده معروف مانند بتادین و ستیل پیریدینیوم خواص سورفکتانتی دارند</span></span></span></p>','/app/articles/1545805206128.png','/app/articles/1545805206651.png','سورفکتانت ها,تعریف سورفکتانت,فروش مواد شیمیایی,آمازون تله,افزودنی ها,فروش انلاین','سورفکتانت-چیست',2181,3,1,'2018-12-26 09:50:06','2022-01-11 23:56:13'),(51,4,'فروشگاه اینترنتی چیست؟','با توجه به رشد روز افزون مفاهیمی مانند خرید آنلاین، فروشگاه آنلاین، کسب و کار آنلاین، خرید اینترنتی، فروشگاه اینترنتی','<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><strong><span style=\"color:#0000FF\"><span style=\"font-family:comic sans ms,cursive\">فروشگاه اینترنتی چیست؟</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">با توجه به رشد روز افزون مفاهیمی مانند خرید آنلاین، فروشگاه آنلاین، کسب و کار آنلاین، خرید اینترنتی، فروشگاه اینترنتی که در سالهای اخیر دیگر مانند گذشته واژه ای نامأنوس نیست و همه افراد از هر قشری گرچه ممکن است تا کنون تجربه نکرده باشند، برایشان آشناست و بارها در موردش شنیده و یا خوانده اند، لذا از این دیدگاه آشنایی با این مفاهیم، استانداردها و انتظارها و واقعیتهای کاربردی در خصوص فروشگاه آنلاین خصوصا برای تازه واردین به این حوزه و افرادی که علاقمند هستند کسب و کار خود را در فضای مجازی توسعه دهند بسیار ضروری می نماید، در این مقاله سعی شده است تمامی آنچه در خصوص فروشگاه هایی اینترنتی باید بدانید تا حد امکان پوشش داده شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">تاریخچه:</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">اولین بار در سال 91 میلادی آقای برنرزلی (استاد دانشگاه MIT) تجارت الکترونیک را پایه نهاد و در سال 94 پس از ارائه مفهوم بانکداری آنلاین مفهوم خرید اینترنتی متولد شد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در لیست زیر برخی از اولین های این حوزه را مشاهده می کنید:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; پیتزا هات (Pizza Hut)</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; کمپانی اینترشاپ: ارائه دهنده راهکارهای تجاری برای کسب و کارهای بزرگ</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; شرکت آمازون: در ابتدا به عنوان فروشگاه آنلاین کتاب فعالیت می کرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ای بی (e-Bay): حوزه کسب و کار در خصوص مزایده اینترنتی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">فروشگاه اینترنتی چیست؟</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">فروشگاه آنلاین در حقیقت یک از ابزارهای تجارت الکترونیک است که به مشتری اجازه می دهد به صورت مستقیم کالاها و خدمات خود را از فروشنده در بستر اینترنتی و وب با استفاده از مروگر تهیه کند.مشتریها می توانند محصول مورد نظر خود را از طریق مشاهده صفحه مشخصات محصول به صورت مجازی انتخاب کنند، قاعدتاً با تغییرات اخیر انتظار می رود که فروشگاه در ابزارهای مختلف مانند موبایل، تبلت و یا نسخه دسکتاپ عملکرد قابل قبولی را از خود بروز دهند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">فروشگاه آنلاین در حات معمول امکان مقایسه فیزیکی و حضوری خدمات و محضولات را در مراکز خرید و یا ساختمان های تجاری معمول حذف کرده و خریدار می تواند با مشاهده تصاویر محصولات، مطالعه امکانات و ویژگیهای مورد نظر اقدام به خرید کند. فروشگاه های آنلاین در رده های مختلف می توانند مورد استفاده قرار گیرد: از جمله حوزه B2C زمانیمه یک تولید کننده و یا فروشنده اقدام به ارائه خدمات و محصولات برای مشتری نهایی خود می کند و یا در زمینه B2B که در این حوزه یک شرکت برای ارائه خدمات خود به سایر فروشندگان از آن استفاده می کند و اصطلاحا تحت عنوان Business to Business شناخته می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">فروشگاه های اینترنتی برای خریداران خود امکان جستجو در بین محصولات برای یافتن مدل مشخص، برند و یا اقلام خاصی از محصول را فراهم می کنند. برای استفاده از فروشگاههای اینترنتی قاعدتا امکان دسترسی به اینترنت، یک روش پرداخت جهت تکمیل فرآیند خرید ضروری است، علاوه بر محصولات فیزیکی محصولات دیجیتال هم در این بستر می توانند به سادگی ارائه شوند مانند: نرم افزارها، موسیقی و فایلهای صوتی از جمله فروشگاه های اینترنتی مطرح در دوران کنونی می توان به آمازون(Amazon)، علی بابا(Alibaba)، و ایی بی(e-Bay) اشاره کرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">با رشد اینترنت و شناخته شدن این بستر به عنوان کانال خرید ایمن از سال 1994 میلادی که اولین بار با فروش آلبوم Ten Summoner&rsquo;s Tales مطرح شد، شراب، گل و شکلات محصولاتی بودند که به سرعت به عنوان رده های پر فروش در فروش آنلاین مطرح شدند و فروشنده ها متوجه شدند که ارائه کالا یا خدماتی که قابلیت فروش اینترنتی را داشته باشند به عنوان عامل اصلی موفقیت در این حوزه می باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بر اساس آمارها در سال 2012 آسیا فروش بین المللی خود را تا 30% افزایش داده است. رکورد پرفروش ترین روز به صورت آنلاین مربوط به روز مجردها در سایت علی بابا بوده است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بخشهای مهم در فروشگاه اینترنتی و فروش آنلاین:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; مشتری:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در حوزه خرید آنلاین هر شخص می تواند به سادگی در خصوص خرید کردن یا نکردن تصمیم گیری کند و این تصمیم گیری تحت تاثیر فاکتورهایی جدای از فاکتورهای موثر در خرید در بازار فیزیکی است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; تحلیل رفتار خرید مشتری:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">همانطور که اشاره شد در زمینه خرید آنلاین از فروشگاه های آنلاین دیگر تنها برند و کارخانه تولید کننده و فروشنده هدایت کننده مشتری برای انجام خرید نیستند بلکه ابزارهایی مانند موتورهای جستجو، نظرات سایر کاربران، اطلاعات ارائه شده در خصوص محصول، ظاهر سایت و سایر پروسه های اعتبارسنجی مانند &quot;نماد اعتبار&quot; و ... تعیین کننده موفقیت یا شکست یک فروش می باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; انتخاب محصول:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در پروسه انتخاب محصول در فروشگاه های آنلاین، الگوریتم کار هدایت کردن مشتری از طریق موتورهای جستجوی فروشگاهی به سمت فروشگاه مورد نظر برای معرفی محصول مورد نظر به مشتری است و در صورت ابراز تمایل مشتری به خرید محصول سعی در افزایش سبد خرید وی می باشد، لذا باید تلاش کرد تا با شناسایی دقیق رفتار مشتری به علاقمندی ذاتی وی پی برده تا در زمان مراجعه محصولات مورد نظر مشتری به راحتی در معرض دید وی قرار گیرد و احتمال خرید سایر موارد دلخواه وی را افزایش دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; پرداخت:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">روش های متداول پرداخت استفاده از کارتهای بانکی و پرداخت آنلاین است ولی برخی راهکارها مانند پرداخت در محل و یا پرداخت اعتباری و یا استفاده از راهکارهایی مانند ارائه کارت هدیه جهت خرید از فروشگاه به دوستان و...</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; تحویل محصول:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بر اساس ساختار هر شرکت و کشوری روشهای متنوعی برای تحویل کالای خریداری شده به مشتری وجود دارد، به عنوان نمونه روشهای زیر از جمله روشهای متداول در این نوع کسب و کار است:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">1.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ارسال مستقیم: کالا مستقیما به آدرس مشخص شده توسط مشتری ارسال شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">2.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ارسال از سمت تولید کننده: در این روش سفارش و مشخصات مشتری به تولید کننده اعلام شده و ارسال کالا از طریق تامین کننده انجام خواهد شد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">3.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ارائه خدمات در فروشگاه: مشتری این امکان را خواهد داشت که برای دریافت کالای خود یکی از انبارها و یا فروشگاه های نزدیک محل اقامت خود را انتخاب کرده و برای دریافت کالای سفارش داده شده مستقیما به این فروشگاه ها مراجعه کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سبدخرید:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">نرم افزار سبد خرید یک بخش از نرم افزارهای تجارت الکترونیک است، که به بازدید کننده ها اجازه می دهد آیتم های مورد نظر خود برای خرید را انتخاب کنند و به عنوان انباره ای برای این محصولات استفاده می شوند، معمولا محاسبه قیمت کلی و تخفیف های اعمال شده بخشی از عملکرد این سیستم می باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نمایش اطلاعات و محصولات:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">همانطور که چیدمان قفسه های فروشگاهی در جذب مشتری نقش بسیار مهمی دارد، در فروشگاه اینترنتی نیز ارائه محصولات مرتبط با خریدهای قبلی مشتری و یا مطابق با روحیات وی نقش حیاتی ایفا می کند، همچنین ارائه تصاویر مناسب، توضیحات کامل و یا پاسخ به سوالات مشتری یکی از عواملی است که تعیین کننده تکمیل خرید و یا انصراف از خرید مشتری می باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نیاز و درخواست مشتری:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بر اساس تحقیقی که در سال 2005 توسط دانشگاه میشیگان صورت گرفته است، نمایش بیش از حد فروشگاه مورد نظر شما در موتورهای جستجو چندان مطلوب نیست و بیشتر باید به دنبال حفظ رابطه ای که با مشتری ایجاد شده است بود، به عبارت ساده تر هدف باید ترغیب مشتری به مراجعه مجدد در این فروشگاه ها انجام شود، با این وجود تحقیقات اخیر ثابت کرده است که فروشگاه هایی که از نظر کارآیی، سهولت و قابلیت شخصی سازی سرویسها در سطح بهتری باشند رابطه پایدارتر و مشتریان بیشتری جذب خواهند کرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; واسط کاربری:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">یکی از فاکتورهای کلیدی در جذب مشتری برای فروشگاه های آنلاین طراحی مناسب واسط کاربری و سهولت استفاده از آن است، هر چه دسترسی به کالاها و مشخصات آنها در سایت شما راحت تر باشد، امکان وفاداری مشتری به شما بیشتر خواهد بود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; یکپارچگی:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">سیستم طراحی شده هر چه به صورت مکانیزه طراحی و کار کند و نیاز به دخالت کمتری توسط انسان داشته باشد بازدهی به صورت چشمگیری افزایش یافته و به راحتی می تواند به مدیریت زمان بندی و انجام تعهدات پرداخت، لذا تهیه سیستمی که مدیریت فروش، تعاملات مالی و ارسال اعلان ها را خودکار انجام دهد می تواند به سادگی و اطمینان در عملکرد منجر شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\">&nbsp;</p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">فروشگاه اینترنتی ناپ کامرس:</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&nbsp;مقدمه:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ناپ کامرس یک راهکار متن باز مبتنی بر ASP.net و SQL Server است که با نام عمومی nop-Commerce برای اولین بار در سال 2008 با هدف ارائه خدمات به شرکتهای کوچک تا سایز متوسط رسماً ارائه شد، این محصول تا کنون بیش از 35 نسخه ارائه داده است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">توسعه ناپ کامرس در سال 2008 توسط انرو مازولنیتسین روسی آغاز شد، در نسخه اولیه عملکردهای پایه مانند پردازش سفارش، ویژگی ها، پلاگین ها، اخبار، بلاگ، پیام خصوص، فروم، مالیات و پشتیبانی خرید وجود داشت. در ژوئن 201 یک لایه دسترسی به داده های در نسخه 1.7 ارائه شد و در نهایت nopCommerce به عنوان یک راهکار میتنبی بر ASP.Net MVC در اگوست 2011 معرفی شد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بنا بر گزارش builtwith.com در سال 2017 تعداد 40.633 وب سایت از ناپ کامرس استفاده می کردند، نسخه نصبی این پکیج بیش از 1.7 میلیون بار دانلود شده است، ناپ کامرس را می توانید به صورت کاملاً رایگان دانلود، نصب و استفاده کنید. فقط برای استفاده با برند شرکت خود بدون ذکر نام ناپ کامرس (white-labelling)&nbsp; نیازمند پرداخت هزینه می باشد. تا سال 2014 برای دانلود مستندات نیازمند رایگان نبود ولی در حال حاضر رایگان است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">برای رایزنی در زمینه استفاده و کاربرد NopCommerce می توانید از فروم (https://www.nopcommerce.com/boards) استفاده کنید، در حال حاضر 107 همکار تجاری در 37 کشور دنیا، بیش از ده ها ارائه دهنده رسمی هاست ناپ کامرس، به ارائه خدمات بر بستر این محصول در زمینه توسعه، ایجاد تم های تجاری و سایر سرویسها می پردازند، به عنوان نمونه در سایت stackoverflow تعداد 750 پرسش با تگ nopCommerce موجود است. بر اساس آمار دسامبر 2015 این برنامه به 30 زبان دنیا ترجمه شده و در حال استفاده است و در 30 اکتبر 2015 اولین کنفرانس در زمینه ناپ کامرس در آمستردام هلند با عنوان NopDevDay برگزار شد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">چرا از ناپ کامرس استفاده کنیم؟</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در ادامه مواردی را بررسی می کنیم که به ادعای خود ناپ کامرس دلیل محبوبیت این زیرساخت است:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ناپ کامرس یک مثال جذاب و قابل تامل از سیستم های متن باز است که به صورت کاملاً شفاف برای انجام توسعه های جدید قابل استفاده است، این محصول از سال 2008 به صورت متمرکز و یکپارچه توسط تیمی حرفه ای توسعه و پشتیبانی می شود. در این زیر ساخت تمرکز بر ارائه نسخه های مبتنی بر کلاینت است تا تعدد مشتریان و درخواستها خللی در کارآیی فروشگاه ایجاد نکند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">علاوه بر اینکه استفاده از زیر ساخت ناپ کامرس کاملاً رایگان است، ابزارهای جانبی بسیار زیادی برای استفاده در راهکارهای متفاوت ارائه شده است. همچنین تعداد بسیار زیادی ویژگی با قابلیت پیکربندی و آپشن های مختلف ارائه شده است که می تواند نیازهای خاص هر تامین کننده ای را پاسخ دهد. شما می توانید لیست ویژگی ها را در آدرس (https://www.nopcommerce.com/featurelist.aspx) مشاهده کنید. سهولت کار برای توسعه دهندگان و طراحان سیستم: ناپ کامرس با ارائه معماری بر اساس پلاگین ها و مکانیسم ارائه تم محیطی را فراهم کرده است تا بدون نیاز به تغییر در هسته فروشگاه بتوان تغییرات مدنظر را با کمترین حاشیه اعمال کرد. قابلیتهای داخلی در زمینه مدیریت کاربران مانند:&nbsp; بازیابی کلمه عبور، احراز هویت، Open ID و ACL امکان ارائه سطوح دسترسی مطلوب. با توجه به استفاده از ASP.NET MVC تمام موارد در ناپ کامرس 100% قابل توسعه هستند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">علاوه بر آن مستندات ارائه شده در nopcommerce.com به صورت کامل در دو حوزه راهنمای کاربری و راهنمای توسعه دهندگان در اختیار است که شما می توانید در مستندات قسمت راهنمای کاربری موارد زیر را مشاهده کنید:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; روش آغاز کار</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; نصب nopCommerce</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; پیکربندی فروشگاه</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; راه اندازی فروشگاه</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; بازاریابی برای فروشگاه:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در این مستند به بررسی ابزارهای بهینه سازی فروشگاه برای بازار می پردازد، از جمله مواردی که کمک می کند آگاهی مشتریان در خصوص برند شما افزایش یابد، محرک شرکاء برای ایجاد و یا توسعه همکاریها باشد، فروشندگان را تشویق به مشارکت در فروش کرده و به مشتریان یکسری پیشنهادهای مرتبط ارائه داده و در نهایت منجر به افزایش فروش شود و در کنار افزایش فروش وفاداری مشتری به فروشگاه را نیز به همراه داشته باشد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; راهنمای فروشگاه برای نسخه های پیشین</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در طول سال وبینارها، همایشها و گردهماییهای مختلفی در خصوص ناپ کامرس در سراسر دنیا برگزار می شود که در آن بسته به همایش تیم ناپ کامرس به ارائه طرح های آتی، معرفی بیشرت امکانات ناپ کامرس و امکانات و نوآوریهای انجام شده در این بستر می پردازند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><strong><span style=\"color:#FF8C00\"><span style=\"font-family:comic sans ms,cursive\">نقشه راه و هدفگذاری ناپ کامرس:</span></span></strong></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ناپ کامرس خود را متعهد می داند در راستای ارائه بهترین راهکار تجارت الکترونیک حرکت کند، به همین دلیل بسیار مشتاق است که همواره وضعیت فعلی خود و هدفی که به سمت آن خیزبرداشته است را برای کاربران خود به صورت شفاف مشخص کند، همچنین از اهمیت تصمیم گیری کسب و کارها بر اساس ویژگیهایی که هنوز آماده نشده و در قالب نقشه راه ارائه شده، آگاهی کامل دارد، اهدافی که همواره سرلوحه توصعه ناپ کامرس است به قرار زیر می باشد:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; کارآیی و مقیاس پذیری(امکان استفاده هر کسب و کاری از این زیر ساخت)</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; استفاده از معماری با قابلیت پذیرش پلاگین های بیشتر</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; توانمدی به روز رسانی ساده تر</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ارائه تجربه کاری بهتر برای مالک فروشگاه و مشتریان</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; افزایش قابلیت پیکربندی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ارائه زیر ساختهای قابل استفاده برای سایر خدمات دهنده ها همکار</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">به صورت معمول هر 6 یا 7 ماه یک نسخه جدید به همراه قابلیتهای جدیدتر که بر اساس درخواستها و بازخورد از مشتریان دریافت شده است ارائه می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بخشی از ویژگیهای ناپ کامرس:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; تجارت موبایلی:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">وب سایتهای واکنشگرا یا به عبارتی ریسپانسیو نقش بسیار مهمی در تجارت روزمره دوران کنونی دارد و آمارها نشان می دهد82% از کاربران گوشیهای هوشمند در زمان گشت و گذار در اینترنت اقدام به خرید از طریق گوشیهای هوشمند خود کرده اند، لذا استفاده از سایتی که بر اساس معماری واکنش گرا طراحی شده باشد بسیار پر اهمیت است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; چندفروشگاهی:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ویژگی چند فروشگاهی می تواند برای شما این امکان را فراهم کند که به میزبانی بیش از یک فروشگاه در یک نسخه نصب شده از ناپ کامرس بپردازید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; چند فروشنده ای:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">امکان استفاده از چند فروشندگی و فروش مستقیم امکان حذف انبار را از پروسه فروش فراهم می کند، که کالاهای عرضه شده نیاز به انبارشدن و هزینه های سربار مشابه نداشته و قیمت تمام شده کمتری داشته باشند. در زمانی که ویژگی فروش مستقیم فعال شود هر محصول به فروشنده مشخص خودش ارجاع می شود که ویژگی ها آن(فروشنده) نیز به صورت کامل قابل مشاهده (توسط مشتری) می باشد. زمانیکه یک سفارش ثبت می شود، ایمیلی به فروشنده کالای مربوطه ارسال می شود که شامل جزییات سفارش مانند تعداد، رنگ و سایر جزییات درخواستی است، در اینجا فروشنده موظف است سفارش مورد نظر را به نمایندگی فروشگاه برای خریدار ارسال کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">محصولاتی که توسط چندین تامین کننده مختلف عرضه می شود می تواند از طریق فروشگاه ارائه شده و بازدید کنندگان از طریق یک سایت واحد از خدمات این فروشندگان در سراسر دنیا استفاده کنند. هر فروشنده پنل مدیریتی خاص خود را دارد که می تواند محصولات خود را مدیریت کرده، گزارش فروش خود را مشاهده و جزییات مربوط به محصولات خود را بازبینی کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ویژگی های محصولات:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">تعدد صفات موجود برای محصولات یک مزیت عمده در فروشگاه است که شما می توانید به راحتی اندازه، رنگ، قیمت، وزن، تصاویر و نحوه فروش محصول خود را مشخص کنید، امکان مقایسه مابین چند محصول، سهولت پیدا کردن محصول با شرایط دلخواه</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; سئو:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">بهینه سازی فرآیند موتورهای جستجو به دیده شدن فروشگاه و وب سایت شما در میان سایر رقبا بسیار کمک خواهد کرد، ابزارهایی&nbsp; ناپ کامرس که به این بهینگی کمک می کنند می توانند باعث افزایش بازدید سایت شما شده و حجم ترافیک ورودی به سایت شما را به نحو چشمگیری افزایش خواهد داد. به عنوان نمونه برای افزایش این بهینه سازی، مدیر فروشگاه دسترسی کامل به به تگ ها، کلمات کلیدی و بخش مدیریت URLها دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">نقشه سایت: هر دو نسخه نقشه های سایت XML, HTML&nbsp; در این فروشگاه پشتیبانی می شود، در نسخه XML یک ساختار از سایت ارائه می شود که بازدید کننده لازم نیست آن را مشاهده کند و برای ارائه اطلاعات در خصوص ساختار سایت به موتورهای جستجو کمک می کند و در مورد نقشه سایتهای مبتنی بر HTML برای استفاده توسط کاربران و سهولت دستیابی به صفحات از آن استفاده می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">میکرو دیتاها: یکسری ویژگی ها هستن که به عنوان داده های قابل خواندن برای ماشین از آنها یاد می شود و در اسناد HTML گنجانده می شوند. درج میکرودیتا در اسناد HTML می تواند مزایای زیادی داشته باشد. اولین تاثیر: ارائه اطلاعات بیشتر در مورد داده های سایت به موتورهای جستجو که می تواند به نحوه رده بندی سایت بر اساس نوع داده ها و اینکه چگونه سایت شما رده بندی و نمایش نتایج جستجو شاخص شود کمک می کند. کاربرد دوم میکرودیتا: کمک به تولید &quot;محتویات غنی&quot; است که در خروجی جستجو انجام شده اطلاعات بیشتر از داده های متداول در اختیار جستجوگر قرار می دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">یکپارچگی با گوگل آنلتیک: طراحی ناپ کامرس کاملا یکپارچه با گوگل آنلتیک است.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; بازاریابی:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ناپ کامرس ویژگیهای متنوعی برای کمپین های بازاریابی ارائه می دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">سیستم ارایه جایزه بر اساس امتیاز: در این سیستم بر اساس میزان امتیاز کسب شده توسط مشتریان در خریدهای انجام شده، تخفیف و یا خدمات جایگزین ارائه خواهد شد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">محصولات مرتبط: در هنگام درخواست خرید هر محصول توسط مشتری در وب سایت سایر محصولات مرتبط با خرید فعلی به او پیشنهاد می شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">تخفیف و کوپن: تخفیف برای محصولات می تواند در قالب مقدار ثابت و یا درصدی ارائه شود. شما می توانید یک بازه زمانی مناسب برای تسهیلات ارائه شده در سایت در نظر بگیرید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ثبت نظر در مورد محصول و رتبه بندی آن: بر اساس خرید انجام شده مشتری می تواند به اعلام نظر بپردازند تا برای خریدهای بعدی سایر مشتریان بتوانند از این تجربیات استفاده کنند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">برنامه فروش زیرمجموعه ها:&nbsp; فروش از طریق زیر مجموعه ها یکی از برنامه های متداول بازاریابی است، که در آن مالک فروشگاه به هریک بازدید کنندگان و خریداران از فروشگاه از طریق این زیر مجموعه ها به فروشگاه معرفی شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ارائه محتوا: ناپ کامرس امکان تولید محتوی براساس نوع کسب و کار شما را از طریق پشتیبانی از اخبار، بلاگ، فروم ها، صفحات سفارشی و ... فراهم می کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">خبرنامه: ناپ کامرس امکان عضویت بازدید کنندگان در خبرنامه را فراهم می کند و دارای زیر ساختی است که امکان ایجاد خبرنامه سفارشی و استفاده از کمپین های ایمیلی را برای شما فراهم می کند، همچنین شما می توانید برای ارسال خبرنامه های خود از شرکتهای واستی مانند میل چیمپ و ... که با ناپ کامرس کاملا یکپارچه است نیز استفاده کنید.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; روش های پرداخت و شرایط تحویل:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در فروشگاه ناپ کامرس امکان استفاده از مکانیزمهای محاسباتی متنوعی برای محاسبه نرخ حمل کالا فراهم است، به عنوان مثال امکان حمل رایگان کالا، محاسبه درصدی از قیمت تمام شده به عنوان هزینه حمل مثلا بر اساس وزن کلی محصول و یا دریافت هزینه حمل بیشتر برای برخی کالاهای خاص، ارائه تخفیف در هزینه حمل محصولات و یا مشخص کردن یک رده از مشتریان خاص و تحویل رایگان کالا به این افراد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">انحصار برخی روشهای حمل کالا و یا تخفیف های ارائه شده برای برخی کشورهای مشخص.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">آدرسها:همچنین مشتریان می توانند اقدام به ارائه دو آدرس داشته باشند یکی برای دریافت صورت حساب و دیگری برای تحویل کالا، لذا به راحتی می توانند برای ارسال هدیه برای دیگران از فروشگاه استفاده کنند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">تخمین زمان تحویل:&nbsp; ای امکان به مشتری امکان تخمین هزینه ارسال پیش از اقدام به ارسال را فراهم می کند به اینصورت که مشتری با وارد کردن آدرس دقیق ایالت و کد پستی گزینه های ممکن برای ارسال به همراه قیمت را می تواند مشاهده کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; شرایط مالیات:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">در ناپ کامرس سعی شده است که محاسبه مالیات به صورت منعطف و به نحوی ارائه شده باشد که بتواند حالتهای مختلف قانونی حاکم بر کسب و کار شما را پشتیبانی کند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">لیست برخی از امکانات مالیاتی:</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; پیکربندی مالیات بر اساس شهر، ایالت و منطقه</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; تفکیک محصولات به دو نوع دارای مالیات و بدون مالیات</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; طبقه بندی مالیاتی بر اساس محصولات متفاوت</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; تعیین برخی از مشتریها به صورت معاف از مالیات</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; امکان نمایش محصولات با و بدون مالیات</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&nbsp;خدمات مشتریان</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">ناپ کامرس ابزار مناسبی برای ارائه سرویس به مشتریان با ارزش شما است و می تواند خدمات زیر را در این راستا ارائه دهد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; تصدیق خارجی: به مشتریان این امکان را خواهد داد تا با حساب کاربری توییتر، فیس بوک و به صورت OpenID به حساب خود وارد شوند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; لیست علاقمندیها: کمک به ذخیره سازی علاقمندیهای خود برای خرید در زمان های آتی</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; پشتیبانی از زبانهای راست به چپ</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left: 0in; margin-right: 0in;\"><span style=\"font-size:18px\"><span style=\"font-family:comic sans ms,cursive\">&bull;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; و بسیاری کاربردهای دیگر</span></span></p>','/app/articles/1545891292233.jpg','/app/articles/1545891294633.jpg','فروش اینترنتی,فروش مواد شیمیایی,فروشگاه اینترنتی,اینترنت,Amazon MAG','فروشگاه-اینترنتی-چیست',641,2,1,'2018-12-27 09:44:54','2022-01-11 17:31:02'),(52,4,'مزایای فروشگاه اینترنتی چیست؟','امروزه با رشد روزافزون فناوری، شکل تجارت و تعاملاتِ فعالیت‌های تجاری با مشتریان به کلی تغییر کرده است. فناوری و به‌خصوص رونق اینترنت،','<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#0000FF\"><span style=\"font-size:22px\"><span style=\"font-family:comic sans ms,cursive\">مزایای فروشگاه اینترنتی چیست؟</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">امروزه با رشد روزافزون فناوری، شکل تجارت و تعاملاتِ فعالیت&zwnj;های تجاری با مشتریان به کلی تغییر کرده است. فناوری و به&zwnj;خصوص رونق اینترنت، باعث شده است کسب&zwnj;و&zwnj;&zwnj;کارهای جدیدی به&zwnj;وجود بیایند و خیلی از کسب&zwnj;و&zwnj;کارهای سنتی هم تغییر شکل بدهند و به استفاده از اینترنت روی بیاورند. در این مقاله می&zwnj;خواهیم مزایای فروشگاه اینترنتی را بررسی کنیم و ببینیم تبدیل شدنِ فروشگاه سنتی به فروشگاه اینترنتی چه فوایدی دارد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">سؤالی که ممکن است برای خیلی از شما پیش بیاید این است: چرا باید شرکت سُنتی خودم را به شرکت اینترنتی تبدیل کنم؟</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">ابتدا، اجازه دهید مطلبی را روشن کنیم. در این مقاله، منظور ما از &laquo;شرکت سنتی&raquo;، شرکتی است که در مکانی فیزیکی واقع شده و فروشش یا از طریق حضور مشتریان صورت می&zwnj;گیرد یا از طریق ایمیل و تلفن. در کل، منظور ما شرکتی است که فروش اینترنتی ندارد. البته، روز&zwnj;به&zwnj;روز از تعداد این شرکت&zwnj;ها کاسته شده و به شرکت&zwnj;های اینترنتی اضافه می&zwnj;شود.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">اگر شما هم صاحب کسب&zwnj;و&zwnj;کاری هستید، حتما خیلی درباره&zwnj;ی مزایای تبدیل کسب&zwnj;و&zwnj;کار خود به کسب&zwnj;و&zwnj;کار الکترونیکی شنیده&zwnj;اید. شاید این کار به نظر خیلی از افراد خطرناک یا پیچیده باشد. اما فواید زیادی در فروش یا فعالیت تجاری آنلاین وجود دارد. در ادامه&zwnj;ی مقاله به ۹ مورد از مهم&zwnj;ترین مزایای فروشگاه اینترنتی اشاره خواهیم کرد.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">۱. حضور در اینترنت، تصویر بهتری از شرکت&zwnj;تان ارائه می&zwnj;دهد</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-family:comic sans ms,cursive\"><span style=\"font-size:18px\">فقط همین دلیل می&zwnj;تواند برای راه&zwnj;اندازی یک وب&zwnj;سایت جدید و شروع فروش اینترنتی کافی باشد. بدون داشتن وب&zwnj;سایت، وبلاگ یا هر نوع حضور اینترنتی، مشتریان نمی&zwnj;توانند متوجه شوند شما چقدر در کارتان جدی هستید. امروزه، شرکت&zwnj;های کوچک و بزرگ در هر صنعتی که باشند، سعی می&zwnj;کنند حضور پُررنگی در اینترنت داشته باشند.</span></span></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><strong><span style=\"color:#FF8C00\"><span style=\"font-size:20px\"><span style=\"font-family:comic sans ms,cursive\">۲. دسترسی به خدمات شرکت شما ۲۴ ساعته می&zwnj;شود</span></span></span></strong></p>\r\n\r\n<p dir=\"RTL\" style=\"margin-left:0in; margin-right:0in; text-align:justify\"><span style=\"font-f