<?php if(isset($order)): ?>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span>
        </button>
        <h4 class="modal-title" id="myModalLabel">سفارش شماره: <?php echo e(convert($order->id)); ?>

        </h4>
    </div>
    <div class="modal-body">
        <div class="mt-comments">
            <div class="mt-comment">
                <div class="mt-comment-img">
                    <img src="/CRM_Assets/assets/layouts/layout/img/online_order_icon.png"> </div>
                <div class="mt-comment-body">
                    <div class="mt-comment-info">
                        <span class="mt-comment-author"></span>
                        <span class="mt-comment-date"></span>
                    </div>
                    <div class="mt-comment-text" style="line-height: 2">
                        <div id="primary-info">
                            <span>کاربر :  </span>
                            <b><?php echo e($order->Address->User->fname); ?> <?php echo e($order->Address->User->lname); ?> - (<?php echo e($order->Address->User->mobile); ?>)</b>
                            <span> / </span>
                            <span>جنسیت :  </span>
                            <b><?php echo e($order->Cart->User->gender == 1? 'مرد':'زن'); ?> </b>
                            <br>
                            <span>سبد خرید شماره :  </span>
                            <b><?php echo e(convert($order->cart_id)); ?></b>
                            <?php if($mode != 0): ?>
                            <br>
                            <span>شناسه واریز موفق : </span>
                            <b><?php echo e(convert($order->transaction_id)); ?></b>
                                <span> / </span>
                                <span>شناسه واریز بانک : </span>
                                <b><?php echo e(convert($order->Transaction->transaction_id)); ?></b>
                            <?php endif; ?>
                        </div>
                        <hr>
                        
                        <div id="address-info">
                            <span>استان :  </span>
                            <b><?php echo e($order->Address->state); ?></b>
                            <span> / </span>
                            <span>شهر :  </span>
                            <b><?php echo e($order->Address->city); ?></b>
                            <span> / </span>
                            <span>کد پستی :  </span>
                            <b><?php echo e(convert($order->Address->postal_code)); ?></b>
                            <br>
                            <span>شماره تلفن :  </span>
                            <b><?php echo e(convert($order->Address->tell)); ?></b>
                            <span> / </span>
                            <span>شماره تماس ضروری :  </span>
                            <b><?php echo e(convert($order->Address->urgent_phone_no)); ?></b>
                            <br>
                            <span>آدرس : </span>
                            <b><?php echo e($order->Address->address); ?></b>
                        </div>
                        <hr>
                        
                        <div id="paycheck-info">
                            <span>بهای تمام شده سبد خرید : </span>
                            <b><?php echo e(convert(priceFormat($order->package_price))); ?></b>
                            <span>تومان</span>
                            <span> / </span>
                            <span>هزینه پستی دریافت شده : </span>
                            <b><?php echo e(convert(priceFormat($order->shipment_price))); ?></b>
                            <span>تومان</span>
                            <br>
                            <span>کل : </span>
                            <b><?php echo e(convert(priceFormat($order->total))); ?></b>
                            <span>تومان</span>
                            <span> / </span>
                            <span>کد تخفیف : </span>
                            <?php if(!is_null($order->discount_code_id)): ?>
                                <b> شناسه <?php echo e($order->discount_code_id); ?></b>
                                <span> / </span>
                                <span>میزان تخفیف : </span>
                                <b><?php echo e(convert(priceFormat($order->discount))); ?></b>
                                <span>تومان</span>
                            <?php else: ?>
                                <b>ندارد</b>
                            <?php endif; ?>
                            <br>
                            <?php if($mode == 0): ?>
                            <span>مبلغ قابل پرداخت : </span>
                            <?php else: ?>
                                <span>مبلغ پرداخت شده : </span>
                                <?php endif; ?>
                            <b><?php echo e(convert(priceFormat($order->payable_price))); ?></b>
                            <span>تومان</span>
                        </div>
                        <hr>
                        <?php if($mode == 4 || $mode == 5): ?>
                            <div id="post-info">
                                <span>نوع ارسال : </span>

                                <?php if($order->PostLog->type == 0): ?>
                                    <b><i class="fa fa-gift" style="color:#ff2843; border: 1px solid #ff2843;border-radius: 50%;padding: 4px"></i> پستی </b>
                                    <span> / </span>
                                    <span>کد مرصوله : </span>
                                    <b><?php echo e($order->PostLog->post_code); ?></b>
                                <?php else: ?>
                                    <b> <i class="fa fa-motorcycle" style="color:#ff2843; border: 1px solid #ff2843;border-radius: 50%;padding: 4px"></i> پیک </b>
                                <?php endif; ?>
                                <span> / </span>
                                <span>هزینه ارسال واقعی: </span>
                                <b><?php echo e(priceFormat($order->PostLog->price)); ?></b> تومان
                            </div>
                            <hr>
                        <?php endif; ?>
                        
                        <div id="product-info"></div>
                        <span>کالاهای این سفارش : </span>
                        <br>
                        <ul>
                            <div class="table-responsive" style="margin-right: -60px;">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                    <tr>
                                        <th class="text-center"> کد کالا</th>
                                        <th class="text-center">نام</th>
                                        <th class="text-center">تعداد</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $order->Cart->CartProduct()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($cart_product->ProductColor->code); ?> </td>
                                            <td class="text-center"><?php echo e($cart_product->ProductColor->Product->name); ?></td>
                                            <td class="text-center">
                                                <?php echo e(convert($cart_product->qty)); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
