<script>

    var data = JSON.parse('<?php echo $data; ?>');
    var categories = JSON.parse('<?php echo $categories; ?>');

    Highcharts.chart('<?php echo e($chart_id); ?>', {
        chart: {
            type: 'column'
        },
        title: {
            text: '<?php echo e($chart_title); ?>'
        },
        subtitle: {
            text: '<?php echo e($chart_sub_title); ?>'
        },
        xAxis: {
            categories: categories,
            crosshair: true
        },
        yAxis: {
            min: 0,
            title: {
                text: '<?php echo e($yAxisTitle); ?>'
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            '<td style="padding:0"><b> <?php echo e($unit); ?> </b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        series: data
    });
</script>