

<?php $__env->startSection('head'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('vendor/smsir/css/smsir-rtl.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/smsir/css/style.css')); ?>">
    <title>سوابق ارسال پیامک</title>
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pageBar'); ?>
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>انبار</span>
    </li>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="glyphicon glyphicon-envelope" style="font-size: 1em"></i>
                        <span class="caption-subject bold uppercase">سوابق ارسال پیامک</span>
                    </div>
                    <div class="pull-left">
                        <button type="button" data-toggle="tooltip" class="btn btn-danger"  data-original-title="موجودی"><h5>موجودی: <?php echo e($credit); ?> پیامک </h5></button>
                        <a target="_blank" href="https://www.sms.ir/" data-toggle="tooltip" class="btn btn-primary"  data-original-title="sms.ir"><h5>افزایش موجودی </h5></a>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="container">
                        <div class="panel-heading">
                            <div class="row">
                                <div class="col col-xs-6">
                                    <h3 class="panel-title">پیامک های ارسالی توسط وب سایت</h3>
                                </div>
                            </div>
                        </div>
                        <div class="panel-body" >
                            <table class="table table-striped table-bordered table-list">
                                <thead>
                                <tr>
                                    <th>ردیف</th>
                                    <th>وضعیت</th>
                                    <th>وضعیت ارسال</th>
                                    <th>شماره موبایل</th>
                                    <th>متن ارسالی</th>
                                    <th>ارسال از طریق</th>
                                    <th>زمان ارسال</th>
                                    <th><em class="fa fa-cog"></em></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $smsir_logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo $log->sendStatus(); ?></td>
                                        <td><?php echo e($log->response); ?></td>
                                        <td><?php echo e($log->to); ?></td>
                                        <td><?php echo e($log->message); ?></td>
                                        <td><?php echo e($log->from); ?></td>
                                        <td><?php echo e(persianDiffForHumans($log->created_at)); ?></td>
                                        <td align="center">
                                            <a onclick="return confirm('حذف شود؟')" href="<?php echo e(route('deleteLog',['log'=>$log])); ?>" class="btn btn-danger"><em class="fa fa-trash"></em></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="panel-footer">
                            <div class="row">
                                <?php echo e($smsir_logs->links()); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="/jq-confirm/jquery-confirm.min.js"></script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>