<?php $__env->startSection('head'); ?>
    <link href="<?php echo e(asset('CRM_Assets/highcharts/highcharts.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('CRM_Assets/highcharts/custom-highcharts.css')); ?>" rel="stylesheet">

    <script src="<?php echo e(asset('CRM_Assets/highcharts/highcharts.js')); ?>"></script>
    <script src="<?php echo e(asset('CRM_Assets/highcharts/exporting.js')); ?>"></script>


    <!--[if lt IE 9]>
    <script src="<?php echo e(asset('CRM_Assets/highcharts/oldie.js')); ?>"></script>
    <![endif]-->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('pageBar'); ?>
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>آمار و نمودارها</span>
    </li>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="page-title"> بخش آمار
        <br>
        <small>آمار، ارقام، گزارشات اخیر</small>
    </h1>
    <div class="clearfix"></div>
    <!-- END DASHBOARD STATS 1-->
    <div class="row">
        <div class="col-lg-12 col-xs-12 col-sm-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title tabbable-line">

                    <div class="caption">
                        <i class="icon-bar-chart font-dark hide"></i>
                        <span class="caption-subject font-dark bold uppercase">آمار کالا</span>
                        <a href="<?php echo e(route('search.products.index')); ?>" class="small"><span class="caption-subject font-red">(جزئیات)</span></a>
                        <span class="caption-subject" style="font-size: 12px;">20 کالای برتر</span>
                    </div>

                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#portlet_comments_1" data-toggle="tab"><i class="fa fa-dollar"></i> پرفروشترین ماهانه</a>
                        </li>
                        <li>
                            <a href="#portlet_comments_2" data-toggle="tab"><i class="fa fa-dollar"></i> پرفروشترین سالانه</a>
                        </li>
                        <li>
                            <a href="#portlet_comments_3" data-toggle="tab"><i class="fa fa-eye"></i> پربازدیدترین ماهانه </a>
                        </li>
                        <li>
                            <a href="#portlet_comments_4" data-toggle="tab"><i class="fa fa-eye"></i> پربازدیدترین سالانه </a>
                        </li>
                    </ul>
                </div>
                <div class="portlet-body" style="height: 500px;overflow-y: scroll;">
                    <div class="tab-content">
                        <div class="tab-pane active" id="portlet_comments_1">
                            <div id="sold-count-permonth"></div>
                        </div>
                        <div class="tab-pane" id="portlet_comments_2">
                            <div id="sold-count-perYear"></div>
                        </div>
                        <div class="tab-pane" id="portlet_comments_3">
                            <div id="view-count-permonth"></div>
                        </div>
                        <div class="tab-pane" id="portlet_comments_4">
                            <div id="view-count-perYear"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END PORTLET-->
        </div>

        <div class="col-lg-12 col-xs-12 col-sm-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title tabbable-line">

                    <div class="caption">
                        <i class="icon-bar-chart font-dark hide"></i>
                        <span class="caption-subject font-dark bold uppercase">آمار جست و جو</span>
                        <span class="caption-subject" style="font-size: 12px;">20 کالای برتر</span>

                    </div>
                    <div class="pull-right">
                        <div class="btn-group-xs" style="margin-right: 5px;margin-left: 5px">
                            <a href="<?php echo e(route('searchCount.details.index')); ?>" class="btn btn-success" title="مشاهده آمار بر اساس تعداد"><i class="fa fa-pie-chart"></i> جزئیات تعداد </a>

                            <a href="<?php echo e(route('search.details.index')); ?>" class="btn btn-purple" title="مشاهده آمار براساس کل جست و جو"><i class="fa fa-line-chart"></i> جزئیات کلی </a>
                        </div>
                    </div>
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#portlet_comments_111" data-toggle="tab"><i class="fa fa-pie-chart"></i> براساس تعداد جست و جو </a>
                        </li>
                        <li>
                            <a href="#portlet_comments_222" data-toggle="tab"><i class="fa fa-bar-chart"></i> نمودار ماهانه </a>
                        </li>
                    </ul>
                </div>
                <div class="portlet-body" style="height: 500px;overflow-y: scroll;">
                    <div class="tab-content">
                        <div class="tab-pane active" id="portlet_comments_111">
                            <div id="search-count"></div>
                        </div>
                        <div class="tab-pane" id="portlet_comments_222">
                            <div id="search-statistic"></div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    
    <?php echo $__env->make('CRM.charts.chart-pie',array('chart_id' => 'search-count','chart_title' => 'نمودار تعداد جست و جو','data' => $search_count), array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo $__env->make('CRM.charts.chart-basic-columns',
    array('chart_id' => 'search-statistic','chart_title' => 'جست و جو هر کلمه','chart_sub_title' => 'بر اساس ماه (یک سال اخیر)',
    'data' => $search_logs['data'],'categories' => $months,'yAxisTitle' => 'تعداد جست و جو','unit' => 'بار {point.y}'), array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    
    <?php echo $__env->make('CRM.charts.chart-basic-columns',
       array('chart_id' => 'sold-count-permonth','chart_title' => 'فروش ماهانه','chart_sub_title' => 'بر اساس ماه (یک سال اخیر)',
       'data' => $sold_count_perMonth['data'],'categories' => $months,'yAxisTitle' => 'تعداد فروش','unit' => 'بار {point.y}'), array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo $__env->make('CRM.charts.chart-basic-columns',
       array('chart_id' => 'sold-count-perYear','chart_title' => 'فروش سالانه','chart_sub_title' => 'بر اساس سال',
       'data' => $sold_count_perYear['data'],'categories' => $years,'yAxisTitle' => 'تعداد فروش','unit' => 'بار {point.y}'), array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    
    <?php echo $__env->make('CRM.charts.chart-basic-columns',
       array('chart_id' => 'view-count-permonth','chart_title' => 'بازدید ماهانه','chart_sub_title' => 'بر اساس ماه (یک سال اخیر)',
       'data' => $view_count_perMonth['data'],'categories' => $months,'yAxisTitle' => 'تعداد بازدید','unit' => 'بار {point.y}'), array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo $__env->make('CRM.charts.chart-basic-columns',
      array('chart_id' => 'view-count-perYear','chart_title' => 'بازدید سالانه','chart_sub_title' => 'بر اساس سال',
      'data' => $view_count_perYear['data'],'categories' => $years,'yAxisTitle' => 'تعداد فروش','unit' => 'بار {point.y}'), array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>