

<?php $__env->startSection('head'); ?>
    <link href="/ui/jquery-ui.min.css" rel="stylesheet" type="text/css">
    <script src="/ui/jquery-ui.min.js"></script>

    <style>
        .col-sm-1 button{
            margin-top: 1.7em;
        }
        @media  screen and (max-width: 755px){
            .col-sm-1 button{
                margin-top: 0em;
            }
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php if(session()->has('message') && session()->has('messageType')): ?>
        <br>
        <?php if(session('messageType') == 'success'): ?>
            <div class="alert alert-success">
                <p><?php echo e(session('message')); ?></p>
            </div>
        <?php elseif(session('messageType') == 'failure'): ?>
            <div class="alert alert-danger">
                <p><?php echo e(session('message')); ?></p>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(count($errors) > 0): ?>
        <?php
            $hasError = true;
        ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php else: ?>
        <?php
            $hasError = false;
        ?>
    <?php endif; ?>

    <div class="row">
        <a href="/CRM/createBrand" class="btn btn-primary"><span class="glyphicon glyphicon-arrow-left"></span> <strong>بازگشت</strong> </a>
        <a href="/CRM/brand/delete/<?php echo e($brandId); ?>" class="btn btn-danger">حذف کل سفارش</a>
    </div>
    <h1>برند: <?php echo e($brandName); ?></h1>
    <form  method="post" action="/CRM/brand/edit">

        <div class="row">
            <p class="form-group col-sm-5">
                <label for="brand">برای ویرایش، فیلد زیر را اصلاح کنید</label>
                <input type="text" class="form-control" id="brand" name="brandName" placeholder="نام دسته بندی"
                       <?php if(!$hasError && !is_null($brandName)): ?>
                       value="<?php echo e($brandName); ?>"
                       <?php else: ?>
                       value="<?php echo e(old("brandName")); ?>"
                        <?php endif; ?> >
            </p>

            <p class="col-sm-1">
            </p>
            <hr class="visible-xs-block">
        </div>
        <input type="hidden" name="brandId" value="<?php echo e($brandId); ?>">
        <input type='submit' class='btn btn-success' name='send' id='sendBtn' value='ثبت اطلاعات'>
        <?php echo e(csrf_field()); ?>

    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>