
<?php $__env->startSection('head'); ?>
    <link href="<?php echo e(asset('CRM_Assets/assets/global/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="/ui/jquery-ui.min.css" rel="stylesheet" type="text/css">

    <script>

        $('document').ready(function () {
            $("#qty").spinner({
                min: 0,
                numberFormat: "n"
            });
        });

    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-header head-section">
        <div class="btn-group pull-left" style=" margin-right: 5px;margin-left: 19px">
            <button data-toggle="modal" data-target="#myModal" class="btn btn-sm btn-success"><span class="fa fa-plus"></span> افزودن کالا به سبد </button>
        </div>
        <div class="btn-group pull-right" style=" margin-right: 5px">
            <a href="<?php echo e(route('carts.pending.index')); ?>" class="previous-a round-a"><i class="fa fa-arrow-right"></i> بازگشت </a>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-check-square-o"></i>
            ویرایش سبد خرید <span class="title bold" style="color:#ff4f4f"><?php echo e($cart->User->fname); ?> <?php echo e($cart->User->lname); ?></span>
        </h3>
    </div>
    <div id="alerts">
        <?php echo $__env->make('errors.formAlert', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;سبد خرید شماره <?php echo e(convert($cart->id)); ?></h3>
        </div>
        <div class="panel-body">
            <table class="table table-striped table-bordered table-hover order-column dataTable no-footer" id="sample_1" role="grid" aria-describedby="sample_1_info" >
                <thead>
                <tr role="row">
                    <th class="text-center"> شناسه</th>
                    <th class="text-center"> کد</th>
                    <th class="text-center"> نام</th>
                    <th class="text-center"> تعداد</th>
                    <th class="text-center"> قیمت</th>
                    <th class="text-center"> <i class="fa fa-cart"></i></th>
                </tr>
                </thead>
                <tbody>
                <?php if(isset($cart_products)): ?>
                    <?php $__currentLoopData = $cart_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $product = \App\Models\CartProduct::getProduct($cart_product->id);
                             $productColor = $cart_product->ProductColor()->first();
                        ?>
                        <tr>
                            <td class="text-center"><?php echo e(convert($cart_product->id)); ?></td>
                            <td class="text-center"><?php echo e($productColor->code); ?></td>
                            <td class="text-center"><a href="<?php echo e($product->dashboardPath()); ?>"><?php echo e($product->name); ?></a></td>
                            <td class="text-center"><?php echo e(convert($cart_product->qty)); ?></td>
                            <td class="text-center"><?php echo e(convert(priceFormat($cart_product->discount_sell_price))); ?> تومان</td>
                            <td class="text-center">
                                <form action="<?php echo e(route('deleteCartProduct',$cart_product)); ?>" method="post">
                                    <?php echo e(csrf_field()); ?>

                                    <?php echo e(method_field('DELETE')); ?>

                                    <button type="submit" class="btn btn-xs btn-danger" data-toggle="tooltip" data-original-title="حذف"><i class="fa fa-trash-o"></i></button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal fade" id="myModal"  role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel">افزودن کالا به سبد خرید</h4>
                </div>
                <div class="modal-body" style="padding-top: 30px;">
                    <form class="form-horizontal" action="<?php echo e(route('updateCartAdmin',$cart)); ?>" method="POST">
                        <?php echo e(csrf_field()); ?>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">کالا</label>
                            <div class="col-sm-9">
                                <select class="form-control select2me"  name="productColorId" data-placeholder="انتخاب کنید..." >
                                    <option value="">انتخاب کنید...</option>
                                    <?php $__currentLoopData = $productColors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productColor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($productColor->id); ?>" <?php if(old('productColorId') == $productColor->id): ?> selected <?php endif; ?>><?php echo e($productColor->Product->name); ?> (<?php echo e($productColor->code); ?>) [<?php echo e($productColor->qty); ?> عدد]</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">تعداد</label>
                            <div class="col-sm-9">
                                <input type="number" class="form-control" id="qty" value="<?php echo e(old('qty')); ?>" name="qty" placeholder="تعداد" required>
                            </div>
                        </div>
                        <div class="modal-footer" style="text-align: center;">
                            <button type="submit" class="btn btn-primary" style="min-width: 50%">ثبت</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="/ui/jquery-ui.min.js"></script>
    <script src="<?php echo e(asset('CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js')); ?>" type="text/javascript"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <script>
        $(document).ready(function() {
            $(':input[type="number"]').keydown(function (e) {
                // Allow: backspace, delete, tab, escape, enter and .
                if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
                    // Allow: Ctrl/cmd+A
                    (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: Ctrl/cmd+C
                    (e.keyCode == 67 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: Ctrl/cmd+X
                    (e.keyCode == 88 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: home, end, left, right
                    (e.keyCode >= 35 && e.keyCode <= 39)) {
                    // let it happen, don't do anything
                    return;
                }
                // Ensure that it is a number and stop the keypress
                if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                    e.preventDefault();
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>