

<?php $__env->startSection('script'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->


    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
<?php $__env->stopSection(); ?>
<?php
    $newestItems = new \App\Models\NewestItem();
?>
<?php $__env->startSection('content'); ?>
    <div class="portlet light bordered main">
        <?php echo $__env->make('CRM.Admin.section.errors', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>

    <div class="col-md-12">
        <div class="panel panel-default">

            <div class="panel-heading">
                <h3 class="panel-title FarsiFont "><i class="fa fa-list"></i>&nbsp;مدیریت دسته بندی مقالات</h3>
            </div>
            <?php if(Auth::user()->can(['همه','مقالات','ثبت دسته بندی مقالات'])): ?>
            <div class="panel-heading">
                <h3 class="panel-title FarsiFont">
                    <a class="btn btn-success text-white" href="<?php echo e(route('articleCategory.create')); ?>">ثبت دسته جدید</a>
                </h3>
            </div>
            <?php endif; ?>
            <div class="panel-body">
                <div class="table">
                    <table class="table table-striped table-bordered table-hover order-column dataTable no-footer"
                           id="sample_1" role="grid" aria-describedby="sample_1_info">
                        <thead>
                        <tr role="row">
                            <th class="sorting_disable text-center" style="width: 10px;" aria-label=""><i
                                        class="fa fa-gears"></i></th>
                            <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=""> زمان ایجاد
                            </th>

                            <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label="نام">نام
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr role="row" class="success">

                                <td>
                                    <div class="btn-group">
                                        <button class="btn btn-xs btn-danger dropdown-toggle bold" type="button"
                                                data-toggle="dropdown" aria-expanded="false">
                                            <i class="fa fa-gears"></i>
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li>
                                                <a href="<?php echo e(route('articleCategory.edit',$category->id)); ?>">
                                                    <i class="fa fa-file-text" style="color:#5E6EDD "></i> ویرایش </a>
                                            </li>

                                            <li>
                                                <form class="form-horizontal" method="POST" action="<?php echo e(route('articleCategory.destroy',$category->id)); ?>" role="form">
                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <?php echo e(csrf_field()); ?>

                                                    <button style="text-align: right;background: none;border: none" type="submit" class="text-danger col-md-12 text-right">
                                                        <i class="fa fa-minus-circle" style="color:#ED6B75 "></i> حذف
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>
                                <td style="width: 90px" class="text-center">
                                    <?php echo e(convert(jDate::forge($category->created_at)->format('datetime'))); ?>

                                </td>

                                <td style="text-decoration: none;font-weight: bold;"
                                    class="text-center"><?php echo e($category->name); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>




<?php $__env->stopSection(); ?>
<?php $__env->startSection('head'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    <?php if(alert()->ready()): ?>
        <script>
            $(document).ready(function () {
                swal({
                    title: "<?php echo alert()->message(); ?>",
                    text: "<?php echo alert()->option('text'); ?>",
                    type: "<?php echo alert()->type(); ?>",
                    <?php if(alert()->option('timer')): ?>
                    timer: "<?php echo alert()->option('timer'); ?>",
                    showConfirmButton: false,
                    <?php endif; ?>
                });
            })
        </script>
    <?php endif; ?>


    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>