
<?php $__env->startSection('head'); ?>

    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="page-header head-section">
                <div class="pull-left" style="margin-left: 19px">
                    <button type="button" data-toggle="tooltip" id="delete_all"  class="btn btn-danger" onclick="" data-original-title="حذف"><i class="icon-trash"></i></button>
                    <a class="btn btn-info" data-toggle="modal" title="جدید" data-target="#myModal" ><i class="icon-plus"></i></a>
                </div>
                <div>
                    <a href="<?php echo e(route('filterTitles.show' , ['id' => $filterTitle->Category->id ])); ?>" class="btn previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span><strong> بازگشت </strong> </a>
                </div>
                <h3 style="text-align: center">
                    <i class="fa fa-filter"></i>
                    گزینه های فیلتر " <span class="title bold" style="color:#ff4f4f"><?php echo e($filterTitle->name); ?></span> "
                </h3>
            </div>
            <div id="alerts">
                <?php echo $__env->make('errors.formAlert', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت گزینه ها</h3>
                </div>
                <div class="panel-body">
                    <div class="table"  id="table_content">
                        <?php echo $__env->make('CRM.SiteFront.filters.includeOptionsTable', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel">ایجاد گزینه جدید</h4>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal" action="<?php echo e(route('options.store')); ?>" role="form" method="POST" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" class="form-control" id="title_id" name="title_id" value="<?php echo e($filterTitle->id); ?>">
                        <div class="form-group">
                            <label class="col-sm-3 control-label">عنوان گزینه</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="name" name="name" placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">کلید واژه فنی</label>
                            <div class="col-sm-9">
                                <select class="form-control select2me tec_code" name="tec_code" data-placeholder="انتخاب کنید..." >
                                    <option value="">انتخاب کنید...</option>
                                    <?php $__currentLoopData = $tecInfoKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tecInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tecInfo->code); ?>" <?php if(old('tec_code') == $tecInfo->code): ?> selected <?php endif; ?>><?php echo e($loop->iteration); ?> - <?php echo e($tecInfo->tec_info_key); ?> (<?php echo e($tecInfo->code); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">مقدار مشخصات فنی</label>
                            <div class="col-sm-9">
                                <select class="form-control select2me" id="tec_id" name="tec_id" data-placeholder="انتخاب کنید...">
                                    <option value="">انتخاب کنید...</option>

                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">ترتیب</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="priority" name="priority" placeholder="ترتیب">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">وضعیت</label>
                            <div class="col-sm-9">
                                <input type="radio" name="status" id="status" value="1" style="margin-right: 30px;">&nbsp;فعال
                                <input type="radio" name="status" id="status" value="0" style="margin-right: 50px;"> غیر فعال
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-green">ثبت</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>


    <input type="hidden" name="title_id" id="title" value="<?php echo e($filterTitle->id); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <!-- END PAGE LEVEL SCRIPTS -->
    <script src="/jq-confirm/jquery-confirm.min.js"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <script>
        //---------------Delete -----------------//
        $(document).on('click', '#delete_all', function () {
            var selected = new Array();
            $("input:checkbox[name*=selected]:checked").each(function(){
                selected.push($(this).val());
            });
            if($.isEmptyObject(selected)){
                swal({
                    title: "تایید نشد",
                    text: 'لطفا یک فیلتر برای حذف انتخاب کنید',
                    type: "warning",
                    timer: 1200,
                    showConfirmButton: false
                });
            }else{
                $.confirm({
                    title: 'حذف فیلتر ها',
                    content: 'آیا مطمئن هستید؟',
                    buttons: {
                        somethingElse: {
                            text: 'تایید',
                            btnClass: 'btn-blue',
                            action: function () {
                                $.ajax({
                                    url     : "<?php echo e(route('options.delete')); ?>",
                                    type    :"POST",
                                    cash    : false,
                                    data    :{ data : selected,title_id:$('#title').val(),_token:$('#token').val()},
                                    success: function(response2) {
                                        $('#myModal').modal('hide');
                                        swal({
                                            title: "حذف شد",
                                            text: "فیلتر ها با موفقیت حذف شد",
                                            type: "success",
                                            timer: 1000,
                                            showConfirmButton: false
                                        });
                                        $("#table_content").html(response2);
                                    }
                                });
                            }
                        },
                        somethingElse2: {
                            text: 'خیر',
                            btnClass: 'btn-red',
                            action: function () {
                                swal({
                                    title: "تایید نشد",
                                    type: "info",
                                    timer: 1000,
                                    showConfirmButton: false
                                });
                            }
                        }
                    }
                });
            }
        });


        $(document).on('change', '.tec_code', function () {
            var tec_code = $(this).val();
            $.ajax({
                url     : "<?php echo e(route('get.tec.values')); ?>",
                type    :"get",
                cash    : false,
                data    :{ tec_code : tec_code},
                success: function(response) {
                    $('#tec_id').empty().append($("<option value=\"\">انتخاب کنید...</option>"));
                    $.each( response, function(key,value) {
                        $('#tec_id')
                            .append($("<option>"+ (key+1) +"- "+value.value +" ("+ value.tec_id +")</option>")
                                .attr({
                                    value:value.tec_id
                                }));
                    });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>