<script type="text/javascript">
    $(document).on('click', ".view-order", function () {
        var id = $(this).attr('data-content');
        var mode = $(this).attr('data-title');
        $.ajax({
            url: "<?php echo e(route('order.view')); ?>",
            type: "GET",
            data: {id: id,mode : mode},
            success: function (data) {

                $("#modal-container").html(data);
            },
            error: function (xhr) {
                var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.
                var info = $('#alerts');
                swal({
                    title: "خطا",
                    text: " با خطا مواجه شد",
                    type: "error",
                    timer: 1500
                });
                info.hide().empty();
                var html = '<div class="alert alert-danger"><ul>';
                $.each(error.errors, function (k, v) {
                    html += '<li>' + v[0] + '</li>';
                });
                html += '<\div><ul>';
                info.append(html);
                info.slideDown();
            }
        });

    });

    $(document).on('click', ".approve-order", function () {
        var id = $(this).attr('data-content');
        var mode = $(this).attr('data-title');
        var city = $(this).attr('data-option');

        if(mode == 3){
//            if(city == 'ارومیه'){
//                $('#order_id_peyk').val(id);
//                $('#myModalPeyk').modal('show');
//            }else {
                $('#order_id').val(id);
                $('#myModalPost').modal('show');
//            }

        }else{
            $.confirm({
                title: 'تایید این مرحله و انتقال به مرحله بعد',
                content: 'آیا مطمئن هستید؟',
                buttons: {
                    somethingElse: {
                        text: 'تایید',
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                url: "<?php echo e(route('changeOrders')); ?>",
                                type: "POST",
                                data: {id: id, mode: mode, _token: $('#token').val()},
                                success: function (data) {
                                    $("#table").html(data);
                                    $('#myModalEye').modal('hide');
                                    swal({
                                        title: "انتقال یافت",
                                        text: "سفارش با موفقیت تایید و مرحله بعد انتفال یافت",
                                        type: "success",
                                        showConfirmButton: false,
                                        timer: 1500
                                    });
                                },
                                error: function (xhr) {
                                    var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.
                                    var info = $('#alerts');
                                    swal({
                                        title: "خطا",
                                        text: " با خطا مواجه شد",
                                        type: "error",
                                        timer: 1500
                                    });
                                    $('#myModalEye').modal('hide');
                                    info.hide().empty();
                                    var html = '<div class="alert alert-danger"><ul>';
                                    $.each(error.errors, function (k, v) {
                                        html += '<li>' + v[0] + '</li>';
                                    });
                                    html += '<\div><ul>';
                                    info.append(html);
                                    info.slideDown();
                                }
                            });
                        }
                    },
                    somethingElse2: {
                        text: 'خیر',
                        btnClass: 'btn-red',
                        action: function () {
                            swal({
                                title: "تایید نشد",
                                text: "",
                                type: "warning",
                                timer: 1500
                            });
                        }
                    }
                }
            });
        }
    });
</script>

<?php if(alert()->ready()): ?>
    <script>
        swal({
            title: "<?php echo alert()->message(); ?>",
            text: "<?php echo alert()->option('text'); ?>",
            type: "<?php echo alert()->type(); ?>",
            <?php if(alert()->option('timer')): ?>
            timer: "<?php echo alert()->option('timer'); ?>",
            showConfirmButton: false,
            <?php else: ?>
            showConfirmButton: true,
            confirmButtonText :'باشه',
            <?php endif; ?>
        });
    </script>
<?php endif; ?>