
<?php $__env->startSection('head'); ?>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="page-header head-section">
                <div>
                    <a href="<?php echo e(route('options.show' , ['id' => $option->FilterTitle->id ])); ?>" class="btn previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span><strong> بازگشت </strong> </a>
                </div>
                <h3 style="text-align: center">
                    <i class="fa fa-filter"></i>
                    ویرایش " <span class="title bold" style="color:#ff4f4f"><?php echo e($option->name); ?></span> "
                </h3>
            </div>
            <div id="alerts">
                <?php echo $__env->make('errors.formAlert', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
            <div class="panel panel-default">
                <div class="panel-body">
                    <form class="form-horizontal" action="<?php echo e(route('options.update',$option)); ?>" role="form" method="POST" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <?php echo e(method_field('PATCH')); ?>

                        <div class="form-group">
                            <label class="col-sm-3 control-label">عنوان گزینه</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="name" placeholder="عنوان" value="<?php echo e(old('name',$option->name)); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">کلید واژه فنی</label>
                            <div class="col-sm-9">
                                <select class="form-control select2me tec_code" name="tec_code" data-placeholder="انتخاب کنید..." >
                                    <option value="">انتخاب کنید...</option>

                                    <?php $__currentLoopData = $tecInfoKeys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tecInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tecInfo->code); ?>" <?php if( old('tec_code',$option->tec_code) == $tecInfo->code): ?> selected <?php endif; ?>><?php echo e($loop->iteration); ?> - <?php echo e($tecInfo->tec_info_key); ?> (<?php echo e($tecInfo->code); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">مقدار مشخصات فنی</label>
                            <div class="col-sm-9">
                                <select class="form-control select2me" id="tec_id" name="tec_id" data-placeholder="انتخاب کنید...">
                                    <option value="">انتخاب کنید...</option>
                                    <?php $__currentLoopData = $tecInfoValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value->tec_id); ?>" <?php if( old('tec_id',$option->tec_id) == $value->tec_id): ?> selected <?php endif; ?>><?php echo e($loop->iteration); ?> - <?php echo e($value->value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">ترتیب</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="priority" placeholder="ترتیب" value="<?php echo e(old('priority',$option->priority)); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">وضعیت</label>
                            <div class="col-sm-9">
                                <input type="radio" name="status" id="status" value="1" style="margin-right: 30px;" <?php if(old('status',$option->status) === 1): ?> checked <?php endif; ?>>&nbsp;فعال
                                <input type="radio" name="status" id="status" value="0" style="margin-right: 50px;" <?php if(old('status',$option->status) === 0): ?> checked <?php endif; ?>> غیر فعال
                            </div>
                        </div>
                        <div class="modal-footer" style="text-align: center;">
                            <button type="submit" class="btn btn-success" style="width: 30%;">ثبت</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <script>
        $(document).on('change', '.tec_code', function () {
            var tec_code = $(this).val();
            $.ajax({
                url     : "<?php echo e(route('get.tec.values')); ?>",
                type    :"get",
                cash    : false,
                data    :{ tec_code : tec_code},
                success: function(response) {
                    $('#tec_id').empty().append($("<option value=\"\">انتخاب کنید...</option>"));
                    $.each( response, function(key,value) {
                        $('#tec_id')
                            .append($("<option>"+ (key+1) +"- "+value.value +" ("+ value.tec_id +")</option>")
                                .attr({
                                    value:value.tec_id
                                }));
                    });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>