
<?php $__env->startSection('head'); ?>

    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="page-header head-section">
                <div class="pull-left" style="margin-left: 19px">
                    <button type="button" data-toggle="tooltip" id="delete_all"  class="btn btn-danger" onclick="" data-original-title="حذف"><i class="icon-trash"></i></button>
                    <a class="btn btn-info" data-toggle="modal" title="جدید" data-target="#myModal" ><i class="icon-plus"></i></a>
                    <button id="edit_btn" type="button" data-toggle="tooltip"  class="btn btn-warning"  data-original-title="ویرایش"><i class="fa fa-edit"></i></button>
                </div>
                <div>
                    <a href="<?php echo e(route('filterTitles.index')); ?>" class="btn previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span><strong> بازگشت </strong> </a>
                </div>
                <h3 style="text-align: center">
                    <i class="fa fa-check-square-o"></i>
                    فیلتر های دسته بندی <span class="title bold" style="color:#ff4f4f"><?php echo e($category->category); ?></span> "
                </h3>
            </div>
            <div id="alerts">
                <?php echo $__env->make('errors.formAlert', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت عنوان ها</h3>
                </div>
                <div class="panel-body">
                    <div class="table"  id="table_content">
                        <?php echo $__env->make('CRM.SiteFront.filters.includeTitlesTable', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Add Modal -->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel">ایجاد فیلتر جدید</h4>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal" id="uploadForm" action="<?php echo e(route('filterTitles.store')); ?>" role="form" method="POST" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="category_id" value="<?php echo e($category->id); ?>">
                        <div class="form-group">
                            <label class="col-sm-3 control-label">عنوان</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="name" name="name" placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">ترتیب</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="priority" name="priority" placeholder="ترتیب">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">وضعیت</label>
                            <div class="col-sm-9">
                                <input type="radio" name="status" id="status" value="1" style="margin-right: 30px;">&nbsp;فعال
                                <input type="radio" name="status" id="status" value="0" style="margin-right: 50px;"> غیر فعال
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-green">ثبت</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <!-- Modal Edit -->
    <div class="modal fade" id="myModalEdit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel">ویرایش فیلتر</h4>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal" id="edit_uploadForm"  role="form" method="POST" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden"  id="edit_id" name="id">
                        <input type="hidden" name="category_id" value="<?php echo e($category->id); ?>">
                        <div class="form-group">
                            <label class="col-sm-3 control-label">عنوان</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="edit_name" name="name" placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">ترتیب</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="edit_priority" name="priority" placeholder="ترتیب">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">وضعیت</label>
                            <div class="col-sm-9">
                                <input type="radio" name="status" id="edit_status_1" value="1" style="margin-right: 30px;">&nbsp;فعال
                                <input type="radio" name="status" id="edit_status_0" value="0" style="margin-right: 50px;"> غیر فعال
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-green">ثبت</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->

    <input type="hidden" name="cat" id="cat" value="<?php echo e($category->id); ?>">


<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <!-- END PAGE LEVEL SCRIPTS -->
    <script src="/jq-confirm/jquery-confirm.min.js"></script>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <script>
        //---------------edit Show-----------------//
        $(document).ready(function() {
            $("#edit_btn").click(function () {

                var select = new Array();
                $("input:checkbox[name*=selected]:checked").each(function(){
                    select.push($(this).val());
                });

                if($.isEmptyObject(select)){
                    swal({
                        title: "توجه",
                        text: "لطفا یک عنوان فیلتر برای ویرایش انتخاب کنید",
                        type: "info",
                        showConfirmButton: true,
                        confirmButtonText :'باشه'
                    });
                }else{
                    if(select.length > 1){
                        swal({
                            title: "توجه",
                            text: "لطفا بیش از یک عنوان فیلتر برای ویرایش انتخاب نکنید",
                            type: "info",
                            showConfirmButton: true,
                            confirmButtonText :'باشه'
                        });
                    }
                    else
                    {
                        $.ajax({
                            url     : "<?php echo e(route('filterTitles.get')); ?>",
                            type    :"POST",
                            cash    : false,
                            data    :{ data : select,_token:$('#token').val()},
                            success: function(response) {
                                $('#edit_id').val(response['id']);
                                $('#edit_name').val(response['name']);
                                $('#edit_priority').val(response['priority']);
                                if(response['status'] === 1){
                                    $('#edit_status_1').prop('checked', true);
                                }else{
                                    $('#edit_status_0').prop('checked', true);
                                }
                                $("#myModalEdit").modal();
                            }
                        });
                    }
                }

            });
        });
        //---------------Delete -----------------//
        $(document).on('click', '#delete_all', function () {
            var selected = new Array();
            $("input:checkbox[name*=selected]:checked").each(function(){
                selected.push($(this).val());
            });
            if($.isEmptyObject(selected)){
                swal({
                    title: "تایید نشد",
                    text: 'لطفا یک عنوان برای حذف انتخاب کنید',
                    type: "warning",
                    confirmButtonText :'باشه',
                    showConfirmButton: true
                });            }else{
                $.confirm({
                    title: 'حذف عنوان فیلتر ها',
                    content: 'آیا مطمئن هستید؟',
                    buttons: {
                        somethingElse: {
                            text: 'تایید',
                            btnClass: 'btn-blue',
                            action: function () {
                                $.ajax({
                                    url     : "<?php echo e(route('filterTitles.delete')); ?>",
                                    type    :"POST",
                                    cash    : false,
                                    data    :{ data : selected,cat:$('#cat').val(),_token:$('#token').val()},
                                    success: function(response2) {
                                        $('#myModal').modal('hide');
                                        swal({
                                            title: "حذف شد",
                                            text: "عنوان فیلتر با موفقیت حذف شد",
                                            type: "success",
                                            timer: 1000,
                                            showConfirmButton: false
                                        });
                                        $("#table_content").html(response2);
                                    }
                                });
                            }
                        },
                        somethingElse2: {
                            text: 'خیر',
                            btnClass: 'btn-red',
                            action: function () {
                                swal({
                                    title: "تایید نشد",
                                    type: "info",
                                    timer: 1000,
                                    showConfirmButton: false
                                });
                            }
                        }
                    }
                });
            }
        });

        //---------------Store-----------------//
        $("#uploadForm").on('submit',(function(e) {
            var formdata = new FormData(this);

            $.ajax({
                url: "<?php echo e(route('filterTitles.store')); ?>",
                type: "POST",
                data: formdata ,
                beforeSend: function(){$("#body-overlay").show();},
                contentType: false,
                processData:false,
                success: function(data)
                {
                    $('#myModal').modal('hide');
                    swal({
                        title: "ذخیره شد",
                        text: "عنوان با موفقیت ذخیره شد",
                        type: "success",
                        timer: 1100,
                        showConfirmButton: false
                    });
                    $("#table_content").html(data);
                },
                error: function(xhr) {
                    var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.
                    var info = $('#alerts');
                    info.hide().empty();
                    var html = '<div class="alert alert-danger"><ul>';
                    $.each( error.errors, function( k,v ) {
                        html+=  '<li>'+v[0]+'</li>';
                    });
                    html += '<\div><ul>';
                    info.append(html);
                    $('#myModal').modal('hide');
                    info.slideDown();
                }
            });
            e.preventDefault();
            return false;
        }));

        //---------------edit update-----------------//

        $("#edit_uploadForm").on('submit',(function(e) {
            var formdata = new FormData(this);

            $.ajax({
                url: "<?php echo e(route('filterTitles.update2')); ?>",
                type: "POST",
                data: formdata ,
                beforeSend: function(){$("#body-overlay").show();},
                contentType: false,
                processData:false,
                success: function(data)
                {
                    $('#myModalEdit').modal('hide');
                    swal({
                        title: "ویرایش شد",
                        text: "عنوان با موفقیت ویرایش شد",
                        type: "success",
                        timer: 1100,
                        showConfirmButton: false
                    });
                    $("#table_content").html(data);
                },
                error: function(xhr) {
                    var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.
                    var info = $('#alerts');
                    info.hide().empty();
                    var html = '<div class="alert alert-danger"><ul>';
                    $.each( error.errors, function( k,v ) {
                        html+=  '<li>'+v[0]+'</li>';
                    });
                    html += '<\div><ul>';
                    info.append(html);
                    $('#myModalEdit').modal('hide');
                    info.slideDown();
                }
            });
            e.preventDefault();
            return false;
        }));
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>