

<?php $__env->startSection('content'); ?>
    <div class="page-header head-section">
        <div class="btn-group" style="float: left; margin-right: 5px;margin-left: 19px">
            <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#modal-user-detail"><i class="fa fa-star-half-o"></i> جزئیات کاربر </button>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-user"></i>
            جزئیات خرید <span class="title bold" style="color:#ff4f4f"><?php echo e($user->fname); ?> <?php echo e($user->lname); ?> </span><?php echo e(convert($user->mobile)); ?>

        </h3>
    </div>
    <div id="alerts">
        <?php echo $__env->make('errors.formAlert', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت سبدهای خرید</h3>
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead>
                    <tr>
                        <th class="text-center"> شناسه</th>
                        <th class="text-center">سبد خرید</th>
                        <th class="text-center"> نام</th>
                        <th class="text-center"> تعداد</th>
                        <th class="text-center"> قیمت</th>
                        <th class="text-center">تاریخ</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(isset($carts_products)): ?>
                        <?php $__currentLoopData = $carts_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carts_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $product = \App\Models\CartProduct::getProduct($carts_product->id) ?>
                            <tr>
                                <td class="text-center"><?php echo e(convert($carts_product->id)); ?></td>
                                <td class="text-center"><?php echo e(convert($carts_product->cart_id)); ?></td>
                                <td class="text-center"><a href="<?php echo e($product->dashboardPath()); ?>"><?php echo e($product->name); ?></a></td>
                                <td class="text-center"><?php echo e(convert($carts_product->qty)); ?></td>
                                <td class="text-center"><?php echo e(convert(priceFormat($carts_product->discount_sell_price))); ?> تومان</td>
                                <td class="text-center" style="direction: ltr"><?php echo e(convert($jdate->forge(strtotime($carts_product->created_at))->format('Y/m/d'))); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div style="margin: 5px 10px 5px 10px">
                <div class="col-sm-6 text-left">
                    <?php if(sizeof($carts_products)>0): ?>
                        <span>نمایش</span>
                        <?php
                            $page=isset($_GET['page']) ? $_GET['page'] : 1;
                            $count=count($carts_products);
                            $a=ceil($carts_products->total()/$carts_products->lastPage());
                        ?>
                        <span class="iransans"><?php echo e(($carts_products->currentpage()-1)*$carts_products->perpage()+1); ?> </span>
                        <span> الی </span>
                        <?php if($count<$a): ?>
                            <span class="iransans"> <?php echo e($carts_products->total()); ?> </span>
                        <?php else: ?>
                            <span class="iransans"><?php echo e($count*$page); ?> </span>
                        <?php endif; ?>
                        <span>کالا</span>
                        <span> از </span>
                        <span class="iransans"> <?php echo e($carts_products->total()); ?> </span>
                        <span>(</span>
                        <span class="iransans"> <?php echo e($carts_products->lastPage()); ?> </span>
                        <span> صفحه)</span>
                    <?php endif; ?>
                </div>
                <div class="col-sm-6 text-right">  <?php echo $carts_products->links(); ?></div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <!-- Add Modal for eye -->
    <div class="modal fade" id="modal-user-detail" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" >
            <div class="modal-content">
                <div id="modal-container">

                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <h6 class="modal-title font-blue-ebonyclay bold" id="myModalLabel" >جزئیات حساب کاربری</h6>
                    </div>
                    <div class="modal-body">
                        <div class="card">
                            <?php if(is_null($user->gender) || $user->gender == 1): ?>
                                <img src="<?php echo e(asset('CRM_Assets/assets/layouts/layout/img/profile.png')); ?>" style="width:25%">
                            <?php else: ?>
                                <img src="<?php echo e(asset('CRM_Assets/assets/layouts/layout/img/profile-female.png')); ?>" style="width:25%">
                            <?php endif; ?>
                            <h2 class="bold" style="color:#ff4f4f"><?php echo e($user->fname); ?> <?php echo e($user->lname); ?></h2>
                            <?php if($user->role == 'admin'): ?>
                                <p class="title large font-blue"> نقش: ادمین </p>
                            <?php else: ?>
                                <p class="title large font-blue"> نقش: مشتری </p>
                            <?php endif; ?>
                            <?php if($user->completed == 0): ?>
                                <p class="title large font-blue"> وضعیت حساب کاربری: تکمیل نشده </p>
                            <?php endif; ?>
                            <div class="pull-right" style="direction: rtl;text-align: right">
                                <p class="title">موبایل : <?php echo e(convert($user->mobile)); ?></p>
                                <?php if($user->completed == 1): ?>
                                    <?php if(is_null($user->gender)): ?>
                                        <p>جنسیت :   --</p>
                                    <?php elseif($user->gender == 1): ?>
                                        <p>جنسیت : مرد</p>
                                    <?php elseif($user->gender == 0): ?>
                                        <p>جنسیت : زن</p>
                                    <?php endif; ?>
                                    <p>استان : <?php echo e($user->state); ?></p>
                                    <p>شهرستان : <?php echo e($user->city); ?></p>
                                    <p>آدرس : <?php echo e(convert($user->address)); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="pull-left" style="direction: rtl;text-align: right">
                                <?php if($user->completed == 1): ?>
                                    <p class="title">کد ملی: <?php echo e(convert($user->melli_code)); ?></p>
                                    <p class="title">کد پستی: <?php echo e(convert($user->postal_code)); ?></p>
                                    <p>تلفن : <?php echo e(is_null($user->tell)? '--':convert($user->tell)); ?></p>
                                    <p>شماره تماس ضروری : <?php echo e(is_null($user->urgent_phone_no)? '--':convert($user->urgent_phone_no)); ?></p>
                                    <p>مجموع دفعات خرید : <?php echo e(convert($user->getPaidCart(true))); ?> بار</p>
                                <?php endif; ?>
                            </div>
                            <p> <button class="btn btn-success">کل میزان خرید: <?php echo e(convert(priceFormat($user->totalBuy()))); ?> تومان</button></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>