

<?php $__env->startSection('script'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->


    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
<?php $__env->stopSection(); ?>
<?php
    $newestItems = new \App\Models\NewestItem();
?>
<?php $__env->startSection('content'); ?>
    <div class="portlet light bordered main">
        <?php echo $__env->make('CRM.Admin.section.errors', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="portlet-body form">
                <?php ($width=900); ?>
                <?php ($heigt=400); ?>
                <form class="form-horizontal" method="POST" action="<?php echo e(route('slider-home.update',$slide->id)); ?>"
                      enctype='multipart/form-data' role="form">
                    <?php echo e(method_field('PUT')); ?>

                    <?php echo e(csrf_field()); ?>


                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">نوع اسلایدر</label>
                                    <div class="col-md-9">
                                        <select name="type" class="form-control">
                                            <option <?php if($slide->type ==0): ?> selected <?php endif; ?> value="0">راست چین</option>
                                            <option <?php if($slide->type ==1): ?> selected <?php endif; ?> value="1">وسط چین</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">نام اسلایدر</label>
                                    <div class="col-md-9">
                                        <input name="name" type="text" class="form-control" required placeholder="نام"
                                               value="<?php echo e($slide->name); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">عنوان</label>
                                    <div class="col-md-9">
                                        <input name="title" type="text" class="form-control" required
                                               value="<?php echo e($slide->title); ?>"
                                               placeholder="عنوان">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">Url</label>
                                    <div class="col-md-10">
                                        <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                            <input name="url" type="url" class="form-control" required
                                                   value="<?php echo e($slide->url); ?>"
                                                   placeholder="Url Address">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">ترتیب</label>
                                    <div class="col-md-9">
                                        <input name="order" type="number" min="1" class="form-control" required
                                               value="<?php echo e($slide->order); ?>"
                                               placeholder="1">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <div class="col-md-6">
                                        <div class="md-checkbox-inline">
                                            <div class="md-checkbox">
                                                <input type="checkbox" id="checkbox2_4" name="status" value="1"
                                                       <?php if($slide->status == 1): ?> checked <?php endif; ?>
                                                       class="md-check">
                                                <label for="checkbox2_4">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> فعال </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">توضیح کوتاه</label>
                                    <div class="col-md-10">
                                        <input name="body" type="text" class="form-control" required
                                               value="<?php echo e($slide->body); ?>"
                                               placeholder="توضیح">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="bgColor">
                                <div style="width: <?php echo e($width); ?>px;height: <?php echo e($heigt); ?>px" class="targetOuter">
                                    <div id="target1" class="targetLayer">
                                        <div id="target1" class="targetLayer">
                                            <?php if(isset($slide)): ?>
                                                <img src="<?php echo e($slide->image_path); ?>" width="<?php echo e($width); ?>px"
                                                     height="<?php echo e($heigt); ?>px" class="upload-preview"/>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <img src="<?php echo e(asset('CRM_Assets/assets/pages/img/easy.png')); ?>"
                                         class="icon-choose-image"/>

                                    <div class="icon-choose-image">
                                        <input name="image" title="انتخاب عکس" type="file"
                                               class="inputFile userImage"
                                               onChange="showPreview(this,'#target1','<?php echo e($width); ?>px','<?php echo e($heigt); ?>px');"/>
                                    </div>
                                </div>
                                <label class="col-sm-4 control-label">سایز مناسب عکس <?php echo e($width); ?>x<?php echo e($heigt); ?> پیکسل</label>

                                <div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('head'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    <?php if(alert()->ready()): ?>
        <script>
            $(document).ready(function () {
                swal({
                    title: "<?php echo alert()->message(); ?>",
                    text: "<?php echo alert()->option('text'); ?>",
                    type: "<?php echo alert()->type(); ?>",
                    <?php if(alert()->option('timer')): ?>
                    timer: "<?php echo alert()->option('timer'); ?>",
                    showConfirmButton: false,
                    <?php endif; ?>
                });
            })
        </script>
    <?php endif; ?>

    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>