

<?php $__env->startSection('script'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->


    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
<?php $__env->stopSection(); ?>
<?php
    $newestItems = new \App\Models\NewestItem();
?>
<?php $__env->startSection('content'); ?>
    <div class="portlet light bordered main">
        <?php echo $__env->make('CRM.Admin.section.errors', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>

    <div class="col-md-12">
        <div class="panel panel-default">

            <div class="panel-heading">
                <h3 class="panel-title FarsiFont "><i class="fa fa-list"></i>&nbsp;مدیریت مقالات</h3>
            </div>
            <?php if(Auth::user()->can(['همه','مقالات','ثبت مقاله جدید'])): ?>
            <div class="panel-heading">
                <h3 class="panel-title FarsiFont">
                    <a class="btn btn-success text-white" href="<?php echo e(route('article.create')); ?>">ثبت مقاله جدید</a>
                </h3>
            </div>
            <?php endif; ?>
            <div class="panel-body">
                <div class="table">
                    <table class="table table-striped table-bordered table-hover order-column dataTable no-footer"
                           id="sample_11" role="grid" aria-describedby="sample_1_info">
                        <thead>
                        <tr role="row">
                            <th class="sorting_disable text-center" style="width: 10px;" aria-label=""><i
                                        class="fa fa-gears"></i></th>
                            <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=""> زمان ایجاد
                            </th>

                            <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label="عنوان">عنوان
                            </th>
                            <th class="sorting_disable text-center" style="" aria-sort="descending" tabindex="0"
                                aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label="توضیح کوتاه">توضیح کوتاه
                            </th>
                            <th class="sorting_disable text-center" style="width: 60px" aria-sort="descending" tabindex="0"
                                aria-controls="sample_1" rowspan="1" colspan="1">تعداد مشاهده
                            </th>
                            <th class="sorting_disable text-center" style="width: 60px" aria-sort="descending" tabindex="0"
                                aria-controls="sample_1" rowspan="1" colspan="1">وضعیت
                            </th>
                            <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=""> عکس
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr role="row" class="<?php echo e($article->status === 1 ? 'success' :'danger'); ?> ">

                                <td>
                                    <div class="btn-group">
                                        <button class="btn btn-xs btn-danger dropdown-toggle bold" type="button"
                                                data-toggle="dropdown" aria-expanded="false">
                                            <i class="fa fa-gears"></i>
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li>
                                                <a href="<?php echo e(route('article.edit',$article->id)); ?>">
                                                    <i class="fa fa-file-text" style="color:#5E6EDD "></i> ویرایش </a>
                                            </li>
                                            <?php if($article->status==0): ?>
                                                <li>
                                                    <a href="<?php echo e(route('article-status',$article->id)); ?>" >
                                                        <i class="fa fa-toggle-on" style="color:#2ecc71 " ></i> فعال کن </a>
                                                </li>
                                            <?php else: ?>
                                                <li>
                                                    <a href="<?php echo e(route('article-status',$article->id)); ?>" >
                                                        <i class="fa fa-toggle-on" style="color:red " ></i> غیر فعال کن </a>
                                                </li>
                                            <?php endif; ?>
                                            <li>
                                                <form class="form-horizontal" method="POST" action="<?php echo e(route('article.destroy',$article->id)); ?>" role="form">
                                                    <?php echo e(method_field('DELETE')); ?>

                                                    <?php echo e(csrf_field()); ?>

                                                    <button style="text-align: right;background: none;border: none" type="submit" class="text-danger col-md-12 text-right">
                                                        <i class="fa fa-minus-circle" style="color:#ED6B75 "></i> حذف
                                                    </button>
                                                </form>
                                            </li>

                                        </ul>
                                    </div>
                                </td>
                                <td style="width: 90px" class="text-center">
                                    <?php echo e(convert(jDate::forge($article->created_at)->format('datetime'))); ?>

                                </td>

                                <td style="text-decoration: none;font-weight: bold;"
                                    class="text-center"><?php echo e($article->title); ?></td>
                                <td class="text-center">
                                    <?php echo e($article->description); ?>

                                </td>
                                <td class="text-center">
                                    <?php echo e($article->view_count); ?>

                                </td>
                                <td class="text-center">
                                    <?php if($article->status == 1): ?>
                                        <span class="label label-sm label-success">  منتشر شده </span>
                                    <?php else: ?>
                                        <span class="label label-sm label-danger"> غیر فعال </span>
                                    <?php endif; ?>

                                </td>
                                <td class="text-center">
                                    <img style="max-width: 105px" alt="<?php echo e($article->name); ?>"
                                         src="<?php echo e(url($article->image_path)); ?>">
                                </td>


                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>




<?php $__env->stopSection(); ?>
<?php $__env->startSection('head'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    <?php if(alert()->ready()): ?>
        <script>
            $(document).ready(function () {
                swal({
                    title: "<?php echo alert()->message(); ?>",
                    text: "<?php echo alert()->option('text'); ?>",
                    type: "<?php echo alert()->type(); ?>",
                    <?php if(alert()->option('timer')): ?>
                    timer: "<?php echo alert()->option('timer'); ?>",
                    showConfirmButton: false,
                    <?php endif; ?>
                });
            })
        </script>
    <?php endif; ?>

    <script>

        $(document).ready(function(){
            $('#sample_11').DataTable({
                'columnDefs': [ {
                    'orderable': false, /* true or false */
                }]
            });
        });
    </script>


    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>