<?php $__env->startSection('head'); ?>

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css" rel="stylesheet" type="text/css" />
    <!-- END PAGE LEVEL PLUGINS -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('pageBar'); ?>
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>انبار</span>
    </li>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <a href="<?php echo e(route('product.index')); ?>" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span><strong> بازگشت </strong> </a>

                    <?php echo $__env->make('errors.formAlert', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <div class="page-header head-section">
                        <div class="btn-group" style="float: left; margin-right: 5px;margin-left: 19px">
                            <a href="<?php echo e(route('product.create')); ?>" class="btn btn-primary" ><i class="fa fa-plus"></i> افزودن کالا </a>
                        </div>
                        <div class="btn-group" style=" margin-right: 5px;margin-left: 5px">
                            <a class="btn btn-danger btn-xs" href="<?php echo e(route('product.qty',['type' => 'stuffType', 'qty' => 'not-available','id' => $stuffType->id ])); ?>"> تمام شده </a>
                            <a class="btn btn-default btn-xs" href="<?php echo e(route('product.qty',['type' => 'stuffType', 'qty' => 'available','id' => $stuffType->id ])); ?>"> موجود </a>
                        </div>
                        <div class="btn-group" style=" margin-right: 5px;margin-left: 5px">
                            <a class="btn btn-warning btn-xs" href="<?php echo e(route('product.available',['type' => 'stuffType', 'available' => 0,'id' => $stuffType->id ])); ?>" > ناموجود شده </a>
                            <a class="btn btn-default btn-xs" href="<?php echo e(route('product.available',['type' => 'stuffType', 'available' => 1,'id' => $stuffType->id ])); ?>" > موجود شده </a>
                        </div>
                        <div class="btn-group" style=" margin-right: 5px;margin-left: 5px">
                            <a class="btn btn-purple btn-xs" href="<?php echo e(route('product.status',['type' => 'stuffType', 'status' => 0,'id' => $stuffType->id ])); ?>"> غیر فعال </a>
                            <a class="btn btn-default btn-xs" href="<?php echo e(route('product.status',['type' => 'stuffType', 'status' => 1,'id' => $stuffType->id ])); ?>"> فعال </a>
                        </div>
                        <h3 style="text-align: center">
                            <i class="fa fa-cubes"></i>
                            کالاهای <span class="title bold" style="color:#ff4f4f"><?php echo e($stuffType->stuffType); ?></span>
                        </h3>
                    </div>
                </div>
                <div class="panel panel-default" >
                    <div class="panel-heading">
                        <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت انبار</h3>
                    </div>
                    <div class="panel-body">
                        <div class="table">
                            <table class="table table-striped table-bordered table-hover order-column dataTable no-footer" id="sample_1" role="grid" aria-describedby="sample_1_info" >
                                <thead>
                                <tr role="row">
                                    
                                    <th class="text-center"> کد </th>
                                    <th class="text-center"> نام </th>
                                    <th class="text-center"> نام انگلیسی </th>
                                    <th class="text-center"> دسته بندی </th>
                                    <th class="text-center"> برند </th>
                                    <th class="text-center"> وضعیت </th>
                                    <th class="text-center"> دسترس </th>
                                    <th class="text-center"> تعداد </th>
                                    <th class="text-center"> گزینه ها </th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(isset($products)): ?>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr <?php if($product->qty === 0): ?> class="danger" <?php elseif($product->available === 0): ?> class="warning" <?php elseif($product->status === 0): ?> class="info" <?php endif; ?>>
                                            
                                            
                                            
                                            
                                            
                                            
                                            <td class="text-center"> <?php echo e($product->code); ?> </td>
                                            <td class="text-center">
                                                <a href="<?php echo e(route('product.show',$product)); ?>"> <?php echo e($product->name); ?></a>
                                            </td>
                                            <td class="text-center">
                                                <a href="<?php echo e(route('product.show',$product)); ?>">  <?php echo e($product->eng_name); ?></a>
                                            </td>
                                            <td class="text-center" >
                                                <a href="<?php echo e(route('product.category',$product->Category)); ?>"> <span class="font-green-jungle bold"  ><?php echo e($product->Category->category); ?></span></a>
                                            </td>
                                            <td class="text-center" >
                                                <a href="<?php echo e(route('product.brand',$product->Brand)); ?>"> <span class="font-green-jungle bold"  ><?php echo e($product->Brand->brandName); ?></span></a>
                                            </td>
                                            <td class="text-center"> <?php echo e($product->status == 0 ? 'غیر فعال':'فعال'); ?> </td>
                                            <td class="text-center"> <?php echo e($product->available == 0 ? 'خارج دسترس':'در دسترس'); ?> </td>
                                            <td class="text-center"> <?php echo e(convert($product->qty)); ?> </td>
                                            <td class="text-center">
                                                <div  class="dropdown-toggle toggle-button btn btn-xs btn-success" type="button" data-toggle="dropdown" aria-expanded="false">...</div>
                                                <ul class="dropdown-menu pull-left" role="menu" style="position: inherit">
                                                    <li>
                                                        <a href="<?php echo e(route('product.show',$product)); ?>">
                                                            <i class="fa fa-list-ul"></i> جزئیات </a>
                                                    </li>
                                                    <li>
                                                        <a href="<?php echo e(route('product.edit',$product)); ?>">
                                                            <i class="fa fa-edit"></i> ویرایش </a>
                                                    </li>
                                                    <li class="divider"> </li>
                                                    <li>
                                                        <a class="toggleStatusModal" data-toggle="modal" data-target="#myModalEye" data-content="<?php echo e($product->id); ?>">
                                                            <i class="icon-flag"></i> تغییر وضعیت
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>
    <script>
        $(document).on('click', ".toggleStatusModal", function () {
            var id = $(this).attr('data-content');

            $.ajax({
                url: "<?php echo e(route('product.status.modal')); ?>",
                type: "GET",
                data: {id: id},
                success: function (data) {

                    $("#modal-container").html(data);

                },
                error: function (xhr) {
                    var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.
                    var info = $('#alerts');
                    swal({
                        title: "خطا",
                        text: " با خطا مواجه شد",
                        type: "error",
                        timer: 1500
                    });
                    info.hide().empty();
                    var html = '<div class="alert alert-danger"><ul>';
                    $.each(error.errors, function (k, v) {
                        html += '<li>' + v[0] + '</li>';
                    });
                    html += '<\div><ul>';
                    info.append(html);
                    info.slideDown();
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal fade" id="myModalEye" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div id="modal-container">

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('/CRM/layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>