<?php

Route::get('/migrate',function (){
   return \Illuminate\Support\Facades\Artisan::call('migrate');
});
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
 |--------------------------------------------------*
 |Routs of public section
 |--------------------------------------------------*
 */


Route::prefix('/')->namespace('SiteFront')->group(function () {
    Route::get('/','HomeController@index')->name('home');


    /*------profile-----*/

    Route::middleware('authCheck')->group(function () {

        Route::get('/profile', 'ProfileController@index')->name('profile.show');
        Route::get('/personalInfo', 'ProfileController@personalInfo')->name('profile.personalInfo');
        Route::patch('/personalInfo', 'ProfileController@store')->name('profile.store');
        /*------inbox-----*/
        Route::get('/inbox', 'ProfileController@indexInbox')->name('profile.inbox');
        Route::patch('/inbox/read-message', 'ProfileController@readMessage')->name('profile.inbox.read-message');
        /*------favorites-----*/
        Route::patch('/favorites/add', 'ProfileController@addToFavorites')->name('addToFavorites');
        Route::delete('/favorites/remove/{favorite}', 'ProfileController@removeFavorite')->name('removeFavorite');

    });

    /*------site front product-----*/
    Route::get('product/{slug}','Product\ProductController@index');

    Route::post('product/review','Product\ProductController@storeReview')->name('review.store');
    Route::post('product/review/login',  'Product\ProductController@reviewLogin')->name('review.login');
    Route::post('product/review/positive',  'Product\ProductController@reviewPositive')->name('review.positive');
    Route::post('product/review/negative',  'Product\ProductController@reviewNegative')->name('review.negative');

    /*------site front collections-----*/
    Route::get('collections','Collections\CollectionsController@index');

    /*------site front MenuSearch-----*/
    Route::get('search','Collections\SearchController@index');
    Route::get('search_box','Collections\SearchController@searchBox')->name('SearchBox');

    Route::post('set_choices_filters','Collections\SearchController@set_choices_filters')->name('set_choices.filters');
    Route::post('set_choices_status','Collections\SearchController@set_choices_status')->name('set_choices.status');
    Route::post('set_choices_colors','Collections\SearchController@set_choices_colors')->name('set_choices.colors');
    Route::post('set_choices_price','Collections\SearchController@set_choices_price')->name('set_choices.price');

    Route::get('clear_choices','Collections\SearchController@clear_choices')->name('clear_choices');
    Route::post('clear_choice','Collections\SearchController@clear_choice')->name('clear_choice');

//    Route::get('Search','Collections\SearchController@index_search');


    Route::get('category/{slug}','Collections\CategoryController@index');
    Route::get('product_type/{slug}','Collections\CategoryController@indexStuffType');

    /*------products compare routs-----*/
//->ajax for get compare products
    Route::get('getCompare/{id}','Collections\CompareController@getCompare');
    Route::get('clearCompare','Collections\CompareController@clearCompare');
    Route::get('clearOneCompare/{id}','Collections\CompareController@clearOneCompare');

//->compare page
    Route::get('/compare','Collections\CompareController@index')->name('compare.index');
    Route::get('/getCompareProducts','Collections\CompareController@getCompareProducts')->name('get.products.compare');

    /*------cart routs-----*/
    Route::get('/cart','Cart\CartController@index')->name('cart.show');
    Route::post('/cart','Cart\CartController@cartQty')->name('cart.qty');

    Route::post('/addToCart','Cart\CartController@addToCart')->name('addToCart');
    Route::post('/addToCart2','Cart\CartController@addToCart2')->name('addToCart2');
    Route::delete('/removeFromCart','Cart\CartController@removeFromCart')->name('removeFromCart');
    Route::delete('/removeFromCartPage','Cart\CartController@removeFromCartPage')->name('removeFromCartPage');

    Route::delete('/removeCart','Cart\CartController@removeCart')->name('removeCart');

    /*------address routs-----*/
    Route::get('/address','OrderPayment\AddressController@index')->name('address.show');
    Route::get('/personal-info',  'OrderPayment\AddressController@personalInfoShow')->name('personalInfo.show');

    Route::post('/getCities',  'OrderPayment\AddressController@getCities')->name('getCities');

    /*------purchase routs-----*/
    Route::get('/purchase','OrderPayment\PurchaseController@index')->name('purchase.show');
    Route::patch('/discountCode','OrderPayment\PurchaseController@discountCodeStore')->name('discountCode.check');

    Route::post('/buy','OrderPayment\PurchaseController@payCheck')->name('invoice.buy');

    Route::any('/invoice','OrderPayment\PurchaseController@callBack');


    /*------Articles-----*/
    Route::get('مقالات','Article\ArticlesController@index')->name('front-articles');
    Route::get('/article/{slug}','Article\ArticlesController@single')->name('front-article');
    Route::get('/article/tag/{tag}','Article\ArticlesController@tag')->name('front-article-tag');
    Route::get('/articles/search','Article\ArticlesController@search')->name('front-article-search');


    /*------Pages-----*/
    Route::get('/page/{slug}','Page\PageController@single')->name('front-page');




});

/*
 |--------------------------------------------------*
 |Routs of CRM section
 |--------------------------------------------------*
 */

/*------Dashboard Routs-----*/
require __DIR__.'/dashboard.php';

require __DIR__.'/owner.php';

// Authentication Routes...
Route::get('login', 'Auth\LoginController@showLoginForm')->name('login.show');
Route::post('login', 'Auth\LoginController@login')->name('login.store');
Route::get('logout', 'Auth\LoginController@logout')->name('logout');
// Registration Routes...
Route::get('/register', 'Auth\RegisterController@showRegistrationForm')->name('register.show');
Route::post('/registerOne', 'Auth\RegisterController@register')->name('register.step1');
Route::patch('/registerTwo',  'Auth\RegisterController@storeStepTwo')->name('register.step2');
Route::get('/register/activation', 'Auth\RegisterController@sendActivationCode')->name('register.activation');
Route::post('/register/activation', 'Auth\RegisterController@activationCodeSend')->name('register.activation.send');


Route::patch('/registerTwoUpdate',  'Auth\RegisterController@storeStepTwoUpdate')->name('updateInfo');
Route::patch('/registerTwoUpdate2',  'Auth\RegisterController@storeStepTwoUpdate2')->name('updateInfo2');

Route::get('/complete',  'Auth\RegisterController@completeQuestion')->name('completeQuestion');

Route::get('/activation',  'Auth\RegisterController@activeShow')->name('confirm.show')->middleware('prevent-back-history');
Route::post('/activation',  'Auth\RegisterController@active')->name('confirm.store');

Route::post('/activationReq',  'Auth\RegisterController@activationReq')->name('confirm.req');
Route::post('/noEdit',  'Auth\RegisterController@noEdit')->name('register.noEdit');

Route::post('/password/reset/show', 'Auth\ResetPasswordController@showResetForm')->name('resetPass.show');
Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('resetPass.reset');
Route::get('/resetPassReq', 'Auth\ResetPasswordController@sendSmsCode')->name('resetPassReq');


Route::get('password/forgot', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('forgot.show.form');
Route::post('password/sms', 'Auth\ForgotPasswordController@sendSms')->name('forgot.sms');

Route::get('password/reset/code/{token}', 'Auth\ForgotPasswordController@codeForm')->name('forgot.code.show');
Route::post('password/reset/code', 'Auth\ForgotPasswordController@codeCheck')->name('forgot.code.check');

Route::get('password/reset/forgot/{token}', 'Auth\ForgotPasswordController@showResetForm')->name('forgot.form');
Route::post('password/reset/forgot', 'Auth\ForgotPasswordController@reset')->name('forgot.reset');






