<?php
/*
 |--------------------------------------------------*
 |Routs of CRM section
 |--------------------------------------------------*
 */

/*------Dashboard Routs-----*/
Route::middleware('authCheck')->group(function () {

    Route::middleware('owner2')->group(function () {
        Route::get('/searchIndexMakeBrand', 'OwnerController@makeIndexBrand')->name('make.search.brand.index');
        Route::get('/searchIndexMakeCategory', 'OwnerController@makeIndexCategory')->name('make.search.category.index');
        Route::get('/searchIndexMakeProduct', 'OwnerController@makeIndexProduct')->name('make.search.product.index');
        Route::get('/storageLink', 'OwnerController@storageLink')->name('storageLink');

    });

    Route::prefix('Admin')->middleware('owner')->group(function () {


        Route::resource('roles', 'Admin\RoleController');
        Route::resource('permissions', 'Admin\PermissionController');

        Route::get('register/user', 'Admin\AdminUserController@index')->name('admin.user.index');
        Route::post('register/user', 'Admin\AdminUserController@store')->name('admin.user.store');


        Route::prefix('users')->group(function () {
            Route::get('/', 'Admin\UserController@index');
            Route::resource('level', 'Admin\LevelManageController', ['parameters' => ['level' => 'user']]);
            Route::delete('/{user}/destroy', 'Admin\UserController@destroy')->name('users.destroy');
        });
    });
});

