<?php
/*
 |--------------------------------------------------*
 |Routs of CRM section
 |--------------------------------------------------*
 */



Route::middleware('admin')->group(function () {




    Route::group(['middleware' => ['permission:همه|آمار و نمودارها']], function() {

        Route::get('/CRM/charts','Dashboard\ChartController@index')->name('charts.index');
        Route::get('/CRM/charts/search-details', 'Dashboard\ChartController@indexSearchDetails')->name('search.details.index');
        Route::get('/CRM/charts/search-details-count', 'Dashboard\ChartController@indexSearchDetailsCount')->name('searchCount.details.index');
        Route::get('/CRM/charts/products-details', 'Dashboard\ChartController@indexProductsDetails')->name('search.products.index');

    });

    /*------Dashboard Routs-----*/
    Route::get('/CRM/Dashboard', 'Dashboard\dashboardController@index')->name('Dashboard');

    Route::post('/CRM/Dashboard/comments/change', 'Dashboard\dashboardController@changeComment')->name('dashboard.changeReview');
    Route::post('/CRM/Dashboard/comments/delete', 'Dashboard\dashboardController@deleteComment')->name('dashboard.deleteReview');

    Route::post('/CRM/Dashboard/carts/change', 'Dashboard\dashboardController@changeCart')->name('dashboard.changeCart');


    Route::get('/CRM/profile/{id}', 'Dashboard\dashboardController@profile')->name('profile');
    Route::post('/profileSave', 'Dashboard\dashboardController@storeProfile')->name('profile_save');
    Route::post('/passwordReset', 'Dashboard\dashboardController@profilePassReset')->name('profile_passwordReset');

    //******************************//


    /*------history-----*/
    Route::group(['middleware' => ['permission:سوابق مرصولات|همه|سوابق بخش مدیریت|سوابق سیستم|سوابق مبادلات بانکی']], function() {

        Route::get('/CRM/history/posts', 'HistoryController@postHistory')->name('postHistory');
        Route::get('/CRM/history/transactions', 'HistoryController@transactionHistory')->name('transactionHistory');
        //->order view ajax
        Route::get('/CRM/orders/view-2', 'CrmSiteFront\orders\OrdersController@viewOrderHistory')->name('order.view2');
    });

    Route::group(['middleware' => ['permission:همه|سوابق بخش مدیریت|سوابق فروش']], function() {

        Route::get('/CRM/history/sells', 'HistoryController@sellHistory')->name('sellHistory');

    });



    Route::prefix('/CRM/SiteFront')->namespace('CrmSiteFront')->group(function () {

        Route::group(['middleware' => ['permission:کدهای تخفیف|همه']],function () {

            /*------discount codes-----*/
            Route::get('DiscountCodes', 'DiscountCodes\DiscountCodesController@index')->name('discountCode.show');
            Route::post('DiscountCodes', 'DiscountCodes\DiscountCodesController@store')->name('discountCode.store');
            Route::delete('DiscountCodes/delete', 'DiscountCodes\DiscountCodesController@delete')->name('discountCode.delete');
            Route::post('DiscountCodes/deactivate', 'DiscountCodes\DiscountCodesController@deactivate')->name('discountCode.deactivate');
            Route::post('DiscountCodes/activate', 'DiscountCodes\DiscountCodesController@activate')->name('discountCode.activate');
        });

        Route::group(['middleware' => ['permission:مدیریت فایل ها|همه']], function() {
            /*------File Manager-----*/
            Route::get('filemanager', 'fileManager\FileManagerController@index')->name('filemanager');
        });

        /*------Baners-----*/
        Route::resource('baners-home', 'Baners\BanersController');
        Route::resource('baners-social', 'Baners\SocialBannersController');
        Route::get('baners-blog', 'Baners\BanersController@blog_index')->name('blog_index');

        /*------banners-stuffType-----*/
        Route::resource('banners-stuffType','Baners\StuffTypeController');

        Route::group(['middleware' => ['permission:مدیریت صفحه اصلی|همه|اسلایدر اصلی']], function() {
            /*------banners-category-----*/
            Route::resource('banners-category', 'Baners\CategoryController');
            Route::get('banners-category-ajax', 'Baners\CategoryController@ajax')->name('banners-category-ajax');
        });

        Route::group(['middleware' => ['permission:مدیریت صفحه اصلی|همه|اسلایدر اصلی']], function() {
            /*------Sliders-----*/
            Route::resource('slider-home', 'slider\SliderController');
            Route::get('slider-home-delete/{id}', 'slider\SliderController@destroy')->name('slider-home-delete');
            Route::get('slider-home-status/{id}', 'slider\SliderController@status_chenge')->name('slider-home-status');
        });

        Route::group(['middleware' => ['permission:مدیریت صفحه اصلی|همه|پیشنهادات شگفت انگیز']], function() {
            /*------Amazing-----*/
            Route::resource('amazing', 'amazing\AmazingController');
            Route::get('amazing-delete/{id}', 'amazing\AmazingController@destroy')->name('amazing-delete');
            Route::get('amazing-status/{id}', 'amazing\AmazingController@status_chenge')->name('amazing-status');
        });

        Route::group(['middleware' => ['permission:مدیریت صفحه اصلی|همه|قیمت لحظه ای']], function() {
            /*------Price List-----*/
            Route::resource('priceList', 'priceList\PriceListController');
        });

        Route::group(['middleware' => ['permission:همه|مقالات|همه مقالات|ثبت مقالات']], function() {
            /*------Article-----*/
            Route::resource('article', 'article\ArticleController');
            Route::get('article-status/{id}', 'article\ArticleController@status_chenge')->name('article-status');
            /*------ArticleCategory-----*/
            Route::resource('articleCategory', 'article\ArticleCategoryController');

        });

        Route::group(['middleware' => ['permission:همه|صفحات|همه صفحات|ثبت صفحه جدید']], function() {
            /*------Pages-----*/
            Route::resource('page', 'page\PageController');
        });


        /*------3 main banners-----*/
        Route::group(['middleware' => ['permission:همه|مدیریت بنرها|بنرهای صفحه اصلی|جدیدترین ها']], function() {
            Route::resource('newestItems', 'NewestItemsController');
        });

        Route::group(['middleware' => ['permission:همه|مدیریت بنرها|بنرهای صفحه اصلی|پرفروش ترین ها']], function() {
            Route::resource('bestSeller', 'BestSellerController');
        });

        Route::group(['middleware' => ['permission:همه|مدیریت بنرها|بنرهای صفحه اصلی|لوازم جانبی']], function() {
            Route::resource('accessories', 'AccessoriesController');
        });

        Route::prefix('settings')->namespace('settings')->middleware(['permission:تعریف کالا|اطلاعات پایه کالا|همه|تنظیمات اولیه'])->group(function() {
            /*------Setting-----*/
            Route::resource('setting_main', 'SettingController');
            Route::resource('links', 'LinksController');
            Route::resource('socials', 'SocialMediaController');

        });
        Route::group(['middleware' => ['permission:همه|صفحات|همه صفحات|ثبت صفحه جدید']], function() {
            /*------Service-----*/
            Route::resource('service', 'service\ServiceController');
        });


        /*-----------------------------------------------filters------------------------------------------------------------*/

        Route::group(['middleware' => ['permission:همه|مدیریت فیلتر ها|افزودن فیلتر دسته بندی']], function() {
            //--------filter titles ---------\\
            Route::resource('filterTitles', 'Filters\TitlesController');
            Route::post('filterTitles/delete', 'Filters\TitlesController@delete')->name('filterTitles.delete');
            Route::post('filterTitles/get', 'Filters\TitlesController@get')->name('filterTitles.get');
            Route::post('filterTitles/update', 'Filters\TitlesController@update')->name('filterTitles.update2');

            //--------------filters options---------\\
            Route::resource('options', 'Filters\OptionsController');
            Route::post('options/delete', 'Filters\OptionsController@delete')->name('options.delete');

        });

        /*-----------------------------------------------Menu------------------------------------------------------------*/
        Route::group(['middleware' => ['permission:مدیریت صفحه اصلی|همه|منو اصلی']], function() {

            Route::get('dynamicMenu/create-url', 'DynamicMenuController@createUrl')->name('dynamicMenu.createUrl');

            Route::resource('dynamicMenu', 'DynamicMenuController');

            Route::get('dynamicMenu/{menu_id}', 'DynamicMenuController@show');

            ////////
            Route::get('dynamicSubMenu/create-url/{dynamicMenu}', 'DynamicSubMenuController@createUrl')->name('dynamicSubMenu.createUrl');
            Route::get('dynamicSubMenu/create/{dynamicMenu}', 'DynamicSubMenuController@create')->name('dynamicSubMenu.create-cat');

            Route::resource('dynamicSubMenu', 'DynamicSubMenuController');
            Route::get('dynamicSubMenu/{menu_id}', 'DynamicSubMenuController@show');
            //--------------sub menu setting ---------\\
            //->title create
            Route::get('subMenuSetting/create/{subMenu_id}', 'SubMenuSettingController@create');
            Route::get('subMenuSetting-title/edit/{dynamicSubMenu}/{subMenuTitle}', 'SubMenuSettingController@edit_title')->name('title.edit');
            Route::get('subMenuSetting-subTitle/edit/{subMenuTitle}/{dynamicSubMenuSetting}', 'SubMenuSettingController@edit_subTitle')->name('subTitle.edit');

            Route::patch('subMenuSetting-title/update/{dynamicSubMenu}/{subMenuTitle}', 'SubMenuSettingController@update_title')->name('title.update');
            Route::patch('subMenuSetting-subTitle/update/{subMenuTitle}/{dynamicSubMenuSetting}', 'SubMenuSettingController@update_subTitle')->name('subTitle.update');

            Route::post('subMenuSetting/save', 'SubMenuSettingController@save')->name('subMenuSetting.save');

            Route::post('subMenuSetting/store-sub-title', 'SubMenuSettingController@storeSubTitle')->name('store.subTitle');

            //->ajax for delete titles
            Route::post('subMenuSetting/delete', 'SubMenuSettingController@delete');
            //->ajax for delete subSetting
            Route::post('subMenuSetting/delete2', 'SubMenuSettingController@delete2');

            //->ajax for get tec_info
            Route::get('subMenuSetting/get-tec-keys', 'SubMenuSettingController@get_tec_keys')->name('get.tec.keys');
            Route::get('subMenuSetting/get-tec-values', 'SubMenuSettingController@get_tec_values')->name('get.tec.values');

            //----------ajax-----------------\\
            //menu activation ajax
            Route::post('menuActivation', 'DynamicMenuController@menuActivation');
            //menu delete
            Route::post('menuDelete', 'DynamicMenuController@delete');
            //menu refresh ajax
            Route::get('menuTableRefresh', 'DynamicMenuController@menuTableRefresh');
            //menu activation set refresh ajax
            Route::get('menu_activation_button', 'DynamicMenuController@menu_activation_button');

            //sub menu activation ajax
            Route::post('subMenuActivation', 'DynamicSubMenuController@subMenuActivation');
            //sub menu delete
            Route::post('subMenuDelete', 'DynamicSubMenuController@delete');

            //sub menu refresh ajax
            Route::get('subMenuTableRefresh', 'DynamicSubMenuController@subMenuTableRefresh');

            //sub menu activation set refresh ajax
            Route::get('activation_button', 'DynamicSubMenuController@activation_button');
        });

    });

    Route::prefix('/CRM')->namespace('CrmSiteFront')->group(function () {
        /*-------------------------------------------------comments---------------------------------------------------------*/
        Route::prefix('comments')->group(function () {

            Route::group(['middleware' => ['permission:مدیریت نظرات|همه|بخش نظرات']], function () {
                Route::get('section', 'CommentsController@sectionIndex')->name('comments.section');
            });
            Route::group(['middleware' => ['permission:مدیریت نظرات|همه|همه نظرات']], function () {
                Route::get('/', 'CommentsController@index')->name('comments.show');
            });

            Route::group(['middleware' => ['permission:مدیریت نظرات|همه|همه نظرات|نظرات در انتظار تایید']], function () {
                Route::get('pending', 'CommentsController@pendingIndex')->name('pending.show');
            });

            Route::group(['middleware' => ['permission:مدیریت نظرات|همه|همه نظرات|نظرات تایید شده']], function () {
                Route::get('approved', 'CommentsController@approvedIndex')->name('approved.show');
            });
            Route::group(['middleware' => ['permission:مدیریت نظرات|همه|همه نظرات|نظرات تایید نشده']], function () {
                Route::get('declined', 'CommentsController@declinedIndex')->name('declined.show');
            });

            Route::post('change', 'CommentsController@change')->name('changeReview');
            Route::post('delete', 'CommentsController@delete')->name('deleteReview');
            Route::post('delete/replay/{id}', 'CommentsController@deleteReplay')->name('deleteReplay');

            Route::get('edit/{review}', 'CommentsController@editIndex')->name('editReview.show');
            Route::post('edit/{review}', 'CommentsController@edit')->name('editReview.edit');
            Route::post('replay/{review}', 'CommentsController@replay')->name('editReview.replay');
        });

        /*---------------------------------------------order Management-----------------------------------------------------*/
        Route::prefix('orders')->namespace('orders')->group(function () {

            //->order view ajax
            Route::get('view', 'OrdersController@viewOrder')->name('order.view');

            Route::group(['middleware' => ['permission:مدیریت سفارشات|همه|بخش سفارشات']], function() {
                Route::get('section', 'OrdersController@sectionIndex')->name('orders.section');
            });
            Route::group(['middleware' => ['permission:مدیریت سفارشات|همه|همه سفارشات']], function() {
                Route::get('/', 'OrdersController@index')->name('orders.show');
            });

            Route::get('{mode}', 'OrdersController@modeIndex')->name('orders.mode');

            Route::post('change-status', 'OrdersController@changeStatus')->name('changeOrders');

            Route::post('postCodeStore', 'OrdersController@postCodeStore')->name('postCode.store');
            Route::post('peykStore', 'OrdersController@peykStore')->name('peyk.store');


            Route::get('/CRM/invoice/{payment}', 'InvoiceController@index')->name('admin.invoice.index');

        });

        /*---------------------------------------------Cart Management-----------------------------------------------------*/
        Route::prefix('carts')->namespace('orders')->group(function () {

            Route::group(['middleware' => ['permission:مدیریت سبدهای خرید|همه|سبدهای در انتظار تایید']], function() {
                Route::get('pending', 'CartsController@indexPending')->name('carts.pending.index');
                Route::get('users/list', 'CartsController@indexUsers')->name('indexUsers');
                Route::get('cart-create/{user}', 'CartsController@createCart')->name('createCart');
                Route::get('cart-edit/{cart}', 'CartsController@editCart')->name('editCart');
                Route::patch('confirm-cart/{cart}', 'CartsController@confirmCart')->name('confirmCart');
                Route::delete('cart-product/delete/{cartProduct}', 'CartsController@deleteCartProduct')->name('deleteCartProduct');
                Route::post('update-cart/admin/{cart}', 'CartsController@updateCartAdmin')->name('updateCartAdmin');

            });
            Route::group(['middleware' => ['permission:مدیریت سبدهای خرید|همه|سبدهای تایید شده']], function() {
                Route::get('confirmed', 'CartsController@indexConfirmed')->name('carts.confirmed.index');
                Route::patch('pending-cart/{cart}', 'CartsController@pendingCart')->name('pendingCart');
            });
            Route::group(['middleware' => ['permission:مدیریت سبدهای خرید|همه|سبدهای در انتظار تایید|سبدهای تایید شده']], function() {

                Route::get('user-carts/{user}', 'CartsController@indexUserCarts')->name('carts.user.index');
            });

        });

        /*---------------------------------------------message Management-----------------------------------------------------*/
        Route::prefix('message')->namespace('message')->group(function () {

            Route::group(['middleware' => ['permission:پیام های گروهی|همه|ارسال پیام']], function() {
                Route::get('create', 'MessagesController@create')->name('message.create');
                Route::post('store', 'MessagesController@store')->name('message.store');
                Route::get('edit/{msMessage}', 'MessagesController@edit')->name('message.edit');
                Route::patch('update/{msMessage}', 'MessagesController@update')->name('message.update');
                Route::get('users-list/{msMessage}', 'MessagesController@usersIndex')->name('message.users');
                Route::post('users-list/{msMessage}/add', 'MessagesController@usersAdd')->name('message.users.add');
                Route::delete('users-list/{msParticipant}/destroy', 'MessagesController@destroyUser')->name('message.users.destroy');

            });

            Route::group(['middleware' => ['permission:پیام های گروهی|همه|لیست پیام ها']], function() {
                Route::get('list', 'MessagesController@index')->name('message.list');
                Route::get('message-view', 'MessagesController@messageView')->name('message.view');

            });

        });
    });





    Route::group(['middleware' => ['permission:قیمت گذاری همه|همه|تنظیمات انبار']], function() {
        Route::resource('CRM/price-chunk', 'Anbar\PriceChunkController');

    });



    Route::group(['middleware' => ['permission:تعریف برند|اطلاعات پایه کالا|همه|تنظیمات اولیه|تعریف نوع کالا|تعریف دسته بندی|تعریف مشخصات فنی|تعریف رنگ|تعریف کالا|تعریف سایز']], function() {
        Route::get('/CRM/store/setting', 'Anbar\StoreSettingController@show');
    });

    Route::group(['middleware' => ['permission:تعریف برند|اطلاعات پایه کالا|همه|تنظیمات اولیه']], function() {
        /*------Brand-----*/
        Route::get('CRM/createBrand', 'Anbar\BrandController@index');
        Route::post('addNewBrand', 'Anbar\BrandController@addNewItem');
        Route::get('CRM/brand/edit/{id}', 'Anbar\BrandController@editbrand');
        Route::get('CRM/brand/delete/{id}', 'Anbar\BrandController@deletebrand');
        Route::post('CRM/brand/edit', 'Anbar\BrandController@saveEditbrand');
    });




    Route::group(['middleware' => ['permission:اطلاعات پایه کالا|همه|تنظیمات اولیه|تعریف رنگ']], function() {
        /*------color-store-----*/
        Route::resource('/CRM/color','Anbar\ColorController');
    });
    Route::group(['middleware' => ['permission:تعریف دسته بندی|تعریف مشخصات فنی|اطلاعات پایه کالا|همه|تنظیمات اولیه|تعریف سایز']], function() {

        /*------Category-----*/
        Route::get('/CRM/category', 'Anbar\CategoryController@index')->name('category.show');
        Route::post('/CRM/category', 'Anbar\CategoryController@store')->name('category.store');

        Route::get('/CRM/category/edit/{category_id}', 'Anbar\CategoryController@edit');
        Route::post('/CRM/category/edit/{category_id}', 'Anbar\CategoryController@update')->name('category.update');
        Route::get('/CRM/category/delete/{category_id}', 'Anbar\CategoryController@delete');

        /*------size-----*/
        Route::get('/CRM/size/{category}', 'Anbar\SizeController@index')->name('size.show');
        Route::post('/CRM/size/store/{category}', 'Anbar\SizeController@store')->name('size.store');
        Route::get('/CRM/size/edit/{size}', 'Anbar\SizeController@edit')->name('size.edit');
        Route::post('/CRM/size/update/{size}', 'Anbar\SizeController@update')->name('size.update');
        Route::delete('/CRM/size/delete/{size}', 'Anbar\SizeController@destroy')->name('size.delete');


        /*------TecInfo-----*/
        Route::get('/CRM/CategoryTecInfo/{category}', 'Anbar\TecInfoController@index')->name('tecInfo.show');
        Route::get('/CRM/tecInfo/{category}', 'Anbar\TecInfoController@addShow')->name('tecInfo.add.show');
        Route::post('/addNewTecInfo/{category}', 'Anbar\TecInfoController@store')->name('tecInfo.add.store');
        Route::get('/CRM/tecInfoEdit/{tecInfo}', 'Anbar\TecInfoController@edit')->name('tecInfo.edit');
        Route::post('/CRM/tecInfoEdit/{tecInfo}', 'Anbar\TecInfoController@update')->name('tecInfo.update');
        Route::get('/CRM/tecInfo/delete/{category}/{tecInfo}', 'Anbar\TecInfoController@delete')->name('tecInfo.delete');

        /*------Nestable-----*/
        Route::get('/CRM/order-tecInfo/{category}', 'Anbar\TecInfoNestableController@index')->name('tecInfo.nestable.show');
        Route::get('/CRM/order-tecInfo', 'Anbar\TecInfoNestableController@store')->name('tecInfo.nestable.store');

        /*------StuffType-----*/
        Route::get('/CRM/createStuffType', 'Anbar\StuffTypeController@index');
        Route::post('/addNewStuffType', 'Anbar\StuffTypeController@addNewItem');
        Route::get('/CRM/StuffType/edit/{id}', 'Anbar\StuffTypeController@editStuffType');
        Route::get('/CRM/StuffType/delete/{id}', 'Anbar\StuffTypeController@deleteStuffType');
        Route::post('/CRM/StuffType/edit', 'Anbar\StuffTypeController@saveEditStuffType');
    });

    Route::group(['middleware' => ['permission:تعریف کالا|اطلاعات پایه کالا|همه|تنظیمات اولیه']], function() {
        /*------Stuff-----*/
        Route::get('/CRM/stuff', 'Anbar\StuffsController@index')->name('stuff.show');

        Route::get('/CRM/createStuff', 'Anbar\StuffsController@addStuffIndex')->name('addStuff.show');

        Route::post('addNewStuff', 'Anbar\StuffsController@addNewItem')->name('addStuff.store');

        Route::get('/CRM/stuff/edit/{id}', 'Anbar\StuffsController@editStuff');
        Route::get('/CRM/stuff/delete/{id}', 'Anbar\StuffsController@deleteStuff');
        Route::post('/CRM/stuff/edit', 'Anbar\StuffsController@saveEditStuff');
    });

    Route::group(['middleware' => ['permission:همه|تنظیمات انبار|لیست کالا|تعریف کالا']], function() {
        Route::prefix('CRM/Anbar')->group(function () {
            Route::namespace('Anbar')->group(function () {
                Route::get('product/get-modal', 'ProductController@getModal')->name('product.status.modal');
                Route::resource('product', 'ProductController');
                Route::get('product/byBrand/{brand}', 'ProductController@brandIndex')->name('product.brand');
                Route::get('product/byCategory/{category}', 'ProductController@categoryIndex')->name('product.category');
                Route::get('product/byStuffType/{stuffType}', 'ProductController@stuffTypeIndex')->name('product.stuffType');
                Route::get('product/byAvailable/{type}/{available}/{id}', 'ProductController@availableIndex')->name('product.available');
                Route::get('product/byStatus/{type}/{status}/{id}', 'ProductController@statusIndex')->name('product.status');
                Route::get('product/byQty/{type}/{qty}/{id}', 'ProductController@qtyIndex')->name('product.qty');
                Route::patch('product/change-status/{products}', 'ProductController@changeStatus')->name('product.change-status');

                /*------Product tec info-----*/
                Route::get('product/{product}/tecInfo', 'ProductTecInfoController@tecInfoIndex')->name('product.tecInfo.index');
                Route::patch('product/{product}/tecInfo', 'ProductTecInfoController@tecInfoStore')->name('product.tecInfo.store');

                /*------Product pdf-----*/
                Route::post('product/{product}/pdf/store', 'ProductPdfController@store')->name('product.pdf.store');
                Route::post('product/{pdf}/pdf/destroy', 'ProductPdfController@destroy')->name('product.pdf.destroy');



                /*------Product-Color-----*/
//            Route::get('product/productColor/{product}', 'ProductColorController@index')->name('product.color.index');
//            Route::get('product/productColor/create/{product}', 'ProductColorController@create')->name('product.color.create');
//            Route::post('product/productColor/store/{product}', 'ProductColorController@store')->name('product.color.store');
//            Route::get('product/productColor/{productsColor}/edit', 'ProductColorController@edit')->name('product.color.edit');
//            Route::patch('product/productColor/update/{productsColor}', 'ProductColorController@update')->name('product.color.update');
//            Route::delete('product/productColor/{productsColor}/delete', 'ProductColorController@destroy')->name('product.color.destroy');
//
            });
        });
    });

    ///dropzone
    Route::post('/CRM/imageUpload', 'Anbar\ImageUploadController@imageUpload');
    //ajax for delete photo
    Route::post('/CRM/deleteImage', 'Anbar\ImageUploadController@deleteImage');
    //ajax for pick photo
    Route::post('/CRM/pickBaseImage', 'Anbar\ImageUploadController@pickBaseImage');


    Route::post('/CRM/defineColor', 'Anbar\ProductColorController@defineColor');
    //ajax of delete color on product info page
    Route::post('/CRM/deleteProductColor', 'Anbar\ProductColorController@deleteColor');


});

