@extends('/CRM/layout')

@section('head')

    <link rel="stylesheet" href="{{asset('vendor/smsir/css/smsir-rtl.min.css')}}">
    <link rel="stylesheet" href="{{asset('vendor/smsir/css/style.css')}}">
    <title>سوابق ارسال پیامک</title>
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
@stop

@section('pageBar')
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>انبار</span>
    </li>

@stop

@section('content')
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="glyphicon glyphicon-envelope" style="font-size: 1em"></i>
                        <span class="caption-subject bold uppercase">سوابق ارسال پیامک</span>
                    </div>
                    <div class="pull-left">
                        <button type="button" data-toggle="tooltip" class="btn btn-danger"  data-original-title="موجودی"><h5>موجودی: {{$credit}} پیامک </h5></button>
                        <a target="_blank" href="https://www.sms.ir/" data-toggle="tooltip" class="btn btn-primary"  data-original-title="sms.ir"><h5>افزایش موجودی </h5></a>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="container">
                        <div class="panel-heading">
                            <div class="row">
                                <div class="col col-xs-6">
                                    <h3 class="panel-title">پیامک های ارسالی توسط وب سایت</h3>
                                </div>
                            </div>
                        </div>
                        <div class="panel-body" >
                            <table class="table table-striped table-bordered table-list">
                                <thead>
                                <tr>
                                    <th>ردیف</th>
                                    <th>وضعیت</th>
                                    <th>وضعیت ارسال</th>
                                    <th>شماره موبایل</th>
                                    <th>متن ارسالی</th>
                                    <th>ارسال از طریق</th>
                                    <th>زمان ارسال</th>
                                    <th><em class="fa fa-cog"></em></th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($smsir_logs as $log)
                                    <tr>
                                        <td>{{$loop->iteration}}</td>
                                        <td>{!! $log->sendStatus() !!}</td>
                                        <td>{{$log->response}}</td>
                                        <td>{{$log->to}}</td>
                                        <td>{{$log->message}}</td>
                                        <td>{{$log->from}}</td>
                                        <td>{{persianDiffForHumans($log->created_at)}}</td>
                                        <td align="center">
                                            <a onclick="return confirm('حذف شود؟')" href="{{route('deleteLog',['log'=>$log])}}" class="btn btn-danger"><em class="fa fa-trash"></em></a>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="panel-footer">
                            <div class="row">
                                {{ $smsir_logs->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@section('script')
    <script src="/jq-confirm/jquery-confirm.min.js"></script>
@stop



