
@yield('scripts')
<script src="/toastr/toastr.min.js"></script>
<script type="text/javascript" src="/sweetalert/sweetalert2.min.js"></script>
<script type="text/javascript" src="/SiteAssets/assets/javascripts/compare.js"></script>

@yield('footer')
<input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
@isset($errors)
    @if(count($errors) > 0)
        @php
            $i = 1;
                $text = "";
                foreach($errors->all() as $error){
                    $y = convert($i);
                    $text .=  "<p style='direction: rtl'>$y - $error</p>";
                    $i++;
                }
        @endphp
        <script>
            $(document).ready(function () {
                swal({
                    title: "خطا",
                    html: "{!! $text !!}",
                    type: "error",
                    showConfirmButton: true,
                    confirmButtonText: 'باشه',
                    reverseButtons: true
                });
            });
        </script>
    @endif
@endisset
<script>
    $(document).ready(function () {
        toastr.options.closeButton = true;
        toastr.options.progressBar = true;
    });

    function removeFromCart(id) {
        $("#loading").show();
        $.ajax({
            url: "{{route('removeFromCart')}}",
            type: "DELETE",
            data: {id:id,_token: $('#token').val()} ,
            success: function(data)
            {
                $('#cart').html(data);
                $("#loading").hide();
                swal({
                    title: "حذف شد ",
                    text: "کالا با موفقیت از سبد خرید حذف شد",
                    timer: 1000,
                    type: "success",
                    showConfirmButton: false
                });
            },
            error: function()
            {
                $("#loading").hide();
                swal({
                    title: "خطا",
                    text: "شبکه ضعیف است، لطفا صفحه را دوباره بارگذاری کنید",
                    timer: 1000,
                    type: "error",
                    showConfirmButton: false
                });
            }
        });
    }

    function removeCart() {

        $("#loading").show();
        $.ajax({
            url: "{{route('removeCart')}}",
            type: "DELETE",
            data: {_token: $('#token').val()} ,
            success: function(data)
            {
                $('#cart').html(data);
                $("#loading").hide();
                swal({
                    title: "حذف شد ",
                    text: "سبد خرید با موفقیت حذف شد",
                    timer: 1000,
                    type: "success",
                    showConfirmButton: false
                });
            },
            error: function()
            {
                $("#loading").hide();
                swal({
                    title: "خطا",
                    text: "شبکه ضعیف است، لطفا صفحه را دوباره بارگذاری کنید",
                    timer: 1000,
                    type: "error",
                    showConfirmButton: false
                });
            }
        });
    }

    //**********add to cart ***********\\
    $(document).on('click', ".pricing_forms", function (event) {

        var formdata = new FormData(this);
        $("#loading").show();
        $.ajax({
            url: "{{route('addToCart2')}}",
            type: "POST",
            data: formdata,
            beforeSend: function () {
                $("#body-overlay").show();
            },
            contentType: false,
            processData: false,
            success: function (data) {
                data = jQuery.parseJSON( data);
                if(data.data == 800){
                    $("#loading").hide();
                    swal({
                        title: "کالا تمام شد",
                        text: "لطفا رنگ های دیگری از محصول را انتخاب کنید",
                        type: "error",
                        showConfirmButton: false
                    });
                    toastr.warning("صفحه در حال بارگذاری مجدد است");
                    setTimeout(location.reload.bind(location), 4700);
                }else if(data.data == 700){
                    $("#loading").hide();
                    swal({
                        title: "بیش از حد مجاز ",
                        text: "لطفا رنگ های دیگری از محصول را انتخاب کنید",
                        timer: 1200,
                        type: "error",
                        showConfirmButton: false
                    });
                }else{
                    $('#cart').html(data.data);
                    $('.mobile_cart_count').addClass('blink_me').html(data.mcount);
                    $("#loading").hide();
                    swal({
                        title: "اضافه شد ",
                        text: "برای تکمیل خرید، به سبد خرید مراجعه کنید",
                        timer: 1000,
                        type: "success",
                        showConfirmButton: false
                    });
                }
            },
            error: function () {
                $("#loading").hide();
                swal({
                    title: "خطا",
                    text: "شبکه ضعیف است، لطفا صفحه را دوباره بارگذاری کنید",
                    timer: 1000,
                    type: "error",
                    showConfirmButton: false

                });
            }
        });
        event.preventDefault();
        return false;

    });

</script>

@if (alert()->ready())
    <script>
        swal({
            title: "{!! alert()->message() !!}",
            text: "{!! alert()->option('text') !!}",
            type: "{!! alert()->type() !!}",
            @if(alert()->option('timer'))
            timer: "{!! alert()->option('timer') !!}",
            showConfirmButton: false,
            @else
            showConfirmButton: true,
            confirmButtonText :'باشه',
            @endif
        });
    </script>
@endif

<script>
    var isMobile = false; //initiate as false
    // device detection
    if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)
        || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4))) {
        isMobile = true;
    }
    if(isMobile){
        $('.dropdown-link,.category-link-a').click(function(e){
            e.preventDefault();
            return false;
        })
    }

</script>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-132396617-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-132396617-1');
</script>
