@extends('public.layouts.SiteFront.main')
@section('content')
    <section class="collection-heading heading-content hidden-sm hidden-xs">
        <div class="container">
            <div class="row">
                <div class="collection-wrapper">
                    <div class="breadcrumb-group box-shadow">
                        <div class="breadcrumb clearfix">
                            <span><a href="{{route('home')}}">@isset($setteng){{$setteng->name}}@endisset</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a href="{{route('profile.show')}}">حساب کاربری {{$user->fname}} {{$user->lname}}</a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <!--detiles-->
                    <div class="col-md-12 info-detail-pro box-shadow clearfix sabad-p" id="code-container" style="direction: rtl; display : none; background-color: #ff2843">
                        <div class="panel panel-default off-box">
                            <div class="panel-heading" role="tab" id="heading2" style="padding: 15px 15px 0 15px;">
                                <h4 class="panel-title">
                                    <a role="button" data-toggle="collapse" href="#collapse2" aria-expanded="false" aria-controls="collapse2" class="trigger collapsed">
                                        <i id="arrow" class="fa fa-arrow-down"></i>                               ارسال کد تغییر رمز
                                    </a>
                                </h4>
                            </div>
                            <div id="collapse2" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading2" aria-expanded="false" style="height: 0px;">
                                <div class="panel-body">
                                    <div class="col-md-6 col-sm-6 col-xs-12 pull-right rtl">
                                        <span>اگر پیامک کد تغییر رمز را دریافت کرده اید در فیلد روبرو وارد کرده و سپس دکمه ثبت را بزنید</span>
                                    </div>
                                    <div class="col-md-6 col-sm-6 col-xs-12 pull-right">
                                        <form id="discountCodeForm" method="POST" action="{{route('resetPass.show')}}" >
                                            {{csrf_field()}}
                                            <div class="off-input">
                                                <input type="text" class="w100" name="resetPassCode" placeholder="کد تغییر رمز را اینجا وارد کنید" autocomplete="off">
                                            </div>
                                            <div class="off-submit">
                                                <button class="btn" style="width: 100%;" type="submit">ثبت کد</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">
                                <!--detiles-->
                                <div id="shopify-section-product-template" class="shopify-section m-b10">
                                    <div class="detail-content-inner">
                                        <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">
                                            <!--detiles-->
                                            <div class="col-md-12 col-sm-12 col-xs-12 box-shadow clearfix t-a-r p0 m-b20 user-info">
                                                <h4>
                                                    اطلاعات کاربر
                                                </h4>
                                                <table>
                                                    <tbody>
                                                    <tr>
                                                        <td>
                                                            <span>نام و نام خانوادگی :</span>
                                                            <span>{{$user->fname}} {{$user->lname}}</span>
                                                        </td>
                                                        <td>
                                                            <span>پست الکترونیک :</span>
                                                            <span class="iransans">{{$user->email}}</span>
                                                        </td>
                                                        <td>
                                                            <span>کدملی :</span>
                                                            <span class="iransans">{{$user->melli_code}}</span>
                                                        </td>
                                                        <td>
                                                            <span>شماره تلفن ثابت :</span>
                                                            <span class="iransans">{{$user->tell}}</span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span>شماره تلفن همراه :</span>
                                                            <span class="iransans">{{$user->mobile}}</span>
                                                        </td>
                                                        <td>
                                                            <span>تاریخ تولد :</span>
                                                            <span class="iransans">{{$user->birth}}</span>
                                                        </td>
                                                        <td>
                                                            <span>جنسیت :</span>
                                                            @if(!is_null($user->gender))
                                                                <span>@if($user->gender == 1)مرد @elseif($user->gender == 0)زن@endif</span>
                                                            @else
                                                                <span></span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <span>محل سکونت  :</span>
                                                            <span>{{$user->address}}</span>
                                                        </td>
                                                    </tr>

                                                    </tbody>
                                                </table>
                                                <a href="{{route('profile.personalInfo')}}"><div class="change-informations">ویرایش اطلاعات</div></a>
                                                <div class="change-password" onclick="passwordChange();">تغییر کلمه عبور</div>
                                            </div>
                                            <div class="col-md-12 col-sm-12 col-xs-12 box-shadow clearfix t-a-r p0 m-b20 user-info">
                                                <h4>
                                                    علاقه مندی ها
                                                </h4>
                                                <table>
                                                    <thead>
                                                    <tr>
                                                        <col width="100">
                                                        <col width="200">
                                                        <col width="200">
                                                        <col width="50">
                                                        <th class="text-center">
                                                            <span>تصویر</span>
                                                        </th>
                                                        <th class="text-center">
                                                            <span>نام</span>
                                                        </th>
                                                        <th class="text-center">
                                                            <span>نام لاتین</span>
                                                        </th>
                                                        <th class="text-center">
                                                            <span></span>
                                                        </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @if(isset($favorites) && count($favorites) > 0)
                                                        @foreach($favorites as $favorite)
                                                            <tr class='clickable-row' data-href='{{$favorite->Product->path()}}' style="cursor: pointer;">

                                                                <td class="text-center">
                                                                    <img src="{{$favorite->Product->base_thumbnail_url}}" style="border: 1px solid rgba(229,236,229,0.91);border-radius: 50%;width: 100px;">
                                                                </td>
                                                                <td class="text-center">
                                                                    <span class="iransans">{{$favorite->Product->name}}</span>
                                                                </td>
                                                                <td style="text-align: center">
                                                                    <span class="iransans">{{$favorite->Product->eng_name}}</span>
                                                                </td>
                                                                <td style="text-align: center">
                                                                    <form action="{{route('removeFavorite',$favorite)}}" method="POST">
                                                                        {{csrf_field()}}
                                                                        {{method_field('DELETE')}}
                                                                        <button type="submit" class="btn" data-toggle="tooltip" title="حذف از علاقه مندی"><i class="fa fa-close" aria-hidden="true"></i></button>
                                                                    </form>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                        @else
                                                            <tr>
                                                                <td class="text-center">
                                                                </td>
                                                                <td class="text-center" style="color: #ff2236">
                                                                    شما هنوز کالایی را به عنوان علاقه مندی انتخاب نکرده اید
                                                                </td>
                                                                <td class="text-center">
                                                                </td>
                                                                <td class="text-center">
                                                                </td>
                                                            </tr>
                                                    @endif
                                                    </tbody>
                                                </table>
                                            </div>

                                            <div class="col-md-12 col-sm-12 col-xs-12 box-shadow clearfix bought">
                                                <h4>سفارشات</h4>
                                                <div class="col-md-12">
                                                    @foreach($orders as $order)
                                                        <div class="panel panel-default off-box">
                                                            <div class="panel-heading" role="tab" id="heading2" style="padding: 15px 15px 0 15px;">
                                                                <h4 class="panel-title">
                                                                    <a role="button" data-toggle="collapse" href="#collapse{{$loop->iteration}}" aria-expanded="false" aria-controls="collapse2" class="trigger collapsed">
                                                                        <span>سفارش به تاریخ :</span>
                                                                        <span>{{convert($jdate->forge(strtotime($order->created_at))->format('l - dام %B Y')) }}</span>
                                                                        <span>ساعت: </span>
                                                                        <span>{{convert($jdate->forge(strtotime($order->created_at))->format('H:i:s')) }}</span>
                                                                        <hr>
                                                                        @if($order->status == 1)
                                                                            <span><i class="fa fa-dot-circle-o" style="color: #FF4F4F;"></i>مرحله اول ( در انتظار تایید )</span>
                                                                        @elseif($order->status == 2)
                                                                            <span><i class="fa fa-refresh" style="color: #2095f2;"></i>مرحله دوم ( در حال بررسی )</span>
                                                                        @elseif($order->status == 3)
                                                                            <span><i class="fa fa-pause" style="color: #cccb09;"></i>مرحله سوم ( در انتظار ارسال )</span>
                                                                        @elseif($order->status == 4)
                                                                            @php $postLog = $order->PostLog()->first(); @endphp
                                                                            @if($postLog->type == 0)
                                                                                <span><i class="fa fa-send" style="color: #22ca61;"></i>مرحله چهارم ( ارسال شده ) کد رهگیری مرصوله : {{convert($postLog->post_code)}}</span>
                                                                            @else
                                                                                <span><i class="fa fa-send" style="color: #22ca61;"></i>مرحله چهارم ( ارسال شده )</span>
                                                                            @endif
                                                                        @elseif($order->status == 5)
                                                                            <span><i class="fa fa-check-square-o" style="color: #cf2ac3;"></i>مرحله آخر ( تحویل داده شد )</span>
                                                                        @endif
                                                                    </a>
                                                                </h4>
                                                            </div>
                                                            <div id="collapse{{$loop->iteration}}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading2" aria-expanded="false" style="height: 0px;">
                                                                <div class="panel-body">
                                                                    <h4 class="panel-title" style="margin-bottom:2% ">
                                                                        کالاهای موجود در این سفارش :
                                                                    </h4>
                                                                    @foreach($order->Cart->CartProduct()->get() as $cart_product)
                                                                        <table>
                                                                            <tbody>
                                                                            <tr>
                                                                                <td>

                                                                                    <span> {{$cart_product->ProductColor->Product->eng_name}}</span>
                                                                                    <span> {{$cart_product->ProductColor->Product->name}}</span>
                                                                                </td>
                                                                                <td>
                                                                                    <span>کد :</span>
                                                                                    <span class="iransans">
                                                                                    {{$cart_product->productColorCode()}}
                                                                                </span>
                                                                                </td>
                                                                                <td>
                                                                                    <span>تعداد :</span>
                                                                                    <span class="iransans">{{$cart_product->qty}} </span>
                                                                                </td>
                                                                                <td>
                                                                                    <span>وضعیت :</span>
                                                                                    <span>
                                                                                    @if($order->status == 1)
                                                                                            در انتظار تایید
                                                                                        @elseif($order->status == 2)
                                                                                            در حال بررسی
                                                                                        @elseif($order->status == 3)
                                                                                            در انتظار ارسال
                                                                                        @elseif($order->status == 4)
                                                                                            ارسال شده
                                                                                        @elseif($order->status == 5)
                                                                                            تحویل داده شده
                                                                                        @endif
                                                                                </span>
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>
                                                                                    <span>قیمت واحد :</span>
                                                                                    <span class="iransans">{{convert(priceFormat($cart_product->base_sell_price))}}</span>
                                                                                </td>
                                                                                <td>
                                                                                    <span>قیمت کل :</span>
                                                                                    <span class="iransans">{{convert(priceFormat($cart_product->base_sell_price * $cart_product->qty))}}</span>
                                                                                </td>
                                                                                <td>
                                                                                    <span>تخفیف کل :</span>
                                                                                    <span class="iransans">{{convert(priceFormat($cart_product->discount))}}</span>
                                                                                </td>
                                                                                <td>
                                                                                    <span>مبلغ کل :</span>
                                                                                    <span>{{convert(priceFormat($cart_product->total))}}</span>
                                                                                </td>
                                                                            </tr>
                                                                            </tbody>
                                                                        </table>
                                                                        <br>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop
@section('title')
    <title>@isset($setteng){{$setteng->title}}@endisset</title>
@endsection

@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/product-styles.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/profile.css" rel="stylesheet" type="text/css" media="all">
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">




    <style>
        .jconfirm .jconfirm-box div.jconfirm-title-c{
            float: right;
        }
        .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content {
            float: right;
        }
    </style>
@stop

@section('scripts')
    <script src="/jq-confirm/jquery-confirm.min.js"></script>

@stop
@section('footer')
    <script>
        function passwordChange() {
            $.confirm({
                title: 'تغییر رمز عبور',
                content: 'آیا مطمئن هستید؟',
                buttons: {
                    somethingElse2: {
                        text: 'خیر',
                        btnClass: 'btn-red',
                        action: function () {}
                    },
                    somethingElse: {
                        text: 'تایید',
                        btnClass: 'btn-blue',
                        action: function () {
                            $('#loading').show();
                            $.ajax({
                                url     : "{{route('resetPassReq')}}",
                                type    :"GET",
                                cash    : false,
                                success : function() {
                                    $('#loading').hide();
                                    swal({
                                        title: "پیام کوتاه ارسال شد",
                                        text: "لطفا بخش پیام کوتاه تلفن همراه خود را کنترل کنید",
                                        type: "info",
                                        timer: 2100,
                                        showConfirmButton: false
                                    });
                                    $('#code-container').show();
                                }
                            });

                        }
                    }

                }
            });
        }

        $(document).on('click', "#heading2", function () {

            if($('#arrow').hasClass('fa fa-arrow-down')){
                $('#arrow').removeClass('fa fa-arrow-down').addClass('fa fa-arrow-up')
            }else{
                $('#arrow').removeClass('fa fa-arrow-up').addClass('fa fa-arrow-down')

            }
        });


            $(".clickable-row").click(function() {
                var href = $(this).data("href");
                window.location = href;
            });

    </script>
@endsection