@extends('public.layouts.SiteFront.main')
@section('title')
    <title> {{$product->name }} | {{$product->Brand->brandName}} </title>
    <meta name="description" content="{{strip_tags($product->short_description)}}"/>
    <meta name="keywords" lang="fa" content="@isset($setteng){{$setteng->keywords}}@endisset">
    <meta property="og:title" content="{{$product->name}}"/>
    <meta property="og:description" content="{{strip_tags($product->short_description)}}"/>
    <meta property="og:image" content="@isset($setteng){{url('/').$setteng->fave_logo}}@endisset"/>
    <meta property="og:locale" content="fa"/>
    <meta property="og:type" content="website"/>
    <meta property="og:url" content="{{url($product->path())}}"/>
    <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>

@endsection
@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/share-popup.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/product-styles.css?1" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/rate.css" rel="stylesheet" type="text/css" media="all">
    <!--only for this page scripts-->
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/scripts.js"></script>
    <!--xzoome-->
    <link rel="stylesheet" type="text/css" href="/SiteAssets/assets/stylesheets/xzoom.css" media="all" />
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/xzoom.min.js"></script>
    <script src="/SiteAssets/assets/javascripts/xzoom/modernizr.js"></script>
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/xzoom/jquery.hammer.min.js"></script>
    <link type="text/css" rel="stylesheet" media="all" href="/SiteAssets/assets/stylesheets/xzoom/magnific-popup.css" />
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/xzoom/jquery.fancybox.js"></script>
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/xzoom/magnific-popup.js"></script>


@stop
@section('php')
    @php
        $categories = new \App\Models\Category();
        $newestItem = new \App\Models\NewestItem();
    @endphp
@stop
@section('head')
    <style>
        .product-price #prices p{
            width: 100%;
            color: #e0493e;
            font-weight: bold;
            font-size: 2em;
            margin: 0;
            padding: 3px 0;
        }
    </style>
@stop
@section('content')
    <section class="collection-heading heading-content hidden-sm hidden-xs" title="@isset($setteng){{$setteng->title}}@endisset">
        <div class="container">
            <div class="row">
                <div class="collection-wrapper">
                    <div class="breadcrumb-group box-shadow">
                        <div class="breadcrumb clearfix">
                            <span><a title="@isset($setteng){{$setteng->title}}@endisset" href="{{route('home')}}">@isset($setteng){{$setteng->name}}@endisset</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a title="{{$product->Category->StuffType->stuffType}}" href="{{url($product->Category->StuffType->path())}}">{{$product->Category->StuffType->stuffType}}</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a title="{{$product->Category->category }}" href="{{url($product->Category->path())}}">{{$product->Category->category }}</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a title="{{$product->name}}" href="{{url($product->path())}}">{{$product->name}} </a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10" title="{{$product->name}}">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">

                                <!--details-->
                                <div class="col-md-12 info-detail-pro box-shadow clearfix">
                                    <div class="col-md-5 col-sm-5 col-xs-12 product-gallery" id="magnific">
                                        <div class="large-5 column">
                                            <div class="xzoom-container">
                                                <div class="icons">
                                                    <button id="favorite-btn" data-id="{{$product->id}}" data-toggle="tooltip" data-placement="bottom" title="افزودن به علاقه مندی ها"><i class="fa fa-heart"></i></button>
                                                    <button id="share-btn" data-toggle="tooltip" data-placement="bottom" title="اشتراک گذاری"><i class="fa fa-share-alt"></i></button>
                                                    <form action="{{route('compare.index')}}" method="get" >
                                                        <input type="hidden" name="TDX[1]" value="{{$product->id}}">
                                                        <button class="compare-btn" type="submit"  data-toggle="tooltip" data-placement="bottom" title="مقایسه کالا"><i class="fa fa-balance-scale"></i></button>
                                                        <span class="exchange current"></span>
                                                    </form>
                                                </div>
                                                {{--modal of sharing--}}
                                                <div id="myModal1" class="modal">
                                                    <!-- Modal content -->
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <span class="close">&times;</span>
                                                            <h2>اشتراک گذاری</h2>
                                                        </div>
                                                        <div class="modal-body">

                                                            <a title="{{$product->name}}" class="fa fa-facebook" target="_blank"  href="http://www.facebook.com/sharer/sharer.php?m2w&amp;s=100&amp;p[url]={{url($product->path())}}&amp;p[images][0]={{URL::to("/").$product->base_img_url}}&amp;p[title]={{$product->name}}&amp;p[summary]={{$product->name}}&zwnj;{{$product->name}}"></a>
                                                            <a title="{{$product->name}}" class="fa fa-twitter" target="_blank" href="http://www.twitter.com/share?url={{url($product->path())}}"></a>
                                                            <a title="{{$product->name}}" class="fa fa-telegram" target="_blank" href="https://telegram.me/share/url?url={{url($product->path())}}&text={{$product->name}}"></a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="slider-img" style="">
                                                    @if(!is_null($product->base_medium_url) and !is_null($product->base_img_url))
                                                        <img class="xzoom5" id="xzoom-magnific" src="{{URL::to("/").$product->base_medium_url}}" xoriginal="{{URL::to("/").$product->base_img_url}}" alt="{{$product->name}}" title="{{$product->name}}" />
                                                    @else
                                                        <img class="xzoom5" id="xzoom-magnific" src="{{path_to_images('defaults/default.png')}}" xoriginal="{{path_to_images('defaults/default.png')}}" alt="{{$product->name}}" title="{{$product->name}}" style="opacity: 0.3"/>
                                                    @endif
                                                    <div class="img-zoom-mask"><img src="/SiteAssets/assets/images/mask.png" alt="" title="{{$product->name}}"></div>
                                                </div>
                                                <div class="xzoom-thumbs">
                                                    @foreach($product->productsGallery()->get() as $image)
                                                        <a title="{{$product->name}}" href="{{URL::to("/").$image->image_path }}">
                                                            <img class="xzoom-gallery5" width="80" src="{{URL::to("/").$image->image_path_th }}"  xpreview="{{URL::to("/").$image->image_path_m }}" alt="{{$product->name}}" title="{{$product->name}}">
                                                        </a>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-7 col-sm-7 col-xs-12 product-info" id="product-information">
                                        <div class="product-titles">
                                            <h1 title="{{$product->name}}" class="title">{{$product->name}}</h1>
                                            <h3 title="{{$product->eng_name}}">{{$product->eng_name}}</h3>
                                            @if(!is_null($totalRate))
                                                <div class="rating-star">

													<span class="spr-badge" data-rating="0.0" data-toggle="tooltip" data-placement="top" title="" data-original-title="از 10 نظر" aria-describedby="tooltip248084">
                                                        <span class="spr-starrating spr-badge-starrating">
                                                            <i style="font-family: IRANSans;font-style: normal;">{{$totalRate}}</i>
                                                            <i class="spr-icon spr-icon-star" style=""></i>
                                                        </span>
                                                        <span class="spr-badge-caption">
: امتیاز
                                                        </span>
													</span>
                                                </div>
                                            @else
                                                <div class="rating-star">
													<span class="spr-badge" data-rating="0.0">
                                                        <span class="spr-badge-caption">
امتیازی ثبت نشده
                                                        </span>
													</span>
                                                </div>
                                            @endif
                                        </div>

                                        <div class="vijhegiha">
                                            <ul>
                                                <li>
                                                    <span>برند</span><i>:</i><span><a title="{{$product->Brand->brandName}}" href="/search?category[0]={{$product->Category->id}}&brand[{{$product->Brand->id}}]={{$product->Brand->id}}">{{$product->Brand->brandName}}</a></span>
                                                </li>
                                                <li>
                                                    <span>دسته بندی</span><i>:</i><span><a title="{{$product->Category->category}}" href="/search?category[0]={{$product->Category->id}}">{{$product->Category->category}}</a></span>
                                                </li>
                                            </ul>
                                        </div>

                                        <div class="product-options " >
                                            <i class="border"></i>
                                            <div class="product-price">
                                                <div id="prices">
                                                    @if($product->checkAvailable())
                                                        <span class="price-title">قیمت :</span>
                                                        @if(isset($products_colors))
                                                            @foreach($products_colors as $productColor)
                                                                @if($productColor->checkAvailable())
                                                                    <div class="price-color" id="price-{{$productColor->id}}" @if($loop->iteration !== 1 ) style="display: none" @endif >
                                                                        @if(!is_null($productColor->discount_sell_price))
                                                                            <div class="price-1"><h2>{{priceFormat($productColor->discount_sell_price)}}</h2><span>تومان</span></div>
                                                                            <div class="price-2"><h4>{{priceFormat($productColor->base_sell_price)}}</h4><span>تومان</span></div>
                                                                        @else
                                                                            <div class="price-1"><h2>{{priceFormat($productColor->base_sell_price)}}</h2><span>تومان</span></div>
                                                                        @endif
                                                                    </div>
                                                                @endif
                                                            @endforeach
                                                        @else
                                                            @if(!is_null($product->discount_sell_price))
                                                                <div class="price-1"><h2>{{priceFormat($product->discount_sell_price)}}</h2><span>تومان</span></div>
                                                                <div class="price-2"><h4>{{priceFormat($product->base_sell_price)}}</h4><span>تومان</span></div>
                                                            @else
                                                                <div class="price-1"><h2>{{priceFormat($product->base_sell_price)}}</h2><span>تومان</span></div>
                                                            @endif
                                                        @endif
                                                    @else
                                                        <!--<p class="product-price-un">ناموجود</p>-->
                                                                                                                <a href="{{url('page/پشتیبانی')}}" class="btn btn-info hidden-xs"><i class="fa fa-phone"></i> تماس بگیرید</a>
                                                        <a href="tel:09100910678" class="btn btn-info hidden-sm hidden-md hidden-lg"><i class="fa fa-phone"></i> تماس بگیرید</a>

                                                    @endif
                                                </div>
                                            </div>
                                            @if($product->checkAvailable())
                                                <div class="add-to-cart-1">
                                                    <form id="pricing_form" action="{{route('addToCart')}}" method="POST" enctype="multipart/form-data">
                                                        {{csrf_field()}}
                                                        <input type="hidden" id="productColorId" name="productColorId" value="{{$product->productsColor()->first()->id}}">
                                                        <button type="submit"><i class="fa fa-shopping-cart"></i><i>افزودن به سبد خرید</i></button>
                                                        <a href="tel:09100910678" class="phone hidden-sm hidden-md hidden-lg"><i class="fa fa-phone"></i> </a>
                                                        <a href="https://t.me/AmazonTelecom" target="_blank" class="telegram hidden-sm hidden-md hidden-lg"><i class="fa fa-paper-plane"></i> </a>

                                                    </form>
                                                </div>
                                            @endif
                                        </div>
                                        <i class="border"></i>

                                        <div class="description" itemprop="description">{!! $product->short_description !!}</div>

                                        {{--<div id="slogans">--}}
                                            {{--<ul class="clearfix">--}}
                                                {{--@foreach($services as $service)--}}
                                                    {{--<li>--}}
                                                        {{--<a href="{{$service->url}}" class="clearfix" title="{{$service->title}}" target="_blank">--}}
                                                            {{--<img class="d-rtl service-img" src="{{$service->image_path}}" alt="{{$service->title}}" title="{{$service->title}}">--}}
                                                            {{--<span>{{$service->title}}</span>--}}
                                                        {{--</a>--}}
                                                    {{--</li>--}}
                                                {{--@endforeach--}}
                                            {{--</ul>--}}
                                        {{--</div>--}}
                                        @if(!$product->pdfs->isEmpty())
                                            @foreach($product->pdfs as $pdf)
                                        <a target="_blank" href="{{asset($pdf->pdf)}}" class="btn-pdf-downloader"> <i class="fa fa-file-pdf-o"></i>  {{$pdf->title}}</a>
                                            @endforeach
                                        @endif
                                    </div>
                                    <a href="#fani" class="col-md- col-sm-7 col-xs-12 text-center" title="مشاهده مشخصات فنی">
                                        <span class="go-down">
                                        <i class="fa fa-angle-double-down"></i>
                                            </span>
                                    </a>
                                </div>


                                <!--tabs-->
                                <div class="product-tabs box-shadow">
                                    <ul class="nav nav-tabs">
                                        <li class="active"><a data-toggle="tab" href="#fani">مشخصات فنی</a></li>
                                        <li><a data-toggle="tab" href="#barrasi">نقد و بررسی</a></li>
                                        <li><a data-toggle="tab" href="#nazarat">نظرات کاربران</a></li>
                                    </ul>

                                    <div class="tab-content tab-detiles">
                                        <div id="fani" class="tab-pane fade in active">
                                            <h3 title="مشخصات فنی{{$product->name}}"> مشخصات فنی</h3>
                                            <span class="fani-name">{{$product->name}}</span>
                                            <div class="moshakhasat">
                                                <ul>
                                                    @foreach($tecs as $tec)
                                                        {!! LAHelper::print_tecs($product,$tec) !!}
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                        <div id="barrasi" class="tab-pane barrasi fade">
                                            <h3 title="نقد و بررسی{{$product->name}}">نقد و بررسی</h3>
                                            <span>
													{!! $product->review !!}
                                            </span>
                                        </div>
                                        <div id="nazarat" class="tab-pane barrasi fade">

                                            <h3 title="نظرات{{$product->name}}">نظر شما</h3>
                                            <div class="nazarat">
                                                @if(!Auth::check())
                                                    <div class="nazar-login">
                                                        <h4 title="{{$product->name}}">شما هم می توانید در مورد این کالا نظر بدهید</h4>
                                                        <span>برای ثبت نظرات، نقد و بررسی، لازم است که شما ابتدا وارد حساب کاربری خود شوید.</span>
                                                        <button class="btn" id="nazar-login">نظر خود را بنویسید</button>
                                                    </div>
                                                @else
                                                    <div class="contact-form-group col-md-12 pull-right">

                                                        <h4 title="{{$product->name}}">نظر خود را وارد نمایید</h4>
                                                        <span>نظر، انتقاد و بررسی خود را در کادر زیر وارد نموده و دیگر کاربران را راهنمایی کنید.</span>

                                                        <form method="post" action="{{route('review.store')}}" id="contact_form" class="contact-form" accept-charset="UTF-8">
                                                            {{csrf_field()}}
                                                            <div class="contactFormWrapper">

                                                                <div>
                                                                    <input type="text" name="name" value="{{old('name')}}" placeholder="نام"  autocomplete="off">
                                                                </div>
                                                                <div class="rating-star" >
                                                                    <span class="spr-badge">
                                                                        <span class="spr-badge-caption">
امتیاز دهید:
                                                                        </span>

                                                                        <fieldset class="rating spr-starrating spr-badge-starrating">
                                                                            <input type="radio" id="star5" name="rating" class="review" data-content="5"/><label class = "full" for="star5" title="Awesome - 5 stars"></label>
                                                                            <input type="radio" id="star4" name="rating" class="review" data-content="4" /><label class = "full" for="star4" title="Pretty good - 4 stars"></label>
                                                                            <input type="radio" id="star3" name="rating" class="review" data-content="3" /><label class = "full" for="star3" title="Meh - 3 stars"></label>
                                                                            <input type="radio" id="star2" name="rating" class="review" data-content="2" /><label class = "full" for="star2" title="Kinda bad - 2 stars"></label>
                                                                            <input type="radio" id="star1" name="rating" class="review" data-content="1" /><label class = "full" for="star1" title="Sucks big time - 1 star"></label>
                                                                        </fieldset>

                                                                    </span>
                                                                </div>
                                                                <input type="text" name="review_rate" id="review_rate" value="{{old('rate')}}" hidden>
                                                                <input type="text" name="product_id"  value="{{$product->id}}" hidden>
                                                                <div>
                                                                    <textarea rows="15" cols="75" name="text"  placeholder="متن نظر شما">{{old('text')}}</textarea>
                                                                </div>
                                                                <div>
                                                                    <input type="submit" value="ارسال" class="btn">
                                                                </div>
                                                            </div>
                                                        </form>
                                                    </div>
                                                @endif
                                                @if(isset($reviews) && !$reviews->isEmpty())
                                                    <h3 title="{{$product->name}}نظرات برای ">نظرات کاربران</h3>
                                                    <ul class="commentslist">
                                                        @foreach($reviews as $comment)
                                                            <li>
                                                                <div class="user-comment-container">
                                                                    <div class="user-comment-header clearfix">
                                                                        <div class="user-info right clearfix ">

                                                                            <div class="author">
                                                                                <span>{{$comment->name}}</span>
                                                                                <time>{{convert($jDate->forge($comment->created_at)->format('%d %B، %Y'))}}</time>

                                                                            </div>
                                                                            <div class="rating-star pull-left">
                                                                                <span class="spr-badge">
                                                                                    <div id="stars_container">
                                                                                                                                                                            <span class="spr-badge-caption">
                                                                                        امتیاز کابر به محصول:
                                                                                    </span>
                                                                                    <span class="spr-starrating spr-badge-starrating" >
                                                                                        @for($i=5; $i >= 1 ;$i--)
                                                                                            @if($i <= $comment->product_score)
                                                                                                <i class="spr-icon spr-icon-star"></i>
                                                                                            @else
                                                                                                <i class="spr-icon spr-icon-star" style="color:#D3D3D3"></i>
                                                                                            @endif
                                                                                        @endfor
                                                                                    </span>

                                                                                    </div>
                                                                                </span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="user-comment-content clearfix">
                                                                        <div class="content-panel right">
                                                                            <div class="subject">{{$product->name}} - {{$product->eng_name}}</div>
                                                                            <div class="comment-text" itemprop="description">
                                                                                <span>{!!  $comment->text !!}</span>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    @foreach($comment->replay as $replay)
                                                                        <div class="user-comment-content clearfix replay">
                                                                            <div class="content-panel right">
                                                                                <div class="subject">پاسخ مدیر</div>
                                                                                <div class="comment-text" itemprop="description">
                                                                                    <span>{!!  $replay->text !!}</span>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                    @endforeach
                                                                    @php
                                                                        $score = $comment->ReviewScore()->get();

                                                                        $positive = $score->sum('positive');
                                                                        $negative = $score->sum('negative');
                                                                    @endphp
                                                                    <div class="like-container left clearfix">
                                                                        <span>آیا این نظر برایتان مفید بود ؟</span>
                                                                        <button class="dislike" data-id="{{$comment->id}}" >
                                                                            <span>خیر</span>
                                                                            <span class="counter dislike" id="dislike_{{$comment->id}}">{{$negative}}</span>
                                                                        </button>
                                                                        <button class="like" data-id="{{$comment->id}}" >
                                                                            <span>بلی</span>
                                                                            <span class="counter like" id="like_{{$comment->id}}">{{$positive}}</span>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div id="login" class="modal">
                                    <!-- Modal content (login pop up) -->
                                    <div class="modal-content modal-content-login" style="width: 300px;">
                                        <div class="modal1-header">
                                            <span class="close1">&times;</span>
                                            <h2>ورود</h2>
                                        </div>
                                        <form class="modal1-body" action="{{route('review.login')}}" method="POST">
                                            {{csrf_field()}}
                                            <p>شماره موبایل</p>
                                            <input type="text" name="mobile" placeholder="شماره همراه" style="width: 100%; margin-bottom: 10px;">
                                            <p>رمز عبور</p>
                                            <input type="password" name="password" placeholder="رمز عبور" style="width: 100%; margin-bottom: 10px;">
                                            <div class="filter filter--existence">
                                                <div class="filter__items">
                                                    <input id='remember-me' type='checkbox' name="remember" {{ old('remember') ? 'checked' : '' }}>
                                                    <label for='remember-me'>
                                                        <span></span>مرا به خاطر بسپار
                                                    </label>
                                                </div>
                                            </div>
                                            <input type="submit" value="ارسال" class="btn" style="width: 100%; margin-bottom: 10px;margin-top: 33px;">
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div id="shopify-section-index-collection-product" class="shopify-section index-section index-section-colpro">
        <section class="collection-colpro">
            <div class="collection-colpro-wrapper">
                <div class="container p0-768">
                    <div class="row">
                        <div class="collection-colpro-inner">
                            <div class="related-products col-sm-12 box-shadow" style="margin: 20px 0;padding:0px;-webkit-border-radius: 4px;-moz-border-radius: 4px;border-radius: 4px; overflow: hidden;">
                                <div class="collection-title home-title page-title"><span>محصولات مرتبط این محصول</span></div>
                                <div class="group-related">
                                    <div class="group-related-inner">
                                        <div class="rp-slider">
                                            @foreach($closest_products as $closest_product)
                                                @if(!is_null($closest_product))
                                                    <div class="content_product">
                                                        <div class="row-container product list-unstyled clearfix">
                                                            <div class="row-left">
                                                                <a title="{{$closest_product->name}}" href="{{url($closest_product->path())}}"
                                                                   class="hoverBorder container_item">
                                                                    <div class="hoverBorderWrapper">
                                                                        {!! $closest_product->getImage() !!}
                                                                        <div class="mask"></div>
                                                                    </div>
                                                                </a>
                                                                <div class="product-top-line">
                                                                    {!! $closest_product->getCart() !!}
                                                                </div>
                                                                {!! $closest_product->getPercent() !!}
                                                            </div>
                                                            <div class="row-right animMix">
                                                                <div class="product-title">
                                                                    <a title="{{$closest_product->name}}" class="title-5"
                                                                       href="{{url($closest_product->path())}}">{{$closest_product->name}}</a>
                                                                </div>
                                                                <div class="product-price">
                                                                    {!! $closest_product->getPrice() !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                                <!--END -->
                            </div>

                            <div class="collection-colpro-content box-shadow">
                                <span class="colpro_title">محصولات دیگر</span>
                                <div class="colpro_content colpro_1_index-collection-product">
                                    @foreach($random_products as $random_product)
                                        @if(!is_null($random_product))
                                            <div class="content_product">
                                                <div class="row-container product list-unstyled clearfix">
                                                    <div class="row-left">
                                                        <a title="{{$random_product->name}}" href="{{url($random_product->path())}}"
                                                           class="hoverBorder container_item">
                                                            <div class="hoverBorderWrapper">
                                                                {!! $random_product->getImage() !!}
                                                                <div class="mask"></div>
                                                            </div>
                                                        </a>

                                                            <div class="product-top-line">
                                                                {!! $random_product->getCart() !!}
                                                            </div>

                                                        {!! $random_product->getPercent() !!}
                                                    </div>
                                                    <div class="row-right animMix">
                                                        <div class="product-title">
                                                            <a title="{{$random_product->name}}" class="title-5"
                                                               href="{{url($random_product->path())}}">{{$random_product->name}}</a>
                                                        </div>
                                                        <div class="product-price">
                                                            {!! $random_product->getPrice() !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@stop



@section('scripts')
    <script src="/SiteAssets/assets/javascripts/xzoom/foundation.min.js"></script>
    <script src="/SiteAssets/assets/javascripts/xzoom/setup.js"></script>
    {{--<script src="https://cdnjs.cloudflare.com/ajax/libs/vue/2.5.13/vue.min.js"></script>--}}
    {{--<script src="https://cdnjs.cloudflare.com/ajax/libs/socket.io/2.0.4/socket.io.js"></script>--}}
@stop
@section('footer')

    <script>

        <!--pop up share script -->
        // Get the modal
        var modal = document.getElementById('myModal1');

        // Get the button that opens the modal
        var btn = document.getElementById("share-btn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal
        btn.onclick = function() {
            modal.style.display = "block";
        };

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
            modal.style.display = "none";
        };

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }
    </script>

    <!--pop up comment script -->
    <script>
        // Get the modal
        var modal1 = document.getElementById('login');

        // Get the button that opens the modal
        var btn = document.getElementById("nazar-login");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close1")[0];


        // When the user clicks the button, open the modal
        btn.onclick = function() {
            modal1.style.display = "block";
        };


        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal1.style.display = "none";
        };

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
            if (event.target == modal1) {
                modal1.style.display = "none";
            }
        };

    </script>
    <script>

        $(function() {
            $("#color-size").change(function() {
                var id = $(this).val();
                $('#productColorId').val(id);
            });
        });

        $(function() {
            $(".color-item").click(function() {
                if (!$(this).hasClass('active')) {
                    $(".color-item.active").removeClass("active");
                    $('.price-color').hide();

                    $(this).addClass("active");
                    var id = $(this).attr('id');
                    $('#price-'+id).show();
                    $('#productColorId').val(id);
                }
            });
        });

        //**********add to cart ***********\\

        $("#pricing_form").on('submit',(function(e) {
            var formdata = new FormData(this);
            $("#loading").show();
            $.ajax({
                url: "{{route('addToCart')}}",
                type: "POST",
                data: formdata ,
                beforeSend: function(){$("#body-overlay").show();},
                contentType: false,
                processData:false,
                success: function (data) {
                    data = jQuery.parseJSON( data);
                    if(data.data == 800){
                        $("#loading").hide();
                        swal({
                            title: "کالا تمام شد",
                            text: "لطفا رنگ های دیگری از محصول را انتخاب کنید",
                            type: "error",
                            showConfirmButton: false
                        });
                        toastr.warning("صفحه در حال بارگذاری مجدد است");
                        setTimeout(location.reload.bind(location), 4700);
                    }else if(data.data == 700){
                        $("#loading").hide();
                        swal({
                            title: "بیش از حد مجاز ",
                            text: "لطفا رنگ های دیگری از محصول را انتخاب کنید",
                            type: "error",
                            timer: 1200,
                            showConfirmButton: false
                        });
                    }else{
                        $('#cart').html(data.data);
                        $('.mobile_cart_count').addClass('blink_me').html(data.mcount);
                        $("#loading").hide();
                        swal({
                            title: "اضافه شد ",
                            text: "برای تکمیل خرید، به سبد خرید مراجعه کنید",
                            type: "success",
                            timer: 1000,
                            showConfirmButton: false
                        });
                    }
                },
                error: function () {
                    $("#loading").hide();
                    swal({
                        title: "خطا",
                        text: "شبکه ضعیف است، لطفا صفحه را دوباره بارگذاری کنید",
                        timer: 1000,
                        type: "error",
                        showConfirmButton: false
                    });
                }
            });
            e.preventDefault();
            return false;
        }));

    </script>

    {{--stars--}}
    <script>
        $(document).on('click', ".review", function () {
            var star = $(this).attr('data-content');

            $("#review_rate").val(star);

            $(".spr-badge-starrating i").removeClass("active");

            for(var i = 1; i <= star ; i++ ){
                $("#star_"+i).addClass('active');
            }
        });
    </script>
    <script>
        $(document).on('click', ".like", function () {
            var review_id = $(this).attr('data-id');

            $.ajax({
                url     : "{{route('review.positive')}}",
                type    :"POST",
                cash    : false,
                data    :{ review_id : review_id,_token:$('#token').val()},
                success :
                    function(response) {
                        if(response == 13){
                            swal({
                                title: "خطا!",
                                text: "شما به نظر خود نمی توانید امتیاز دهید",
                                type: "error",
                                showConfirmButton: true,
                                confirmButtonText :'باشه'
                            });
                        }else if(response == 12){
                            swal({
                                title: "خطا!",
                                text: "بیش از یکبار نمی توان به یک نظر امتیاز داد",
                                type: "error",
                                showConfirmButton: true,
                                confirmButtonText :'باشه'
                            });
                        }else{
                            $('#like_'+review_id).html(response.positive2);
                            $('#dislike_'+review_id).html(response.negative2);
                        }

                    },
                error :
                    function( ) {
                        swal({
                            title: "خطا !",
                            text: "ارتباط ضعیف است لطفا صفحه را دوباره بارگذاری کنید",
                            type: "error",
                            showConfirmButton: true,
                            confirmButtonText :'باشه'
                        });
                    }
            });

        });
    </script>
    <script>
        $(document).on('click', ".dislike", function () {
            var review_id = $(this).attr('data-id');

            $.ajax({
                url     : "{{route('review.negative')}}",
                type    :"POST",
                cash    : false,
                data    :{ review_id : review_id,_token:$('#token').val()},
                success :
                    function(response) {
                        if(response == 13){
                            swal({
                                title: "خطا!",
                                text: "شما به نظر خود نمی توانید امتیاز دهید",
                                type: "error",
                                showConfirmButton: true,
                                confirmButtonText :'باشه'
                            });
                        }else if(response == 12){
                            swal({
                                title: "خطا!",
                                text: "بیش از یکبار نمی توان به یک نظر امتیاز داد",
                                type: "error",
                                showConfirmButton: true,
                                confirmButtonText :'باشه'
                            });
                        }else{
                            $('#like_'+review_id).html(response.positive2);
                            $('#dislike_'+review_id).html(response.negative2);
                        }

                    },
                error :
                    function( ) {
                        swal({
                            title: "خطا !",
                            text: "ارتباط ضعیف است لطفا صفحه را دوباره بارگذاری کنید",
                            type: "error",
                            showConfirmButton: true,
                            confirmButtonText :'باشه'
                        });
                    }
            });

        });

        $(document).on('click', "#favorite-btn", function () {
            var id = $(this).attr('data-id');

            $.ajax({
                url     : "{{route('addToFavorites')}}",
                type    :"POST",
                cash    : false,
                data    :{ id : id,_token:$('#token').val(),_method:'PATCH'},
                success :
                    function() {
                        swal({
                            title: "اضافه شد",
                            text: "این کالا به علاقه مندی های شما اضافه شد، می توانید لیست علاقه مندی های را در پروفایل کاربری خود مشاهده کنید",
                            type: "success",
                            showConfirmButton: true,
                            confirmButtonText :'باشه'
                        });
                    },
                error :
                    function( ) {
                        swal({
                            title: "خطا !",
                            text: "ارتباط ضعیف است لطفا صفحه را دوباره بارگذاری کنید",
                            type: "error",
                            showConfirmButton: true,
                            confirmButtonText :'باشه'
                        });
                    }
            });

        });
        <script type="application/ld+json">
            {
                "@context": "http://schema.org/",
                "@type": "Product",
                "name": "{{$product->name}}",
                "image": "{{URL::to("/").$product->base_img_url}}",
                "description": "{{str_limit(strip_tags($product->short_description))}}",
                "mpn": "925872",
                "brand": {
                    "@type": "{{$product->Category->category}}",
                    "name": "{{$product->Brand->brandName}}"
                },
                "aggregateRating": {
                    "@type": "AggregateRating",
                    "ratingValue": "@if(strip_tags($product->getRate()) == 'بدون امتیاز')1.0 @else {{strip_tags($product->getRate())}} @endif",
                    "reviewCount": "100"
                },
                "offers": {
                    "@type": "Offer",
                    "priceCurrency": "تومان",
                    "price": "@if(!is_null($product->discount_sell_price)){{priceFormat($product->discount_sell_price)}}@else{{priceFormat($product->base_sell_price)}} @endif",
                    "priceValidUntil": "{{\Carbon\Carbon::now()->addYear(1)->format('Y-m-d')}}",
                    "itemCondition": "http://schema.org/UsedCondition",
                    "availability": "http://schema.org/InStock",
                    "seller": {
                        "@type": "Organization",
                        "name": "آمازون تله"
                    }
                }
            }
    </script>

@stop