@extends('public.layouts.SiteFront.main')

@section('content')
    <section class="collection-heading heading-content hidden-sm hidden-xs">
        <div class="container">
            <div class="row">
                <div class="collection-wrapper">
                    <div class="breadcrumb-group box-shadow">
                        <div class="breadcrumb clearfix">
                            <span><a href="#">محصولات</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a href="#">سبد خرید</a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">

                                <!--detiles-->
                                <div class="col-md-12 info-detail-pro box-shadow clearfix sabad-p">
                                    <div class="titr">
                                        <h4>سبد خرید شما در فروشگاه آمازون تله</h4>
                                        <span>افزودن کالاها به سبد خرید به معنی رزرو کالا برای شما نیست. برای ثبت سفارش باید مراحل بعدی خرید را تکمیل نمایید.</span>
                                    </div>
                                    <div id="tableContainer">
                                        @include('public.SiteFront.orderPayment.cartTable')
                                    </div>

                                    <div class="container check-page-btn-box">
                                        <div class="col-md-12 p0">
                                            <div class="col-md-6 col-sm-12 col-xs-12 t-a-l">
                                                {{--<span class="red">بخش مربوط به پیغام ها</span>--}}
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12 col-xs-12 p0">
                                            @if($cartItems)
                                            @if(count($cartItems) > 0)
                                                @if(Auth::check())
                                                    @if(!is_null($token))
                                                        <a href="{{route('address.show',['cart' => $token])}}">
                                                            <div class="submit-div m-b20">
                                                                ثبت اطلاعات و ادامه خرید
                                                            </div>
                                                        </a>
                                                    @endif
                                                @else
                                                    <a href="{{route('address.show')}}">
                                                        <div class="submit-div m-b20">ثبت اطلاعات و ادامه خرید</div>
                                                    </a>
                                                @endif
                                            @endif
                                            @endif
                                        </div>
                                        <div class="col-md-6 col-sm-12 col-xs-12 p0">
                                            <a href="{{route('home')}}">  <div class="back-to-mainpage m-b20">بازگشت به صفحه اصلی</div></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div id="shopify-section-index-collection-product" class="shopify-section index-section index-section-colpro">
        <section class="collection-colpro">
            <div class="collection-colpro-wrapper">
                <div class="container p0-768">
                    <div class="row">
                        <div class="collection-colpro-inner">
                            <div class="collection-colpro-content box-shadow">
                                <span class="colpro_title">محصولات دیگر</span>
                                <div class="colpro_content colpro_1_index-collection-product">
                                    @isset($random_products)
                                        @foreach($random_products as $random)
                                            @if(!is_null($random))
                                                <div class="content_product">
                                                    <div class="row-container product list-unstyled clearfix">
                                                        <div class="row-left">
                                                            <a href="{{url($random->path())}}" class="hoverBorder container_item">
                                                                <div class="hoverBorderWrapper">
                                                                    {!! $random->getImage() !!}
                                                                </div>
                                                            </a>
                                                            @php
                                                                $percentage = discount($random->base_sell_price,$random->discount_sell_price,$random)
                                                            @endphp
                                                            @if($percentage !== false)
                                                                <span class="sale_banner">
                                                                <span class="sale_text">-{{$percentage}}%</span>
                                                            </span>
                                                            @endif
                                                        </div>
                                                        <div class="row-right animMix">
                                                            <div class="product-title"><a class="title-5" href="{{url($random->path())}}">{{$random->name}}</a></div>
                                                            <div class="product-price">
                                                                @if(!is_null($random->discount_sell_price))
                                                                    <span class="price_sale"><span class="money"><span>تومان</span>{{priceFormat($random->discount_sell_price)}}</span></span>
                                                                    <del class="price_compare"> <span class="money">{{priceFormat($random->base_sell_price)}}</span></del>
                                                                @else
                                                                    <span class="price_sale"><span class="money"><span>تومان</span>{{priceFormat($random->base_sell_price)}}</span></span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    @endisset
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

@stop

@section('title')
    <title>سبد خرید | @isset($setteng){{$setteng->title}}@endisset </title>
    <meta name="description" content="@isset($setteng){{$setteng->description}}@endisset"/>
    <meta name="keywords" lang="fa" content="@isset($setteng){{$setteng->keywords}}@endisset">

    <meta property="og:locale" content="fa"/>
    <meta property="og:type" content="website"/>
    <meta property="og:url" content="http://www.amazontele.com"/>
    <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>
    <meta property="og:title" content="@isset($setteng){{$setteng->title}}@endisset"/>
    <meta property="og:image" content="@isset($setteng){{url('/').$setteng->fave_logo}}@endisset"/>
@endsection

@section('head_bottom')

    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/product-styles.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/sabad.css" rel="stylesheet" type="text/css" media="all">

    <!--only for this page scripts-->
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/scripts.js"></script>
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/xzoom.min.js"></script>
@stop

@section('scripts')
    <script>
    </script>
@stop
@section('footer')
    <script>
        $(document).on('change', ".cart-item-num", function () {
            $("#loading").show();
            var cartProductId = $(this).attr('data-content');
            var val = $(this).val();
            $.ajax({
                url     : "{{route('cart.qty')}}",
                type    :"POST",
                cash    : false,
                data    :{ cartProductId : cartProductId,qty : val, _token: $('#token').val()},
                success: function(response) {
                    $("#loading").hide();
                    $('#tableContainer').html(response);
                }
            });
        });
    </script>
@stop