@extends('public.layouts.SiteFront.main')
@section('title')
    <title>سبد خرید | @isset($setteng){{$setteng->title}}@endisset </title>
    <meta name="description" content="@isset($setteng){{$setteng->description}}@endisset"/>
    <meta name="keywords" lang="fa" content="@isset($setteng){{$setteng->keywords}}@endisset">

    <meta property="og:locale" content="fa"/>
    <meta property="og:type" content="website"/>
    <meta property="og:url" content="http://www.amazontele.com"/>
    <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>
    <meta property="og:title" content="@isset($setteng){{$setteng->title}}@endisset"/>
    <meta property="og:image" content="@isset($setteng){{url('/').$setteng->fave_logo}}@endisset"/>
@endsection

@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/product-styles.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/sabad-step2.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/share-popup.css" rel="stylesheet" type="text/css" media="all">


@stop
@section('content')
    <section class="collection-heading heading-content hidden-xs">
        <div class="container">
            <div class="row">
                <img class="w100 m-t10" src="/SiteAssets/assets/images/cart-banner-step-2.png" alt="">
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">

                                <!--detiles-->
                                <div class="col-md-12 info-detail-pro box-shadow clearfix sabad-p">


                                    <div class="titr">
                                        <h4>مشخصات شما برای ارسال کالا</h4>
                                        <span>اگر نیاز به تغییر مشخصات زیر داشته باشید بر روی ویرایش مشخصات کلیک کنید.</span>
                                    </div>
                                    <div class="container check-page-btn-box">
                                        @if($user->completed == 1)
                                            <div class="client-address-box">
                                                <header>{{$user->fname}} {{$user->lname}}</header>
                                                <div class="client-detiles">
                                                    <div class="client-address">
                                                        <div class="row-div">
                                                            <span>استان :</span>
                                                            <span>{{$user->state}}</span>
                                                        </div>
                                                        <div class="row-div">
                                                            <span>شهر :</span>
                                                            <span>{{$user->city}}</span>
                                                        </div>
                                                        <div class="row-div">
                                                            <span>آدرس :</span>
                                                            <span>{{$user->address}}</span>
                                                        </div>
                                                        <div class="row-div">
																<span>
																	شماره تلفن ثابت :
																</span>
                                                            <span class="iransans">
																	{{$user->tell}}
																</span>
                                                        </div>
                                                        <div class="row-div">
                                                            <span>شماره تماس ضروری :</span>
                                                            <span class="iransans">{{$user->urgent_phone_no}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <footer id="change-btn">
                                                    <i class="fa fa-pencil edit-icon"></i>
                                                    ویرایش مشخصات
                                                </footer>
                                            </div>
                                            <div id="myModal" class="modal">

                                                <!-- Modal content -->
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <span class="close">&times;</span>
                                                        <h2>{{$user->fname}} {{$user->lname}}</h2>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="client-detiles" style="width: 100%">
                                                            <div class="client-address">
                                                                <form id="infoUpdate" method="POST" enctype="multipart/form-data">
                                                                    {{csrf_field()}}
                                                                    {{method_field('PATCH')}}
                                                                    <div class="row-div m-b20">
                                                                        <span>استان :</span>
                                                                        <span>
                                                                        <div class="styled-select">
                                                                            <select name="state" id="state" class="cart-item-num" required>
                                                                                 @foreach($provinces as $province)
                                                                                    <option value="{{$province->name}}"
                                                                                            @if(old('state',$user->state) == $province->name)
                                                                                            selected
                                                                                            @endif
                                                                                    >{{$province->name}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </div>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>شهر :</span>
                                                                        <span>
																			<div class="styled-select">
																				<select name="city" id="city" class="cart-item-num" required>

																				</select>
																			</div>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>آدرس :</span>
                                                                        <span class="iransans">
																			<textarea rows="3" cols="50" id="address" name="address" required>{{old('address',$user->address)}}</textarea>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>کدپستی :</span>
                                                                        <span class="iransans">
																			<input type="text" id="postal_code" name="postal_code" value="{{old('postal_code',$user->postal_code)}}" required>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>شماره تلفن ثابت :</span>
                                                                        <span class="iransans">
																			<input type="text" id="tell" name="tell" value="{{old('tell',$user->tell)}}" required>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div">
                                                                        <span>شماره تماس ضروری :</span>
                                                                        <span class="iransans">
																			<input type="text" id="urgent_phone_no" name="urgent_phone_no" value="{{old('urgent_phone_no',$user->urgent_phone_no)}}" required>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div">
                                                                        <button type="submit" class="submit-div">اعمال تغییرات</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                            <div class="client-address-box">
                                                <header style="color: #ff002a"> مشخصات حساب کاربری شما کامل نیست، لطفا ابتدا آن را تکمیل کرده و سپس دکمه ادامه را بزنید</header>
                                                <br>
                                                <footer id="change-btn"><i class="fa fa-pencil edit-icon"></i> برای تکمیل حساب کاربری اینجا کلیک کنید.</footer>
                                            </div>
                                            <div id="myModal" class="modal">
                                                <!-- Modal content -->
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <span class="close">&times;</span>
                                                        <h2>تکمیل اطلاعات حساب کاربری</h2>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="client-detiles" style="width: 100%">
                                                            <div class="client-address">
                                                                <form id="infoUpdate2" method="POST" enctype="multipart/form-data">
                                                                    {{csrf_field()}}
                                                                    {{method_field('PATCH')}}
                                                                    <div class="row-div m-b20">
                                                                        <span>نام :</span>
                                                                        <span class="iransans">
																			<input type="text" id="fname" name="fname" value="{{old('fname')}}" required>
																        </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>نام خانوادگی :</span>
                                                                        <span class="iransans">
																			<input type="text" id="lname" name="lname" value="{{old('lname')}}" required>
																        </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>کد ملی :</span>
                                                                        <span class="iransans">
																			<input type="text" id="melli_code" name="melli_code" value="{{old('melli_code')}}" required>
																        </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>استان :</span>
                                                                        <span>
                                                                        <div class="styled-select">
                                                                            <select name="state" id="state2" class="cart-item-num" required>
                                                                            <option selected disabled>انتخاب کنید...</option>
                                                                                @foreach($provinces as $province)
                                                                                    <option value="{{$province->name}}"
                                                                                            @if(old('state') == $province->name)
                                                                                            selected
                                                                                            @endif
                                                                                    >{{$province->name}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </div>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>شهر :</span>
                                                                        <span>
																			<div class="styled-select">
																				<select name="city" id="city2" class="cart-item-num" required>
@if(old('city'))
                                                                                        <option value="{{old('city')}}" selected>{{old('city')}}</option>
                                                                                    @else
                                                                                        <option selected disabled>شهر</option>
                                                                                    @endif
																				</select>
																			</div>
																		</span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>آدرس :</span>
                                                                        <span class="iransans">
																			<textarea rows="3" cols="50" id="address" name="address" required>{{old('address')}}</textarea>
																        </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>کدپستی :</span>
                                                                        <span class="iransans">
																			<input type="text" id="postal_code" name="postal_code" value="{{old('postal_code')}}" required>
                                                                    </span>
                                                                    </div>
                                                                    <div class="row-div m-b20">
                                                                        <span>شماره تلفن ثابت :</span>
                                                                        <span class="iransans">
																			<input type="text" id="tell" name="tell" placeholder="شماره تلفن با پیش شماره شهرستان" value="{{old('tell')}}" required>
																        </span>
                                                                    </div>
                                                                    <div class="row-div">
                                                                        <span>شماره تماس ضروری :</span>
                                                                        <span class="iransans">
																			<input type="text" id="urgent_phone_no" name="urgent_phone_no" placeholder="شماره تلفن با پیش شماره شهرستان" value="{{old('urgent_phone_no')}}" required>
																    </span>
                                                                    </div>
                                                                    <div class="row-div">
                                                                        <button type="submit" class="submit-div">ثبت اطلاعات</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div id="shopify-section-index-collection-product" class="shopify-section index-section index-section-colpro">
        <section class="collection-colpro">
            <div class="collection-colpro-wrapper">
                <div class="container p0-768">
                    <div class="row">
                        <div class="collection-colpro-inner">
                            <div class="collection-colpro-content box-shadow">
                                <span class="colpro_title">محصولات ارسالی در این مرسوله :</span>
                                <div class="colpro_content colpro_1_index-collection-product">
                                    @isset($cartItems)
                                        @foreach($cartItems as $productColor)
                                            @php
                                                $product = $productColor->Product;
                                            @endphp
                                            <div class="content_product">
                                                <div class="row-container product list-unstyled clearfix">
                                                    <div class="row-left">
                                                        <a href="{{url($product->path())}}" class="hoverBorder container_item">
                                                            <div class="hoverBorderWrapper">
                                                                {!! $product->getImage() !!}
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="row-right animMix">
                                                        <div class="product-title"><a class="title-5" href="{{url($product->path())}}">{{$product->name}}</a></div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endisset
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <section class="product-detail-content m-t10">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">
                                <!--detiles-->
                                @if($user->completed == 1)
                                    <div class="col-md-12 bg-white box-shadow clearfix sabad-p">
                                        <div class="container check-page-btn-box" style="width: 100%;padding: 15px 0">
                                            <div class="col-md-12 p0 t-a-r send-price">
                                                @if(isset($shipmentCost))
                                                    هزینه ارسال پست پیشتاز <span>{{$shipmentCost}}</span> تومان<i class="fa fa-truck" aria-hidden="true"></i>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="product-detail-content">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">
                                <!--detiles-->
                                <div class="col-md-12 info-detail-pro box-shadow clearfix sabad-p">
                                    <div class="container check-page-btn-box">
                                        <div class="col-md-12 p0">
                                            <div class="col-md-6 col-sm-12 col-xs-12 t-a-l">
                                                <a href="{{route('profile.inbox')}}"><span class="red">بخش مربوط به پیغام ها</span></a>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12 col-xs-12 p0">
                                            <div id="payment">
                                                @if($user->completed == 1)
                                                    <a href="{{route('purchase.show',['p' => $dualToken])}}"><div class="submit-div m-b20">ثبت اطلاعات و ادامه خرید</div></a>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12 col-xs-12 p0">
                                            <a href="{{route('cart.show')}}"><div class="back-to-mainpage m-b20">بازگشت به سبد خرید</div></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop

@section('scripts')

@stop
@section('footer')
    <script>



        // Get the modal
        var modal = document.getElementById('myModal');

        // Get the button that opens the modal
        var btn = document.getElementById("change-btn");

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks the button, open the modal
        btn.onclick = function() {
            modal.style.display = "block";
        };

        // When the user clicks on <span> (x), close the modal
        span.onclick = function() {
            modal.style.display = "none";
        };

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        };



        $(document).ready(function () {
            var user_city= '{{old('city',$user->city)}}';
            var province = $('#state').val();
            var city= $('#city').val();

            if (city == null) {
                $.ajax({
                    url: "{{route('getCities')}}",
                    type: "POST",
                    cash: false,
                    data: {province: province, _token: $('#token').val()},
                    success: function (response) {
                        if (response !== 0) {
                            var html = '';
                            $.each(response, function (key, value) {
                                if (user_city== value.name){
                                    html += '<option selected value=' + value.name + '>' + value.name + '</option>';

                                } else {
                                    html += '<option  value=' + value.name + '>' + value.name + '</option>';

                                }
                            });
                        } else {
                            var html = '<option selected disabled>شهر</option>';
                        }
                        $('#city').empty().append(html);
                    },
                    error: function () {
                        $('#city').empty();
                    }

                });
            } else {
                $('#city').empty();
            }
        });
        $(document).on('change', "#state", function () {
            var province = $(this).val();
            $.ajax({
                url     : "{{route('getCities')}}",
                type    :"POST",
                cash    : false,
                data    :{ province : province, _token: $('#token').val()},
                success: function (response) {
                    if(response !== 0){
                        var html = '';
                        $.each( response, function( key, value ) {
                            html += '<option value="'+ value.name +'">'+value.name+'</option>';
                        });
                    }else{
                        var html = '<option selected disabled>شهر</option>';
                    }
                    $('#city').empty().append(html);
                },
                error: function () {
                    $('#city').empty();
                }
            });
        });

        $(document).on('submit', "#infoUpdate", function (event) {

            var formdata = new FormData(this);
            $.ajax({
                url: "{{route('updateInfo')}}",
                type: "POST",
                data: formdata,
                beforeSend: function () {
                    $("#body-overlay").show();
                },
                contentType: false,
                processData: false,
                success: function () {
                    modal.style.display = "none";
                    setTimeout(location.reload.bind(location), 1500);
                    swal({
                        title: "بروزرسانی شد!",
                        text: "صفحه در حال بارگذاری مجدد",
                        type: "success",
                        showConfirmButton: false
                    });
                },error: function(xhr) {
                    modal.style.display = "none";
                    var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.

                    var text =  '';
                    $.each( error.errors, function( k,v ) {
                        text += '<p style="direction: rtl">'+v[0]+'</p>';
                    });
                    swal({
                        title: "خطا",
                        html: text,
                        type: "error",
                        showConfirmButton: true,
                        confirmButtonText: 'باشه',
                        reverseButtons: true
                    });
                }
            });
            event.preventDefault();
            return false;
        });
        //----------------create modal---------------\\
        $(document).ready(function () {
            var province = $('#state2').val();
            if (province != null) {
                $.ajax({
                    url: "{{route('getCities')}}",
                    type: "POST",
                    cash: false,
                    data: {province: province, _token: $('#token').val()},
                    success: function (response) {
                        if (response !== 0) {
                            var html = '';
                            $.each(response, function (key, value) {
                                html += '<option value="' + value.name + '">' + value.name + '</option>';
                            });
                        } else {
                            var html = '<option selected disabled>شهر</option>';
                        }
                        $('#city2').empty().append(html);
                    },
                    error: function () {
                        $('#city2').empty();
                    }

                });
            }else{
                $('#city2').empty();
            }
        });
        $(document).on('change', "#state2", function () {
            var province = $(this).val();
            $.ajax({
                url     : "{{route('getCities')}}",
                type    :"POST",
                cash    : false,
                data    :{ province : province, _token: $('#token').val()},
                success: function (response) {
                    if(response !== 0){
                        var html = '';
                        $.each( response, function( key, value ) {
                            html += '<option value="'+ value.name +'">'+value.name+'</option>';
                        });
                    }else{
                        var html = '<option selected disabled>شهر</option>';
                    }
                    $('#city2').empty().append(html);
                },
                error: function () {
                    $('#city2').empty();
                }
            });
        });

        $(document).on('submit', "#infoUpdate2", function (event) {

            var formdata = new FormData(this);
            $.ajax({
                url: "{{route('updateInfo2')}}",
                type: "POST",
                data: formdata,
                beforeSend: function () {
                    $("#body-overlay").show();
                },
                contentType: false,
                processData: false,
                success: function () {
                    modal.style.display = "none";
                    setTimeout(location.reload.bind(location), 1500);
                    swal({
                        title: "بروزرسانی شد!",
                        text: "صفحه در حال بارگذاری مجدد",
                        type: "success",
                        showConfirmButton: false
                    });
                },error: function(xhr) {
                    modal.style.display = "none";
                    var error = jQuery.parseJSON(xhr.responseText);  // this section is key player in getting the value of the errors from controller.

                    var text =  '';
                    $.each( error.errors, function( k,v ) {
                        text += '<p style="direction: rtl">'+v[0]+'</p>';
                    });
                    swal({
                        title: "خطا",
                        html: text,
                        type: "error",
                        showConfirmButton: true,
                        confirmButtonText: 'باشه',
                        reverseButtons: true
                    });
                }
            });
            event.preventDefault();
            return false;
        });
    </script>


@stop