@extends('public.layouts.SiteFront.main')
@section('content')
    <section class="collection-heading heading-content hidden-sm hidden-xs">
        <div class="container">
            <div class="row">
                <div class="collection-wrapper">
                    <div class="breadcrumb-group box-shadow">
                        <div class="breadcrumb clearfix">
                            <span><a href="{{route('home')}}">@isset($setteng){{$setteng->name}}@endisset</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a href="{{route('profile.show')}}">صندوق پیام {{$user->fname}} {{$user->lname}}</a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10" style="min-height: 390px">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <!--detiles-->
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">
                                <!--detiles-->
                                <div id="shopify-section-product-template" class="shopify-section m-b10">
                                    <div class="detail-content-inner">
                                        <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">
                                            <!--detiles-->
                                            <div class="col-md-12 col-sm-12 col-xs-12 box-shadow clearfix bought" style="min-height: 310px; margin-top: 15px;">
                                                <h4>پیام ها</h4>
                                                <hr>
                                                <div class="col-md-12">
                                                    @if(isset($messages) && count($messages) > 0)
                                                        @foreach($messages as $message)
                                                            @php $messagePivot = $user->getUserMessagePivot($message); @endphp
                                                            <div class="panel panel-default off-box box-shadow ">
                                                                <div class="panel-heading message-section message-title @if(is_null($messagePivot->seen)) message-unread @endif" data-content="{{$messagePivot->id}}" role="tab">
                                                                    <h4 class="panel-title">
                                                                        <a role="button" data-toggle="collapse" href="#collapse{{$loop->iteration}}" aria-expanded="false" aria-controls="collapse2" class="trigger collapsed">
                                                                            <span><i class="fa fa-envelope"></i></span>
                                                                            <span style="font-size: 14px;font-weight: bold;">{{$message->subject}}</span>
                                                                            <div style="padding: 10px;">
                                                                                <span>{{convert($jdate->forge(strtotime($message->created_at))->format('l - dام %B Y')) }}</span>
                                                                                <span>ساعت: </span>
                                                                                <span>{{convert($jdate->forge(strtotime($message->created_at))->format('H:i:s')) }}</span>
                                                                                <span class="status-section">
                                                                                @if(is_null($messagePivot->seen))
                                                                                    <span><i class="fa fa-close" style="color: #FF4F4F;"></i>خوانده نشده</span>
                                                                                @else
                                                                                    <span><i class="fa fa-check" style="color: #22ca61;"></i>خوانده شده</span>
                                                                                @endif
                                                                                </span>
                                                                            </div>
                                                                            <hr>
                                                                        </a>
                                                                    </h4>
                                                                </div>
                                                                <div id="collapse{{$loop->iteration}}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading2" aria-expanded="false" style="height: 0px;">
                                                                    <div class="panel-body">
                                                                        <h4 class="panel-title" style="margin-bottom:2% ">
                                                                            متن پیام :
                                                                        </h4>
                                                                        <div class="col-lg-12 text-center message-rtl">
                                                                            <div class="col-md-8 message-body" style=" padding-right: 20px;padding-left: 15px;">
                                                                                {!!  $message->body !!}
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                    <hr>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    @else
                                                        <div class="alert alert-warning text-center col-md-12" role="alert">
                                                            فعلا هیچ پیامی ندارید...!
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop
@section('title')
    <title>صندوق پیام | @isset($setteng){{$setteng->title}}@endisset </title>
    <meta name="description" content="@isset($setteng){{$setteng->description}}@endisset"/>
    <meta name="keywords" lang="fa" content="@isset($setteng){{$setteng->keywords}}@endisset">

    <meta property="og:locale" content="fa"/>
    <meta property="og:type" content="website"/>
    <meta property="og:url" content="http://www.amazontele.com"/>
    <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>
    <meta property="og:title" content="@isset($setteng){{$setteng->title}}@endisset"/>
    <meta property="og:image" content="@isset($setteng){{url('/').$setteng->fave_logo}}@endisset"/>
@endsection

@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/product-styles.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/profile.css" rel="stylesheet" type="text/css" media="all">
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">

    <!--only for this page scripts-->
    <script type="text/javascript" src="/SiteAssets/assets/javascripts/scripts.js"></script>

@stop

@section('scripts')
    <script src="/jq-confirm/jquery-confirm.min.js"></script>
    <script src="/SiteAssets/assets/javascripts/xzoom/foundation.min.js"></script>
    <script src="/SiteAssets/assets/javascripts/xzoom/setup.js"></script>
@stop
@section('footer')
    <script>
        $(document).on('click','.message-section',function () {

            var element = $(this);
            var id = element.attr('data-content');
            $.ajax({
                url     : "{{route('profile.inbox.read-message')}}",
                type    :"POST",
                cash    : false,
                data: {id: id,_token: $('#token').val(),_method:'PATCH'} ,
                success : function() {
                    if(element.hasClass('message-unread')){
                        element.fadeOut('slow').fadeIn('fast').removeClass('message-unread');

                        element.find('.status-section').html('<span><i class="fa fa-check" style="color: #22ca61;"></i>خوانده شده</span>').animate('ease');
                    }
                }
            });

        });


    </script>
@endsection