@extends('public.layouts.SiteFront.main')

@section('content')
    <section class="collection-heading heading-content hidden-sm hidden-xs" title="@isset($setteng){{$setteng->title}}@endisset">
        <div class="container">
            <div class="row">
                <div class="collection-wrapper">
                    <div class="breadcrumb-group box-shadow">
                        <div class="breadcrumb clearfix">
                            <span><a title="@isset($setteng){{$setteng->title}}@endisset" href="{{route('home')}}">@isset($setteng){{$setteng->name}}@endisset</a></span>
                            @isset($category)
                                <span class="fa fa-angle-left angle"></span>
                                <span><a title="{{$category->StuffType->stuffType}}" href="{{url($category->StuffType->path())}}">{{$category->StuffType->stuffType}}</a></span>
                                <span class="fa fa-angle-left angle"></span>
                                <span><a title="{{$category->category}}" href="{{url($category->path())}}">{{$category->category}}</a></span>
                            @endisset
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">
                            @isset($banner)
                                <!--banner-->
                                    <div class="banner-category emthemesModez-banner-figure">

                                        <a title="{{$banner->title}}" href="{{$banner->url}}">
                                            <img class="box-shadow" src="{{$banner->image_path}}"
                                                 title="{{$banner->title}}"
                                                 alt="{{$banner->title}}">
                                        </a>
                                    </div>
                                @endisset
                                <div class="white-box-col-3 box-shadow m-top10 category-right">
                                    <header>
                                        @isset($menu2)
                                        {{$menu2->name}}
                                            @endisset
                                    </header>
                                    @isset($menu2)
                                        @php
                                            $subMenu2 = $menu2->DynamicSubMenu()
                                            ->where('status',1)
                                            ->where('category_id',$category->id)
                                            ->orderBy('priority','asc')
                                            ->first();
                                        @endphp
                                        <div class="p15">
                                            <div class="daste">
                                                <a title="{{$subMenu2->name}}" href="{{$subMenu2->path()}}"><span><i class="fa fa-angle-down"
                                                                                              style="margin-left: 5px;"></i>{{$subMenu2->name}}</span></a>
                                            </div>
                                            @foreach($subMenu2->SubMenuTitle()->get() as $subtitle2)
                                                <div class="zir-daste">
                                                    <a {{$subtitle2->title}} href="{{$subtitle2->path()}}"><span><i class="fa fa-angle-left"
                                                                                                   style="margin-left: 5px;"></i>{{$subtitle2->title}}</span></a>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endisset
                                </div>
                                <div class="col-md-10 col-sm-12 p0">
                                    <div class="shopify-section index-section index-section-protab1 box-shadow ptoducts-slider bg-white">
                                        <div data-section-id="1490953841934" data-section-type="protab1-section">
                                            <section class="home_protab1_layout" title="محبوب ترین های @if(isset($category)){{$category->category}}@endif">
                                                <div class="home_protab1_wrapper">
                                                    <div class="">
                                                        <div class="">
                                                            <div class="home_protab1_inner">
                                                                <div class="home_protab1_content">
                                                                    <div class="protab1_top page-top"
                                                                         style="text-align: right;">
                                                                        <div class="page-title pull-right">
                                                                            <h2 title="محبوب ترین های @if(isset($category)){{$category->category}}@endif">محبوب ترین
                                                                                های @if(isset($category)){{$category->category}}@endif </h2>
                                                                        </div>
                                                                    </div>
                                                                    <div class="protab1_bottom">
                                                                        <div class="tab-content">
                                                                            <div class="tab-pane active" id="home_protab3_tab">
                                                                                <div class="protab1_item">
                                                                                    @foreach($bestViews as $bestView)
                                                                                        <div class="content_product">
                                                                                            <div class="row-container product list-unstyled clearfix">
                                                                                                <div class="row-left">
                                                                                                    <a title="{{$bestView->name}}" href="{{url($bestView->path())}}"
                                                                                                       class="hoverBorder container_item">
                                                                                                        <div class="hoverBorderWrapper">
                                                                                                            {!! $bestView->getImageCat() !!}
                                                                                                            <div class="mask"></div>
                                                                                                        </div>
                                                                                                    </a>
                                                                                                    <div class="product-top-line">
                                                                                                        {!! $bestView->getCart() !!}
                                                                                                    </div>
                                                                                                    {!! $bestView->getPercent() !!}
                                                                                                </div>
                                                                                                <div class="row-right animMix">
                                                                                                    <div class="product-title">
                                                                                                        <a title="{{$bestView->name}}" class="title-5"
                                                                                                           href="{{url($bestView->path())}}">{{$bestView->name}}</a>
                                                                                                    </div>
                                                                                                    <div class="product-price">
                                                                                                        {!! $bestView->getPrice() !!}
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </section>
                                        </div>
                                    </div>
                                    <div class="shopify-section index-section index-section-protab1 box-shadow ptoducts-slider bg-white">
                                        <div data-section-id="1490953841934" data-section-type="protab1-section">
                                            <section class="home_protab1_layout" title="پرفروشترین های @if(isset($category)){{$category->category}}@endif">
                                                <div class="home_protab1_wrapper">
                                                    <div class="">
                                                        <div class="">
                                                            <div class="home_protab1_inner">


                                                                <div class="home_protab1_content">
                                                                    <div class="protab1_top page-top"
                                                                         style="text-align: right;">
                                                                        <div class="page-title pull-right">
                                                                            <h2 title="پرفروشترین های @if(isset($category)){{$category->category}}@endif">پرفروشترین های
                                                                                @if(isset($category)){{$category->category}}@endif </h2>
                                                                        </div>
                                                                    </div>
                                                                    <div class="protab1_bottom">
                                                                        <div class="tab-content">

                                                                            <div class="tab-pane active "
                                                                                 id="home_protab3_tab">
                                                                                <div class="protab1_item">
                                                                                    @foreach($bestSellers as $bestSeller)
                                                                                        <div class="content_product">
                                                                                            <div class="row-container product list-unstyled clearfix">
                                                                                                <div class="row-left">
                                                                                                    <a title="{{$bestSeller->name}}" href="{{url($bestSeller->path())}}"
                                                                                                       class="hoverBorder container_item">
                                                                                                        <div class="hoverBorderWrapper">
                                                                                                            {!! $bestSeller->getImageCat() !!}
                                                                                                            <div class="mask"></div>
                                                                                                        </div>
                                                                                                    </a>
                                                                                                    <div class="product-top-line">
                                                                                                        {!! $bestSeller->getCart() !!}
                                                                                                    </div>
                                                                                                    {!! $bestSeller->getPercent() !!}
                                                                                                </div>
                                                                                                <div class="row-right animMix">
                                                                                                    <div class="product-title">
                                                                                                        <a title="{{$bestSeller->name}}" class="title-5"
                                                                                                           href="{{url($bestSeller->path())}}">{{$bestSeller->name}}</a>
                                                                                                    </div>
                                                                                                    <div class="product-price">
                                                                                                        {!! $bestSeller->getPrice() !!}
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </section>
                                        </div>
                                    </div>
                                    <div class="shopify-section index-section index-section-protab1 box-shadow ptoducts-slider bg-white">
                                        <div data-section-id="1490953841934" data-section-type="protab1-section">
                                            <section class="home_protab1_layout" title="جدیدترین های @if(isset($category)){{$category->category}}@endif">
                                                <div class="home_protab1_wrapper">
                                                    <div class="">
                                                        <div class="">
                                                            <div class="home_protab1_inner">
                                                                <div class="home_protab1_content">
                                                                    <div class="protab1_top page-top"
                                                                         style="text-align: right;">
                                                                        <div class="page-title pull-right">
                                                                            <h2 title="جدیدترین های @if(isset($category)){{$category->category}}@endif">جدیدترین های @if(isset($category)){{$category->category}}@endif </h2>
                                                                        </div>
                                                                    </div>
                                                                    <div class="protab1_bottom">
                                                                        <div class="tab-content">
                                                                            <div class="tab-pane active "
                                                                                 id="home_protab3_tab">
                                                                                <div class="protab1_item">
                                                                                    @foreach($newest as $new)
                                                                                        <div class="content_product">
                                                                                            <div class="row-container product list-unstyled clearfix">
                                                                                                <div class="row-left">
                                                                                                    <a title="{{$new->name}}" href="{{url($new->path())}}"
                                                                                                       class="hoverBorder container_item">
                                                                                                        <div class="hoverBorderWrapper">
                                                                                                            {!! $new->getImageCat() !!}
                                                                                                            <div class="mask"></div>
                                                                                                        </div>
                                                                                                    </a>
                                                                                                    <div class="product-top-line">
                                                                                                        {!! $new->getCart() !!}
                                                                                                    </div>
                                                                                                    {!! $new->getPercent() !!}
                                                                                                </div>
                                                                                                <div class="row-right animMix">
                                                                                                    <div class="product-title">
                                                                                                        <a title="{{$new->name}}" class="title-5"
                                                                                                           href="{{url($new->path())}}">{{$new->name}}</a>
                                                                                                    </div>
                                                                                                    <div class="product-price">
                                                                                                        {!! $new->getPrice() !!}
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    @endforeach
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </section>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop
@section('title')
    @if(isset($category))
        <title> {{ $category->category}} </title>
        <meta name="description" content="@isset($setteng){{$setteng->description}}@endisset"/>
        <meta name="keywords" lang="fa" content="@isset($setteng){{$setteng->keywords}}@endisset">

        <meta property="og:locale" content="fa"/>
        <meta property="og:type" content="website"/>
        <meta property="og:url" content="http://www.amazontele.com"/>
        <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>
        <meta property="og:title" content="@isset($setteng){{ $category->category}}@endisset"/>
        @if($banner)
        <meta property="og:image" content="{{$banner->image_path}}"/>
            @else
            <meta property="og:image" content="@isset($setteng){{url('/').$setteng->fave_logo}}@endisset"/>
        @endif
    @endif
@endsection
@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/category.css" rel="stylesheet" type="text/css" media="all">


@stop

@section('scripts')

@stop
