@extends('public.layouts.SiteFront.main')

@section('content')
    <section class="collection-heading heading-content hidden-sm hidden-xs">
        <div class="container">
            <div class="row">
                <div class="collection-wrapper">
                    <div class="breadcrumb-group box-shadow">
                        <div class="breadcrumb clearfix">
                            <span><a href="#">@isset($setteng){{$setteng->name}}@endisset</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a href="#">تکمیل اطلاعات حساب کاربری</a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div id="shopify-section-product-template" class="shopify-section m-b10">
                        <div class="detail-content-inner">
                            <div id="product" class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">

                                <!--detiles-->
                                <div id="shopify-section-product-template" class="shopify-section m-b10">
                                    <div class="detail-content-inner">
                                        <div id="product"
                                             class="neque-porro-quisquam-est-qui-dolor-ipsum-quia-9 detail-content">

                                            <!--detiles-->
                                            <div class="col-md-12 col-sm-12 col-xs-12 box-shadow clearfix t-a-r p0 m-b20 register">
                                                <div class="col-md-6 hidden-sm hidden-xs">

                                                </div>
                                                <div class="col-md-6 col-sm-12">
                                                    <h4 class="auth__title">تکمیل اطلاعات حساب کاربری</h4>
                                                    @include('errors.formAlert')
                                                    <form class="userform register-inputs" id="registerForm"
                                                          method="post" action="{{route('profile.store')}}">
                                                        {{csrf_field()}}
                                                        {{method_field('PATCH')}}
                                                        <div class="info-row">
                                                            <i style="color: #ff002a">*</i><span>نام:</span>
                                                            <input type="text" name="fname"
                                                                   @if(old('fname') != null)
                                                                   value="{{old('fname')}}"
                                                                   @else
                                                                   value="{{$user->fname}}"
                                                                   @endif
                                                                   style="text-align: right" autofocus required>
                                                        </div>
                                                        <div class="info-row">
                                                            <i style="color: #ff002a">*</i><span>نام خانوادگی :</span>
                                                            <input type="text" name="lname"
                                                                   @if(old('lname') != null)
                                                                   value="{{old('lname')}}"
                                                                   @else
                                                                   value="{{$user->lname}}"
                                                                   @endif
                                                                   style="text-align: right" required>
                                                        </div>
                                                        <div class="info-row" id="melliParent">
                                                            <i style="color: #ff002a">*</i><span>کد ملی :</span>
                                                            <input type="text" name="melli_code" pattern = "[0-9]{10}" maxlength="10" id="melli_code"
                                                                   @if(old('melli_code') != null)
                                                                   value="{{old('melli_code')}}"
                                                                   @else
                                                                   value="{{$user->melli_code}}"
                                                                   @endif
                                                                   value="{{old('melli_code')}}" required
                                                                   style="-moz-appearance:textfield;">
                                                        </div>
                                                        <div class="info-row" id="tellParent">
                                                            <i style="color: #ff002a">*</i><span>شماره تلفن ثابت :</span>
                                                            <input type="number" name="tell"
                                                                   @if(old('tell') != null)
                                                                   value="{{old('tell')}}"
                                                                   @else
                                                                   value="{{$user->tell}}"
                                                                   @endif
                                                                   id="tell" style="-moz-appearance:textfield;"
                                                                   required>
                                                        </div>
                                                        <div class="info-row" id="urgentParent">
                                                            <i style="color: #ff002a">*</i><span>شماره تماس ضروری :</span>
                                                            <input type="number" name="urgent_phone_no"
                                                                   style="-moz-appearance:textfield;"
                                                                   @if(old('urgent_phone_no') != null)
                                                                   value="{{old('urgent_phone_no')}}"
                                                                   @else
                                                                   value="{{$user->urgent_phone_no}}"
                                                                   @endif
                                                                   id="urgent" required>
                                                        </div>
                                                        <div class="info-row">
                                                            <span>پست الکترونیک :</span>
                                                            <input type="text" name="email"
                                                                   @if(old('email') != null)
                                                                   value="{{old('email')}}"
                                                                   @else
                                                                   value="{{$user->email}}"
                                                                    @endif
                                                            >
                                                        </div>
                                                        <div class="info-row">
                                                            <span>جنسیت :</span>
                                                            <div class="register-date">
                                                                <div class="pretty p-default p-round">
                                                                    <input type="radio" checked name="gender" value="1"
                                                                           @if(old('gender') != null && old('gender') == 1)
                                                                           checked
                                                                           @elseif(isset($user) && $user->gender == 1)
                                                                           checked
                                                                            @endif
                                                                    >
                                                                    <div class="state p-primary-o">
                                                                        <label>مرد</label>
                                                                    </div>
                                                                </div>
                                                                <div class="pretty p-default p-round">
                                                                    <input type="radio" name="gender" value="0"
                                                                           @if(old('gender') != null && old('gender') == 0)
                                                                           checked
                                                                           @elseif(isset($user) && $user->gender == 0)
                                                                           checked
                                                                            @endif
                                                                    >
                                                                    <div class="state p-primary-o">
                                                                        <label>زن</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="info-row">
                                                            <i style="color: #ff002a">*</i><span> محل سکونت :</span>
                                                            <div class="register-date">
                                                                <div class="col-md-6 col-sm-6 col-xs-6 pull-right shahr">
                                                                    <select name="state"
                                                                            style="width: 100%;border-radius: 3px;"
                                                                            id="state" required>
                                                                        <option selected disabled>استان</option>
                                                                        <option disabled>------------------</option>
                                                                        @foreach($provinces as $province)
                                                                            <option value="{{$province->name}}"
                                                                                    @if(old('state') && old('state') == $province->name)
                                                                                    selected
                                                                                    @elseif(isset($user) && $user->state == $province->name )
                                                                                    selected
                                                                                    @endif
                                                                            >{{$province->name}}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="col-md-6 col-sm-6 col-xs-6 pull-right ostan">
                                                                    <select name="city" id="city"
                                                                            style="width: 100%;border-radius: 3px;"
                                                                            required>

                                                                        {{--@if(old('city') && old('city') == $province->name)--}}
                                                                            {{--selected--}}
                                                                        {{--@elseif(isset($user) && $user->city == $province->city )--}}
                                                                            {{--selected--}}
                                                                        {{--@endif--}}

                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="info-row">
                                                            <i style="color: #ff002a">*</i><span>کدپستی :</span>
                                                            <input name="postal_code" type="text" required
                                                                   @if(old('postal_code') != null)
                                                                   value="{{old('postal_code')}}"
                                                                   @else
                                                                   value="{{$user->postal_code}}"
                                                                    @endif
                                                            >
                                                        </div>
                                                        <div class="info-row"
                                                             style="padding-bottom: 30px;border-bottom: 1px solid #f3f3f3">
                                                            <i style="color: #ff002a">*</i><span>آدرس :</span>
                                                            <textarea name="address" type="text"
                                                                      style="text-align: right"
                                                                      required>@if(old('address') != null){{old('address')}}@else{{$user->address}}@endif</textarea>
                                                        </div>
                                                        <button type="submit" class="register-submit" id="nazar-login">
                                                            ثبت اطلاعات
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
@stop
@section('title')
    <title>@isset($setteng){{$setteng->title}}@endisset</title>
@endsection
@section('head_top')


@stop
@section('head_bottom')

    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/product-styles.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/sabad-step2.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/pretty-checkbox.min.css" rel="stylesheet" type="text/css" media="all">

    <!--only for this page scripts-->
    <style>
        /* For Firefox */
        input[type='number'] {
            -moz-appearance: textfield;
        }

        /* Webkit browsers like Safari and Chrome */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
    </style>

@stop

@section('scripts')

@stop
@section('footer')

    <script>
        $(function () {
            $('#melliParent').on('keydown', '#melli_code', function (e) {
                -1 !== $.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) || (/65|67|86|88/.test(e.keyCode) && (e.ctrlKey === true || e.metaKey === true)) && (!0 === e.ctrlKey || !0 === e.metaKey) || 35 <= e.keyCode && 40 >= e.keyCode || (e.shiftKey || 48 > e.keyCode || 57 < e.keyCode) && (96 > e.keyCode || 105 < e.keyCode) && e.preventDefault()
            });
        });
        $(function () {
            $('#tellParent').on('keydown', '#tell', function (e) {
                -1 !== $.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) || (/65|67|86|88/.test(e.keyCode) && (e.ctrlKey === true || e.metaKey === true)) && (!0 === e.ctrlKey || !0 === e.metaKey) || 35 <= e.keyCode && 40 >= e.keyCode || (e.shiftKey || 48 > e.keyCode || 57 < e.keyCode) && (96 > e.keyCode || 105 < e.keyCode) && e.preventDefault()
            });
        });
        $(function () {
            $('#urgentParent').on('keydown', '#urgent', function (e) {
                -1 !== $.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) || (/65|67|86|88/.test(e.keyCode) && (e.ctrlKey === true || e.metaKey === true)) && (!0 === e.ctrlKey || !0 === e.metaKey) || 35 <= e.keyCode && 40 >= e.keyCode || (e.shiftKey || 48 > e.keyCode || 57 < e.keyCode) && (96 > e.keyCode || 105 < e.keyCode) && e.preventDefault()
            });
        });
        $(document).ready(function () {
            var user_city= '{{old('city',$user->city)}}';
            var province = $('#state').val();
           var city= $('#city').val();

            if (city == null) {
                $.ajax({
                    url: "{{route('getCities')}}",
                    type: "POST",
                    cash: false,
                    data: {province: province, _token: $('#token').val()},
                    success: function (response) {
                        if (response !== 0) {
                            var html = '';
                            $.each(response, function (key, value) {
                                if (user_city== value.name){
                                    html += '<option selected value="' + value.name + '">' + value.name + '</option>';

                                } else {
                                    html += '<option  value="' + value.name + '">' + value.name + '</option>';

                                }
                            });
                        } else {
                            var html = '<option selected disabled>شهر</option>';
                        }
                        $('#city').empty().append(html);
                    },
                    error: function () {
                        $('#city').empty();
                    }

                });
            } else {
                $('#city').empty();
            }
        });
        $(document).on('change', "#state", function () {
            var province = $(this).val();
            $.ajax({
                url: "{{route('getCities')}}",
                type: "POST",
                cash: false,
                data: {province: province, _token: $('#token').val()},
                success: function (response) {
                    if (response !== 0) {
                        var html = '';
                        $.each(response, function (key, value) {
                            html += '<option value="' + value.name + '">' + value.name + '</option>';
                        });
                    } else {
                        var html = '<option selected disabled>شهر</option>';
                    }
                    $('#city').empty().append(html);
                },
                error: function () {
                    $('#city').empty();
                }
            });
        });
    </script>
@stop