@extends('public.layouts.SiteFront.main')
@section('title') @endsection

@section('head_bottom')
    <meta name="csrf-token" content="{{ csrf_token()}}">

    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/category-all.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/bootstrap-slider.css" rel="stylesheet" type="text/css" media="all">

    <!--price range-->

    <script type="text/javascript" src="/SiteAssets/assets/javascripts/bootstrap-slider.js"></script>

@stop
@section('body_top')

    <script type="text/javascript">

        $(function() {
            $('body').on('click', '.pagination a', function(e) {
                e.preventDefault();
                var url = $(this).attr('href');
                $("#loading").show();
                getProducts(url);
                window.history.pushState("", "", url);
            });

            function getProducts(url) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url : url
                }).done(function (data) {
                    $('#products-load').html(data);
                    $("#loading").hide();
                }).fail(function () {
                    toastr.warning('ارتباط ضعیف است، لطفا صفحه را دوباره بارگذاری کنید');
                });
            }
        });

    </script>

@endsection
@section('content')
    <div id="hole_page">

        <section class="collection-heading heading-content hidden-sm hidden-xs m-b10">
            <div class="container">
                <div class="row">
                    <div class="collection-wrapper">
                        <div class="breadcrumb-group box-shadow">
                            <div class="breadcrumb clearfix">
                                <span><a href="{{url('/')}}">@isset($setteng){{$setteng->name}}@endisset</a></span>
                                <span class="fa fa-angle-left angle"></span>
                                <span><a href="{{url('Collections/Newest_Items')}}">جدیدترین ها</a></span>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>
        <section class="collection-content">
            <div class="collection-wrapper">
                <div class="container container-padding-left">
                    <div class="row">
                        <div id="shopify-section-collection-template" class="shopify-section">
                            <div class="collection-inner">
                                <!-- Tags loading -->
                                <div id="tags-load" style="display:none;">
                                    <i class="fa fa-spinner fa-pulse fa-2x"></i></div>
                                <div id="collection">
                                    <div class="collection_inner">
                                        <!--right colmn-->
                                        <div class="collection-leftsidebar sidebar col-lg-3 col-md-3 col-sm-12 col-xs-12 clearfix" style="float: right;">
                                            <div class="filters-panel bg-white box-shadow">

                                                {{--<!--your selects-->--}}
                                                <div class="filtered">
                                                    <div class="clearfix">
                                                        <span class="filtered__header">انتخاب شما</span>
                                                        <span class="filtered__clear-button">پاک کردن همه</span>
                                                    </div>
                                                    @php
                                                        $session2 = session('choices');
                                                    @endphp
                                                    <div class="filtered__items close" id="choices">
                                                        @include('public.SiteFront.Collections.choices')
                                                    </div>
                                                </div>
                                                @if(isset($request['category']) && count($request['category']) == 1)
                                                    <input type="hidden" id="cat" value="category[0]={{current($request['category'])}}">
                                                @endif
                                            <!--Only the availables-->
                                                <div class="filter filter--existence">
                                                    <div class="filter__items">
                                                        <input id='only_available' type='checkbox' value="status=1"
                                                               @if(isset($request['status']))
                                                               @if($request['status'] == 1)
                                                               checked
                                                                @endif
                                                                @endif
                                                        >
                                                        <label for='only_available'>
                                                            <span></span>فقط نمایش کالاهای موجود
                                                        </label>
                                                    </div>
                                                </div>
                                                <!-- brands filter-->
                                                @if(isset($brands))
                                                    <div class="panel panel-default">
                                                        <div class="panel-heading"  id="heading-brand">
                                                            <h4 class="panel-title">
                                                                <a role="button" data-toggle="collapse" href="#collapse-brand"  aria-controls="collapse-brand"
                                                                   @if(isset($request['brand']))
                                                                   class="trigger"
                                                                   aria-expanded="true"
                                                                   @else
                                                                   class="trigger collapsed"
                                                                   aria-expanded="false"
                                                                        @endif
                                                                >
                                                                    براساس برند
                                                                </a>
                                                            </h4>
                                                        </div>
                                                        <div id="collapse-brand"
                                                             @if(isset($request['brand']))
                                                             class="panel-collapse collapse in"
                                                             aria-expanded="true"
                                                             @else
                                                             class="panel-collapse collapse"
                                                             aria-expanded="false"
                                                             @endif
                                                             role="tabpanel" aria-labelledby="heading-brand">

                                                            <div class="panel-body panel-body-color">
                                                                @foreach($brands as $brand)
                                                                    <div class="filter__items">
                                                                        <input  id='brand_filter_{{$brand->id}}'
                                                                                @if(isset($request['brand']))
                                                                                @foreach($request['brand'] as $value)
                                                                                @if($value == $brand->id)
                                                                                value="brand[{{$value}}]={{$value}}"
                                                                                checked
                                                                                @else
                                                                                value="brand[{{$brand->id}}]={{$brand->id}}"
                                                                                @endif
                                                                                @endforeach
                                                                                @else
                                                                                value="brand[{{$brand->id}}]={{$brand->id}}"
                                                                                @endif
                                                                                type='checkbox' />
                                                                        <label class='filterClass' data-content="{{$brand->brandName}}" for='brand_filter_{{$brand->id}}' data-title="brand">
                                                                            <span></span>
                                                                            <i>{{$brand->brandName}}</i>
                                                                        </label>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            <!-- end brands filter-->
                                                <!--price range-->
                                                <div class="panel panel-default price-range">
                                                    <div class="panel-heading"  id="heading1">
                                                        <h4 class="panel-title">
                                                            <a role="button" data-toggle="collapse" href="#collapse1" aria-expanded="true" aria-controls="collapse1" class="trigger collapsed">
                                                                محدوده قیمت
                                                            </a>
                                                        </h4>
                                                    </div>
                                                    <div id="collapse1" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="heading1"> <!-- کلاس in برای باز نگهداشتن تب میباشد -->
                                                        <div class="panel-body">
                                                            <div class="price-range width400-in-990-768">
                                                                <input style="width: 100%;" id="ex2" type="text" class="span2" name="price" value="" data-slider-min="{{$price_range['min']}}" data-slider-max="{{$price_range['max']}}" data-slider-step="5"
                                                                       @if(isset($request['price']))
                                                                       @php
                                                                           $price = explode(',',$request['price']);
                                                                           $previous_min = $price[0];
                                                                           $previous_max = $price[1];
                                                                       @endphp
                                                                       data-slider-value="[{{$price[0]}},{{$price[1]}}]"
                                                                       @else
                                                                       data-slider-value="[{{$price_range['min']}},{{$price_range['max']}}]"
                                                                        @endif
                                                                >
                                                            </div>
                                                            <div class="price-rang-text">
                                                                <span class="iransans" id="price_min">{{convert(priceFormat($price_range['min']))}}</span> تا
                                                                <span class="iransans" id="price_max">{{convert(priceFormat($price_range['max']))}}</span>
                                                            </div>
                                                            <div id="price-submit" class="submit-div m-b20">اعمال محدوده قیمت</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--attribute select-->
                                                @isset($filterTitles)
                                                    @foreach($filterTitles as $title)
                                                        <div class="panel panel-default">
                                                            <div class="panel-heading" role="tab" id="heading{{$title->id}}{{$loop->iteration}}">
                                                                <h4 class="panel-title">
                                                                    <a role="button" data-toggle="collapse" href="#collapse{{$title->id}}{{$loop->iteration}}" aria-expanded="true" aria-controls="collapse{{$title->id}}{{$loop->iteration}}" class="trigger collapsed">
                                                                        {{$title->name}}
                                                                    </a>
                                                                </h4>
                                                            </div>
                                                            <div id="collapse{{$title->id}}{{$loop->iteration}}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading{{$title->id+10}}">
                                                                <div class="panel-body">
                                                                    @php
                                                                        $options = $title->Filter()->where('status',1)->orderBy('priority','asc')->get();
                                                                    @endphp
                                                                    @isset($options)
                                                                        @foreach($options as $option)
                                                                            <div class="filter__items">
                                                                                <input  id='filter_{{$option->id}}{{$loop->iteration}}'  type='checkbox' value="{{$option->url}}"
                                                                                        @if(isset($request['tecInfo']))
                                                                                        @if(checkTecSelect($request['tecInfo'],$option))
                                                                                        checked
                                                                                        @endif
                                                                                        @endif
                                                                                >
                                                                                <label class='filterClass' data-content="{{$option->TecInfoProduct->TecInfo->tec_info_key.':'.$option->TecInfoProduct->value}}" for='filter_{{$option->id}}{{$loop->iteration}}' data-title="tecInfo">
                                                                                    <span></span>
                                                                                    <i>{{$option->name}}</i>
                                                                                </label>
                                                                            </div>
                                                                        @endforeach
                                                                    @endisset
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                @endisset
                                            <!--color select-->
                                                @isset($colors)
                                                    {{--<div class="panel panel-default">--}}
                                                        {{--<div class="panel-heading" role="tab" id="heading">--}}
                                                            {{--<h4 class="panel-title">--}}
                                                                {{--<a role="button" data-toggle="collapse" href="#collapse" aria-controls="collapse"--}}
                                                                   {{--@if(isset($request['color']))--}}
                                                                   {{--class="trigger"--}}
                                                                   {{--aria-expanded="true"--}}
                                                                   {{--@else--}}
                                                                   {{--class="trigger collapsed"--}}
                                                                   {{--aria-expanded="false"--}}
                                                                        {{--@endif--}}
                                                                {{-->--}}
                                                                    {{--براساس رنگ--}}

                                                                {{--</a>--}}
                                                            {{--</h4>--}}
                                                        {{--</div>--}}
                                                        {{--<div id="collapse"--}}
                                                             {{--@if(isset($request['color']))--}}
                                                             {{--class="panel-collapse collapse in"--}}
                                                             {{--aria-expanded="true"--}}
                                                             {{--@else--}}
                                                             {{--class="panel-collapse collapse"--}}
                                                             {{--aria-expanded="false"--}}
                                                             {{--@endif--}}
                                                             {{--role="tabpanel" aria-labelledby="heading">--}}
                                                            {{--<div class="panel-body panel-body-color">--}}
                                                                {{--@foreach($colors as $color)--}}
                                                                    {{--<div class="color_items">--}}
                                                                        {{--<input id='color_{{$color->id}}'--}}
                                                                               {{--@if(isset($request['color']))--}}
                                                                               {{--@foreach($request['color'] as $value)--}}
                                                                               {{--@if($value == $color->id)--}}
                                                                               {{--value="color[{{$value}}]={{$color->id}}"--}}
                                                                               {{--checked--}}
                                                                               {{--@else--}}
                                                                               {{--value="color[{{$color->id}}]={{$color->id}}"--}}
                                                                               {{--@endif--}}
                                                                               {{--@endforeach--}}
                                                                               {{--@else--}}
                                                                               {{--value="color[{{$color->id}}]={{$color->id}}"--}}
                                                                               {{--@endif--}}
                                                                               {{--type='checkbox' >--}}
                                                                        {{--<label for='color_{{$color->id}}' class="box-shadow color" data-title="{{$color->colorName}}" data-toggle="tooltip" style="background-color:{{'#'.$color->colorCode}}">--}}
                                                                            {{--<i></i>--}}
                                                                        {{--</label>--}}
                                                                    {{--</div>--}}
                                                                {{--@endforeach--}}
                                                            {{--</div>--}}
                                                        {{--</div>--}}
                                                    {{--</div>--}}
                                                @endisset
                                            </div>
                                        </div>
                                        <!--left colmn-->
                                        <div id="products-load">
                                            @include('public.SiteFront.Collections.load',array('request' => $request))
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        {{--<div id="loading">--}}
            {{--<p>--}}
                {{--<img src="{{url('/')}}/ajax-loader.gif" width="70px" alt="لودر @isset($setteng){{$setteng->name}}@endisset" title="لودر @isset($setteng){{$setteng->name}}@endisset"/>--}}
            {{--</p>--}}
        {{--</div>--}}
        <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

        @include('public.SiteFront.Collections.viewedProductsInclude')

    </div>
    <div class="exchange-box">
        <div class="show-botton" id="show-btn">
            <span>مقایسه (<span id="product_count">0</span> مورد)</span>
        </div>
        <div class="exchange-bg-white">
            <div class="exchange-items">
                <div class="container">
                    <div class="row">
                        <form action="{{route('compare.index')}}" method="get" >
                            <div class="col-md-8 pull-right">
                                <div  id="compare_products">
                                    @include('public.SiteFront.Collections.compare')
                                </div>
                            </div>
                            <div class="col-md-4 pull-right">
                                <div class="exchange-botton-box">
                                    <button class="exchange-botton" type="submit">مقایسه</button>
                                    <div class="exchange-clear" id="compare_clear">
                                        <i class="fa fa-close"></i>حذف همه موارد</div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@stop

@section('footer')


    <script type="text/javascript">

        function handleGridList() {
            if ($('#goList').length) {
                $(document).on('click', "#goList", function (e) {
                    $(this).parent().find('li').removeClass('active');
                    $(this).addClass('active');
                    $('.collection-items').addClass('full_width ListMode');
                    $('.collection-items').removeClass('no_full_width GridMode');
                    $('.collection-items .row-left').addClass('col-md-5');
                    $('.collection-items .row-right').addClass('col-md-7');
                    $('.collection-items .product-item').removeClass('col-sm-3 col-sm-4');
                    $('.grid-mode').addClass("hide");
                    $('.list-mode').removeClass("hide");
                });
            }
            if ($('#goGrid').length) {
                $(document).on('click', "#goGrid", function (e) {
                    $(this).parent().find('li').removeClass('active');
                    $(this).addClass('active');
                    $('.collection-items').removeClass('full_width ListMode');
                    $('.collection-items').addClass('no_full_width GridMode');
                    $('.collection-items .row-left').removeClass('col-md-5');
                    $('.collection-items .row-right').removeClass('col-md-7');

                    $('.collection-items .product-item').addClass('col-sm-3');

                    $('.grid-mode').removeClass("hide");
                    $('.list-mode').addClass("hide");
                });
            }
        }
        $(document).ready(function() {
            if (location.search.search("sort_by=") == -1) {

            } else {
                if (location.search != "") {
                    var stpo = location.search.search("sort_by=") + 8,
                        sortby_url = '.' + location.search.substr(stpo).split('='),
                        sortby_url_a = sortby_url + " a";
                    $(sortby_url).addClass("active");
                    $('#sortButton .name').html($(sortby_url_a).html());
                } else {
                    $('.manual').addClass("active");
                }
            }
            handleGridList();
        });
    </script>

    <!--show hide exchange btn-->
    <script>

        $( document ).ready(function() {
            $( "#ex2" ).slider({});


            $('.show-botton').hide();
            $(document).on('click', ".close-item", function () {

                var id = $(this).attr('id');

                $.ajax({
                    url: "/clearOneCompare/" + id,
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $.each(response, function (key, value) {
                                if (key === 0) {
                                    $("#compare_products").html(value);
                                } else {
                                    $('#product_count').empty().text(value);
                                    $('#'+id+'').removeClass('current');
                                    if (value !== 0) {
                                        $('.show-botton').show(400);
                                    } else {
                                        $("#compare_products").html('');
                                        $('.exchange-box').removeClass('show-now');
                                        $('.show-botton').hide(400);
                                    }
                                }
                            });
                        }
                });
            });
            $(document).on('click', ".exchange", function (){

                if ($(this).hasClass('current')) {
                    $(this).removeClass('current');
                } else {
                    $(this).addClass('current');
                }

                var id = $(this).attr('id');

                $.ajax({
                    url     : "/getCompare/" + id,
                    type    :"GET",
                    cash    : false,
                    contentType:"application/json; charset=utf-8",
                    success :
                        function( response ) {
                            if(response === 'مقایسه بیش از ۳ محصول امکان پذیر نیست'){
                                toastr.error('مقایسه بیش از ۳ محصول امکان پذیر نیست');
                                $('#'+id).removeClass('current');
                            }else{
                                $.each( response, function( key, value ) {
                                    if(key === 0){
                                        $("#compare_products").html(value);
                                    }else{
                                        $('#product_count').empty().text(value);
                                        if(value !== 0){
                                            $('.show-botton').show(400);
                                        }else{
                                            $("#compare_products").html('');
                                            $('.exchange-box').removeClass('show-now');
                                            $('.show-botton').hide(400);
                                        }
                                    }
                                });
                            }
                        }
                });
            });
            $(document).on('click', "#show-btn", function (){
                if ( $('.exchange-box').hasClass('show-now') ) {
                    $('.exchange-box').removeClass('show-now');

                } else {
                    $('.exchange-box.show-now').removeClass('show-now');
                    $('.exchange-box').addClass('show-now');
                }
            });
            $(document).on('click', "#compare_clear", function (){
                $.ajax({
                    url     : "/clearCompare",
                    type    :"GET",
                    cash    : false,
                    success :
                        function() {
                            if ( $('.exchange-box').hasClass('show-now') ) {
                                $('.exchange-box').removeClass('show-now');
                                $("#compare_products").html('');
                                $('.show-botton').hide(400);
                                $('.current').removeClass('current');
                            } else {
                                $('.exchange-box.show-now').removeClass('show-now');
                                $('.exchange-box').addClass('show-now');
                            }
                        }
                });

            });

            $(document).on('click', "#only_available", function () {

                $("#loading").show();
                if ($('#only_available').is(':checked')) {
                    var status = 1;
                } else {
                    var status = 0;

                }

                var previous_min = $('#previous_min').val();
                var previous_max = $('#previous_max').val();

                var params = window.location.search;
                var path = window.location.pathname;

                var old_url = path+params;

                if ($.getUrlVar("status") != null) {
                    var re = new RegExp("&status=\\d+");
                    var url = old_url.replace(re, '&status='+status);
                }else{

                    var url = old_url+'&status=' + status;
                }

                window.history.pushState("", "", url);

                $.ajax({
                    url: url,
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $('#products-load').html(response);
                            $.ajax({
                                url     : "{{route('set_choices.status')}}",
                                type    :"POST",
                                cash    : false,
                                data    :{
                                    previous_min:previous_min,
                                    previous_max:previous_max,
                                    filter : status,_token:$('#token').val()},
                                success :
                                    function(response) {
                                        $("#loading").hide();
                                        $('#choices').html(response);
                                    }
                            });
                        }

                });
            });

            $(document).on('click', "#price-submit", function () {

                $("#loading").show();

                var price = $('#ex2').val();

                var params = window.location.search;
                var path = window.location.pathname;

                var old_url = path+params;

                var max = $('#price_max').html();
                var min = $('#price_min').html();
                var previous_min = $('#previous_min').val();
                var previous_max = $('#previous_max').val();

                if ($.getUrlVar("price") != null) {
                    var re = new RegExp("&price=\\d+,\\d+");
                    var url = old_url.replace(re, '&price='+price);
                }else{

                    var url = old_url+'&price=' + price;
                }

                window.history.pushState("", "", url);
                $.ajax({
                    url: url,
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $('#products-load').html(response);
                            $.ajax({
                                url     : "{{route('set_choices.price')}}",
                                type    :"POST",
                                cash    : false,
                                data    :{
                                    previous_min:previous_min,
                                    previous_max:previous_max,
                                    max : max,min : min,filter : price,_token:$('#token').val()},
                                success :
                                    function(response) {
                                        $("#loading").hide();
                                        $('#choices').html(response);
                                    }
                            });
                        }

                });
            });

            <!-- tecinfo and brand filters -->

            $(document).on('click', ".filterClass", function () {

                $("#loading").show();

                var id = $(this).attr('for');

                var html = $(this).attr("data-content");

                var filter = $('#'+id).val();

                var params = decodeURIComponent(window.location.search);
                var path = decodeURIComponent(window.location.pathname);

                var previous_min = $('#previous_min').val();
                var previous_max = $('#previous_max').val();

                var old_url = path+params;

                var res = filter.split("=");

                if ($.getUrlVar(res[0]) != null) {

                    var url = old_url.replace("&"+filter, "");
                }else{

                    var url = old_url+'&'+filter;
                }

                window.history.pushState("", "", url);
                $.ajax({
                    url: url,
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $('#products-load').html(response);
                            $.ajax({
                                url     : "{{route('set_choices.filters')}}",
                                type    :"POST",
                                cash    : false,
                                data    :{
                                    previous_min:previous_min,
                                    previous_max:previous_max,
                                    html : html,filter : filter,_token:$('#token').val()},
                                success :
                                    function(response) {
                                        $("#loading").hide();
                                        $('#choices').html(response);
                                    }
                            });
                        }

                });
            });

            <!--end tecinfo and brand filters -->

            <!-- color filters -->

            $(document).on('click', ".color", function () {

                $("#loading").show();

                var id = $(this).attr('for');

                var color = $('#'+id).val();

                var params = decodeURIComponent(window.location.search);
                var path = decodeURIComponent(window.location.pathname);

                var old_url = path+params;

                var previous_min = $('#previous_min').val();
                var previous_max = $('#previous_max').val();
                var html = $(this).attr('data-title');

                var res = color.split("=");

                if ($.getUrlVar(res[0]) != null) {

                    var url = old_url.replace("&"+color, "");
                }else{

                    var url = old_url+'&'+color;
                }

                window.history.pushState("", "", url);

                $.ajax({
                    url: url,
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $('#products-load').html(response);
                            $.ajax({
                                url     : "{{route('set_choices.colors')}}",
                                type    :"POST",
                                cash    : false,
                                data    :{
                                    html:html,
                                    previous_min:previous_min,
                                    previous_max:previous_max,
                                    filter : color,_token:$('#token').val()},
                                success :
                                    function(response) {
                                        $("#loading").hide();
                                        $('#choices').html(response);
                                    }
                            });
                        }

                });
            });

            <!--end color filters -->

            $(document).on('click', ".filtered__clear-button", function () {

                $("#loading").show();

                var page = '&'+ $('#page').val();
                if(page == '&page=1'){
                    page = '';
                }
                var cat = $('#cat').val();
                var path = decodeURIComponent(window.location.pathname);

                var url = path+'?'+cat+page;
                window.history.pushState("", "", url);
                $('input:checkbox').removeAttr('checked');
                $.ajax({
                    url: "{{route('clear_choices')}}",
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $("#loading").hide();
                            $('#choices').html(response);
                            window.location.reload(true);
                        }
                });
            });

            $(document).on('click', '.filtered__filter-name--close', function () {

                $("#loading").show();

                var filter = $(this).attr('data-name');
                var html = $(this).attr('data-title');

                var params = decodeURIComponent(window.location.search);
                var path = decodeURIComponent(window.location.pathname);

                var previous_min = $('#previous_min').val();
                var previous_max = $('#previous_max').val();

                var old_url = path+params;


                var res = filter.split("=");


                if ($.getUrlVar(res[0]) != null) {

                    var url = old_url.replace("&"+filter, "");
                }
                window.history.pushState("", "", url);

                $.ajax({
                    url: url,
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $('#products-load').html(response);
                            $.ajax({
                                url     : "{{route('clear_choice')}}",
                                type    :"POST",
                                cash    : false,
                                data    :{
                                    previous_min : previous_min,
                                    previous_max : previous_max,
                                    html:html,filter : filter,_token:$('#token').val()},
                                success :
                                    function(response) {
                                        $("input[value='"+filter+ "']").prop('checked', false);
                                        $('#choices').html(response);
                                        $("#loading").hide();
                                    }
                            });
                        }

                });
            });

            $(document).on('change', "#sort", function () {

                $("#loading").show();

                var sortby = $(this).val();

                var params = decodeURIComponent(window.location.search);
                var path = decodeURIComponent(window.location.pathname);

                var old_url = path+params;

                if ($.getUrlVar("sortby") != null) {
                    var re = new RegExp("&sortby=\\d+");
                    var url = old_url.replace(re, '&sortby='+sortby);
                }else{

                    var url = old_url+'&sortby=' + sortby;
                }

                window.history.pushState("", "", url);

                $.ajax({
                    url: url,
                    type: "GET",
                    cash: false,
                    success:
                        function (response) {
                            $('#products-load').html(response);
                            $("#loading").hide();

                        }
                });
            });
        });



        //gets the params in url with name****MOHEM***
        $.extend({
            getUrlVars: function(){
                var vars = [], hash;
                var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');

                for(var i = 0; i < hashes.length; i++)
                {
                    hash = decodeURIComponent(hashes[i]).split('=');
                    vars.push(hash[0]);
                    vars[hash[0]] = hash[1];
                }
                return vars;
            },
            getUrlVar: function(name){
                return $.getUrlVars()[name];
            }
        });
        
       // Reload page "زدن دکمه برگشت مرورگر به درخواست ایجکس"
        window.onpopstate = function(event) {
            location.reload();
        };
    </script>
@endsection
