@extends('public.layouts.SiteFront.main')

@section('content')
    <section class="collection-heading heading-content hidden-sm hidden-xs" xmlns="">
        <div class="container">
            <div class="row">
                <div class="collection-wrapper">
                    <div class="breadcrumb-group box-shadow">
                        <div class="breadcrumb clearfix">
                            <span><a href="{{route('home')}}">@isset($setteng){{$setteng->name}}@endisset</a></span>
                            <span class="fa fa-angle-left angle"></span>
                            <span><a href="#">مقایسه</a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="product-detail-content m-t10">
        <div class="detail-content-wrapper">
            <div class="container p0-768">
                <div class="row">
                    <div class="back-white box-shadow m-b20">
                        <form id="compare-form" action="{{route('compare.index')}}" method="get" >
                            <div class="main-box">
                                <table @if(count($products['products']) == 1) style="width: 50%" @elseif(count($products['products']) == 2) style="width: 75%" @else style="width: 100%" @endif class="table food2">
                                    <thead>
                                    <tr>
                                        <th scope="col">

                                        </th>
                                        @foreach($products['products'] as $pro)
                                            @if($loop->first)
                                                <span style="display: none" id="stuffType">{{$pro->stuffType_id}}</span>
                                                <span style="display: none" id="category">{{$pro->category_id}}</span>
                                            @endif
                                            @php
                                                $totalRate = \App\Models\Review::totalRate($pro->id);
                                            @endphp
                                            <th scope="col" class="col">
                                                <span class="fa fa-close close-span" data-content="{{$pro->id}}"></span>
                                                <span class="all" style="display: none" data-content="{{$pro->id}}"></span>
                                                <div class="star">
                                                    @if(!is_null($totalRate))
                                                        <i class="fa fa-star"></i>
                                                        <span>{{$totalRate}}</span>
                                                    @else
                                                        <i class="fa fa-star"></i>
                                                        <span>ــ</span>
                                                    @endif
                                                </div>
                                                <a href="{{$pro->path()}}">
                                                    <img src="{{$pro->base_thumbnail_url}}" alt="{{$pro->name}}" title="{{$pro->name}}">
                                                </a>
                                                <a href="{{$pro->path()}}" class="product-name">
                                                    <h2>{{$pro->name}}</h2>
                                                    <h2>{{$pro->eng_name}}</h2>
                                                </a>
                                                {!! $pro->getPriceCompare() !!}
                                                <input name="TDX[{{$loop->iteration}}]" value="{{$pro->id}}" hidden>
                                            </th>
                                        @endforeach
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                    </tr>
                                    @foreach($products['infos'] as $key => $info)

                                        <tr>
                                            <td>{{$key}}</td>
                                            @foreach($info as $value)
                                                <td>
                                                    {{$value}}
                                                </td>
                                            @endforeach

                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                @for($i=3;$i > count($products['products']);$i--)
                                    <div class="col3">
                                        <div class="select-col-back">
                                            <span>افزودن</span>
                                            <div class="unitnumber-container">
                                                <div class="styled-select">
                                                    <select required class="form-control brand" data-content="{{$i}}" style="height: 3.3em">
                                                        <option value="0">برند</option>
                                                        @foreach($brands as $brand)
                                                            <option value="{{$brand->id}}">{{$brand->brandName}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <input name="TDX[{{$i}}]" id="in-{{$i}}" hidden>
                                                <div class="unitnumber-container">
                                                    <div class="styled-select">
                                                        <select  class="form-control product" data-content="{{$i}}" id="p-{{$i}}"  disabled  style="height: 3.3em">
                                                            <option value="0">کالا</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <button class="btn btn-success" type="submit" id="s-{{$i}}" disabled>اضافه کن</button>
                                            </div>
                                        </div>
                                    </div>
                                @endfor
                            </div>
                        </form>
                        <div class="responsive-error">
                            <span>امکان مقایسه فقط در سایز بزرگ قابل مشاهده میباشد</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop

@section('title')
    <title>  مقایسه محصول |@isset($setteng){{$setteng->title}}@endisset </title>
    <meta name="description" content="@isset($setteng){{$setteng->description}}@endisset"/>
    <meta name="keywords" lang="fa" content="@isset($setteng){{$setteng->keywords}}@endisset">

    <meta property="og:locale" content="fa"/>
    <meta property="og:type" content="website"/>
    <meta property="og:url" content="http://www.amazontele.com"/>
    <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>
    <meta property="og:title" content="@isset($setteng){{$setteng->title}}@endisset"/>
    <meta property="og:image" content="@isset($setteng){{url('/').$setteng->fave_logo}}@endisset"/>
@endsection

@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/product-styles.css" rel="stylesheet" type="text/css" media="all">
    <link href="/SiteAssets/assets/stylesheets/pretty-checkbox.min.css" rel="stylesheet" type="text/css" media="all">
    <!--for comparison-->
    <link href="/SiteAssets/assets/stylesheets/comparison.css" rel="stylesheet" type="text/css" media="all">

    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>




@stop

@section('scripts')



    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>

    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>

    <script>
        $(".brand").select2({
            allowClear:true,
            placeholder: 'برند'
        });
        $(".product").select2({
            allowClear:true,
            placeholder: 'محصول'
        });
    </script>

@stop
@section('footer')
    <script>
        $(document).ready(function($) {

            // Change 'form' to class or ID of your specific form
            $("#compare-form").submit(function () {
                $(this).find(":input").filter(function () {
                    return !this.value;
                }).attr("disabled", "disabled");
                return true; // ensure form still submits
            });

        });
    </script>
    <script>

        $('.brand').change(function () {
            var i = $(this).attr('data-content');

            var select_id = 'p-' + i;
            var btn_id = 's-'+ i;

            var id = $(this).val();

            var stuffType_id = $('#stuffType').html();
            var category_id = $('#category').html();

            if(id != 0){
                $.ajax({
                    url     : "{{route('get.products.compare')}}",
                    type    :"GET",
                    cash    : false,
                    data    :{ brand_id : id,stuffType_id : stuffType_id,category_id : category_id},
                    success :
                        function(response) {
                            var html = '<option value="0">انتخاب کنید...</option>';
                            $.each( response, function( key, value ) {
                                console.log(value);
                                html += '<option value="'+value.id+'">'+value.name+'</option>';
                            });
                            $('#'+select_id).html(html).prop('disabled', false);
                            $('#'+btn_id).prop('disabled', false);

                        },
                    error :
                        function( ) {
                            swal({
                                title: "خطا !",
                                text: "ارتباط ضعیف است لطفا صفحه را دوباره بارگذاری کنید",
                                type: "error",
                                showConfirmButton: true,
                                confirmButtonText :'باشه'
                            });
                        }
                });
            }else{
                var html = '<option value="0">کالا</option>';
                $('#'+select_id).html(html).prop('disabled', true);

            }
        });

        $('.product').change(function () {
            var i = $(this).attr('data-content');

            var btn_id = 's-'+ i;
            var val = $(this).val();
            var input_id = 'in-'+ i;

            if(val != 0){
                $('#'+input_id).val(val);
                $('#'+btn_id).prop('disabled', false);
            }else{
                $('#'+input_id).val();
                $('#'+btn_id).prop('disabled', true);
            }
        });

        $('.close-span').click(function () {

            var elements = document.getElementsByClassName("all");
            var all = [];
            for (var i = 0, len = elements.length; i < len; i++) {
                all[i] = $(elements[i]).attr('data-content');

            }

            var removeItem = $(this).attr('data-content');

            all = jQuery.grep(all, function(value) {
                return value != removeItem;
            });


            var path = getPathFromUrl(window.location.href) ;
            var params = '?';
            var i = 1;
           var length = all.length;
            $.each( all, function(key,value) {

                params = params + "TDX["+i+"]="+value;
                if(length != i){
                    params = params + "&";
                }
                i++;
            });
           var url = path+params;
            window.history.pushState("", "", url);
            window.location.reload(false)
        });

        function getPathFromUrl(url) {
            return url.split(/[?#]/)[0];
        }
    </script>





@stop
