{{--/**--}}
{{--* Created by PhpStorm.--}}
{{--* User: saeed--}}
{{--* Date: 3/6/2018--}}
{{--* Time: 5:52 PM--}}
{{--*/--}}
@extends('public.layouts.SiteFront.main')
@section('php')

@stop
@section('content')
    @php
        $banner=$banners->where('name','blog_baner')->first();
    @endphp
    @isset($banner)
        <a class="" href="{{$banner->url}}">
            <img class="img_heading" src="{{url("$banner->image_path")}}" alt="{{$banner->title}}"
                 title="{{$banner->title}}">
        </a>
    @endisset
    <section class="blog-content">
        <div class="blog-wrapper">
            <div class="container">
                <div class="row">
                    <div id="shopify-section-blog-template" class="shopify-section">
                        <div class="blog-inner">
                            <div id="blog">
                                <div class="col-sm-9 articles">


                                    <div class="col-md-12">
                                        <div class="nav-search">
                                            <div class="nav-search">
                                                <form class="search" action="{{route('front-article-search')}}" method="GET">
                                                    <input type="text" name="articleSearch" class="search_box"
                                                           placeholder="جستجو مقالات"
                                                           @if(isset($searchBox))
                                                           value="{{$searchBox}}"
                                                            @endif
                                                    >

                                                    <button class="search_submit" type="submit">
                                                        {{--<i class="fa fa-search" style="color:#fff;font-size: 20px"></i>--}}
                                                        جستجو
                                                    </button>
                                                </form>
                                            </div>
                                        </div>

                                    </div>


                                    <div class="blog-items">
                                        <div class="article clearfix col-sm-12">
                                            <div class="m-b20">

                                                <a href="{{$article->path()}}"><img
                                                            src="{{$article->image_path}}"
                                                            alt="{{$article->title}}"
                                                            title="{{$article->title}}"></a>
                                            </div>
                                            <div class="articleinfo_group">
                                                <div class="article-title">
                                                    <h1 class="article-name"><a
                                                                href="{{$article->path()}}">{{$article->title}}</a>
                                                    </h1>
                                                </div>
                                                <ul class="article-info list-inline">
                                                    <li class="article-date">{{convert(jDate::forge($article->created_at)->format('%Y %d %B '))}}</li>
                                                </ul>
                                                <div class="article-content">
                                                    <p>{!! $article->body !!}</p>
                                                </div>
                                                <div class="share-box">
                                                    <h5>به اشتراک گذاری :</h5>
                                                    <ul>
                                                        <li>
                                                            <a target="_blank" href="https://telegram.me/share/url?url={{url($article->path())}}&text={{$article->title}}"
                                                               class="fa fa-telegram"></a></li>
                                                        <li><a target="_blank" href="http://www.twitter.com/share?url={{url($article->path())}}" class="fa fa-twitter"></a></li>
                                                        <li><a target="_blank"  href="http://www.facebook.com/sharer/sharer.php?m2w&amp;s=100&amp;p[url]={{url($article->path())}}&amp;p[images][0]={{$article->image_path}}&amp;p[title]={{$article->title}}&amp;p[summary]={{$article->title}}&zwnj;{{$article->title}}" class="fa fa-facebook"></a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="blog-bottom-toolbar">
                                        <ul class="pagination">
                                            <li class="prev"><a
                                                        @isset($previous)href="{{url($previous->path())}}" @endisset>قبلی</a>
                                            </li>
                                            <li><a href="{{route('front-articles')}}">برگشت به بلاگ</a></li>
                                            <li class="next"><a
                                                        @isset($next)href="{{url($next->path())}}" @endisset >بعدی</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>

                                <div class="col-sm-3 sidebar">
                                    <div class="sidebar-block blogs-recent">
                                        <h3 class="sidebar-title"><span>مطالب اخیر</span></h3>
                                        <div class="sidebar-content recent-article">
                                            <div class="ra-item-inner">
                                                @foreach($latest as $latest_article)
                                                    <div class="article clearfix">
                                                        <div class="article-image">
                                                            <a href="{{$latest_article->path()}}"><img
                                                                        src="{{$latest_article->thumb_path}}"
                                                                        alt="{{$latest_article->title}}"
                                                                        title="{{$latest_article->title}}"></a>
                                                        </div>
                                                        <div class="articleinfo_group">
                                                            <div class="article-title">
                                                                <h2 class="article-name"><a
                                                                            href="{{$latest_article->path()}}">{{$latest_article->title}}</a>
                                                                </h2>
                                                            </div>
                                                            <ul class="article-info list-inline">
                                                                <li class="article-date">{{convert(jDate::forge($latest_article->created_at)->format('%Y %d %B '))}}</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                @endforeach

                                            </div>
                                        </div>
                                    </div>
                                    <div class="sidebar-block blogs-bestseller">
                                        <h3 class="sidebar-title"><span>کالاهای پیشنهادی</span></h3>
                                        <div class="sidebar-content bestseller-content">
                                            <div class="bestseller-item-inner">
                                                <div class="bestseller-item">
                                                    <div class="row-container ">
                                                        @foreach($products as $product)
                                                            <div class="product home_product">
                                                                <div class="row-left">
                                                                    <a href="{{$product->path()}}"
                                                                       class="container_item">
                                                                        <div class="hoverBorderWrapper">
                                                                            <img src="{{$product->base_thumbnail_url}}"
                                                                                 class="img-responsive front"
                                                                                 title="{{$product->name}}"
                                                                                 alt="{{$product->name}}">
                                                                        </div>
                                                                    </a>
                                                                    @php
                                                                        $discount = discount($product->base_sell_price,$product->discount_sell_price,$product);
                                                                    @endphp

                                                                    @if($discount !== false)
                                                                        <span class="sale_banner">
																			<span class="sale_text ">-{{$discount}}
                                                                                %</span>
																		</span>
                                                                    @endif
                                                                </div>
                                                                <div class="row-right">
                                                                    <div class="product-title"><a
                                                                                class="title-5"
                                                                                href="{{$product->path()}}">{{$product->name}}</a>
                                                                    </div>
                                                                    @if($product->checkAvailable())
                                                                        <div class="product-price">
                                                                            <del class="price_compare">
                                                                                <span class="money">{{$product->base_sell_price}}</span>
                                                                            </del>
                                                                            <span class="price_sale"><span class="money"><span>تومان</span>{{$product->discount_sell_price}}</span></span>
                                                                        </div>
                                                                    @else
                                                                        <div class="product-price">
                                                                            <span class="price_sale"><span class="money"><span>ناموجود</span></span></span>
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="sidebar-block blog-tags clearfix">
                                        <h3 title="{{$article->title}}" class="sidebar-title"><span>تگ ها</span></h3>
                                        <div class="sidebar-content">
                                            <ul class="tags-inner tags">
                                                @php($tags=explode(',',$article->tags))
                                                @foreach($tags as $tag)
                                                    <li><a  href="{{url("article/tag/$tag")}}"
                                                           title="{{$tag}}">{{$tag}}</a></li>
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@stop
@section('title')
    <title>{{$article->title}}</title>
    <meta name="description" content="{{$article->description}}"/>
    <meta name="keywords" lang="fa" content="{{$article->tags}}">

    <meta property="og:locale" content="fa"/>
    <meta property="og:type" content="website"/>
    <meta property="og:url" content="{{url($article->path())}}"/>
    <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>
    <meta property="og:title" content="{{$article->title}}"/>
    <meta property="og:image" content="{{url($article->thumb_path)}}"/>

@endsection
@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/category.css" rel="stylesheet" type="text/css" media="all">

    <!--only for this page-->
    <link href="/SiteAssets/assets/stylesheets/single_blog.css" rel="stylesheet" type="text/css" media="all">
@stop

@section('scripts')

@stop
