@extends('public.layouts.SiteFront.main')
@section('php')

@stop
@section('content')
    <section class="collection-heading heading-content m-b30" title="مقالات و نشریات فروشگاه مواد شیمیایی آمازون تله">
        @php
            $banner=$banners->where('name','blog_baner')->first();
        @endphp
        @isset($banner)
            <a title="{{$banner->title}}" class="" href="{{$banner->url}}">
                <img class="img_heading" src="{{url("$banner->image_path")}}" alt="{{$banner->title}}"
                     title="{{$banner->title}}">
            </a>
        @endisset

    </section>
    <section class="blog-content">
        <div class="blog-wrapper">
            <div class="container">
                <div class="row">
                    <h1 title="مقالات و نشریات فروشگاه مواد شیمیایی آمازون تله" class="page-title pull-right rtl"><i class="fa fa-align-right"></i>  مقالات و نشریات آمازون تله </h1>

                    <div id="shopify-section-blog-template" class="shopify-section">
                        <div class="blog-inner">
                            <div id="blog">
                                <div class="col-sm-3 sidebar">
                                    <div class="sidebar-block blogs-recent">
                                        <h3 title="مقالات پربازدید فروشگاه مواد شیمیایی آمازون تله" class="sidebar-title"><span>مقالات پربازدید</span></h3>
                                        <div class="sidebar-content recent-article">
                                            <div class="ra-item-inner">
                                                @foreach($visited as $article)
                                                    <div class="article clearfix">
                                                        <div class="article-image">
                                                            <a title="{{$article->title}}" href="{{$article->path()}}"><img
                                                                        src="{{$article->thumb_path}}"
                                                                        alt="{{$article->title}}"
                                                                        title="{{$article->title}}"></a>
                                                        </div>
                                                        <div class="articleinfo_group">
                                                            <div class="article-title">
                                                                <h2 title="{{$article->title}}" class="article-name"><a
                                                                            href="{{$article->path()}}">{{$article->title}}</a>
                                                                </h2>
                                                            </div>
                                                            <ul class="article-info list-inline">
                                                                <li class="article-date">{{convert(jDate::forge($article->created_at)->format('%Y %d %B '))}}</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                @endforeach

                                            </div>
                                        </div>
                                    </div>
                                    <div class="sidebar-block blogs-bestseller hidden-sm hidden-xs">
                                        <h3 title="کالاهای پیشنهادی فروشگاه مواد شیمیایی آمازون تله" class="sidebar-title"><span>کالاهای پیشنهادی</span></h3>
                                        <div class="sidebar-content bestseller-content">
                                            <div class="bestseller-item-inner">
                                                <div class="bestseller-item">
                                                    <div class="row-container ">
                                                        @foreach($products as $product)
                                                            <div class="product home_product">
                                                                <div class="row-left">
                                                                    <a title="{{$product->name}}" href="{{$product->path()}}"
                                                                       class="container_item">
                                                                        <div class="hoverBorderWrapper">
                                                                            <img src="{{$product->base_thumbnail_url}}"
                                                                                 class="img-responsive front"
                                                                                 title="{{$product->name}}"
                                                                                 alt="{{$product->name}}">
                                                                        </div>
                                                                    </a>
                                                                    <span class="sale_banner">
																			<span class="sale_text ">-{{discount($product->base_sell_price,$product->discount_sell_price,$product)}}
                                                                                %</span>
																		</span>
                                                                </div>
                                                                <div class="row-right">
                                                                    <div class="product-title"><a
                                                                                class="title-5"
                                                                                href="{{$product->path()}}">{{$product->name}}</a>
                                                                    </div>
                                                                    @if($product->checkAvailable())
                                                                        <div class="product-price">
                                                                            <del class="price_compare">
                                                                                <span class="money">{{$product->base_sell_price}}</span>
                                                                            </del>
                                                                            <span class="price_sale"><span class="money"><span>تومان</span>{{$product->discount_sell_price}}</span></span>
                                                                        </div>
                                                                    @else
                                                                        <div class="product-price">
                                                                            <span class="price_sale"><span class="money"><span>ناموجود</span></span></span>
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    {{--<div class="sidebar-block blog-tags clearfix">--}}
                                    {{--<h3 class="sidebar-title"><span>تگ ها</span></h3>--}}
                                    {{--<div class="sidebar-content">--}}
                                    {{--<ul class="tags-inner tags">--}}
                                    {{--<li><a href="blog.html" title="Show articles tagged tag">تگ</a></li>--}}
                                    {{--<li><a href="blog.html" title="Show articles tagged tag">تگ</a></li>--}}
                                    {{--<li><a href="blog.html" title="Show articles tagged tag">تگ</a></li>--}}
                                    {{--<li><a href="blog.html" title="Show articles tagged tag">تگ</a></li>--}}
                                    {{--<li><a href="blog.html" title="Show articles tagged tag">تگ</a></li>--}}
                                    {{--<li><a href="blog.html" title="Show articles tagged tag">تگ</a></li>--}}
                                    {{--</ul>--}}
                                    {{--</div>--}}
                                    {{--</div>--}}
                                </div>
                                <div class="col-sm-9 articles">

                                    <div class="nav-search">
                                        <div class="nav-search">
                                            <form class="search" action="{{route('front-article-search')}}" method="GET">
                                                <input type="text" name="articleSearch" class="search_box"
                                                       placeholder="جستجو مقالات"
                                                       @if(isset($searchBox))
                                                       value="{{$searchBox}}"
                                                        @endif
                                                >

                                                <button class="search_submit" type="submit">
                                                    {{--<i class="fa fa-search" style="color:#fff;font-size: 20px"></i>--}}
                                                    جستجو
                                                </button>
                                            </form>
                                        </div>
                                    </div>


                                    <div class="blog-toolbar">
                                        <div class="toolbar_left" style="text-align: right">
                                            @if(sizeof($articles)>0)
                                                <span>نمایش</span>
                                                @php
                                                    $page=isset($_GET['page']) ? $_GET['page'] : 1;
                                                    $count=count($articles);
                                                    $a=ceil($articles->total()/$articles->lastPage());
                                                @endphp
                                                <span class="iransans">{{($articles->currentpage()-1)*$articles->perpage()+1}} </span>
                                                <span> الی </span>
                                                @if($count<$a)
                                                    <span class="iransans"> {{$articles->total()}} </span>
                                                @else
                                                    <span class="iransans">{{$count*$page}} </span>
                                                @endif
                                                <span>مقاله</span>
                                                <span> از </span>
                                                <span class="iransans"> {{ $articles->total() }} </span>

                                                <span>( صفحه</span>
                                                <span class="iransans"> {{ $articles->lastPage() }} </span>
                                                <span>)</span>

                                            @endif
                                        </div>
                                    </div>
                                    <div class="blog-items">
                                        @foreach($articles as $article)
                                            <div class="article clearfix col-sm-6 blog_Grid">
                                                <a title="{{$article->title}}" href="{{$article->path()}}">
                                                    <div class="article-image">
                                                        <img src="{{$article->thumb_path}}" alt="{{$article->title}}" title="{{$article->title}}">
                                                    </div>
                                                </a>
                                                <div class="articleinfo_group">
                                                    <div class="article-title">
                                                        <h2 title="{{$article->title}}" class="article-name"><a title="{{$article->title}}"
                                                                    href="{{$article->path()}}">{{$article->title}}</a>
                                                        </h2>
                                                    </div>
                                                    <ul class="article-info list-inline">
                                                        <li class="article-date">{{convert(jDate::forge($article->created_at)->format('%Y %d %B '))}}</li>
                                                    </ul>
                                                    <div class="article-content">
                                                        <p>{{$article->description}}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="blog-bottom-toolbar">
                                        {{$articles->links()}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@stop
@section('title')
    <title>مقالات | @isset($setteng){{$setteng->title}}@endisset </title>
    <meta name="description" content="@isset($setteng){{$setteng->description}}@endisset"/>
    <meta name="keywords" lang="fa" content="@isset($setteng){{$setteng->keywords}}@endisset">

    <meta property="og:locale" content="fa"/>
    <meta property="og:type" content="website"/>
    <meta property="og:url" content="http://www.amazontele.com"/>
    <meta property="og:site_name" content="@isset($setteng){{$setteng->name}}@endisset"/>
    <meta property="og:title" content="@isset($setteng){{$setteng->title}}@endisset"/>
    <meta property="og:image" content="@isset($setteng){{url('/').$setteng->fave_logo}}@endisset"/>

@endsection
@section('head_bottom')
    <!--only for this page stylesheets-->
    <link href="/SiteAssets/assets/stylesheets/category.css" rel="stylesheet" type="text/css" media="all">

    <!--only for this page-->
    <link href="/SiteAssets/assets/stylesheets/blog.css" rel="stylesheet" type="text/css" media="all">
@stop

@section('scripts')

@stop
