@extends('/CRM/layout')
<!-- BEGIN PAGE BAR -->
@section('pageBar')
    <li>
        <a href="Dashboard">خانه</a>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>پنل مدیریت</span>
        <i class="fa fa-circle"></i>
    </li>
    <li>
        <span>پروفایل</span>
    </li>

@stop
@section('content')
    @if(session()->has('message') && session()->has('messageType'))
        <br>
        @if(session('messageType') == 'success')
            <div class="alert alert-success">
                <p>{{session('message')}}</p>
            </div>
        @elseif(session('messageType') == 'failure')
            <div class="alert alert-danger">
                <p>{{session('message')}}</p>
            </div>
        @endif
    @endif
    @if(count($errors) > 0)
        @php
            $hasError = true;
        @endphp
        <div class="alert alert-danger">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{$error}}</li>
                @endforeach
            </ul>
        </div>
    @else
        @php
            $hasError = false;
        @endphp
    @endif
    @php
        $user = Auth::user();
    @endphp
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    <div class="profile">
        <div class="tabbable-line tabbable-full-width">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab_1_1" data-toggle="tab"> ایجاد کاربر جدید </a>
                </li>
            </ul>
            <div class="tab-content">
                <!--tab_1_2-->
                <div class="tab-pane active" id="tab_1_1">
                    <div class="row profile-account">
                        <div class="col-md-12">
                            <div class="tab-content">
                                <div id="tab_1-1" class="tab-pane active">
                                    <form role="form" method="post" action="{{route('admin.user.store')}}">
                                        {{csrf_field()}}
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">نام </label>
                                                <input type="text" name="fname" value="{{old('fname')}}" class="form-control" required autofocus/>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">نام خانوادگی</label>
                                                <input type="text" name="lname" value="{{old('lname')}}" class="form-control" required/>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">موبایل</label>
                                                <input type="text" name="mobile" value="{{old('mobile')}}" class="form-control" required/>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">کد ملی</label>
                                                <input type="text" name="melli_code" value="{{old('melli_code')}}" class="form-control" required/>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">رمز عبور</label>
                                                <input type="password" name="password" class="form-control" required autocomplete="off"/>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">تکرار رمز عبور جدید</label>
                                                <input type="password" name="password_confirmation" class="form-control" required autocomplete="off"/>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label>نقش</label>
                                            <div class="mt-radio-inline">
                                                <label class="mt-radio">
                                                    <input type="radio" name="role" id="role" value="admin" style="margin-right: 30px;"
                                                           @if(!is_null(old('status')) && old('status') == 'admin')
                                                           checked
                                                           @else
                                                           checked
                                                            @endif
                                                    >&nbsp;مدیر
                                                    <span></span>
                                                </label>
                                                <label class="mt-radio">
                                                    <input type="radio" name="role" id="role" value="costumer" style="margin-right: 50px;"
                                                           @if(!is_null(old('status')) && old('status') == 'costumer')
                                                           checked
                                                            @endif
                                                    >مشتری
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-12 margiv-top-10">
                                            <button type="submit" class="btn green"> ثبت </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!--end col-md-9-->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- END CONTENT BODY -->


@endsection