@extends('public.layouts.public-master')

@section('title')
    بازیابی رمز عبور
@stop

@section('body')
    @if(session()->has('message') && session()->has('messageType'))
        <div class="container">
            <br>
            @if(session('messageType') == 'success')
                <div class="alert alert-success">
                    <p>{{session('message')}}</p>
                </div>
            @elseif(session('messageType') == 'failure')
                <div class="alert alert-danger">
                    <p>{{session('message')}}</p>
                </div>
            @endif
        </div>
    @else

        @if(count($errors) > 0)
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{$error}}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <form method="post" action="resetPassword" >
            <div class="row">
                <p class="form-group col-sm-5 col-sm-offset-7">
                    <label for="email">ایمیل:</label>
                    <input type="text" name="email" id="email" class="form-control">
                </p>
            </div>
            {{csrf_field()}}
            <input type="submit" name="send" value="ارسال" class="btn btn-default">
        </form>
    @endif
@stop