@extends('/CRM/layouts/main')
@section('scripts')
    <script>
        $(document).ready(function () {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
@stop
@section('sideBar')
    <li class="heading">
        <h3 class="uppercase">خانه</h3>
    </li>
    <li class="nav-item">
        <a href="/CRM/Dashboard" class="nav-link nav-toggle FarsiFont ">
            <i class="fa fa-dashboard"></i>
            <span class="title">داشبورد</span>
            <span class="selected"></span>
        </a>

    </li>
    @if(Auth::user()->can(['آمار و نمودارها','همه']))
        <li class="nav-item">
            <a href="{{route('charts.index')}}" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-bar-chart-o"></i>
                <span class="title">آمار و نمودارها</span>
            </a>
        </li>
    @endif
    <li class="heading">
        <h3 class="uppercase">فروشگاه</h3>
    </li>
    @if(Auth::user()->can(['تنظیمات انبار','همه','لیست کالا','قیمت گذاری همه','تنظیمات اولیه','تعریف کالا']))

        <li class="nav-item">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-industry" aria-hidden="true"></i>
                <span class="title"> تنظیمات انبار</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['تنظیمات انبار','همه','لیست کالا']))
                    <li class="nav-item">
                        <a href="{{route('product.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-cubes"></i>
                            <span class="title">لیست کالا</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['تنظیمات انبار','همه','تعریف کالا']))
                    <li class="nav-item ">
                        <a href="{{route('product.create')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-cube"></i>
                            <span class="title">تعریف کالا</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['تنظیمات انبار','همه','قیمت گذاری همه']))

                    <li class="nav-item  ">
                        <a href="{{route('price-chunk.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-dollar"></i>
                            <span class="title">قیمت گذاری همه</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['تنظیمات انبار','همه','تنظیمات اولیه']))

                    <li class="nav-item  ">
                        <a href="/CRM/store/setting" class="nav-link FarsiFont ">
                            <i class="fa fa-cog"></i>
                            <span class="title">تنظیمات اولیه</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif    @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف رنگ','تعریف برند','تعریف نوع کالا','تعریف دسته بندی','تعریف مشخصات فنی']))
        <li class="nav-item ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-info-circle"></i>
                <span class="title">اطلاعات پایه کالا</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف نوع کالا','تعریف دسته بندی','تعریف مشخصات فنی','تعریف سایز']))
                    <li class="nav-item ">
                        <a href="{{url('/CRM/createStuffType')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-tags"></i>
                            <span class="title">تعریف نوع کالا</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف دسته بندی','تعریف مشخصات فنی','تعریف سایز']))
                    <li class="nav-item  ">
                        <a href="{{route('category.show')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-tag"></i>
                            <ul>
                                <li class="title">تعریف دسته بندی</li>
                                <li class="title">تعریف مشخصات فنی</li>
                                <li class="title">تعریف سایز</li>

                            </ul>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف برند']))
                    <li class="nav-item  ">
                        <a href="{{url('CRM/createBrand')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-apple"></i>
                            <span class="title">تعریف برند</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف رنگ']))
                    <li class="nav-item  ">
                        <a href="{{route('color.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-eyedropper"></i>
                            <span class="title"> تعریف رنگ </span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['اطلاعات پایه کالا','همه','تعریف کالا']))
                    <li class="nav-item  ">
                        <a href="{{route('stuff.show')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-sign-in"></i>
                            <span class="title">تعریف کالا</span>
                        </a>
                    </li>
                @endif

            </ul>
        </li>
    @endif
    <li class="heading">
        <h3 class="uppercase">رویداد ها</h3>
    </li>
    @if(Auth::user()->can(['همه','مدیریت سبدهای خرید','سبدهای در انتظار تایید','سبدهای تایید شده']))
        <li class="nav-item  ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-shopping-cart" aria-hidden="true"></i>
                <span class="title">مدیریت سبدهای خرید</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['مدیریت سبدهای خرید','همه','سبدهای در انتظار تایید']))
                    <li class="nav-item  ">
                        <a href="{{route('carts.pending.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-dot-circle-o"></i>
                            <span class="title">سبدهای در انتظار تایید</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت سبدهای خرید','همه','سبدهای تایید شده']))
                    <li class="nav-item  ">
                        <a href="{{route('carts.confirmed.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-check-square-o"></i>
                            <span class="title">سبدهای تایید شده</span>
                        </a>
                    </li>
                @endif
                    @if(Auth::user()->can(['مدیریت سبدهای خرید','همه','ایجاد سبد']))
                    <li class="nav-item  ">
                        <a href="{{route('indexUsers')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-cart-plus"></i>
                            <span class="title">ایجاد سبد</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif
    @if(Auth::user()->can([
    'مدیریت سفارشات','همه','سفارشات در انتظار تایید',
    'سفارشات در حال بررسی','سفارشات در انتظار ارسال',
    'بخش سفارشات','همه سفارشات','سفارشات تحویل داده شده',
    'سفارشات ارسال شده']))
        <li class="nav-item  ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-shopping-cart" aria-hidden="true"></i>
                <span class="title">مدیریت سفارشات</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['مدیریت سفارشات','همه','سفارشات در انتظار تایید']))
                    <li class="nav-item  ">
                        <a href="{{route('orders.mode',1)}}" class="nav-link FarsiFont ">
                            <i class="fa fa-dot-circle-o"></i>
                            <span class="title">سفارشات در انتظار تایید</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت سفارشات','همه','سفارشات در حال بررسی']))
                    <li class="nav-item  ">
                        <a href="{{route('orders.mode',2)}}" class="nav-link FarsiFont ">
                            <i class="fa fa-refresh"></i>
                            <span class="title">سفارشات در حال بررسی</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت سفارشات','همه','سفارشات در انتظار ارسال']))
                    <li class="nav-item  ">
                        <a href="{{route('orders.mode',3)}}" class="nav-link FarsiFont ">
                            <i class="fa fa-pause"></i>
                            <span class="title">سفارشات در انتظار ارسال</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت سفارشات','همه','سفارشات ارسال شده']))
                    <li class="nav-item  ">
                        <a href="{{route('orders.mode',4)}}" class="nav-link FarsiFont ">
                            <i class="fa fa-send"></i>
                            <span class="title">سفارشات ارسال شده</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت سفارشات','همه','سفارشات تحویل داده شده']))
                    <li class="nav-item  ">
                        <a href="{{route('orders.mode',5)}}" class="nav-link FarsiFont ">
                            <i class="fa fa-check-square-o"></i>
                            <span class="title">سفارشات تحویل داده شده</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت سفارشات','همه','همه سفارشات']))
                    <li class="nav-item  ">
                        <a href="{{route('orders.show')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-shopping-cart"></i>
                            <span class="title">همه سفارشات</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت سفارشات','همه','بخش سفارشات']))
                    <li class="nav-item  ">
                        <a href="{{route('orders.section')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-google-wallet"></i>
                            <span class="title">بخش سفارشات</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif
    @if(Auth::user()->can(['مدیریت نظرات','همه','نظرات در انتظار تایید','نظرات تایید شده','همه نظرات','بخش نظرات']))
        <li class="nav-item  ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-comments" aria-hidden="true"></i>
                <span class="title">مدیریت نظرات</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['مدیریت نظرات','همه','نظرات در انتظار تایید']))
                    <li class="nav-item  ">
                        <a href="{{route('pending.show')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-commenting"></i>
                            <span class="title">نظرات در انتظار تایید</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت نظرات','همه','نظرات تایید شده']))
                    <li class="nav-item  ">
                        <a href="{{route('approved.show')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-check"></i>
                            <span class="title">نظرات تایید شده</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت نظرات','همه','نظرات تایید نشده']))
                    <li class="nav-item  ">
                        <a href="{{route('declined.show')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-times"></i>
                            <span class="title">نظرات تایید نشده</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت نظرات','همه','همه نظرات']))
                    <li class="nav-item  ">
                        <a href="{{route('comments.show')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-comments"></i>
                            <span class="title">همه نظرات</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت نظرات','همه','بخش نظرات']))
                    <li class="nav-item  ">
                        <a href="{{route('comments.section')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-google-wallet"></i>
                            <span class="title">بخش نظرات</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif
    <li class="heading">
        <h3 class="uppercase">امکانات</h3>
    </li>
    @if(Auth::user()->can(['پیام های گروهی','همه','لیست پیام ها','ارسال پیام']))
        <li class="nav-item  ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-envelope-o" aria-hidden="true"></i>
                <span class="title">پیام های گروهی</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['پیام های گروهی','همه','ارسال پیام']))
                    <li class="nav-item  ">
                        <a href="{{route('message.create')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-send-o" aria-hidden="true"></i>
                            <span class="title">ارسال پیام</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['پیام های گروهی','همه','لیست پیام ها']))
                    <li class="nav-item  ">
                        <a href="{{route('message.list')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-envelope-o" aria-hidden="true"></i>
                            <span class="title">لیست پیام ها</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif

    @if(Auth::user()->can(['مدیریت صفحه اصلی','همه','منو اصلی','اسلایدر اصلی','پیشنهادات شگفت انگیز']))
        <li class="nav-item  ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-cogs"></i>
                <span class="title">مدیریت صفحه اصلی</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['مدیریت صفحه اصلی','همه','منو اصلی']))
                    <li class="nav-item  ">
                        <a href="{{route('dynamicMenu.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-list"></i>
                            <span class="title">منو اصلی</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت صفحه اصلی','همه','اسلایدر اصلی']))
                    <li class="nav-item  ">
                        <a href="{{route('slider-home.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-file-image-o" aria-hidden="true"></i>
                            <span class="title">اسلایدر اصلی</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['مدیریت صفحه اصلی','همه','پیشنهادات شگفت انگیز']))
                    <li class="nav-item  ">
                        <a href="{{route('amazing.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-magic" aria-hidden="true"></i>
                            <span class="title">پیشنهادات شگفت انگیز</span>
                        </a>
                    </li>
                @endif
                {{--@if(Auth::user()->can(['مدیریت صفحه اصلی','همه','قیمت لحظه ای']))--}}
                    {{--<li class="nav-item  ">--}}
                        {{--<a href="{{route('priceList.index')}}" class="nav-link FarsiFont ">--}}
                            {{--<i class="fa fa-dollar" aria-hidden="true"></i>--}}
                            {{--<span class="title">قیمت لحظه ای</span>--}}
                        {{--</a>--}}
                    {{--</li>--}}
                {{--@endif--}}
            </ul>
        </li>
    @endif
    @if(Auth::user()->can(['بنرهای دسته بندی','بنرهای نوع کالا','بنر وبلاگ','مدیریت بنرها','بنرهای صفحه اصلی','جدیدترین ها','همه']))
        <li class="nav-item">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-windows"></i>
                <span class="title">مدیریت بنرها</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['مدیریت بنرها','بنرهای صفحه اصلی','جدیدترین ها','همه']))
                    <li class="nav-item">
                        <a href="javascript:;" class="nav-link nav-toggle">
                            <i class="fa fa-windows"></i>
                            <span class="title">بنرهای صفحه اصلی</span>
                            <span class="arrow"></span>
                        </a>
                        <ul class="sub-menu" style="display: none;">
                            @if(Auth::user()->can(['مدیریت بنرها','بنرهای صفحه اصلی','جدیدترین ها','همه']))
                                <li class="nav-item  ">
                                    <a href="{{route('newestItems.index')}}" class="nav-link FarsiFont ">
                                        <span class="title">جدیدترین ها</span>
                                    </a>
                                </li>
                            @endif
                            @if(Auth::user()->can(['مدیریت بنرها','بنرهای صفحه اصلی','پرفروش ترین ها','همه']))
                                <li class="nav-item  ">
                                    <a href="{{route('bestSeller.index')}}" class="nav-link FarsiFont ">
                                        <span class="title">پرفروش ترین ها</span>
                                    </a>
                                </li>
                            @endif
                            @if(Auth::user()->can(['مدیریت بنرها','بنرهای صفحه اصلی','شبکه های اجتماعی','همه']))

                                <li class="nav-item  ">
                                    <a href="{{route('baners-social.index')}}" class="nav-link ">
                                        <span class="title">شبکه های اجتماعی</span>
                                    </a>
                                </li>
                            @endif
                            @if(Auth::user()->can(['مدیریت بنرها','بنرهای صفحه اصلی','سایر بنر ها','همه']))
                                <li class="nav-item  ">
                                    <a href="{{route('baners-home.index')}}" class="nav-link ">
                                        <span class="title">سایر بنر ها</span>
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </li>
                @endif
                @if(Auth::user()->can(['بنر وبلاگ','مدیریت بنرها','همه']))
                    <li class="nav-item  ">
                        <a href="{{route('blog_index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-list"></i>
                            <span class="title">بنر وبلاگ</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['بنرهای نوع کالا','مدیریت بنرها','همه']))
                    <li class="nav-item  ">
                        <a href="{{route('banners-stuffType.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-list"></i>
                            <span class="title">بنرهای نوع کالا</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['بنرهای دسته بندی','مدیریت بنرها','همه']))
                    <li class="nav-item  ">
                        <a href="{{route('banners-category.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-list"></i>
                            <span class="title">بنرهای دسته بندی</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif
    @if(Auth::user()->can(['مدیریت فیلترها','افزودن فیلتر دسته بندی','همه']))
        <li class="nav-item">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-check-square-o"></i>
                <span class="title"> مدیریت فیلترها</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                <li class="nav-item  ">
                    <a href="{{route('filterTitles.index')}}" class="nav-link FarsiFont ">
                        <i class="fa fa-filter"></i>
                        <span class="title">افزودن فیلتر دسته بندی</span>
                    </a>
                </li>
            </ul>
        </li>
    @endif

    @if(Auth::user()->can(['همه','مقالات','همه مقالات','ثبت مقاله جدید']))
        {{--Articles --}}
        <li class="nav-item ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-newspaper-o" aria-hidden="true"></i>
                <span class="title">مقالات</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['همه','مقالات','دسته بندی مقالات']))
                    <li class="nav-item  ">
                        <a href="{{route('articleCategory.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-files-o" aria-hidden="true"></i>
                            <span class="title">دسته بندی</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','مقالات','همه مقالات']))
                    <li class="nav-item  ">
                        <a href="{{route('article.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-files-o" aria-hidden="true"></i>
                            <span class="title">همه مقالات</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','مقالات','ثبت مقاله جدید']))
                    <li class="nav-item  ">
                        <a href="{{route('article.create')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-file-text-o" aria-hidden="true"></i>
                            <span class="title">ثبت مقاله جدید</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif
    @if(Auth::user()->can(['همه','صفحات','همه صفحات','ثبت صفحه جدید']))
        {{--Articles --}}
        <li class="nav-item ">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-file-text" aria-hidden="true"></i>
                <span class="title">صفحات</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['همه','صفحات','همه صفحات']))
                    <li class="nav-item  ">
                        <a href="{{route('page.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-files-o" aria-hidden="true"></i>
                            <span class="title">همه صفحات</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','صفحات','ثبت صفحه جدید']))
                    <li class="nav-item  ">
                        <a href="{{route('page.create')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-file-text-o" aria-hidden="true"></i>
                            <span class="title">ثبت صفحه جدید</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif
    @if(Auth::user()->can(['همه','مدیریت فایل ها']))
        {{--File manager --}}
        <li class="nav-item">
            <a href="{{route('filemanager')}}" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-folder-o"></i>
                <span class="title"> مدیریت فایل ها </span>
            </a>
        </li>
    @endif

    @if(Auth::user()->owner == 1 || Auth::user()->owner == 2)
        <li class="heading">
            <h3 class="uppercase">دسترسی ها</h3>
        </li>
        <li class="nav-item  @if(Request::is('Admin/*')) open @endif">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-lock"></i>
                <span class="title">مقام و اجازه دسترسی</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu"  @if(Request::is('Admin/*')) style="display: block" @endif>
                <li class="nav-item  ">
                    <a href="/Admin/permissions" class="nav-link FarsiFont">
                        <i class="fa fa-hand-paper-o"></i>
                        <span class="title">تعریف دسترسی ها</span>
                    </a>
                </li>
                <li class="nav-item  ">
                    <a href="/Admin/roles" class="nav-link FarsiFont ">
                        <i class="fa fa-rebel"></i>
                        <span class="title">تعریف مقام</span>
                    </a>
                </li>
                <li class="nav-item  ">
                    <a href="/Admin/users/level/create" class="nav-link FarsiFont ">
                        <i class="fa fa-users"></i>

                        <span class="title">ثبت مقام برای کاربران</span>
                    </a>
                </li>
                <li class="nav-item  ">
                    <a href="/Admin/users" class="nav-link FarsiFont ">
                        <i class="fa fa-users"></i>
                        <span class="title">همه کاربران</span>
                    </a>
                </li>
            </ul>
        </li>
        <li class="nav-item">
            <a href="{{route('admin.user.index')}}" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-user-plus"></i>
                <span class="title">ایجاد کاربر جدید</span>
            </a>
        </li>
    @endif
    <li class="heading">
        <h3 class="uppercase">تنظیمات سیستم</h3>
    </li>
    @if(Auth::user()->can(['همه','کدهای تخفیف']))
        <li class="nav-item">
            <a href="{{route('discountCode.show')}}" class="nav-link FarsiFont ">
                <i class="fa fa-percent"></i>
                <span class="title">کدهای تخفیف</span>
            </a>
        </li>

    @endif
    @if(Auth::user()->can(['همه','سوابق سیستم','سوابق بخش مدیریت','سوابق مرصولات','سوابق مبادلات بانکی']))
        <li class="nav-item">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-floppy-o"></i>
                <span class="title">سوابق سیستم</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                {{--@if(Auth::user()->can(['همه','سوابق سیستم','سوابق بخش مدیریت']))--}}
                {{--<li class="nav-item">--}}
                {{--<a href="#" class="nav-link FarsiFont ">--}}
                {{--<i class="fa fa-clock-o"></i>--}}
                {{--<span class="title">سوابق بخش مدیریت</span>--}}
                {{--</a>--}}
                {{--</li>--}}
                {{--@endif--}}

                @if(Auth::user()->can(['همه','سوابق سیستم','سوابق فروش']))
                    <li class="nav-item">
                        <a href="{{route('sellHistory')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-dollar"></i>
                            <span class="title">سوابق فروش</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','سوابق سیستم','سوابق مرصولات']))
                    <li class="nav-item">
                        <a href="{{route('postHistory')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-gift"></i>
                            <span class="title">سوابق مرصولات</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','سوابق سیستم','سوابق مبادلات بانکی']))
                    <li class="nav-item">
                        <a href="{{route('transactionHistory')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-dollar"></i>
                            <span class="title">سوابق مبادلات بانکی</span>
                        </a>
                    </li>
                @endif
            </ul>
        </li>
    @endif
    @if(Auth::user()->owner == 1 || Auth::user()->owner == 2)
        <li class="nav-item">
            <a href="{{route('sms-admin')}}" class="nav-link FarsiFont ">
                <i class="fa fa-envelope"></i>
                <span class="title">سوابق ارسال پیامک</span>
            </a>
        </li>
    @endif
    @if(Auth::user()->can(['همه','تنظیمات سایت','تنظیمات عمومی','تنظیمات شبکه های اجتماعی','تنظیمات لینکهای مفید','خدمات']))
        <li class="nav-item">
            <a href="javascript:;" class="nav-link nav-toggle FarsiFont ">
                <i class="fa fa-cogs"></i>
                <span class="title">تنظیمات سایت</span>
                <span class="arrow"></span>
            </a>
            <ul class="sub-menu">
                @if(Auth::user()->can(['همه','تنظیمات سایت','تنظیمات عمومی']))
                    <li class="nav-item">
                        <a href="{{route('setting_main.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-clock-o"></i>
                            <span class="title">تنظیمات عمومی</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','تنظیمات سایت','تنظیمات شبکه های اجتماعی']))
                    <li class="nav-item">
                        <a href="{{route('socials.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-envelope"></i>
                            <span class="title">تنظیمات شبکه های اجتماعی</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','تنظیمات سایت','تنظیمات لینکهای مفید']))
                    <li class="nav-item">
                        <a href="{{route('links.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-link"></i>
                            <span class="title">تنظیمات لینکهای مفید</span>
                        </a>
                    </li>
                @endif
                @if(Auth::user()->can(['همه','تنظیمات سایت','لوگو همکاران']))

                    <li class="nav-item">
                        <a href="{{route('service.index')}}" class="nav-link FarsiFont ">
                            <i class="fa fa-gift"></i>
                            <span class="title">لوگو همکاران</span>
                        </a>
                    </li>
                @endif

            </ul>
        </li>
        @if(Auth::user()->owner == 2)
            <li class="heading">
                <h3 class="uppercase">آرتیزن ها</h3>
            </li>
            {{--<li class="nav-item">--}}
            {{--<a href="{{route('make.search.brand.index')}}" class="nav-link FarsiFont ">--}}
            {{--<i class="fa fa-gears"></i>--}}
            {{--<span class="title">ایندکس برند کالا</span>--}}
            {{--</a>--}}
            {{--</li>--}}
            {{--<li class="nav-item">--}}
            {{--<a href="{{route('make.search.category.index')}}" class="nav-link FarsiFont ">--}}
            {{--<i class="fa fa-gears"></i>--}}
            {{--<span class="title">ایندکس دسته بندی کالا</span>--}}
            {{--</a>--}}
            {{--</li>--}}
            <li class="nav-item">
                <a href="{{route('make.search.product.index')}}" class="nav-link FarsiFont ">
                    <i class="fa fa-gears"></i>
                    <span class="title">ایندکس کالا</span>
                </a>
            </li>
            {{--<li class="nav-item">--}}
            {{--<a href="{{route('storageLink')}}" class="nav-link FarsiFont ">--}}
            {{--<i class="fa fa-gears"></i>--}}
            {{--<span class="title">storage link</span>--}}
            {{--</a>--}}
            {{--</li>--}}
        @endif
    @endif
@stop