@extends('/CRM/layout')
@section('head')
    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <!-- END PAGE LEVEL PLUGINS -->
    {{--Data TimePiker--}}
    <link rel="stylesheet"
          href="/CRM_Assets/assets/global/plugins/PersianDateTimePicker/Content/bootstrap-theme.min.css"/>
    <style>
        a.title:link, a.title:visited {
            padding: 1px 6px 1px 6px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
        }

        a.title:hover, a.title:active {
            color: #ED6B75;
            text-decoration: none;
        }

        .popover {
            z-index: 90000 !important;
            max-width: 290px;
            font-family: IRANSANS;
        }

        .popover-title {
            font-family: IRANSANS;
        }


    </style>
@endsection
@section('content')
    <div class="page-header head-section">

        <h3 style="text-align: center">
                <i class="fa fa-gift" style="color:#ff4f4f"></i>
            سوابق  <span class="title bold" style="color:#ff4f4f">مرصولات </span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت مرصولات</h3>
        </div>
        <div class="panel-body">
            <div id="table">
                <table class="table table-striped table-bordered table-hover order-column dataTable no-footer" id="sample_1" role="grid" aria-describedby="sample_1_info" >
                    <thead>
                    <tr role="row">
                        <th class="sorting_disable text-center"  aria-label="" style="width:20.883px!important;"><i class="fa fa-eye"></i> </th>
                        <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"  colspan="1"  aria-sort="descending" > شناسه </th>
                        <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1" colspan="1" >شناسه سفارش</th>
                        <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1" colspan="1" >نوع</th>
                        <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1" colspan="1" >کد مرصوله</th>
                        <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1"  colspan="1"> مبلغ </th>
                        <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1"  colspan="1"> زمان </th>
                    </tr>
                    </thead>
                    <tbody>
                    @isset($posts)
                        @foreach($posts as $post)
                            <tr role="row">
                                <td>
                                    <a class="btn btn-sm btn-primary view-order2" data-toggle="modal" data-target="#myModalEye" data-content="{{$post->Payment->id}}" data-title="{{$post->Payment->status}}" title="مشاهده"><i class="fa fa-eye"></i> </a>
                                </td>
                                <td class="text-center">{{$post->id}}</td>
                                <td class="text-center">{{$post->Payment->id}}</td>
                                <td class="text-center">
                                    <span style="display: none">{{$post->type}}</span>
                                    @if($post->type == 0)
                                        <i class="fa fa-gift" title="ارسال پستی" style="cursor: pointer"></i>
                                        <hr>پستی
                                    @else
                                        <i class="fa fa-motorcycle" title="ارسال با پیک" style="cursor: pointer"></i>
                                        <hr>پیک
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($post->type == 0)
                                        {{$post->post_code}}
                                    @else
                                        --
                                    @endif
                                </td>
                                <td class="text-center">
                                        {{priceFormat($post->price)}} تومان
                                </td>
                                <td class="text-center" style="direction: ltr">
                                    {{convert($jdate->forge(strtotime($post->created_at))->format('Y/m/d - H:i:s')) }} <hr>{{convert($jdate->forge(strtotime($post->created_at))->format('l')) }} - {{persianDiffForHumans($post->created_at) }}
                                </td>
                            </tr>
                        @endforeach
                    @endisset
                    </tbody>
                </table>

            </div>
        </div>
    </div>
    <!-- Add Modal for eye -->
    <div class="modal fade" id="myModalEye" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div id="modal-container">

                </div>
            </div>
        </div>
    </div>

@endsection
@section('script')

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->

    <script src="/jq-confirm/jquery-confirm.min.js"></script>
@endsection
@section('footer')
    <script>
        $(document).on('click', ".view-order2", function () {
            var id = $(this).attr('data-content');
            var mode = $(this).attr('data-title');
            $.ajax({
                url: "{{route('order.view2')}}",
                type: "GET",
                data: {id: id,mode : mode},
                success: function (data) {

                    $("#modal-container").html(data);
                },
                error: function () {
                    swal({
                        title: "خطا",
                        text: " با خطا مواجه شد",
                        type: "error",
                        timer: 1500
                    });

                }
            });

        });
    </script>
@endsection