<div class="portlet-title tabbable-line">
    <div class="caption">
        <i class="icon-bubbles font-dark hide"></i>
        <span class="caption-subject font-dark bold uppercase"> <i class="fa fa-shopping-cart"></i> سبدهای خرید</span>
        <a href="{{route('carts.pending.index')}}"><span class="caption-subject font-red" style="font-size: 9pt;">(نمایش همه)</span></a>
    </div>
    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#portlet_comments_1111" data-toggle="tab"><i class="fa fa-dot-circle-o"></i> در انتظار تایید </a>
        </li>
        <li>
            <a href="#portlet_comments_2222" data-toggle="tab"><i class="fa fa-check-square-o"></i> تایید شده </a>
        </li>
    </ul>
</div>
<div class="portlet-body" style="height: 533px;overflow-y: scroll;">
    <div class="tab-content">
        <div class="tab-pane active" id="portlet_comments_1111">
            <!-- BEGIN: Comments -->
            @foreach($pendingCarts as $pendingCart)
                @php $payment = $pendingCart->Payment()->first() @endphp
                <div class="mt-comments">
                    <div class="mt-comment">
                        <div class="mt-comment-img">
                            <img src="/CRM_Assets/assets/layouts/layout/img/online_order_icon.png">
                        </div>
                        <div class="mt-comment-body">
                            <div class="mt-comment-info">
                                <span class="mt-comment-author"></span>
                                <span class="mt-comment-date"></span>
                            </div>
                            <div class="mt-comment-text" style="line-height: 1.7">
                                <span>کاربر :  </span>
                                <b>{{$pendingCart->User->fname}} {{$pendingCart->User->lname}} - ({{$pendingCart->User->mobile}})</b>
                                <br>
                                <span>سبد خرید شماره :  </span>
                                <b>{{$pendingCart->id}}</b>
                                <span> / </span>
                                <span>شناسه سفارش : </span>
                                <b>{{$payment->id}}</b>
                                <br>
                                <span>بهای تمام شده سبد خرید : </span>
                                <b>{{priceFormat($payment->package_price)}}</b>
                                <span>تومان</span>
                                <span> / </span>
                                <span>هزینه پستی خرید : </span>
                                <b>{{priceFormat($payment->shipment_price)}}</b>
                                <span>تومان</span>
                                <span> / </span>
                                <span>کل : </span>
                                <b>{{priceFormat($payment->total)}}</b>
                                <span>تومان</span>
                                <span> / </span>
                                <span>کد تخفیف : </span>
                                @if(!is_null($payment->discount_code_id))
                                    <b> شناسه {{$payment->discount_code_id}}</b>
                                    <span> / </span>
                                    <span>میزان تخفیف : </span>
                                    <b>{{priceFormat($payment->discount)}}</b>
                                    <span>تومان</span>
                                @else
                                    <b>ندارد</b>
                                @endif
                                <br>
                                <span>مبلغ قابل پرداخت : </span>
                                <b>{{priceFormat($payment->payable_price)}}</b>
                                <span>تومان</span>
                                <br>
                                <br>
                                <span>کالاهای این سفارش : </span>
                                <br>
                                <ul>
                                    @foreach($pendingCart->CartProduct()->get() as $cart_product)
                                        <li>
                                            <b>{{$cart_product->qty}}</b>
                                            <i class="fa fa-times"></i>
                                            <b>{{$cart_product->ProductColor->Product->name}}</b>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                            <div class="mt-comment-details">
                                <div class="mt-comment-status mt-comment-status-pending">
                                    <div class="mt-action-buttons ">
                                        <div class="btn-group btn-group-circle">
                                            <button type="button" data-content="{{$pendingCart->id}}" class="btn btn-outline green btn-sm approve-cart" style="border-radius: 25px 25px 0 25px !important;">تایید سبد</button>
                                        </div>
                                    </div>
                                </div>
                                <ul class="mt-comment-actions">
                                    <li>
                                        <a class="view-order" data-toggle="modal" data-target="#myModalEye" data-content="{{$payment->id}}" data-title="{{$payment->status}}" style="color: #0f0f0f"><button >مشاهده سبد</button></a>
                                    </li>
                                    <li>
                                        <a href="" style="color: #0f0f0f"><button >ویرایش</button></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
        @endforeach
        <!-- END: Comments -->
        </div>
        <div class="tab-pane" id="portlet_comments_2222">
            <!-- BEGIN: Comments -->
            <div class="mt-comments">
                @foreach($confirmedCarts as $confirmedCart)
                    @php $payment = $confirmedCart->Payment()->first() @endphp
                    <div class="mt-comments">
                        <div class="mt-comment">
                            <div class="mt-comment-img">
                                <img src="/CRM_Assets/assets/layouts/layout/img/online_order_icon.png">
                            </div>
                            <div class="mt-comment-body">
                                <div class="mt-comment-info">
                                    <span class="mt-comment-author"></span>
                                    <span class="mt-comment-date"></span>
                                </div>
                                <div class="mt-comment-text" style="line-height: 1.7">
                                    <span>کاربر :  </span>
                                    <b>{{$confirmedCart->User->fname}} {{$confirmedCart->User->lname}} - ({{$confirmedCart->User->mobile}})</b>
                                    <br>
                                    <span>سبد خرید شماره :  </span>
                                    <b>{{$confirmedCart->id}}</b>
                                    <span> / </span>
                                    <span>شناسه سفارش : </span>
                                    <b>{{$payment->id}}</b>
                                    <br>
                                    <span>بهای تمام شده سبد خرید : </span>
                                    <b>{{priceFormat($payment->package_price)}}</b>
                                    <span>تومان</span>
                                    <span> / </span>
                                    <span>هزینه پستی خرید : </span>
                                    <b>{{priceFormat($payment->shipment_price)}}</b>
                                    <span>تومان</span>
                                    <span> / </span>
                                    <span>کل : </span>
                                    <b>{{priceFormat($payment->total)}}</b>
                                    <span>تومان</span>
                                    <span> / </span>
                                    <span>کد تخفیف : </span>
                                    @if(!is_null($payment->discount_code_id))
                                        <b> شناسه {{$payment->discount_code_id}}</b>
                                        <span> / </span>
                                        <span>میزان تخفیف : </span>
                                        <b>{{priceFormat($payment->discount)}}</b>
                                        <span>تومان</span>
                                    @else
                                        <b>ندارد</b>
                                    @endif
                                    <br>
                                    <span>مبلغ قابل پرداخت : </span>
                                    <b>{{priceFormat($payment->payable_price)}}</b>
                                    <span>تومان</span>
                                    <br>
                                    <br>
                                    <span>کالاهای این سفارش : </span>
                                    <br>
                                    <ul>
                                        @foreach($confirmedCart->CartProduct()->get() as $cart_product)
                                            <li>
                                                <b>{{$cart_product->qty}}</b>
                                                <i class="fa fa-times"></i>
                                                <b>{{$cart_product->ProductColor->Product->name}}</b>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                                <div class="mt-comment-details">
                                    @if($confirmedCart->paid == 0)
                                    <div class="mt-comment-status mt-comment-status-pending">
                                        <div class="mt-action-buttons ">
                                            <div class="btn-group btn-group-circle">
                                                <button type="button" data-content="{{$confirmedCart->id}}" class="btn btn-outline red btn-sm pending-cart" style="border-radius: 25px 25px 0 25px !important;">تعلیق سبد</button>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    <ul class="mt-comment-actions">
                                        <li>
                                            <a class="view-order" data-toggle="modal" data-target="#myModalEye" data-content="{{$payment->id}}" data-title="{{$payment->status}}" style="color: #0f0f0f"><button >مشاهده سبد</button></a>
                                        </li>
                                        <li>
                                            <a href="" style="color: #0f0f0f"><button >ویرایش</button></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <!-- END: Comments -->
        </div>
    </div>
</div>