@extends('/CRM/layout')
@section('head')

    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css" rel="stylesheet" type="text/css"/>
@endsection
@section('content')
    <div class="page-header head-section">
        <div class="btn-group" >
            <a href="{{route('charts.index')}}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span><strong> بازگشت </strong> </a>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-bar-chart-o"></i>
            جزئیات آمار <span class="title bold" style="color:#ff4f4f">تعداد جست و جو</span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;</h3>
        </div>
        <div class="panel-body">
            <div id="table">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover table-checkable order-column" id="sample_1">
                                    <thead>
                                    <tr>
                                        <th>
                                            <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                                <input class="group-checkable" data-set="#sample_1 .checkboxes" type="checkbox">
                                                <span></span>
                                            </label>
                                        </th>
                                        <th class="text-center"> عبارت جست و جو </th>
                                        <th class="text-center"> تعداد </th>
                                        <th class="text-center"> اولین جست و جو </th>
                                        <th class="text-center"> آخرین جست و جو </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @isset($records)
                                        @foreach($records as $record)
                                            <tr>
                                                <td>
                                                    <label class="mt-checkbox mt-checkbox-single mt-checkbox-outline">
                                                        <input class="checkboxes" value="1" type="checkbox">
                                                        <span></span>
                                                    </label>
                                                </td>
                                                <td class="text-center"> {{$record->query}} </td>
                                                <td class="text-center">
                                                    {{$record->count}}
                                                </td>
                                                <td class="text-center" >
                                                    {{$jdate->forge(strtotime($record->created_at))->format('Y/m/d')}}
                                                </td>
                                                <td class="text-center" >
                                                    {{$jdate->forge(strtotime($record->updated_at))->format('Y/m/d')}}
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endisset
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')

    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" ></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" ></script>
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" ></script>

@endsection
@section('footer')

@endsection