@extends('/CRM/layout')
@section('head')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <!-- END PAGE LEVEL PLUGINS -->

    <style>
        a.title:link, a.title:visited {
            padding: 1px 6px 1px 6px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
        }

        a.title:hover, a.title:active {
            color: #ED6B75;
            text-decoration: none;
        }

        .popover {
            z-index: 90000 !important;
            max-width: 290px;
            font-family: IRANSANS;
        }

        .popover-title {
            font-family: IRANSANS;
        }


    </style>
@endsection
@section('content')
    <div class="page-header head-section">
        <div class="btn-group" >
            <a href="{{route('charts.index')}}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span><strong> بازگشت </strong> </a>
        </div>
        <h3 style="text-align: center">
            <i class="fa fa-dot-circle-o"></i>
            آمار <span class="title bold" style="color:#ff4f4f">کالا</span>
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;</h3>
        </div>
        <div class="panel-body">
            <table class="table table-striped table-bordered table-hover order-column dataTable no-footer" id="sample_1" role="grid" aria-describedby="sample_1_info" >
                <thead>
                <tr role="row">
                    <th class="text-center"> کد </th>
                    <th class="text-center"> نام </th>
                    <th class="text-center"> تعداد فروش </th>
                    <th class="text-center"> تعداد بازدید </th>
                </tr>
                </thead>
                <tbody>
                @isset($records)
                    @foreach($records as $record)
                        <tr role="row">
                            <td class="text-center">{{$record->code}}</td>
                            <td class="text-center"><a href="{{$record->dashboardPath()}}">{{$record->name}}</a></td>
                            <td class="text-center">{{$record->sold_count}}</td>
                            <td class="text-center">{{$record->view_count}}</td>
                        </tr>
                    @endforeach
                @endisset
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('script')

    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->

@endsection
