<script>

    var data = JSON.parse('{!! $data !!}');
    var categories = JSON.parse('{!! $categories !!}');

    Highcharts.chart('{{$chart_id}}', {
        chart: {
            type: 'area'
        },
        title: {
            text: '{{$chart_title}}'
        },
        subtitle: {
            text: '{{$chart_sub_title}}'
        },
        xAxis: {
            categories: categories,
            tickmarkPlacement: 'on',
            title: {
                enabled: false
            }
        },
        yAxis: {
            title: {
                text: 'Percent'
            }
        },
        tooltip: {
            pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.percentage:.1f}%</b> ({point.y:,.0f} millions)<br/>',
            split: true
        },
        plotOptions: {
            area: {
                stacking: 'percent',
                lineColor: '#ffffff',
                lineWidth: 1,
                marker: {
                    lineWidth: 1,
                    lineColor: '#ffffff'
                }
            }
        },
        series: data
    });
</script>