<script>

    var data = JSON.parse('{!! $data !!}');
    var categories = JSON.parse('{!! $categories !!}');

    Highcharts.chart('{{$chart_id}}', {
        chart: {
            type: 'column'
        },
        title: {
            text: '{{$chart_title}}'
        },
        subtitle: {
            text: '{{$chart_sub_title}}'
        },
        xAxis: {
            categories: categories,
            crosshair: true
        },
        yAxis: {
            min: 0,
            title: {
                text: '{{$yAxisTitle}}'
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            '<td style="padding:0"><b> {{$unit}} </b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        series: data
    });
</script>