@extends('/CRM/layout')

@section('head')
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet">
@endsection

@section('content')
    <div class="portlet light bordered main">
        <div class="btn-group" >
            <a href="{{ url('/CRM/SiteFront/dynamicSubMenu/'.$subMenuTitle->DynamicSubMenu->id) }}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت</a>
        </div>
        <div class="page-header head-section">
            <h3>ویرایش زیر عنوان {{ $subTitle->sub_title }}</h3>
        </div>
        <br>
        <form class="form-horizontal" action="{{ route('subTitle.update',[$subMenuTitle,$subTitle]) }}" method="post" enctype="multipart/form-data">
            {{ csrf_field() }}
            {{method_field('PATCH')}}
            @include('CRM.SiteFront.section.errors')
            <input name="title_type" value="{{$subTitle->title_type}}" hidden>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="title" class="control-label" style="margin-bottom: 10px;">زیر عنوان برای نمایش</label>
                    <br>
                    <input type="text" class="form-control" name="sub_title" id="sub_title" placeholder="زیر عنوان را وارد کنید" value="{{ old('sub_title',$subTitle->sub_title) }}" required>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="title_id" class="control-label" style="margin-bottom: 10px;">عنوان مربوطه</label>
                    <br>
                    <select class="form-control select2me" id="title_id" name="title_id" data-placeholder="انتخاب کنید..." required>
                        <option>انتخاب کنید...</option>
                        @foreach($subMenuTitles as $title)
                            <option value="{{$title->id}}"
                                    @if(old('subMenuTitle_id',$subMenuTitle->id) == $title->id)
                                    selected
                                    @endif
                            >{{$title->title}} ({{$title->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="title" class="control-label" style="margin-bottom: 10px;">URL</label>
                    <br>
                    <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-link"></i>
                            </span>
                        <input name="url" type="url" value="{{old('url',$subTitle->url)}}" class="form-control"  placeholder="آدرس URL مورد نظر را وارد کنید" required>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="priority" class="control-label" style="margin-bottom: 10px;">ترتیب</label>
                    <br>
                    <input type="text" class="form-control" name="priority" id="priority" value="{{ old('priority',$subTitle->priority) }}" required>
                </div>
            </div>
            <br>
            <div class="form-group">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-danger" style="width: 105px;">ویرایش</button>
                </div>
            </div>
        </form>
    </div>
@endsection

@section('footer')
    <script>
        $(document).on('change', '#category_id_tec', function () {
            var cat_id = $(this).val();

            $.ajax({
                url     : "{{route('get.tec.keys')}}",
                type    :"get",
                cash    : false,
                data    :{ cat_id : cat_id},
                success: function(response) {
                    $("#tec_code").empty().append($("<option value=\"\">انتخاب کنید...</option>"));
                    $.each( response, function(key,value) {
                        $('#tec_code')
                            .append($("<option>"+ (key+1) +"- "+value.tec_info_key +" ("+ value.code +")</option>")
                                .attr({
                                    value:value.code
                                }));
                    });
                }
            });
        });
        $(document).on('change', '#tec_code', function () {
            var tec_code = $(this).val();
            $.ajax({
                url     : "{{route('get.tec.values')}}",
                type    :"get",
                cash    : false,
                data    :{ tec_code : tec_code},
                success: function(response) {
                    $("#tec_id").empty().append($("<option value=\"\">انتخاب کنید...</option>"));
                    $.each( response, function(key,value) {
                        $('#tec_id')
                            .append($("<option>"+ (key+1) +"- "+value.value +" ("+ value.tec_id +")</option>")
                                .attr({
                                    value:value.tec_id
                                }));
                    });
                }
            });
        });
    </script>
@endsection

@section('script')
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection