@extends('/CRM/layout')

@section('head')
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet">
@endsection
@section('content')
    <div class="portlet light bordered main">
        <div class="btn-group" >
            <a href="{{ url('/CRM/SiteFront/dynamicSubMenu/'.$subMenuTitle->DynamicSubMenu->id) }}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت</a>
        </div>
        <div class="page-header head-section">
            <h3>ویرایش زیر عنوان {{ $subTitle->sub_title }}</h3>
        </div>
        <br>
        <form class="form-horizontal" action="{{ route('subTitle.update',[$subMenuTitle,$subTitle]) }}" method="post" enctype="multipart/form-data">
            {{ csrf_field() }}
            {{method_field('PATCH')}}
            @include('CRM.SiteFront.section.errors')
            <input name="title_type" value="{{$subTitle->title_type}}" hidden>

            <div class="form-group">
                <div class="col-md-6">
                    <label for="title_id" class="control-label" style="margin-bottom: 10px;">عنوان مربوطه</label>
                    <br>
                    <select class="form-control select2me" id="title_id" name="title_id" data-placeholder="انتخاب کنید..." >
                        <option>انتخاب کنید...</option>
                        @foreach($subMenuTitles as $title)
                            <option value="{{$title->id}}"
                                    @if( $subMenuTitle->id == $title->id or old('subMenuTitle_id') == $title->id)
                                    selected
                                    @endif
                            >{{$loop->iteration}} -  {{$title->title}} ({{$title->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="title" class="control-label" style="margin-bottom: 10px;">زیر عنوان برای نمایش</label>
                    <br>
                    <input type="text" class="form-control" name="sub_title" id="sub_title" placeholder="زیر عنوان را وارد کنید" value="{{ $subTitle->sub_title or old('sub_title') }}">
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="category_id" class="control-label" style="margin-bottom: 10px;">دسته بندی مربوطه</label>
                    <br>
                    <select  class="form-control select2me"  name="category_id" id="category_id">
                        <option>انتخاب کنید...</option>
                        @foreach($categories as $category)
                            <option value="{{$category->id}}"
                                    @if($subTitle->category_id == $category->id or old('category_id') == $category->id)
                                    selected
                                    @endif
                            >{{$loop->iteration}} -  {{$category->category}} ({{$category->id}})</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-6">
                    <label for="priority" class="control-label" style="margin-bottom: 10px;">ترتیب</label>
                    <br>
                    <input type="text" class="form-control" name="priority" id="priority" value="{{ $subTitle->priority or old('priority') }}">
                </div>
            </div>
            <br>
            <div class="form-group">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-danger" style="width: 105px;">ویرایش</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('script')
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection