@extends('/CRM/layout')
@section('head')
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
    <style>
        /* For Firefox */
        input[type='number'] {
            -moz-appearance: textfield;
        }

        /* Webkit browsers like Safari and Chrome */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
    </style>
@endsection
@section('content')
    <div class="portlet light bordered main col-lg-12">
        <div class="col-lg-12">
            <div class="page-header head-section">
                <div class="btn-group" >
                    <a href="{{ URL('/CRM/SiteFront/dynamicSubMenu/'.$dynamicSubMenu->id) }}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت</a>
                </div>
                <h3>ایجاد عنوان</h3>
            </div>
        </div>
        <br>
        <div class="col-md-6">
            <div class="panel-title col-md-12 ">
                <span class="font-red-haze"> بر اساس دسته بندی</span>
            </div>
            <div class="col-md-12">
                <form class="form-horizontal" action="{{ route('subMenuSetting.save') }}" method="post" >
                    {{ csrf_field() }}
                    @include('CRM.SiteFront.section.errors')
                    <div class="form-group">
                        <div class="col-md-10">
                            <label for="title" class="control-label" style="margin-bottom: 10px;">عنوان برای نمایش</label>
                            <br>
                            <input type="text" class="form-control" name="title" id="title" placeholder="عنوان را وارد کنید" value="{{ old('title') }}">
                        </div>
                    </div>
                    <div class="form-group" >
                        <div class="col-md-10">
                            <label for="category_id" class="control-label" style="margin-bottom: 10px;">زیر منو مربوطه</label>
                            <br>
                            <select  class="form-control select2me" name="subMenu_id" id="subMenu_id">
                                @foreach($dynamicSubMenus as $subMenu)
                                    <option value="{{$subMenu->id}}"
                                            @if(old('subMenu_id',$subMenu->id) == $dynamicSubMenu->id)
                                            selected
                                            @endif
                                    >{{$subMenu->name}} ({{$subMenu->id}})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-10">
                            <label for="category_id" class="control-label" style="margin-bottom: 10px;">دسته بندی مربوطه</label>
                            <br>
                            <select  class="form-control select2me" name="category_id" id="category_id">
                                @foreach($categories as $category)
                                    <option value="{{$category->id}}"
                                            @if(old('category_id') == $category->id)
                                            selected
                                            @endif
                                    >{{$category->category}} ({{$category->id}})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-10">
                            <label for="priority" class="control-label" style="margin-bottom: 10px;">ترتیب</label>
                            <br>
                            <input type="number" class="form-control" name="priority" id="priority" value="{{old('priority',1) }}">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-10">
                            <label for="type" class="control-label" style="margin-bottom: 10px;">نوع نمایش</label>
                            <br>
                            <div>
                                <input type="radio" name="type" value="0" style="margin-right: 50px;" @if(old('type') == 0) checked @elseif(old('type') == 1) @else checked @endif>&nbsp;صفحه جست و جو
                                <input type="radio" name="type" value="1" style="margin-right: 30px;" @if(old('type') == 1) checked @endif>&nbsp;صفحه اصلی دسته بندی
                            </div>
                        </div>
                    </div>

                    <br>
                    <div class="form-group">
                        <div class="col-sm-12">
                            <button type="submit" class="btn btn-danger" style="width: 105px;">ثبت</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-6">
            <div class="panel-title col-md-12 ">
                <span class="font-red-haze"> بر اساس URL</span>
            </div>
            <div class="col-md-12">
                <form class="form-horizontal" action="{{ route('subMenuSetting.save') }}" method="post">
                    {{ csrf_field() }}
                    @include('CRM.SiteFront.section.errors')
                    <div class="form-group">
                        <div class="col-md-10">
                            <label for="title" class="control-label" style="margin-bottom: 10px;">عنوان برای نمایش</label>
                            <br>
                            <input type="text" class="form-control" name="title" id="title" placeholder="عنوان را وارد کنید" value="{{ old('title') }}">
                        </div>
                    </div>
                    <div class="form-group" >
                        <div class="col-md-10">
                            <label for="category_id" class="control-label" style="margin-bottom: 10px;">زیر منو مربوطه</label>
                            <br>
                            <select  class="form-control select2me" name="subMenu_id" id="subMenu_id">
                                @foreach($dynamicSubMenus as $subMenu)
                                    <option value="{{$subMenu->id}}"
                                            @if(old('subMenu_id',$dynamicSubMenu->id) == $subMenu->id)
                                            selected
                                            @endif
                                    >{{$subMenu->name}} ({{$subMenu->id}})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-10">
                            <label class="control-label" style="margin-bottom: 10px;">URL</label>
                            <br>
                            <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-link"></i>
                            </span>
                                <input name="url" type="url" value="{{old('url')}}" class="form-control"  placeholder="آدرس URL مورد نظر را وارد کنید" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-10">
                            <label for="priority" class="control-label" style="margin-bottom: 10px;">ترتیب</label>
                            <br>
                            <input type="number" class="form-control" name="priority" id="priority" value="{{ 1 or old('priority') }}">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-10">
                            <label for="type" class="control-label" style="margin-bottom: 10px;">نوع نمایش</label>
                            <br>
                            <div>
                                <input type="radio" name="type" value="2" style="margin-right: 50px;" checked>&nbsp;بر اساس URL
                            </div>
                        </div>
                    </div>

                    <br>
                    <div class="form-group">
                        <div class="col-sm-12">
                            <button type="submit" class="btn btn-danger" style="width: 105px;">ثبت</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>
@endsection

@section('footer')
    <script>
        $(document).ready(function() {
            $(':input[type="number"]').keydown(function (e) {
                // Allow: backspace, delete, tab, escape, enter and .
                if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
                    // Allow: Ctrl/cmd+A
                    (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: Ctrl/cmd+C
                    (e.keyCode == 67 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: Ctrl/cmd+X
                    (e.keyCode == 88 && (e.ctrlKey === true || e.metaKey === true)) ||
                    // Allow: home, end, left, right
                    (e.keyCode >= 35 && e.keyCode <= 39)) {
                    // let it happen, don't do anything
                    return;
                }
                // Ensure that it is a number and stop the keypress
                if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                    e.preventDefault();
                }
            });
        });
    </script>
@endsection