@extends('/CRM/layout')

@section('head')

    <link rel="stylesheet" href="/jq-confirm/jquery-confirm.min.css">
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet"
          type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css" rel="stylesheet" type="text/css"/>

    <style>
        /* For Firefox */
        input[type='number'] {
            -moz-appearance: textfield;
        }

        /* Webkit browsers like Safari and Chrome */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
    </style>
@endsection
@section('content')
    <div class="page-header head-section">
        <div class="btn-group" >
            <a href="{{ url('/CRM/SiteFront/dynamicMenu/'.$dynamicSubMenu->DynamicMenu->id) }}" class="previous-a round-a"><span class="glyphicon glyphicon-arrow-left"></span> بازگشت</a>
        </div>
        <div class="btn-group"  style="float: left">
            <a href="{{ url('/CRM/SiteFront/subMenuSetting/create/' .$dynamicSubMenu->id) }}" class="btn btn-sm btn-success" >ایجاد عنوان</a>
            <a class="btn btn-sm btn-primary" data-toggle="modal" data-target="#myModal" data-original-title="جدید" style="margin-left: 19px;"> ایجاد زیر عنوان </a>
        </div>
        <h3 style="text-align: center"><i class="fa fa-list" aria-hidden="true"></i> عنوان و زیرعنوان "<a href="{{ url('/CRM/SiteFront/dynamicMenu/'.$dynamicSubMenu->DynamicMenu()->first()->id) }}" class="title bold">
                {{$dynamicSubMenu->name}}</a>"
        </h3>
    </div>
    <div id="alerts">
        @include('errors.formAlert')
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت عنوان ها</h3>
        </div>
        <div class="panel-body">
            @include('CRM.SiteFront.subMenuSetting.settingTablesInclude')
        </div>
    </div>



@endsection
@section('modal')
    <!-- Add Modal -->
    <div class="modal fade" id="myModal"  role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" style="z-index: 100;width: 600px;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel">یکی از موارد را برای نشان دادن در عنوان انتخاب کنید</h4>
                </div>
                <div class="modal-body">
                    <div class="tabbable"> <!-- Only required for left/right tabs -->
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#tab11" data-toggle="tab">بر اساس برند</a></li>
                            <li><a href="#tab22" data-toggle="tab">بر اساس دسته بندی</a></li>
                            <li><a href="#tab33" data-toggle="tab">بر اساس مشخصات فنی</a></li>
                            <li><a href="#tab44" data-toggle="tab">بر اساس URL</a></li>
                        </ul>
                            {{--
                             * brand    => 1
                             * category => 2
                             * tecinfo  => 3
                             * url      => 4
                             --}}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab11">
                                <form class="form-horizontal" action="{{route('store.subTitle')}}" role="form" method="POST" >
                                    <br>
                                    {{csrf_field()}}
                                    <input name="title_type" value="1" hidden>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">نام زیر عنوان</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="sub_title" value="{{old('sub_title')}}" placeholder="نام زیر عنوان مورد نظر خود را وارد کنید" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">عنوان مربوطه</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2me" name="title_id" data-placeholder="انتخاب کنید..." required>
                                                <option value="">انتخاب کنید...</option>
                                               @foreach($form_titles as $title)
                                                    <option value="{{$title->id }}" @if(old('title_id') == $title->id) selected @endif>  {{ $title->title }} ({{ $title->id }})</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">دسته بندی </label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2me" id="category_id" name="category_id" data-placeholder="انتخاب کنید..." >
                                                <option value="">انتخاب کنید...</option>

                                                @foreach($categories as $category)
                                                    <option value="{{ $category->id }}" @if(old('category_id') == $category->id) selected @endif> {{ $category->category }} ({{ $category->id }})</option>

                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">برند </label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2me" name="brand_id" data-placeholder="انتخاب کنید..." required>
                                                <option value="">انتخاب کنید...</option>
                                                @foreach($brands as $brand)
                                                    <option value="{{ $brand->id }}" @if(old('brand_id') == $brand->id) selected @endif> {{ $brand->brandName }} ({{ $brand->id }})</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">ترتیب</label>
                                        <div class="col-sm-9" >
                                            <input type="text" class="form-control" name="priority" placeholder="ترتیب" value="{{old('priority')}}" required>
                                        </div>
                                    </div>
                                    <div class="modal-footer" style="text-align: center;">
                                        <button type="submit" class="btn btn-primary" style="width: 50%;">ثبت</button>
                                    </div>
                                </form>
                            </div>

                            <div class="tab-pane" id="tab22">
                                <form class="form-horizontal" action="{{route('store.subTitle')}}" role="form" method="POST" >
                                    <br>
                                    {{csrf_field()}}
                                    <input name="title_type" value="2" hidden>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">نام زیر عنوان</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="sub_title" value="{{old('sub_title')}}" placeholder="نام زیر عنوان مورد نظر خود را وارد کنید" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">عنوان مربوطه</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2me" name="title_id" data-placeholder="انتخاب کنید..." required>
                                                <option value="">انتخاب کنید...</option>
                                                @foreach($form_titles as $title)
                                                    <option value="{{$title->id }}" @if(old('title_id') == $title->id) selected @endif>  {{ $title->title }} ({{ $title->id }})</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">دسته بندی </label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2me" id="category_id" name="category_id" data-placeholder="انتخاب کنید..." >
                                                <option value="">انتخاب کنید...</option>
                                                
                                                @foreach($categories as $category)
                                                    <option value="{{ $category->id }}" @if(old('category_id') == $category->id) selected @endif> {{ $category->category }} ({{ $category->id }})</option>
                                                    
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">ترتیب</label>
                                        <div class="col-sm-9" >
                                            <input type="text" class="form-control" name="priority" placeholder="ترتیب" value="{{old('priority')}}" required>
                                        </div>
                                    </div>
                                    <div class="modal-footer" style="text-align: center;">
                                        <button type="submit" class="btn btn-primary" style="width: 50%;">ثبت</button>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane" id="tab33">
                                <form class="form-horizontal" action="{{route('store.subTitle')}}" role="form" method="POST" >
                                    {{csrf_field()}}
                                    <input name="title_type" value="3" hidden>

                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">نام زیر عنوان</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="sub_title" value="{{old('sub_title')}}" placeholder="نام زیر عنوان مورد نظر خود را وارد کنید" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">عنوان مربوطه</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2me" name="title_id" data-placeholder="انتخاب کنید..." required>
                                                <option value="">انتخاب کنید...</option>
                                                @foreach($form_titles as $title)
                                                    <option value="{{$title->id }}" @if(old('title_id') == $title->id) selected @endif>  {{ $title->title }} ({{ $title->id }})</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">دسته بندی </label>
                                        <div class="col-sm-9">
                                            <select class="form-control " id="category_id_tec" name="category_id" data-placeholder="انتخاب کنید..." >
                                                <option value="">انتخاب کنید...</option>

                                                @foreach($categories as $category)
                                                    <option value="{{ $category->id }}" @if(old('category_id') == $category->id) selected @endif> {{ $category->category }} ({{ $category->id }})</option>

                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">کلید مشخصات فنی</label>
                                        <div class="col-sm-9">
                                            <select class="form-control " id="tec_code" name="tec_code" data-placeholder="انتخاب کنید...">
                                                <option value="">انتخاب کنید...</option>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">مقدار مشخصات فنی</label>
                                        <div class="col-sm-9">
                                            <select class="form-control " id="tec_id" name="tec_id" data-placeholder="انتخاب کنید...">
                                                <option value="">انتخاب کنید...</option>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">ترتیب</label>
                                        <div class="col-sm-9" >
                                            <input type="text" class="form-control" name="priority" placeholder="ترتیب" value="{{old('priority')}}" required>
                                        </div>
                                    </div>
                                    <div class="modal-footer" style="text-align: center;">
                                        <button type="submit" class="btn btn-primary" style="width: 50%;">ثبت</button>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane" id="tab44">
                                <form class="form-horizontal" id="uploadForm" action="{{route('store.subTitle')}}" role="form" method="POST" >
                                    <br>
                                    {{csrf_field()}}
                                    <input name="title_type" value="4" hidden>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">نام زیر عنوان</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="sub_title" value="{{old('sub_title')}}" placeholder="نام زیر عنوان مورد نظر خود را وارد کنید" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">عنوان مربوطه</label>
                                        <div class="col-sm-9">
                                            <select class="form-control select2me" name="title_id" data-placeholder="انتخاب کنید..." required>
                                                <option value="">انتخاب کنید...</option>
                                                @foreach($form_titles as $title)
                                                    <option value="{{$title->id }}" @if(old('title_id') == $title->id) selected @endif>  {{ $title->title }} ({{ $title->id }})</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">URL</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-link"></i>
                            </span>
                                            <input name="url" type="url" value="{{old('url')}}" class="form-control"  placeholder="آدرس URL مورد نظر را وارد کنید" required>
                                            </div>
                                            </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">ترتیب</label>
                                        <div class="col-sm-9" >
                                            <input type="text" class="form-control" name="priority" placeholder="ترتیب" value="{{old('priority')}}" required>
                                        </div>
                                    </div>
                                    <div class="modal-footer" style="text-align: center;">
                                        <button type="submit" class="btn btn-primary" style="width: 50%;">ثبت</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
@endsection
@section('script')
    <script src="/jq-confirm/jquery-confirm.min.js"></script>
    <script src="/CRM_Assets/assets/global/plugins/select2/js/select2.full.min.js" type="text/javascript"></script>

    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" ></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" ></script>
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" ></script>
@endsection
@section('footer')

    <script type="text/javascript">
        //---------------tecInfo selection-----------------//

        $(document).on('change', '#category_id_tec', function () {
            var cat_id = $(this).val();

            $.ajax({
                url     : "{{route('get.tec.keys')}}",
                type    :"get",
                cash    : false,
                data    :{ cat_id : cat_id},
                success: function(response) {
                    $("#tec_code").empty().append($("<option value=\"\">انتخاب کنید...</option>"));
                    $.each( response, function(key,value) {
                        $('#tec_code')
                            .append($("<option>"+ (key+1) +"- "+value.tec_info_key +" ("+ value.code +")</option>")
                                .attr({
                                    value:value.code
                                }));
                    });
                }
            });
        });
        $(document).on('change', '#tec_code', function () {
            var tec_code = $(this).val();
            $.ajax({
                url     : "{{route('get.tec.values')}}",
                type    :"get",
                cash    : false,
                data    :{ tec_code : tec_code},
                success: function(response) {
                    $("#tec_id").empty().append($("<option value=\"\">انتخاب کنید...</option>"));
                    $.each( response, function(key,value) {
                        $('#tec_id')
                            .append($("<option>"+ (key+1) +"- "+value.value +" ("+ value.tec_id +")</option>")
                                .attr({
                                    value:value.tec_id
                                }));
                    });
                }
            });
        });

        //---------------Delete1 -----------------//
        $(document).on('click', '#delete_all', function () {

            var selected = new Array();
            $("input:checkbox[name*=selected]:checked").each(function(){
                selected.push($(this).val());
            });
            if($.isEmptyObject(selected)){
                swal({
                    title: "توجه",
                    text: "لطفا یک عنوان برای حذف انتخاب کنید",
                    type: "info",
                    showConfirmButton: true,
                    confirmButtonText :'باشه'
                });
            }else{
                $.confirm({
                    title: 'حذف عنوان ها',
                    content: 'آیا مطمئن هستید؟',
                    buttons: {
                        somethingElse: {
                            text: 'تایید',
                            btnClass: 'btn-blue',
                            action: function () {

                                $.ajax({
                                    url     : "<?= url('/CRM/SiteFront/subMenuSetting/delete') ?>",
                                    type    :"POST",
                                    cash    : false,
                                    data    :{ data : selected,"_token": $('#token').val()},
                                    success: function(response2) {
                                        $('#myModal').modal('hide');
                                        swal({
                                            title: "حذف شد",
                                            text: "عنوان ها با موفقیت حذف شد",
                                            type: "success",
                                            timer: 1000,
                                            showConfirmButton: false
                                        });
                                        $("#content_tab1").html(response2);
                                    },
                                    error: function() {
                                        $('#myModal').modal('hide');
                                        swal({
                                            title: "ارتباط ضعیف",
                                            text: "یکبار صفحه را مجددا بارگذاری کنید",
                                            type: "error",
                                            showConfirmButton: true,
                                            confirmButtonText :'باشه'
                                        });
                                    }
                                });
                            }
                        },
                        somethingElse2: {
                            text: 'خیر',
                            btnClass: 'btn-red',
                            action: function () {
                                swal({
                                    title: "تایید نشد",
                                    type: "info",
                                    timer: 1000,
                                    showConfirmButton: false
                                });
                            }
                        }
                    }
                });
            }
        });

        //---------------Delete2 -----------------//
        $(document).on('click', '#delete_all_2', function () {

            var selected = new Array();
            $("input:checkbox[name*=selected2]:checked").each(function(){
                selected.push($(this).val());
            });
            if($.isEmptyObject(selected)){
                swal({
                    title: "توجه",
                    text: "لطفا یک زیر عنوان برای حذف انتخاب کنید",
                    type: "info",
                    showConfirmButton: true,
                    confirmButtonText :'باشه'
                });
            }else{
                $.confirm({
                    title: 'حذف زیر عنوان',
                    content: 'آیا مطمئن هستید؟',
                    buttons: {
                        somethingElse: {
                            text: 'تایید',
                            btnClass: 'btn-blue',
                            action: function () {
                                $.ajax({
                                    url     : "<?= url('/CRM/SiteFront/subMenuSetting/delete2') ?>",
                                    type    :"POST",
                                    cash    : false,
                                    data    :{ data : selected,"_token": $('#token').val(),subMenuId : "{{$dynamicSubMenu->id}}"},
                                    success: function(response2) {
                                        $('#myModal').modal('hide');
                                        swal({
                                            title: "حذف شد",
                                            text: "زیر عنوان با موفقیت حذف شد",
                                            type: "success",
                                            timer: 1000,
                                            showConfirmButton: false
                                        });
                                        $("#content_tab2").html(response2);
                                    },
                                    error: function() {
                                        $('#myModal').modal('hide');
                                        swal({
                                            title: "ارتباط ضعیف",
                                            text: "یکبار صفحه را مجددا بارگذاری کنید",
                                            type: "error",
                                            showConfirmButton: true,
                                            confirmButtonText :'باشه'
                                        });
                                    }
                                });
                            }
                        },
                        somethingElse2: {
                            text: 'خیر',
                            btnClass: 'btn-red',
                            action: function () {
                                swal({
                                    title: "تایید نشد",
                                    type: "info",
                                    timer: 1000,
                                    showConfirmButton: false
                                });
                            }
                        }
                    }
                });
            }
        });

    </script>


@endsection