@extends('/CRM/layout')

@section('script')
    <script src="/CRM_Assets/assets/fontawesome-iconpicker/js/fontawesome-iconpicker.min.js"></script>
@endsection
@section('head')
    <link rel="stylesheet" href="/CRM_Assets/assets/fontawesome-iconpicker/css/fontawesome-iconpicker.min.css">
    <link rel="stylesheet" href="/CRM_Assets/assets/font-awesome-4.7.0/css/font-awesome.min.css">
@endsection
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase">شبکه های اجتماعی</span>
                </div>
            </div>
            <div class="portlet-body form">


                <form class="form-horizontal" method="POST" action="{{route('socials.store')}}"
                      enctype='multipart/form-data' role="form">
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="name" type="text" value="{{old('name')}}"
                                       class="form-control" required placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">Url</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                    <input name="url" type="url" value="{{old('url')}}"
                                           class="form-control" required
                                           placeholder="Url Address">
                                </div>
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">ایکون</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                    <input name="icon" id="e1_element" class="form-control icp icp-auto" value="کلیک کن" type="text"/>
                                </div>
                            </div>
                        </div>


                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ثبت</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->
        <div class="col-md-12">
            <div class="panel panel-default">

                <div class="panel-heading">
                    <h3 class="panel-title FarsiFont "><i class="fa fa-list"></i>&nbsp;لیست لینکهال</h3>
                </div>

                <div class="panel-body">
                    <div class="table">
                        <table class="table table-striped table-bordered table-hover order-column dataTable no-footer"
                               id="sample_1" role="grid" aria-describedby="sample_1_info">
                            <thead>
                            <tr role="row">
                                <th class="sorting_disable text-center" style="width: 10px;" aria-label=""><i
                                            class="fa fa-gears"></i></th>
                                <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                    colspan="1" aria-label=""> زمان ایجاد
                                </th>

                                <th class="sorting_disable text-center" tabindex="0" aria-controls="sample_1"
                                    rowspan="1"
                                    colspan="1" aria-label="عنوان">عنوان
                                </th>

                                <th class="sorting_disable text-center" style="width: 60px" aria-sort="descending"
                                    tabindex="0"
                                    aria-controls="sample_1" rowspan="1" colspan="1">لینک
                                </th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach($socials as $social)
                                <tr role="row" class="">

                                    <td>
                                        <div class="btn-group">
                                            <button class="btn btn-xs btn-danger dropdown-toggle bold" type="button"
                                                    data-toggle="dropdown" aria-expanded="false">
                                                <i class="fa fa-gears"></i>
                                                <i class="fa fa-angle-down"></i>
                                            </button>
                                            <ul class="dropdown-menu" role="menu">
                                                <li>
                                                    <a href="{{route('socials.edit',$social->id)}}">
                                                        <i class="fa fa-file-text" style="color:#5E6EDD "></i> ویرایش
                                                    </a>
                                                </li>

                                                <li>
                                                    <form class="form-horizontal" method="POST"
                                                          action="{{route('socials.destroy',$social->id)}}" role="form">
                                                        {{method_field('DELETE')}}
                                                        {{csrf_field()}}
                                                        <button style="text-align: right;background: none;border: none"
                                                                type="submit" class="text-danger col-md-12 text-right">
                                                            <i class="fa fa-minus-circle" style="color:#ED6B75 "></i>
                                                            حذف
                                                        </button>
                                                    </form>
                                                </li>

                                            </ul>
                                        </div>
                                    </td>

                                    <td style="width: 200px"
                                        class="text-center">{{convert(jDate::forge($social->created_at)->format('datetime'))}}</td>
                                    <td style="width: 400px"
                                        class="text-center">{{$social->name}}</td>

                                    <td class="text-center">
                                        {{$social->url}}
                                    </td>


                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('footer')
    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif
    <script>
        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>


    <script>

        jQuery(document).ready(function ($) {

            $('#e1_element').iconpicker();

        });

    </script>
@endsection