@extends('/CRM/layout')

@section('script')
    <script src="/CRM_Assets/assets/fontawesome-iconpicker/js/fontawesome-iconpicker.min.js"></script>
@endsection
@section('head')
    <link rel="stylesheet" href="/CRM_Assets/assets/fontawesome-iconpicker/css/fontawesome-iconpicker.min.css">
    <link rel="stylesheet" href="/CRM_Assets/assets/font-awesome-4.7.0/css/font-awesome.min.css">

@endsection
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <!-- BEGIN SAMPLE FORM PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-image"></i>
                    <span class="caption-subject font-dark sbold uppercase"> شبکه های اجتماعی</span>
                </div>
            </div>
            <div class="portlet-body form">


                <form class="form-horizontal" method="POST" action="{{route('socials.update',$social->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{csrf_field()}}
                    {{method_field('PATCH')}}

                    <div class="form-body">
                        <div class="form-group ">
                            <label class="col-md-2 control-label">عنوان</label>
                            <div class="col-md-10">
                                <input name="name" type="text" value="{{$social->name}}"
                                       class="form-control" required placeholder="عنوان">
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">Url</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                    <input name="url" type="url" value="{{$social->url}}"
                                           class="form-control" required
                                           placeholder="Url Address">
                                </div>
                            </div>
                        </div>
                        <div class="form-group ">
                            <label class="col-md-2 control-label">ایکون</label>
                            <div class="col-md-10">
                                <div class="input-group">
                                    <input name="icon" id="e1_element" class="form-control icp icp-auto" value="{{$social->icon}}" type="text"/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- END SAMPLE FORM PORTLET-->

    </div>
@endsection
@section('footer')
    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif
    <script>
        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
    <script>

        jQuery(document).ready(function ($) {

            $('#e1_element').iconpicker();

        });

    </script>
@endsection