@extends('/CRM/layout')

@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->


    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="alert alert-warning" role="alert">
                اگر مقار نام را null قرار دهید متنی بر روی عکس نمایش داده نمیشود.
            </div>

            <div class="portlet-body form">
                @php($width=900)
                @php($heigt=400)
                <form class="form-horizontal" method="POST" action="{{route('slider-home.store')}}"
                      enctype='multipart/form-data' role="form">

                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">نوع اسلایدر</label>
                                    <div class="col-md-9">
                                        <select name="type" class="form-control">
                                            <option @if(old('type')==0) selected @endif value="0">راست چین</option>
                                            <option @if(old('type')==1) selected @endif value="1">وسط چین</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">نام اسلایدر</label>
                                    <div class="col-md-9">
                                        <input name="name" type="text" class="form-control" required  placeholder="نام"
                                               value="{{old('name')}}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">عنوان</label>
                                    <div class="col-md-9">
                                        <input name="title" type="text" class="form-control"
                                               value="{{old('title')}}"
                                               placeholder="عنوان">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">Url</label>
                                    <div class="col-md-10">
                                        <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                            <input name="url" type="url" class="form-control" required
                                                   value="{{old('url')}}"
                                                   placeholder="Url Address">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">ترتیب</label>
                                    <div class="col-md-9">
                                        <input name="order" type="number" min="1" class="form-control" required
                                               @if(old('order')) value="{{old('order')}}" @else value="1" @endif
                                               placeholder="1">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-1">
                                <div class="form-group">
                                    <div class="col-md-6">
                                        <div class="md-checkbox-inline">
                                            <div class="md-checkbox">
                                                <input type="checkbox" id="checkbox2_4" name="status" value="1"
                                                       @if(old('status') == 'ok') checked @endif
                                                       class="md-check">
                                                <label for="checkbox2_4">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> فعال </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">توضیح کوتاه</label>
                                    <div class="col-md-10">
                                        <input name="body" type="text" class="form-control"
                                               value="{{old('body')}}"
                                               placeholder="توضیح">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="bgColor">
                                <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                    <div id="target1" class="targetLayer">

                                    </div>
                                    <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                         class="icon-choose-image"/>

                                    <div class="icon-choose-image">
                                        <input name="image" title="انتخاب عکس" type="file"
                                               class="inputFile userImage"
                                               required
                                               onChange="showPreview(this,'#target1','{{$width}}px','{{$heigt}}px');"/>
                                    </div>
                                </div>
                                <label class="col-sm-4 control-label">سایز مناسب عکس {{$width}}x{{$heigt}} پیکسل</label>

                                <div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ثبت</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title FarsiFont"><i class="fa fa-list"></i>&nbsp;مدیریت اسلایدر</h3>
            </div>
            <div class="panel-body">
                <div class="table">
                    <table class="table table-striped table-bordered table-hover order-column dataTable no-footer"
                           id="sample_1" role="grid" aria-describedby="sample_1_info">
                        <thead>
                        <tr role="row">
                            <th class="sorting_disable text-center" style="width: 10px;" aria-label=""><i
                                        class="fa fa-gears"></i></th>
                            <th class="sorting_desc text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" style="width: 90px" aria-sort="descending"
                                aria-label=" Id : activate to sort column ascending"> نوع
                            </th>
                            <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=" StuffName : activate to sort column ascending"> نام
                            </th>
                            <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=" StuffEngName : activate to sort column ascending">عنوان
                            </th>
                            <th class="sorting text-center" style="width: 60px" aria-sort="descending" tabindex="0"
                                aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=" StuffEngName : activate to sort column ascending">وضعیت
                            </th>
                            <th class="sorting text-center" style="width: 60px" aria-sort="descending" tabindex="0"
                                aria-controls="sample_1" rowspan="1" colspan="1">ترتیب
                            </th>
                            <th class="sorting text-center" tabindex="0" aria-controls="sample_1" rowspan="1"
                                colspan="1" aria-label=" StuffEngName : activate to sort column ascending"> عکس
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($sliders as $slider)
                            <tr role="row" class="success">

                                <td>
                                    <div class="btn-group">
                                        <button class="btn btn-xs btn-danger dropdown-toggle bold" type="button"
                                                data-toggle="dropdown" aria-expanded="false">
                                            <i class="fa fa-gears"></i>
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li>
                                                <a href="{{route('slider-home.edit',$slider->id)}}">
                                                    <i class="fa fa-file-text" style="color:#5E6EDD "></i> ویرایش </a>
                                            </li>
                                            @if($slider->status==0)
                                                <li>
                                                    <a href="{{route('slider-home-status',$slider->id)}}" >
                                                        <i class="fa fa-toggle-on" style="color:#2ecc71 " ></i> فعال کن </a>
                                                </li>
                                                @else
                                                <li>
                                                    <a href="{{route('slider-home-status',$slider->id)}}" >
                                                        <i class="fa fa-toggle-on" style="color:red " ></i> غیر فعال کن </a>
                                                </li>
                                            @endif
                                            <li>
                                                <a href="{{route('slider-home-delete',$slider->id)}}" class="bold" style="color: #ed6b75">
                                                    <i class="fa fa-minus-circle" style="color:#ED6B75 "></i> حذف </a>
                                            </li>

                                        </ul>
                                    </div>
                                </td>
                                <td style="text-decoration: none;font-weight: bold;"
                                    class="text-center">@if($slider->type==0)راست چین @else وسط چین @endif </td>
                                <td class="text-center">
                                    {{$slider->name}}
                                </td>
                                <td class="text-center">
                                    {{$slider->title}}
                                </td>
                                <td class="text-center">
                                    @if($slider->status == 1)
                                        <span class="label label-sm label-success">  فعال </span>
                                    @else
                                        <span class="label label-sm label-danger"> غیر فعال </span>
                                    @endif

                                </td>
                                <td class="text-center">{{$slider->order}}</td>
                                <td class="text-center">
                                    <img style="max-width: 105px" alt="{{$slider->name}}"
                                         src="{{url($slider->image_path)}}">
                                </td>


                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>




@endsection
@section('head')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection
