@extends('/CRM/layout')

@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->


    <script>
        $(document).ready(function () {
            $('#permission_id').selectpicker();
        })
    </script>
@endsection
@php
    $newestItems = new \App\Models\NewestItem();
@endphp
@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="portlet-body form">
                @php($width=900)
                @php($heigt=400)
                <form class="form-horizontal" method="POST" action="{{route('slider-home.update',$slide->id)}}"
                      enctype='multipart/form-data' role="form">
                    {{method_field('PUT')}}
                    {{csrf_field()}}

                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">نوع اسلایدر</label>
                                    <div class="col-md-9">
                                        <select name="type" class="form-control">
                                            <option @if($slide->type ==0) selected @endif value="0">راست چین</option>
                                            <option @if($slide->type ==1) selected @endif value="1">وسط چین</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">نام اسلایدر</label>
                                    <div class="col-md-9">
                                        <input name="name" type="text" class="form-control" required placeholder="نام"
                                               value="{{$slide->name}}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">عنوان</label>
                                    <div class="col-md-9">
                                        <input name="title" type="text" class="form-control" required
                                               value="{{$slide->title}}"
                                               placeholder="عنوان">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">Url</label>
                                    <div class="col-md-10">
                                        <div class="input-group">
                                                            <span class="input-group-addon">
                                                                <i class="fa fa-link"></i>
                                                            </span>
                                            <input name="url" type="url" class="form-control" required
                                                   value="{{$slide->url}}"
                                                   placeholder="Url Address">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">ترتیب</label>
                                    <div class="col-md-9">
                                        <input name="order" type="number" min="1" class="form-control" required
                                               value="{{$slide->order}}"
                                               placeholder="1">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <div class="col-md-6">
                                        <div class="md-checkbox-inline">
                                            <div class="md-checkbox">
                                                <input type="checkbox" id="checkbox2_4" name="status" value="1"
                                                       @if($slide->status == 1) checked @endif
                                                       class="md-check">
                                                <label for="checkbox2_4">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> فعال </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">توضیح کوتاه</label>
                                    <div class="col-md-10">
                                        <input name="body" type="text" class="form-control" required
                                               value="{{$slide->body}}"
                                               placeholder="توضیح">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="bgColor">
                                <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                    <div id="target1" class="targetLayer">
                                        <div id="target1" class="targetLayer">
                                            @isset($slide)
                                                <img src="{{$slide->image_path}}" width="{{$width}}px"
                                                     height="{{$heigt}}px" class="upload-preview"/>
                                            @endisset
                                        </div>
                                    </div>
                                    <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                         class="icon-choose-image"/>

                                    <div class="icon-choose-image">
                                        <input name="image" title="انتخاب عکس" type="file"
                                               class="inputFile userImage"
                                               onChange="showPreview(this,'#target1','{{$width}}px','{{$heigt}}px');"/>
                                    </div>
                                </div>
                                <label class="col-sm-4 control-label">سایز مناسب عکس {{$width}}x{{$heigt}} پیکسل</label>

                                <div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


@endsection
@section('head')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection
