@extends('/CRM/layout')

@section('script')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <script src="/CRM_Assets/assets/global/scripts/datatable.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
    <script src="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"
            type="text/javascript"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="/CRM_Assets/assets/pages/scripts/table-datatables-managed.min.js" type="text/javascript"></script>
    <!-- END PAGE LEVEL SCRIPTS -->
    <!-- bootstrap-tagsinput -->
    <script src="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js"
            type="text/javascript"></script>
    <!-- bootstrap-tagsinput -->

    <script>

        var options = {
            filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
            filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
            filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
            filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
        };
        CKEDITOR.replace('body', options);

    </script>

@endsection

@section('content')
    <div class="portlet light bordered main">
        @include('CRM.Admin.section.errors')
    </div>
    <div class="col-md-12 ">
        <div class="portlet light bordered">
            <div class="portlet-body form">
                <form class="form-horizontal" method="POST" action="{{route('setting_main.update',1)}}"
                      enctype='multipart/form-data' role="form">
                    {{method_field('PATCH')}}
                    {{csrf_field()}}


                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">نام</label>
                                    <div class="col-md-10">
                                        <input name="name" type="text" class="form-control" required
                                               value="@isset($mainSetting) {{$mainSetting->name}} @endisset"
                                               placeholder="نام">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">عنوان</label>
                                    <div class="col-md-10">
                                        <input name="title" type="text" class="form-control" required
                                               value="@isset($mainSetting) {{$mainSetting->title}} @endisset"
                                               placeholder="عنوان">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="col-md-2 control-label">توضیح کوتاه</label>
                                    <div class="col-md-10">
                                        <input name="description" type="text" class="form-control" required
                                               value="@isset($mainSetting){{$mainSetting->description}}@endisset"
                                               placeholder="توضیح کوتاه">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-12">

                                <div class="form-group">
                                    <label class="control-label col-md-3">کلمات کلیدی</label>
                                    <div class="col-md-9">
                                        <input type="text" name="keywords" class="form-control input-large"
                                               value="@isset($mainSetting){{$mainSetting->keywords}}@endisset"
                                               data-role="tagsinput" required >
                                    </div>
                                </div>


                            </div>
                            <div class="col-md-6">
                                @php($width=227)
                                @php($heigt=51)
                                @php($id='logo')
                                <input type="hidden" name="logo_width" value="{{$width}}">
                                <input type="hidden" name="logo_heigt" value="{{$heigt}}">

                                <div class="form-group">
                                    <div class="bgColor"> لوگو
                                        <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                            <div id="{{$id}}" class="targetLayer">
                                                @isset($mainSetting)
                                                    <img src="{{$mainSetting->logo}}" width="{{$width}}px"
                                                         height="{{$heigt}}px" class="upload-preview"/>
                                                @endisset
                                            </div>
                                            <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                                 class="icon-choose-image"/>

                                            <div class="icon-choose-image">
                                                <input name="logo" title="انتخاب عکس" type="file"
                                                       class="inputFile userImage"
                                                       onChange="showPreview(this,'#{{$id}}','{{$width}}px','{{$heigt}}px');"/>
                                            </div>
                                        </div>
                                        <label class="col-sm-4 control-label">سایز مناسب عکس {{$width}}x{{$heigt}}
                                            پیکسل</label>

                                        <div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="col-md-6">
                                @php($width=114)
                                @php($heigt=114)
                                @php($id='fave')

                                <input type="hidden" name="fave_width" value="{{$width}}">
                                <input type="hidden" name="fave_heigt" value="{{$heigt}}">


                                <div class="form-group">
                                    <div class="bgColor"> Fave icon
                                        <div style="width: {{$width}}px;height: {{$heigt}}px" class="targetOuter">
                                            <div id="{{$id}}" class="targetLayer">
                                                @isset($mainSetting)
                                                    <img src="{{$mainSetting->fave_logo}}" width="{{$width}}px"
                                                         height="{{$heigt}}px" class="upload-preview"/>
                                                @endisset
                                            </div>
                                            <img src="{{asset('CRM_Assets/assets/pages/img/easy.png')}}"
                                                 class="icon-choose-image"/>

                                            <div class="icon-choose-image">
                                                <input name="fave_logo" title="انتخاب عکس" type="file"
                                                       class="inputFile userImage"
                                                       onChange="showPreview(this,'#{{$id}}','{{$width}}px','{{$heigt}}px');"/>
                                            </div>
                                        </div>
                                        <label class="col-sm-4 control-label">سایز مناسب عکس {{$width}}x{{$heigt}}
                                            پیکسل</label>

                                        <div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>


                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green">ویرایش</button>
                        <a class="btn red" href="{{route('setting_main.index')}}">انصراف</a>
                    </div>
                </form>
            </div>
        </div>
    </div>



@endsection
@section('footer')
    <!-- BEGIN PAGE LEVEL PLUGINS -->
    <link href="/CRM_Assets/assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css"
          rel="stylesheet" type="text/css"/>
    <link href="/CRM_Assets/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css"
          rel="stylesheet" type="text/css"/>

    <!-- END PAGE LEVEL PLUGINS -->

    @if (alert()->ready())
        <script>
            $(document).ready(function () {
                swal({
                    title: "{!! alert()->message() !!}",
                    text: "{!! alert()->option('text') !!}",
                    type: "{!! alert()->type() !!}",
                    @if(alert()->option('timer'))
                    timer: "{!! alert()->option('timer') !!}",
                    showConfirmButton: false,
                    @endif
                });
            })
        </script>
    @endif

    <script>

        function showPreview(objFileInput, id, w, h) {
            if (objFileInput.files[0]) {
                var fileReader = new FileReader();
                fileReader.onload = function (e) {
                    $('#blah').attr('src', e.target.result);
                    $(id).html('<img src="' + e.target.result + '" width=" ' + w + ' "; height="' + h + '" class="upload-preview" />');
                    $(".targetLayer").css('opacity', '0.7');
                    $(".icon-choose-image").css('opacity', '0.5');
                };
                fileReader.readAsDataURL(objFileInput.files[0]);
            }
        }
    </script>
@endsection
